/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import jakarta.servlet.AsyncEvent;
import jakarta.servlet.AsyncListener;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmsAsyncListener
implements AsyncListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(UmsAsyncListener.class);
    private static final int ADVISE_MS_TRIGGER = 1000;
    private final long startTime;
    private final int counter;
    private long bytesSent = 0L;
    private long nextBytesAdvise = System.currentTimeMillis() + 1000L;

    public UmsAsyncListener(long startTime, int counter) {
        this.startTime = startTime;
        this.counter = counter;
    }

    @Override
    public void onTimeout(AsyncEvent asyncEvent) throws IOException {
        this.log(asyncEvent, "Timed out", true);
    }

    @Override
    public void onStartAsync(AsyncEvent asyncEvent) throws IOException {
        this.log(asyncEvent, "Start", false);
    }

    @Override
    public void onError(AsyncEvent asyncEvent) throws IOException {
        this.log(asyncEvent, "Error", true);
    }

    @Override
    public void onComplete(AsyncEvent asyncEvent) throws IOException {
        this.log(asyncEvent, "Complete", true);
    }

    public void onPrematureEnd(String state) {
        this.log(null, String.format("Premature end: %s", state), true);
    }

    public void log(AsyncEvent asyncEvent, String state, boolean extended) {
        ServletRequest servletRequest;
        Object data = String.format("Stream Async %s", state);
        if (this.counter > 0) {
            data = (String)data + String.format(", id: %d", this.counter);
        }
        if (asyncEvent != null && (servletRequest = asyncEvent.getSuppliedRequest()) instanceof HttpServletRequest) {
            HttpServletRequest request = (HttpServletRequest)servletRequest;
            data = (String)data + String.format(", uri: %s", request.getRequestURI());
            request.getRequestURI();
        }
        if (extended) {
            long duration = System.currentTimeMillis() - this.startTime;
            data = (String)data + String.format(", duration: %d ms", duration);
            if (this.bytesSent > 0L) {
                data = (String)data + String.format(", sent: %d bytes", this.bytesSent);
            }
        }
        LOGGER.trace((String)data);
    }

    public void setBytesSent(long bytesSent) {
        this.bytesSent = bytesSent;
        if (LOGGER.isTraceEnabled() && System.currentTimeMillis() > this.nextBytesAdvise) {
            this.nextBytesAdvise = System.currentTimeMillis() + 1000L;
            LOGGER.trace("Stream Async progress: {} bytes sent", (Object)bytesSent);
        }
    }
}

