/*
 * Decompiled with CFR 0.152.
 */
package net.pms.network;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.Authenticator;
import java.net.CookieHandler;
import java.net.CookieManager;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import net.pms.PMS;
import net.pms.network.HTTPResourceAuthenticator;
import net.pms.util.PropertiesUtil;
import net.pms.util.StringUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class HTTPResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(HTTPResource.class);
    public static final String UNKNOWN_VIDEO_TYPEMIME = "video/mpeg";
    public static final String UNKNOWN_IMAGE_TYPEMIME = "image/jpeg";
    public static final String UNKNOWN_AUDIO_TYPEMIME = "audio/mpeg";
    public static final String AUDIO_TRANSCODE = "audio/transcode";
    public static final String VIDEO_TRANSCODE = "video/transcode";
    public static final String AUDIO_AAC_TYPEMIME = "audio/aac";
    public static final String AUDIO_AC3_TYPEMIME = "audio/vnd.dolby.dd-raw";
    public static final String AUDIO_ADPCM_TYPEMIME = "audio/x-adpcm";
    public static final String AUDIO_ADTS_TYPEMIME = "audio/vnd.dlna.adts";
    public static final String AUDIO_AIFF_TYPEMIME = "audio/aiff";
    public static final String AUDIO_APE_TYPEMIME = "audio/x-ape";
    public static final String AUDIO_ATRAC_TYPEMIME = "audio/x-sony-oma";
    public static final String AUDIO_AU_TYPEMIME = "audio/basic";
    public static final String AUDIO_DSF_TYPEMIME = "audio/x-dsf";
    public static final String AUDIO_DFF_TYPEMIME = "audio/x-dff";
    public static final String AUDIO_DTS_TYPEMIME = "audio/vnd.dts";
    public static final String AUDIO_DTSHD_TYPEMIME = "audio/vnd.dts.hd";
    public static final String AUDIO_EAC3_TYPEMIME = "audio/eac3";
    public static final String AUDIO_FLAC_TYPEMIME = "audio/x-flac";
    public static final String AUDIO_LPCM_TYPEMIME = "audio/L16";
    public static final String AUDIO_M4A_TYPEMIME = "audio/mp4";
    public static final String AUDIO_MKA_TYPEMIME = "audio/x-matroska";
    public static final String AUDIO_MLP_TYPEMIME = "audio/vnd.dolby.mlp";
    public static final String AUDIO_MP3_TYPEMIME = "audio/mpeg";
    public static final String AUDIO_MP2_TYPEMIME = "audio/mpeg";
    public static final String AUDIO_MPA_TYPEMIME = "audio/mpeg";
    public static final String AUDIO_MPC_TYPEMIME = "audio/x-musepack";
    public static final String AUDIO_OGA_TYPEMIME = "audio/ogg";
    public static final String AUDIO_RA_TYPEMIME = "audio/vnd.rn-realaudio";
    public static final String AUDIO_SHN_TYPEMIME = "audio/x-shn";
    public static final String AUDIO_THREEGPPA_TYPEMIME = "audio/3gpp";
    public static final String AUDIO_THREEGPP2A_TYPEMIME = "audio/3gpp2";
    public static final String AUDIO_TRUEHD_TYPEMIME = "audio/vnd.dolby.mlp";
    public static final String AUDIO_TTA_TYPEMIME = "audio/x-tta";
    public static final String AUDIO_VORBIS_TYPEMIME = "audio/ogg";
    public static final String AUDIO_WAV_TYPEMIME = "audio/wav";
    public static final String AUDIO_WEBM_TYPEMIME = "audio/webm";
    public static final String AUDIO_WMA_TYPEMIME = "audio/x-ms-wma";
    public static final String AUDIO_WV_TYPEMIME = "audio/x-wavpack";
    public static final String ASF_TYPEMIME = "video/x-ms-asf";
    public static final String AVI_TYPEMIME = "video/avi";
    public static final String BMP_TYPEMIME = "image/bmp";
    public static final String DIVX_TYPEMIME = "video/x-divx";
    public static final String FLV_TYPEMIME = "video/x-flv";
    public static final String GIF_TYPEMIME = "image/gif";
    public static final String HLS_TYPEMIME = "application/x-mpegURL";
    public static final String HLS_APPLE_TYPEMIME = "application/vnd.apple.mpegURL";
    public static final String JPEG_TYPEMIME = "image/jpeg";
    public static final String JSON_TYPEMIME = "application/json";
    public static final String M4V_TYPEMIME = "video/x-m4v";
    public static final String MATROSKA_TYPEMIME = "video/x-matroska";
    public static final String MOV_TYPEMIME = "video/quicktime";
    public static final String MP4_TYPEMIME = "video/mp4";
    public static final String MPEG_TYPEMIME = "video/mpeg";
    public static final String MPEGTS_TYPEMIME = "video/vnd.dlna.mpeg-tts";
    public static final String MPEGTS_BYTESTREAM_TYPEMIME = "video/MP2T";
    public static final String PNG_TYPEMIME = "image/png";
    public static final String RM_TYPEMIME = "application/vnd.rn-realmedia";
    public static final String THREEGPP_TYPEMIME = "video/3gpp";
    public static final String THREEGPP2_TYPEMIME = "video/3gpp2";
    public static final String TIFF_TYPEMIME = "image/tiff";
    public static final String WMV_TYPEMIME = "video/x-ms-wmv";
    public static final String OGG_TYPEMIME = "video/ogg";
    public static final String WEBM_TYPEMIME = "video/webm";
    public static final String WEBP_TYPEMIME = "image/webp";
    public static final String WEBVTT_TYPEMIME = "text/vtt";

    protected HTTPResource() {
    }

    public static InputStream getResourceInputStream(String fileName) {
        fileName = "/resources/" + (String)fileName;
        fileName = ((String)fileName).replace("//", "/");
        ClassLoader cll = HTTPResource.class.getClassLoader();
        InputStream is = cll.getResourceAsStream(((String)fileName).substring(1));
        while (is == null && cll.getParent() != null) {
            cll = cll.getParent();
            is = cll.getResourceAsStream(((String)fileName).substring(1));
        }
        return is;
    }

    public static String getDefaultMimeType(int type) {
        return switch (type) {
            case 4 -> "video/mpeg";
            case 2 -> "image/jpeg";
            case 1 -> "audio/mpeg";
            default -> "video/mpeg";
        };
    }

    public static InputStream downloadAndSend(String u, boolean saveOnDisk) throws IOException {
        if (u == null) {
            return null;
        }
        URL url = URI.create(u).toURL();
        File f = null;
        if (saveOnDisk) {
            String host = url.getHost();
            String hostName = StringUtil.convertURLToFileName(host);
            String fileName = url.getFile();
            fileName = StringUtil.convertURLToFileName(fileName);
            File hostDir = new File(PMS.getConfiguration().getTempFolder(), hostName);
            if (!hostDir.isDirectory() && !hostDir.mkdir()) {
                LOGGER.debug("Cannot create directory: {}", (Object)hostDir.getAbsolutePath());
            }
            if ((f = new File(hostDir, fileName)).exists()) {
                return new FileInputStream(f);
            }
        }
        byte[] content = HTTPResource.downloadAndSendBinary(u, saveOnDisk, f);
        return new ByteArrayInputStream(content);
    }

    public static byte[] downloadAndSendBinary(String u) throws IOException {
        return HTTPResource.downloadAndSendBinary(u, false, null);
    }

    protected static byte[] downloadAndSendBinary(String u, boolean saveOnDisk, File f) throws IOException {
        ByteArrayOutputStream bytes;
        block16: {
            if (u == null) {
                return new byte[0];
            }
            URL url = URI.create(u).toURL();
            Authenticator.setDefault(new HTTPResourceAuthenticator());
            HTTPResourceAuthenticator.addURL(url);
            LOGGER.debug("Retrieving " + url.toString());
            bytes = new ByteArrayOutputStream();
            URLConnection conn = url.openConnection();
            conn.setRequestProperty("User-agent", PropertiesUtil.getProjectProperties().get("project.name") + " " + PMS.getVersion());
            CookieManager cookieManager = (CookieManager)CookieHandler.getDefault();
            if (cookieManager != null && cookieManager.getCookieStore() != null && cookieManager.getCookieStore().getCookies() != null && !cookieManager.getCookieStore().getCookies().isEmpty()) {
                conn.setRequestProperty("Cookie", StringUtils.join(cookieManager.getCookieStore().getCookies(), ";"));
            }
            try (InputStream in = conn.getInputStream();){
                int n;
                byte[] buf = new byte[4096];
                if (saveOnDisk && f != null) {
                    try (FileOutputStream fOUT = new FileOutputStream(f);){
                        int n2;
                        while ((n2 = in.read(buf)) > -1) {
                            bytes.write(buf, 0, n2);
                            fOUT.write(buf, 0, n2);
                        }
                        break block16;
                    }
                }
                while ((n = in.read(buf)) > -1) {
                    bytes.write(buf, 0, n);
                }
            }
        }
        return bytes.toByteArray();
    }
}

