/*
 * Decompiled with CFR 0.152.
 */
package net.pms.logging;

import ch.qos.logback.classic.Level;
import ch.qos.logback.classic.LoggerContext;
import ch.qos.logback.classic.encoder.PatternLayoutEncoder;
import ch.qos.logback.classic.filter.ThresholdFilter;
import ch.qos.logback.classic.joran.JoranConfigurator;
import ch.qos.logback.classic.net.SyslogAppender;
import ch.qos.logback.classic.spi.ILoggingEvent;
import ch.qos.logback.core.Appender;
import ch.qos.logback.core.ConsoleAppender;
import ch.qos.logback.core.FileAppender;
import ch.qos.logback.core.OutputStreamAppender;
import ch.qos.logback.core.encoder.Encoder;
import ch.qos.logback.core.filter.Filter;
import ch.qos.logback.core.joran.spi.JoranException;
import ch.qos.logback.core.util.StatusPrinter2;
import java.io.File;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.logging.CacheLogger;
import net.pms.logging.GuiManagerAppender;
import net.pms.util.Iterators;
import net.pms.util.PropertiesUtil;
import org.slf4j.ILoggerFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoggingConfig {
    private static final Logger LOGGER = LoggerFactory.getLogger(LoggingConfig.class);
    private static final Object FILE_PATH_LOCK = new Object();
    private static final Object LOG_FILE_PATHS_LOCK = new Object();
    private static final HashMap<String, String> LOG_FILE_PATHS = new HashMap();
    private static final LinkedList<Appender<ILoggingEvent>> SYSLOG_DETACHED_APPENDERS = new LinkedList();
    private static String filepath = null;
    private static LoggerContext loggerContext = null;
    private static ch.qos.logback.classic.Logger rootLogger;
    private static SyslogAppender syslog;
    private static boolean syslogDisabled;
    private static Level consoleLevel;
    private static Level tracesLevel;
    private static final StatusPrinter2 STATUS_PRINTER;

    private LoggingConfig() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getConfigFilePath() {
        Object object = FILE_PATH_LOCK;
        synchronized (object) {
            if (filepath != null) {
                return filepath;
            }
            return "internal defaults";
        }
    }

    private static File getFile(String[] fileList) {
        for (String fileName : fileList) {
            File file;
            if ((fileName = fileName.trim()).length() <= 0) continue;
            if (fileName.matches("\\[PROFILE_DIR\\].*")) {
                PMS.getConfiguration();
                String s = UmsConfiguration.getProfileDirectory().replace("\\", "/");
                fileName = fileName.replaceAll("\\[PROFILE_DIR\\]", s);
            }
            if (!(file = new File(fileName.trim())).exists() || !file.canRead()) continue;
            return file;
        }
        return null;
    }

    private static boolean setContextAndRoot() {
        ILoggerFactory ilf = LoggerFactory.getILoggerFactory();
        if (!(ilf instanceof LoggerContext)) {
            LOGGER.debug("Not using LogBack, aborting LogBack configuration");
            return false;
        }
        loggerContext = (LoggerContext)ilf;
        rootLogger = loggerContext.getLogger("ROOT");
        if (rootLogger == null) {
            LOGGER.error("Couldn't find root logger, aborting LogBack configuration");
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void loadFile() {
        File file = null;
        if (!LoggingConfig.setContextAndRoot()) {
            return;
        }
        if (PMS.isHeadless()) {
            file = LoggingConfig.getFile(PropertiesUtil.getProjectProperties().get("project.logback.headless").split(","));
        }
        if (file == null) {
            file = LoggingConfig.getFile(PropertiesUtil.getProjectProperties().get("project.logback").split(","));
        }
        if (file == null) {
            LOGGER.warn("Could not load LogBack configuration file from " + (String)(PMS.isHeadless() ? PropertiesUtil.getProjectProperties().get("project.logback.headless") + ", " : "") + PropertiesUtil.getProjectProperties().get("project.logback"));
            LOGGER.warn("Falling back to somewhat unpredictable defaults, probably only logging to console.");
            return;
        }
        JoranConfigurator configurator = new JoranConfigurator();
        configurator.setContext(loggerContext);
        try {
            loggerContext.reset();
            loggerContext.getStatusManager().clear();
            configurator.doConfigure(file);
            if (CacheLogger.isActive()) {
                CacheLogger.initContext();
            }
            Object object = FILE_PATH_LOCK;
            synchronized (object) {
                filepath = file.getAbsolutePath();
                LOGGER.debug("LogBack started with configuration file: {}", (Object)filepath);
            }
        }
        catch (JoranException je) {
            try {
                System.err.println("LogBack configuration failed: " + je.getLocalizedMessage());
                System.err.println("Trying to create \"emergency\" configuration");
                if (PMS.isHeadless()) {
                    ConsoleAppender<ILoggingEvent> ca = new ConsoleAppender<ILoggingEvent>();
                    PatternLayoutEncoder pe = new PatternLayoutEncoder();
                    pe.setPattern("%-5level %d{HH:mm:ss.SSS} [%thread] %logger %msg%n");
                    pe.setContext(loggerContext);
                    pe.start();
                    ca.setEncoder(pe);
                    ca.setContext(loggerContext);
                    ca.setName("Emergency Console");
                    ca.start();
                    loggerContext.getLogger("ROOT").addAppender((Appender<ILoggingEvent>)ca);
                } else {
                    GuiManagerAppender<ILoggingEvent> ga = new GuiManagerAppender<ILoggingEvent>();
                    PatternLayoutEncoder pe = new PatternLayoutEncoder();
                    pe.setPattern("%-5level %d{HH:mm:ss.SSS} [%thread] %logger %msg%n");
                    pe.setContext(loggerContext);
                    pe.start();
                    ga.setEncoder(pe);
                    ga.setContext(loggerContext);
                    ga.setName("Emergency Frame");
                    ga.start();
                    loggerContext.getLogger("ROOT").addAppender((Appender<ILoggingEvent>)ga);
                }
                System.err.println("LogBack \"emergency\" configuration applied.");
            }
            catch (Exception e) {
                System.err.println("LogBack \"emergency\" configuration failed with: " + e);
            }
            if (CacheLogger.isActive()) {
                CacheLogger.initContext();
            }
            LOGGER.error("Logback configuration failed with: {}", (Object)je.getLocalizedMessage());
            STATUS_PRINTER.printInCaseOfErrorsOrWarnings(loggerContext);
            return;
        }
        Iterators<Appender<ILoggingEvent>> iterators = new Iterators<Appender<ILoggingEvent>>();
        if (CacheLogger.isActive()) {
            iterators.addIterator(CacheLogger.iteratorForAppenders());
        }
        for (ch.qos.logback.classic.Logger logger : loggerContext.getLoggerList()) {
            iterators.addIterator(logger.iteratorForAppenders());
        }
        Iterator it = iterators.combinedIterator();
        Object object = LOG_FILE_PATHS_LOCK;
        synchronized (object) {
            while (it.hasNext()) {
                Appender appender = (Appender)it.next();
                if (appender instanceof FileAppender) {
                    FileAppender fa = (FileAppender)appender;
                    LOG_FILE_PATHS.put(fa.getName(), fa.getFile());
                    continue;
                }
                if (!(appender instanceof SyslogAppender)) continue;
                syslogDisabled = true;
            }
        }
        LoggingConfig.setConfigurableFilters(true, true);
        STATUS_PRINTER.printInCaseOfErrorsOrWarnings(loggerContext);
    }

    private static synchronized void setConfigurableFilters(boolean setConsole, boolean setTraces) {
        Level level;
        UmsConfiguration configuration = PMS.getConfiguration();
        if (loggerContext == null) {
            LOGGER.error("Unknown loggerContext, aborting buffered logging. Make sure that loadFile() has been called first.");
            return;
        }
        if (setConsole) {
            level = configuration.getLoggingFilterConsole();
            if (consoleLevel == null || consoleLevel != level) {
                consoleLevel = level;
            } else {
                setConsole = false;
            }
        }
        if (setTraces) {
            level = configuration.getLoggingFilterLogsTab();
            if (tracesLevel == null || tracesLevel != level) {
                tracesLevel = level;
            } else {
                setTraces = false;
            }
        }
        if (setConsole || setTraces) {
            Iterator<Appender<ILoggingEvent>> it;
            Iterator<Appender<ILoggingEvent>> iterator = it = CacheLogger.isActive() ? CacheLogger.iteratorForAppenders() : rootLogger.iteratorForAppenders();
            while (it.hasNext()) {
                boolean createNew;
                Appender<ILoggingEvent> appender = it.next();
                if (setConsole && appender instanceof ConsoleAppender) {
                    ConsoleAppender ca = (ConsoleAppender)appender;
                    createNew = true;
                    if (!ca.getCopyOfAttachedFiltersList().isEmpty()) {
                        for (Filter filter : ca.getCopyOfAttachedFiltersList()) {
                            if (!(filter instanceof ThresholdFilter)) continue;
                            createNew = false;
                            ((ThresholdFilter)filter).setLevel(LoggingConfig.consoleLevel.levelStr);
                            ((ThresholdFilter)filter).start();
                        }
                    }
                    if (createNew) {
                        ThresholdFilter consoleFilter = new ThresholdFilter();
                        ca.addFilter(consoleFilter);
                        consoleFilter.setLevel(LoggingConfig.consoleLevel.levelStr);
                        consoleFilter.setContext(loggerContext);
                        consoleFilter.start();
                    }
                }
                if (!setTraces || !(appender instanceof GuiManagerAppender)) continue;
                GuiManagerAppender ga = (GuiManagerAppender)appender;
                createNew = true;
                if (!ga.getCopyOfAttachedFiltersList().isEmpty()) {
                    for (Filter filter : ga.getCopyOfAttachedFiltersList()) {
                        if (!(filter instanceof ThresholdFilter)) continue;
                        createNew = false;
                        ((ThresholdFilter)filter).setLevel(LoggingConfig.tracesLevel.levelStr);
                        ((ThresholdFilter)filter).start();
                    }
                }
                if (!createNew) continue;
                ThresholdFilter tracesFilter = new ThresholdFilter();
                ga.addFilter(tracesFilter);
                tracesFilter.setLevel(LoggingConfig.tracesLevel.levelStr);
                tracesFilter.setContext(loggerContext);
                tracesFilter.start();
            }
        }
    }

    public static void setConsoleFilter() {
        LoggingConfig.setConfigurableFilters(true, false);
    }

    public static void setTracesFilter() {
        LoggingConfig.setConfigurableFilters(false, true);
    }

    public static synchronized boolean isSyslogDisabled() {
        return syslogDisabled;
    }

    public static synchronized void setSyslog() {
        ActionType action = ActionType.NONE;
        UmsConfiguration configuration = PMS.getConfiguration();
        if (loggerContext == null) {
            LOGGER.error("Unknown loggerContext, aborting syslog configuration. Make sure that loadFile() has been called first.");
            return;
        }
        if (syslogDisabled) {
            LOGGER.warn("A syslog appender is already configured, aborting syslog configuration");
            return;
        }
        if (configuration.getLoggingUseSyslog()) {
            if (configuration.getLoggingSyslogHost().isEmpty()) {
                LOGGER.error("Empty syslog hostname, syslog configuration aborted");
                return;
            }
            try {
                InetAddress.getByName(configuration.getLoggingSyslogHost());
            }
            catch (UnknownHostException e) {
                LOGGER.error("Unknown syslog hostname {}, syslog configuration aborted", (Object)configuration.getLoggingSyslogHost());
                return;
            }
            if (configuration.getLoggingSyslogPort() < 1 && configuration.getLoggingSyslogPort() > 65535) {
                LOGGER.error("Invalid syslog port {}, using default", (Object)configuration.getLoggingSyslogPort());
                configuration.setLoggingSyslogPortDefault();
            }
            if (!configuration.getLoggingSyslogFacility().toLowerCase().matches("auth|authpriv|daemon|cron|ftp|lpr|kern|mail|news|syslog|user|uucp|local0|local1|local2|local3|local4|local5|local6|local7")) {
                LOGGER.error("Invalid syslog facility \"{}\", using default", (Object)configuration.getLoggingSyslogFacility());
                configuration.setLoggingSyslogFacilityDefault();
            }
        }
        if (configuration.getLoggingUseSyslog() && syslog == null) {
            syslog = new SyslogAppender();
            syslog.setContext(loggerContext);
            syslog.setSuffixPattern("UMS [%thread] %msg");
            syslog.setName("UMS syslog");
            syslog.setCharset(StandardCharsets.UTF_8);
            action = ActionType.START;
        } else if (!configuration.getLoggingUseSyslog() && syslog != null) {
            action = ActionType.STOP;
        }
        if (syslog != null && (action == ActionType.START || action == ActionType.NONE)) {
            syslog.setSyslogHost(configuration.getLoggingSyslogHost());
            syslog.setPort(configuration.getLoggingSyslogPort());
            syslog.setFacility(configuration.getLoggingSyslogFacility().toUpperCase());
            syslog.start();
        }
        if (action == ActionType.START || action == ActionType.STOP) {
            Iterator<Appender<ILoggingEvent>> it;
            Iterator<Appender<ILoggingEvent>> iterator = it = CacheLogger.isActive() ? CacheLogger.iteratorForAppenders() : rootLogger.iteratorForAppenders();
            while (it.hasNext()) {
                Appender<ILoggingEvent> appender = it.next();
                if (action == ActionType.START && appender instanceof FileAppender) {
                    if (CacheLogger.isActive()) {
                        CacheLogger.removeAppender(appender);
                    } else {
                        rootLogger.detachAppender(appender);
                    }
                    SYSLOG_DETACHED_APPENDERS.add(appender);
                    ((FileAppender)appender).setAppend(true);
                    continue;
                }
                if (action != ActionType.STOP || appender != syslog) continue;
                if (CacheLogger.isActive()) {
                    CacheLogger.removeAppender(syslog);
                } else {
                    rootLogger.detachAppender(syslog);
                }
                syslog.stop();
                syslog = null;
            }
            if (action == ActionType.START) {
                if (CacheLogger.isActive()) {
                    CacheLogger.addAppender(syslog);
                } else {
                    rootLogger.addAppender(syslog);
                }
                LOGGER.info("Syslog logging started, file logging disabled");
            } else {
                for (Appender<ILoggingEvent> appender : SYSLOG_DETACHED_APPENDERS) {
                    if (CacheLogger.isActive()) {
                        CacheLogger.addAppender(appender);
                        continue;
                    }
                    rootLogger.addAppender(appender);
                }
                SYSLOG_DETACHED_APPENDERS.clear();
                LOGGER.info("Syslog logging stopped, file logging enabled");
            }
        }
    }

    public static synchronized void setBuffered(boolean buffered) {
        if (loggerContext == null) {
            LOGGER.error("Unknown loggerContext, aborting buffered logging. Make sure that loadFile() has been called first.");
            return;
        }
        Iterators<Appender<ILoggingEvent>> iterators = new Iterators<Appender<ILoggingEvent>>();
        if (CacheLogger.isActive()) {
            iterators.addIterator(CacheLogger.iteratorForAppenders());
        } else {
            iterators.addIterator(rootLogger.iteratorForAppenders());
        }
        if (!SYSLOG_DETACHED_APPENDERS.isEmpty()) {
            iterators.addList(SYSLOG_DETACHED_APPENDERS);
        }
        Iterator it = iterators.combinedIterator();
        while (it.hasNext()) {
            Appender appender = (Appender)it.next();
            if (!(appender instanceof OutputStreamAppender) || appender instanceof ConsoleAppender) continue;
            ((OutputStreamAppender)appender).setImmediateFlush(!buffered);
        }
        LOGGER.info("Buffered logging turned {}", (Object)(buffered ? "ON" : "OFF"));
    }

    public static synchronized void setRootLevel(Level level) {
        if (loggerContext == null && !LoggingConfig.setContextAndRoot()) {
            LOGGER.error("Unknown loggerContext, aborting setRootLevel");
            return;
        }
        rootLogger.setLevel(level);
    }

    public static synchronized Level getRootLevel() {
        if (loggerContext == null && !LoggingConfig.setContextAndRoot()) {
            LOGGER.error("Unknown loggerContext, aborting getRootLevel.");
            return Level.OFF;
        }
        return rootLogger.getLevel();
    }

    public static synchronized void forceVerboseFileEncoder() {
        String timeStampFormat = "yyyy-MM-dd HH:mm:ss.SSS";
        if (loggerContext == null) {
            LOGGER.error("Unknown loggerContext, aborting buffered logging. Make sure that loadFile() has been called first.");
            return;
        }
        Iterators<Appender<ILoggingEvent>> iterators = new Iterators<Appender<ILoggingEvent>>();
        if (CacheLogger.isActive()) {
            iterators.addIterator(CacheLogger.iteratorForAppenders());
        } else {
            iterators.addIterator(rootLogger.iteratorForAppenders());
        }
        if (!SYSLOG_DETACHED_APPENDERS.isEmpty()) {
            iterators.addList(SYSLOG_DETACHED_APPENDERS);
        }
        Iterator it = iterators.combinedIterator();
        while (it.hasNext()) {
            boolean replace;
            Encoder encoder;
            Appender appender = (Appender)it.next();
            if (!(appender instanceof OutputStreamAppender) || appender instanceof ConsoleAppender || !((encoder = ((OutputStreamAppender)appender).getEncoder()) instanceof PatternLayoutEncoder)) continue;
            PatternLayoutEncoder patternEncoder = (PatternLayoutEncoder)encoder;
            Object logPattern = patternEncoder.getPattern();
            Pattern pattern = Pattern.compile("%((date|d)(\\{([^\\}]*)\\})?)(?=\\s)");
            Matcher matcher = pattern.matcher((CharSequence)logPattern);
            if (matcher.find()) {
                replace = true;
                if (matcher.group(4) != null && matcher.group(4).equals("yyyy-MM-dd HH:mm:ss.SSS")) {
                    replace = false;
                }
                if (replace) {
                    logPattern = ((String)logPattern).replaceFirst(pattern.pattern(), "%d{yyyy-MM-dd HH:mm:ss.SSS}");
                }
            } else {
                logPattern = ((String)logPattern).startsWith("%-5level") ? ((String)logPattern).substring(0, 8) + " %d{yyyy-MM-dd HH:mm:ss.SSS}" + ((String)logPattern).substring(8) : "d%{yyyy-MM-dd HH:mm:ss.SSS} " + (String)logPattern;
            }
            pattern = Pattern.compile("((%logger|%lo|%c)(\\{\\d+\\})?)(?=\\s)");
            matcher = pattern.matcher((CharSequence)logPattern);
            if (matcher.find()) {
                replace = true;
                if (matcher.group().equals("%logger")) {
                    replace = false;
                }
                if (replace) {
                    logPattern = ((String)logPattern).replaceFirst(pattern.pattern(), "%logger");
                }
            } else {
                logPattern = ((String)logPattern).contains("%msg") ? ((String)logPattern).substring(0, ((String)logPattern).indexOf("%msg")) + "%logger " + ((String)logPattern).substring(((String)logPattern).indexOf("%msg")) : "%logger " + (String)logPattern;
            }
            patternEncoder.setPattern((String)logPattern);
            patternEncoder.start();
        }
        LOGGER.info("Verbose file logging pattern enforced");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Map<String, String> getLogFilePaths() {
        Object object = LOG_FILE_PATHS_LOCK;
        synchronized (object) {
            return LOG_FILE_PATHS;
        }
    }

    static {
        syslogDisabled = false;
        consoleLevel = null;
        tracesLevel = null;
        STATUS_PRINTER = new StatusPrinter2();
    }

    private static enum ActionType {
        START,
        STOP,
        NONE;

    }
}

