/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.FutureTask;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import javax.annotation.Nonnull;
import net.pms.io.ByteProcessWrapperConsumer;
import net.pms.io.ByteProcessWrapperResult;
import net.pms.io.ListProcessWrapperConsumer;
import net.pms.io.ListProcessWrapperResult;
import net.pms.io.NullProcessWrapperConsumer;
import net.pms.io.ProcessWrapperConsumer;
import net.pms.io.ProcessWrapperResult;
import net.pms.service.Services;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ThreadedProcessWrapper<C extends ProcessWrapperConsumer<R, T>, R extends ProcessWrapperResult<T>, T> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ThreadedProcessWrapper.class);
    private static final AtomicInteger PROCESS_COUNTER = new AtomicInteger(1);
    protected final C consumer;

    @Nonnull
    public static Future<ListProcessWrapperResult> runProcessListOutput(long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS, String ... command) {
        return new ThreadedProcessWrapper(new ListProcessWrapperConsumer()).runProcess(timeUnit.toMillis(timeout), terminateTimeoutMS, command);
    }

    @Nonnull
    public static Future<ListProcessWrapperResult> runProcessListOutput(long timeoutMS, long terminateTimeoutMS, String ... command) {
        return new ThreadedProcessWrapper(new ListProcessWrapperConsumer()).runProcess(timeoutMS, terminateTimeoutMS, command);
    }

    @Nonnull
    public static Future<ListProcessWrapperResult> runProcessListOutput(@Nonnull List<String> command, long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS) {
        return new ThreadedProcessWrapper(new ListProcessWrapperConsumer()).runProcess(command, timeUnit.toMillis(timeout), terminateTimeoutMS);
    }

    @Nonnull
    public static Future<ListProcessWrapperResult> runProcessListOutput(@Nonnull List<String> command, long timeoutMS, long terminateTimeoutMS) {
        return new ThreadedProcessWrapper(new ListProcessWrapperConsumer()).runProcess(command, timeoutMS, terminateTimeoutMS);
    }

    @Nonnull
    public static Future<ByteProcessWrapperResult> runProcessByteOutput(long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS, String ... command) {
        return new ThreadedProcessWrapper(new ByteProcessWrapperConsumer()).runProcess(timeUnit.toMillis(timeout), terminateTimeoutMS, command);
    }

    @Nonnull
    public static Future<ByteProcessWrapperResult> runProcessByteOutput(long timeoutMS, long terminateTimeoutMS, String ... command) {
        return new ThreadedProcessWrapper(new ByteProcessWrapperConsumer()).runProcess(timeoutMS, terminateTimeoutMS, command);
    }

    @Nonnull
    public static Future<ByteProcessWrapperResult> runProcessByteOutput(@Nonnull List<String> command, long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS) {
        return new ThreadedProcessWrapper(new ByteProcessWrapperConsumer()).runProcess(command, timeUnit.toMillis(timeout), terminateTimeoutMS);
    }

    @Nonnull
    public static Future<ByteProcessWrapperResult> runProcessByteOutput(@Nonnull List<String> command, long timeoutMS, long terminateTimeoutMS) {
        return new ThreadedProcessWrapper(new ByteProcessWrapperConsumer()).runProcess(command, timeoutMS, terminateTimeoutMS);
    }

    public static void runProcessNullOutput(long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS, String ... command) {
        new ThreadedProcessWrapper(new NullProcessWrapperConsumer()).runProcess(timeUnit.toMillis(timeout), terminateTimeoutMS, command);
    }

    public static void runProcessNullOutput(long timeoutMS, long terminateTimeoutMS, String ... command) {
        new ThreadedProcessWrapper(new NullProcessWrapperConsumer()).runProcess(timeoutMS, terminateTimeoutMS, command);
    }

    public static void runProcessNullOutput(@Nonnull List<String> command, long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS) {
        new ThreadedProcessWrapper(new NullProcessWrapperConsumer()).runProcess(command, timeUnit.toMillis(timeout), terminateTimeoutMS);
    }

    public static void runProcessNullOutput(@Nonnull List<String> command, long timeoutMS, long terminateTimeoutMS) {
        new ThreadedProcessWrapper(new NullProcessWrapperConsumer()).runProcess(command, timeoutMS, terminateTimeoutMS);
    }

    public ThreadedProcessWrapper(C consumer) {
        this.consumer = consumer;
    }

    public ThreadedProcessWrapper(Class<C> consumer) throws InstantiationException, IllegalAccessException, IllegalArgumentException, InvocationTargetException, NoSuchMethodException, SecurityException {
        this.consumer = (ProcessWrapperConsumer)consumer.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
    }

    @Nonnull
    public Future<R> runProcess(long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS, String ... command) {
        return this.runProcess(Arrays.asList(command), timeUnit.toMillis(timeout), terminateTimeoutMS);
    }

    @Nonnull
    public Future<R> runProcess(long timeoutMS, long terminateTimeoutMS, String ... command) {
        return this.runProcess(Arrays.asList(command), timeoutMS, terminateTimeoutMS);
    }

    @Nonnull
    public Future<R> runProcess(@Nonnull List<String> command, long timeout, @Nonnull TimeUnit timeUnit, long terminateTimeoutMS) {
        return this.runProcess(command, timeUnit.toMillis(timeout), terminateTimeoutMS);
    }

    @Nonnull
    public Future<R> runProcess(@Nonnull List<String> command, long timeoutMS, long terminateTimeoutMS) {
        Path executable;
        if (command.isEmpty()) {
            throw new IllegalArgumentException("command can't be null or empty");
        }
        String executableName = StringUtils.isNotBlank(command.get(0)) ? ((executable = Paths.get(command.get(0), new String[0]).getFileName()) != null ? executable.toString() : command.get(0)) : command.get(0);
        int threadId = PROCESS_COUNTER.getAndIncrement();
        Callable<ProcessWrapperResult> callable = () -> {
            boolean interrupted;
            Process process;
            boolean manageProcess = timeoutMS > 0L;
            ProcessBuilder processBuilder = new ProcessBuilder(command);
            processBuilder.redirectErrorStream(true);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("Executing \"{}\"", (Object)StringUtils.join(command, " "));
            }
            try {
                process = processBuilder.start();
            }
            catch (IOException e) {
                LOGGER.debug("IOException when trying to start \"{}\" process: {}", (Object)executableName, (Object)e.getMessage());
                LOGGER.trace("", e);
                return (ProcessWrapperResult)this.consumer.createResult(null, Integer.MIN_VALUE, e);
            }
            FutureTask output = this.consumer.consume(process.getInputStream(), "TPW \"" + executableName + "\" consumer " + threadId);
            if (manageProcess) {
                Services.processManager().addProcess(process, executableName, timeoutMS, terminateTimeoutMS);
            }
            int exitCode = Integer.MIN_VALUE;
            boolean shutdown = false;
            do {
                interrupted = false;
                try {
                    exitCode = process.waitFor();
                }
                catch (InterruptedException e) {
                    interrupted = Thread.interrupted();
                    if (shutdown) continue;
                    if (manageProcess) {
                        Services.processManager().shutdownProcess(process, executableName);
                        manageProcess = false;
                    } else {
                        Services.processManager().addProcess(process, executableName, 0L, terminateTimeoutMS);
                    }
                    shutdown = true;
                }
            } while (interrupted);
            if (manageProcess) {
                Services.processManager().removeProcess(process, executableName);
            }
            try {
                return (ProcessWrapperResult)this.consumer.createResult(output.get(), exitCode, null);
            }
            catch (ExecutionException e) {
                Throwable cause = e.getCause() != null ? e.getCause() : e;
                LOGGER.error("ExecutionException in \"{}\" consumer, no output will be returned: {}", (Object)executableName, (Object)cause.getMessage());
                LOGGER.trace("", e);
                return (ProcessWrapperResult)this.consumer.createResult(null, exitCode, cause);
            }
        };
        FutureTask<ProcessWrapperResult> result = new FutureTask<ProcessWrapperResult>(callable);
        Thread runner = new Thread(result, "TPW \"" + executableName + "\" " + threadId);
        runner.start();
        return result;
    }
}

