/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import com.sun.jna.Platform;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicInteger;
import net.pms.encoders.AviDemuxerInputStream;
import net.pms.io.BufferedOutputByteArrayImpl;
import net.pms.io.BufferedOutputFile;
import net.pms.io.ByteArrayOutputStreamConsumer;
import net.pms.io.OutputBufferConsumer;
import net.pms.io.OutputConsumer;
import net.pms.io.OutputParams;
import net.pms.io.OutputTextConsumer;
import net.pms.io.OutputTextLogger;
import net.pms.io.ProcessWrapper;
import net.pms.util.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessWrapperImpl
extends Thread
implements ProcessWrapper {
    private static final Logger LOGGER = LoggerFactory.getLogger(ProcessWrapperImpl.class);
    private static final String FONTCONFIG_PATH = "FONTCONFIG_PATH";
    private static final AtomicInteger PROCESS_COUNTER = new AtomicInteger(1);
    private static final List<Process> CURRENT_PROCESSES = Collections.synchronizedList(new ArrayList());
    private Process process;
    private OutputConsumer stdoutConsumer;
    private OutputConsumer stderrConsumer;
    private OutputParams params;
    private volatile boolean destroyed;
    private String[] cmdArray;
    private boolean nullable;
    private ArrayList<ProcessWrapper> attachedProcesses;
    private BufferedOutputFile bo = null;
    private boolean keepStdout;
    private boolean keepStderr;
    private volatile boolean success;
    private final boolean useByteArrayStdConsumer;

    @Override
    public String toString() {
        return super.getName();
    }

    public boolean isSuccess() {
        return this.success;
    }

    public ProcessWrapperImpl(String[] cmdArray, OutputParams params) {
        this(cmdArray, params, false, false);
    }

    public ProcessWrapperImpl(String[] cmdArray, boolean useByteArrayStdConsumer, OutputParams params) {
        this(cmdArray, useByteArrayStdConsumer, params, false, false);
    }

    public ProcessWrapperImpl(String[] cmdArray, OutputParams params, boolean keepOutput) {
        this(cmdArray, false, params, keepOutput, keepOutput);
    }

    public ProcessWrapperImpl(String[] cmdArray, boolean useByteArrayStdConsumer, OutputParams params, boolean keepOutput) {
        this(cmdArray, useByteArrayStdConsumer, params, keepOutput, keepOutput);
    }

    public ProcessWrapperImpl(String[] cmdArray, OutputParams params, boolean keepStdout, boolean keepStderr) {
        this(cmdArray, false, params, keepStdout, keepStderr);
    }

    public ProcessWrapperImpl(String[] cmdArray, boolean useByteArrayStdConsumer, OutputParams params, boolean keepStdout, boolean keepStderr) {
        this.useByteArrayStdConsumer = useByteArrayStdConsumer;
        String threadName = cmdArray[0];
        if (threadName.indexOf(47) >= 0) {
            threadName = threadName.substring(threadName.lastIndexOf(47) + 1);
        }
        if (threadName.indexOf(92) >= 0) {
            threadName = threadName.substring(threadName.lastIndexOf(92) + 1);
        }
        this.setName(threadName + "-" + PROCESS_COUNTER.getAndIncrement());
        File exec = new File(cmdArray[0]);
        if (exec.isFile()) {
            cmdArray[0] = exec.getAbsolutePath();
        }
        this.cmdArray = cmdArray;
        this.params = params;
        this.keepStdout = keepStdout;
        this.keepStderr = keepStderr;
        this.attachedProcesses = new ArrayList();
    }

    public void attachProcess(ProcessWrapper process) {
        this.attachedProcesses.add(process);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ProcessBuilder pb = new ProcessBuilder(this.cmdArray);
        try {
            long pid;
            if (LOGGER.isDebugEnabled()) {
                LOGGER.debug("Starting {}", (Object)ProcessUtil.dbgWashCmds(this.cmdArray));
            }
            if (this.params.getWorkDir() != null && this.params.getWorkDir().isDirectory()) {
                pb.directory(this.params.getWorkDir());
            }
            Map<String, String> environment = pb.environment();
            if (this.params.getEnv() != null && !this.params.getEnv().isEmpty()) {
                Object path;
                String sysPathKey;
                String string = sysPathKey = Platform.isWindows() ? "Path" : "PATH";
                Object object = this.params.getEnv().containsKey("PATH") ? this.params.getEnv().get("PATH") : (this.params.getEnv().containsKey("path") ? this.params.getEnv().get("path") : (path = this.params.getEnv().containsKey("Path") ? this.params.getEnv().get("Path") : null));
                if (path != null) {
                    path = (String)path + File.pathSeparator + environment.get(sysPathKey);
                }
                environment.putAll(this.params.getEnv());
                if (path != null) {
                    environment.put(sysPathKey, (String)path);
                }
            }
            if (Platform.isMac() && !environment.containsKey(FONTCONFIG_PATH)) {
                String pmsWorkingDirectory = new File("").getAbsolutePath();
                String fontconfigFontsPath = pmsWorkingDirectory + "/fonts";
                LOGGER.trace("Setting FONTCONFIG_PATH to \"" + fontconfigFontsPath + "\"");
                environment.put(FONTCONFIG_PATH, fontconfigFontsPath);
            }
            this.process = pb.start();
            CURRENT_PROCESSES.add(this.process);
            if (this.stderrConsumer == null) {
                this.stderrConsumer = this.keepStderr ? new OutputTextConsumer(this.process.getErrorStream(), true) : new OutputTextLogger(this.process.getErrorStream());
            } else {
                this.stderrConsumer.setInputStream(this.process.getErrorStream());
            }
            this.stderrConsumer.setName(this.getName() + "-2");
            this.stderrConsumer.start();
            this.stdoutConsumer = null;
            if (this.useByteArrayStdConsumer) {
                this.stdoutConsumer = new ByteArrayOutputStreamConsumer(this.process.getInputStream(), this.params);
                this.bo = this.stdoutConsumer.getBuffer();
            } else if (this.params.getInputPipes()[0] != null) {
                LOGGER.debug("Reading pipe: {}", (Object)this.params.getInputPipes()[0].getInputPipe());
                this.bo = this.params.getInputPipes()[0].getDirectBuffer();
                if (this.bo == null || this.params.isLosslessAudio() || this.params.isLossyAudio() || this.params.isNoVideoEncode()) {
                    InputStream is = this.params.getInputPipes()[0].getInputStream();
                    if (this.params.isAvidemux()) {
                        is = new AviDemuxerInputStream(is, this.params, this.attachedProcesses);
                    }
                    this.stdoutConsumer = new OutputBufferConsumer(is, this.params);
                    this.bo = this.stdoutConsumer.getBuffer();
                }
                this.bo.attachThread(this);
                new OutputTextLogger(this.process.getInputStream()).start();
            } else if (this.params.isLog()) {
                this.stdoutConsumer = this.keepStdout ? new OutputTextConsumer(this.process.getInputStream(), true) : new OutputTextLogger(this.process.getInputStream());
            } else {
                this.stdoutConsumer = new OutputBufferConsumer(this.process.getInputStream(), this.params);
                this.bo = this.stdoutConsumer.getBuffer();
                this.bo.attachThread(this);
            }
            if (this.stdoutConsumer != null) {
                this.stdoutConsumer.setName(this.getName() + "-1");
                this.stdoutConsumer.start();
            }
            if (this.params.getStdIn() != null) {
                this.params.getStdIn().push(this.process.getOutputStream());
            }
            if ((pid = ProcessUtil.getProcessId(this.process)) != 0L) {
                LOGGER.debug("Process ID ({}): {}", (Object)this.cmdArray[0], (Object)pid);
            }
            ProcessUtil.waitFor(this.process);
            try {
                if (this.stderrConsumer != null) {
                    this.stderrConsumer.join(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            try {
                if (this.stdoutConsumer != null) {
                    this.stdoutConsumer.join(1000L);
                }
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        catch (IOException e) {
            LOGGER.error("Error initializing process: {}", (Object)e.getMessage());
            LOGGER.debug("", e);
            this.stopProcess();
        }
        finally {
            try {
                if (this.bo != null) {
                    this.bo.close();
                }
            }
            catch (IOException ioe) {
                LOGGER.debug("Error closing buffered output file: {}", (Object)ioe.getMessage());
                LOGGER.debug("", ioe);
            }
            if (!this.destroyed && !this.params.isNoExitCheck()) {
                try {
                    this.success = true;
                    if (this.process != null && this.process.exitValue() != 0) {
                        LOGGER.info("Process {} has a return code of {}! Maybe an error occurred... check the log file", (Object)this.cmdArray[0], (Object)this.process.exitValue());
                        this.success = false;
                    }
                }
                catch (IllegalThreadStateException itse) {
                    LOGGER.error("Error reading process exit value: {}", (Object)itse.getMessage());
                    LOGGER.debug("", itse);
                }
            }
            if (this.attachedProcesses != null) {
                for (ProcessWrapper pw : this.attachedProcesses) {
                    if (pw == null) continue;
                    pw.stopProcess();
                }
            }
            CURRENT_PROCESSES.remove(this.process);
        }
    }

    @Override
    public void runInNewThread() {
        this.start();
    }

    @Override
    @SuppressFBWarnings(value={"RU_INVOKE_RUN"})
    public void runInSameThread() {
        if (!this.useByteArrayStdConsumer && !this.params.isLog()) {
            LOGGER.warn("ProcessWrapperImpl.runInSameThread() is called without using byte array standard consumer or a text consumer. This can cause this thread to hang and should be avoided!");
        }
        this.run();
    }

    public BufferedOutputByteArrayImpl getOutputByteArray() {
        return this.bo instanceof BufferedOutputByteArrayImpl ? (BufferedOutputByteArrayImpl)this.bo : null;
    }

    @Override
    public InputStream getInputStream(long seek) throws IOException {
        if (this.bo != null) {
            return this.bo.getInputStream(seek);
        }
        if (this.stdoutConsumer != null && this.stdoutConsumer.getBuffer() != null) {
            return this.stdoutConsumer.getBuffer().getInputStream(seek);
        }
        return null;
    }

    public List<String> getOtherResults() {
        if (this.stdoutConsumer == null) {
            return null;
        }
        try {
            this.stdoutConsumer.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.stdoutConsumer.getResults();
    }

    @Override
    public List<String> getResults() {
        try {
            this.stderrConsumer.join(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return this.stderrConsumer.getResults();
    }

    @Override
    public synchronized void stopProcess() {
        if (!this.destroyed) {
            this.destroyed = true;
            if (this.process != null) {
                long pid = ProcessUtil.getProcessId(this.process);
                if (pid != 0L) {
                    LOGGER.debug("Stopping process " + pid + ": " + this);
                } else {
                    LOGGER.debug("Stopping process: " + this);
                }
                ProcessUtil.destroy(this.process);
            }
            if (this.attachedProcesses != null) {
                for (ProcessWrapper pw : this.attachedProcesses) {
                    if (pw == null) continue;
                    pw.stopProcess();
                }
            }
            if (this.stdoutConsumer != null && this.stdoutConsumer.getBuffer() != null) {
                this.stdoutConsumer.getBuffer().reset();
            }
        }
    }

    @Override
    public boolean isDestroyed() {
        return this.destroyed;
    }

    @Override
    public boolean isReadyToStop() {
        return this.nullable;
    }

    @Override
    public void setReadyToStop(boolean nullable) {
        if (nullable != this.nullable) {
            LOGGER.trace("Ready to Stop: " + nullable);
        }
        this.nullable = nullable;
    }

    public void setStderrConsumer(OutputConsumer consumer) {
        this.stderrConsumer = consumer;
    }

    public static void destroyCurrentProcesses() {
        for (Process p : CURRENT_PROCESSES) {
            try {
                p.exitValue();
            }
            catch (IllegalThreadStateException ise) {
                LOGGER.trace("Forcing shutdown of process: " + p);
                ProcessUtil.destroy(p);
            }
        }
    }
}

