/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import net.pms.io.NullProcessWrapperResult;
import net.pms.io.ProcessWrapperConsumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NullProcessWrapperConsumer
implements ProcessWrapperConsumer<NullProcessWrapperResult, Void> {
    private static final Logger LOGGER = LoggerFactory.getLogger(NullProcessWrapperConsumer.class);

    @Override
    @Nullable
    public FutureTask<Void> consume(InputStream inputStream) {
        return this.consume(inputStream, null);
    }

    @Override
    @Nullable
    public FutureTask<Void> consume(@Nullable InputStream inputStream, @Nullable String threadName) {
        if (inputStream == null) {
            return null;
        }
        Callable<Void> callable = () -> {
            ArrayList<String> result = LOGGER.isTraceEnabled() ? new ArrayList<String>() : null;
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    if (result == null) continue;
                    result.add(line);
                }
            }
            if (result != null) {
                LOGGER.trace("Discarded {} lines of process output:", (Object)result.size());
                for (String line : result) {
                    LOGGER.trace("  Process output: {}", (Object)line);
                }
            }
            return null;
        };
        FutureTask<Void> result = new FutureTask<Void>(callable);
        Thread runner = StringUtils.isBlank(threadName) ? new Thread(result) : new Thread(result, threadName);
        runner.start();
        return result;
    }

    @Override
    public NullProcessWrapperResult createResult(@Nullable Void output, int exitCode, @Nullable Throwable throwable) {
        return null;
    }
}

