/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.pms.io.ProcessWrapperResult;
import net.pms.platform.PlatformUtils;

@Immutable
public class ListProcessWrapperResult
implements ProcessWrapperResult<List<String>> {
    protected final List<String> output;
    protected final int exitCode;
    protected final Throwable throwable;

    public ListProcessWrapperResult(@Nullable List<String> output, int exitCode, @Nullable Throwable throwable) {
        this.output = output;
        this.exitCode = exitCode;
        this.throwable = throwable;
    }

    @Override
    @Nonnull
    public List<String> getOutput() {
        return this.output != null ? this.output : new ArrayList<String>();
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public Throwable getError() {
        return this.throwable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        PlatformUtils.INSTANCE.appendErrorString(sb, this.exitCode);
        for (String line : this.output) {
            sb.append(line).append("\n");
        }
        return sb.toString();
    }
}

