/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.FutureTask;
import javax.annotation.Nullable;
import net.pms.io.ListProcessWrapperResult;
import net.pms.io.ProcessWrapperConsumer;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ListProcessWrapperConsumer
implements ProcessWrapperConsumer<ListProcessWrapperResult, List<String>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ListProcessWrapperConsumer.class);

    @Override
    @Nullable
    public FutureTask<List<String>> consume(InputStream inputStream) {
        return this.consume(inputStream, null);
    }

    @Override
    @Nullable
    public FutureTask<List<String>> consume(@Nullable InputStream inputStream, @Nullable String threadName) {
        if (inputStream == null) {
            return null;
        }
        Callable<List> callable = () -> {
            ArrayList<String> result = new ArrayList<String>();
            try (BufferedReader reader = new BufferedReader(new InputStreamReader(inputStream));){
                String line;
                while ((line = reader.readLine()) != null) {
                    result.add(line);
                }
            }
            if (LOGGER.isTraceEnabled()) {
                for (String line : result) {
                    LOGGER.trace("Process output: {}", (Object)line);
                }
            }
            return result;
        };
        FutureTask<List<String>> result = new FutureTask<List<String>>(callable);
        Thread runner = StringUtils.isBlank(threadName) ? new Thread(result) : new Thread(result, threadName);
        runner.start();
        return result;
    }

    @Override
    public ListProcessWrapperResult createResult(@Nullable List<String> output, int exitCode, @Nullable Throwable throwable) {
        return new ListProcessWrapperResult(output, exitCode, throwable);
    }
}

