/*
 * Decompiled with CFR 0.152.
 */
package net.pms.io;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.Immutable;
import net.pms.io.ProcessWrapperResult;
import net.pms.platform.PlatformUtils;

@Immutable
public class ByteProcessWrapperResult
implements ProcessWrapperResult<byte[]> {
    protected final byte[] output;
    protected final int exitCode;
    protected final Throwable throwable;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public ByteProcessWrapperResult(@Nullable byte[] output, int exitCode, @Nullable Throwable throwable) {
        this.output = output;
        this.exitCode = exitCode;
        this.throwable = throwable;
    }

    @Override
    @Nonnull
    public byte[] getOutput() {
        return this.output != null ? this.output : new byte[]{};
    }

    @Override
    public int getExitCode() {
        return this.exitCode;
    }

    @Override
    public Throwable getError() {
        return this.throwable;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        PlatformUtils.INSTANCE.appendErrorString(sb, this.exitCode);
        sb.append("Captured {} bytes of output").append(this.output.length);
        return sb.toString();
    }
}

