/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import com.drew.imaging.png.PngChunkType;
import com.drew.imaging.png.PngColorType;
import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.png.PngDirectory;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import net.pms.image.ColorSpaceType;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.util.ParseException;

public class PNGInfo
extends ImageInfo {
    private static final long serialVersionUID = 1L;
    protected final int colorType;
    protected final InterlaceMethod interlaceMethod;
    protected final boolean hasTransparencyChunk;
    protected final boolean isModifiedBitDepth;

    protected PNGInfo(int width, int height, ImageFormat format, long size, ColorModel colorModel, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
        this.colorType = ((PNGParseInfo)this.parsedInfo).colorType.getNumericValue();
        this.interlaceMethod = ((PNGParseInfo)this.parsedInfo).interlaceMethod;
        this.hasTransparencyChunk = ((PNGParseInfo)this.parsedInfo).hasTransparencyChunk;
        this.isModifiedBitDepth = ((PNGParseInfo)this.parsedInfo).isModifiedBitDepth;
    }

    protected PNGInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
        this.colorType = ((PNGParseInfo)this.parsedInfo).colorType.getNumericValue();
        this.interlaceMethod = ((PNGParseInfo)this.parsedInfo).interlaceMethod;
        this.hasTransparencyChunk = ((PNGParseInfo)this.parsedInfo).hasTransparencyChunk;
        this.isModifiedBitDepth = ((PNGParseInfo)this.parsedInfo).isModifiedBitDepth;
    }

    protected PNGInfo(int width, int height, Metadata metadata, ImageFormat format, long size, boolean applyExifOrientation, boolean throwOnParseFailure) throws ParseException {
        super(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
        this.colorType = ((PNGParseInfo)this.parsedInfo).colorType.getNumericValue();
        this.interlaceMethod = ((PNGParseInfo)this.parsedInfo).interlaceMethod;
        this.hasTransparencyChunk = ((PNGParseInfo)this.parsedInfo).hasTransparencyChunk;
        this.isModifiedBitDepth = ((PNGParseInfo)this.parsedInfo).isModifiedBitDepth;
    }

    protected PNGInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, boolean imageIOSupport, PngColorType colorType, InterlaceMethod interlaceMethod, boolean hasTransparencyChunk, boolean isModifiedBitDepth) {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, imageIOSupport);
        this.colorType = colorType.getNumericValue();
        this.interlaceMethod = interlaceMethod;
        this.hasTransparencyChunk = hasTransparencyChunk;
        this.isModifiedBitDepth = isModifiedBitDepth;
    }

    public PngColorType getColorType() {
        return PngColorType.fromNumericValue(this.colorType);
    }

    public boolean isHasTransparencyChunk() {
        return this.hasTransparencyChunk;
    }

    public boolean isModifiedBitDepth() {
        return this.isModifiedBitDepth;
    }

    public InterlaceMethod getInterlaceMethod() {
        return this.interlaceMethod;
    }

    @Override
    protected ImageInfo.ParseInfo createParseInfo() {
        return new PNGParseInfo();
    }

    @Override
    protected void parseMetadata(Metadata metadata) throws ParseException {
        if (metadata == null) {
            return;
        }
        for (Directory directory : metadata.getDirectories()) {
            if (directory instanceof PngDirectory && PngChunkType.IHDR.equals(((PngDirectory)directory).getPngChunkType())) {
                Integer i;
                this.parsedInfo.format = ImageFormat.PNG;
                if (((PngDirectory)directory).containsTag(1) && ((PngDirectory)directory).containsTag(2)) {
                    this.parsedInfo.width = ((PngDirectory)directory).getInteger(1);
                    this.parsedInfo.height = ((PngDirectory)directory).getInteger(2);
                }
                if (((PngDirectory)directory).containsTag(3)) {
                    this.parsedInfo.bitDepth = ((PngDirectory)directory).getInteger(3);
                }
                if (((PngDirectory)directory).containsTag(7) && (i = ((PngDirectory)directory).getInteger(7)) != null) {
                    ((PNGParseInfo)this.parsedInfo).interlaceMethod = InterlaceMethod.typeOf(i);
                }
                if (((PngDirectory)directory).containsTag(4) && (i = ((PngDirectory)directory).getInteger(4)) != null) {
                    ((PNGParseInfo)this.parsedInfo).colorType = PngColorType.fromNumericValue(i);
                    switch (((PNGParseInfo)this.parsedInfo).colorType.getNumericValue()) {
                        case 0: {
                            this.parsedInfo.numComponents = 1;
                            this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_GRAY;
                            break;
                        }
                        case 2: 
                        case 3: {
                            this.parsedInfo.numComponents = 3;
                            this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_RGB;
                            break;
                        }
                        case 4: {
                            this.parsedInfo.numComponents = 2;
                            this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_GRAY;
                            break;
                        }
                        case 6: {
                            this.parsedInfo.numComponents = 4;
                            this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_RGB;
                            break;
                        }
                    }
                }
            }
            if (directory instanceof PngDirectory && PngChunkType.tRNS.equals(((PngDirectory)directory).getPngChunkType())) {
                ((PNGParseInfo)this.parsedInfo).hasTransparencyChunk = true;
                if (((PNGParseInfo)this.parsedInfo).colorType == null || ((PNGParseInfo)this.parsedInfo).numComponents == null) {
                    throw new ParseException("PNG parsing failed with ancillary chunk tRNS appearing before critical chunk IHDR");
                }
                if (((PNGParseInfo)this.parsedInfo).colorType == PngColorType.GREYSCALE_WITH_ALPHA || ((PNGParseInfo)this.parsedInfo).colorType == PngColorType.TRUE_COLOR_WITH_ALPHA) {
                    throw new ParseException(String.format("PNG parsing failed with illegal combination of %s color type and tRNS transparency chunk", ((PNGParseInfo)this.parsedInfo).colorType));
                }
                ImageInfo.ParseInfo parseInfo = this.parsedInfo;
                Integer n = parseInfo.numComponents;
                parseInfo.numComponents = parseInfo.numComponents + 1;
            }
            if (!(directory instanceof PngDirectory) || !PngChunkType.sBIT.equals(((PngDirectory)directory).getPngChunkType())) continue;
            ((PNGParseInfo)this.parsedInfo).isModifiedBitDepth = true;
        }
    }

    @Override
    public PNGInfo copy() {
        return new PNGInfo(this.width, this.height, this.format, this.size, this.bitDepth, this.numComponents, this.colorSpace, this.colorSpaceType, this.imageIOSupport, PngColorType.fromNumericValue(this.colorType), this.interlaceMethod, this.hasTransparencyChunk, this.isModifiedBitDepth);
    }

    @Override
    protected void buildToString(StringBuilder sb) {
        if (this.colorType >= 0) {
            sb.append(", Color Type = ").append(this.colorType);
        }
        if (this.interlaceMethod != null) {
            sb.append(", Interlace Method = ").append((Object)this.interlaceMethod);
        }
        sb.append(", Has Transparency Chunk = ").append(this.hasTransparencyChunk ? "True" : "False").append(", Has Modified Bit Depth = ").append(this.isModifiedBitDepth ? "True" : "False");
    }

    protected static class PNGParseInfo
    extends ImageInfo.ParseInfo {
        PngColorType colorType;
        InterlaceMethod interlaceMethod;
        boolean hasTransparencyChunk = false;
        boolean isModifiedBitDepth = false;

        protected PNGParseInfo() {
        }
    }

    public static enum InterlaceMethod {
        NONE,
        ADAM7,
        UNKNOWN;


        public static InterlaceMethod typeOf(int value) {
            return switch (value) {
                case 0 -> NONE;
                case 1 -> ADAM7;
                default -> UNKNOWN;
            };
        }
    }
}

