/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.pcx.PcxDirectory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import net.pms.image.ColorSpaceType;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.util.ParseException;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class PCXInfo
extends ImageInfo {
    protected PCXInfo(int width, int height, ImageFormat format, long size, ColorModel colorModel, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
    }

    protected PCXInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
    }

    protected PCXInfo(int width, int height, Metadata metadata, ImageFormat format, long size, boolean applyExifOrientation, boolean throwOnParseFailure) throws ParseException {
        super(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
    }

    protected PCXInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, boolean imageIOSupport) {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, imageIOSupport);
    }

    @Override
    protected ImageInfo.ParseInfo createParseInfo() {
        return new ImageInfo.ParseInfo();
    }

    @Override
    protected void parseMetadata(Metadata metadata) {
        if (metadata == null) {
            return;
        }
        for (Directory directory : metadata.getDirectories()) {
            if (!(directory instanceof PcxDirectory)) continue;
            PcxDirectory pcxDirectory = (PcxDirectory)directory;
            this.parsedInfo.format = ImageFormat.PCX;
            if (!pcxDirectory.containsTag(3) || !pcxDirectory.containsTag(5) || !pcxDirectory.containsTag(4) || !pcxDirectory.containsTag(6)) continue;
            Integer min = pcxDirectory.getInteger(3);
            Integer max = pcxDirectory.getInteger(5);
            if (min != null && max != null) {
                this.parsedInfo.width = max - min + 1;
            }
            min = pcxDirectory.getInteger(4);
            max = pcxDirectory.getInteger(6);
            if (min == null || max == null) continue;
            this.parsedInfo.height = max - min + 1;
        }
    }

    @Override
    public PCXInfo copy() {
        return new PCXInfo(this.width, this.height, this.format, this.size, this.bitDepth, this.numComponents, this.colorSpace, this.colorSpaceType, this.imageIOSupport);
    }

    @Override
    protected void buildToString(StringBuilder sb) {
    }
}

