/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.jfif.JfifDirectory;
import com.drew.metadata.jpeg.HuffmanTablesDirectory;
import com.drew.metadata.jpeg.JpegComponent;
import com.drew.metadata.jpeg.JpegDirectory;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.pms.image.ColorSpaceType;
import net.pms.image.ExifInfo;
import net.pms.image.ExifOrientation;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.image.JPEGSubsamplingNotation;
import net.pms.util.ParseException;

public class JPEGInfo
extends ExifInfo {
    protected final Map<Integer, JpegComponent> components;
    protected final Integer jfifVersion;
    protected final CompressionType compressionType;
    protected final Boolean isTypicalHuffman;
    protected final JPEGSubsamplingNotation chromaSubsampling;

    protected JPEGInfo(int width, int height, ImageFormat format, long size, ColorModel colorModel, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
        this.jfifVersion = ((JPEGParseInfo)this.parsedInfo).jfifVersion;
        this.compressionType = ((JPEGParseInfo)this.parsedInfo).compressionType;
        this.components = ((JPEGParseInfo)this.parsedInfo).components;
        this.isTypicalHuffman = ((JPEGParseInfo)this.parsedInfo).isTypicalHuffman;
        this.chromaSubsampling = ((JPEGParseInfo)this.parsedInfo).chromaSubsampling;
    }

    protected JPEGInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
        this.jfifVersion = ((JPEGParseInfo)this.parsedInfo).jfifVersion;
        this.compressionType = ((JPEGParseInfo)this.parsedInfo).compressionType;
        this.components = ((JPEGParseInfo)this.parsedInfo).components;
        this.isTypicalHuffman = ((JPEGParseInfo)this.parsedInfo).isTypicalHuffman;
        this.chromaSubsampling = ((JPEGParseInfo)this.parsedInfo).chromaSubsampling;
    }

    protected JPEGInfo(int width, int height, Metadata metadata, ImageFormat format, long size, boolean applyExifOrientation, boolean throwOnParseFailure) throws ParseException {
        super(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
        this.jfifVersion = ((JPEGParseInfo)this.parsedInfo).jfifVersion;
        this.compressionType = ((JPEGParseInfo)this.parsedInfo).compressionType;
        this.components = ((JPEGParseInfo)this.parsedInfo).components;
        this.isTypicalHuffman = ((JPEGParseInfo)this.parsedInfo).isTypicalHuffman;
        this.chromaSubsampling = ((JPEGParseInfo)this.parsedInfo).chromaSubsampling;
    }

    protected JPEGInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, boolean imageIOSupport, ExifInfo.PhotometricInterpretation photometricInterpretation, ExifOrientation exifOrientation, ExifOrientation originalExifOrientation, Integer exifVersion, ExifInfo.ExifCompression exifCompression, Integer jfifVersion, ExifInfo.ExifColorSpace exifColorSpace, CompressionType compressionType, Map<Integer, JpegComponent> components, boolean hasExifThumbnail, boolean isTypicalHuffman, JPEGSubsamplingNotation chromaSubsampling) {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, imageIOSupport, photometricInterpretation, exifOrientation, originalExifOrientation, exifVersion, exifCompression, exifColorSpace, hasExifThumbnail);
        this.jfifVersion = jfifVersion;
        this.compressionType = compressionType;
        this.components = components;
        this.isTypicalHuffman = isTypicalHuffman;
        this.chromaSubsampling = chromaSubsampling;
    }

    @Override
    protected ImageInfo.ParseInfo createParseInfo() {
        return new JPEGParseInfo();
    }

    @Override
    protected void parseMetadata(Metadata metadata) {
        if (metadata == null) {
            return;
        }
        super.parseMetadata(metadata);
        for (Directory directory : metadata.getDirectories()) {
            Integer i;
            if (directory instanceof JpegDirectory) {
                JpegDirectory jpegDirectory = (JpegDirectory)directory;
                this.parsedInfo.format = ImageFormat.JPEG;
                if (jpegDirectory.containsTag(3) && jpegDirectory.containsTag(1)) {
                    this.parsedInfo.width = jpegDirectory.getInteger(3);
                    this.parsedInfo.height = jpegDirectory.getInteger(1);
                }
                if (jpegDirectory.containsTag(0) && (i = jpegDirectory.getInteger(0)) != null) {
                    this.parsedInfo.bitDepth = i;
                }
                if (jpegDirectory.containsTag(5) && (i = jpegDirectory.getInteger(5)) != null) {
                    this.parsedInfo.numComponents = i;
                    switch (this.parsedInfo.numComponents) {
                        case 1: {
                            this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_GRAY;
                            break;
                        }
                        case 3: {
                            this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_YCbCr;
                            break;
                        }
                        case 4: {
                            this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_CMYK;
                            break;
                        }
                    }
                    ((JPEGParseInfo)this.parsedInfo).components.clear();
                    for (int j = 0; j < this.parsedInfo.numComponents; ++j) {
                        ((JPEGParseInfo)this.parsedInfo).components.put(j, jpegDirectory.getComponent(j));
                    }
                }
                if (jpegDirectory.containsTag(-3) && (i = jpegDirectory.getInteger(-3)) != null) {
                    ((JPEGParseInfo)this.parsedInfo).compressionType = CompressionType.typeOf(i);
                }
                ((JPEGParseInfo)this.parsedInfo).chromaSubsampling = JPEGSubsamplingNotation.calculateJPEGSubsampling(jpegDirectory);
                continue;
            }
            if (directory instanceof JfifDirectory) {
                JfifDirectory jfifDirectory = (JfifDirectory)directory;
                if (!jfifDirectory.containsTag(5) || (i = jfifDirectory.getInteger(5)) == null) continue;
                ((JPEGParseInfo)this.parsedInfo).jfifVersion = i;
                continue;
            }
            if (!(directory instanceof HuffmanTablesDirectory)) continue;
            HuffmanTablesDirectory huffmanTablesDirectory = (HuffmanTablesDirectory)directory;
            ((JPEGParseInfo)this.parsedInfo).isTypicalHuffman = huffmanTablesDirectory.isTypical();
        }
    }

    public Map<Integer, JpegComponent> getComponents() {
        return Collections.unmodifiableMap(this.components);
    }

    public JpegComponent getComponent(int componentIndex) {
        return this.components.get(componentIndex);
    }

    public int getJFIFVersion() {
        return this.jfifVersion != null ? this.jfifVersion : Integer.MIN_VALUE;
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    public boolean isTypicalHuffman() {
        return this.isTypicalHuffman != null && this.isTypicalHuffman != false;
    }

    public JPEGSubsamplingNotation getChromaSubsampling() {
        return this.chromaSubsampling;
    }

    @Override
    public JPEGInfo copy() {
        return new JPEGInfo(this.width, this.height, this.format, this.size, this.bitDepth, this.numComponents, this.colorSpace, this.colorSpaceType, this.imageIOSupport, this.photometricInterpretation, this.exifOrientation, this.originalExifOrientation, this.exifVersion, this.exifCompression, this.jfifVersion, this.exifColorSpace, this.compressionType, this.components, this.hasExifThumbnail, this.isTypicalHuffman, this.chromaSubsampling);
    }

    @Override
    protected void buildToString(StringBuilder sb) {
        super.buildToString(sb);
        if (this.jfifVersion != null) {
            sb.append(", JFIF Version = ").append(Integer.toHexString(this.jfifVersion));
        }
        if (this.compressionType != null) {
            sb.append(", Compression Type = ").append((Object)this.compressionType);
        }
        if (this.isTypicalHuffman != null) {
            sb.append(", Typical Huffman = ").append(this.isTypicalHuffman != false ? "True" : "False");
        }
        if (this.chromaSubsampling != null) {
            sb.append(", Chroma Subsampling = ").append(this.chromaSubsampling);
        }
        if (this.components != null) {
            sb.append(", Components: [");
            boolean first = true;
            for (Map.Entry<Integer, JpegComponent> component : this.components.entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append(component.getKey()).append(" (").append(component.getValue().getComponentName()).append("): ").append(component.getValue().getHorizontalSamplingFactor()).append(" x ").append(component.getValue().getVerticalSamplingFactor());
                first = false;
            }
            sb.append("]");
        }
    }

    protected static class JPEGParseInfo
    extends ExifInfo.ExifParseInfo {
        Integer jfifVersion;
        CompressionType compressionType;
        Map<Integer, JpegComponent> components = new HashMap<Integer, JpegComponent>(4);
        Boolean isTypicalHuffman;
        JPEGSubsamplingNotation chromaSubsampling;

        protected JPEGParseInfo() {
        }
    }

    public static enum CompressionType {
        BASELINE_HUFFMAN,
        EXTENDED_SEQUENTIAL_HUFFMAN,
        PROGRESSIVE_HUFFMAN,
        LOSSLESS_HUFFMAN,
        DIFFERENTIAL_SEQUENTIAL_HUFFMAN,
        DIFFERENTIAL_PROGRESSIVE_HUFFMAN,
        DIFFERENTIAL_LOSSLESS_HUFFMAN,
        RESERVED,
        EXTENDED_SEQUENTIAL_ARITHMETIC,
        PROGRESSIVE_ARITHMETIC,
        LOSSLESS_ARITHMETIC,
        DIFFERENTIAL_SEQUENTIAL_ARITHMETIC,
        DIFFERENTIAL_PROGRESSIVE_ARITHMETIC,
        DIFFERENTIAL_LOSSLESS_ARITHMETIC;


        public static CompressionType typeOf(int value) {
            return switch (value) {
                case 0 -> BASELINE_HUFFMAN;
                case 1 -> EXTENDED_SEQUENTIAL_HUFFMAN;
                case 2 -> PROGRESSIVE_HUFFMAN;
                case 3 -> LOSSLESS_HUFFMAN;
                case 5 -> DIFFERENTIAL_SEQUENTIAL_HUFFMAN;
                case 6 -> DIFFERENTIAL_PROGRESSIVE_HUFFMAN;
                case 7 -> DIFFERENTIAL_LOSSLESS_HUFFMAN;
                case 8 -> RESERVED;
                case 9 -> EXTENDED_SEQUENTIAL_ARITHMETIC;
                case 10 -> PROGRESSIVE_ARITHMETIC;
                case 11 -> LOSSLESS_ARITHMETIC;
                case 13 -> DIFFERENTIAL_SEQUENTIAL_ARITHMETIC;
                case 14 -> DIFFERENTIAL_PROGRESSIVE_ARITHMETIC;
                case 15 -> DIFFERENTIAL_LOSSLESS_ARITHMETIC;
                default -> null;
            };
        }

        public boolean isHuffman() {
            return switch (this) {
                case BASELINE_HUFFMAN, DIFFERENTIAL_LOSSLESS_HUFFMAN, DIFFERENTIAL_PROGRESSIVE_HUFFMAN, DIFFERENTIAL_SEQUENTIAL_HUFFMAN, EXTENDED_SEQUENTIAL_HUFFMAN, LOSSLESS_HUFFMAN, PROGRESSIVE_HUFFMAN -> true;
                default -> false;
            };
        }
    }
}

