/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.image.BufferedImage;
import java.awt.image.ColorConvertOp;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.ref.WeakReference;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.imageio.IIOException;
import javax.imageio.ImageIO;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.filters.Canvas;
import net.coobird.thumbnailator.geometry.Position;
import net.coobird.thumbnailator.geometry.Positions;
import net.coobird.thumbnailator.util.exif.ExifFilterUtils;
import net.pms.PMS;
import net.pms.dlna.DLNAImage;
import net.pms.dlna.DLNAImageProfile;
import net.pms.dlna.DLNAThumbnail;
import net.pms.image.BufferedImageFilter;
import net.pms.image.BufferedImageFilterChain;
import net.pms.image.ColorSpaceType;
import net.pms.image.ExifOrientation;
import net.pms.image.Image;
import net.pms.image.ImageFormat;
import net.pms.image.ImageIOTools;
import net.pms.image.ImageInfo;
import net.pms.image.NonGeometricBufferedImageOp;
import net.pms.parsers.MetadataExtractorParser;
import net.pms.util.BufferedImageType;
import net.pms.util.InvalidStateException;
import net.pms.util.Iso639;
import net.pms.util.UnknownFormatException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImagesUtil {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImagesUtil.class);
    public static final String LANGUAGE_FLAGS_PATH = "/resources/images/store/flags/%s.png";
    private static final HashMap<String, WeakReference<BufferedImage>> LANGUAGE_FLAGS_CACHE = new HashMap();

    private ImagesUtil() {
    }

    public static int parseExifVersion(byte[] bytes) {
        if (bytes == null) {
            return Integer.MIN_VALUE;
        }
        StringBuilder stringBuilder = new StringBuilder(4);
        for (int i = 0; i < bytes.length; ++i) {
            if (bytes[i] > 47 && bytes[i] < 58) {
                stringBuilder.append((char)bytes[i]);
                continue;
            }
            if (bytes[i] != 0 || i != bytes.length - 1) continue;
            stringBuilder.insert(0, '0');
        }
        while (stringBuilder.length() < 4) {
            stringBuilder.append("0");
        }
        try {
            return Integer.parseInt(stringBuilder.toString());
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Failed to parse Exif version number from: {}", (Object)Arrays.toString(bytes));
            return 0;
        }
    }

    public static boolean isExifAxesSwapNeeded(ImageInfo imageInfo) {
        return imageInfo != null && ImagesUtil.isExifAxesSwapNeeded(imageInfo.getExifOrientation());
    }

    public static boolean isExifAxesSwapNeeded(ExifOrientation orientation) {
        if (orientation == null) {
            return false;
        }
        return switch (orientation) {
            case ExifOrientation.LEFT_TOP, ExifOrientation.RIGHT_TOP, ExifOrientation.RIGHT_BOTTOM, ExifOrientation.LEFT_BOTTOM -> true;
            default -> false;
        };
    }

    public static Dimension calculateScaledResolution(ImageInfo imageInfo, ScaleType scaleType, int scaleWidth, int scaleHeight) {
        return ImagesUtil.calculateScaledResolution(imageInfo.getWidth(), imageInfo.getHeight(), scaleType, scaleWidth, scaleHeight);
    }

    public static Dimension calculateScaledResolution(int actualWidth, int actualHeight, ScaleType scaleType, int scaleWidth, int scaleHeight) {
        if (scaleType == null) {
            throw new NullPointerException("scaleType cannot be null");
        }
        if (actualWidth < 1 || actualHeight < 1) {
            throw new IllegalArgumentException(String.format("actualWidth (%d) and actualHeight (%d) must be positive", actualWidth, actualHeight));
        }
        if (scaleWidth < 1 || scaleHeight < 1) {
            throw new IllegalArgumentException(String.format("scaleWidth (%d) and scaleHeight (%d) must be positive", scaleWidth, scaleHeight));
        }
        double scale = Math.min((double)scaleWidth / (double)actualWidth, (double)scaleHeight / (double)actualHeight);
        if (scaleType == ScaleType.MAX && scale > 1.0) {
            scale = 1.0;
        }
        return new Dimension((int)Math.max(Math.round((double)actualWidth * scale), 1L), (int)Math.max(Math.round((double)actualHeight * scale), 1L));
    }

    public static byte[] retrieveByteArray(ByteArrayInputStream inputStream) {
        try {
            Field f = ByteArrayInputStream.class.getDeclaredField("buf");
            f.setAccessible(true);
            return (byte[])f.get(inputStream);
        }
        catch (IllegalAccessException | NoSuchFieldException | RuntimeException e) {
            LOGGER.debug("Unexpected reflection failure in retrieveByteArray(): {}", (Object)e.getMessage());
            LOGGER.trace("", e);
            return null;
        }
    }

    public static byte[] toByteArray(InputStream inputStream) throws IOException {
        if (inputStream == null) {
            return IOUtils.EMPTY_BYTE_ARRAY;
        }
        try (InputStream inputStream2 = inputStream;){
            ByteArrayInputStream byteArrayInputStream;
            byte[] bytes;
            if (inputStream instanceof ByteArrayInputStream && (bytes = ImagesUtil.retrieveByteArray(byteArrayInputStream = (ByteArrayInputStream)inputStream)) != null) {
                byte[] byArray = bytes;
                return byArray;
            }
            byte[] byArray = IOUtils.toByteArray(inputStream);
            return byArray;
        }
    }

    public static Image convertImage(Image inputImage, ImageFormat outputFormat, boolean dlnaCompliant, boolean dlnaThumbnail, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(inputImage, 0, 0, null, outputFormat, dlnaCompliant, dlnaThumbnail, false, filterChain);
    }

    public static Image convertImage(InputStream inputStream, ImageFormat outputFormat, boolean dlnaCompliant, boolean dlnaThumbnail, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(inputStream, 0, 0, null, outputFormat, dlnaCompliant, dlnaThumbnail, false, filterChain);
    }

    public static Image convertImage(byte[] inputByteArray, ImageFormat outputFormat, boolean dlnaCompliant, boolean dlnaThumbnail, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(inputByteArray, 0, 0, null, outputFormat, dlnaCompliant, dlnaThumbnail, false, filterChain);
    }

    public static Image scaleImage(Image inputImage, int width, int height, ScaleType scaleType, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(inputImage, width, height, scaleType, ImageFormat.SOURCE, dlnaCompliant, dlnaThumbnail, padToSize, filterChain);
    }

    public static Image scaleImage(InputStream inputStream, int width, int height, ScaleType scaleType, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(inputStream, width, height, scaleType, ImageFormat.SOURCE, dlnaCompliant, dlnaThumbnail, padToSize, filterChain);
    }

    public static Image scaleImage(byte[] inputByteArray, int width, int height, ScaleType scaleType, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(inputByteArray, width, height, scaleType, ImageFormat.SOURCE, dlnaCompliant, dlnaThumbnail, padToSize, filterChain);
    }

    public static Image transcodeImage(Image inputImage, DLNAImageProfile outputProfile, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(inputImage, 0, 0, null, outputProfile, true, dlnaThumbnail, padToSize, filterChain);
    }

    public static Image transcodeImage(InputStream inputStream, DLNAImageProfile outputProfile, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(inputStream, 0, 0, null, outputProfile, true, dlnaThumbnail, padToSize, filterChain);
    }

    public static Image transcodeImage(byte[] inputByteArray, DLNAImageProfile outputProfile, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(inputByteArray, 0, 0, null, outputProfile, true, dlnaThumbnail, padToSize, filterChain);
    }

    public static Image transcodeImage(Image inputImage, int width, int height, ScaleType scaleType, ImageFormat outputFormat, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(null, inputImage, null, width, height, scaleType, outputFormat, null, dlnaCompliant, dlnaThumbnail, padToSize, filterChain);
    }

    public static Image transcodeImage(InputStream inputStream, int width, int height, ScaleType scaleType, ImageFormat outputFormat, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(null, null, inputStream, width, height, scaleType, outputFormat, null, dlnaCompliant, dlnaThumbnail, padToSize, filterChain);
    }

    public static Image transcodeImage(byte[] inputByteArray, int width, int height, ScaleType scaleType, ImageFormat outputFormat, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(inputByteArray, null, null, width, height, scaleType, outputFormat, null, dlnaCompliant, dlnaThumbnail, padToSize, filterChain);
    }

    public static Image transcodeImage(Image inputImage, int width, int height, ScaleType scaleType, DLNAImageProfile outputProfile, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(null, inputImage, null, width, height, scaleType, null, outputProfile, dlnaCompliant, dlnaThumbnail, padToSize, filterChain);
    }

    public static Image transcodeImage(InputStream inputStream, int width, int height, ScaleType scaleType, DLNAImageProfile outputProfile, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(null, null, inputStream, width, height, scaleType, null, outputProfile, dlnaCompliant, dlnaThumbnail, padToSize, filterChain);
    }

    public static Image transcodeImage(byte[] inputByteArray, int width, int height, ScaleType scaleType, DLNAImageProfile outputProfile, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(inputByteArray, null, null, width, height, scaleType, null, outputProfile, dlnaCompliant, dlnaThumbnail, padToSize, filterChain);
    }

    protected static Image transcodeImage(byte[] inputByteArray, Image inputImage, InputStream inputStream, int width, int height, ScaleType scaleType, ImageFormat outputFormat, DLNAImageProfile outputProfile, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        boolean convertColors;
        ExifOrientation orientation;
        boolean reencode;
        ImageIOTools.ImageReaderResult inputResult;
        if (inputByteArray == null && inputStream == null && inputImage == null) {
            return null;
        }
        if (inputByteArray != null && inputImage != null || inputByteArray != null && inputStream != null || inputImage != null && inputStream != null) {
            throw new IllegalArgumentException("Use either inputByteArray, inputImage or inputStream");
        }
        boolean trace = LOGGER.isTraceEnabled();
        if (trace) {
            StringBuilder sb = new StringBuilder();
            if (scaleType != null) {
                sb.append("ScaleType = ").append((Object)scaleType);
            }
            if (width > 0 && height > 0) {
                if (sb.length() > 0) {
                    sb.append(", ");
                }
                sb.append("Width = ").append(width).append(", Height = ").append(height);
            }
            if (sb.length() > 0) {
                sb.append(", ");
            }
            sb.append("PadToSize = ").append(padToSize ? "True" : "False");
            if (filterChain != null && !filterChain.isEmpty()) {
                sb.append(", Filters: ");
                boolean first = true;
                for (BufferedImageFilter filter : filterChain) {
                    if (first) {
                        first = false;
                    } else {
                        sb.append(", ");
                    }
                    sb.append(filter);
                }
            }
            Object[] objectArray = new Object[4];
            objectArray[0] = inputByteArray != null ? "byte array" : (inputImage != null ? "Image" : "input stream");
            Object object = objectArray[1] = outputProfile != null ? outputProfile : outputFormat;
            objectArray[2] = dlnaThumbnail ? "DLNAThumbnail" : (dlnaCompliant ? "DLNAImage" : "Image");
            objectArray[3] = sb;
            LOGGER.trace("Converting {} image source to {} format and type {} using the following parameters: {}", objectArray);
        }
        ImageIO.setUseCache(false);
        boolean bl = dlnaCompliant = dlnaCompliant || dlnaThumbnail;
        if (inputImage != null) {
            inputByteArray = inputImage.getBytes(false);
        } else if (inputStream != null) {
            inputByteArray = ImagesUtil.toByteArray(inputStream);
        }
        if (outputProfile != null) {
            if (dlnaThumbnail && outputProfile.equals(DLNAImageProfile.GIF_LRG)) {
                outputProfile = DLNAImageProfile.JPEG_LRG;
            }
            if (scaleType == null) {
                scaleType = DLNAImageProfile.JPEG_RES_H_V.equals(outputProfile) ? ScaleType.EXACT : ScaleType.MAX;
            }
            outputFormat = ImageFormat.toImageFormat(outputProfile);
            width = width > 0 ? width : outputProfile.getMaxWidth();
            height = height > 0 ? height : outputProfile.getMaxHeight();
        } else if (scaleType == null) {
            scaleType = ScaleType.MAX;
        }
        try {
            inputResult = ImageIOTools.read(new ByteArrayInputStream(inputByteArray));
        }
        catch (IIOException e) {
            throw new UnknownFormatException("Unable to read image format", e);
        }
        if (inputResult.bufferedImage == null || inputResult.imageFormat == null) {
            throw new UnknownFormatException("Failed to transform image because the source format is unknown");
        }
        if (outputFormat == null || outputFormat == ImageFormat.SOURCE) {
            outputFormat = inputResult.imageFormat;
        }
        BufferedImage bufferedImage = inputResult.bufferedImage;
        boolean bl2 = reencode = filterChain != null && !filterChain.isEmpty();
        if (outputProfile == null && dlnaCompliant) {
            switch (outputFormat) {
                case GIF: {
                    if (!dlnaThumbnail) break;
                    outputFormat = ImageFormat.JPEG;
                    break;
                }
                case JPEG: 
                case PNG: {
                    break;
                }
                default: {
                    outputFormat = bufferedImage.getColorModel().hasAlpha() ? ImageFormat.PNG : ImageFormat.JPEG;
                }
            }
        }
        Metadata metadata = null;
        if (inputImage != null && inputImage.getImageInfo() != null) {
            orientation = inputImage.getImageInfo().getExifOrientation();
        } else {
            try {
                metadata = MetadataExtractorParser.getMetadata(inputByteArray, inputResult.imageFormat);
            }
            catch (ImageProcessingException | IOException e) {
                LOGGER.error("Failed to read input image metadata: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
                metadata = new Metadata();
            }
            if (metadata == null) {
                metadata = new Metadata();
            }
            orientation = MetadataExtractorParser.parseExifOrientation(metadata);
        }
        if (orientation != ExifOrientation.TOP_LEFT) {
            BufferedImage oldBufferedImage = bufferedImage;
            bufferedImage = Thumbnails.of(bufferedImage).scale(1.0).addFilter(ExifFilterUtils.getFilterForOrientation(orientation.getThumbnailatorOrientation())).asBufferedImage();
            oldBufferedImage.flush();
            ByteArrayOutputStream tmpOutputStream = new ByteArrayOutputStream(inputByteArray.length);
            Thumbnails.of(bufferedImage).scale(1.0).outputFormat(outputFormat.toString()).toOutputStream(tmpOutputStream);
            try {
                metadata = MetadataExtractorParser.getMetadata(tmpOutputStream.toByteArray(), outputFormat);
            }
            catch (ImageProcessingException | IOException e) {
                LOGGER.debug("Failed to read rotated image metadata: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
                metadata = new Metadata();
            }
            if (metadata == null) {
                metadata = new Metadata();
            }
            reencode = true;
        }
        if (outputProfile == null && dlnaCompliant) {
            if (width < 1 || height < 1) {
                outputProfile = DLNAImageProfile.getClosestDLNAProfile(bufferedImage.getWidth(), bufferedImage.getHeight(), outputFormat, true);
                width = outputProfile.getMaxWidth();
                height = outputProfile.getMaxHeight();
            } else {
                outputProfile = DLNAImageProfile.getClosestDLNAProfile(ImagesUtil.calculateScaledResolution(bufferedImage.getWidth(), bufferedImage.getHeight(), scaleType, width, height), outputFormat, true);
                width = Math.min(width, outputProfile.getMaxWidth());
                height = Math.min(height, outputProfile.getMaxHeight());
            }
            if (DLNAImageProfile.JPEG_RES_H_V.equals(outputProfile)) {
                scaleType = ScaleType.EXACT;
            }
        }
        boolean bl3 = convertColors = bufferedImage.getType() == BufferedImageType.TYPE_CUSTOM.getTypeId() || bufferedImage.getType() == BufferedImageType.TYPE_BYTE_BINARY.getTypeId() || bufferedImage.getColorModel().getColorSpace().getType() != ColorSpaceType.TYPE_RGB.getTypeId();
        if (!reencode && outputFormat == inputResult.imageFormat && outputProfile != null) {
            DLNAImageProfile.DLNAComplianceResult complianceResult = switch (outputFormat) {
                case ImageFormat.GIF, ImageFormat.JPEG, ImageFormat.PNG -> {
                    if (metadata == null) {
                        ImageInfo e = inputImage.getImageInfo();
                    }
                    ImageInfo imageInfo = ImageInfo.create(bufferedImage.getWidth(), bufferedImage.getHeight(), inputResult.imageFormat, Long.MIN_VALUE, bufferedImage.getColorModel(), metadata, false, true);
                    yield DLNAImageProfile.checkCompliance(imageInfo, outputProfile);
                }
                default -> throw new IllegalStateException("Unexpected image format: " + outputFormat);
            };
            boolean bl4 = reencode = reencode || convertColors || !complianceResult.isFormatCorrect() || !complianceResult.isColorsCorrect();
            if (!complianceResult.isResolutionCorrect()) {
                int n = width > 0 && complianceResult.getMaxWidth() > 0 ? Math.min(width, complianceResult.getMaxWidth()) : (width = width > 0 ? width : complianceResult.getMaxWidth());
                int n2 = height > 0 && complianceResult.getMaxHeight() > 0 ? Math.min(height, complianceResult.getMaxHeight()) : (height = height > 0 ? height : complianceResult.getMaxHeight());
            }
            if (trace) {
                if (complianceResult.isAllCorrect()) {
                    LOGGER.trace("Image conversion DLNA compliance check: The source image is compliant");
                } else {
                    LOGGER.trace("Image conversion DLNA compliance check for {}: The source image colors are {}, format is {} and resolution ({} x {}) is {}.\nFailures:\n  {}", outputProfile, complianceResult.isColorsCorrect() ? "compliant" : "non-compliant", complianceResult.isFormatCorrect() ? "compliant" : "non-compliant", bufferedImage.getWidth(), bufferedImage.getHeight(), complianceResult.isResolutionCorrect() ? "compliant" : "non-compliant", StringUtils.join(complianceResult.getFailures(), "\n  "));
                }
            }
        }
        if (convertColors) {
            BufferedImageType outputImageType = (outputFormat == ImageFormat.PNG || outputFormat == ImageFormat.PSD) && bufferedImage.getColorModel().getNumComponents() == 4 ? (bufferedImage.isAlphaPremultiplied() ? BufferedImageType.TYPE_4BYTE_ABGR_PRE : BufferedImageType.TYPE_4BYTE_ABGR) : BufferedImageType.TYPE_3BYTE_BGR;
            BufferedImage convertedImage = new BufferedImage(bufferedImage.getWidth(), bufferedImage.getHeight(), outputImageType.getTypeId());
            ColorConvertOp colorConvertOp = new ColorConvertOp(null);
            colorConvertOp.filter(bufferedImage, convertedImage);
            bufferedImage.flush();
            bufferedImage = convertedImage;
            reencode = true;
        }
        if (width < 1 || height < 1 || scaleType == ScaleType.MAX && bufferedImage.getWidth() <= width && bufferedImage.getHeight() <= height || scaleType == ScaleType.EXACT && bufferedImage.getWidth() == width && bufferedImage.getHeight() == height) {
            if (!reencode && inputResult.imageFormat == outputFormat) {
                Image result = dlnaThumbnail ? (metadata == null ? new DLNAThumbnail(inputImage, outputProfile, false) : new DLNAThumbnail(inputByteArray, outputFormat, bufferedImage, metadata, outputProfile, false)) : (dlnaCompliant ? (metadata == null ? new DLNAImage(inputImage, outputProfile, false) : new DLNAImage(inputByteArray, outputFormat, bufferedImage, metadata, outputProfile, false)) : (metadata == null ? new Image(inputImage, false) : new Image(inputByteArray, outputFormat, bufferedImage, metadata, false)));
                bufferedImage.flush();
                if (trace) {
                    LOGGER.trace("No conversion is needed, returning source image with width = {}, height = {} and output {}.", bufferedImage.getWidth(), bufferedImage.getHeight(), dlnaCompliant && outputProfile != null ? "profile: " + outputProfile : "format: " + outputFormat);
                }
                return result;
            }
            if (!reencode) {
                reencode = true;
            }
        } else {
            boolean force = DLNAImageProfile.JPEG_RES_H_V.equals(outputProfile);
            BufferedImage oldBufferedImage = bufferedImage;
            bufferedImage = padToSize && force ? Thumbnails.of(bufferedImage).forceSize(width, height).addFilter(new Canvas(width, height, (Position)Positions.CENTER, Color.BLACK)).asBufferedImage() : (padToSize ? Thumbnails.of(bufferedImage).size(width, height).addFilter(new Canvas(width, height, (Position)Positions.CENTER, Color.BLACK)).asBufferedImage() : (force ? Thumbnails.of(bufferedImage).forceSize(width, height).asBufferedImage() : Thumbnails.of(bufferedImage).size(width, height).asBufferedImage()));
            oldBufferedImage.flush();
        }
        if (filterChain != null && !filterChain.isEmpty()) {
            BufferedImageFilter.BufferedImageFilterResult filterResult = filterChain.filter(bufferedImage);
            if (!filterResult.isOriginalInstance()) {
                bufferedImage.flush();
            }
            bufferedImage = filterResult.getBufferedImage();
        }
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        Thumbnails.of(bufferedImage).scale(1.0).outputFormat(outputFormat.toString()).outputQuality(0.8f).toOutputStream(outputStream);
        byte[] outputByteArray = outputStream.toByteArray();
        Image result = dlnaThumbnail ? new DLNAThumbnail(outputByteArray, bufferedImage.getWidth(), bufferedImage.getHeight(), outputFormat, null, null, outputProfile, false) : (dlnaCompliant ? new DLNAImage(outputByteArray, bufferedImage.getWidth(), bufferedImage.getHeight(), outputFormat, null, null, outputProfile, false) : new Image(outputByteArray, bufferedImage.getWidth(), bufferedImage.getHeight(), outputFormat, null, null, true, false));
        if (trace) {
            StringBuilder sb = new StringBuilder();
            sb.append("Convert colors = ").append(convertColors ? "True" : "False").append(", Re-encode = ").append(reencode ? "True" : "False");
            LOGGER.trace("Finished converting {}x{} {} image{}. Output image resolution: {}x{}, {}. Flags: {}", new Object[]{inputResult.width, inputResult.height, inputResult.imageFormat, orientation != ExifOrientation.TOP_LEFT ? " with orientation " + orientation : "", bufferedImage.getWidth(), bufferedImage.getHeight(), dlnaCompliant && outputProfile != null ? "profile: " + outputProfile : "format: " + outputFormat, sb});
        }
        bufferedImage.flush();
        return result;
    }

    public static DLNAImageProfile parseThumbRequest(String fileName) {
        if (fileName.startsWith("thumbnail0000")) {
            fileName = fileName.substring(13);
            return ImagesUtil.parseImageRequest(fileName, DLNAImageProfile.JPEG_TN);
        }
        LOGGER.warn("Could not parse thumbnail DLNAImageProfile from \"{}\"");
        return DLNAImageProfile.JPEG_TN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static DLNAImageProfile parseImageRequest(String fileName, DLNAImageProfile defaultProfile) {
        Matcher matcher = Pattern.compile("^([A-Z]+_(?:(?!R)[A-Z]+|RES_?\\d+[Xx_]\\d+))_").matcher(fileName);
        if (matcher.find()) {
            DLNAImageProfile imageProfile = DLNAImageProfile.toDLNAImageProfile(matcher.group(1));
            if (imageProfile != null) return imageProfile;
            LOGGER.warn("Could not parse DLNAImageProfile from \"{}\"", (Object)matcher.group(1));
            return defaultProfile;
        } else {
            LOGGER.debug("Embedded DLNAImageProfile not found in \"{}\"", (Object)fileName);
        }
        return defaultProfile;
    }

    public static int getBitDepthFromArray(int[] bitDepthArray) throws InvalidStateException {
        if (bitDepthArray == null || bitDepthArray.length == 0) {
            throw new InvalidStateException("The bit depth array cannot be null or empty");
        }
        try {
            return ImagesUtil.getConstantIntArrayValue(bitDepthArray);
        }
        catch (InvalidStateException e) {
            if (bitDepthArray.length > 1) {
                int[] tmpArray = new int[bitDepthArray.length - 1];
                System.arraycopy(bitDepthArray, 0, tmpArray, 0, bitDepthArray.length - 1);
                return ImagesUtil.getConstantIntArrayValue(tmpArray);
            }
            throw e;
        }
    }

    public static byte getBitDepthFromArray(byte[] bitDepthArray) throws InvalidStateException {
        if (bitDepthArray == null || bitDepthArray.length == 0) {
            throw new InvalidStateException("The bit depth array cannot be null or empty");
        }
        try {
            return ImagesUtil.getConstantByteArrayValue(bitDepthArray);
        }
        catch (InvalidStateException e) {
            if (bitDepthArray.length > 1) {
                byte[] tmpArray = new byte[bitDepthArray.length - 1];
                System.arraycopy(bitDepthArray, 0, tmpArray, 0, bitDepthArray.length - 1);
                return ImagesUtil.getConstantByteArrayValue(tmpArray);
            }
            throw e;
        }
    }

    public static int getConstantIntArrayValue(int[] intArray) throws InvalidStateException {
        if (intArray == null || intArray.length == 0) {
            throw new InvalidStateException("The array cannot be null or empty");
        }
        if (intArray.length == 1) {
            return intArray[0];
        }
        Integer result = null;
        for (int i : intArray) {
            if (result == null) {
                result = i;
                continue;
            }
            if (result == i) continue;
            throw new InvalidStateException("The array doesn't have a constant value: " + Arrays.toString(intArray));
        }
        return result;
    }

    public static byte getConstantByteArrayValue(byte[] byteArray) throws InvalidStateException {
        if (byteArray == null || byteArray.length == 0) {
            throw new InvalidStateException("The array cannot be null or empty");
        }
        if (byteArray.length == 1) {
            return byteArray[0];
        }
        Byte result = null;
        for (byte b : byteArray) {
            if (result == null) {
                result = b;
                continue;
            }
            if (result == b) continue;
            throw new InvalidStateException("The array doesn't have a constant value: " + Arrays.toString(byteArray));
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static BufferedImage getLanguageFlag(String languageCode) {
        if (StringUtils.isBlank(languageCode)) {
            return null;
        }
        if ((languageCode = Iso639.getISO639_2Code(languageCode.toLowerCase(Locale.ROOT))) == null) {
            return null;
        }
        HashMap<String, WeakReference<BufferedImage>> hashMap = LANGUAGE_FLAGS_CACHE;
        synchronized (hashMap) {
            InputStream inputStream;
            BufferedImage result;
            Iterator<Map.Entry<String, WeakReference<BufferedImage>>> cacheIterator = LANGUAGE_FLAGS_CACHE.entrySet().iterator();
            while (cacheIterator.hasNext()) {
                Map.Entry<String, WeakReference<BufferedImage>> entry = cacheIterator.next();
                if (entry.getValue() == null || entry.getValue().get() != null) continue;
                cacheIterator.remove();
            }
            if (LANGUAGE_FLAGS_CACHE.containsKey(languageCode)) {
                WeakReference<BufferedImage> reference = LANGUAGE_FLAGS_CACHE.get(languageCode);
                if (reference == null) {
                    return null;
                }
                result = (BufferedImage)reference.get();
                if (result != null) {
                    return result;
                }
                LANGUAGE_FLAGS_CACHE.remove(languageCode);
            }
            if ((inputStream = PMS.class.getResourceAsStream(String.format(LANGUAGE_FLAGS_PATH, languageCode))) != null) {
                try {
                    result = ImageIO.read(inputStream);
                    LANGUAGE_FLAGS_CACHE.put(languageCode, new WeakReference<BufferedImage>(result));
                    return result;
                }
                catch (Exception e) {
                    LOGGER.warn("An error occurred while trying to read the language flag for \"{}\" (\"{}\"): {}", languageCode, String.format(LANGUAGE_FLAGS_PATH, languageCode), e.getMessage());
                    LOGGER.trace("", e);
                }
            } else {
                LOGGER.debug("Warning: Failed to find the language flag for \"{}\" (\"{}\")", (Object)languageCode, (Object)String.format(LANGUAGE_FLAGS_PATH, languageCode));
            }
            LANGUAGE_FLAGS_CACHE.put(languageCode, null);
            return null;
        }
    }

    public static enum ScaleType {
        EXACT,
        MAX;

    }

    public static class SubtitlesFlagFilter
    extends NonGeometricBufferedImageOp
    implements BufferedImageFilter {
        private final String languageCode;

        public SubtitlesFlagFilter(String languageCode, RenderingHints hints) {
            super(hints);
            this.languageCode = languageCode;
        }

        @Override
        public String getDescription() {
            return this.toString();
        }

        public String toString() {
            return "Subtitles language flag for \"" + this.languageCode + "\"";
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public BufferedImage filter(BufferedImage source, BufferedImage destination) {
            return this.filter(source, destination, true).getBufferedImage();
        }

        @Override
        public BufferedImageFilter.BufferedImageFilterResult filter(BufferedImage source) {
            return this.filter(source, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferedImageFilter.BufferedImageFilterResult filter(BufferedImage source, BufferedImage destination, boolean modifySource) {
            BufferedImage flag = ImagesUtil.getLanguageFlag(this.languageCode);
            if (flag == null) {
                return new BufferedImageFilter.BufferedImageFilterResult(source, false, true);
            }
            boolean sameInstance = true;
            if (source == null) {
                source = this.createCompatibleDestImage(flag, null);
                sameInstance = false;
            }
            if (destination == null) {
                if (modifySource) {
                    destination = source;
                } else {
                    destination = this.createCompatibleDestImage(source, null);
                    sameInstance = false;
                }
            } else {
                sameInstance = source == destination;
            }
            double scale = Math.min((double)source.getWidth() / (double)(flag.getWidth() * 2), (double)source.getHeight() / (double)(flag.getHeight() * 2));
            int maxRelativeHorizontalResolution = (int)Math.round((double)flag.getWidth() * scale * 1.5);
            int maxRelativeVerticalResolution = (int)Math.round((double)flag.getHeight() * scale * 1.5);
            int flagHorizontalResolution = (int)Math.max(Math.round((double)flag.getWidth() * scale), (long)Math.min(64, maxRelativeHorizontalResolution));
            int flagVerticalResolution = (int)Math.max(Math.round((double)flag.getHeight() * scale), (long)Math.min(64, maxRelativeVerticalResolution));
            int flagHorizontalPosition = source.getWidth() - flagHorizontalResolution;
            int flagVerticalPosition = source.getHeight() - flagVerticalResolution;
            Graphics2D g2d = source.createGraphics();
            try {
                if (this.hints != null) {
                    g2d.setRenderingHints(this.hints);
                }
                if (source != destination) {
                    g2d.drawImage((java.awt.Image)source, 0, 0, null);
                }
                g2d.drawImage(flag, flagHorizontalPosition, flagVerticalPosition, flagHorizontalResolution, flagVerticalResolution, null);
            }
            finally {
                g2d.dispose();
            }
            return new BufferedImageFilter.BufferedImageFilterResult(source, true, sameInstance);
        }
    }

    public static class AudioFlagFilter
    extends NonGeometricBufferedImageOp
    implements BufferedImageFilter {
        private final String languageCode;

        public AudioFlagFilter(String languageCode, RenderingHints hints) {
            super(hints);
            this.languageCode = languageCode;
        }

        @Override
        public String getDescription() {
            return this.toString();
        }

        public String toString() {
            return "Audio language flag for \"" + this.languageCode + "\"";
        }

        public String getLanguageCode() {
            return this.languageCode;
        }

        @Override
        public BufferedImage filter(BufferedImage source, BufferedImage destination) {
            return this.filter(source, destination, true).getBufferedImage();
        }

        @Override
        public BufferedImageFilter.BufferedImageFilterResult filter(BufferedImage source) {
            return this.filter(source, null, true);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public BufferedImageFilter.BufferedImageFilterResult filter(BufferedImage source, BufferedImage destination, boolean modifySource) {
            int flagVerticalPosition;
            int flagHorizontalPosition;
            int flagVerticalResolution;
            int flagHorizontalResolution;
            boolean nullSource;
            BufferedImage flag = ImagesUtil.getLanguageFlag(this.languageCode);
            if (flag == null) {
                return new BufferedImageFilter.BufferedImageFilterResult(source, false, true);
            }
            boolean sameInstance = true;
            boolean bl = nullSource = source == null;
            if (source == null) {
                source = flag;
                sameInstance = false;
            }
            if (destination == null) {
                if (modifySource) {
                    destination = source;
                } else {
                    destination = this.createCompatibleDestImage(source, null);
                    sameInstance = false;
                }
            } else {
                boolean bl2 = sameInstance = source == destination;
            }
            if (nullSource && source == destination) {
                return new BufferedImageFilter.BufferedImageFilterResult(flag, true, false);
            }
            if (nullSource) {
                flagHorizontalResolution = source.getWidth();
                flagVerticalResolution = source.getHeight();
                flagHorizontalPosition = 0;
                flagVerticalPosition = 0;
            } else {
                double scale = Math.min((double)source.getWidth() / (double)flag.getWidth(), (double)source.getHeight() / (double)flag.getHeight());
                flagHorizontalResolution = (int)Math.round((double)flag.getWidth() * scale);
                flagVerticalResolution = (int)Math.round((double)flag.getHeight() * scale);
                flagHorizontalPosition = (source.getWidth() - flagHorizontalResolution) / 2;
                flagVerticalPosition = (source.getHeight() - flagVerticalResolution) / 2;
            }
            Graphics2D g2d = source.createGraphics();
            try {
                if (this.hints != null) {
                    g2d.setRenderingHints(this.hints);
                }
                if (source != destination) {
                    g2d.drawImage((java.awt.Image)source, 0, 0, null);
                }
                g2d.drawImage(flag, flagHorizontalPosition, flagVerticalPosition, flagHorizontalResolution, flagVerticalResolution, null);
            }
            finally {
                g2d.dispose();
            }
            return new BufferedImageFilter.BufferedImageFilterResult(source, true, sameInstance);
        }
    }
}

