/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import com.drew.metadata.Metadata;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import java.io.Serializable;
import java.util.Arrays;
import net.pms.image.BMPInfo;
import net.pms.image.CURInfo;
import net.pms.image.ColorSpaceType;
import net.pms.image.ExifInfo;
import net.pms.image.ExifOrientation;
import net.pms.image.GIFInfo;
import net.pms.image.GenericImageInfo;
import net.pms.image.ICOInfo;
import net.pms.image.ImageFormat;
import net.pms.image.ImagesUtil;
import net.pms.image.JPEGInfo;
import net.pms.image.PCXInfo;
import net.pms.image.PNGInfo;
import net.pms.image.PSDInfo;
import net.pms.image.RAWInfo;
import net.pms.image.TIFFInfo;
import net.pms.image.WebPInfo;
import net.pms.parsers.MetadataExtractorParser;
import net.pms.util.InvalidStateException;
import net.pms.util.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class ImageInfo
implements Serializable {
    private static final long serialVersionUID = 4247040093720562338L;
    private static final Logger LOGGER = LoggerFactory.getLogger(ImageInfo.class);
    public static final long SIZE_UNKNOWN = Long.MIN_VALUE;
    public static final int UNKNOWN = Integer.MIN_VALUE;
    protected final int width;
    protected final int height;
    protected final ImageFormat format;
    protected final long size;
    protected final int bitDepth;
    protected final int numComponents;
    protected final ColorSpace colorSpace;
    protected final ColorSpaceType colorSpaceType;
    protected final boolean imageIOSupport;
    protected transient ParseInfo parsedInfo = null;

    protected abstract ParseInfo createParseInfo();

    protected abstract void parseMetadata(Metadata var1) throws ParseException;

    public static ImageInfo create(int width, int height, ImageFormat format, long size, ColorModel colorModel, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        if (format == null && metadata != null && (format = MetadataExtractorParser.toImageFormat(metadata)) == null) {
            throw new ParseException("Unable to determine image format from metadata");
        }
        if (format == null) {
            throw new IllegalArgumentException("Both format and metadata cannot be null");
        }
        if (format.isRaw()) {
            return new RAWInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
        }
        switch (format) {
            case ICNS: 
            case IFF: 
            case PICT: 
            case PNM: 
            case RGBE: 
            case SGI: 
            case TGA: 
            case WBMP: {
                return new GenericImageInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
            }
            case BMP: {
                return new BMPInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
            }
            case CUR: {
                return new CURInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
            }
            case DCX: {
                return new PCXInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
            }
            case GIF: {
                return new GIFInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
            }
            case ICO: {
                return new ICOInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
            }
            case JPEG: {
                return new JPEGInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
            }
            case PCX: {
                return new PCXInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
            }
            case PNG: {
                return new PNGInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
            }
            case PSD: {
                return new PSDInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
            }
            case TIFF: {
                return new TIFFInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
            }
            case WEBP: {
                return new WebPInfo(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
            }
        }
        throw new IllegalStateException("Format " + format + " is unknown for ImageInfo.create()");
    }

    protected ImageInfo(int width, int height, ImageFormat format, long size, ColorModel colorModel, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        this.parsedInfo = this.createParseInfo();
        this.parseMetadata(metadata);
        this.compareResolution(width, height, this.parsedInfo);
        if ((width < 1 || height < 1) && this.parsedInfo.width != null && this.parsedInfo.height != null) {
            width = this.parsedInfo.width;
            height = this.parsedInfo.height;
        }
        if (applyExifOrientation && this.parsedInfo instanceof ExifInfo.ExifParseInfo && ((ExifInfo.ExifParseInfo)this.parsedInfo).exifOrientation != null && ImagesUtil.isExifAxesSwapNeeded(((ExifInfo.ExifParseInfo)this.parsedInfo).exifOrientation)) {
            this.width = height;
            this.height = width;
        } else {
            this.width = width;
            this.height = height;
        }
        this.compareFormat(format, this.parsedInfo);
        this.format = format != null ? format : this.parsedInfo.format;
        long l = this.size = !applyExifOrientation || !(this.parsedInfo instanceof ExifInfo.ExifParseInfo) || ((ExifInfo.ExifParseInfo)this.parsedInfo).exifOrientation == ExifOrientation.TOP_LEFT ? size : Long.MIN_VALUE;
        if (colorModel == null || this instanceof JPEGInfo && this.parsedInfo.colorSpaceType == ColorSpaceType.TYPE_CMYK) {
            this.bitDepth = this.parsedInfo.bitDepth != null ? this.parsedInfo.bitDepth : Integer.MIN_VALUE;
            this.numComponents = this.parsedInfo.numComponents != null ? this.parsedInfo.numComponents : Integer.MIN_VALUE;
            this.colorSpace = null;
            this.colorSpaceType = this.parsedInfo.colorSpaceType;
        } else {
            int bitDepthTemp = Integer.MIN_VALUE;
            if (colorModel.getNumComponents() > 0) {
                try {
                    bitDepthTemp = ImagesUtil.getBitDepthFromArray(colorModel.getComponentSize());
                }
                catch (InvalidStateException e) {
                    LOGGER.trace("Unexpected bit depth array retrieved from ColorModel: {}", (Object)Arrays.toString(colorModel.getComponentSize()));
                }
            }
            int numComponentsTemp = colorModel.getNumComponents();
            ColorSpaceType colorSpaceTypeTemp = ColorSpaceType.toColorSpaceType(colorModel.getColorSpace().getType());
            this.compareColorModel(bitDepthTemp, numComponentsTemp, colorSpaceTypeTemp, this.parsedInfo);
            this.bitDepth = bitDepthTemp == Integer.MIN_VALUE && this.parsedInfo.bitDepth != null ? this.parsedInfo.bitDepth : bitDepthTemp;
            this.numComponents = numComponentsTemp == Integer.MIN_VALUE && this.parsedInfo.numComponents != null ? this.parsedInfo.numComponents : numComponentsTemp;
            this.colorSpace = colorModel.getColorSpace();
            this.colorSpaceType = colorSpaceTypeTemp == null && this.parsedInfo.colorSpaceType != null ? this.parsedInfo.colorSpaceType : colorSpaceTypeTemp;
        }
        this.imageIOSupport = imageIOSupport;
    }

    public static ImageInfo create(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        if (format == null && metadata != null && (format = MetadataExtractorParser.toImageFormat(metadata)) == null) {
            throw new ParseException("Unable to determine image format from metadata");
        }
        if (format == null) {
            throw new IllegalArgumentException("Both format and metadata cannot be null");
        }
        if (format.isRaw()) {
            return new RAWInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
        }
        switch (format) {
            case ICNS: 
            case IFF: 
            case PICT: 
            case PNM: 
            case RGBE: 
            case SGI: 
            case TGA: 
            case WBMP: {
                return new GenericImageInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
            }
            case BMP: {
                return new BMPInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
            }
            case CUR: {
                return new CURInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
            }
            case DCX: {
                return new PCXInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
            }
            case GIF: {
                return new GIFInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
            }
            case ICO: {
                return new ICOInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
            }
            case JPEG: {
                return new JPEGInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
            }
            case PCX: {
                return new PCXInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
            }
            case PNG: {
                return new PNGInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
            }
            case PSD: {
                return new PSDInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
            }
            case TIFF: {
                return new TIFFInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
            }
            case WEBP: {
                return new WebPInfo(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
            }
        }
        throw new IllegalStateException("Format " + format + " is unknown for this ImageInfo.create()");
    }

    protected ImageInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        this.parsedInfo = this.createParseInfo();
        this.parseMetadata(metadata);
        this.compareResolution(width, height, this.parsedInfo);
        if ((width < 1 || height < 1) && this.parsedInfo.width != null && this.parsedInfo.height != null) {
            width = this.parsedInfo.width;
            height = this.parsedInfo.height;
        }
        if (applyExifOrientation && this.parsedInfo instanceof ExifInfo.ExifParseInfo && ((ExifInfo.ExifParseInfo)this.parsedInfo).exifOrientation != null && ImagesUtil.isExifAxesSwapNeeded(((ExifInfo.ExifParseInfo)this.parsedInfo).exifOrientation)) {
            this.width = height;
            this.height = width;
        } else {
            this.width = width;
            this.height = height;
        }
        this.compareFormat(format, this.parsedInfo);
        this.format = format != null ? format : this.parsedInfo.format;
        long l = this.size = !applyExifOrientation || !(this.parsedInfo instanceof ExifInfo.ExifParseInfo) || ((ExifInfo.ExifParseInfo)this.parsedInfo).exifOrientation == ExifOrientation.TOP_LEFT ? size : Long.MIN_VALUE;
        if (this instanceof JPEGInfo && this.parsedInfo.colorSpaceType == ColorSpaceType.TYPE_CMYK) {
            this.bitDepth = this.parsedInfo.bitDepth != null ? this.parsedInfo.bitDepth : bitDepth;
            this.numComponents = this.parsedInfo.numComponents != null ? this.parsedInfo.numComponents : numComponents;
            this.colorSpace = null;
            this.colorSpaceType = this.parsedInfo.colorSpaceType;
        } else {
            colorSpaceType = colorSpace != null ? ColorSpaceType.toColorSpaceType(colorSpace.getType()) : colorSpaceType;
            this.compareColorModel(bitDepth, numComponents, colorSpaceType, this.parsedInfo);
            this.bitDepth = bitDepth == Integer.MIN_VALUE && this.parsedInfo.bitDepth != null ? this.parsedInfo.bitDepth : bitDepth;
            this.numComponents = numComponents == Integer.MIN_VALUE && this.parsedInfo.numComponents != null ? this.parsedInfo.numComponents : numComponents;
            this.colorSpace = colorSpace;
            this.colorSpaceType = colorSpaceType == null && this.parsedInfo.colorSpaceType != null ? this.parsedInfo.colorSpaceType : colorSpaceType;
        }
        this.imageIOSupport = imageIOSupport;
    }

    public static ImageInfo create(Metadata metadata, ImageFormat format, long size, boolean applyExifOrientation, boolean throwOnParseFailure) throws ParseException {
        return ImageInfo.create(Integer.MIN_VALUE, Integer.MIN_VALUE, metadata, format, size, applyExifOrientation, throwOnParseFailure);
    }

    public static ImageInfo create(int width, int height, Metadata metadata, ImageFormat format, long size, boolean applyExifOrientation, boolean throwOnParseFailure) throws ParseException {
        if (format == null && metadata != null && (format = MetadataExtractorParser.toImageFormat(metadata)) == null) {
            throw new ParseException("Unable to determine image format from metadata");
        }
        if (format == null) {
            throw new IllegalArgumentException("Both format and metadata cannot be null");
        }
        if (format.isRaw()) {
            return new RAWInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
        }
        switch (format) {
            case ICNS: 
            case IFF: 
            case PICT: 
            case PNM: 
            case RGBE: 
            case SGI: 
            case TGA: 
            case WBMP: {
                return new GenericImageInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
            }
            case BMP: {
                return new BMPInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
            }
            case CUR: {
                return new CURInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
            }
            case DCX: {
                return new PCXInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
            }
            case GIF: {
                return new GIFInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
            }
            case ICO: {
                return new ICOInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
            }
            case JPEG: {
                return new JPEGInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
            }
            case PCX: {
                return new PCXInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
            }
            case PNG: {
                return new PNGInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
            }
            case PSD: {
                return new PSDInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
            }
            case TIFF: {
                return new TIFFInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
            }
            case WEBP: {
                return new WebPInfo(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
            }
        }
        throw new IllegalStateException("Format " + format + " is unknown for ImageInfo.create()");
    }

    protected ImageInfo(int width, int height, Metadata metadata, ImageFormat format, long size, boolean applyExifOrientation, boolean throwOnParseFailure) throws ParseException {
        this.parsedInfo = this.createParseInfo();
        this.parseMetadata(metadata);
        this.compareResolution(width, height, this.parsedInfo);
        if ((width < 1 || height < 1) && this.parsedInfo.width != null && this.parsedInfo.height != null) {
            width = this.parsedInfo.width;
            height = this.parsedInfo.height;
        }
        if (throwOnParseFailure && (width < 0 || height < 0)) {
            throw new ParseException("Failed to parse image resolution from metadata");
        }
        if (applyExifOrientation && this.parsedInfo instanceof ExifInfo.ExifParseInfo && ((ExifInfo.ExifParseInfo)this.parsedInfo).exifOrientation != null && ImagesUtil.isExifAxesSwapNeeded(((ExifInfo.ExifParseInfo)this.parsedInfo).exifOrientation)) {
            this.width = height;
            this.height = width;
        } else {
            this.width = width;
            this.height = height;
        }
        this.compareFormat(format, this.parsedInfo);
        this.format = format != null ? format : this.parsedInfo.format;
        this.size = !applyExifOrientation || !(this.parsedInfo instanceof ExifInfo.ExifParseInfo) || ((ExifInfo.ExifParseInfo)this.parsedInfo).exifOrientation == ExifOrientation.TOP_LEFT ? size : Long.MIN_VALUE;
        this.bitDepth = this.parsedInfo.bitDepth != null ? this.parsedInfo.bitDepth : Integer.MIN_VALUE;
        this.numComponents = this.parsedInfo.numComponents != null ? this.parsedInfo.numComponents : Integer.MIN_VALUE;
        this.colorSpace = null;
        this.colorSpaceType = this.parsedInfo.colorSpaceType;
        this.imageIOSupport = false;
    }

    protected ImageInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, boolean imageIOSupport) {
        this.width = width;
        this.height = height;
        this.format = format;
        this.size = size;
        this.bitDepth = bitDepth;
        this.numComponents = numComponents;
        this.colorSpace = colorSpace;
        this.colorSpaceType = colorSpaceType;
        this.imageIOSupport = imageIOSupport;
    }

    public int getWidth() {
        return this.width;
    }

    public int getHeight() {
        return this.height;
    }

    public String getResolution() {
        if (this.width > 0 && this.height > 0) {
            return this.width + "x" + this.height;
        }
        return null;
    }

    public ImageFormat getFormat() {
        return this.format;
    }

    public long getSize() {
        return this.size;
    }

    public ColorSpace getColorSpace() {
        return this.colorSpace;
    }

    public ColorSpaceType getColorSpaceType() {
        if (this.colorSpace != null) {
            return ColorSpaceType.toColorSpaceType(this.colorSpace.getType());
        }
        return this.colorSpaceType;
    }

    public int getBitsPerPixel() {
        return this.bitDepth < 0 || this.numComponents < 0 ? Integer.MIN_VALUE : this.bitDepth * this.numComponents;
    }

    public int getNumComponents() {
        return this.numComponents;
    }

    public int getBitDepth() {
        return this.bitDepth;
    }

    public boolean isImageIOSupported() {
        return this.imageIOSupport;
    }

    public ExifOrientation getExifOrientation() {
        if (!(this instanceof ExifInfo)) {
            return ExifOrientation.TOP_LEFT;
        }
        return ((ExifInfo)this).exifOrientation != null ? ((ExifInfo)this).exifOrientation : ExifOrientation.TOP_LEFT;
    }

    public abstract ImageInfo copy();

    protected abstract void buildToString(StringBuilder var1);

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append(this.getClass().getSimpleName()).append(": [Format = ").append((Object)this.format).append(", Resolution = ").append(this.width == Integer.MIN_VALUE ? "Unknown" : Integer.valueOf(this.width)).append("\u00d7").append(this.height == Integer.MIN_VALUE ? "Unknown" : Integer.valueOf(this.height)).append(", Size = ").append(this.size == Long.MIN_VALUE ? "Unknown" : Long.valueOf(this.size)).append(", Bit Depth = ").append(this.bitDepth == Integer.MIN_VALUE ? "Unknown" : Integer.valueOf(this.bitDepth)).append(", Number of Components = ").append(this.numComponents == Integer.MIN_VALUE ? "Unknown" : Integer.valueOf(this.numComponents));
        if (this.colorSpace != null) {
            sb.append(", Color Space = [");
            for (int i = 0; i < this.colorSpace.getNumComponents(); ++i) {
                if (i != 0) {
                    sb.append(", ");
                }
                sb.append(this.colorSpace.getName(i));
            }
            sb.append("]");
        }
        if (this.colorSpaceType != null) {
            sb.append(", Color Space Type = ").append((Object)this.colorSpaceType);
        }
        sb.append(", ImageIO Support = ").append(this.imageIOSupport ? "True" : "False");
        this.buildToString(sb);
        sb.append("]");
        return sb.toString();
    }

    protected void compareResolution(int width, int height, ParseInfo parsedInfo) {
        int parsedHeight;
        if (parsedInfo == null) {
            return;
        }
        int parsedWidth = parsedInfo.width != null ? parsedInfo.width : Integer.MIN_VALUE;
        int n = parsedHeight = parsedInfo.height != null ? parsedInfo.height : Integer.MIN_VALUE;
        if (this instanceof RAWInfo) {
            if (parsedInfo.width != null && width >= parsedInfo.width && width <= parsedInfo.width + 40) {
                parsedWidth = width;
            }
            if (parsedInfo.height != null && height >= parsedInfo.height && height <= parsedInfo.height + 40) {
                parsedHeight = height;
            }
        }
        if (width > 0 && parsedInfo.width != null && width != parsedWidth || height > 0 && parsedInfo.height != null && height != parsedHeight) {
            LOGGER.debug("Warning: Parsed image resolution ({} x {}) mismatches given image resolution ({} x {}) - using given resolution", parsedInfo.width, parsedInfo.height, width, height);
        }
    }

    protected void compareFormat(ImageFormat format, ParseInfo parsedInfo) {
        if (parsedInfo == null) {
            return;
        }
        if (parsedInfo.format != null && format != null && format != parsedInfo.format) {
            LOGGER.debug("Warning: Parsed image format ({}) mismatches given image format ({}) - using given format", (Object)parsedInfo.format, (Object)format);
        }
    }

    protected void compareColorModel(int bitDepth, int numComponents, ColorSpaceType colorSpaceType, ParseInfo parsedInfo) {
        if (parsedInfo == null) {
            return;
        }
        if (!(bitDepth == Integer.MIN_VALUE || parsedInfo.bitDepth == null || bitDepth == parsedInfo.bitDepth || this instanceof GIFInfo && parsedInfo.bitDepth < 8)) {
            LOGGER.debug("Warning: Parsed image bit depth ({}) mismatches given color model bit depth ({}) - using given color model bit depth", (Object)parsedInfo.bitDepth, (Object)bitDepth);
        }
        if (numComponents != Integer.MIN_VALUE && parsedInfo.numComponents != null && numComponents != parsedInfo.numComponents) {
            LOGGER.debug("Warning: Parsed image number of components ({}) mismatches given color model number of components ({}) - using given color model number of components", (Object)parsedInfo.numComponents, (Object)numComponents);
        }
        if (colorSpaceType != null && parsedInfo.colorSpaceType != null && colorSpaceType != parsedInfo.colorSpaceType && (!(this instanceof JPEGInfo) || parsedInfo.colorSpaceType != ColorSpaceType.TYPE_YCbCr && colorSpaceType != ColorSpaceType.TYPE_RGB)) {
            LOGGER.debug("Warning: Parsed image color space type ({}) mismatches given color model color space type ({}) - using given color model color space type", (Object)parsedInfo.colorSpaceType, (Object)colorSpaceType);
        }
    }

    protected static class ParseInfo {
        Integer width;
        Integer height;
        ImageFormat format;
        Integer bitDepth;
        Integer numComponents;
        ColorSpaceType colorSpaceType;

        protected ParseInfo() {
        }
    }
}

