/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import com.drew.imaging.ImageProcessingException;
import com.drew.metadata.Metadata;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.color.ColorSpace;
import java.awt.image.BufferedImage;
import java.awt.image.ColorModel;
import java.io.IOException;
import java.io.InputStream;
import java.io.Serializable;
import net.pms.dlna.DLNAImageProfile;
import net.pms.image.BufferedImageFilterChain;
import net.pms.image.ColorSpaceType;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.image.ImagesUtil;
import net.pms.parsers.MetadataExtractorParser;
import net.pms.util.ParseException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Image
implements Serializable {
    private static final long serialVersionUID = 6878185988106188499L;
    private static final Logger LOGGER = LoggerFactory.getLogger(Image.class);
    protected final byte[] bytes;
    protected final ImageInfo imageInfo;

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public Image(Image image, boolean copy) {
        this.bytes = image.getBytes(copy);
        this.imageInfo = copy && image.getImageInfo() != null ? image.getImageInfo().copy() : image.getImageInfo();
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public Image(byte[] bytes, ImageInfo imageInfo, boolean copy) {
        if (copy && bytes != null) {
            this.bytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
        } else {
            this.bytes = bytes;
        }
        this.imageInfo = copy && imageInfo != null ? imageInfo.copy() : imageInfo;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public Image(byte[] bytes, int width, int height, ImageFormat format, ColorModel colorModel, Metadata metadata, boolean imageIOSupport, boolean copy) throws ParseException {
        if (copy && bytes != null) {
            this.bytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
        } else {
            this.bytes = bytes;
        }
        if (metadata == null) {
            try {
                metadata = MetadataExtractorParser.getMetadata(this.bytes, format);
            }
            catch (ImageProcessingException | IOException e) {
                LOGGER.error("Error reading image metadata: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
                metadata = new Metadata();
            }
        }
        this.imageInfo = ImageInfo.create(width, height, format, bytes != null ? (long)bytes.length : 0L, colorModel, metadata, false, imageIOSupport);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP2"})
    public Image(byte[] bytes, ImageFormat format, BufferedImage bufferedImage, Metadata metadata, boolean copy) throws ParseException {
        if (bufferedImage == null) {
            throw new IllegalArgumentException("bufferedImage cannot be null");
        }
        if (copy && bytes != null) {
            this.bytes = new byte[bytes.length];
            System.arraycopy(bytes, 0, this.bytes, 0, bytes.length);
        } else {
            this.bytes = bytes;
        }
        if (metadata == null) {
            try {
                metadata = MetadataExtractorParser.getMetadata(this.bytes, format);
            }
            catch (ImageProcessingException | IOException e) {
                LOGGER.error("Error while reading image metadata: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
                metadata = new Metadata();
            }
        }
        this.imageInfo = ImageInfo.create(bufferedImage.getWidth(), bufferedImage.getHeight(), format, bytes != null ? (long)bytes.length : 0L, bufferedImage.getColorModel(), metadata, false, true);
    }

    public static Image toImage(InputStream inputStream) throws IOException {
        return Image.toImage(inputStream, 0, 0, null, ImageFormat.SOURCE, false);
    }

    public static Image toImage(byte[] imageByteArray) throws IOException {
        return Image.toImage(imageByteArray, 0, 0, null, ImageFormat.SOURCE, false);
    }

    public static Image toImage(Image inputImage, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        return ImagesUtil.transcodeImage(inputImage, width, height, scaleType, outputFormat, false, false, padToSize, null);
    }

    public static Image toImage(InputStream inputStream, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        return ImagesUtil.transcodeImage(inputStream, width, height, scaleType, outputFormat, false, false, padToSize, null);
    }

    public static Image toImage(byte[] imageByteArray, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        return ImagesUtil.transcodeImage(imageByteArray, width, height, scaleType, outputFormat, false, false, padToSize, null);
    }

    public Image scale(int width, int height, ImagesUtil.ScaleType scaleType, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize) throws IOException {
        return this.transcode(width, height, scaleType, ImageFormat.SOURCE, dlnaCompliant, dlnaThumbnail, padToSize, null);
    }

    public Image transcode(ImageFormat outputFormat, boolean dlnaCompliant, boolean dlnaThumbnail, BufferedImageFilterChain filterChain) throws IOException {
        return this.transcode(0, 0, null, outputFormat, dlnaCompliant, dlnaThumbnail, false, filterChain);
    }

    public Image transcode(int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(this.getBytes(false), width, height, scaleType, outputFormat, dlnaCompliant, dlnaThumbnail, padToSize, filterChain);
    }

    public Image transcode(DLNAImageProfile outputProfile, boolean dlnaCompliant, boolean dlnaThumbnail, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        return ImagesUtil.transcodeImage(this.getBytes(false), 0, 0, ImagesUtil.ScaleType.MAX, outputProfile, dlnaCompliant, dlnaThumbnail, padToSize, filterChain);
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getBytes(boolean copy) {
        if (copy) {
            byte[] result = new byte[this.bytes.length];
            System.arraycopy(this.bytes, 0, result, 0, this.bytes.length);
            return result;
        }
        return this.bytes;
    }

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public int getWidth() {
        return this.imageInfo != null ? this.imageInfo.getWidth() : -1;
    }

    public int getHeight() {
        return this.imageInfo != null ? this.imageInfo.getHeight() : -1;
    }

    public ImageFormat getFormat() {
        return this.imageInfo != null ? this.imageInfo.getFormat() : null;
    }

    public long getSize() {
        return this.bytes != null ? (long)this.bytes.length : 0L;
    }

    public ColorSpace getColorSpace() {
        return this.imageInfo != null ? this.imageInfo.getColorSpace() : null;
    }

    public ColorSpaceType getColorSpaceType() {
        return this.imageInfo != null ? this.imageInfo.getColorSpaceType() : null;
    }

    public int getBitPerPixel() {
        return this.imageInfo != null ? this.imageInfo.getBitsPerPixel() : -1;
    }

    public int getNumComponents() {
        return this.imageInfo != null ? this.imageInfo.getNumComponents() : -1;
    }

    public int getBitDepth() {
        return this.imageInfo != null ? this.imageInfo.getBitDepth() : -1;
    }

    public boolean isImageIOSupported() {
        return this.imageInfo != null && this.imageInfo.isImageIOSupported();
    }

    public Image copy() {
        return new Image(this.bytes, this.imageInfo, true);
    }

    protected void buildToString(StringBuilder sb) {
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(80);
        sb.append(this.getClass().getSimpleName()).append(": [Format = ").append((Object)this.imageInfo.getFormat()).append(", Resolution = ").append(this.imageInfo.getWidth()).append("\u00d7").append(this.imageInfo.getHeight());
        if (this.getSize() > 0L) {
            sb.append(", Size = ").append(this.bytes != null ? this.bytes.length : 0);
        }
        this.buildToString(sb);
        sb.append("]");
        return sb.toString();
    }
}

