/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.gif.GifControlDirectory;
import com.drew.metadata.gif.GifHeaderDirectory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import net.pms.image.ColorSpaceType;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.util.ParseException;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class GIFInfo
extends ImageInfo {
    protected final String formatVersion;
    protected final boolean hasTransparency;

    protected GIFInfo(int width, int height, ImageFormat format, long size, ColorModel colorModel, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
        this.formatVersion = ((GIFParseInfo)this.parsedInfo).formatVersion;
        this.hasTransparency = ((GIFParseInfo)this.parsedInfo).hasTransparency != null && ((GIFParseInfo)this.parsedInfo).hasTransparency != false;
    }

    protected GIFInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
        this.formatVersion = ((GIFParseInfo)this.parsedInfo).formatVersion;
        this.hasTransparency = ((GIFParseInfo)this.parsedInfo).hasTransparency != null && ((GIFParseInfo)this.parsedInfo).hasTransparency != false;
    }

    protected GIFInfo(int width, int height, Metadata metadata, ImageFormat format, long size, boolean applyExifOrientation, boolean throwOnParseFailure) throws ParseException {
        super(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
        this.formatVersion = ((GIFParseInfo)this.parsedInfo).formatVersion;
        this.hasTransparency = ((GIFParseInfo)this.parsedInfo).hasTransparency != null && ((GIFParseInfo)this.parsedInfo).hasTransparency != false;
    }

    protected GIFInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, boolean imageIOSupport, String formatVersion, boolean hasTransparency) {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, imageIOSupport);
        this.formatVersion = formatVersion;
        this.hasTransparency = hasTransparency;
    }

    @Override
    protected ImageInfo.ParseInfo createParseInfo() {
        return new GIFParseInfo();
    }

    @Override
    protected void parseMetadata(Metadata metadata) throws ParseException {
        if (metadata == null) {
            return;
        }
        for (Directory directory : metadata.getDirectories()) {
            if (directory instanceof GifHeaderDirectory) {
                String s;
                GifHeaderDirectory gifHeaderDirectory = (GifHeaderDirectory)directory;
                this.parsedInfo.format = ImageFormat.GIF;
                this.parsedInfo.numComponents = 3;
                if (gifHeaderDirectory.containsTag(2) && gifHeaderDirectory.containsTag(3)) {
                    this.parsedInfo.width = gifHeaderDirectory.getInteger(2);
                    this.parsedInfo.height = gifHeaderDirectory.getInteger(3);
                }
                if (gifHeaderDirectory.containsTag(6)) {
                    this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_RGB;
                    Integer i = gifHeaderDirectory.getInteger(6);
                    if (i != null) {
                        this.parsedInfo.bitDepth = i;
                    }
                }
                if (!gifHeaderDirectory.containsTag(1) || (s = gifHeaderDirectory.getString(1, "US-ASCII")) == null) continue;
                ((GIFParseInfo)this.parsedInfo).formatVersion = s;
                continue;
            }
            if (!(directory instanceof GifControlDirectory)) continue;
            GifControlDirectory gifControlDirectory = (GifControlDirectory)directory;
            boolean isTransparent = gifControlDirectory.isTransparent();
            ((GIFParseInfo)this.parsedInfo).hasTransparency = isTransparent;
            if (!isTransparent) continue;
            if (this.parsedInfo.numComponents == null) {
                throw new ParseException("Invalid GIF image - Graphic Control Extension block encountered before the Header block");
            }
            this.parsedInfo.numComponents = 4;
        }
    }

    @Override
    public GIFInfo copy() {
        return new GIFInfo(this.width, this.height, this.format, this.size, this.bitDepth, this.numComponents, this.colorSpace, this.colorSpaceType, this.imageIOSupport, this.formatVersion, this.hasTransparency);
    }

    public String getFormatVersion() {
        return this.formatVersion;
    }

    public boolean isHasTransparency() {
        return this.hasTransparency;
    }

    @Override
    protected void buildToString(StringBuilder sb) {
        if (this.formatVersion != null) {
            sb.append(", GIF Version = ").append(this.formatVersion);
        }
        sb.append(", Has Transparency = ").append(this.hasTransparency ? "True" : "False");
    }

    protected static class GIFParseInfo
    extends ImageInfo.ParseInfo {
        String formatVersion;
        Boolean hasTransparency;

        protected GIFParseInfo() {
        }
    }
}

