/*
 * Decompiled with CFR 0.152.
 */
package net.pms.image;

import com.drew.metadata.Directory;
import com.drew.metadata.Metadata;
import com.drew.metadata.bmp.BmpHeaderDirectory;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.color.ColorSpace;
import java.awt.image.ColorModel;
import net.pms.image.ColorSpaceType;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.util.ParseException;

@SuppressFBWarnings(value={"SE_NO_SERIALVERSIONID"})
public class BMPInfo
extends ImageInfo {
    protected final CompressionType compressionType;

    protected BMPInfo(int width, int height, ImageFormat format, long size, ColorModel colorModel, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, colorModel, metadata, applyExifOrientation, imageIOSupport);
        this.compressionType = ((BMPParseInfo)this.parsedInfo).compressionType;
    }

    protected BMPInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, Metadata metadata, boolean applyExifOrientation, boolean imageIOSupport) throws ParseException {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, metadata, applyExifOrientation, imageIOSupport);
        this.compressionType = ((BMPParseInfo)this.parsedInfo).compressionType;
    }

    protected BMPInfo(int width, int height, Metadata metadata, ImageFormat format, long size, boolean applyExifOrientation, boolean throwOnParseFailure) throws ParseException {
        super(width, height, metadata, format, size, applyExifOrientation, throwOnParseFailure);
        this.compressionType = ((BMPParseInfo)this.parsedInfo).compressionType;
    }

    protected BMPInfo(int width, int height, ImageFormat format, long size, int bitDepth, int numComponents, ColorSpace colorSpace, ColorSpaceType colorSpaceType, boolean imageIOSupport, CompressionType compressionType) {
        super(width, height, format, size, bitDepth, numComponents, colorSpace, colorSpaceType, imageIOSupport);
        this.compressionType = compressionType;
    }

    @Override
    protected ImageInfo.ParseInfo createParseInfo() {
        return new BMPParseInfo();
    }

    public CompressionType getCompressionType() {
        return this.compressionType;
    }

    @Override
    @SuppressFBWarnings(value={"SF_SWITCH_NO_DEFAULT"})
    protected void parseMetadata(Metadata metadata) {
        if (metadata == null) {
            return;
        }
        for (Directory directory : metadata.getDirectories()) {
            CompressionType compressionTypeTemp;
            if (directory instanceof BmpHeaderDirectory) {
                BmpHeaderDirectory bmpHeaderDirectory = (BmpHeaderDirectory)directory;
                this.parsedInfo.format = ImageFormat.BMP;
                if (bmpHeaderDirectory.containsTag(2) && bmpHeaderDirectory.containsTag(1)) {
                    this.parsedInfo.width = bmpHeaderDirectory.getInteger(2);
                    this.parsedInfo.height = bmpHeaderDirectory.getInteger(1);
                }
            }
            if (!((BmpHeaderDirectory)directory).containsTag(4) || !((BmpHeaderDirectory)directory).containsTag(5) || !((BmpHeaderDirectory)directory).containsTag(-1)) continue;
            Integer compression = ((BmpHeaderDirectory)directory).getInteger(5);
            Integer headerSize = ((BmpHeaderDirectory)directory).getInteger(-1);
            Integer bitsPerPixel = ((BmpHeaderDirectory)directory).getInteger(4);
            if (compression == null || headerSize == null || bitsPerPixel == null) continue;
            ((BMPParseInfo)this.parsedInfo).compressionType = compressionTypeTemp = CompressionType.typeOf(compression, headerSize);
            if (this.parsedInfo.bitDepth == null) continue;
            block0 : switch (compressionTypeTemp) {
                case BIT_FIELDS: 
                case HUFFMAN_1D: 
                case NONE: 
                case PNG: 
                case RLE24: 
                case RLE4: 
                case RLE8: {
                    switch (bitsPerPixel) {
                        case 1: {
                            this.parsedInfo.numComponents = 1;
                            this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_GRAY;
                            this.parsedInfo.bitDepth = 1;
                            break block0;
                        }
                        case 2: 
                        case 4: 
                        case 8: 
                        case 24: {
                            this.parsedInfo.numComponents = 3;
                            this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_RGB;
                            this.parsedInfo.bitDepth = 8;
                            break block0;
                        }
                        case 16: {
                            this.parsedInfo.numComponents = 3;
                            this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_RGB;
                            this.parsedInfo.bitDepth = 5;
                            break block0;
                        }
                        case 32: {
                            this.parsedInfo.numComponents = 4;
                            this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_RGB;
                            this.parsedInfo.bitDepth = 8;
                            break block0;
                        }
                    }
                    break;
                }
                case JPEG: {
                    this.parsedInfo.numComponents = 3;
                    this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_RGB;
                    this.parsedInfo.bitDepth = bitsPerPixel / 3;
                    break;
                }
                case RGBA_BIT_FIELDS: {
                    this.parsedInfo.numComponents = 4;
                    this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_RGB;
                    this.parsedInfo.bitDepth = bitsPerPixel / 4;
                    break;
                }
                case CMYK_NONE: 
                case CMYK_RLE4: 
                case CMYK_RLE8: {
                    this.parsedInfo.numComponents = 4;
                    this.parsedInfo.colorSpaceType = ColorSpaceType.TYPE_CMYK;
                    this.parsedInfo.bitDepth = bitsPerPixel / 4;
                    break;
                }
            }
        }
    }

    @Override
    public BMPInfo copy() {
        return new BMPInfo(this.width, this.height, this.format, this.size, this.bitDepth, this.numComponents, this.colorSpace, this.colorSpaceType, this.imageIOSupport, this.compressionType);
    }

    @Override
    protected void buildToString(StringBuilder sb) {
        if (this.compressionType != null) {
            sb.append(", Compression Type = ").append((Object)this.compressionType);
        }
    }

    protected static class BMPParseInfo
    extends ImageInfo.ParseInfo {
        CompressionType compressionType;

        protected BMPParseInfo() {
        }
    }

    public static enum CompressionType {
        NONE,
        RLE8,
        RLE4,
        BIT_FIELDS,
        HUFFMAN_1D,
        JPEG,
        RLE24,
        PNG,
        RGBA_BIT_FIELDS,
        CMYK_NONE,
        CMYK_RLE8,
        CMYK_RLE4,
        UNKNOWN;


        public String toString() {
            return switch (this) {
                case BIT_FIELDS -> "RGB bit field masks";
                case CMYK_NONE -> "CMYK no compression";
                case CMYK_RLE4 -> "CMYK RLE 4";
                case CMYK_RLE8 -> "CMYK RLE 8";
                case HUFFMAN_1D -> "Huffman 1D";
                case JPEG -> "JPEG";
                case NONE -> "No compression";
                case PNG -> "PNG";
                case RGBA_BIT_FIELDS -> "RGBA bit field masks";
                case RLE24 -> "RLE 24-bit/pixel";
                case RLE4 -> "RLE 4-bit/pixel";
                case RLE8 -> "RLE 8-bit/pixel";
                case UNKNOWN -> "Unknown compression";
                default -> super.toString();
            };
        }

        public static CompressionType typeOf(int value, int headerSize) {
            return switch (value) {
                case 0 -> NONE;
                case 1 -> RLE8;
                case 2 -> RLE4;
                case 3 -> {
                    if (headerSize == 64) {
                        yield BIT_FIELDS;
                    }
                    yield HUFFMAN_1D;
                }
                case 4 -> {
                    if (headerSize == 64) {
                        yield JPEG;
                    }
                    yield RLE24;
                }
                case 5 -> PNG;
                case 6 -> RGBA_BIT_FIELDS;
                case 11 -> CMYK_NONE;
                case 12 -> CMYK_RLE8;
                case 13 -> CMYK_RLE4;
                default -> UNKNOWN;
            };
        }
    }
}

