/*
 * Decompiled with CFR 0.152.
 */
package net.pms.iam;

import com.auth0.jwt.JWT;
import com.auth0.jwt.JWTVerifier;
import com.auth0.jwt.algorithms.Algorithm;
import com.auth0.jwt.exceptions.JWTCreationException;
import com.auth0.jwt.exceptions.JWTDecodeException;
import com.auth0.jwt.exceptions.JWTVerificationException;
import com.auth0.jwt.interfaces.DecodedJWT;
import jakarta.servlet.http.HttpServletRequest;
import java.util.Date;
import java.util.List;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.iam.Account;
import net.pms.iam.AccountService;
import net.pms.iam.Group;
import net.pms.iam.User;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuthService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuthService.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final String JWT_SECRET = CONFIGURATION.getJwtSecret();
    private static final int TWO_HOURS_IN_MS = 0x6DDD00;
    private static final String JWT_ISSUER = "UMS";

    private AuthService() {
    }

    public static String signJwt(int id, String host) {
        try {
            Algorithm algorithm = Algorithm.HMAC256(JWT_SECRET);
            return JWT.create().withIssuer(JWT_ISSUER).withSubject(host).withExpiresAt(new Date(System.currentTimeMillis() + 0x6DDD00L)).withClaim("id", id).sign(algorithm);
        }
        catch (JWTCreationException e) {
            LOGGER.warn("Error signing JWT: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static DecodedJWT decodeJwt(String token) {
        try {
            return JWT.decode(token);
        }
        catch (JWTDecodeException e) {
            LOGGER.warn("Error decoding JWT: {}", (Object)e.getMessage());
            return null;
        }
    }

    private static int getUserIdFromJWT(String token) {
        try {
            DecodedJWT jwt = AuthService.decodeJwt(token);
            if (jwt != null) {
                return jwt.getClaim("id").asInt();
            }
        }
        catch (JWTDecodeException e) {
            LOGGER.warn("Error decoding JWT: {}", (Object)e.getMessage());
        }
        return 0;
    }

    public static boolean isValidToken(String token, String host) {
        try {
            Algorithm algorithm = Algorithm.HMAC256(JWT_SECRET);
            JWTVerifier verifier = JWT.require(algorithm).withIssuer(JWT_ISSUER).withSubject(host).build();
            verifier.verify(token);
            return true;
        }
        catch (JWTVerificationException e) {
            LOGGER.warn("Error verifying JWT: {}", (Object)e.getMessage());
            return false;
        }
    }

    private static Account getAccountLoggedIn(String authHeader, String host) {
        String token = authHeader.replace("Bearer ", "");
        if (AuthService.isValidToken(token, host)) {
            int userId = AuthService.getUserIdFromJWT(token);
            return AccountService.getAccountByUserId(userId);
        }
        return null;
    }

    public static Account getAccountLoggedIn(List<String> authHeaders, String host, boolean isLocalhost) {
        if (!AuthService.isEnabled() || isLocalhost && AuthService.isLocalhostAsAdmin()) {
            return AccountService.getFakeAdminAccount();
        }
        if (authHeaders == null || authHeaders.isEmpty()) {
            return null;
        }
        return AuthService.getAccountLoggedIn(authHeaders.get(0), host);
    }

    public static Account getAccountLoggedIn(HttpServletRequest req) {
        if (!AuthService.isEnabled() || req.getRemoteAddr().equals(req.getLocalAddr()) && AuthService.isLocalhostAsAdmin()) {
            return AccountService.getFakeAdminAccount();
        }
        String authHeader = req.getHeader("Authorization");
        if (authHeader == null) {
            return null;
        }
        return AuthService.getAccountLoggedIn(authHeader, req.getRemoteAddr());
    }

    public static Account getAccountLoggedIn(String authHeader, String host, boolean isLocalhost) {
        if (!AuthService.isEnabled() || isLocalhost && AuthService.isLocalhostAsAdmin()) {
            return AccountService.getFakeAdminAccount();
        }
        if (authHeader == null) {
            return null;
        }
        return AuthService.getAccountLoggedIn(authHeader, host);
    }

    public static Account getPlayerAccountLoggedIn(HttpServletRequest req) {
        if (AuthService.isPlayerRequest(req) && !AuthService.isPlayerEnabled()) {
            Account account = new Account();
            Group group = new Group();
            group.setId(Integer.MAX_VALUE);
            int permissions = 0x2000000;
            if (CONFIGURATION.useWebPlayerControls()) {
                permissions |= 0x1000;
            }
            if (CONFIGURATION.useWebPlayerDownload()) {
                permissions |= 0x4000000;
            }
            group.setPermissions(permissions);
            account.setGroup(group);
            User user = new User();
            user.setId(Integer.MAX_VALUE);
            user.setGroupId(Integer.MAX_VALUE);
            account.setUser(user);
            return account;
        }
        return AuthService.getAccountLoggedIn(req);
    }

    private static boolean isPlayerRequest(HttpServletRequest req) {
        return CONFIGURATION.useWebPlayerServer() && req.getLocalPort() == CONFIGURATION.getWebPlayerServerPort();
    }

    public static boolean isEnabled() {
        return CONFIGURATION.isAuthenticationEnabled();
    }

    public static boolean isPlayerEnabled() {
        return AuthService.isEnabled() && (!CONFIGURATION.useWebPlayerServer() || CONFIGURATION.isWebPlayerAuthenticationEnabled());
    }

    public static void setEnabled(boolean value) {
        CONFIGURATION.setAuthenticationEnabled(value);
    }

    public static boolean isLocalhostAsAdmin() {
        return CONFIGURATION.isAuthenticateLocalhostAsAdmin();
    }

    public static void setLocalhostAsAdmin(boolean value) {
        CONFIGURATION.setAuthenticateLocalhostAsAdmin(value);
    }
}

