/*
 * Decompiled with CFR 0.152.
 */
package net.pms.iam;

import at.favre.lib.crypto.bcrypt.BCrypt;
import java.sql.Connection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableFilesStatus;
import net.pms.database.UserDatabase;
import net.pms.database.UserTableGroups;
import net.pms.database.UserTableUsers;
import net.pms.iam.Account;
import net.pms.iam.Group;
import net.pms.iam.User;
import net.pms.image.Image;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AccountService {
    private static final Logger LOGGER = LoggerFactory.getLogger(AccountService.class);
    public static final String DEFAULT_ADMIN_GROUP = "admin";
    public static final String DEFAULT_ADMIN_USERNAME = "ums";
    public static final String DEFAULT_ADMIN_PASSWORD = "initialpassword";
    public static final int MAX_LOGIN_FAIL_BEFORE_LOCK = 3;
    public static final int LOGIN_FAIL_LOCK_TIME = 30000;
    private static final Map<Integer, User> USERS = new HashMap<Integer, User>();
    private static final Map<Integer, Group> GROUPS = new HashMap<Integer, Group>();
    private static final Account FAKE_ADMIN_ACCOUNT = AccountService.setFakeAdminAccount();

    protected AccountService() {
    }

    public static Account getAccountByUserId(int userId) {
        if (userId == Integer.MAX_VALUE) {
            return FAKE_ADMIN_ACCOUNT;
        }
        Account result = new Account();
        result.setUser(AccountService.getUserById(userId));
        return AccountService.fillGroupAndPermissions(result);
    }

    public static User getUserById(int userId) {
        if (USERS.containsKey(userId)) {
            return USERS.get(userId);
        }
        Connection connection = UserDatabase.getConnectionIfAvailable();
        if (connection != null) {
            User user = UserTableUsers.getUserByUserId(connection, userId);
            if (user != null) {
                USERS.put(userId, user);
                UserDatabase.close(connection);
                return user;
            }
            UserDatabase.close(connection);
        }
        return null;
    }

    private static Group getGroupById(int groupId) {
        if (GROUPS.containsKey(groupId)) {
            return GROUPS.get(groupId);
        }
        Connection connection = UserDatabase.getConnectionIfAvailable();
        if (connection != null) {
            Group group = UserTableGroups.getGroupById(connection, groupId);
            if (group.getId() == groupId) {
                GROUPS.put(group.getId(), group);
            }
            UserDatabase.close(connection);
            return group;
        }
        return null;
    }

    private static Account fillGroupAndPermissions(Account account) {
        if (account == null || account.getUser() == null) {
            return null;
        }
        int groupId = account.getUser().getGroupId();
        account.setGroup(AccountService.getGroupById(groupId));
        if (account.getUser().getGroupId() != account.getGroup().getId() && account.getGroup().getId() == 0) {
            LOGGER.info("User '{}' refer to an unknown group that fall back to no group.", (Object)account.getUser().getUsername());
            account.getUser().setGroupId(account.getGroup().getId());
        }
        return account;
    }

    public static Account getAccountByUsername(Connection connection, String username) {
        int groupId;
        Account account = new Account();
        account.setUser(UserTableUsers.getUserByUsername(connection, username));
        if (account.getUser() == null) {
            return null;
        }
        if (!USERS.containsKey(account.getUser().getId())) {
            USERS.put(account.getUser().getId(), account.getUser());
        }
        if (GROUPS.containsKey(groupId = account.getUser().getGroupId())) {
            account.setGroup(GROUPS.get(groupId));
        } else {
            Group group = UserTableGroups.getGroupById(connection, groupId);
            GROUPS.put(group.getId(), group);
            account.setGroup(group);
            if (account.getUser().getGroupId() != account.getGroup().getId() && account.getGroup().getId() == 0) {
                LOGGER.info("User '{}' refer to an unknown group that fall back to no group.", (Object)account.getUser().getUsername());
                account.getUser().setGroupId(account.getGroup().getId());
            }
        }
        return account;
    }

    public static void setUserLogged(Connection connection, User user) {
        LOGGER.info("User {} logged", (Object)user.getUsername());
        long timestamp = System.currentTimeMillis();
        user.setLastLoginTime(timestamp);
        user.setLoginFailedTime(0L);
        user.setLoginFailedCount(0);
        UserTableUsers.setLoginTime(connection, user.getId(), timestamp);
    }

    public static void setUserLoginFailed(Connection connection, User user) {
        LOGGER.info("User login failed for {}", (Object)user.getUsername());
        long timestamp = System.currentTimeMillis();
        user.setLoginFailedTime(timestamp);
        user.setLoginFailedCount(user.getLoginFailedCount() + 1);
        UserTableUsers.setLoginFailed(connection, user.getId(), timestamp);
    }

    public static void createUser(Connection connection, String username, String password) {
        AccountService.createUser(connection, username, password, username, 0);
    }

    public static void createUser(Connection connection, String username, String password, String displayName) {
        AccountService.createUser(connection, username, password, displayName, 0);
    }

    public static void createUser(Connection connection, String username, String password, int groupId) {
        AccountService.createUser(connection, username, password, username, groupId);
    }

    public static void createUser(Connection connection, String username, String password, String displayName, int groupId) {
        LOGGER.info("Creating user: {}", (Object)username);
        UserTableUsers.addUser(connection, StringUtils.left(username, 255), StringUtils.left(AccountService.hashPassword(password), 255), StringUtils.left(displayName, 255), groupId);
    }

    public static void updateUser(Connection connection, int userId, String displayName, int groupId, Image avatar, String pinCode, boolean libraryHidden) {
        LOGGER.info("Updating user id : {}", (Object)userId);
        if (UserTableUsers.updateUser(connection, userId, displayName, groupId, avatar, pinCode, libraryHidden) && USERS.containsKey(userId)) {
            USERS.get(userId).setDisplayName(displayName);
            USERS.get(userId).setGroupId(groupId);
            USERS.get(userId).setAvatar(avatar);
            USERS.get(userId).setPinCode(pinCode);
        }
    }

    public static void deleteUser(Connection connection, int userId) {
        LOGGER.info("Deleting user id : {}", (Object)userId);
        UserTableUsers.deleteUser(connection, userId);
        Connection mConnection = MediaDatabase.getConnectionIfAvailable();
        if (mConnection != null) {
            MediaTableFilesStatus.deleteUser(mConnection, userId);
            MediaDatabase.close(mConnection);
        }
        if (USERS.containsKey(userId)) {
            USERS.remove(userId);
        }
    }

    public static void updateLogin(Connection connection, int userId, String username, String newPassword) {
        LOGGER.info("Updating username/password for user id {}", (Object)userId);
        String password = AccountService.hashPassword(newPassword);
        if (UserTableUsers.updateLogin(connection, userId, username, password) && USERS.containsKey(userId)) {
            USERS.get(userId).setUsername(username);
            USERS.get(userId).setPassword(password);
        }
    }

    public static void checkUserUnlock(Connection connection, User user) {
        if (user != null && user.getLoginFailedCount() > 0 && System.currentTimeMillis() - user.getLoginFailedTime() > 30000L) {
            LOGGER.trace("Unlocking account for {}", (Object)user.getUsername());
            user.setLoginFailedCount(0);
            UserTableUsers.resetLoginFailCount(connection, user.getId());
        }
    }

    public static boolean isUserLocked(User user) {
        return user == null || user.getLoginFailedCount() >= 3;
    }

    public static boolean validatePassword(String password, String bcryptHash) {
        BCrypt.Result result = BCrypt.verifyer().verify(password.toCharArray(), bcryptHash);
        return result.verified;
    }

    public static String hashPassword(String password) {
        return BCrypt.withDefaults().hashToString(12, password.toCharArray());
    }

    public static void createGroup(Connection connection, String name, int permissions) {
        LOGGER.info("Creating group: {}", (Object)name);
        UserTableGroups.addGroup(connection, name, permissions);
    }

    public static void updateGroup(Connection connection, int groupId, String name) {
        LOGGER.info("Updating group: {}", (Object)groupId);
        if (UserTableGroups.updateGroupName(connection, groupId, name) && GROUPS.containsKey(groupId)) {
            GROUPS.get(groupId).setDisplayName(name);
        }
    }

    public static void deleteGroup(Connection connection, int groupId) {
        LOGGER.info("Deleting group: {}", (Object)groupId);
        if (UserTableGroups.removeGroup(connection, groupId) && GROUPS.containsKey(groupId)) {
            GROUPS.remove(groupId);
        }
    }

    public static void updatePermissions(Connection connection, int groupId, int permissions) {
        LOGGER.info("Updating permissions to group id {}", (Object)groupId);
        if (UserTableGroups.updateGroupPermissions(connection, groupId, permissions) && GROUPS.containsKey(groupId)) {
            GROUPS.get(groupId).setPermissions(permissions);
        }
    }

    public static boolean hasNoAdmin(Connection connection) {
        LOGGER.info("Checking user table have admin");
        return UserTableUsers.hasNoAdmin(connection);
    }

    public static List<User> getUsersLibraryChoice() {
        return AccountService.getAllUsers().stream().filter(User::isLibraryChoice).toList();
    }

    public static Collection<User> getAllUsers() {
        Connection connection = UserDatabase.getConnectionIfAvailable();
        if (connection != null) {
            List<User> users = UserTableUsers.getAllUsers(connection);
            for (User user : users) {
                if (USERS.containsKey(user.getId())) continue;
                USERS.put(user.getId(), user);
            }
            UserDatabase.close(connection);
        }
        return USERS.values();
    }

    public static Collection<Group> getAllGroups() {
        Connection connection = UserDatabase.getConnectionIfAvailable();
        if (connection != null) {
            List<Group> groups = UserTableGroups.getAllGroups(connection);
            for (Group group : groups) {
                if (GROUPS.containsKey(group.getId())) continue;
                GROUPS.put(group.getId(), group);
            }
            UserDatabase.close(connection);
        }
        return GROUPS.values();
    }

    public static List<Integer> getUserIdsForGroup(int groupId) {
        ArrayList<Integer> userIds = new ArrayList<Integer>();
        for (User user : USERS.values()) {
            if (user.getGroupId() != groupId) continue;
            userIds.add(user.getId());
        }
        return userIds;
    }

    public static Account getFakeAdminAccount() {
        return FAKE_ADMIN_ACCOUNT;
    }

    private static Account setFakeAdminAccount() {
        Account account = new Account();
        Group group = new Group();
        group.setPermissions(-1);
        group.setId(Integer.MAX_VALUE);
        account.setGroup(group);
        User user = new User();
        user.setId(Integer.MAX_VALUE);
        user.setGroupId(Integer.MAX_VALUE);
        user.setDisplayName(DEFAULT_ADMIN_USERNAME);
        account.setUser(user);
        return account;
    }
}

