/*
 * Decompiled with CFR 0.152.
 */
package net.pms.external.update;

import com.sun.jna.Platform;
import java.awt.Desktop;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Executor;
import java.util.concurrent.Executors;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.event.EventListenerList;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.external.JavaHttpClient;
import net.pms.external.ProgressCallback;
import net.pms.external.update.AutoUpdaterServerProperties;
import net.pms.external.update.UpdateException;
import net.pms.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AutoUpdater
implements ProgressCallback {
    private static final Logger LOGGER = LoggerFactory.getLogger(AutoUpdater.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final EventListenerList LISTENERS = new EventListenerList();
    private static final AutoUpdaterServerProperties SERVER_PROPERTIES = new AutoUpdaterServerProperties();
    private final String serverUrl;
    private final Object stateLock = new Object();
    private final Version currentVersion;
    private final Executor executor = Executors.newSingleThreadExecutor();
    private State state = State.NOTHING_KNOWN;
    private Throwable errorStateCause;
    private long bytesDownloaded = -1L;
    private long totalBytes = -1L;
    private boolean downloadCancelled = false;

    public static void addChangeListener(ChangeListener listener) {
        LISTENERS.add(ChangeListener.class, listener);
    }

    public static void removeChangeListener(ChangeListener listener) {
        LISTENERS.remove(ChangeListener.class, listener);
    }

    private static void fireStateChanged(AutoUpdater autoUpdater) {
        for (ChangeListener listener : (ChangeListener[])LISTENERS.getListeners(ChangeListener.class)) {
            listener.stateChanged(new ChangeEvent(autoUpdater));
        }
    }

    public AutoUpdater(String updateServerUrl, String currentVersion, String binariesRevision) {
        this.serverUrl = updateServerUrl;
        this.currentVersion = new Version(currentVersion);
    }

    public void pollServer() {
        if (this.serverUrl != null) {
            this.executor.execute(() -> {
                try {
                    this.doPollServer();
                }
                catch (UpdateException e) {
                    this.setErrorState(e);
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doPollServer() throws UpdateException {
        this.assertNotInErrorState();
        try {
            this.setState(State.POLLING_SERVER);
            long unixTime = System.currentTimeMillis() / 1000L;
            byte[] propertiesAsData = JavaHttpClient.getBytes(this.serverUrl + "?cacheBuster=" + unixTime);
            Object object = this.stateLock;
            synchronized (object) {
                SERVER_PROPERTIES.loadFrom(propertiesAsData);
                this.setState(this.isUpdateAvailable() ? State.UPDATE_AVAILABLE : State.NO_UPDATE_AVAILABLE);
            }
        }
        catch (IOException e) {
            this.wrapException("Cannot download properties", e);
        }
    }

    public void getUpdateFromNetwork() {
        this.executor.execute(() -> {
            try {
                this.doGetUpdateFromNetwork();
            }
            catch (UpdateException e) {
                this.setErrorState(e);
            }
        });
    }

    public void runUpdateAndExit() {
        this.executor.execute(() -> {
            try {
                this.doRunUpdateAndExit();
            }
            catch (UpdateException e) {
                this.setErrorState(e);
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setErrorState(UpdateException e) {
        Object object = this.stateLock;
        synchronized (object) {
            this.setState(State.ERROR);
            this.errorStateCause = e;
        }
    }

    private void doGetUpdateFromNetwork() throws UpdateException {
        this.assertNotInErrorState();
        this.assertUpdateIsAvailable();
        this.setState(State.DOWNLOAD_IN_PROGRESS);
        this.downloadUpdate();
        this.setState(State.DOWNLOAD_FINISHED);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRunUpdateAndExit() throws UpdateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.DOWNLOAD_FINISHED) {
                this.setState(State.EXECUTING_SETUP);
                this.launchExe();
                System.exit(0);
            }
        }
    }

    private void launchExe() throws UpdateException {
        try {
            File exe = new File(CONFIGURATION.getProfileDirectory(), AutoUpdater.getTargetFilename());
            Desktop desktop = Desktop.getDesktop();
            desktop.open(exe);
        }
        catch (IOException e) {
            LOGGER.debug("Failed to run update after downloading: {}", e);
            this.wrapException("Unable to run update. You may need to manually download it.", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertUpdateIsAvailable() throws UpdateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (!SERVER_PROPERTIES.isStateValid()) {
                throw new UpdateException("Server error. Try again later.");
            }
            if (!this.isUpdateAvailable()) {
                throw new UpdateException("Attempt to perform non-existent update");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void assertNotInErrorState() throws UpdateException {
        Object object = this.stateLock;
        synchronized (object) {
            if (this.state == State.ERROR) {
                throw new UpdateException("Update system must be reset after an error.");
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void setState(State value) {
        Object object = this.stateLock;
        synchronized (object) {
            this.state = value;
            if (this.state == State.DOWNLOAD_FINISHED) {
                this.bytesDownloaded = this.totalBytes;
            } else if (this.state != State.DOWNLOAD_IN_PROGRESS) {
                this.bytesDownloaded = -1L;
                this.totalBytes = -1L;
            }
            if (this.state != State.ERROR) {
                this.errorStateCause = null;
            }
        }
        AutoUpdater.fireStateChanged(this);
    }

    public boolean isUpdateAvailable() {
        return AutoUpdater.isUmsUpdatable(this.currentVersion, SERVER_PROPERTIES.getLatestVersion());
    }

    private void downloadUpdate() throws UpdateException {
        String downloadUrl = SERVER_PROPERTIES.getDownloadUrl();
        File target = new File(CONFIGURATION.getProfileDirectory(), AutoUpdater.getTargetFilename());
        try {
            JavaHttpClient.getFile(target, downloadUrl, this);
        }
        catch (IOException e) {
            target.delete();
            this.wrapException("Cannot download update", e);
        }
    }

    private void wrapException(String message, Throwable cause) throws UpdateException {
        throw new UpdateException("Error: " + message, cause);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void progress(String uri, long bytesDownloaded, long totalBytes) {
        Object object = this.stateLock;
        synchronized (object) {
            this.bytesDownloaded = bytesDownloaded;
            this.totalBytes = totalBytes;
        }
        AutoUpdater.fireStateChanged(this);
    }

    @Override
    public boolean isCancelled() {
        boolean cancelled = this.isDownloadCancelled();
        if (cancelled) {
            this.setErrorState(new UpdateException("Download cancelled"));
        }
        return cancelled;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public State getState() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.state;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Throwable getErrorStateCause() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.errorStateCause;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getBytesDownloaded() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.bytesDownloaded;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalBytes() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.totalBytes;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void cancelDownload() {
        Object object = this.stateLock;
        synchronized (object) {
            this.downloadCancelled = true;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isDownloadCancelled() {
        Object object = this.stateLock;
        synchronized (object) {
            return this.downloadCancelled;
        }
    }

    public Version getLatestVersion() {
        return SERVER_PROPERTIES.getLatestVersion();
    }

    public Version getLatestVersionPatreon() {
        return SERVER_PROPERTIES.getLatestVersionPatreon();
    }

    public String getPatreonDownloadUrl() {
        return SERVER_PROPERTIES.getPatreonDownloadUrl();
    }

    private static String getTargetFilename() {
        String filename = "new-version.";
        String fileExtension = "tgz";
        if (Platform.isWindows()) {
            fileExtension = "exe";
        }
        if (Platform.isMac()) {
            fileExtension = "dmg";
        }
        return filename + fileExtension;
    }

    public static boolean isUmsUpdatable(Version vFrom, Version vTo) {
        return vTo.isGreaterThan(vFrom);
    }

    public static enum State {
        NOTHING_KNOWN,
        POLLING_SERVER,
        NO_UPDATE_AVAILABLE,
        UPDATE_AVAILABLE,
        DOWNLOAD_IN_PROGRESS,
        DOWNLOAD_FINISHED,
        EXECUTING_SETUP,
        ERROR;

    }
}

