/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.sun.jna.Platform;
import java.io.IOException;
import java.util.ArrayList;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.pms.Messages;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EncodingFormat;
import net.pms.encoders.Engine;
import net.pms.encoders.EngineId;
import net.pms.encoders.StandardEngineId;
import net.pms.formats.Format;
import net.pms.io.IPipeProcess;
import net.pms.io.ListProcessWrapperResult;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.SimpleProcessWrapper;
import net.pms.media.MediaInfo;
import net.pms.platform.PlatformUtils;
import net.pms.store.StoreItem;
import net.pms.util.ExecutableErrorType;
import net.pms.util.ExecutableInfo;
import net.pms.util.PlayerUtil;
import net.pms.util.UMSUtils;
import net.pms.util.Version;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VideoLanVideoStreaming
extends Engine {
    private static final Logger LOGGER = LoggerFactory.getLogger(VideoLanVideoStreaming.class);
    public static final EngineId ID = StandardEngineId.VLC_VIDEO_STREAMING;
    public static final String KEY_VLC_PATH = "vlc_path";
    public static final String KEY_VLC_LEGACY_EXECUTABLE_TYPE = "vlc_legacy_executable_type";
    public static final String NAME = "VLC Web Video (Legacy)";

    VideoLanVideoStreaming() {
        super(CONFIGURATION.getVLCPaths());
    }

    @Override
    public int purpose() {
        return 2;
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public String getConfigurablePathKey() {
        return KEY_VLC_PATH;
    }

    @Override
    public String getExecutableTypeKey() {
        return KEY_VLC_LEGACY_EXECUTABLE_TYPE;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int type() {
        return 4;
    }

    @Override
    public String getMimeType() {
        return "video/mpeg";
    }

    protected String getEncodingArgs() {
        return "vcodec=mp2v,vb=4096,scale=1,acodec=mp2a,ab=128,channels=2";
    }

    protected String getMux() {
        return "ts";
    }

    @Override
    public ProcessWrapper launchTranscode(StoreItem resource, MediaInfo media, OutputParams params) throws IOException {
        UmsConfiguration configuration = params.getMediaRenderer().getUmsConfiguration();
        boolean isWindows = Platform.isWindows();
        String filename = resource.getFileName();
        IPipeProcess tsPipe = PlatformUtils.INSTANCE.getPipeProcess("VLC" + System.currentTimeMillis() + "." + this.getMux(), new String[0]);
        ProcessWrapper pipeProcess = tsPipe.getPipeProcess();
        pipeProcess.runInNewThread();
        tsPipe.deleteLater();
        params.getInputPipes()[0] = tsPipe;
        params.setMinBufferSize(params.getMinFileSize());
        params.setSecondReadMinSize(100000);
        ArrayList<Object> cmdList = new ArrayList<Object>();
        cmdList.add(this.getExecutable());
        cmdList.add("-I");
        cmdList.add("dummy");
        String transcodeSpec = String.format("#transcode{%s}:standard{access=file,mux=%s,dst=\"%s%s\"}", this.getEncodingArgs(), this.getMux(), isWindows ? "\\\\" : "", tsPipe.getInputPipe());
        if (isWindows) {
            cmdList.add("--dummy-quiet");
        }
        if (isWindows || Platform.isMac()) {
            cmdList.add("--sout=" + transcodeSpec);
        } else {
            cmdList.add("--sout");
            cmdList.add(transcodeSpec);
        }
        if (Platform.isMac()) {
            cmdList.add("");
        }
        cmdList.add(filename);
        cmdList.add("vlc://quit");
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.attachProcess(pipeProcess);
        UMSUtils.sleep(150);
        pw.runInNewThread();
        return pw;
    }

    @Override
    public boolean isCompatible(StoreItem item) {
        return PlayerUtil.isWebVideo(item);
    }

    @Override
    public boolean isCompatible(EncodingFormat encodingFormat) {
        return encodingFormat.isVideoFormat() && !encodingFormat.isTranscodeToHLS();
    }

    @Override
    public boolean excludeFormat(Format extension) {
        return false;
    }

    @Override
    @Nullable
    public ExecutableInfo testExecutable(@Nonnull ExecutableInfo executableInfo) {
        if (Boolean.FALSE.equals((executableInfo = this.testExecutableFile(executableInfo)).getAvailable())) {
            return executableInfo;
        }
        ExecutableInfo.ExecutableInfoBuilder result = executableInfo.modify();
        if (Platform.isWindows()) {
            if (executableInfo.getPath().isAbsolute() && executableInfo.getPath().equals(PlatformUtils.INSTANCE.getVlcPath())) {
                result.version(PlatformUtils.INSTANCE.getVlcVersion());
            }
            result.available(Boolean.TRUE);
        } else {
            String arg = "--version";
            try {
                ListProcessWrapperResult output = SimpleProcessWrapper.runProcessListOutput(30000L, 1000L, executableInfo.getPath().toString(), "--version");
                if (output.getError() != null) {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + " \n" + output.getError().getMessage());
                    result.available(Boolean.FALSE);
                    LOGGER.debug("\"{} {}\" failed with error: {}", executableInfo.getPath(), "--version", output.getError().getMessage());
                    return result.build();
                }
                if (output.getExitCode() == 0) {
                    Pattern pattern;
                    Matcher matcher;
                    if (!output.getOutput().isEmpty() && (matcher = (pattern = Pattern.compile("VLC version\\s+[^\\(]*\\(([^\\)]*)", 2)).matcher((CharSequence)output.getOutput().get(0))).find() && StringUtils.isNotBlank(matcher.group(1))) {
                        result.version(new Version(matcher.group(1)));
                    }
                    result.available(Boolean.TRUE);
                } else {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineNotAvailableExitCode"), this, output.getExitCode()));
                    result.available(Boolean.FALSE);
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                return null;
            }
        }
        if (result.version() != null) {
            Version requiredVersion = new Version("2.0.2");
            if (result.version().compareTo(requiredVersion) <= 0) {
                result.errorType(ExecutableErrorType.GENERAL);
                result.errorText(String.format(Messages.getString("OnlyVersionXAboveSupported"), requiredVersion, this));
                result.available(Boolean.FALSE);
                LOGGER.warn(String.format(Messages.getRootString("OnlyVersionXAboveSupported"), requiredVersion, this));
            }
        } else if (Boolean.TRUE.equals(result.available())) {
            LOGGER.warn("Could not parse VLC version, the version might be too low (< 2.0.2)");
        }
        return result.build();
    }

    @Override
    protected boolean isSpecificTest() {
        return false;
    }
}

