/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.util.ArrayList;
import java.util.List;
import net.pms.encoders.EncodingFormat;
import net.pms.encoders.Engine;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.EngineId;
import net.pms.encoders.ImageEngine;
import net.pms.encoders.StandardEngineId;
import net.pms.formats.FormatFactory;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TranscodingSettings {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatFactory.class);
    private final Engine engine;
    private final EncodingFormat encodingFormat;

    public TranscodingSettings(Engine engine, EncodingFormat encodingFormat) {
        this.engine = engine;
        this.encodingFormat = encodingFormat;
    }

    public Engine getEngine() {
        return this.engine;
    }

    public EncodingFormat getEncodingFormat() {
        return this.encodingFormat;
    }

    public String getMimeType(StoreItem item) {
        String mimeType = this.getEngine().getMimeType();
        if (mimeType == null) {
            return null;
        }
        Object matchedMimeType = null;
        if (item.getDefaultRenderer().isUseMediaInfo() && ("video/transcode".equals(mimeType) || "audio/transcode".equals(mimeType))) {
            matchedMimeType = item.getDefaultRenderer().getFormatConfiguration().getMatchedMIMEtype(this.getEncodingFormat().getTranscodingContainer(), this.getEncodingFormat().getTranscodingVideoCodec(), this.getEncodingFormat().getTranscodingAudioCodec());
        }
        if (matchedMimeType == null) {
            if ("video/transcode".equals(mimeType)) {
                matchedMimeType = this.getEncodingFormat().isTranscodeToWMV() ? "video/x-ms-wmv" : (this.getEncodingFormat().isTranscodeToMPEGTS() ? "video/vnd.dlna.mpeg-tts" : (this.getEncodingFormat().isTranscodeToMP4() ? "video/mp4" : "video/mpeg"));
            } else if ("audio/transcode".equals(mimeType)) {
                matchedMimeType = this.getEncodingFormat().isTranscodeToWAV() ? "audio/wav" : (this.getEncodingFormat().isTranscodeToMP3() ? "audio/mpeg" : "audio/L16");
            }
        }
        if ("audio/transcode".equals(mimeType) && "audio/L16".equals(matchedMimeType)) {
            MediaInfo mediaInfo = item.getMediaInfo();
            if (item.getDefaultRenderer().getUmsConfiguration().isAudioResample()) {
                matchedMimeType = item.getDefaultRenderer().isTranscodeAudioTo441() ? (String)matchedMimeType + ";rate=44100;channels=2" : (String)matchedMimeType + ";rate=48000;channels=2";
            } else if (mediaInfo != null && mediaInfo.getDefaultAudioTrack() != null) {
                MediaAudio audio = mediaInfo.getDefaultAudioTrack();
                if (audio.getSampleRate() > 0) {
                    matchedMimeType = (String)matchedMimeType + ";rate=" + Integer.toString(audio.getSampleRate());
                }
                if (audio.getNumberOfChannels() > 0) {
                    matchedMimeType = (String)matchedMimeType + ";channels=" + Integer.toString(audio.getNumberOfChannels());
                }
            }
        }
        if (matchedMimeType == null) {
            matchedMimeType = mimeType;
        }
        if (item.getDefaultRenderer().getMimeTranslations().containsKey(matchedMimeType)) {
            return item.getDefaultRenderer().getMimeTranslations().get(matchedMimeType);
        }
        return matchedMimeType;
    }

    public String getId() {
        return this.engine.getEngineId() + "|" + this.encodingFormat;
    }

    public String toString() {
        return this.engine + " (" + this.encodingFormat + ")";
    }

    public static TranscodingSettings getBestTranscodingSettings(StoreItem item) {
        if (item == null) {
            LOGGER.warn("Invalid resource (null): no engine found");
            return null;
        }
        LOGGER.trace("Getting engine for resource \"{}\"", (Object)item.getName());
        boolean isImage = item.getMediaInfo() != null && item.getMediaInfo().isImage();
        List<EncodingFormat> encodingFormats = item.getDefaultRenderer().getTranscodingFormats();
        List<Engine> engines = EngineFactory.getEngines();
        for (EncodingFormat encodingFormat : encodingFormats) {
            for (Engine engine : engines) {
                boolean compatible;
                if (isImage && !(engine instanceof ImageEngine)) continue;
                boolean bl = compatible = engine.isCompatible(encodingFormat) && engine.isCompatible(item);
                if (compatible) {
                    LOGGER.trace("Returning compatible engine \"{}\"", (Object)engine.getName());
                    return new TranscodingSettings(engine, encodingFormat);
                }
                if (!LOGGER.isTraceEnabled()) continue;
                LOGGER.trace("Engine \"{}\" is incompatible", (Object)engine.getName());
            }
        }
        LOGGER.trace("No engine found for {}", (Object)item.getName());
        return null;
    }

    public static List<TranscodingSettings> getTranscodingsSettings(StoreItem item) {
        ArrayList<TranscodingSettings> compatibleEngines = new ArrayList<TranscodingSettings>();
        if (item == null) {
            return compatibleEngines;
        }
        List<EncodingFormat> encodingFormats = item.getDefaultRenderer().getTranscodingFormats();
        List<Engine> engines = EngineFactory.getEngines();
        for (EncodingFormat encodingFormat : encodingFormats) {
            for (Engine engine : engines) {
                if (!engine.isCompatible(encodingFormat) || !engine.isCompatible(item)) continue;
                LOGGER.trace("Engine {} is compatible with resource \"{}\"", (Object)engine.getName(), (Object)item.getName());
                compatibleEngines.add(new TranscodingSettings(engine, encodingFormat));
            }
        }
        return compatibleEngines;
    }

    public static List<TranscodingSettings> getTranscodingsSettings(Renderer renderer) {
        ArrayList<TranscodingSettings> availableEngines = new ArrayList<TranscodingSettings>();
        if (renderer == null) {
            return availableEngines;
        }
        List<EncodingFormat> encodingFormats = renderer.getTranscodingFormats();
        List<Engine> engines = EngineFactory.getEngines();
        for (EncodingFormat encodingFormat : encodingFormats) {
            for (Engine engine : engines) {
                availableEngines.add(new TranscodingSettings(engine, encodingFormat));
            }
        }
        return availableEngines;
    }

    public static TranscodingSettings getTranscodingSettings(String transcodingId) {
        if (StringUtils.isBlank(transcodingId) || !transcodingId.contains("|")) {
            return null;
        }
        String[] transcodingParts = transcodingId.split("\\|");
        String engineIdString = transcodingParts[0].trim();
        String encodingFormatName = transcodingParts[1].trim();
        EngineId engineId = StandardEngineId.toEngineID(engineIdString);
        EncodingFormat encodingFormat = EncodingFormat.getEncodingFormat(encodingFormatName);
        if (engineId != null && encodingFormat != null) {
            Engine engine = EngineFactory.getEngine(engineId, false, false);
            return new TranscodingSettings(engine, encodingFormat);
        }
        return null;
    }
}

