/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import javax.annotation.concurrent.Immutable;
import net.pms.encoders.EngineId;
import net.pms.platform.PlatformUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Immutable
public class StandardEngineId
extends EngineId {
    private static final Logger LOGGER = LoggerFactory.getLogger(StandardEngineId.class);
    public static final EngineId AVI_SYNTH_FFMPEG = new StandardEngineId("AviSynthFFmpeg");
    public static final EngineId AVI_SYNTH_MENCODER = new StandardEngineId("AviSynthMEncoder");
    public static final EngineId FFMPEG_AUDIO = new StandardEngineId("FFmpegAudio");
    public static final EngineId FFMPEG_VIDEO = new StandardEngineId("FFmpegVideo");
    public static final EngineId FFMPEG_HLS_VIDEO = new StandardEngineId("FFmpegHlsVideo");
    public static final EngineId FFMPEG_WEB_VIDEO = new StandardEngineId("FFmpegWebVideo");
    public static final EngineId MENCODER_VIDEO = new StandardEngineId("MEncoderVideo");
    public static final EngineId MENCODER_WEB_VIDEO = new StandardEngineId("MEncoderWebVideo");
    public static final EngineId DCRAW = new StandardEngineId("DCRaw");
    public static final EngineId TSMUXER_AUDIO = new StandardEngineId("tsMuxeRAudio");
    public static final EngineId TSMUXER_VIDEO = new StandardEngineId("tsMuxeRVideo");
    public static final EngineId VLC_AUDIO_STREAMING = new StandardEngineId("VLCAudioStreaming");
    public static final EngineId VLC_VIDEO_STREAMING = new StandardEngineId("VLCVideoStreaming");
    public static final EngineId VLC_VIDEO = new StandardEngineId("VLCVideo");
    public static final EngineId VLC_WEB_VIDEO = new StandardEngineId("VLCWebVideo");
    public static final EngineId YOUTUBE_DL = new StandardEngineId("youtubeDl");
    public static final List<EngineId> ALL;
    protected final String engineIdName;

    private StandardEngineId(String engineIdName) {
        this.engineIdName = engineIdName;
    }

    @Override
    public String getName() {
        return this.engineIdName;
    }

    public static EngineId toEngineID(String engineIdString) {
        if (StringUtils.isBlank(engineIdString)) {
            return null;
        }
        switch (engineIdString = engineIdString.trim().toUpperCase(Locale.ROOT)) {
            case "AVISYNTHFFMPEG": {
                return AVI_SYNTH_FFMPEG;
            }
            case "AVISYNTHMENCODER": {
                return AVI_SYNTH_MENCODER;
            }
            case "FFMPEGAUDIO": {
                return FFMPEG_AUDIO;
            }
            case "FFMPEGVIDEO": {
                return FFMPEG_VIDEO;
            }
            case "FFMPEGHLSVIDEO": {
                return FFMPEG_HLS_VIDEO;
            }
            case "FFMPEGWEBVIDEO": {
                return FFMPEG_WEB_VIDEO;
            }
            case "MENCODER": 
            case "MENCODERVIDEO": {
                return MENCODER_VIDEO;
            }
            case "MENCODERWEBVIDEO": {
                return MENCODER_WEB_VIDEO;
            }
            case "DCRAW": {
                return DCRAW;
            }
            case "TSMUXERAUDIO": {
                return TSMUXER_AUDIO;
            }
            case "TSMUXER": 
            case "TSMUXERVIDEO": {
                return TSMUXER_VIDEO;
            }
            case "VLCAUDIO": 
            case "VLCAUDIOSTREAMING": {
                return VLC_AUDIO_STREAMING;
            }
            case "VLCVIDEOSTREAMING": {
                return VLC_VIDEO_STREAMING;
            }
            case "VLCTRANSCODER": 
            case "VLCVIDEO": {
                return VLC_VIDEO;
            }
            case "VLCWEBVIDEO": {
                return VLC_WEB_VIDEO;
            }
            case "YOUTUBEDL": {
                return YOUTUBE_DL;
            }
        }
        LOGGER.warn("Could not parse engine id \"{}\"", (Object)engineIdString);
        return null;
    }

    static {
        ArrayList<EngineId> allEngines = new ArrayList<EngineId>(12);
        allEngines.add(FFMPEG_VIDEO);
        if (PlatformUtils.isWindows()) {
            allEngines.add(AVI_SYNTH_FFMPEG);
        }
        allEngines.add(MENCODER_VIDEO);
        if (PlatformUtils.isWindows()) {
            allEngines.add(AVI_SYNTH_MENCODER);
        }
        allEngines.add(TSMUXER_VIDEO);
        allEngines.add(VLC_VIDEO);
        allEngines.add(FFMPEG_AUDIO);
        allEngines.add(TSMUXER_AUDIO);
        allEngines.add(FFMPEG_HLS_VIDEO);
        allEngines.add(FFMPEG_WEB_VIDEO);
        allEngines.add(VLC_WEB_VIDEO);
        allEngines.add(VLC_VIDEO_STREAMING);
        allEngines.add(MENCODER_WEB_VIDEO);
        allEngines.add(VLC_AUDIO_STREAMING);
        allEngines.add(DCRAW);
        allEngines.add(YOUTUBE_DL);
        ALL = Collections.unmodifiableList(allEngines);
    }
}

