/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import bsh.EvalError;
import bsh.Interpreter;
import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.pms.Messages;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.AviSynthMEncoder;
import net.pms.encoders.EncodingFormat;
import net.pms.encoders.Engine;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.EngineId;
import net.pms.encoders.StandardEngineId;
import net.pms.encoders.TsMuxeRVideo;
import net.pms.formats.Format;
import net.pms.formats.v2.SubtitleType;
import net.pms.io.IPipeProcess;
import net.pms.io.ListProcessWrapperResult;
import net.pms.io.OutputParams;
import net.pms.io.PipeIPCProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.SimpleProcessWrapper;
import net.pms.io.StreamModifier;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.platform.PlatformUtils;
import net.pms.platform.windows.NTStatus;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.store.item.DVDISOTitle;
import net.pms.util.CodecUtil;
import net.pms.util.ExecutableErrorType;
import net.pms.util.ExecutableInfo;
import net.pms.util.FileUtil;
import net.pms.util.InputFile;
import net.pms.util.PlayerUtil;
import net.pms.util.ProcessUtil;
import net.pms.util.StringUtil;
import net.pms.util.SubtitleUtils;
import net.pms.util.UMSUtils;
import net.pms.util.Version;
import org.apache.commons.lang.BooleanUtils;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MEncoderVideo
extends Engine {
    private static final Logger LOGGER = LoggerFactory.getLogger(MEncoderVideo.class);
    public static final EngineId ID = StandardEngineId.MENCODER_VIDEO;
    public static final String KEY_MENCODER_PATH = "mencoder_path";
    public static final String KEY_MENCODER_EXECUTABLE_TYPE = "mencoder_executable_type";
    public static final String NAME = "MEncoder Video";
    private static final String REMOVE_OPTION = "---REMOVE-ME---";
    private static final String[] INVALID_CUSTOM_OPTIONS = new String[]{"-of", "-oac", "-ovc", "-mpegopts"};
    private static final String INVALID_CUSTOM_OPTIONS_LIST = Arrays.toString(INVALID_CUSTOM_OPTIONS);
    public static final int MENCODER_MAX_THREADS = 8;
    public static final String DEFAULT_CODEC_CONF_SCRIPT = Messages.getString("MencoderConfigScript.1.HereYouCanInputSpecific") + Messages.getString("MencoderConfigScript.2.WarningThisShouldNot") + Messages.getString("MencoderConfigScript.3.SyntaxIsJavaCondition") + Messages.getString("MencoderConfigScript.4.AuthorizedVariables") + Messages.getString("MencoderConfigScript.5.SpecialOptions") + Messages.getString("MencoderConfigScript.6.Noass") + Messages.getString("MencoderConfigScript.7.Nosync") + Messages.getString("MencoderConfigScript.8.Quality") + Messages.getString("MencoderConfigScript.9.Nomux") + "\ncontainer == iso :: -nosync\n(container == avi || container == matroska) && vcodec == mpeg4 && acodec == mp3 :: -mc 0.1\ncontainer == flv :: -mc 0.1\ncontainer == mov :: -mc 0.1\ncontainer == rm  :: -mc 0.1\ncontainer == mp4 && vcodec == h264 :: -mc 0.1\n\n" + Messages.getString("MencoderConfigScript.10.YouCanPut") + Messages.getString("MencoderConfigScript.11.ToRemoveJudder") + Messages.getString("MencoderConfigScript.12.ToRemux");

    MEncoderVideo() {
        super(CONFIGURATION.getMEncoderPaths());
    }

    @Override
    public int purpose() {
        return 0;
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public String getConfigurablePathKey() {
        return KEY_MENCODER_PATH;
    }

    @Override
    public String getExecutableTypeKey() {
        return KEY_MENCODER_EXECUTABLE_TYPE;
    }

    @Override
    public boolean isAviSynthEngine() {
        return false;
    }

    @Override
    public boolean isTimeSeekable() {
        return true;
    }

    private String[] getDefaultArgs(EncodeOptions options) {
        ArrayList<String> defaultArgsList = new ArrayList<String>();
        defaultArgsList.add("-msglevel");
        defaultArgsList.add("statusline=2");
        defaultArgsList.add("-oac");
        if (options.ac3Remux || options.dtsRemux) {
            defaultArgsList.add("copy");
        } else if (options.pcm) {
            defaultArgsList.add("pcm");
        } else if (options.isTranscodeToAAC) {
            defaultArgsList.add("faac");
            defaultArgsList.add("-faacopts");
            defaultArgsList.add("br=320:mpeg=4:object=2");
        } else {
            defaultArgsList.add("lavc");
        }
        defaultArgsList.add("-of");
        if (options.wmv || options.isTranscodeToMPEGTS) {
            defaultArgsList.add("lavf");
        } else if (options.pcm && this.isAviSynthEngine()) {
            defaultArgsList.add("avi");
        } else if (options.pcm || options.dtsRemux || options.encodedAudioPassthrough) {
            defaultArgsList.add("rawvideo");
        } else {
            defaultArgsList.add("mpeg");
        }
        if (options.wmv) {
            defaultArgsList.add("-lavfopts");
            defaultArgsList.add("format=asf");
        } else if (options.isTranscodeToMPEGTS) {
            defaultArgsList.add("-lavfopts");
            defaultArgsList.add("format=mpegts");
        }
        if (!options.isTranscodeToH264) {
            defaultArgsList.add("-mpegopts");
            defaultArgsList.add("format=mpeg2:muxrate=500000:vbuf_size=1194:abuf_size=64");
        }
        defaultArgsList.add("-ovc");
        String ovc = "lavc";
        if (options.ovccopy) {
            ovc = "copy";
        } else if (options.isTranscodeToH264) {
            ovc = "x264";
        }
        defaultArgsList.add(ovc);
        String[] defaultArgsArray = new String[defaultArgsList.size()];
        defaultArgsList.toArray(defaultArgsArray);
        return defaultArgsArray;
    }

    private static String[] sanitizeArgs(String[] args) {
        ArrayList<String> sanitized = new ArrayList<String>();
        for (int i = 0; i < args.length; ++i) {
            String name = args[i];
            Object value = null;
            for (String option : INVALID_CUSTOM_OPTIONS) {
                if (!option.equals(name)) continue;
                if (i + 1 < args.length) {
                    value = " " + args[i + 1];
                    ++i;
                } else {
                    value = "";
                }
                LOGGER.warn("Ignoring custom MEncoder option: {}{}; the following options cannot be changed: " + INVALID_CUSTOM_OPTIONS_LIST, (Object)name, value);
                break;
            }
            if (value != null) continue;
            sanitized.add(args[i]);
        }
        return (String[])sanitized.toArray(String[]::new);
    }

    private String[] args(EncodeOptions options) {
        String[] defaultArgs = this.getDefaultArgs(options);
        String[] args = options.overriddenMainArgs != null ? ArrayUtils.addAll(defaultArgs, MEncoderVideo.sanitizeArgs(options.overriddenMainArgs)) : defaultArgs;
        return args;
    }

    private static int[] getVideoBitrateConfig(String bitrate) {
        int[] bitrates = new int[2];
        if (bitrate.contains("(") && bitrate.contains(")")) {
            try {
                bitrates[1] = Integer.parseInt(bitrate.substring(bitrate.indexOf(40) + 1, bitrate.indexOf(41)));
            }
            catch (NumberFormatException e) {
                bitrates[1] = 0;
            }
        }
        if (bitrate.contains("(")) {
            bitrate = bitrate.substring(0, bitrate.indexOf(40)).trim();
        }
        if (StringUtils.isBlank(bitrate)) {
            bitrate = "0";
        }
        try {
            bitrates[0] = (int)Double.parseDouble(bitrate);
        }
        catch (NumberFormatException e) {
            bitrates[0] = 0;
        }
        return bitrates;
    }

    private String addMaximumBitrateConstraints(EncodeOptions encodeOptions, String encodeSettings, MediaInfo media, String quality, Renderer renderer, String audioType, EncodingFormat encodingFormat) {
        UmsConfiguration configuration = renderer.getUmsConfiguration();
        MediaVideo defaultVideoTrack = media.getDefaultVideoTrack();
        int[] defaultMaxBitrates = MEncoderVideo.getVideoBitrateConfig(configuration.getMaximumBitrate());
        int[] rendererMaxBitrates = new int[2];
        if (renderer.getMaxVideoBitrate() > 0) {
            rendererMaxBitrates = MEncoderVideo.getVideoBitrateConfig(Integer.toString(renderer.getMaxVideoBitrate()));
        }
        if (rendererMaxBitrates[0] > 0 && rendererMaxBitrates[0] < defaultMaxBitrates[0]) {
            LOGGER.trace("Using video bitrate limit from {} configuration ({} Mb/s) because it is lower than the general configuration bitrate limit ({} Mb/s)", renderer.getRendererName(), rendererMaxBitrates[0], defaultMaxBitrates[0]);
            defaultMaxBitrates = rendererMaxBitrates;
        } else {
            LOGGER.trace("Using video bitrate limit from the general configuration ({} Mb/s)", (Object)defaultMaxBitrates[0]);
        }
        if (!(renderer.getCBRVideoBitrate() != 0 || quality.contains("vrc_buf_size") || quality.contains("vrc_maxrate") || quality.contains("vbitrate"))) {
            boolean isXboxOneWebVideo;
            defaultMaxBitrates[0] = 1000 * defaultMaxBitrates[0];
            if (renderer.isHalveBitrate() && !configuration.isAutomaticMaximumBitrate()) {
                defaultMaxBitrates[0] = defaultMaxBitrates[0] / 2;
                LOGGER.trace("Halving the video bitrate limit to {} kb/s", (Object)defaultMaxBitrates[0]);
            }
            int bufSize = 1835;
            boolean bitrateLevel41Limited = false;
            boolean bl = isXboxOneWebVideo = renderer.isXboxOne() && this.purpose() == 2;
            if ((encodingFormat.isTranscodeToH264() || encodingFormat.isTranscodeToH265()) && !isXboxOneWebVideo) {
                if (renderer.getH264LevelLimit() < 4.2 && defaultMaxBitrates[0] > 31250) {
                    defaultMaxBitrates[0] = 31250;
                    bitrateLevel41Limited = true;
                    LOGGER.trace("Adjusting the video bitrate limit to the H.264 Level 4.1-safe value of 31250 kb/s");
                }
                bufSize = defaultMaxBitrates[0];
            } else {
                if (defaultVideoTrack != null && defaultVideoTrack.isHDVideo()) {
                    bufSize = defaultMaxBitrates[0] / 3;
                }
                if (bufSize > 7000) {
                    bufSize = 7000;
                }
                if (defaultMaxBitrates[1] > 0) {
                    bufSize = defaultMaxBitrates[1];
                }
                if (renderer.isDefaultVBVSize() && rendererMaxBitrates[1] == 0) {
                    bufSize = 1835;
                }
            }
            if (!bitrateLevel41Limited) {
                switch (audioType) {
                    case "pcm": {
                        defaultMaxBitrates[0] = defaultMaxBitrates[0] - 4600;
                        break;
                    }
                    case "dts": {
                        defaultMaxBitrates[0] = defaultMaxBitrates[0] - 1510;
                        break;
                    }
                    case "aac": 
                    case "ac3": {
                        defaultMaxBitrates[0] = defaultMaxBitrates[0] - configuration.getAudioBitrate();
                        break;
                    }
                }
                defaultMaxBitrates[0] = defaultMaxBitrates[0] / 1000 * 1000;
                LOGGER.trace("Adjusting the video bitrate limit to {} kb/s to make room for audio", (Object)defaultMaxBitrates[0]);
            }
            encodeSettings = encodeOptions.isTranscodeToH264 ? (String)encodeSettings + ":vbv_maxrate=" + defaultMaxBitrates[0] + ":vbv_bufsize=" + bufSize : (String)encodeSettings + ":vrc_maxrate=" + defaultMaxBitrates[0] + ":vrc_buf_size=" + bufSize;
        }
        return encodeSettings;
    }

    private boolean isDisableSubtitles(OutputParams params) {
        Renderer renderer = params.getMediaRenderer();
        UmsConfiguration configuration = renderer.getUmsConfiguration();
        return configuration.isDisableSubtitles() || params.getSid() == null || this.isAviSynthEngine();
    }

    @Override
    public ProcessWrapper launchTranscode(StoreItem item, MediaInfo media, OutputParams params) throws IOException {
        ProcessWrapperImpl pw;
        String framerate;
        int nThreads;
        EncodeOptions encodeOptions = new EncodeOptions();
        Renderer renderer = params.getMediaRenderer();
        UmsConfiguration configuration = renderer.getUmsConfiguration();
        params.manageFastStart();
        boolean avisynth = this.isAviSynthEngine();
        String filename = item.getFileName();
        EncodingFormat encodingFormat = item.getTranscodingSettings().getEncodingFormat();
        MEncoderVideo.setAudioAndSubs(item, params);
        MediaVideo defaultVideoTrack = media.getDefaultVideoTrack();
        String externalSubtitlesFileName = null;
        if (params.getSid() != null && params.getSid().isExternal()) {
            if (params.getSid().getExternalFile() != null) {
                if (params.getSid().isExternalFileUtf16()) {
                    File convertedSubtitles = new File(configuration.getTempFolder(), "utf8_" + params.getSid().getExternalFile().getName());
                    FileUtil.convertFileFromUtf16ToUtf8(params.getSid().getExternalFile(), convertedSubtitles);
                    externalSubtitlesFileName = ProcessUtil.getShortFileNameIfWideChars(convertedSubtitles.getAbsolutePath());
                } else {
                    externalSubtitlesFileName = ProcessUtil.getShortFileNameIfWideChars(params.getSid().getExternalFile());
                }
            } else {
                LOGGER.error("External subtitles file \"{}\" is unavailable", (Object)params.getSid().getName());
            }
        }
        InputFile newInput = new InputFile();
        newInput.setFilename(filename);
        newInput.setPush(params.getStdIn());
        boolean isDVD = item instanceof DVDISOTitle;
        encodeOptions.ovccopy = false;
        encodeOptions.pcm = false;
        encodeOptions.ac3Remux = false;
        encodeOptions.dtsRemux = false;
        encodeOptions.wmv = false;
        int intOCW = 0;
        int intOCH = 0;
        try {
            intOCW = Integer.parseInt(configuration.getMencoderOverscanCompensationWidth());
        }
        catch (NumberFormatException e) {
            LOGGER.error("Cannot parse configured MEncoder overscan compensation width: \"{}\"", (Object)configuration.getMencoderOverscanCompensationWidth());
        }
        try {
            intOCH = Integer.parseInt(configuration.getMencoderOverscanCompensationHeight());
        }
        catch (NumberFormatException e) {
            LOGGER.error("Cannot parse configured MEncoder overscan compensation height: \"{}\"", (Object)configuration.getMencoderOverscanCompensationHeight());
        }
        boolean deferToTsmuxer = true;
        String prependTraceReason = "Not muxing the video stream with tsMuxeR via MEncoder because ";
        if (!configuration.isMencoderMuxWhenCompatible()) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "the user setting is disabled");
        } else if (item.isInsideTranscodeFolder()) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "the file is being played via a MEncoder entry in the TRANSCODE folder.");
        } else if (!renderer.isVideoStreamTypeSupportedInTranscodingContainer(media, encodingFormat, "mpegts")) {
            deferToTsmuxer = false;
            LOGGER.debug(prependTraceReason + "the renderer does not support {} inside MPEG-TS.", (Object)defaultVideoTrack.getCodec());
        } else if (params.getSid() != null) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "we need to burn subtitles.");
        } else if (isDVD) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "this is a DVD track.");
        } else if (this.isAviSynthEngine()) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "we are using AviSynth.");
        } else if (defaultVideoTrack.isH264() && !this.isVideoWithinH264LevelLimits(defaultVideoTrack, renderer)) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "the video stream is not within H.264 level limits for this renderer.");
        } else if (!MEncoderVideo.isMuxable(defaultVideoTrack, renderer)) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "the video stream is not muxable to this renderer");
        } else if (intOCW > 0 && intOCH > 0) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "we need to transcode to apply overscan compensation.");
        } else if (!defaultVideoTrack.isDisplayAspectRatioFromCodec()) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "we need to transcode to apply the correct aspect ratio.");
        } else if (!renderer.isPS3() && this.isWebDl(filename, media, params)) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "the version of tsMuxeR supported by this renderer does not support WEB-DL files.");
        } else if ("bt.601".equals(defaultVideoTrack.getMatrixCoefficients())) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "the colorspace probably isn't supported by the renderer.");
        } else if ((renderer.isKeepAspectRatio() || renderer.isKeepAspectRatioTranscoding()) && !"16:9".equals(defaultVideoTrack.getDisplayAspectRatio())) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "the renderer needs us to add borders so it displays the correct aspect ratio of " + defaultVideoTrack.getDisplayAspectRatio() + ".");
        } else if (!renderer.isResolutionCompatibleWithRenderer(defaultVideoTrack.getWidth(), defaultVideoTrack.getHeight())) {
            deferToTsmuxer = false;
            LOGGER.trace(prependTraceReason + "the resolution is incompatible with the renderer.");
        } else if (!EngineFactory.isEngineAvailable(StandardEngineId.TSMUXER_VIDEO)) {
            deferToTsmuxer = false;
            LOGGER.warn(prependTraceReason + "the configured executable isn't available.");
        }
        if (deferToTsmuxer) {
            Object tv;
            expertOptions = MEncoderVideo.getSpecificCodecOptions(configuration.getMencoderCodecSpecificConfig(), media, params, filename, externalSubtitlesFileName, configuration.isMencoderIntelligentSync(), false);
            nomux = false;
            for (String s : expertOptions) {
                if (!s.equals("-nomux")) continue;
                nomux = true;
            }
            if (!nomux && (tv = (TsMuxeRVideo)EngineFactory.getEngine(StandardEngineId.TSMUXER_VIDEO, false, true)) != null) {
                params.setForceFps(MEncoderVideo.getValidFps(media.getFrameRate(), false));
                if (defaultVideoTrack.getCodec() != null) {
                    if (defaultVideoTrack.isH264()) {
                        params.setForceType("V_MPEG4/ISO/AVC");
                    } else if (defaultVideoTrack.getCodec().startsWith("mpeg2")) {
                        params.setForceType("V_MPEG-2");
                    } else if (defaultVideoTrack.getCodec().equals("vc1")) {
                        params.setForceType("V_MS/VFW/WVC1");
                    }
                }
                return ((TsMuxeRVideo)tv).launchTranscode(item, media, params);
            }
        } else if (params.getSid() == null && isDVD && configuration.isMencoderRemuxMPEG2() && renderer.isMpeg2Supported()) {
            expertOptions = MEncoderVideo.getSpecificCodecOptions(configuration.getMencoderCodecSpecificConfig(), media, params, filename, externalSubtitlesFileName, configuration.isMencoderIntelligentSync(), false);
            nomux = false;
            for (String s : expertOptions) {
                if (!s.equals("-nomux")) continue;
                nomux = true;
            }
            if (!nomux) {
                encodeOptions.ovccopy = true;
            }
        }
        encodeOptions.isTranscodeToMPEGTS = encodingFormat.isTranscodeToMPEGTS();
        encodeOptions.isTranscodeToH264 = encodingFormat.isTranscodeToH264() || encodingFormat.isTranscodeToH265();
        encodeOptions.isTranscodeToAAC = encodingFormat.isTranscodeToAAC();
        boolean isXboxOneWebVideo = renderer.isXboxOne() && this.purpose() == 2;
        String vcodec = "mpeg2video";
        if (encodeOptions.isTranscodeToH264) {
            vcodec = "libx264";
        } else if (encodingFormat.isTranscodeToWMV() && !renderer.isXbox360() || isXboxOneWebVideo) {
            encodeOptions.wmv = true;
            vcodec = "wmv2";
        }
        String rendererMencoderOptions = renderer.getCustomMencoderOptions();
        if (rendererMencoderOptions.contains("expand=") && isDVD) {
            rendererMencoderOptions = "";
        }
        String globalMencoderOptions = configuration.getMencoderCustomOptions();
        String combinedCustomOptions = StringUtils.defaultString(globalMencoderOptions) + " " + StringUtils.defaultString(rendererMencoderOptions);
        boolean hasAudioStream = params.getAid() != null;
        boolean isTsMuxeRVideoEngineActive = EngineFactory.isEngineActive(TsMuxeRVideo.ID);
        boolean mencoderAC3RemuxAudioDelayBug = hasAudioStream && params.getAid().getVideoDelay() != 0 && params.getTimeSeek() == 0.0;
        String add = "";
        int channels = 2;
        Object channelsString = "";
        if (hasAudioStream) {
            boolean bl = encodeOptions.encodedAudioPassthrough = isTsMuxeRVideoEngineActive && configuration.isEncodedAudioPassthrough() && renderer.isWrapEncodedAudioIntoPCM() && (!isDVD || configuration.isMencoderRemuxMPEG2()) && params.getAid().isNonPCMEncodedAudio() && !this.isAviSynthEngine() && renderer.isMuxLPCMToMpeg();
            if (configuration.isAudioRemuxAC3() && params.getAid().isAC3() && !this.isAviSynthEngine() && encodingFormat.isTranscodeToAC3() && !configuration.isMEncoderNormalizeVolume() && !combinedCustomOptions.contains("acodec=") && !encodeOptions.encodedAudioPassthrough && !isXboxOneWebVideo && params.getAid().getNumberOfChannels() <= configuration.getAudioChannelCount()) {
                encodeOptions.ac3Remux = true;
            } else {
                encodeOptions.dtsRemux = isTsMuxeRVideoEngineActive && configuration.isAudioEmbedDtsInPcm() && (!isDVD || configuration.isMencoderRemuxMPEG2()) && params.getAid() != null && params.getAid().isDTS() && !this.isAviSynthEngine() && renderer.isDTSPlayable() && !combinedCustomOptions.contains("acodec=");
                boolean bl2 = encodeOptions.pcm = !(!isTsMuxeRVideoEngineActive || !configuration.isAudioUsePCM() || isDVD && !configuration.isMencoderRemuxMPEG2() || media.getContainer().equals("mp4") && !defaultVideoTrack.isH264() || (!params.getAid().isDTS() || params.getAid().getNumberOfChannels() > 6) && !params.getAid().isLossless() && !params.getAid().isTrueHD() && (configuration.isMencoderUsePcmForHQAudioOnly() || !params.getAid().isAC3() && !params.getAid().isMP3() && !params.getAid().isAAC() && !params.getAid().isVorbis() && !params.getAid().isMpegAudio()) || !renderer.isLPCMPlayable() || combinedCustomOptions.contains("acodec="));
            }
            if (encodeOptions.dtsRemux || encodeOptions.pcm || encodeOptions.encodedAudioPassthrough) {
                params.setLosslessAudio(true);
                params.setForceFps(MEncoderVideo.getValidFps(media.getFrameRate(), false));
            }
            encodeOptions.ovccopy = false;
            if (encodeOptions.pcm && this.isAviSynthEngine()) {
                params.setAvidemux(true);
            }
            if (!combinedCustomOptions.contains("-lavdopts")) {
                add = " -lavdopts debug=0";
            }
            channels = encodeOptions.ac3Remux ? params.getAid().getNumberOfChannels() : (encodeOptions.dtsRemux || encodeOptions.encodedAudioPassthrough || !renderer.isXbox360() && encodeOptions.wmv ? 2 : (params.getAid().getNumberOfChannels() == 8 || params.getAid().isAAC() ? 2 : (encodeOptions.pcm ? params.getAid().getNumberOfChannels() : configuration.getAudioChannelCount())));
            if (!combinedCustomOptions.contains("-channels")) {
                channelsString = "-channels " + channels;
            }
        }
        StringTokenizer st = new StringTokenizer((String)channelsString + (String)(StringUtils.isNotBlank(globalMencoderOptions) ? " " + globalMencoderOptions : "") + (String)(StringUtils.isNotBlank(rendererMencoderOptions) ? " " + rendererMencoderOptions : "") + add, " ");
        encodeOptions.overriddenMainArgs = new String[st.countTokens()];
        int n = nThreads = isDVD || filename.toLowerCase().endsWith("dvr-ms") ? 1 : configuration.getMencoderMaxThreads();
        if (nThreads > 4) {
            nThreads = 4;
        }
        boolean handleToken = false;
        int i = 0;
        while (st.hasMoreTokens()) {
            Object token = st.nextToken().trim();
            if (handleToken) {
                token = (String)token + ":threads=" + nThreads;
                if (configuration.getSkipLoopFilterEnabled() && !this.isAviSynthEngine()) {
                    token = (String)token + ":skiploopfilter=all";
                }
                handleToken = false;
            }
            if (((String)token).toLowerCase().contains("lavdopts")) {
                handleToken = true;
            }
            encodeOptions.overriddenMainArgs[i++] = token;
        }
        Object vcodecString = ":vcodec=" + vcodec;
        if (combinedCustomOptions.contains("vcodec=")) {
            vcodecString = "";
        }
        if (configuration.getx264ConstantRateFactor() != null && encodeOptions.isTranscodeToH264 || configuration.getMPEG2MainSettings() != null && !encodeOptions.isTranscodeToH264) {
            int cbrBitrate = renderer.getCBRVideoBitrate();
            String cbrSettings = cbrBitrate > 0 ? ":vrc_buf_size=5000:vrc_minrate=" + cbrBitrate + ":vrc_maxrate=" + cbrBitrate + ":vbitrate=" + (cbrBitrate > 16000 ? cbrBitrate * 1000 : cbrBitrate) : "";
            String string = "";
            Object abitrate = "";
            if (!(encodeOptions.ac3Remux || encodeOptions.dtsRemux || encodeOptions.isTranscodeToAAC)) {
                if (!combinedCustomOptions.contains("acodec=")) {
                    String string2 = ":acodec=";
                    if (encodeOptions.wmv && !renderer.isXbox360()) {
                        String string3 = string2 + "wmav2";
                    } else {
                        String string4 = cbrSettings + string2;
                        if (encodingFormat.isTranscodeToAAC()) {
                            String string5 = string4 + "libfaac";
                        } else if (configuration.isMencoderAc3Fixed()) {
                            String string6 = string4 + "ac3_fixed";
                        } else {
                            String string7 = string4 + "ac3";
                        }
                    }
                }
                if (!combinedCustomOptions.contains("abitrate=")) {
                    abitrate = ":abitrate=";
                    abitrate = encodeOptions.wmv && !renderer.isXbox360() ? (String)abitrate + "448" : (String)abitrate + CodecUtil.getAC3Bitrate(configuration, params.getAid());
                }
            }
            int[] defaultMaxBitrates = MEncoderVideo.getVideoBitrateConfig(configuration.getMaximumBitrate());
            int[] rendererMaxBitrates = new int[2];
            if (renderer.getMaxVideoBitrate() > 0) {
                rendererMaxBitrates = MEncoderVideo.getVideoBitrateConfig(Integer.toString(renderer.getMaxVideoBitrate()));
            }
            if (rendererMaxBitrates[0] > 0 && rendererMaxBitrates[0] < defaultMaxBitrates[0]) {
                LOGGER.trace("Using video bitrate limit from {} configuration ({} Mb/s) because it is lower than the general configuration bitrate limit ({} Mb/s)", renderer.getRendererName(), rendererMaxBitrates[0], defaultMaxBitrates[0]);
            }
            String audioType = "ac3";
            if (encodeOptions.dtsRemux) {
                audioType = "dts";
            } else if (encodeOptions.pcm || encodeOptions.encodedAudioPassthrough) {
                audioType = "pcm";
            } else if (encodingFormat.isTranscodeToAAC()) {
                audioType = "aac";
            }
            Object encodeSettings = "";
            String aspectRatioLavcopts = "autoaspect=1";
            if (!(isDVD || !renderer.isKeepAspectRatio() && !renderer.isKeepAspectRatioTranscoding() || "16:9".equals(defaultVideoTrack.getDisplayAspectRatio()) || configuration.isMencoderScaler())) {
                aspectRatioLavcopts = "aspect=16/9";
            }
            if (isXboxOneWebVideo || configuration.getMPEG2MainSettings() != null && !encodeOptions.isTranscodeToH264) {
                String mpeg2Options = configuration.getMPEG2MainSettings();
                String mpeg2OptionsRenderer = renderer.getCustomMEncoderMPEG2Options();
                if (StringUtils.isNotBlank(mpeg2OptionsRenderer)) {
                    mpeg2Options = mpeg2OptionsRenderer;
                } else {
                    if (mpeg2Options.contains("/*")) {
                        mpeg2Options = mpeg2Options.substring(mpeg2Options.indexOf("/*"));
                    }
                    if (configuration.isAutomaticMaximumBitrate()) {
                        mpeg2Options = renderer.getAutomaticVideoQuality();
                    }
                    if (mpeg2Options.contains("Automatic")) {
                        mpeg2Options = mpeg2Options.contains("Wireless") ? (defaultVideoTrack.getWidth() > 1280 ? "keyint=25:vqmin=2:vqmax=7" : (defaultVideoTrack.getWidth() > 720 ? "keyint=25:vqmin=2:vqmax=5" : "keyint=25:vqmin=2:vqmax=3")) : "keyint=5:vqscale=1:vqmin=2:vqmax=3";
                    }
                    if (renderer.isPS3()) {
                        mpeg2Options = "keyint=25:vqscale=1:vqmin=2:vqmax=3";
                    }
                }
                encodeSettings = "-lavcopts " + aspectRatioLavcopts + (String)vcodecString + (String)var36_51 + (String)abitrate + ":threads=" + (encodeOptions.wmv && !renderer.isXbox360() ? 1 : configuration.getMencoderMaxThreads()) + (String)("".equals(mpeg2Options) ? "" : ":" + mpeg2Options);
                encodeSettings = this.addMaximumBitrateConstraints(encodeOptions, (String)encodeSettings, media, mpeg2Options, renderer, audioType, encodingFormat);
            } else if (configuration.getx264ConstantRateFactor() != null && encodeOptions.isTranscodeToH264) {
                String x264CRF = configuration.getx264ConstantRateFactor();
                if (configuration.isAutomaticMaximumBitrate()) {
                    x264CRF = renderer.getAutomaticVideoQuality();
                }
                if (x264CRF.contains("/*")) {
                    x264CRF = x264CRF.substring(x264CRF.indexOf("/*"));
                }
                if (x264CRF.contains("Automatic")) {
                    if (x264CRF.contains("Wireless")) {
                        x264CRF = "19";
                        if (defaultVideoTrack.getWidth() > 1280) {
                            x264CRF = "23";
                        } else if (defaultVideoTrack.getWidth() > 720) {
                            x264CRF = "22";
                        }
                    } else {
                        x264CRF = "16";
                        if (defaultVideoTrack.getWidth() > 720 && !encodingFormat.isTranscodeToH265()) {
                            x264CRF = "19";
                        }
                    }
                }
                encodeSettings = "-lavcopts " + aspectRatioLavcopts + (String)var36_51 + (String)abitrate + ":threads=" + configuration.getMencoderMaxThreads();
                encodeSettings = (String)encodeSettings + " -x264encopts crf=" + x264CRF + ":preset=superfast:level=31:threads=auto";
                encodeSettings = this.addMaximumBitrateConstraints(encodeOptions, (String)encodeSettings, media, "", renderer, audioType, encodingFormat);
            }
            st = new StringTokenizer((String)encodeSettings, " ");
            int ii = encodeOptions.overriddenMainArgs.length;
            encodeOptions.overriddenMainArgs = Arrays.copyOf(encodeOptions.overriddenMainArgs, encodeOptions.overriddenMainArgs.length + st.countTokens());
            while (st.hasMoreTokens()) {
                encodeOptions.overriddenMainArgs[ii++] = st.nextToken();
            }
        }
        boolean foundNoassParam = false;
        String[] expertOptions = MEncoderVideo.getSpecificCodecOptions(configuration.getMencoderCodecSpecificConfig(), media, params, filename, externalSubtitlesFileName, configuration.isMencoderIntelligentSync(), false);
        if (expertOptions != null) {
            for (String s : expertOptions) {
                if (!s.equals("-noass")) continue;
                foundNoassParam = true;
            }
        }
        StringBuilder stringBuilder = new StringBuilder();
        if (!this.isDisableSubtitles(params)) {
            boolean applyAssStyling;
            int subtitleMargin = 0;
            int userMargin = 0;
            boolean bl = applyAssStyling = params.getSid().getType() != SubtitleType.VOBSUB && params.getSid().getType() != SubtitleType.PGS && configuration.isMencoderAss() && !foundNoassParam && !isDVD;
            if (applyAssStyling) {
                String font;
                boolean overrideAssStyle;
                stringBuilder.append("-ass ");
                boolean bl3 = overrideAssStyle = !configuration.isUseEmbeddedSubtitlesStyle() || params.getSid().getType() == SubtitleType.SUBRIP || params.getSid().getType() == SubtitleType.TX3G;
                if (overrideAssStyle) {
                    String assSubColor = configuration.getSubsColor().getMEncoderHexValue();
                    stringBuilder.append("-ass-color ").append(assSubColor).append(" -ass-border-color 00000000 -ass-font-scale ").append(configuration.getAssScale());
                    if (StringUtils.isNotBlank(configuration.getFont())) {
                        stringBuilder.append(" -font ").append(StringUtil.quoteArg(configuration.getFont())).append(' ');
                        font = CodecUtil.isFontRegisteredInOS(configuration.getFont());
                        if (font != null) {
                            stringBuilder.append(" -ass-force-style FontName=").append(StringUtil.quoteArg(font)).append(',');
                        }
                    } else {
                        font = CodecUtil.getDefaultFontPath();
                        if (StringUtils.isNotBlank(font)) {
                            stringBuilder.append(" -font ").append(StringUtil.quoteArg(font)).append(' ');
                            String fontName = CodecUtil.isFontRegisteredInOS(font);
                            if (fontName != null) {
                                stringBuilder.append(" -ass-force-style FontName=").append(StringUtil.quoteArg(fontName)).append(',');
                            }
                        } else {
                            stringBuilder.append(" -font Arial ");
                            stringBuilder.append(" -ass-force-style FontName=Arial,");
                        }
                    }
                    if (intOCH > 0) {
                        subtitleMargin = defaultVideoTrack.getHeight() / 100 * intOCH;
                        subtitleMargin /= 2;
                    }
                    stringBuilder.append("Outline=").append(configuration.getAssOutline()).append(",Shadow=").append(configuration.getAssShadow());
                    try {
                        userMargin = Integer.parseInt(configuration.getAssMargin());
                    }
                    catch (NumberFormatException n2) {
                        LOGGER.debug("Could not parse SSA margin from \"" + configuration.getAssMargin() + "\"");
                    }
                    stringBuilder.append(",MarginV=").append(subtitleMargin += userMargin).append(' ');
                } else if (intOCH > 0) {
                    subtitleMargin = defaultVideoTrack.getHeight() / 100 * intOCH;
                    stringBuilder.append("-ass-force-style MarginV=").append(subtitleMargin /= 2).append(' ');
                }
                if (Platform.isMac() && !stringBuilder.toString().contains(" -font ") && StringUtils.isNotBlank(font = CodecUtil.getDefaultFontPath())) {
                    stringBuilder.append("-font ").append(StringUtil.quoteArg(font)).append(' ');
                }
                if (!params.getSid().isEmbedded()) {
                    stringBuilder.append("-noflip-hebrew ");
                }
            } else {
                if (configuration.getFont() != null && configuration.getFont().length() > 0) {
                    stringBuilder.append(" -font ").append(StringUtil.quoteArg(configuration.getFont())).append(' ');
                } else {
                    String font = CodecUtil.getDefaultFontPath();
                    if (StringUtils.isNotBlank(font)) {
                        stringBuilder.append(" -font ").append(StringUtil.quoteArg(font)).append(' ');
                    }
                }
                stringBuilder.append(" -subfont-text-scale ").append(configuration.getMencoderNoAssScale());
                stringBuilder.append(" -subfont-outline ").append(configuration.getMencoderNoAssOutline());
                stringBuilder.append(" -subfont-blur ").append(configuration.getMencoderNoAssBlur());
                if (intOCH > 0) {
                    subtitleMargin = intOCH;
                }
                try {
                    userMargin = Integer.parseInt(configuration.getMencoderNoAssSubPos());
                }
                catch (NumberFormatException n3) {
                    LOGGER.debug("Could not parse subpos from \"" + configuration.getMencoderNoAssSubPos() + "\"");
                }
                stringBuilder.append(" -subpos ").append(100 - (subtitleMargin += userMargin)).append(' ');
            }
            if (!Platform.isMac()) {
                stringBuilder.append('-').append(configuration.isMencoderFontConfig() ? "" : "no").append("fontconfig ");
            }
            if (params.getSid().getType() == SubtitleType.VOBSUB && configuration.getMencoderVobsubSubtitleQuality() != null) {
                String subtitleQuality = configuration.getMencoderVobsubSubtitleQuality();
                stringBuilder.append("-spuaa ").append(subtitleQuality).append(' ');
            }
            if (params.getSid().isExternal() && !params.getSid().isExternalFileUtf()) {
                String subcp = null;
                if (StringUtils.isNotBlank(configuration.getSubtitlesCodepage())) {
                    subcp = configuration.getSubtitlesCodepage();
                } else if (StringUtils.isNotBlank(SubtitleUtils.getSubCpOptionForMencoder(params.getSid()))) {
                    subcp = SubtitleUtils.getSubCpOptionForMencoder(params.getSid());
                }
                if (StringUtils.isNotBlank(subcp)) {
                    stringBuilder.append("-subcp ").append(subcp).append(' ');
                    if (configuration.isMencoderSubFribidi()) {
                        stringBuilder.append("-fribidi-charset ").append(subcp).append(' ');
                    }
                }
            }
        }
        st = new StringTokenizer(stringBuilder.toString(), " ");
        int length = encodeOptions.overriddenMainArgs.length;
        encodeOptions.overriddenMainArgs = Arrays.copyOf(encodeOptions.overriddenMainArgs, encodeOptions.overriddenMainArgs.length + st.countTokens());
        boolean handleToken1 = false;
        while (st.hasMoreTokens()) {
            String s = st.nextToken();
            if (handleToken1) {
                s = "-quiet";
                handleToken1 = false;
            }
            if ((!configuration.isMencoderAss() || isDVD) && s.contains("-ass")) {
                s = "-quiet";
                handleToken1 = true;
            }
            encodeOptions.overriddenMainArgs[length++] = s;
        }
        ArrayList<Object> cmdList = new ArrayList<Object>();
        cmdList.add(this.getExecutable());
        cmdList.add("-ss");
        cmdList.add(params.getTimeSeek() > 0.0 ? "" + params.getTimeSeek() : "0");
        if (isDVD) {
            cmdList.add("-dvd-device");
        }
        String frameRateRatio = MEncoderVideo.getValidFps(media.getFrameRate(), true);
        String frameRateNumber = MEncoderVideo.getValidFps(media.getFrameRate(), false);
        if (avisynth && !filename.toLowerCase().endsWith(".iso")) {
            File avsFile = AviSynthMEncoder.getAVSScript(filename, params.getSid(), params.getFromFrame(), params.getToFrame(), frameRateRatio, frameRateNumber, configuration);
            cmdList.add(ProcessUtil.getShortFileNameIfWideChars(avsFile.getAbsolutePath()));
        } else if (params.getStdIn() != null) {
            cmdList.add("-");
        } else if (isDVD) {
            String[] dvdFileName = filename.replace("\\VIDEO_TS", "");
            cmdList.add(dvdFileName);
        } else {
            cmdList.add(filename);
        }
        if (isDVD) {
            cmdList.add("dvd://" + media.getDvdtrack());
        }
        for (String arg : this.args(encodeOptions)) {
            if (arg.contains("format=mpeg2") && media.getAspectRatioDvdIso() != null && MEncoderVideo.getAspectRatioMencoderMpegopts(media.getAspectRatioDvdIso(), true) != null) {
                cmdList.add(arg + ":vaspect=" + MEncoderVideo.getAspectRatioMencoderMpegopts(media.getAspectRatioDvdIso(), true));
                continue;
            }
            cmdList.add(arg);
        }
        if (!(encodeOptions.dtsRemux || encodeOptions.encodedAudioPassthrough || encodeOptions.pcm || this.isAviSynthEngine() || params.getAid() == null || media.getAudioTracks().size() <= 1)) {
            cmdList.add("-aid");
            boolean lavf = false;
            cmdList.add("" + (lavf ? params.getAid().getId() + 1 : params.getAid().getId()));
        }
        if (this.isDisableSubtitles(params)) {
            cmdList.add("-nosub");
            cmdList.add("-noautosub");
        } else if (params.getSid().isEmbedded()) {
            cmdList.add("-noautosub");
            cmdList.add("-sid");
            cmdList.add("" + params.getSid().getId());
        } else if (externalSubtitlesFileName != null) {
            assert (params.getSid().isExternal());
            cmdList.add("-nosub");
            if (params.getSid().getType() == SubtitleType.VOBSUB) {
                cmdList.add("-vobsub");
                cmdList.add(externalSubtitlesFileName.substring(0, externalSubtitlesFileName.length() - 4));
                cmdList.add("-slang");
                cmdList.add(params.getSid().getLang());
            } else if (!renderer.streamSubsForTranscodedVideo() || !renderer.isExternalSubtitlesFormatSupported(params.getSid(), item)) {
                cmdList.add("-sub");
                MediaSubtitle convertedSubs = item.getMediaSubtitle();
                if (defaultVideoTrack.is3d()) {
                    if (convertedSubs != null && convertedSubs.getConvertedFile() != null) {
                        cmdList.add(convertedSubs.getConvertedFile().getAbsolutePath().replace(",", "\\,"));
                    } else if (params.getSid().getType() != SubtitleType.ASS) {
                        File subsFilename = SubtitleUtils.getSubtitles(item, media, params, configuration, SubtitleType.ASS);
                        cmdList.add(subsFilename.getAbsolutePath().replace(",", "\\,"));
                    }
                } else {
                    cmdList.add(externalSubtitlesFileName.replace(",", "\\,"));
                }
                if (params.getSid().isExternalFileUtf()) {
                    cmdList.add("-utf8");
                }
            }
        }
        String ofps = framerate = frameRateRatio != null ? frameRateRatio : "24000/1001";
        if (configuration.isMencoderForceFps()) {
            if (!configuration.isFix25FPSAvMismatch()) {
                cmdList.add("-fps");
                cmdList.add(framerate);
            } else if (frameRateRatio != null) {
                cmdList.add("-mc");
                cmdList.add("0.005");
                ofps = "25";
            }
        }
        if (this.isAviSynthEngine() && configuration.getAvisynthInterFrame() && !"60000/1001".equals(frameRateRatio) && !"50".equals(frameRateRatio) && !"60".equals(frameRateRatio)) {
            ofps = switch (frameRateRatio) {
                case "25" -> "50";
                case "30" -> "60";
                default -> "60000/1001";
            };
        }
        cmdList.add("-ofps");
        cmdList.add(ofps);
        if (filename.toLowerCase().endsWith(".evo")) {
            cmdList.add("-psprobe");
            cmdList.add("10000");
        }
        boolean deinterlace = configuration.isMencoderYadif();
        boolean isResolutionTooHighForRenderer = !renderer.isResolutionCompatibleWithRenderer(defaultVideoTrack.getWidth(), defaultVideoTrack.getHeight());
        boolean scaleBool = false;
        if (isResolutionTooHighForRenderer || configuration.isMencoderScaler() && (configuration.getMencoderScaleX() != 0 || configuration.getMencoderScaleY() != 0) || intOCW > 0 || intOCH > 0) {
            scaleBool = true;
        }
        int scaleWidth = 0;
        int scaleHeight = 0;
        Object vfValue = "";
        if (defaultVideoTrack.getWidth() > 0 && defaultVideoTrack.getHeight() > 0) {
            scaleWidth = defaultVideoTrack.getWidth();
            scaleHeight = defaultVideoTrack.getHeight();
        }
        double videoAspectRatio = (double)defaultVideoTrack.getWidth() / (double)defaultVideoTrack.getHeight();
        double rendererAspectRatio = 1.777777777777778;
        if (renderer.isMaximumResolutionSpecified()) {
            rendererAspectRatio = (double)renderer.getMaxVideoWidth() / (double)renderer.getMaxVideoHeight();
        }
        if ((deinterlace || scaleBool) && !this.isAviSynthEngine()) {
            StringBuilder vfValueOverscanPrepend = new StringBuilder();
            StringBuilder vfValueOverscanMiddle = new StringBuilder();
            StringBuilder vfValueVS = new StringBuilder();
            StringBuilder vfValueComplete = new StringBuilder();
            String deinterlaceComma = "";
            if (intOCW > 0 || intOCH > 0) {
                int intOCWPixels = defaultVideoTrack.getWidth() / 100 * intOCW;
                int n2 = defaultVideoTrack.getHeight() / 100 * intOCH;
                if (renderer.isMaximumResolutionSpecified() && ((scaleWidth += intOCWPixels) > renderer.getMaxVideoWidth() || (scaleHeight += n2) > renderer.getMaxVideoHeight())) {
                    double overscannedAspectRatio = (double)scaleWidth / (double)scaleHeight;
                    if (overscannedAspectRatio > rendererAspectRatio) {
                        scaleWidth = renderer.getMaxVideoWidth();
                        scaleHeight = (int)Math.round((double)renderer.getMaxVideoWidth() / overscannedAspectRatio);
                    } else {
                        scaleWidth = (int)Math.round((double)renderer.getMaxVideoHeight() * overscannedAspectRatio);
                        scaleHeight = renderer.getMaxVideoHeight();
                    }
                }
                scaleWidth = MEncoderVideo.convertToModX(scaleWidth, 4);
                scaleHeight = MEncoderVideo.convertToModX(scaleHeight, 4);
                vfValueOverscanPrepend.append("softskip,expand=-").append(intOCWPixels).append(":-").append(n2);
                vfValueOverscanMiddle.append(",scale=").append(scaleWidth).append(':').append(scaleHeight);
            }
            if (configuration.isMencoderScaler()) {
                if (configuration.getMencoderScaleX() != 0) {
                    scaleWidth = configuration.getMencoderScaleX() <= renderer.getMaxVideoWidth() ? configuration.getMencoderScaleX() : renderer.getMaxVideoWidth();
                }
                if (configuration.getMencoderScaleY() != 0) {
                    scaleHeight = configuration.getMencoderScaleY() <= renderer.getMaxVideoHeight() ? configuration.getMencoderScaleY() : renderer.getMaxVideoHeight();
                }
                scaleWidth = MEncoderVideo.convertToModX(scaleWidth, 4);
                scaleHeight = MEncoderVideo.convertToModX(scaleHeight, 4);
                LOGGER.info("Setting video resolution to: " + scaleWidth + "x" + scaleHeight + ", your Video Scaler setting");
                vfValueVS.append("scale=").append(scaleWidth).append(':').append(scaleHeight);
            } else if (isResolutionTooHighForRenderer) {
                if (defaultVideoTrack.getWidth() == 3840 && defaultVideoTrack.getHeight() <= 1080) {
                    scaleWidth = 1920;
                    scaleHeight = defaultVideoTrack.getHeight();
                } else if (defaultVideoTrack.getWidth() == 1920 && defaultVideoTrack.getHeight() == 2160) {
                    scaleWidth = 1920;
                    scaleHeight = 1080;
                } else if (defaultVideoTrack.getWidth() == 1920 && defaultVideoTrack.getHeight() == 1088) {
                    scaleWidth = 1920;
                    scaleHeight = 1088;
                } else if (videoAspectRatio > rendererAspectRatio) {
                    scaleWidth = renderer.getMaxVideoWidth();
                    scaleHeight = (int)Math.round((double)renderer.getMaxVideoWidth() / videoAspectRatio);
                } else {
                    scaleWidth = (int)Math.round((double)renderer.getMaxVideoHeight() * videoAspectRatio);
                    scaleHeight = renderer.getMaxVideoHeight();
                }
                scaleWidth = MEncoderVideo.convertToModX(scaleWidth, 4);
                scaleHeight = MEncoderVideo.convertToModX(scaleHeight, 4);
                LOGGER.info("Setting video resolution to: " + scaleWidth + "x" + scaleHeight + ", the maximum your renderer supports");
                vfValueVS.append("scale=").append(scaleWidth).append(':').append(scaleHeight);
            }
            if (intOCW > 0 || intOCH > 0) {
                vfValueComplete.append((CharSequence)vfValueOverscanPrepend).append((CharSequence)vfValueOverscanMiddle).append(",harddup");
                LOGGER.info("Setting video resolution to: " + scaleWidth + "x" + scaleHeight + ", to fit your overscan compensation");
            } else {
                vfValueComplete.append((CharSequence)vfValueVS);
            }
            if (deinterlace) {
                deinterlaceComma = ",";
            }
            vfValue = (deinterlace ? "yadif" : "") + (String)(scaleBool ? deinterlaceComma + vfValueComplete : "");
        }
        if (!(isDVD || (scaleWidth % 4 == 0 && scaleHeight % 4 == 0 || renderer.isMuxNonMod4Resolution()) && (!renderer.isKeepAspectRatio() && !renderer.isKeepAspectRatioTranscoding() || "16:9".equals(defaultVideoTrack.getDisplayAspectRatio())) || configuration.isMencoderScaler())) {
            Object vfValuePrepend = "expand=";
            if (renderer.isKeepAspectRatio() || renderer.isKeepAspectRatioTranscoding()) {
                String resolution = item.getResolutionForKeepAR(scaleWidth, scaleHeight);
                scaleWidth = Integer.parseInt(StringUtils.substringBefore(resolution, "x"));
                scaleHeight = Integer.parseInt(StringUtils.substringAfter(resolution, "x"));
                vfValuePrepend = scaleWidth + 4 > renderer.getMaxVideoWidth() || scaleHeight + 4 > renderer.getMaxVideoHeight() ? (String)vfValuePrepend + "::::0:16/9,scale=" + scaleWidth + ":" + scaleHeight : (String)vfValuePrepend + "::::0:16/9:4";
            } else {
                vfValuePrepend = (String)vfValuePrepend + "-" + scaleWidth % 4 + ":-" + scaleHeight % 4;
            }
            vfValuePrepend = (String)vfValuePrepend + ",softskip";
            if (StringUtils.isNotBlank((CharSequence)vfValue)) {
                vfValuePrepend = (String)vfValuePrepend + ",";
            }
            vfValue = (String)vfValuePrepend + (String)vfValue;
        }
        if (StringUtils.isNotBlank((CharSequence)vfValue)) {
            cmdList.add("-vf");
            cmdList.add(vfValue);
        }
        if (!(!configuration.getMencoderMT() || avisynth || isDVD || defaultVideoTrack.getCodec() != null && defaultVideoTrack.getCodec().startsWith("mpeg2"))) {
            cmdList.add("-lavdopts");
            cmdList.add("fast");
        }
        boolean disableMc0AndNoskip = false;
        if (expertOptions != null && expertOptions.length > 0) {
            HashMap<String, Boolean> removeCmdListOption = new HashMap<String, Boolean>();
            HashMap<String, Object> mergeCmdListOption = new HashMap<String, Object>();
            HashMap<String, Boolean> mergedCmdListOption = new HashMap<String, Boolean>();
            block60: for (int l = 0; l < expertOptions.length; ++l) {
                switch (expertOptions[l]) {
                    case "-noass": {
                        removeCmdListOption.put("-ass", false);
                        expertOptions[l] = REMOVE_OPTION;
                        continue block60;
                    }
                    case "-nomux": {
                        expertOptions[l] = REMOVE_OPTION;
                        continue block60;
                    }
                    case "-mt": {
                        expertOptions[l] = REMOVE_OPTION;
                        continue block60;
                    }
                    case "-ofps": {
                        removeCmdListOption.put("-ofps", true);
                        ++l;
                        continue block60;
                    }
                    case "-fps": {
                        removeCmdListOption.put("-fps", true);
                        ++l;
                        continue block60;
                    }
                    case "-ovc": {
                        removeCmdListOption.put("-ovc", true);
                        ++l;
                        continue block60;
                    }
                    case "-channels": {
                        removeCmdListOption.put("-channels", true);
                        ++l;
                        continue block60;
                    }
                    case "-oac": {
                        removeCmdListOption.put("-oac", true);
                        ++l;
                        continue block60;
                    }
                    case "-quality": {
                        String lavcopts = String.format("autoaspect=1:vcodec=%s:acodec=%s:abitrate=%s:threads=%d:%s", vcodec, configuration.isMencoderAc3Fixed() ? "ac3_fixed" : "ac3", CodecUtil.getAC3Bitrate(configuration, params.getAid()), configuration.getMencoderMaxThreads(), expertOptions[l + 1]);
                        lavcopts = this.addMaximumBitrateConstraints(encodeOptions, lavcopts, media, lavcopts, renderer, "", encodingFormat);
                        mergeCmdListOption.put("-lavcopts", lavcopts.replace("%", "%%"));
                        expertOptions[l] = REMOVE_OPTION;
                        expertOptions[l + 1] = REMOVE_OPTION;
                        ++l;
                        continue block60;
                    }
                    case "-mpegopts": {
                        mergeCmdListOption.put("-mpegopts", "%s:" + expertOptions[l + 1].replace("%", "%%"));
                        expertOptions[l] = REMOVE_OPTION;
                        expertOptions[l + 1] = REMOVE_OPTION;
                        ++l;
                        continue block60;
                    }
                    case "-vf": {
                        mergeCmdListOption.put("-vf", "%s," + expertOptions[l + 1].replace("%", "%%"));
                        ++l;
                        continue block60;
                    }
                    case "-af": {
                        mergeCmdListOption.put("-af", "%s," + expertOptions[l + 1].replace("%", "%%"));
                        ++l;
                        continue block60;
                    }
                    case "-nosync": {
                        disableMc0AndNoskip = true;
                        expertOptions[l] = REMOVE_OPTION;
                        continue block60;
                    }
                    case "-mc": {
                        disableMc0AndNoskip = true;
                        continue block60;
                    }
                }
            }
            for (String key : mergeCmdListOption.keySet()) {
                mergedCmdListOption.put(key, false);
            }
            ArrayList<String> transformedCmdList = new ArrayList<String>();
            for (int ii = 0; ii < cmdList.size(); ++ii) {
                String string = (String)cmdList.get(ii);
                if (removeCmdListOption.containsKey(string)) {
                    if (!BooleanUtils.isTrue((Boolean)removeCmdListOption.get(string))) continue;
                    ++ii;
                    continue;
                }
                transformedCmdList.add(string);
                if (!mergeCmdListOption.containsKey(string)) continue;
                String format = (String)mergeCmdListOption.get(string);
                String value = String.format(format, cmdList.get(ii + 1));
                mergedCmdListOption.put(string, true);
                transformedCmdList.add(value);
                ++ii;
            }
            cmdList = transformedCmdList;
            for (int iii = 0; iii < expertOptions.length; ++iii) {
                String string = expertOptions[iii];
                if (string.equals(REMOVE_OPTION)) continue;
                if (BooleanUtils.isTrue((Boolean)mergedCmdListOption.get(string))) {
                    ++iii;
                    continue;
                }
                cmdList.add(string);
            }
        }
        if (encodeOptions.pcm || encodeOptions.dtsRemux || encodeOptions.encodedAudioPassthrough || encodeOptions.ac3Remux || configuration.isMencoderNoOutOfSync() && !disableMc0AndNoskip) {
            if (configuration.isFix25FPSAvMismatch()) {
                cmdList.add("-mc");
                cmdList.add("0.005");
            } else if (configuration.isMencoderNoOutOfSync() && !disableMc0AndNoskip) {
                cmdList.add("-mc");
                cmdList.add("0");
                if (!renderer.isDisableMencoderNoskip()) {
                    cmdList.add("-noskip");
                }
            }
        }
        if (params.getTimeEnd() > 0.0) {
            cmdList.add("-endpos");
            cmdList.add("" + params.getTimeEnd());
        }
        String rate = "" + renderer.getTranscodedVideoAudioSampleRate();
        if (!(encodeOptions.pcm || encodeOptions.dtsRemux || encodeOptions.ac3Remux || encodeOptions.encodedAudioPassthrough)) {
            cmdList.add("-af");
            String af = "lavcresample=" + rate;
            if (configuration.isMEncoderNormalizeVolume()) {
                af = af + ":volnorm=1";
            }
            cmdList.add(af);
            cmdList.add("-srate");
            cmdList.add(rate);
        }
        if (params.getStdIn() != null) {
            cmdList.add("-cache");
            cmdList.add("8192");
        }
        IPipeProcess pipe = null;
        if (encodeOptions.pcm || encodeOptions.dtsRemux || encodeOptions.encodedAudioPassthrough) {
            boolean channelsFilterPresent = false;
            for (String string : cmdList) {
                if (!StringUtils.isNotBlank(string) || !string.startsWith("channels")) continue;
                channelsFilterPresent = true;
                break;
            }
            if (params.isAvidemux()) {
                String mixer;
                params.getInputPipes()[0] = pipe = PlatformUtils.INSTANCE.getPipeProcess("mencoder" + System.currentTimeMillis(), encodeOptions.pcm || encodeOptions.dtsRemux || encodeOptions.encodedAudioPassthrough || encodeOptions.ac3Remux ? null : params, new String[0]);
                cmdList.add("-o");
                cmdList.add(pipe.getInputPipe());
                if (encodeOptions.pcm && !channelsFilterPresent && params.getAid() != null && StringUtils.isNotBlank(mixer = MEncoderVideo.getLPCMChannelMappingForMencoder(params.getAid()))) {
                    cmdList.add("-af");
                    cmdList.add(mixer);
                }
                String[] cmdArray = new String[cmdList.size()];
                cmdList.toArray(cmdArray);
                pw = new ProcessWrapperImpl(cmdArray, params);
                IPipeProcess iPipeProcess = PlatformUtils.INSTANCE.getPipeProcess("videoPipe" + System.currentTimeMillis(), "out", "reconnect");
                IPipeProcess audioPipe = PlatformUtils.INSTANCE.getPipeProcess("audioPipe" + System.currentTimeMillis(), "out", "reconnect");
                ProcessWrapper videoPipeProcess = iPipeProcess.getPipeProcess();
                ProcessWrapper audioPipeProcess = audioPipe.getPipeProcess();
                params.getOutputPipes()[0] = iPipeProcess;
                params.getOutputPipes()[1] = audioPipe;
                pw.attachProcess(videoPipeProcess);
                pw.attachProcess(audioPipeProcess);
                videoPipeProcess.runInNewThread();
                audioPipeProcess.runInNewThread();
                UMSUtils.sleep(50);
                iPipeProcess.deleteLater();
                audioPipe.deleteLater();
            } else {
                ListIterator<String> it = cmdList.listIterator();
                while (it.hasNext()) {
                    String string = (String)it.next();
                    if (!string.equals("-oac")) continue;
                    it.set("-nosound");
                    if (!it.hasNext()) break;
                    it.next();
                    it.remove();
                    break;
                }
                pipe = PlatformUtils.INSTANCE.getPipeProcess(System.currentTimeMillis() + "tsmuxerout.ts", new String[0]);
                TsMuxeRVideo ts = (TsMuxeRVideo)EngineFactory.getEngine(StandardEngineId.TSMUXER_VIDEO, false, true);
                File file = new File(CONFIGURATION.getTempFolder(), "ums-tsmuxer.meta");
                String[] cmd = new String[]{ts.getExecutable(), file.getAbsolutePath(), pipe.getInputPipe()};
                pw = new ProcessWrapperImpl(cmd, params);
                PipeIPCProcess ffVideoPipe = new PipeIPCProcess(System.currentTimeMillis() + "ffmpegvideo", System.currentTimeMillis() + "videoout", false, true);
                cmdList.add("-o");
                cmdList.add(ffVideoPipe.getInputPipe());
                OutputParams ffparams = new OutputParams(configuration);
                ffparams.setMaxBufferSize(1.0);
                ffparams.setStdIn(params.getStdIn());
                String[] cmdArray = new String[cmdList.size()];
                cmdList.toArray(cmdArray);
                ProcessWrapperImpl ffVideo = new ProcessWrapperImpl(cmdArray, ffparams);
                ProcessWrapper ffVideoPipeProcess = ffVideoPipe.getPipeProcess();
                pw.attachProcess(ffVideoPipeProcess);
                ffVideoPipeProcess.runInNewThread();
                ffVideoPipe.deleteLater();
                pw.attachProcess(ffVideo);
                ffVideo.runInNewThread();
                String aid = null;
                if (media.getAudioTracks().size() > 1 && params.getAid() != null) {
                    aid = media.getContainer() != null && (media.getContainer().equals("avi") || media.getContainer().equals("flv")) ? "" + (params.getAid().getId() + 1) : "" + params.getAid().getId();
                }
                PipeIPCProcess ffAudioPipe = new PipeIPCProcess(System.currentTimeMillis() + "ffmpegaudio01", System.currentTimeMillis() + "audioout", false, true);
                StreamModifier sm = new StreamModifier();
                sm.setPcm(encodeOptions.pcm);
                sm.setDtsEmbed(encodeOptions.dtsRemux);
                sm.setEncodedAudioPassthrough(encodeOptions.encodedAudioPassthrough);
                sm.setSampleFrequency(48000);
                sm.setBitsPerSample(16);
                String mixer = null;
                if (encodeOptions.pcm && !encodeOptions.dtsRemux && !encodeOptions.encodedAudioPassthrough) {
                    mixer = MEncoderVideo.getLPCMChannelMappingForMencoder(params.getAid());
                }
                sm.setNbChannels(channels);
                String[] ffmpegLPCMextract = new String[]{this.getExecutable(), "-ss", "0", filename, "-really-quiet", "-msglevel", "statusline=2", "-channels", "" + channels, "-ovc", "copy", "-of", "rawaudio", "-mc", encodeOptions.dtsRemux || encodeOptions.encodedAudioPassthrough ? "0.1" : "0", "-noskip", aid == null ? "-quiet" : "-aid", aid == null ? "-quiet" : aid, "-oac", encodeOptions.ac3Remux || encodeOptions.dtsRemux || encodeOptions.encodedAudioPassthrough ? "copy" : "pcm", StringUtils.isNotBlank(mixer) && !channelsFilterPresent ? "-af" : "-quiet", StringUtils.isNotBlank(mixer) && !channelsFilterPresent ? mixer : "-quiet", "-srate", "48000", "-o", ffAudioPipe.getInputPipe()};
                if (!renderer.isMuxDTSToMpeg()) {
                    ffAudioPipe.setModifier(sm);
                }
                if (media.getDvdtrack() > 0) {
                    ffmpegLPCMextract[3] = "-dvd-device";
                    ffmpegLPCMextract[4] = filename;
                    ffmpegLPCMextract[5] = "dvd://" + media.getDvdtrack();
                } else if (params.getStdIn() != null) {
                    ffmpegLPCMextract[3] = "-";
                }
                if (filename.toLowerCase().endsWith(".evo")) {
                    ffmpegLPCMextract[4] = "-psprobe";
                    ffmpegLPCMextract[5] = "1000000";
                }
                if (params.getTimeSeek() > 0.0) {
                    ffmpegLPCMextract[2] = "" + params.getTimeSeek();
                }
                OutputParams ffaudioparams = new OutputParams(configuration);
                ffaudioparams.setMaxBufferSize(1.0);
                ffaudioparams.setStdIn(params.getStdIn());
                ProcessWrapperImpl ffAudio = new ProcessWrapperImpl(ffmpegLPCMextract, ffaudioparams);
                params.setStdIn(null);
                try (PrintWriter pwMux = new PrintWriter(file);){
                    pwMux.println("MUXOPT --no-pcr-on-video-pid --no-asyncio --new-audio-pes --vbr --vbv-len=500");
                    String videoType = "V_MPEG-2";
                    if (params.isNoVideoEncode() && params.getForceType() != null) {
                        videoType = params.getForceType();
                    }
                    Object fps = "";
                    if (params.getForceFps() != null) {
                        fps = "fps=" + params.getForceFps() + ", ";
                    }
                    String audioType = encodeOptions.ac3Remux ? "A_AC3" : (encodeOptions.dtsRemux ? (renderer.isMuxDTSToMpeg() ? "A_DTS" : "A_LPCM") : "A_LPCM");
                    Object timeshift = "";
                    if (params.getAid() != null && mencoderAC3RemuxAudioDelayBug) {
                        timeshift = "timeshift=" + params.getAid().getVideoDelay() + "ms, ";
                    }
                    pwMux.println(videoType + ", \"" + ffVideoPipe.getOutputPipe() + "\", " + (String)fps + "level=4.1, insertSEI, contSPS, track=1");
                    pwMux.println(audioType + ", \"" + ffAudioPipe.getOutputPipe() + "\", " + (String)timeshift + "track=2");
                }
                ProcessWrapper pipeProcess = pipe.getPipeProcess();
                pw.attachProcess(pipeProcess);
                pipeProcess.runInNewThread();
                UMSUtils.sleep(50);
                pipe.deleteLater();
                params.getInputPipes()[0] = pipe;
                ProcessWrapper ffPipeProcess = ffAudioPipe.getPipeProcess();
                pw.attachProcess(ffPipeProcess);
                ffPipeProcess.runInNewThread();
                UMSUtils.sleep(50);
                ffAudioPipe.deleteLater();
                pw.attachProcess(ffAudio);
                ffAudio.runInNewThread();
            }
        } else {
            boolean directpipe;
            boolean bl = directpipe = Platform.isMac() || Platform.isFreeBSD();
            if (directpipe) {
                cmdList.add("-o");
                cmdList.add("-");
                cmdList.add("-really-quiet");
                cmdList.add("-msglevel");
                cmdList.add("statusline=2");
                params.setInputPipes(new IPipeProcess[2]);
            } else {
                params.getInputPipes()[0] = pipe = PlatformUtils.INSTANCE.getPipeProcess("mencoder" + System.currentTimeMillis(), encodeOptions.pcm || encodeOptions.dtsRemux || encodeOptions.encodedAudioPassthrough ? null : params, new String[0]);
                cmdList.add("-o");
                cmdList.add(pipe.getInputPipe());
            }
            String[] cmdArray = new String[cmdList.size()];
            cmdList.toArray(cmdArray);
            pw = new ProcessWrapperImpl(cmdArray, params);
            if (!directpipe && pipe != null) {
                ProcessWrapper processWrapper = pipe.getPipeProcess();
                pw.attachProcess(processWrapper);
                processWrapper.runInSameThread();
                pipe.deleteLater();
            }
        }
        pw.runInNewThread();
        UMSUtils.sleep(100);
        return pw;
    }

    @Override
    public String getMimeType() {
        return "video/transcode";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int type() {
        return 4;
    }

    public static String[] getSpecificCodecOptions(String codecParam, MediaInfo media, OutputParams params, String filename, String externalSubtitlesFileName, boolean enable, boolean verifyOnly) {
        StringBuilder sb = new StringBuilder();
        Object codecs = enable ? DEFAULT_CODEC_CONF_SCRIPT : "";
        codecs = (String)codecs + "\n" + codecParam;
        StringTokenizer stLines = new StringTokenizer((String)codecs, "\n");
        String container = media.getContainer();
        String codecV = media.getDefaultVideoTrack() != null ? media.getDefaultVideoTrack().getCodec() : null;
        String codecA = params.getAid() != null ? params.getAid().getCodec() : null;
        try {
            Interpreter interpreter = new Interpreter();
            interpreter.setStrictJava(true);
            List<String> types = CodecUtil.getPossibleCodecs();
            int rank = 1;
            if (types != null) {
                for (String type : types) {
                    int r = rank++;
                    interpreter.set(type, r);
                    String secondaryType = "dummy";
                    if ("matroska".equals(type)) {
                        secondaryType = "mkv";
                        interpreter.set(secondaryType, r);
                    } else if ("rm".equals(type)) {
                        secondaryType = "rmvb";
                        interpreter.set(secondaryType, r);
                    } else if ("mpeg2".startsWith(type)) {
                        secondaryType = "mpeg2";
                        interpreter.set(secondaryType, r);
                    } else if ("mpeg1video".equals(type)) {
                        secondaryType = "mpeg1";
                        interpreter.set(secondaryType, r);
                    }
                    if (container != null && (container.equals(type) || container.equals(secondaryType))) {
                        interpreter.set("container", r);
                        continue;
                    }
                    if (codecV != null && (codecV.equals(type) || codecV.equals(secondaryType))) {
                        interpreter.set("vcodec", r);
                        continue;
                    }
                    if (codecA == null || !codecA.equals(type)) continue;
                    interpreter.set("acodec", r);
                }
            } else {
                return null;
            }
            interpreter.set("filename", filename);
            interpreter.set("audio", params.getAid() != null);
            interpreter.set("subtitles", params.getSid() != null);
            interpreter.set("srtfile", externalSubtitlesFileName);
            if (params.getAid() != null) {
                interpreter.set("samplerate", params.getAid().getSampleRate());
            }
            String frameRateNumber = MEncoderVideo.getValidFps(media.getFrameRate(), false);
            try {
                if (frameRateNumber != null) {
                    interpreter.set("framerate", Double.parseDouble(frameRateNumber));
                }
            }
            catch (NumberFormatException e) {
                LOGGER.debug("Could not parse framerate from \"" + frameRateNumber + "\"");
            }
            interpreter.set("duration", media.getDurationInSeconds());
            if (params.getAid() != null) {
                interpreter.set("channels", params.getAid().getNumberOfChannels());
            }
            interpreter.set("height", media.getHeight());
            interpreter.set("width", media.getWidth());
            while (stLines.hasMoreTokens()) {
                String line = stLines.nextToken();
                if (line.startsWith("#") || line.trim().length() <= 0) continue;
                int separator = line.indexOf("::");
                if (separator > -1) {
                    String key = null;
                    try {
                        Boolean boolval;
                        Object result;
                        key = line.substring(0, separator).trim();
                        String value = line.substring(separator + 2).trim();
                        if (value.length() <= 0) continue;
                        if (key.length() == 0) {
                            key = "1 == 1";
                        }
                        if (!((result = interpreter.eval(key)) instanceof Boolean) || !(boolval = (Boolean)result).booleanValue()) continue;
                        sb.append(' ').append(value);
                        continue;
                    }
                    catch (EvalError e) {
                        LOGGER.debug("Error while executing: " + key + " : " + e.getMessage());
                        if (!verifyOnly) continue;
                        return new String[]{"@@Error while parsing: " + e.getMessage()};
                    }
                }
                if (!verifyOnly) continue;
                return new String[]{"@@Malformatted line: " + line};
            }
        }
        catch (EvalError e) {
            LOGGER.debug("BeanShell error: " + e.getMessage());
        }
        String completeLine = sb.toString();
        ArrayList<String> args = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(completeLine, " ");
        while (st.hasMoreTokens()) {
            String arg = st.nextToken().trim();
            if (arg.length() <= 0) continue;
            args.add(arg);
        }
        String[] definitiveArgs = new String[args.size()];
        args.toArray(definitiveArgs);
        return definitiveArgs;
    }

    @Override
    public boolean isCompatible(StoreItem item) {
        return PlayerUtil.isVideo(item, Format.Identifier.ISOVOB) || PlayerUtil.isVideo(item, Format.Identifier.MKV) || PlayerUtil.isVideo(item, Format.Identifier.MPG) || PlayerUtil.isVideo(item, Format.Identifier.OGG);
    }

    @Override
    public boolean isCompatible(EncodingFormat encodingFormat) {
        return encodingFormat.isVideoFormat() && !encodingFormat.isTranscodeToHLS();
    }

    @Override
    public boolean excludeFormat(Format extension) {
        return false;
    }

    @Override
    @Nullable
    public ExecutableInfo testExecutable(@Nonnull ExecutableInfo executableInfo) {
        if (Boolean.FALSE.equals((executableInfo = this.testExecutableFile(executableInfo)).getAvailable())) {
            return executableInfo;
        }
        String arg = "-info:help";
        ExecutableInfo.ExecutableInfoBuilder result = executableInfo.modify();
        try {
            ListProcessWrapperResult output = SimpleProcessWrapper.runProcessListOutput(30000L, 1000L, executableInfo.getPath().toString(), "-info:help");
            if (output.getError() != null) {
                result.errorType(ExecutableErrorType.GENERAL);
                result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + " \n" + output.getError().getMessage());
                result.available(Boolean.FALSE);
                LOGGER.debug("\"{} {}\" failed with error: {}", executableInfo.getPath(), "-info:help", output.getError().getMessage());
                return result.build();
            }
            if (output.getExitCode() == 0) {
                Pattern pattern;
                Matcher matcher;
                if (!output.getOutput().isEmpty() && (matcher = (pattern = Pattern.compile("^MEncoder\\s+(.*?)\\s+\\(C\\)", 2)).matcher((CharSequence)output.getOutput().get(0))).find() && StringUtils.isNotBlank(matcher.group(1))) {
                    result.version(new Version(matcher.group(1)));
                }
                result.available(Boolean.TRUE);
            } else {
                NTStatus ntStatus;
                NTStatus nTStatus = ntStatus = Platform.isWindows() ? NTStatus.typeOf(output.getExitCode()) : null;
                if (ntStatus != null) {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + "\n\n" + ntStatus);
                } else if (output.getOutput().size() > 3 && StringUtil.hasValue((String)output.getOutput().get(output.getOutput().size() - 1)) && !StringUtil.hasValue((String)output.getOutput().get(output.getOutput().size() - 2)) && StringUtil.hasValue((String)output.getOutput().get(output.getOutput().size() - 3))) {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + " \n" + (String)output.getOutput().get(output.getOutput().size() - 3));
                } else {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + Messages.getString("UnknownError"));
                }
                result.available(Boolean.FALSE);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        return result.build();
    }

    @Override
    protected boolean isSpecificTest() {
        return false;
    }

    private static String getLPCMChannelMappingForMencoder(MediaAudio audioTrack) {
        String mixer = null;
        int numberOfInputChannels = audioTrack.getNumberOfChannels();
        if (numberOfInputChannels == 6) {
            mixer = "channels=6:6:0:0:1:1:2:5:3:2:4:4:5:3";
        } else if (numberOfInputChannels == 8) {
            mixer = "channels=8:8:0:0:1:4:2:7:3:5:4:1:5:3:6:6:7:2";
        }
        return mixer;
    }

    private static String getAspectRatioMencoderMpegopts(String aspectRatioDvdIso, boolean ratios) {
        if (aspectRatioDvdIso != null) {
            double aspectRatio = Double.parseDouble(aspectRatioDvdIso);
            if (aspectRatio > 1.7 && aspectRatio < 1.8) {
                return ratios ? "16/9" : "1.777777777777777";
            }
            if (aspectRatio > 1.3 && aspectRatio < 1.4) {
                return ratios ? "4/3" : "1.333333333333333";
            }
        }
        return null;
    }

    protected static class EncodeOptions {
        private String[] overriddenMainArgs;
        private boolean dtsRemux;
        private boolean encodedAudioPassthrough;
        private boolean pcm;
        private boolean ovccopy;
        private boolean ac3Remux;
        private boolean isTranscodeToMPEGTS;
        private boolean isTranscodeToH264;
        private boolean isTranscodeToAAC;
        private boolean wmv;

        protected EncodeOptions() {
        }
    }
}

