/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.IOException;
import java.io.InputStream;
import java.time.LocalTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Locale;
import java.util.Map;
import java.util.StringTokenizer;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EncodingFormat;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.media.chapter.MediaChapter;
import net.pms.media.codec.video.H264;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.util.TimeRange;
import org.apache.commons.lang3.StringUtils;

public class HlsHelper {
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final String NONE_CONF_NAME = "NONE";
    private static final String COPY_CONF_NAME = "COPY";
    private static final DateTimeFormatter CHAPTERS_TIMESTAMP_FORMATTER = DateTimeFormatter.ofPattern("HH:mm:ss.SSS");
    public static final double DEFAULT_TARGETDURATION = 6.0;

    private HlsHelper() {
    }

    public static HlsConfiguration getByKey(String label) {
        String[] labelParts = label.split("_");
        if (labelParts.length > 1) {
            HlsVideoConfiguration videoConf = HlsVideoConfiguration.getByKey(labelParts[0]);
            HlsAudioConfiguration audioConf = HlsAudioConfiguration.getByKey(labelParts[1]);
            int audioStream = -1;
            int subtitle = -1;
            if (labelParts.length == 3) {
                int parsedValue;
                try {
                    parsedValue = Integer.parseInt(labelParts[2]);
                }
                catch (NumberFormatException e) {
                    parsedValue = -1;
                }
                if (audioConf != null && !audioConf.label.equals(NONE_CONF_NAME)) {
                    audioStream = parsedValue;
                } else {
                    subtitle = parsedValue;
                }
            }
            if (videoConf != null && audioConf != null) {
                return new HlsConfiguration(videoConf, audioConf, audioStream, subtitle);
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public static String getHLSm3u8(StoreItem item, Renderer renderer, String baseUrl) {
        if (item.getMediaInfo() != null) {
            HlsAudioConfiguration askedDefaultAudioGroup;
            EncodingFormat encodingFormat = item.getTranscodingSettings().getEncodingFormat();
            int hlsVersion = renderer.getHlsVersion();
            MediaInfo mediaInfo = item.getMediaInfo();
            int maxHeight = (int)((double)mediaInfo.getHeight() * 1.05);
            String id = item.getResourceId();
            StringBuilder sb = new StringBuilder();
            sb.append("#EXTM3U\n");
            if (hlsVersion > 1) {
                sb.append("#EXT-X-VERSION:").append(hlsVersion).append("\n");
            }
            ArrayList<HlsAudioConfiguration> audioGroups = new ArrayList<HlsAudioConfiguration>();
            MediaAudio mediaAudioDefault = null;
            if (!mediaInfo.getAudioTracks().isEmpty()) {
                HlsAudioConfiguration audioGroup;
                mediaAudioDefault = null;
                StringTokenizer st = new StringTokenizer(CONFIGURATION.getAudioLanguages(), ",");
                block4: while (st.hasMoreTokens() && mediaAudioDefault == null) {
                    String lang = st.nextToken().trim();
                    for (MediaAudio mediaAudio : mediaInfo.getAudioTracks()) {
                        if (!mediaAudio.matchCode(lang)) continue;
                        mediaAudioDefault = mediaAudio;
                        continue block4;
                    }
                }
                if (mediaAudioDefault != null && HlsHelper.isMediaAudioCompatible(mediaAudioDefault) && (audioGroup = HlsHelper.getAudioConfiguration(mediaAudioDefault)) != null) {
                    audioGroups.add(audioGroup);
                }
            }
            HlsAudioConfiguration hlsAudioConfiguration = askedDefaultAudioGroup = encodingFormat.isTranscodeToAAC() ? HlsAudioConfiguration.getByKey("AAC-LC") : HlsAudioConfiguration.getByKey("AC3");
            if (!audioGroups.contains(askedDefaultAudioGroup)) {
                audioGroups.add(askedDefaultAudioGroup);
            }
            HashMap<String, Integer> audioNames = new HashMap<String, Integer>();
            for (HlsAudioConfiguration hlsAudioConfiguration2 : audioGroups) {
                String groupId = hlsAudioConfiguration2.label;
                for (MediaAudio mediaAudio : mediaInfo.getAudioTracks()) {
                    sb.append("#EXT-X-MEDIA:TYPE=AUDIO,GROUP-ID=\"").append(groupId).append("\",LANGUAGE=\"");
                    sb.append(mediaAudio.getLang()).append("\",NAME=\"");
                    String audioName = mediaAudio.getLangFullName();
                    if (hlsAudioConfiguration2.audioChannels != 2) {
                        switch (hlsAudioConfiguration2.audioChannels) {
                            case 6: {
                                String string = audioName.concat(" (5.1)");
                                break;
                            }
                            case 8: {
                                String string = audioName.concat(" (7.1)");
                                break;
                            }
                            default: {
                                String string = audioName = audioName.concat(" (" + hlsAudioConfiguration2.audioChannels + "ch)");
                            }
                        }
                    }
                    if (audioNames.containsKey(audioName)) {
                        audioNames.put(audioName, (Integer)audioNames.get(audioName) + 1);
                        audioName = audioName.concat(" [" + audioNames.get(audioName) + "]");
                    } else {
                        audioNames.put(audioName, 0);
                    }
                    sb.append(audioName);
                    sb.append("\",CHANNELS=").append(hlsAudioConfiguration2.audioChannels);
                    sb.append(",AUTOSELECT=YES,DEFAULT=");
                    if (mediaAudioDefault != null && mediaAudioDefault.equals(mediaAudio)) {
                        sb.append("YES\n");
                        continue;
                    }
                    sb.append("NO").append(",URI=\"").append(baseUrl).append(id).append("/hls/").append(NONE_CONF_NAME).append("_").append(hlsAudioConfiguration2.label).append("_").append(mediaAudio.getId()).append(".m3u8\"\n");
                }
            }
            boolean subtitleAdded = false;
            for (MediaSubtitle mediaSubtitle : mediaInfo.getSubtitlesTracks()) {
                void var16_29;
                void var16_27;
                if (!mediaSubtitle.isEmbedded() || !mediaSubtitle.getType().isText()) continue;
                subtitleAdded = true;
                sb.append("#EXT-X-MEDIA:TYPE=SUBTITLES,GROUP-ID=\"sub1\",CHARACTERISTICS=\"public.accessibility.transcribes-spoken-dialog\",AUTOSELECT=YES");
                sb.append(",DEFAULT=").append(mediaSubtitle.isDefault() ? "YES" : "NO");
                sb.append(",FORCED=NO");
                if (StringUtils.isNotBlank(mediaSubtitle.getTitle())) {
                    String string = mediaSubtitle.getTitle();
                } else if (StringUtils.isNotBlank(mediaSubtitle.getName())) {
                    String string = mediaSubtitle.getName();
                } else if (StringUtils.isNotBlank(mediaSubtitle.getLangFullName())) {
                    String string = mediaSubtitle.getLangFullName();
                } else {
                    String string = String.valueOf(mediaSubtitle.getId());
                }
                if (mediaSubtitle.isForced() && !var16_27.toLowerCase().contains("forced")) {
                    String string = var16_27.concat(" (forced)");
                }
                sb.append(",NAME=\"").append((String)var16_29).append("\"");
                sb.append(",LANGUAGE=\"").append(mediaSubtitle.getLang()).append("\"");
                sb.append(",URI=\"").append(baseUrl).append(id).append("/hls/").append(NONE_CONF_NAME).append("_").append(NONE_CONF_NAME).append("_").append(mediaSubtitle.getId()).append(".m3u8\"\n");
            }
            if (mediaInfo.hasChapters()) {
                sb.append("#EXT-X-SESSION-DATA:DATA-ID=\"com.apple.hls.chapters\",URI=\"").append(baseUrl).append(id).append("/hls/chapters.json\"\n");
            }
            ArrayList<Object> arrayList = new ArrayList<Object>();
            arrayList.add(HlsVideoConfiguration.getByKey(COPY_CONF_NAME));
            if (renderer.getHlsMultiVideoQuality()) {
                for (HlsVideoConfiguration videoConf : HlsVideoConfiguration.getValues()) {
                    if (!videoConf.isTranscodable || arrayList.contains(videoConf) || mediaInfo.getHeight() == videoConf.resolutionHeight || mediaInfo.getWidth() == videoConf.resolutionWidth || (maxHeight < videoConf.resolutionHeight || mediaInfo.getWidth() < videoConf.resolutionWidth) && !"LD".equals(videoConf.label)) continue;
                    arrayList.add(videoConf);
                }
            }
            for (HlsVideoConfiguration hlsVideoConfiguration : arrayList) {
                for (HlsAudioConfiguration audioGroup : audioGroups) {
                    sb.append("#EXT-X-STREAM-INF:BANDWIDTH=");
                    if (hlsVideoConfiguration.label.equals(COPY_CONF_NAME)) {
                        sb.append(mediaInfo.getBitRate());
                        sb.append(",RESOLUTION=").append(mediaInfo.getWidth()).append("x").append(mediaInfo.getHeight());
                        sb.append(",AUDIO=\"").append(audioGroup.label).append("\"");
                        sb.append(",CODECS=\"").append("avc1.");
                        sb.append(HlsHelper.getAvcProfileHex(mediaInfo));
                        sb.append(HlsHelper.getAvcLevelHex(mediaInfo));
                    } else {
                        sb.append(hlsVideoConfiguration.bandwidth);
                        sb.append(",RESOLUTION=").append(hlsVideoConfiguration.resolutionWidth).append("x").append(hlsVideoConfiguration.resolutionHeight);
                        sb.append(",AUDIO=\"").append(audioGroup.label).append("\"");
                        sb.append(",CODECS=\"").append(hlsVideoConfiguration.videoCodec);
                    }
                    sb.append(",").append(audioGroup.audioCodec).append("\"");
                    if (subtitleAdded) {
                        sb.append(",SUBTITLES=\"sub1\"");
                    }
                    sb.append("\n");
                    sb.append(baseUrl).append(id).append("/hls/").append(hlsVideoConfiguration.label).append("_").append(audioGroup.label).append("_");
                    if (mediaAudioDefault != null) {
                        sb.append(mediaAudioDefault.getId());
                    } else {
                        sb.append("0");
                    }
                    sb.append(".m3u8\n");
                }
            }
            return sb.toString();
        }
        return null;
    }

    public static String getHLSm3u8ForRendition(StoreItem resource, Renderer renderer, String baseUrl, String rendition) {
        if (resource.getMediaInfo() != null) {
            int hlsVersion = renderer.getHlsVersion();
            Double duration = resource.getMediaInfo().getDuration();
            double partLen = duration;
            String id = resource.getResourceId();
            String targetDurationStr = String.valueOf(Double.valueOf(Math.ceil(6.0)).intValue());
            String defaultDurationStr = hlsVersion > 2 ? String.format(Locale.ENGLISH, "%.6f", 6.0) : targetDurationStr;
            String filename = rendition.startsWith("NONE_NONE_") ? "vtt" : "ts";
            StringBuilder sb = new StringBuilder();
            sb.append("#EXTM3U\n");
            if (hlsVersion > 1) {
                sb.append("#EXT-X-VERSION:").append(hlsVersion).append("\n");
            }
            sb.append("#EXT-X-TARGETDURATION:").append(targetDurationStr).append("\n");
            sb.append("#EXT-X-MEDIA-SEQUENCE:0\n");
            sb.append("#EXT-X-PLAYLIST-TYPE:VOD\n");
            sb.append("#EXT-X-INDEPENDENT-SEGMENTS\n");
            int partCount = 0;
            while (partLen > 0.0) {
                sb.append("#EXTINF:");
                if (partLen >= 6.0) {
                    sb.append(defaultDurationStr);
                } else if (hlsVersion > 2) {
                    sb.append(String.format(Locale.ENGLISH, "%.6f", partLen));
                } else {
                    sb.append(String.valueOf(Double.valueOf(Math.ceil(partLen)).intValue()));
                }
                sb.append(",\n");
                sb.append(baseUrl).append(id).append("/hls/").append(rendition).append("/").append(partCount).append(".").append(filename).append("\n");
                partLen -= 6.0;
                ++partCount;
            }
            sb.append("#EXT-X-ENDLIST\n");
            return sb.toString();
        }
        return null;
    }

    private static TimeRange getTimeRange(String url) {
        int position;
        if (!url.contains("/")) {
            return null;
        }
        String positionStr = url.substring(url.lastIndexOf("/") + 1);
        if (!positionStr.contains(".")) {
            return null;
        }
        positionStr = positionStr.substring(0, positionStr.indexOf("."));
        try {
            position = Integer.parseInt(positionStr);
        }
        catch (NumberFormatException es) {
            return null;
        }
        double askedStart = Double.valueOf(position) * 6.0;
        return new TimeRange(askedStart, askedStart + 6.0);
    }

    public static InputStream getInputStream(String url, StoreItem resource) throws IOException {
        if (!url.contains("/hls/")) {
            return null;
        }
        String rendition = url.substring(url.lastIndexOf("/hls/") + 5);
        rendition = rendition.substring(0, rendition.indexOf("/"));
        HlsConfiguration hlsConfiguration = HlsHelper.getByKey(rendition);
        TimeRange timeRange = HlsHelper.getTimeRange(url);
        if (hlsConfiguration != null && timeRange != null) {
            return resource.getInputStream(timeRange, hlsConfiguration);
        }
        return null;
    }

    private static boolean isMediaAudioCompatible(MediaAudio mediaAudio) {
        return HlsHelper.getAudioConfiguration(mediaAudio) != null;
    }

    private static HlsAudioConfiguration getAudioConfiguration(MediaAudio mediaAudio) {
        if (mediaAudio.isAACLC()) {
            if (mediaAudio.getNumberOfChannels() < 3) {
                return HlsAudioConfiguration.getByKey("AAC-LC");
            }
            if (mediaAudio.getNumberOfChannels() == 6) {
                return HlsAudioConfiguration.getByKey("AAC-LC-6");
            }
        } else if (mediaAudio.isHEAAC()) {
            if (mediaAudio.getNumberOfChannels() < 3) {
                return HlsAudioConfiguration.getByKey("HE-AAC");
            }
            if (mediaAudio.getNumberOfChannels() == 6) {
                return HlsAudioConfiguration.getByKey("HE-AAC-6");
            }
        } else if (mediaAudio.isAC3()) {
            if (mediaAudio.getNumberOfChannels() < 3) {
                return HlsAudioConfiguration.getByKey("AC3");
            }
            if (mediaAudio.getNumberOfChannels() == 6) {
                return HlsAudioConfiguration.getByKey("AC3-6");
            }
        } else if (mediaAudio.isEAC3()) {
            if (mediaAudio.getNumberOfChannels() < 3) {
                return HlsAudioConfiguration.getByKey("EAC3");
            }
            if (mediaAudio.getNumberOfChannels() == 6) {
                return HlsAudioConfiguration.getByKey("EAC3-6");
            }
            if (mediaAudio.getNumberOfChannels() == 8) {
                return HlsAudioConfiguration.getByKey("EAC3-8");
            }
            if (mediaAudio.getNumberOfChannels() == 16) {
                return HlsAudioConfiguration.getByKey("EAC3-16");
            }
        }
        return null;
    }

    public static String getAvcLevelHex(MediaInfo mediaInfo) {
        if (mediaInfo != null && mediaInfo.hasVideoTrack()) {
            MediaVideo mediaVideo = mediaInfo.getDefaultVideoTrack();
            if (mediaVideo.isH264() && mediaVideo.getFormatLevel() != null) {
                return H264.getAvcLevelHex(mediaVideo.getFormatLevelAsDouble(4.1));
            }
            int width = mediaVideo.getWidth();
            int height = mediaVideo.getHeight();
            if (width > 3840 || height > 2160) {
                return "3D";
            }
            if (width > 1920 || height > 1080) {
                return "34";
            }
            if (width > 842 || height > 480) {
                return "2A";
            }
            if (width > 640 || height > 360) {
                return "29";
            }
            return "1E";
        }
        return "29";
    }

    public static String getAvcProfileHex(MediaInfo mediaInfo) {
        if (mediaInfo != null && mediaInfo.hasVideoTrack()) {
            String profileHex;
            MediaVideo mediaVideo = mediaInfo.getDefaultVideoTrack();
            if (mediaVideo.isH264() && mediaVideo.getFormatProfile() != null && (profileHex = H264.getAvcProfileHex(mediaVideo.getFormatProfile())) != null) {
                return profileHex;
            }
            int width = mediaVideo.getWidth();
            int height = mediaVideo.getHeight();
            if (width > 640 || height > 360) {
                return "6400";
            }
        }
        return "4D00";
    }

    public static String getChaptersWebVtt(StoreItem resource) {
        StringBuilder chaptersVtt = new StringBuilder();
        chaptersVtt.append("WEBVTT\n");
        MediaInfo mediaInfo = resource.getMediaInfo();
        if (mediaInfo != null && mediaInfo.hasChapters()) {
            for (MediaChapter chapter : mediaInfo.getChapters()) {
                int chaptersNum = chapter.getId() + 1;
                chaptersVtt.append("\nChapter ").append(chaptersNum).append("\n");
                long nanoOfDay = (long)(chapter.getStart() * 1.0E9);
                LocalTime lt = LocalTime.ofNanoOfDay(nanoOfDay);
                chaptersVtt.append(lt.format(CHAPTERS_TIMESTAMP_FORMATTER));
                chaptersVtt.append(" --> ");
                nanoOfDay = (long)(chapter.getEnd() * 1.0E9);
                lt = LocalTime.ofNanoOfDay(nanoOfDay);
                chaptersVtt.append(lt.format(CHAPTERS_TIMESTAMP_FORMATTER)).append("\n");
                if (StringUtils.isNotBlank(chapter.getTitle())) {
                    chaptersVtt.append(chapter.getTitle());
                } else {
                    chaptersVtt.append(Messages.getString("Chapter")).append(" ").append(String.format("%02d", chaptersNum));
                }
                chaptersVtt.append("\n");
            }
        }
        return chaptersVtt.toString();
    }

    public static String getChaptersHls(StoreItem resource) {
        StringBuilder sb = new StringBuilder();
        sb.append("[");
        MediaInfo mediaInfo = resource.getMediaInfo();
        if (mediaInfo != null && mediaInfo.hasChapters()) {
            for (MediaChapter chapter : mediaInfo.getChapters()) {
                sb.append("{").append("\"start-time\": ").append(chapter.getStart()).append("},");
            }
            sb.deleteCharAt(sb.length() - 1);
        }
        sb.append("]");
        return sb.toString();
    }

    public static class HlsVideoConfiguration {
        private static final Map<String, HlsVideoConfiguration> BY_LABEL = new LinkedHashMap<String, HlsVideoConfiguration>();
        public final String label;
        public final String description;
        public final int resolutionWidth;
        public final int resolutionHeight;
        public final int bandwidth;
        public final String videoCodec;
        public final int maxVideoBitRate;
        public final boolean isTranscodable;

        public HlsVideoConfiguration(String label, String description, int resolutionWidth, int resolutionHeight, int bandwidth, String videoCodec, int maxVideoBitRate, boolean isTranscodable) {
            this.label = label;
            this.description = description;
            this.resolutionWidth = resolutionWidth;
            this.resolutionHeight = resolutionHeight;
            this.bandwidth = bandwidth;
            this.videoCodec = videoCodec;
            this.maxVideoBitRate = maxVideoBitRate;
            this.isTranscodable = isTranscodable;
        }

        public static HlsVideoConfiguration getByKey(String label) {
            return BY_LABEL.get(label);
        }

        public static HlsVideoConfiguration[] getValues() {
            return BY_LABEL.values().toArray(new HlsVideoConfiguration[0]);
        }

        static {
            BY_LABEL.put(HlsHelper.NONE_CONF_NAME, new HlsVideoConfiguration(HlsHelper.NONE_CONF_NAME, "", -1, 0, 0, "", 0, false));
            BY_LABEL.put(HlsHelper.COPY_CONF_NAME, new HlsVideoConfiguration(HlsHelper.COPY_CONF_NAME, "", 0, 0, 0, "avc1.640029", 0, false));
            BY_LABEL.put("UHD2", new HlsVideoConfiguration("UHD2", "Ultra High Definition 8K", 7680, 4320, 72000000, "avc1.64003D", 64000000, true));
            BY_LABEL.put("UHD1", new HlsVideoConfiguration("UHD1", "Ultra High Definition 4K", 3840, 2160, 18000000, "avc1.640034", 16000000, true));
            BY_LABEL.put("QHD", new HlsVideoConfiguration("QHD", "Quad High Definition", 2560, 1440, 8000000, "avc1.640033", 9600000, true));
            BY_LABEL.put("FHD", new HlsVideoConfiguration("FHD", "Full High Definition", 1920, 1080, 5000000, "avc1.64002A", 4800000, true));
            BY_LABEL.put("HD", new HlsVideoConfiguration("HD", "High Definition", 1280, 720, 2800000, "avc1.64002A", 2400000, true));
            BY_LABEL.put("SD", new HlsVideoConfiguration("SD", "Standard Definition", 842, 480, 1400000, "avc1.640029", 1200000, true));
            BY_LABEL.put("LD", new HlsVideoConfiguration("LD", "Low Definition", 640, 360, 800000, "avc1.4D401E", 600000, true));
            BY_LABEL.put("ULD", new HlsVideoConfiguration("ULD", "Ultra-Low Definition", 426, 240, 350000, "avc1.4D401E", 350000, true));
        }
    }

    public static class HlsAudioConfiguration {
        private static final Map<String, HlsAudioConfiguration> BY_LABEL = new LinkedHashMap<String, HlsAudioConfiguration>();
        public final String label;
        public final String description;
        public final String audioCodec;
        public final int audioBitRate;
        public final int audioChannels;
        public final boolean isTranscodable;

        public static HlsAudioConfiguration getByKey(String label) {
            return BY_LABEL.get(label);
        }

        public HlsAudioConfiguration(String label, String description, String audioCodec, int audioBitRate, int audioChannels, boolean isTranscodable) {
            this.label = label;
            this.description = description;
            this.audioCodec = audioCodec;
            this.audioBitRate = audioBitRate;
            this.audioChannels = audioChannels;
            this.isTranscodable = isTranscodable;
        }

        static {
            BY_LABEL.put("AAC-LC", new HlsAudioConfiguration("AAC-LC", "AAC", "mp4a.40.2", 160000, 2, true));
            BY_LABEL.put("AAC-LC-6", new HlsAudioConfiguration("AAC-LC-6", "AAC 5.1", "mp4a.40.2", 320000, 6, false));
            BY_LABEL.put("HE-AAC", new HlsAudioConfiguration("HE-AAC", "HE-AAC", "mp4a.40.5", 160000, 2, false));
            BY_LABEL.put("HE-AAC-6", new HlsAudioConfiguration("HE-AAC-6", "HE-AAC 5.1", "mp4a.40.5", 160000, 2, false));
            BY_LABEL.put("HE-AACv2", new HlsAudioConfiguration("HE-AACv2", "HE-AACv2", "mp4a.40.29", 160000, 2, false));
            BY_LABEL.put("MP3", new HlsAudioConfiguration("MP3", "MPEG-1/2 Audio Layer III", "mp4a.40.34", 192000, 2, false));
            BY_LABEL.put("AC3", new HlsAudioConfiguration("AC3", "Dolby Digital", "ac-3", 384000, 2, true));
            BY_LABEL.put("AC3-6", new HlsAudioConfiguration("AC3-6", "Dolby Digital 5.1", "ac-3", 384000, 6, false));
            BY_LABEL.put("EAC3", new HlsAudioConfiguration("EAC3", "Dolby Digital Plus", "ec-3", 160000, 2, true));
            BY_LABEL.put("EAC3-6", new HlsAudioConfiguration("EAC3-6", "Dolby Digital Plus 5.1", "ec-3", 192000, 6, false));
            BY_LABEL.put("EAC3-8", new HlsAudioConfiguration("EAC3-8", "Dolby Digital Plus 7.1", "ec-3", 384000, 8, false));
            BY_LABEL.put("EAC3-16", new HlsAudioConfiguration("EAC3-16", "Dolby Digital Plus with Dolby Atmos", "ec-3", 768000, 16, false));
            BY_LABEL.put(HlsHelper.NONE_CONF_NAME, new HlsAudioConfiguration(HlsHelper.NONE_CONF_NAME, "Removed audio", "", 0, 0, false));
            BY_LABEL.put(HlsHelper.COPY_CONF_NAME, new HlsAudioConfiguration(HlsHelper.COPY_CONF_NAME, "Copied audio", "", 0, 0, false));
        }
    }

    public static class HlsConfiguration {
        public final HlsVideoConfiguration video;
        public final HlsAudioConfiguration audio;
        public final int audioStream;
        public final int subtitle;

        public HlsConfiguration(HlsVideoConfiguration video, HlsAudioConfiguration audio, int audioStream, int subtitle) {
            this.video = video;
            this.audio = audio;
            this.audioStream = audioStream;
            this.subtitle = subtitle;
        }

        public boolean isSubtitle() {
            return this.subtitle > -1;
        }

        public String toString() {
            return "BANDWIDTH=" + this.video.bandwidth + ",RESOLUTION=" + this.video.resolutionWidth + "x" + this.video.resolutionHeight + ",CODECS=\"" + this.video.videoCodec + "," + this.audio.audioCodec + "\"";
        }
    }
}

