/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.configuration.FFmpegWebFilters;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EngineId;
import net.pms.encoders.FFMpegVideo;
import net.pms.encoders.FFmpegLogLevels;
import net.pms.encoders.FFmpegOptions;
import net.pms.encoders.StandardEngineId;
import net.pms.io.IPipeProcess;
import net.pms.io.OutputParams;
import net.pms.io.OutputTextLogger;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.media.MediaInfo;
import net.pms.parsers.FFmpegParser;
import net.pms.platform.PlatformUtils;
import net.pms.renderers.OutputOverride;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.util.ExecutableInfo;
import net.pms.util.FFmpegExecutableInfo;
import net.pms.util.PlayerUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFmpegWebVideo
extends FFMpegVideo {
    private static final Logger LOGGER = LoggerFactory.getLogger(FFmpegWebVideo.class);
    public static final EngineId ID = StandardEngineId.FFMPEG_WEB_VIDEO;
    public static final String KEY_FFMPEG_WEB_EXECUTABLE_TYPE = "ffmpeg_web_executable_type";
    public static final String NAME = "FFmpeg Web Video";
    static final Matcher END_OF_HEADER = Pattern.compile("Press \\[q\\]|A-V:|At least|Invalid").matcher("");

    FFmpegWebVideo() {
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public String getExecutableTypeKey() {
        return KEY_FFMPEG_WEB_EXECUTABLE_TYPE;
    }

    @Override
    public int purpose() {
        return 2;
    }

    @Override
    public boolean isTimeSeekable() {
        return false;
    }

    @Override
    public synchronized ProcessWrapper launchTranscode(StoreItem resource, MediaInfo media, OutputParams params) throws IOException {
        String ffmpegOptions;
        String attached;
        params.setMinBufferSize(params.getMinFileSize());
        params.setSecondReadMinSize(100000);
        Renderer renderer = params.getMediaRenderer();
        UmsConfiguration configuration = renderer.getUmsConfiguration();
        Object filename = resource.getFileName();
        FFmpegWebVideo.setAudioAndSubs(resource, params);
        if (((String)filename).startsWith("mms:")) {
            filename = "mmsh:" + ((String)filename).substring(4);
        }
        filename = FFmpegWebFilters.getReplacements((String)filename);
        FFmpegOptions customOptions = new FFmpegOptions();
        List<String> opts = FFmpegWebFilters.getAutoOptions((String)filename);
        if (opts != null) {
            customOptions.addAll((List)opts);
        }
        if (params.getHeader() != null && params.getHeader().length > 0) {
            String hdr = new String(params.getHeader(), StandardCharsets.UTF_8);
            customOptions.addAll((List)FFmpegWebVideo.parseOptions(hdr));
        }
        if ((attached = (String)resource.getAttachment(ID.toString())) != null) {
            customOptions.addAll((List)FFmpegWebVideo.parseOptions(attached));
        }
        if (StringUtils.isNotEmpty(ffmpegOptions = renderer.getCustomFFmpegOptions())) {
            customOptions.addAll((List)FFmpegWebVideo.parseOptions(ffmpegOptions));
        }
        ArrayList<String> cmdList = new ArrayList<String>();
        cmdList.add(this.getExecutable());
        cmdList.add("-y");
        cmdList.add("-loglevel");
        FFmpegLogLevels askedLogLevel = FFmpegLogLevels.valueOfLabel(configuration.getFFmpegLoggingLevel());
        if (LOGGER.isTraceEnabled()) {
            if (FFmpegLogLevels.INFO.isMoreVerboseThan(askedLogLevel)) {
                cmdList.add("info");
            } else {
                cmdList.add(askedLogLevel.label);
            }
        } else if (FFmpegLogLevels.WARNING.isMoreVerboseThan(askedLogLevel)) {
            cmdList.add("warning");
        } else {
            cmdList.add(askedLogLevel.label);
        }
        int nThreads = 1;
        if (configuration.isFfmpegMultithreading()) {
            nThreads = Runtime.getRuntime().availableProcessors() == configuration.getNumberOfCpuCores() ? 0 : configuration.getNumberOfCpuCores();
        }
        if (nThreads > 0) {
            cmdList.add("-threads");
            cmdList.add("" + nThreads);
        }
        if (!customOptions.isEmpty()) {
            customOptions.transferGlobals(cmdList);
            customOptions.transferInputFileOptions(cmdList);
        }
        if (params.getTimeSeek() > 0.0) {
            cmdList.add("-ss");
            cmdList.add("" + (int)params.getTimeSeek());
        }
        cmdList.add("-i");
        cmdList.add((String)filename);
        cmdList.addAll(this.getVideoFilterOptions(resource, media, params, false));
        if (nThreads > 0) {
            cmdList.add("-threads");
            cmdList.add("" + nThreads);
        }
        boolean override = false;
        if (renderer instanceof OutputOverride) {
            OutputOverride outputOverride = (OutputOverride)((Object)renderer);
            override = outputOverride.getOutputOptions(cmdList, resource, this, params);
        }
        if (!override) {
            cmdList.addAll(this.getVideoTranscodeOptions(resource, media, params, false));
            cmdList.addAll(this.getVideoBitrateOptions(resource, media, params, false));
            cmdList.addAll(this.getAudioBitrateOptions(resource, media, params));
            if (!customOptions.isEmpty()) {
                customOptions.transferAll(cmdList);
            }
        }
        String fifoName = String.format("ffmpegwebvideo_%d_%d", Thread.currentThread().getId(), System.currentTimeMillis());
        IPipeProcess pipe = PlatformUtils.INSTANCE.getPipeProcess(fifoName, new String[0]);
        pipe.deleteLater();
        ProcessWrapper mkfifoProcess = pipe.getPipeProcess();
        mkfifoProcess.runInSameThread();
        params.getInputPipes()[0] = pipe;
        cmdList.add(pipe.getInputPipe());
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        FFmpegWebVideo.parseMediaInfo((String)filename, resource, pw);
        pw.attachProcess(mkfifoProcess);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread interrupted while waiting for named pipe to be created", e);
            Thread.currentThread().interrupt();
        }
        pw.runInNewThread();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread interrupted while waiting for transcode to start", e);
            Thread.currentThread().interrupt();
        }
        return pw;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isCompatible(StoreItem item) {
        if (PlayerUtil.isWebVideo(item)) {
            String url = item.getFileName();
            ExecutableInfo executableInfo = this.programInfo.getExecutableInfo(this.currentExecutableType);
            if (executableInfo instanceof FFmpegExecutableInfo) {
                List<String> protocols = FFmpegOptions.getSupportedProtocols(executableInfo.getPath());
                if (!protocols.contains(url.split(":")[0])) {
                    return false;
                }
            } else {
                LOGGER.warn("Couldn't check {} protocol compatibility for \"{}\", reporting as not compatible", (Object)this.getClass().getSimpleName(), (Object)url.split(":")[0]);
                return false;
            }
            if (FFmpegWebVideo.isYouTubeURL(url)) {
                return false;
            }
            return !FFmpegWebFilters.isExluded(url);
        }
        return false;
    }

    public static void parseMediaInfo(final String filename, final StoreItem item, ProcessWrapperImpl pw) {
        if (item.getMediaInfo() == null) {
            item.setMediaInfo(new MediaInfo());
        } else if (item.getMediaInfo().isMediaParsed()) {
            return;
        }
        OutputTextLogger ffParser = new OutputTextLogger(null){
            final ArrayList<String> lines;
            final String input;
            {
                super(inputStream);
                this.lines = new ArrayList();
                this.input = filename.length() > 200 ? filename.substring(0, 199) : filename;
            }

            @Override
            public boolean filter(String line) {
                if (END_OF_HEADER.reset(line).find()) {
                    FFmpegParser.parseFFmpegInfo(item.getMediaInfo(), this.lines, this.input);
                    LOGGER.trace("[{}] parsed media from headers: {}", (Object)ID, (Object)item.getMediaInfo());
                    item.getParent().updateChild(item);
                    return false;
                }
                this.lines.add(line);
                return true;
            }
        };
        ffParser.setFiltered(true);
        pw.setStderrConsumer(ffParser);
    }

    public static boolean isYouTubeURL(String youTubeUrl) {
        String pattern = "(?<=youtu.be/|watch\\?v=|/videos/|embed\\/)[^#\\&\\?]*";
        Pattern compiledPattern = Pattern.compile(pattern);
        Matcher matcher = compiledPattern.matcher(youTubeUrl);
        return matcher.find();
    }
}

