/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.util.HashMap;
import java.util.Map;

public enum FFmpegLogLevels {
    QUIET("quiet", -8),
    PANIC("panic", 0),
    FATAL("fatal", 8),
    ERROR("error", 16),
    WARNING("warning", 24),
    INFO("info", 32),
    VERBOSE("verbose", 40),
    DEBUG("debug", 48),
    TRACE("trace", 56);

    public final int level;
    public final String label;
    private static final Map<String, FFmpegLogLevels> BY_LABEL;

    private FFmpegLogLevels(String label, int level) {
        this.label = label;
        this.level = level;
    }

    public boolean isMoreVerboseThan(FFmpegLogLevels otherFFmpegLogLevel) {
        if (otherFFmpegLogLevel == null) {
            return true;
        }
        return otherFFmpegLogLevel.level < this.level;
    }

    public static String[] getLabels() {
        return BY_LABEL.keySet().toArray(new String[0]);
    }

    public static FFmpegLogLevels valueOfLabel(String label) {
        return BY_LABEL.get(label);
    }

    public static FFmpegLogLevels valueOfLevel(int level) {
        for (FFmpegLogLevels e : FFmpegLogLevels.values()) {
            if (e.level != level) continue;
            return e;
        }
        return null;
    }

    static {
        BY_LABEL = new HashMap<String, FFmpegLogLevels>();
        for (FFmpegLogLevels e : FFmpegLogLevels.values()) {
            BY_LABEL.put(e.label, e);
        }
    }
}

