/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.sun.jna.Platform;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import net.pms.Messages;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.AviSynthFFmpeg;
import net.pms.encoders.EncodingFormat;
import net.pms.encoders.Engine;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.EngineId;
import net.pms.encoders.FFmpegLogLevels;
import net.pms.encoders.FFmpegOptions;
import net.pms.encoders.MEncoderVideo;
import net.pms.encoders.StandardEngineId;
import net.pms.encoders.TsMuxeRVideo;
import net.pms.formats.Format;
import net.pms.formats.v2.SubtitleType;
import net.pms.io.IPipeProcess;
import net.pms.io.ListProcessWrapperResult;
import net.pms.io.OutputParams;
import net.pms.io.OutputTextLogger;
import net.pms.io.PipeIPCProcess;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.SimpleProcessWrapper;
import net.pms.io.StreamModifier;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.platform.PlatformUtils;
import net.pms.platform.windows.NTStatus;
import net.pms.renderers.OutputOverride;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.util.CodecUtil;
import net.pms.util.ExecutableErrorType;
import net.pms.util.ExecutableInfo;
import net.pms.util.FFmpegExecutableInfo;
import net.pms.util.InputFile;
import net.pms.util.PlayerUtil;
import net.pms.util.ProcessUtil;
import net.pms.util.StringUtil;
import net.pms.util.SubtitleUtils;
import net.pms.util.Version;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FFMpegVideo
extends Engine {
    private static final Logger LOGGER = LoggerFactory.getLogger(FFMpegVideo.class);
    public static final EngineId ID = StandardEngineId.FFMPEG_VIDEO;
    public static final String KEY_FFMPEG_PATH = "ffmpeg_path";
    public static final String KEY_FFMPEG_EXECUTABLE_TYPE = "ffmpeg_executable_type";
    public static final String NAME = "FFmpeg Video";
    private static final String DEFAULT_QSCALE = "3";
    static final Matcher RE_DURATION = Pattern.compile("Duration:\\s+([\\d:.]+),").matcher("");

    FFMpegVideo() {
        super(CONFIGURATION.getFFmpegPaths());
    }

    public List<String> getVideoFilterOptions(StoreItem resource, MediaInfo mediaInfo, OutputParams params, boolean isConvertedTo3d) throws IOException {
        String overrideVF;
        ArrayList<String> videoFilterOptions = new ArrayList<String>();
        ArrayList filterChain = new ArrayList();
        Renderer renderer = params.getMediaRenderer();
        UmsConfiguration configuration = renderer.getUmsConfiguration();
        MediaVideo defaultVideoTrack = mediaInfo != null ? mediaInfo.getDefaultVideoTrack() : null;
        boolean isMediaValid = mediaInfo != null && mediaInfo.isMediaParsed() && defaultVideoTrack != null && defaultVideoTrack.getHeight() != 0;
        boolean isResolutionTooHighForRenderer = isMediaValid && defaultVideoTrack != null && !renderer.isResolutionCompatibleWithRenderer(defaultVideoTrack.getWidth(), defaultVideoTrack.getHeight());
        int scaleWidth = 0;
        int scaleHeight = 0;
        if (defaultVideoTrack != null && defaultVideoTrack.getWidth() > 0 && defaultVideoTrack.getHeight() > 0) {
            scaleWidth = defaultVideoTrack.getWidth();
            scaleHeight = defaultVideoTrack.getHeight();
        }
        boolean is3D = defaultVideoTrack != null && defaultVideoTrack.is3d() && !defaultVideoTrack.multiViewIsAnaglyph() || isConvertedTo3d;
        boolean keepAR = (renderer.isKeepAspectRatio() || renderer.isKeepAspectRatioTranscoding()) && defaultVideoTrack != null && !defaultVideoTrack.is3dFullSbsOrOu() && !isConvertedTo3d && !"16:9".equals(defaultVideoTrack.getDisplayAspectRatio());
        ArrayList<Object> scalePadFilterChain = new ArrayList<Object>();
        if (isResolutionTooHighForRenderer || !renderer.isRescaleByRenderer() && renderer.isMaximumResolutionSpecified() && mediaInfo.getWidth() < 720) {
            if (defaultVideoTrack != null && defaultVideoTrack.is3dFullSbsOrOu()) {
                scalePadFilterChain.add(String.format("[0:v]scale=%1$d:%2$d", renderer.getMaxVideoWidth(), renderer.getMaxVideoHeight()));
            } else {
                scalePadFilterChain.add(String.format("[0:v]scale=iw*min(%1$d/iw\\,%2$d/ih):ih*min(%1$d/iw\\,%2$d/ih)", renderer.getMaxVideoWidth(), renderer.getMaxVideoHeight()));
                scalePadFilterChain.add(String.format("[0:v]pad=ceil(iw/4)*4:ceil(ih/4)*4:(ow-iw)/2:(oh-ih)/2", new Object[0]));
                if (keepAR) {
                    scalePadFilterChain.add(String.format("[0:v]pad=%1$d:%2$d:(%1$d-iw)/2:(%2$d-ih)/2", renderer.getMaxVideoWidth(), renderer.getMaxVideoHeight()));
                }
            }
        } else if (keepAR && isMediaValid) {
            if ((double)mediaInfo.getWidth() / (double)mediaInfo.getHeight() >= 1.7777777777777777) {
                scalePadFilterChain.add("[0:v]pad=iw:iw/(16/9):0:(oh-ih)/2");
                scaleHeight = (int)Math.round((double)scaleWidth / 1.7777777777777777);
            } else {
                scalePadFilterChain.add("[0:v]pad=ih*(16/9):ih:(ow-iw)/2:0");
                scaleWidth = (int)Math.round((double)scaleHeight * 1.7777777777777777);
            }
            scaleWidth = FFMpegVideo.convertToModX(scaleWidth, 4);
            scaleHeight = FFMpegVideo.convertToModX(scaleHeight, 4);
            if (scaleHeight > renderer.getMaxVideoHeight() || scaleWidth > renderer.getMaxVideoWidth()) {
                scaleHeight = renderer.getMaxVideoHeight();
                scaleWidth = renderer.getMaxVideoWidth();
            }
            scalePadFilterChain.add("[0:v]scale=" + scaleWidth + ":" + scaleHeight);
        }
        filterChain.addAll(scalePadFilterChain);
        boolean override = true;
        if (renderer instanceof OutputOverride) {
            OutputOverride or = (OutputOverride)((Object)renderer);
            override = or.addSubtitles();
        }
        if (!this.isDisableSubtitles(params) && override) {
            boolean isSubsManualTiming = true;
            MediaSubtitle convertedSubs = resource.getMediaSubtitle();
            StringBuilder subsFilter = new StringBuilder();
            if (params.getSid() != null && params.getSid().getType().isText()) {
                boolean isSubsASS = params.getSid().getType() == SubtitleType.ASS;
                String originalSubsFilename = null;
                if (is3D) {
                    if (convertedSubs != null && convertedSubs.getConvertedFile() != null) {
                        originalSubsFilename = convertedSubs.getConvertedFile().getAbsolutePath();
                    } else if (!isSubsASS) {
                        File subtitlesFile = SubtitleUtils.getSubtitles(resource, mediaInfo, params, configuration, SubtitleType.ASS);
                        if (subtitlesFile != null) {
                            originalSubsFilename = subtitlesFile.getAbsolutePath();
                        } else {
                            LOGGER.error("External subtitles file \"{}\" is unavailable", (Object)params.getSid().getName());
                        }
                    } else if (params.getSid().getExternalFile() != null) {
                        originalSubsFilename = params.getSid().getExternalFile().getPath();
                    } else {
                        LOGGER.error("External subtitles file \"{}\" is unavailable", (Object)params.getSid().getName());
                    }
                } else if (params.getSid().isExternal()) {
                    if (params.getSid().getExternalFile() != null) {
                        if (!renderer.streamSubsForTranscodedVideo() || !renderer.isExternalSubtitlesFormatSupported(params.getSid(), resource)) {
                            originalSubsFilename = params.getSid().getExternalFile().getPath();
                        }
                    } else {
                        LOGGER.error("External subtitles file \"{}\" is unavailable", (Object)params.getSid().getName());
                    }
                } else {
                    originalSubsFilename = resource.getFileName();
                }
                if (originalSubsFilename != null) {
                    subsFilter.append("subtitles=").append(StringUtil.ffmpegEscape(originalSubsFilename));
                    if (params.getSid().isEmbedded()) {
                        subsFilter.append(":si=").append(params.getSid().getId());
                    }
                    if (!params.getSid().isSubsUtf8()) {
                        if (StringUtils.isNotBlank(configuration.getSubtitlesCodepage())) {
                            subsFilter.append(":charenc=").append(configuration.getSubtitlesCodepage());
                        } else if (params.getSid().getSubCharacterSet() != null) {
                            subsFilter.append(":charenc=").append(params.getSid().getSubCharacterSet());
                        }
                    }
                    if (configuration.isFFmpegFontConfig() && !is3D && !isSubsASS) {
                        String font;
                        subsFilter.append(":force_style=");
                        subsFilter.append("'");
                        String fontName = configuration.getFont();
                        if (StringUtils.isNotBlank(fontName) && (font = CodecUtil.isFontRegisteredInOS(fontName)) != null) {
                            subsFilter.append("Fontname=").append(font);
                        }
                        subsFilter.append(",Fontsize=").append(15.0 * Double.parseDouble(configuration.getAssScale()));
                        subsFilter.append(",PrimaryColour=").append(configuration.getSubsColor().getASSv4StylesHexValue());
                        subsFilter.append(",Outline=").append(configuration.getAssOutline());
                        subsFilter.append(",Shadow=").append(configuration.getAssShadow());
                        subsFilter.append(",MarginV=").append(configuration.getAssMargin());
                        subsFilter.append("'");
                    }
                }
            } else if (params.getSid().getType().isPicture()) {
                StringBuilder subsPictureFilter = new StringBuilder();
                if (params.getSid().isEmbedded()) {
                    subsPictureFilter.append("[0:v][0:s:").append(mediaInfo.getSubtitlesTracks().indexOf(params.getSid())).append("]overlay");
                    isSubsManualTiming = false;
                } else if (params.getSid().getExternalFile() != null) {
                    videoFilterOptions.add("-i");
                    videoFilterOptions.add(params.getSid().getExternalFile().getPath());
                    subsPictureFilter.append("[0:v][1:s]overlay");
                }
                filterChain.add(0, subsPictureFilter.toString());
            }
            if (StringUtils.isNotBlank(subsFilter)) {
                if (params.getTimeSeek() > 0.0 && isSubsManualTiming) {
                    filterChain.add("setpts=PTS+" + params.getTimeSeek() + "/TB");
                }
                filterChain.add(subsFilter.toString());
                if (params.getTimeSeek() > 0.0 && isSubsManualTiming) {
                    filterChain.add("setpts=PTS-STARTPTS");
                }
            }
        }
        if (StringUtils.isNotEmpty(overrideVF = renderer.getFFmpegVideoFilterOverride())) {
            filterChain.add(overrideVF);
        }
        String stereoLayout = null;
        String renderer3DOutputFormat = null;
        if (defaultVideoTrack != null && defaultVideoTrack.get3DLayout() != null) {
            stereoLayout = defaultVideoTrack.get3DLayout().toString().toLowerCase(Locale.ROOT);
            renderer3DOutputFormat = renderer.getOutput3DFormat();
        }
        if (is3D && stereoLayout != null && StringUtils.isNotBlank(renderer3DOutputFormat) && !stereoLayout.equals(renderer3DOutputFormat)) {
            filterChain.add("stereo3d=" + stereoLayout + ":" + renderer3DOutputFormat);
        }
        if (!filterChain.isEmpty()) {
            videoFilterOptions.add("-filter_complex");
            videoFilterOptions.add(StringUtils.join(filterChain, ","));
        }
        return videoFilterOptions;
    }

    protected synchronized List<String> getVideoTranscodeOptions(StoreItem item, MediaInfo media, OutputParams params, boolean canMuxVideoWithFFmpeg) {
        ArrayList<String> transcodeOptions = new ArrayList<String>();
        String filename = item.getFileName();
        Renderer renderer = params.getMediaRenderer();
        UmsConfiguration configuration = renderer.getUmsConfiguration();
        String customFFmpegOptions = renderer.getCustomFFmpegOptions();
        EncodingFormat encodingFormat = item.getTranscodingSettings().getEncodingFormat();
        if (encodingFormat.isTranscodeToWMV() && !renderer.isXbox360() || renderer.isXboxOne() && this.purpose() == 2) {
            transcodeOptions.add("-c:v");
            transcodeOptions.add("wmv2");
            if (!customFFmpegOptions.contains("-c:a ")) {
                transcodeOptions.add("-c:a");
                transcodeOptions.add("wmav2");
            }
            transcodeOptions.add("-f");
            transcodeOptions.add("asf");
        } else {
            MediaVideo defaultVideoTrack;
            boolean isSubtitlesAndTimeseek;
            boolean isTsMuxeRVideoEngineActive = EngineFactory.isEngineActive(TsMuxeRVideo.ID);
            boolean dtsRemux = isTsMuxeRVideoEngineActive && configuration.isAudioEmbedDtsInPcm() && params.getAid() != null && params.getAid().isDTS() && !this.isAviSynthEngine() && renderer.isDTSPlayable();
            boolean bl = isSubtitlesAndTimeseek = !this.isDisableSubtitles(params) && params.getTimeSeek() > 0.0;
            if (params.getAid() != null && (configuration.isAudioRemuxAC3() && params.getAid().isAC3() || !params.getAid().isAC3()) && renderer.isAudioStreamTypeSupportedInTranscodingContainer(params.getAid(), encodingFormat) && !this.isAviSynthEngine() && !isSubtitlesAndTimeseek && this.ffmpegSupportsRemuxingAudioStreamToTranscodingContainer(params.getAid(), encodingFormat.getTranscodingContainer())) {
                if (!customFFmpegOptions.contains("-c:a ")) {
                    transcodeOptions.add("-c:a");
                    transcodeOptions.add("copy");
                }
            } else {
                String logPrepend = "Audio was not remuxed because ";
                if (params.getAid() == null) {
                    LOGGER.trace(logPrepend + "there is no audio");
                } else {
                    if (!configuration.isAudioRemuxAC3() && params.getAid().isAC3()) {
                        LOGGER.trace(logPrepend + "audio is AC-3 and the user setting to remux AC-3 is disabled");
                    }
                    if (!renderer.isAudioStreamTypeSupportedInTranscodingContainer(params.getAid(), encodingFormat)) {
                        LOGGER.trace(logPrepend + "audio stream type {} is not supported inside the container {}", (Object)params.getAid().getAudioCodec(), (Object)encodingFormat);
                    }
                    if (!this.ffmpegSupportsRemuxingAudioStreamToTranscodingContainer(params.getAid(), encodingFormat.getTranscodingContainer())) {
                        LOGGER.trace(logPrepend + "FFmpeg does not support remuxing the audio stream {} to the transcoding container {}", (Object)params.getAid().getAudioCodec(), (Object)encodingFormat.getTranscodingContainer());
                    }
                }
                if (this.isAviSynthEngine()) {
                    LOGGER.trace(logPrepend + "this is AviSynth");
                }
                if (isSubtitlesAndTimeseek) {
                    LOGGER.trace(logPrepend + "there are subtitles and seeking involved");
                }
                if (dtsRemux) {
                    transcodeOptions.add("-an");
                } else if (this.type() != 1 && !customFFmpegOptions.matches(".*-(c:a|codec:a|acodec).*")) {
                    if (encodingFormat.isTranscodeToAAC()) {
                        transcodeOptions.add("-c:a");
                        transcodeOptions.add("aac");
                    } else if (!customFFmpegOptions.contains("-c:a ")) {
                        transcodeOptions.add("-c:a");
                        transcodeOptions.add("ac3");
                    }
                }
            }
            if (filename != null) {
                InputFile newInput = new InputFile();
                newInput.setFilename(filename);
                newInput.setPush(params.getStdIn());
            }
            if ((defaultVideoTrack = media.getDefaultVideoTrack()) != null) {
                if (canMuxVideoWithFFmpeg) {
                    if (!customFFmpegOptions.contains("-c:v")) {
                        transcodeOptions.add("-c:v");
                        transcodeOptions.add("copy");
                    }
                } else if (encodingFormat.isTranscodeToMPEG2() && !dtsRemux) {
                    if (!customFFmpegOptions.contains("-c:v")) {
                        transcodeOptions.add("-c:v");
                        transcodeOptions.add("mpeg2video");
                    }
                } else {
                    String selectedTranscodeAccelerationMethod = null;
                    if (!customFFmpegOptions.contains("-c:v")) {
                        transcodeOptions.add("-c:v");
                        if (encodingFormat.isTranscodeToH264()) {
                            selectedTranscodeAccelerationMethod = configuration.getFFmpegGPUH264EncodingAccelerationMethod();
                            transcodeOptions.add(selectedTranscodeAccelerationMethod);
                        } else if (encodingFormat.isTranscodeToH265()) {
                            selectedTranscodeAccelerationMethod = configuration.getFFmpegGPUH265EncodingAccelerationMethod();
                            transcodeOptions.add(selectedTranscodeAccelerationMethod);
                        }
                        if (selectedTranscodeAccelerationMethod != null && selectedTranscodeAccelerationMethod.endsWith("nvenc")) {
                            transcodeOptions.add("-preset");
                            transcodeOptions.add("llhp");
                        }
                    }
                    if (selectedTranscodeAccelerationMethod == null || selectedTranscodeAccelerationMethod.startsWith("libx264")) {
                        if (!customFFmpegOptions.contains("-preset")) {
                            transcodeOptions.add("-preset");
                            transcodeOptions.add("superfast");
                        }
                        if (!customFFmpegOptions.contains("-level")) {
                            transcodeOptions.add("-level");
                            transcodeOptions.add("31");
                        }
                    } else if (selectedTranscodeAccelerationMethod.startsWith("libx265") && !customFFmpegOptions.contains("-preset")) {
                        transcodeOptions.add("-preset");
                        transcodeOptions.add("superfast");
                    }
                    if (defaultVideoTrack.getBitDepth() == 8 || !renderer.isVideoBitDepthSupportedForAllFiletypes(10)) {
                        transcodeOptions.add("-pix_fmt");
                        transcodeOptions.add("yuv420p");
                    }
                }
                if (defaultVideoTrack.getHDRFormatForRenderer() != null) {
                    transcodeOptions.add("-strict");
                    transcodeOptions.add("unofficial");
                }
            }
            if (!customFFmpegOptions.contains("-f")) {
                transcodeOptions.add("-f");
                if (dtsRemux) {
                    transcodeOptions.add("mpeg2video");
                } else if (encodingFormat.isTranscodeToMPEGTS()) {
                    transcodeOptions.add("mpegts");
                } else if (encodingFormat.isTranscodeToMP4()) {
                    transcodeOptions.add("mp4");
                    transcodeOptions.add("-movflags");
                    transcodeOptions.add("frag_keyframe+faststart+delay_moov");
                } else {
                    transcodeOptions.add("vob");
                }
            }
        }
        return transcodeOptions;
    }

    public List<String> getVideoBitrateOptions(StoreItem item, MediaInfo media, OutputParams params, boolean dtsRemux) {
        ArrayList<String> videoBitrateOptions = new ArrayList<String>();
        boolean low = false;
        Renderer renderer = params.getMediaRenderer();
        UmsConfiguration configuration = renderer.getUmsConfiguration();
        MediaVideo defaultVideoTrack = media.getDefaultVideoTrack();
        EncodingFormat encodingFormat = item.getTranscodingSettings().getEncodingFormat();
        int[] defaultMaxBitrates = FFMpegVideo.getVideoBitrateConfig(configuration.getMaximumBitrate());
        int[] rendererMaxBitrates = new int[2];
        if (renderer.getMaxVideoBitrate() > 0) {
            rendererMaxBitrates = FFMpegVideo.getVideoBitrateConfig(Integer.toString(renderer.getMaxVideoBitrate()));
        }
        if (rendererMaxBitrates[0] > 0 && rendererMaxBitrates[0] < defaultMaxBitrates[0]) {
            LOGGER.trace("Using video bitrate limit from {} configuration ({} Mb/s) because it is lower than the general configuration bitrate limit ({} Mb/s)", renderer.getRendererName(), rendererMaxBitrates[0], defaultMaxBitrates[0]);
            defaultMaxBitrates = rendererMaxBitrates;
        } else {
            LOGGER.trace("Using video bitrate limit from the general configuration ({} Mb/s)", (Object)defaultMaxBitrates[0]);
        }
        boolean isXboxOneWebVideo = renderer.isXboxOne() && this.purpose() == 2;
        int maximumBitrate = defaultMaxBitrates[0];
        if (renderer.getCBRVideoBitrate() == 0 && params.getTimeEnd() == 0.0) {
            if (rendererMaxBitrates[0] < 0) {
                defaultMaxBitrates[0] = 3000;
                low = true;
            } else {
                defaultMaxBitrates[0] = 1000 * defaultMaxBitrates[0];
            }
            if (renderer.isHalveBitrate() && !configuration.isAutomaticMaximumBitrate()) {
                defaultMaxBitrates[0] = defaultMaxBitrates[0] / 2;
                LOGGER.trace("Halving the video bitrate limit to {} kb/s", (Object)defaultMaxBitrates[0]);
            }
            int bufSize = 1835;
            boolean bitrateLevel41Limited = false;
            if (!isXboxOneWebVideo && encodingFormat.isTranscodeToH264()) {
                if (renderer.getH264LevelLimit() < 4.2 && defaultMaxBitrates[0] > 31250) {
                    defaultMaxBitrates[0] = 31250;
                    bitrateLevel41Limited = true;
                    LOGGER.trace("Adjusting the video bitrate limit to the H.264 Level 4.1-safe value of 31250 kb/s");
                }
                bufSize = defaultMaxBitrates[0];
            } else {
                if (defaultVideoTrack != null && defaultVideoTrack.isHDVideo()) {
                    bufSize = defaultMaxBitrates[0] / 3;
                }
                if (bufSize > 7000) {
                    bufSize = 7000;
                }
                if (defaultMaxBitrates[1] > 0) {
                    bufSize = defaultMaxBitrates[1];
                }
                if (renderer.isDefaultVBVSize() && rendererMaxBitrates[1] == 0) {
                    bufSize = 1835;
                }
            }
            if (!bitrateLevel41Limited) {
                defaultMaxBitrates[0] = dtsRemux ? defaultMaxBitrates[0] - 1510 : defaultMaxBitrates[0] - configuration.getAudioBitrate();
                defaultMaxBitrates[0] = defaultMaxBitrates[0] / 1000 * 1000;
                if (low) {
                    defaultMaxBitrates[0] = 3000;
                }
                LOGGER.trace("Adjusting the video bitrate limit to {} kb/s to make room for audio", (Object)defaultMaxBitrates[0]);
            }
            if (defaultMaxBitrates[0] > 0) {
                if (!encodingFormat.isTranscodeToH265()) {
                    videoBitrateOptions.add("-bufsize");
                    videoBitrateOptions.add(String.valueOf(bufSize) + "k");
                }
                videoBitrateOptions.add("-maxrate");
                videoBitrateOptions.add(String.valueOf(defaultMaxBitrates[0]) + "k");
            }
        }
        if (isXboxOneWebVideo || encodingFormat.isTranscodeToMPEG2()) {
            String mpeg2Options = configuration.getMPEG2MainSettingsFFmpeg();
            String mpeg2OptionsRenderer = renderer.getCustomFFmpegMPEG2Options();
            if (StringUtils.isNotBlank(mpeg2OptionsRenderer)) {
                mpeg2Options = mpeg2OptionsRenderer;
            } else if (configuration.isAutomaticMaximumBitrate()) {
                mpeg2Options = renderer.getAutomaticVideoQuality();
            }
            if (mpeg2Options.contains("Automatic")) {
                mpeg2Options = mpeg2Options.contains("Wireless") ? (media.getWidth() > 1280 ? "-g 25 -qmin 2 -qmax 7" : (media.getWidth() > 720 ? "-g 25 -qmin 2 -qmax 5" : "-g 25 -qmin 2 -qmax 3")) : "-g 5 -q:v 1 -qmin 2 -qmax 3";
            }
            if (renderer.isPS3()) {
                mpeg2Options = "-g 25 -q:v 1 -qmin 2 -qmax 3";
            }
            String[] customOptions = StringUtils.split(mpeg2Options);
            videoBitrateOptions.addAll(new ArrayList<String>(Arrays.asList(customOptions)));
        } else {
            String x264CRF = configuration.getx264ConstantRateFactor();
            if (configuration.isAutomaticMaximumBitrate()) {
                x264CRF = renderer.getAutomaticVideoQuality();
            }
            if (x264CRF.contains("/*")) {
                x264CRF = x264CRF.substring(x264CRF.indexOf("/*"));
            }
            if (x264CRF.contains("Automatic")) {
                if (x264CRF.contains("Wireless") || maximumBitrate < 70) {
                    x264CRF = "19";
                    if (media.getWidth() > 1280) {
                        x264CRF = "23";
                    } else if (media.getWidth() > 720) {
                        x264CRF = "22";
                    }
                } else {
                    x264CRF = "16";
                    if (media.getWidth() > 720 && !encodingFormat.isTranscodeToH265()) {
                        x264CRF = "19";
                    }
                }
            }
            if (StringUtils.isNotBlank(x264CRF) && !renderer.nox264()) {
                videoBitrateOptions.add("-crf");
                videoBitrateOptions.add(x264CRF);
            }
        }
        return videoBitrateOptions;
    }

    public List<String> getAudioBitrateOptions(StoreItem item, MediaInfo media, OutputParams params) {
        Renderer renderer = params.getMediaRenderer();
        ArrayList<String> audioBitrateOptions = new ArrayList<String>();
        audioBitrateOptions.add("-q:a");
        audioBitrateOptions.add(DEFAULT_QSCALE);
        audioBitrateOptions.add("-ar");
        audioBitrateOptions.add("" + renderer.getTranscodedVideoAudioSampleRate());
        return audioBitrateOptions;
    }

    @Override
    public int purpose() {
        return 0;
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public String getConfigurablePathKey() {
        return KEY_FFMPEG_PATH;
    }

    @Override
    public String getExecutableTypeKey() {
        return KEY_FFMPEG_EXECUTABLE_TYPE;
    }

    @Override
    public boolean isTimeSeekable() {
        return true;
    }

    @Override
    public boolean isAviSynthEngine() {
        return false;
    }

    public String initialString() {
        Object threads = " -threads 1";
        if (CONFIGURATION.isFfmpegMultithreading()) {
            threads = Runtime.getRuntime().availableProcessors() == CONFIGURATION.getNumberOfCpuCores() ? "" : " -threads " + CONFIGURATION.getNumberOfCpuCores();
        }
        return threads;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int type() {
        return 4;
    }

    private static int[] getVideoBitrateConfig(String bitrate) {
        int[] bitrates = new int[2];
        if (bitrate.contains("(") && bitrate.contains(")")) {
            bitrates[1] = Integer.parseInt(bitrate.substring(bitrate.indexOf(40) + 1, bitrate.indexOf(41)));
        }
        if (bitrate.contains("(")) {
            bitrate = bitrate.substring(0, bitrate.indexOf(40)).trim();
        }
        if (StringUtils.isBlank(bitrate)) {
            bitrate = "0";
        }
        bitrates[0] = (int)Double.parseDouble(bitrate);
        return bitrates;
    }

    @Override
    public String getMimeType() {
        return "video/transcode";
    }

    @Override
    public boolean isGPUAccelerationReady() {
        return true;
    }

    @Override
    public synchronized ProcessWrapper launchTranscode(StoreItem item, MediaInfo media, OutputParams params) throws IOException {
        List<String> videoFilterOptions;
        boolean deferToTsmuxer;
        FFMpegVideo fFMpegVideo;
        Renderer renderer = params.getMediaRenderer();
        UmsConfiguration configuration = renderer.getUmsConfiguration();
        MediaVideo defaultVideoTrack = media.getDefaultVideoTrack();
        String filename = item.getFileName();
        EncodingFormat encodingFormat = item.getTranscodingSettings().getEncodingFormat();
        InputFile newInput = new InputFile();
        newInput.setFilename(filename);
        newInput.setPush(params.getStdIn());
        ArrayList<String> cmdList = new ArrayList<String>();
        boolean avisynth = this.isAviSynthEngine();
        if (params.getTimeSeek() > 0.0) {
            params.setWaitBeforeStart(1);
        } else if (renderer.isTranscodeFastStart()) {
            params.manageFastStart();
        } else {
            params.setWaitBeforeStart(2500);
        }
        FFMpegVideo.setAudioAndSubs(item, params);
        cmdList.add(this.getExecutable());
        cmdList.add("-y");
        FFMpegVideo.setLogLevel(cmdList, configuration);
        FFMpegVideo.setDecodingOptions(cmdList, configuration, avisynth);
        boolean isTsMuxeRVideoEngineActive = EngineFactory.isEngineActive(TsMuxeRVideo.ID);
        boolean isXboxOneWebVideo = renderer.isXboxOne() && this.purpose() == 2;
        boolean ac3Remux = false;
        boolean dtsRemux = false;
        if (configuration.isAudioRemuxAC3() && params.getAid() != null && (params.getAid().isAC3() || params.getAid().isEAC3()) && !this.isAviSynthEngine() && encodingFormat.isTranscodeToAC3() && !isXboxOneWebVideo && params.getAid().getNumberOfChannels() <= configuration.getAudioChannelCount()) {
            ac3Remux = true;
        } else {
            dtsRemux = isTsMuxeRVideoEngineActive && configuration.isAudioEmbedDtsInPcm() && params.getAid() != null && params.getAid().isDTS() && !this.isAviSynthEngine() && renderer.isDTSPlayable();
        }
        String frameRateRatio = FFMpegVideo.getValidFps(media.getFrameRate(), true);
        String frameRateNumber = FFMpegVideo.getValidFps(media.getFrameRate(), false);
        if (params.getTimeSeek() > 0.0 && !avisynth) {
            cmdList.add("-ss");
            cmdList.add(String.valueOf(params.getTimeSeek()));
        }
        boolean isConvertedTo3d = false;
        cmdList.add("-i");
        if (avisynth && !filename.toLowerCase().endsWith(".iso") && (fFMpegVideo = this) instanceof AviSynthFFmpeg) {
            AviSynthFFmpeg aviSynthFFmpeg = (AviSynthFFmpeg)fFMpegVideo;
            AviSynthFFmpeg.AviSynthScriptGenerationResult aviSynthScriptGenerationResult = aviSynthFFmpeg.getAVSScript(filename, params, frameRateRatio, frameRateNumber, media);
            cmdList.add(ProcessUtil.getShortFileNameIfWideChars(aviSynthScriptGenerationResult.getAvsFile().getAbsolutePath()));
            isConvertedTo3d = aviSynthScriptGenerationResult.isConvertedTo3d();
        } else if (params.getStdIn() != null) {
            cmdList.add("pipe:");
        } else {
            cmdList.add(filename);
        }
        if (!(!EngineFactory.isEngineActive(MEncoderVideo.ID) || renderer instanceof OutputOverride || params.getSid() == null || item.isInsideTranscodeFolder() || !configuration.isFFmpegDeferToMEncoderForProblematicSubtitles() || !params.getSid().isEmbedded() || !params.getSid().getType().isText() && params.getSid().getType() != SubtitleType.VOBSUB || defaultVideoTrack != null && defaultVideoTrack.getHDRFormatForRenderer() != null && defaultVideoTrack.getHDRFormatForRenderer().equals("dolbyvision"))) {
            LOGGER.debug("Switching from FFmpeg to MEncoder to transcode subtitles because the user setting is enabled.");
            MEncoderVideo mv = (MEncoderVideo)EngineFactory.getEngine(StandardEngineId.MENCODER_VIDEO, false, true);
            if (mv != null) {
                return mv.launchTranscode(item, media, params);
            }
        }
        boolean canMuxVideoWithFFmpeg = true;
        boolean canMuxVideoWithFFmpegIfTsMuxerIsNotUsed = false;
        String prependFfmpegTraceReason = "Not muxing the video stream with FFmpeg because ";
        if (!(renderer instanceof OutputOverride)) {
            if (!renderer.isVideoStreamTypeSupportedInTranscodingContainer(media, encodingFormat, null)) {
                canMuxVideoWithFFmpeg = false;
                LOGGER.debug(prependFfmpegTraceReason + "the video codec is not the same as the transcoding goal.");
            } else if (item.isInsideTranscodeFolder()) {
                canMuxVideoWithFFmpeg = false;
                LOGGER.debug(prependFfmpegTraceReason + "the file is being played via a FFmpeg entry in the TRANSCODE folder.");
            } else if (params.getSid() != null) {
                canMuxVideoWithFFmpeg = false;
                LOGGER.debug(prependFfmpegTraceReason + "we need to burn subtitles.");
            } else if (this.isAviSynthEngine()) {
                canMuxVideoWithFFmpeg = false;
                LOGGER.debug(prependFfmpegTraceReason + "we are using AviSynth.");
            } else if (defaultVideoTrack.isH264() && !this.isVideoWithinH264LevelLimits(defaultVideoTrack, renderer)) {
                canMuxVideoWithFFmpeg = false;
                LOGGER.debug(prependFfmpegTraceReason + "the video stream is not within H.264 level limits for this renderer.");
            } else if ("bt.601".equals(defaultVideoTrack.getMatrixCoefficients())) {
                canMuxVideoWithFFmpeg = false;
                LOGGER.debug(prependFfmpegTraceReason + "the colorspace probably isn't supported by the renderer.");
            } else if ((renderer.isKeepAspectRatio() || renderer.isKeepAspectRatioTranscoding()) && !"16:9".equals(defaultVideoTrack.getDisplayAspectRatio())) {
                canMuxVideoWithFFmpeg = false;
                LOGGER.debug(prependFfmpegTraceReason + "the renderer needs us to add borders so it displays the correct aspect ratio of " + defaultVideoTrack.getDisplayAspectRatio() + ".");
            } else if (!renderer.isResolutionCompatibleWithRenderer(media.getWidth(), media.getHeight())) {
                canMuxVideoWithFFmpeg = false;
                LOGGER.debug(prependFfmpegTraceReason + "the resolution is incompatible with the renderer.");
            } else if (!encodingFormat.isTranscodeToMP4H265AC3() && defaultVideoTrack.getHDRFormatForRenderer() != null && defaultVideoTrack.getHDRFormatForRenderer().equals("dolbyvision")) {
                boolean videoWouldBeCompatibleInTsContainer;
                canMuxVideoWithFFmpeg = false;
                boolean bl = videoWouldBeCompatibleInTsContainer = renderer.getFormatConfiguration().getMatchedMIMEtype("mpegts", defaultVideoTrack.getCodec(), null, 0, 0, defaultVideoTrack.getBitRate(), 0, defaultVideoTrack.getWidth(), defaultVideoTrack.getHeight(), defaultVideoTrack.getBitDepth(), defaultVideoTrack.getHDRFormatForRenderer(), defaultVideoTrack.getHDRFormatCompatibilityForRenderer(), defaultVideoTrack.getExtras(), null, false, renderer) != null;
                if (videoWouldBeCompatibleInTsContainer) {
                    canMuxVideoWithFFmpegIfTsMuxerIsNotUsed = true;
                }
                LOGGER.debug(prependFfmpegTraceReason + "the file is Dolby Vision and FFmpeg only outputs Dolby Vision metadata to MP4 containers as of FFmpeg 7.0.1 (worth re-checking periodically).");
            }
        }
        boolean bl = deferToTsmuxer = !canMuxVideoWithFFmpeg;
        if (!(renderer instanceof OutputOverride) && configuration.isFFmpegMuxWithTsMuxerWhenCompatible()) {
            String prependTraceReason = "Not muxing the video stream with tsMuxeR via FFmpeg because ";
            if (item.isInsideTranscodeFolder()) {
                deferToTsmuxer = false;
                LOGGER.debug(prependTraceReason + "the file is being played via a FFmpeg entry in the TRANSCODE folder.");
            } else if (!renderer.isVideoStreamTypeSupportedInTranscodingContainer(media, encodingFormat, "mpegts")) {
                deferToTsmuxer = false;
                LOGGER.debug(prependTraceReason + "the renderer does not support {} inside MPEG-TS.", (Object)defaultVideoTrack.getCodec());
            } else if (!(params.getSid() == null || defaultVideoTrack.getHDRFormatForRenderer() != null && defaultVideoTrack.getHDRFormatForRenderer().equals("dolbyvision"))) {
                deferToTsmuxer = false;
                LOGGER.debug(prependTraceReason + "we need to burn subtitles.");
            } else if (this.isAviSynthEngine()) {
                deferToTsmuxer = false;
                LOGGER.debug(prependTraceReason + "we are using AviSynth.");
            } else if (defaultVideoTrack.isH264() && !this.isVideoWithinH264LevelLimits(defaultVideoTrack, renderer)) {
                deferToTsmuxer = false;
                LOGGER.debug(prependTraceReason + "the video stream is not within H.264 level limits for this renderer.");
            } else if (!FFMpegVideo.isMuxable(defaultVideoTrack, renderer)) {
                deferToTsmuxer = false;
                LOGGER.debug(prependTraceReason + "the video stream is not muxable to this renderer");
            } else if (!defaultVideoTrack.isDisplayAspectRatioFromCodec()) {
                deferToTsmuxer = false;
                LOGGER.debug(prependTraceReason + "we need to transcode to apply the correct aspect ratio.");
            } else if ("bt.601".equals(defaultVideoTrack.getMatrixCoefficients())) {
                deferToTsmuxer = false;
                LOGGER.debug(prependTraceReason + "the colorspace probably isn't supported by the renderer.");
            } else if ((renderer.isKeepAspectRatio() || renderer.isKeepAspectRatioTranscoding()) && !"16:9".equals(defaultVideoTrack.getDisplayAspectRatio())) {
                deferToTsmuxer = false;
                LOGGER.debug(prependTraceReason + "the renderer needs us to add borders so it displays the correct aspect ratio of " + defaultVideoTrack.getDisplayAspectRatio() + ".");
            } else if (!renderer.isResolutionCompatibleWithRenderer(media.getWidth(), media.getHeight())) {
                deferToTsmuxer = false;
                LOGGER.debug(prependTraceReason + "the resolution is incompatible with the renderer.");
            } else if (!EngineFactory.isEngineAvailable(StandardEngineId.TSMUXER_VIDEO)) {
                deferToTsmuxer = false;
                LOGGER.warn(prependTraceReason + "the configured executable isn't available.");
            } else if (params.getTimeSeek() > 0.0) {
                deferToTsmuxer = false;
                LOGGER.debug(prependTraceReason + "the renderer will display a blank screen, no good explanation for this yet.");
            }
            if (deferToTsmuxer) {
                TsMuxeRVideo tsMuxeRVideoInstance = (TsMuxeRVideo)EngineFactory.getEngine(StandardEngineId.TSMUXER_VIDEO, false, true);
                params.setForceFps(FFMpegVideo.getValidFps(media.getFrameRate(), false));
                if (defaultVideoTrack != null && defaultVideoTrack.getCodec() != null) {
                    if (defaultVideoTrack.isH264()) {
                        params.setForceType("V_MPEG4/ISO/AVC");
                    } else if (defaultVideoTrack.isH265()) {
                        params.setForceType("V_MPEGH/ISO/HEVC");
                    } else if (defaultVideoTrack.getCodec().startsWith("mpeg2")) {
                        params.setForceType("V_MPEG-2");
                    } else if (defaultVideoTrack.getCodec().equals("vc1")) {
                        params.setForceType("V_MS/VFW/WVC1");
                    }
                }
                LOGGER.debug("Deferring from FFmpeg to tsMuxeR");
                return tsMuxeRVideoInstance.launchTranscode(item, media, params);
            }
        }
        if (canMuxVideoWithFFmpegIfTsMuxerIsNotUsed) {
            canMuxVideoWithFFmpeg = true;
        }
        if (!(videoFilterOptions = this.getVideoFilterOptions(item, media, params, isConvertedTo3d)).isEmpty()) {
            cmdList.addAll(videoFilterOptions);
            canMuxVideoWithFFmpeg = false;
            LOGGER.debug(prependFfmpegTraceReason + "video filters are being applied.");
        }
        if (media.getAudioTracks().size() > 1) {
            cmdList.add("-map");
            cmdList.add("0:V");
            cmdList.add("-map");
            cmdList.add("0:a:" + media.getAudioTracks().indexOf(params.getAid()));
        }
        FFMpegVideo.setEncodingThreads(cmdList, configuration);
        if (params.getTimeEnd() > 0.0) {
            cmdList.add("-t");
            cmdList.add(String.valueOf(params.getTimeEnd()));
        }
        boolean override = false;
        if (renderer instanceof OutputOverride) {
            OutputOverride outputOverride = (OutputOverride)((Object)renderer);
            override = outputOverride.getOutputOptions(cmdList, item, this, params);
        }
        if (!override) {
            if (!canMuxVideoWithFFmpeg) {
                cmdList.addAll(this.getVideoBitrateOptions(item, media, params, dtsRemux));
            }
            String customFFmpegOptions = renderer.getCustomFFmpegOptions();
            if (!ac3Remux && !dtsRemux && this.type() != 1) {
                int channels = 0;
                if (encodingFormat.isTranscodeToWMV() && !renderer.isXbox360() || renderer.isXboxOne() && this.purpose() == 2) {
                    channels = 2;
                } else if (params.getAid() != null && params.getAid().getNumberOfChannels() > configuration.getAudioChannelCount()) {
                    channels = configuration.getAudioChannelCount();
                }
                if (!customFFmpegOptions.contains("-ac ") && channels > 0) {
                    cmdList.add("-ac");
                    cmdList.add(String.valueOf(channels));
                }
                if (!customFFmpegOptions.matches(".* -(-ab|b:a) .*")) {
                    cmdList.add("-ab");
                    if (encodingFormat.isTranscodeToAAC()) {
                        cmdList.add(Math.min(configuration.getAudioBitrate(), 320) + "k");
                    } else {
                        cmdList.add(String.valueOf(CodecUtil.getAC3Bitrate(configuration, params.getAid())) + "k");
                    }
                }
                if (!customFFmpegOptions.contains("-ar ") && params.getAid() != null && params.getAid().getSampleRate() != renderer.getTranscodedVideoAudioSampleRate()) {
                    cmdList.add("-ar");
                    cmdList.add("" + renderer.getTranscodedVideoAudioSampleRate());
                }
                if (!customFFmpegOptions.contains("--resampler") && params.getAid() != null && params.getAid().getSampleRate() != renderer.getTranscodedVideoAudioSampleRate() && configuration.isFFmpegSoX()) {
                    cmdList.add("-resampler");
                    cmdList.add("soxr");
                    cmdList.add("-precision");
                    cmdList.add("33");
                    cmdList.add("-cheby");
                    cmdList.add("1");
                }
            }
            cmdList.addAll(this.getVideoTranscodeOptions(item, media, params, canMuxVideoWithFFmpeg));
            if (StringUtils.isNotEmpty(customFFmpegOptions)) {
                FFMpegVideo.parseOptions(customFFmpegOptions, cmdList);
            }
        }
        IPipeProcess pipe = null;
        if (!dtsRemux) {
            String fifoName = String.format("ffmpegvideo_%d_%d", Thread.currentThread().getId(), System.currentTimeMillis());
            pipe = PlatformUtils.INSTANCE.getPipeProcess(fifoName, new String[0]);
            pipe.deleteLater();
            params.getInputPipes()[0] = pipe;
            cmdList.add(pipe.getInputPipe());
        }
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        this.setOutputParsing(configuration, item, pw, false);
        if (!dtsRemux && pipe != null) {
            ProcessWrapper mkfifoProcess = pipe.getPipeProcess();
            mkfifoProcess.runInSameThread();
            pw.attachProcess(mkfifoProcess);
            try {
                Thread.sleep(300L);
            }
            catch (InterruptedException e) {
                LOGGER.error("Thread interrupted while waiting for named pipe to be created", e);
                Thread.currentThread().interrupt();
            }
        } else {
            pipe = PlatformUtils.INSTANCE.getPipeProcess(System.currentTimeMillis() + "tsmuxerout.ts", new String[0]);
            TsMuxeRVideo ts = (TsMuxeRVideo)EngineFactory.getEngine(StandardEngineId.TSMUXER_VIDEO, false, true);
            File f = new File(CONFIGURATION.getTempFolder(), "ums-tsmuxer.meta");
            String[] cmd = new String[]{ts.getExecutable(), f.getAbsolutePath(), pipe.getInputPipe()};
            pw = new ProcessWrapperImpl(cmd, params);
            PipeIPCProcess ffVideoPipe = new PipeIPCProcess(System.currentTimeMillis() + "ffmpegvideo", System.currentTimeMillis() + "videoout", false, true);
            cmdList.add(ffVideoPipe.getInputPipe());
            OutputParams ffparams = new OutputParams(configuration);
            ffparams.setMaxBufferSize(1.0);
            ffparams.setStdIn(params.getStdIn());
            String[] cmdArrayDts = new String[cmdList.size()];
            cmdList.toArray(cmdArrayDts);
            ProcessWrapperImpl ffVideo = new ProcessWrapperImpl(cmdArrayDts, ffparams);
            ProcessWrapper ffVideoPipeProcess = ffVideoPipe.getPipeProcess();
            pw.attachProcess(ffVideoPipeProcess);
            ffVideoPipeProcess.runInNewThread();
            ffVideoPipe.deleteLater();
            pw.attachProcess(ffVideo);
            ffVideo.runInNewThread();
            PipeIPCProcess ffAudioPipe = new PipeIPCProcess(System.currentTimeMillis() + "ffmpegaudio01", System.currentTimeMillis() + "audioout", false, true);
            StreamModifier sm = new StreamModifier();
            sm.setPcm(false);
            sm.setDtsEmbed(dtsRemux);
            sm.setSampleFrequency(48000);
            sm.setBitsPerSample(16);
            sm.setNbChannels(2);
            ArrayList<String> cmdListDTS = new ArrayList<String>();
            cmdListDTS.add(this.getExecutable());
            cmdListDTS.add("-y");
            cmdListDTS.add("-ss");
            if (params.getTimeSeek() > 0.0) {
                cmdListDTS.add(String.valueOf(params.getTimeSeek()));
            } else {
                cmdListDTS.add("0");
            }
            if (params.getStdIn() == null) {
                cmdListDTS.add("-i");
            } else {
                cmdListDTS.add("-");
            }
            cmdListDTS.add(filename);
            if (params.getTimeSeek() > 0.0) {
                cmdListDTS.add("-copypriorss");
                cmdListDTS.add("0");
                cmdListDTS.add("-avoid_negative_ts");
                cmdListDTS.add("1");
            }
            cmdListDTS.add("-ac");
            cmdListDTS.add("2");
            cmdListDTS.add("-f");
            cmdListDTS.add("dts");
            cmdListDTS.add("-c:a");
            cmdListDTS.add("copy");
            cmdListDTS.add(ffAudioPipe.getInputPipe());
            String[] cmdArrayDTS = new String[cmdListDTS.size()];
            cmdListDTS.toArray(cmdArrayDTS);
            if (!renderer.isMuxDTSToMpeg()) {
                ffAudioPipe.setModifier(sm);
            }
            OutputParams ffaudioparams = new OutputParams(configuration);
            ffaudioparams.setMaxBufferSize(1.0);
            ffaudioparams.setStdIn(params.getStdIn());
            ProcessWrapperImpl ffAudio = new ProcessWrapperImpl(cmdArrayDTS, ffaudioparams);
            params.setStdIn(null);
            try (PrintWriter pwMux = new PrintWriter(f);){
                Object videoparams;
                pwMux.println("MUXOPT --no-pcr-on-video-pid --no-asyncio --new-audio-pes --vbr --vbv-len=500");
                String videoType = "V_MPEG-2";
                if (encodingFormat.isTranscodeToH264()) {
                    videoType = "V_MPEG4/ISO/AVC";
                } else if (encodingFormat.isTranscodeToH265()) {
                    videoType = "V_MPEGH/ISO/HEVC";
                }
                if (params.isNoVideoEncode() && params.getForceType() != null) {
                    videoType = params.getForceType();
                }
                StringBuilder fps = new StringBuilder();
                fps.append("");
                if (params.getForceFps() != null) {
                    fps.append("fps=").append(params.getForceFps()).append(", ");
                }
                String audioType = "A_AC3";
                if (dtsRemux) {
                    audioType = renderer.isMuxDTSToMpeg() ? "A_DTS" : "A_LPCM";
                }
                if (encodingFormat.isTranscodeToH264()) {
                    String sei = "insertSEI";
                    if (renderer.isPS3() && this.isWebDl(filename, media, params)) {
                        sei = "forceSEI";
                    }
                    videoparams = "level=4.1, " + sei + ", contSPS, track=1";
                } else {
                    videoparams = "track=1";
                }
                pwMux.println(videoType + ", \"" + ffVideoPipe.getOutputPipe() + "\", " + fps + (String)videoparams);
                pwMux.println(audioType + ", \"" + ffAudioPipe.getOutputPipe() + "\", track=2");
            }
            ProcessWrapper pipeProcess = pipe.getPipeProcess();
            pw.attachProcess(pipeProcess);
            pipeProcess.runInNewThread();
            try {
                this.wait(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            pipe.deleteLater();
            params.getInputPipes()[0] = pipe;
            ProcessWrapper ffPipeProcess = ffAudioPipe.getPipeProcess();
            pw.attachProcess(ffPipeProcess);
            ffPipeProcess.runInNewThread();
            try {
                this.wait(50L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            ffAudioPipe.deleteLater();
            pw.attachProcess(ffAudio);
            ffAudio.runInNewThread();
        }
        pw.runInNewThread();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread interrupted while waiting for transcode to start", (Object)e.getMessage());
            LOGGER.trace("", e);
            Thread.currentThread().interrupt();
        }
        return pw;
    }

    public static void setLogLevel(List<String> cmdList, UmsConfiguration configuration) {
        cmdList.add("-loglevel");
        FFmpegLogLevels askedLogLevel = FFmpegLogLevels.valueOfLabel(configuration.getFFmpegLoggingLevel());
        if (LOGGER.isTraceEnabled()) {
            if (FFmpegLogLevels.INFO.isMoreVerboseThan(askedLogLevel)) {
                cmdList.add("info");
            } else {
                cmdList.add(askedLogLevel.label);
            }
        } else {
            if (FFmpegLogLevels.FATAL.isMoreVerboseThan(askedLogLevel)) {
                cmdList.add("fatal");
            } else {
                cmdList.add(askedLogLevel.label);
            }
            cmdList.add("-hide_banner");
        }
    }

    public static void setDecodingOptions(List<String> cmdList, UmsConfiguration configuration, boolean avisynth) {
        int nThreads = 1;
        if (configuration.isFfmpegMultithreading()) {
            nThreads = Runtime.getRuntime().availableProcessors() == configuration.getNumberOfCpuCores() ? 0 : configuration.getNumberOfCpuCores();
        }
        if (nThreads > 0 && !configuration.isGPUAcceleration()) {
            cmdList.add("-threads");
            cmdList.add(String.valueOf(nThreads));
        } else if (configuration.isGPUAcceleration() && !avisynth && !configuration.getFFmpegGPUDecodingAccelerationMethod().equals("none")) {
            if (configuration.getFFmpegGPUDecodingAccelerationMethod().trim().matches("(auto|cuda|cuvid|d3d11va|dxva2|vaapi|vdpau|videotoolbox|qsv)")) {
                cmdList.add("-hwaccel");
                cmdList.add(configuration.getFFmpegGPUDecodingAccelerationMethod().trim());
            } else if (configuration.getFFmpegGPUDecodingAccelerationMethod().matches(".*-hwaccel +[a-z]+.*")) {
                String[] hwaccelOptions = StringUtils.split(configuration.getFFmpegGPUDecodingAccelerationMethod());
                cmdList.addAll(Arrays.asList(hwaccelOptions));
            } else {
                cmdList.add("-hwaccel");
                cmdList.add("auto");
            }
            if (configuration.getFFmpegGPUDecodingAccelerationThreadNumber().trim().matches("^[0-9]+$")) {
                if (Integer.parseInt(configuration.getFFmpegGPUDecodingAccelerationThreadNumber().trim()) > 0) {
                    cmdList.add("-threads");
                    cmdList.add(String.valueOf(configuration.getFFmpegGPUDecodingAccelerationThreadNumber().trim()));
                }
            } else {
                cmdList.add("-threads");
                cmdList.add("1");
            }
        }
    }

    public static void setEncodingThreads(List<String> cmdList, UmsConfiguration configuration) {
        int nThreads = 1;
        if (configuration.isFfmpegMultithreading()) {
            nThreads = Runtime.getRuntime().availableProcessors() == configuration.getNumberOfCpuCores() ? 0 : configuration.getNumberOfCpuCores();
        }
        if (nThreads > 0) {
            cmdList.add("-threads");
            cmdList.add("" + nThreads);
        }
    }

    public static ProcessWrapperImpl runHlsTranscodeProcess(OutputParams params, List<String> cmdList) {
        String fifoName = String.format("ffmpeghlsvideo_%d_%d", Thread.currentThread().getId(), System.currentTimeMillis());
        IPipeProcess pipe = PlatformUtils.INSTANCE.getPipeProcess(fifoName, new String[0]);
        pipe.deleteLater();
        ProcessWrapper mkfifoProcess = pipe.getPipeProcess();
        mkfifoProcess.runInSameThread();
        params.getInputPipes()[0] = pipe;
        cmdList.add(pipe.getInputPipe());
        String[] cmdArray = new String[cmdList.size()];
        cmdList.toArray(cmdArray);
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, params);
        pw.attachProcess(mkfifoProcess);
        try {
            Thread.sleep(300L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread interrupted while waiting for named pipe to be created", e);
            Thread.currentThread().interrupt();
        }
        pw.runInNewThread();
        try {
            Thread.sleep(200L);
        }
        catch (InterruptedException e) {
            LOGGER.error("Thread interrupted while waiting for transcode to start", e);
            Thread.currentThread().interrupt();
        }
        return pw;
    }

    public static List<String> parseOptions(String str) {
        return str == null ? null : FFMpegVideo.parseOptions(str, new ArrayList<String>());
    }

    protected static List<String> parseOptions(String str, List<String> cmdList) {
        int pos = 0;
        int len = str.length();
        while (pos < len) {
            int start;
            if (str.charAt(pos) == '\"') {
                start = pos + 1;
                pos = str.indexOf(34, start);
            } else {
                start = pos;
                pos = str.indexOf(32, start);
            }
            if (pos == -1) {
                pos = len;
            }
            if (pos - start > 0) {
                cmdList.add(str.substring(start, pos).trim());
            }
            ++pos;
            while (pos < len && str.charAt(pos) == ' ') {
                ++pos;
            }
        }
        return cmdList;
    }

    public boolean isDisableSubtitles(OutputParams params) {
        UmsConfiguration configuration = params.getMediaRenderer().getUmsConfiguration();
        return configuration.isDisableSubtitles() || params.getSid() == null || this.isAviSynthEngine();
    }

    @Override
    public boolean isCompatible(StoreItem item) {
        MediaAudio audio = item.getMediaInfo().getDefaultAudioTrack();
        if (audio != null && audio.isAC4()) {
            LOGGER.trace("Ignoring file \"{}\" because audio is AC-4 and engine is FFmpeg so skip it until FFmpeg will support it.", (Object)item.getName());
            return false;
        }
        return PlayerUtil.isVideo(item, Format.Identifier.MKV) || PlayerUtil.isVideo(item, Format.Identifier.MPG) || PlayerUtil.isVideo(item, Format.Identifier.OGG) || "m3u8".equals(item.getFormat().getMatchedExtension());
    }

    @Override
    public boolean isCompatible(EncodingFormat encodingFormat) {
        return encodingFormat.isVideoFormat() && !encodingFormat.isTranscodeToHLS();
    }

    public void setOutputParsing(UmsConfiguration configuration, final StoreItem resource, ProcessWrapperImpl pw, boolean force) {
        if (configuration.isResumeEnabled() && resource.getMediaInfo() != null) {
            long duration;
            long l = duration = force ? 0L : (long)resource.getMediaInfo().getDurationInSeconds();
            if (duration == 0L || duration == 0x7FFFFFFF7FFFFFFFL) {
                OutputTextLogger ffParser = new OutputTextLogger(null){

                    @Override
                    public boolean filter(String line) {
                        if (RE_DURATION.reset(line).find()) {
                            String d = RE_DURATION.group(1);
                            LOGGER.trace("[{}] setting duration: {}", (Object)ID, (Object)d);
                            resource.getMediaInfo().setDuration(StringUtil.convertStringToTime(d));
                            return false;
                        }
                        return true;
                    }
                };
                ffParser.setFiltered(true);
                pw.setStderrConsumer(ffParser);
            }
        }
    }

    @Override
    public boolean excludeFormat(Format extension) {
        return false;
    }

    @Override
    public ExecutableInfo testExecutable(@Nonnull ExecutableInfo executableInfo) {
        if (Boolean.FALSE.equals((executableInfo = this.testExecutableFile(executableInfo)).getAvailable())) {
            return executableInfo;
        }
        String arg = "-version";
        ExecutableInfo.ExecutableInfoBuilder result = executableInfo.modify();
        try {
            ListProcessWrapperResult output = SimpleProcessWrapper.runProcessListOutput(30000L, 1000L, executableInfo.getPath().toString(), "-version");
            if (output.getError() != null) {
                result.errorType(ExecutableErrorType.GENERAL);
                result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + " \n" + output.getError().getMessage());
                result.available(Boolean.FALSE);
                LOGGER.debug("\"{} {}\" failed with error: {}", executableInfo.getPath(), "-version", output.getError().getMessage());
                return result.build();
            }
            if (output.getExitCode() == 0) {
                Pattern pattern;
                Matcher matcher;
                if (!output.getOutput().isEmpty() && (matcher = (pattern = Pattern.compile("^ffmpeg version\\s+(.*?)\\s+Copyright", 2)).matcher((CharSequence)output.getOutput().get(0))).find() && StringUtils.isNotBlank(matcher.group(1))) {
                    result.version(new Version(matcher.group(1)));
                }
                result.available(Boolean.TRUE);
                if (result instanceof FFmpegExecutableInfo.FFmpegExecutableInfoBuilder) {
                    FFmpegExecutableInfo.FFmpegExecutableInfoBuilder fFmpegExecutableInfoBuilder = (FFmpegExecutableInfo.FFmpegExecutableInfoBuilder)result;
                    List<String> protocols = FFmpegOptions.getSupportedProtocols(executableInfo.getPath());
                    fFmpegExecutableInfoBuilder.protocols(protocols);
                    if (protocols.isEmpty()) {
                        LOGGER.warn("Couldn't parse any supported protocols for \"{}\"", (Object)executableInfo.getPath());
                    } else {
                        LOGGER.debug("{} supported protocols: {}", (Object)executableInfo.getPath(), (Object)protocols);
                    }
                } else {
                    LOGGER.error("Could not store FFmpeg supported protocols because of an internal error");
                }
            } else {
                NTStatus ntStatus;
                NTStatus nTStatus = ntStatus = Platform.isWindows() ? NTStatus.typeOf(output.getExitCode()) : null;
                if (ntStatus != null) {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + "\n\n" + ntStatus);
                } else if (output.getOutput().size() > 2) {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + " \n" + (String)output.getOutput().get(output.getOutput().size() - 2) + " " + (String)output.getOutput().get(output.getOutput().size() - 1));
                } else if (output.getOutput().size() > 1) {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + " \n" + (String)output.getOutput().get(output.getOutput().size() - 1));
                } else {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + Messages.getString("UnknownError"));
                }
                result.available(Boolean.FALSE);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        return result.build();
    }

    @Override
    protected boolean isSpecificTest() {
        return false;
    }

    private boolean ffmpegSupportsRemuxingAudioStreamToTranscodingContainer(MediaAudio fileAudio, String transcodingContainer) {
        if (transcodingContainer.equals("mpegps")) {
            return fileAudio.isMpegAudio() || fileAudio.isMP3() || fileAudio.isAC3() || fileAudio.isDTS() || fileAudio.isPCM();
        }
        return true;
    }
}

