/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.sun.jna.Platform;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.AviSynthFFmpeg;
import net.pms.encoders.AviSynthMEncoder;
import net.pms.encoders.DCRaw;
import net.pms.encoders.Engine;
import net.pms.encoders.EngineId;
import net.pms.encoders.FFMpegVideo;
import net.pms.encoders.FFmpegAudio;
import net.pms.encoders.FFmpegHlsVideo;
import net.pms.encoders.FFmpegWebVideo;
import net.pms.encoders.MEncoderVideo;
import net.pms.encoders.MEncoderWebVideo;
import net.pms.encoders.TsMuxeRAudio;
import net.pms.encoders.TsMuxeRVideo;
import net.pms.encoders.VLCVideo;
import net.pms.encoders.VLCWebVideo;
import net.pms.encoders.VideoLanAudioStreaming;
import net.pms.encoders.VideoLanVideoStreaming;
import net.pms.encoders.YoutubeDl;
import net.pms.formats.FormatFactory;
import net.pms.util.ExecutableErrorType;
import net.pms.util.ExternalProgramInfo;
import net.pms.util.ProgramExecutableType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class EngineFactory {
    private static final Logger LOGGER = LoggerFactory.getLogger(FormatFactory.class);
    private static final ReentrantReadWriteLock ENGINES_LOCK = new ReentrantReadWriteLock();
    private static final ArrayList<Engine> ENGINES = new ArrayList();
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static boolean initialized = false;

    private EngineFactory() {
    }

    public static void initialize() throws InterruptedException {
        EngineFactory.registerEngines();
        initialized = true;
    }

    public static boolean isInitialized() {
        return initialized;
    }

    private static void registerEngines() throws InterruptedException {
        if (Platform.isWindows()) {
            EngineFactory.registerEngine(new AviSynthFFmpeg());
            EngineFactory.registerEngine(new AviSynthMEncoder());
        }
        EngineFactory.registerEngine(new FFmpegAudio());
        EngineFactory.registerEngine(new MEncoderVideo());
        EngineFactory.registerEngine(new FFMpegVideo());
        EngineFactory.registerEngine(new VLCVideo());
        EngineFactory.registerEngine(new FFmpegHlsVideo());
        EngineFactory.registerEngine(new FFmpegWebVideo());
        EngineFactory.registerEngine(new MEncoderWebVideo());
        EngineFactory.registerEngine(new VLCWebVideo());
        EngineFactory.registerEngine(new TsMuxeRVideo());
        EngineFactory.registerEngine(new TsMuxeRAudio());
        EngineFactory.registerEngine(new VideoLanAudioStreaming());
        EngineFactory.registerEngine(new VideoLanVideoStreaming());
        EngineFactory.registerEngine(new DCRaw());
        EngineFactory.registerEngine(new YoutubeDl());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void registerEngine(Engine engine) throws InterruptedException {
        if (engine == null) {
            throw new IllegalArgumentException("engine cannot be null");
        }
        CONFIGURATION.capitalizeEngineId(engine);
        ENGINES_LOCK.writeLock().lock();
        try {
            if (EngineFactory.isEngineRegistered(engine.getEngineId())) {
                LOGGER.debug("Transcoding engine {} already exists, skipping registration...", (Object)engine);
                return;
            }
            LOGGER.debug("Checking transcoding engine {}", (Object)engine);
            ENGINES.add(engine);
            engine.setEnabled(CONFIGURATION.isEngineEnabled(engine), false);
            ExternalProgramInfo programInfo = engine.getProgramInfo();
            ReentrantReadWriteLock programInfoLock = programInfo.getLock();
            programInfoLock.writeLock().lock();
            try {
                if (CONFIGURATION.isCustomProgramPathsSupported()) {
                    LOGGER.trace("Registering custom executable path for transcoding engine {}", (Object)engine);
                    Path customPath = CONFIGURATION.getEngineCustomPath(engine);
                    engine.initCustomExecutablePath(customPath);
                }
                for (ProgramExecutableType executableType : programInfo.getExecutableTypes()) {
                    EngineFactory.testEngineExecutableType(engine, executableType);
                }
                engine.determineCurrentExecutableType();
            }
            finally {
                programInfoLock.writeLock().unlock();
            }
            if (engine.isAvailable()) {
                LOGGER.info("Transcoding engine \"{}\" is available", (Object)engine);
            } else {
                LOGGER.warn("Transcoding engine \"{}\" is not available", (Object)engine);
            }
            EngineFactory.sortEngines();
        }
        finally {
            ENGINES_LOCK.writeLock().unlock();
        }
    }

    protected static void testEngineExecutableType(@Nullable Engine engine, @Nullable ProgramExecutableType executableType) {
        if (engine == null || executableType == null || !engine.getProgramInfo().containsType(executableType, true)) {
            return;
        }
        if (!engine.testEngine(executableType) && engine.getProgramInfo().getExecutableInfo(executableType) != null) {
            engine.setUnavailable(executableType, ExecutableErrorType.GENERAL, String.format(Messages.getString("TranscodingEngineXNotAvailableCouldntValidated"), engine));
        }
    }

    public static void sortEngines() {
        ENGINES_LOCK.writeLock().lock();
        try {
            Collections.sort(ENGINES, new EngineSort());
        }
        finally {
            ENGINES_LOCK.writeLock().unlock();
        }
    }

    public static List<Engine> getAllEngines() {
        ENGINES_LOCK.readLock().lock();
        try {
            ArrayList<Engine> arrayList = new ArrayList<Engine>(ENGINES);
            return arrayList;
        }
        finally {
            ENGINES_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<Engine> getEngines(boolean onlyEnabled, boolean onlyAvailable) {
        ENGINES_LOCK.readLock().lock();
        try {
            ArrayList<Engine> resultEngines = new ArrayList<Engine>();
            for (Engine engine : ENGINES) {
                if (onlyAvailable && !engine.isAvailable() || onlyEnabled && !engine.isEnabled()) continue;
                resultEngines.add(engine);
            }
            ArrayList<Engine> arrayList = resultEngines;
            return arrayList;
        }
        finally {
            ENGINES_LOCK.readLock().unlock();
        }
    }

    public static List<Engine> getEngines() {
        return EngineFactory.getEngines(true, true);
    }

    public static boolean isEngineRegistered(Engine engine) {
        if (engine == null) {
            return false;
        }
        return EngineFactory.isEngineRegistered(engine.getEngineId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEngineRegistered(EngineId id) {
        if (id == null) {
            return false;
        }
        ENGINES_LOCK.readLock().lock();
        try {
            for (Engine engine : ENGINES) {
                if (!id.equals(engine.getEngineId())) continue;
                boolean bl = true;
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ENGINES_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEngineActive(EngineId id) {
        if (id == null) {
            return false;
        }
        ENGINES_LOCK.readLock().lock();
        try {
            for (Engine engine : ENGINES) {
                if (!id.equals(engine.getEngineId())) continue;
                boolean bl = engine.isActive();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ENGINES_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean isEngineAvailable(EngineId id) {
        if (id == null) {
            return false;
        }
        ENGINES_LOCK.readLock().lock();
        try {
            for (Engine engine : ENGINES) {
                if (!id.equals(engine.getEngineId())) continue;
                boolean bl = engine.isAvailable();
                return bl;
            }
            boolean bl = false;
            return bl;
        }
        finally {
            ENGINES_LOCK.readLock().unlock();
        }
    }

    public static Engine getActiveEngine(EngineId id) {
        return EngineFactory.getEngine(id, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    public static Engine getEngine(@Nullable EngineId id, boolean onlyEnabled, boolean onlyAvailable) {
        if (id == null) {
            return null;
        }
        ENGINES_LOCK.readLock().lock();
        try {
            for (Engine engine : ENGINES) {
                if (!id.equals(engine.getEngineId())) continue;
                if (!(onlyAvailable && !engine.isAvailable() || onlyEnabled && !engine.isEnabled())) {
                    Engine engine2 = engine;
                    return engine2;
                }
                Engine engine3 = null;
                return engine3;
            }
            Iterator<Engine> iterator = null;
            return iterator;
        }
        finally {
            ENGINES_LOCK.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getEngineExecutable(EngineId id) {
        if (id == null) {
            return null;
        }
        ENGINES_LOCK.readLock().lock();
        try {
            for (Engine engine : ENGINES) {
                if (!id.equals(engine.getEngineId())) continue;
                String string = engine.getExecutable();
                return string;
            }
        }
        finally {
            ENGINES_LOCK.readLock().unlock();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void reEvaluateExecutable(@Nonnull Engine triggeringEngine, @Nullable ProgramExecutableType changedType, @Nullable ProgramExecutableType.DefaultExecutableType defaultType) {
        if (triggeringEngine == null) {
            throw new IllegalArgumentException("triggeringEngine cannot be null");
        }
        ExternalProgramInfo programInfo = triggeringEngine.getProgramInfo();
        ArrayList<Engine> affectedEngines = new ArrayList<Engine>();
        ENGINES_LOCK.readLock().lock();
        try {
            for (Engine engine : ENGINES) {
                if (engine.getProgramInfo() != programInfo) continue;
                affectedEngines.add(engine);
            }
        }
        finally {
            ENGINES_LOCK.readLock().unlock();
        }
        ReentrantReadWriteLock programInfoLock = programInfo.getLock();
        programInfoLock.writeLock().lock();
        try {
            if (defaultType != null) {
                switch (defaultType) {
                    case CUSTOM: {
                        programInfo.setDefault(ProgramExecutableType.CUSTOM);
                        break;
                    }
                    case ORIGINAL: {
                        programInfo.setOriginalDefault();
                        break;
                    }
                }
            }
            Set<ProgramExecutableType> retestTypes = changedType == null ? EnumSet.allOf(ProgramExecutableType.class) : Collections.singleton(changedType);
            for (Engine engine : affectedEngines) {
                for (ProgramExecutableType executableType : retestTypes) {
                    engine.clearSpecificErrors(executableType);
                    EngineFactory.testEngineExecutableType(engine, executableType);
                }
                engine.determineCurrentExecutableType();
            }
        }
        finally {
            programInfoLock.writeLock().unlock();
        }
    }

    private static class EngineSort
    implements Comparator<Engine>,
    Serializable {
        private EngineSort() {
        }

        @Override
        public int compare(Engine engine1, Engine engine2) {
            Integer index1 = CONFIGURATION.getEnginePriority(engine1);
            Integer index2 = CONFIGURATION.getEnginePriority(engine2);
            if (index1 == -1) {
                index1 = 999;
            }
            if (index2 == -1) {
                index2 = 999;
            }
            return index1.compareTo(index2);
        }
    }
}

