/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.google.gson.JsonArray;
import com.sun.jna.Platform;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.HashMap;
import java.util.Set;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.concurrent.GuardedBy;
import javax.annotation.concurrent.ThreadSafe;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.ConfigurableProgramPaths;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EncodingFormat;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.EngineId;
import net.pms.formats.Format;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.media.MediaInfo;
import net.pms.media.codec.video.H264;
import net.pms.media.video.MediaVideo;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.util.ExecutableErrorType;
import net.pms.util.ExecutableInfo;
import net.pms.util.ExternalProgramInfo;
import net.pms.util.FilePermissions;
import net.pms.util.ProgramExecutableType;
import net.pms.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@ThreadSafe
public abstract class Engine {
    private static final Logger LOGGER = LoggerFactory.getLogger(Engine.class);
    protected static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    public static final int VIDEO_SIMPLEFILE_ENGINE = 0;
    public static final int AUDIO_SIMPLEFILE_ENGINE = 1;
    public static final int VIDEO_WEBSTREAM_ENGINE = 2;
    public static final int AUDIO_WEBSTREAM_ENGINE = 3;
    public static final int MISC_ENGINE = 4;
    public static final String AVS_SEPARATOR = "\u0001";
    @Nonnull
    protected final ExternalProgramInfo programInfo;
    protected final ReentrantReadWriteLock specificErrorsLock = new ReentrantReadWriteLock();
    protected volatile ProgramExecutableType currentExecutableType;
    @GuardedBy(value="specificErrorsLock")
    protected final HashMap<ProgramExecutableType, String> specificErrors = new HashMap();
    protected final ReentrantReadWriteLock enabledLock = new ReentrantReadWriteLock();
    @GuardedBy(value="enabledLock")
    protected boolean enabled = false;

    protected Engine(ExternalProgramInfo programInfo) {
        this.programInfo = programInfo;
        if (programInfo == null) {
            throw new IllegalStateException("Can't instantiate " + this.getClass().getSimpleName() + "because executables() returns null");
        }
    }

    public abstract int purpose();

    public abstract EngineId getEngineId();

    public abstract String getConfigurablePathKey();

    public abstract String getName();

    public abstract int type();

    public abstract String getMimeType();

    public abstract String getExecutableTypeKey();

    public abstract boolean excludeFormat(Format var1);

    public abstract ProcessWrapper launchTranscode(StoreItem var1, MediaInfo var2, OutputParams var3) throws IOException;

    public abstract boolean isCompatible(StoreItem var1);

    public abstract boolean isCompatible(EncodingFormat var1);

    protected abstract boolean isSpecificTest();

    @Nullable
    protected abstract ExecutableInfo testExecutable(@Nonnull ExecutableInfo var1);

    @Nullable
    public ProgramExecutableType getCurrentExecutableType() {
        return this.currentExecutableType;
    }

    public void setCurrentExecutableType(ProgramExecutableType executableType) {
        this.currentExecutableType = executableType;
    }

    public void determineCurrentExecutableType() {
        this.determineCurrentExecutableType(CONFIGURATION.getEngineExecutableType(this));
    }

    public void determineCurrentExecutableType(@Nullable ProgramExecutableType newExecutableType) {
        if (!this.isAvailable(newExecutableType)) {
            ProgramExecutableType tmpExecutableType = this.programInfo.getDefault();
            if (this.isAvailable(tmpExecutableType)) {
                newExecutableType = tmpExecutableType;
            } else {
                for (ProgramExecutableType executableType : this.programInfo.getExecutableTypes()) {
                    if (!this.isAvailable(executableType)) continue;
                    newExecutableType = executableType;
                    break;
                }
            }
        }
        if (newExecutableType == null) {
            if (this.currentExecutableType != null) {
                return;
            }
            for (ProgramExecutableType executableType : this.programInfo.getExecutableTypes()) {
                if (executableType == null) continue;
                newExecutableType = executableType;
                break;
            }
        }
        this.currentExecutableType = newExecutableType;
    }

    @Nonnull
    public ExternalProgramInfo getProgramInfo() {
        return this.programInfo;
    }

    @Nullable
    public String getExecutable() {
        Path executable = this.getProgramInfo().getPath(this.currentExecutableType);
        return executable == null ? null : executable.toString();
    }

    public boolean isAviSynthEngine() {
        return false;
    }

    public boolean isInternalSubtitlesSupported() {
        return true;
    }

    public boolean isExternalSubtitlesSupported() {
        return true;
    }

    public boolean isTimeSeekable() {
        return false;
    }

    public boolean isAvailable() {
        return this.isAvailable(this.currentExecutableType);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isAvailable(@Nullable ProgramExecutableType executableType) {
        if (executableType == null) {
            return false;
        }
        ExecutableInfo executableInfo = this.programInfo.getExecutableInfo(executableType);
        if (executableInfo == null) {
            return false;
        }
        Boolean result = executableInfo.getAvailable();
        if (result == null || !result.booleanValue()) {
            return false;
        }
        this.specificErrorsLock.readLock().lock();
        try {
            String specificError = this.specificErrors.get((Object)executableType);
            boolean bl = specificError == null;
            return bl;
        }
        finally {
            this.specificErrorsLock.readLock().unlock();
        }
    }

    public String getStatusText(ProgramExecutableType executableType) {
        return this.getStatusText(executableType, false);
    }

    public String getStatusTextFull(ProgramExecutableType executableType) {
        return this.getStatusText(executableType, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getStatusText(ProgramExecutableType executableType, boolean fullText) {
        if (executableType == null) {
            return null;
        }
        ExecutableInfo executableInfo = this.programInfo.getExecutableInfo(executableType);
        if (executableInfo == null) {
            return String.format(Messages.getString("TheXExecutableNotDefined"), this.getName());
        }
        if (executableInfo.getAvailable() == null || executableInfo.getAvailable().booleanValue()) {
            this.specificErrorsLock.readLock().lock();
            try {
                String specificError = this.specificErrors.get((Object)executableType);
                if (specificError != null) {
                    String string = fullText ? specificError : String.format(Messages.getString("ThereIsProblemTranscodingEngineX"), this.getName());
                    return string;
                }
            }
            finally {
                this.specificErrorsLock.readLock().unlock();
            }
            if (executableInfo.getAvailable() == null) {
                return String.format(Messages.getString("StatusTranscodingEngineXUnknown"), this.getName());
            }
        }
        if (executableInfo.getAvailable().booleanValue()) {
            if (this.isEnabled()) {
                if (executableInfo.getVersion() != null) {
                    return String.format(Messages.getString("TranscodingEngineXYEnabled"), this.getName(), executableInfo.getVersion());
                }
                return String.format(Messages.getString("TranscodingEngineXEnabled"), this.getName());
            }
            return String.format(Messages.getString("TranscodingEngineXDisabled"), this.getName());
        }
        if (executableInfo.getErrorText() == null) {
            return Messages.getString("UnknownError");
        }
        return fullText ? executableInfo.getErrorText() : String.format(Messages.getString("ThereIsProblemTranscodingEngineX"), this.getName());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public JsonArray getStatusTextAsJsonArray(ProgramExecutableType executableType, boolean fullText) {
        if (executableType == null) {
            return null;
        }
        JsonArray array = new JsonArray();
        ExecutableInfo executableInfo = this.programInfo.getExecutableInfo(executableType);
        if (executableInfo == null) {
            array.add("i18n@TheXExecutableNotDefined");
            array.add(this.getName());
            return array;
        }
        if (executableInfo.getAvailable() == null || executableInfo.getAvailable().booleanValue()) {
            this.specificErrorsLock.readLock().lock();
            try {
                String specificError = this.specificErrors.get((Object)executableType);
                if (specificError != null) {
                    if (fullText) {
                        array.add(specificError);
                    } else {
                        array.add("i18n@ThereIsProblemTranscodingEngineX");
                        array.add(this.getName());
                    }
                    JsonArray jsonArray = array;
                    return jsonArray;
                }
            }
            finally {
                this.specificErrorsLock.readLock().unlock();
            }
            if (executableInfo.getAvailable() == null) {
                array.add("i18n@StatusTranscodingEngineXUnknown");
                array.add(this.getName());
                return array;
            }
        }
        if (executableInfo.getAvailable().booleanValue()) {
            if (this.isEnabled()) {
                Version version = executableInfo.getVersion();
                if (version != null) {
                    array.add("i18n@TranscodingEngineXYEnabled");
                    array.add(this.getName());
                    array.add(version.toString());
                    return array;
                }
                array.add("i18n@TranscodingEngineXEnabled");
                array.add(this.getName());
                return array;
            }
            array.add("i18n@TranscodingEngineXDisabled");
            array.add(this.getName());
            return array;
        }
        if (executableInfo.getErrorText() == null) {
            array.add("i18n@UnknownError");
            return array;
        }
        if (fullText) {
            array.add(executableInfo.getErrorText());
            return array;
        }
        array.add("i18n@ThereIsProblemTranscodingEngineX");
        array.add(this.getName());
        return array;
    }

    public String getStatusText() {
        return this.getStatusText(this.currentExecutableType, false);
    }

    public String getStatusTextFull() {
        return this.getStatusText(this.currentExecutableType, true);
    }

    public JsonArray getStatusTextFullAsJsonArray() {
        return this.getStatusTextAsJsonArray(this.currentExecutableType, true);
    }

    public void setAvailable(@Nonnull ProgramExecutableType executableType, @Nullable Version version) {
        this.setAvailable(true, executableType, version, null, null);
    }

    public void setUnavailable(@Nonnull ProgramExecutableType executableType, @Nonnull ExecutableErrorType errorType, @Nullable String errorText) {
        this.setAvailable(false, executableType, null, errorType, errorText);
    }

    public void setUnavailable(@Nonnull ProgramExecutableType executableType, @Nullable Version version, @Nonnull ExecutableErrorType errorType, @Nonnull String errorText) {
        this.setAvailable(false, executableType, version, errorType, errorText);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setAvailable(boolean available, @Nonnull ProgramExecutableType executableType, @Nullable Version version, @Nullable ExecutableErrorType errorType, @Nullable String errorText) {
        if (executableType == null) {
            throw new IllegalArgumentException("executableType cannot be null or unknown");
        }
        if (!(available || errorType != null && errorText != null)) {
            throw new IllegalArgumentException("errorType and errorText can only be null if available is true");
        }
        if (errorType == ExecutableErrorType.SPECIFIC) {
            this.specificErrorsLock.writeLock().lock();
            try {
                this.specificErrors.put(executableType, errorText);
            }
            finally {
                this.specificErrorsLock.writeLock().unlock();
            }
        } else {
            ExecutableInfo executableInfo = this.programInfo.getExecutableInfo(executableType);
            if (executableInfo == null) {
                throw new IllegalStateException("Cannot set availability for " + executableType + " " + this.getName() + " because it is undefined");
            }
            ExecutableInfo.ExecutableInfoBuilder builder = executableInfo.modify();
            builder.available(available);
            if (version != null) {
                builder.version(version);
            }
            if (errorType != null || errorText != null) {
                builder.errorType(errorType).errorText(errorText);
            }
            this.programInfo.setExecutableInfo(executableType, builder.build());
        }
    }

    public void initCustomExecutablePath(@Nullable Path customPath) {
        customPath = ConfigurableProgramPaths.resolveCustomProgramPath(customPath);
        this.programInfo.setPath(ProgramExecutableType.CUSTOM, customPath);
        if (customPath == null) {
            this.programInfo.setOriginalDefault();
        } else {
            this.programInfo.setDefault(ProgramExecutableType.CUSTOM);
            LOGGER.debug("Custom executable path for {} was initialized to \"{}\"", (Object)this.programInfo, (Object)customPath);
        }
    }

    public boolean setCustomExecutablePath(@Nullable Path customPath, boolean setConfiguration) {
        boolean changed;
        boolean configurationChanged = false;
        if (setConfiguration) {
            try {
                configurationChanged = CONFIGURATION.setEngineCustomPath(this, customPath);
            }
            catch (IllegalStateException e) {
                configurationChanged = false;
                LOGGER.warn("Failed to set custom executable path for {}: {}", (Object)this.getName(), (Object)e.getMessage());
                LOGGER.trace("", e);
            }
        }
        if (changed = this.programInfo.setPath(ProgramExecutableType.CUSTOM, customPath = ConfigurableProgramPaths.resolveCustomProgramPath(customPath))) {
            ProgramExecutableType.DefaultExecutableType defaultType;
            if (customPath == null) {
                defaultType = ProgramExecutableType.DefaultExecutableType.ORIGINAL;
                if (setConfiguration && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Custom executable path for {} was cleared", (Object)this.programInfo);
                }
            } else {
                defaultType = ProgramExecutableType.DefaultExecutableType.CUSTOM;
                if (setConfiguration && LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Custom executable path for {} was set to \"{}\"", (Object)this.programInfo, (Object)customPath);
                }
            }
            EngineFactory.reEvaluateExecutable(this, ProgramExecutableType.CUSTOM, defaultType);
        }
        return changed || configurationChanged;
    }

    public void clearSpecificErrors(@Nullable ProgramExecutableType executableType) {
        if (executableType == null && !this.isSpecificTest()) {
            return;
        }
        this.specificErrorsLock.writeLock().lock();
        try {
            this.specificErrors.remove((Object)executableType);
        }
        finally {
            this.specificErrorsLock.writeLock().unlock();
        }
    }

    public boolean isEnabled() {
        this.enabledLock.readLock().lock();
        try {
            boolean bl = this.enabled;
            return bl;
        }
        finally {
            this.enabledLock.readLock().unlock();
        }
    }

    public void setEnabled(boolean enabled, boolean setConfiguration) {
        this.enabledLock.writeLock().lock();
        try {
            this.enabled = enabled;
            if (setConfiguration) {
                CONFIGURATION.setEngineEnabled(this.getEngineId(), enabled);
            }
        }
        finally {
            this.enabledLock.writeLock().unlock();
        }
    }

    public void toggleEnabled(boolean setConfiguration) {
        this.enabledLock.writeLock().lock();
        try {
            boolean bl = this.enabled = !this.enabled;
            if (setConfiguration) {
                CONFIGURATION.setEngineEnabled(this.getEngineId(), this.enabled);
            }
        }
        finally {
            this.enabledLock.writeLock().unlock();
        }
    }

    public boolean isActive(ProgramExecutableType executableType) {
        return this.isAvailable(executableType) && this.isEnabled();
    }

    public boolean isActive() {
        return this.isAvailable(this.currentExecutableType) && this.isEnabled();
    }

    public boolean isGPUAccelerationReady() {
        return false;
    }

    public String toString() {
        return this.getName();
    }

    public static int convertToModX(int number, int mod) {
        if (number % mod != 0) {
            number -= number % mod;
        }
        return number;
    }

    @Nonnull
    protected ExecutableInfo testExecutableFile(@Nonnull ExecutableInfo executableInfo) {
        try {
            FilePermissions permissions = new FilePermissions(executableInfo.getPath(), new LinkOption[0]);
            Set<FilePermissions.FileFlag> flags = permissions.getFlags(FilePermissions.FileFlag.FILE, FilePermissions.FileFlag.EXECUTE, FilePermissions.FileFlag.READ);
            if (!(flags.contains((Object)FilePermissions.FileFlag.FILE) && flags.contains((Object)FilePermissions.FileFlag.READ) && flags.contains((Object)FilePermissions.FileFlag.EXECUTE))) {
                LOGGER.warn("Insufficient permission to execute \"{}\" for transcoding engine {}", (Object)executableInfo.getPath(), (Object)this);
                executableInfo = executableInfo.modify().available(Boolean.FALSE).errorType(ExecutableErrorType.GENERAL).errorText(String.format(Messages.getString("InsufficientPermissionExecuteTranscodingEngine"), executableInfo.getPath(), this)).build();
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.warn("Executable \"{}\" of transcoding engine {} not found: {}", executableInfo.getPath(), this, e.getMessage());
            executableInfo = executableInfo.modify().available(Boolean.FALSE).errorType(ExecutableErrorType.GENERAL).errorText(String.format(Messages.getString("ExecutableXTranscodingEngineNotFound"), executableInfo.getPath(), this)).build();
        }
        return executableInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean testEngine(@Nonnull ProgramExecutableType executableType) {
        if (executableType == null) {
            throw new IllegalArgumentException("executableType cannot be null");
        }
        ReentrantReadWriteLock programInfoLock = this.programInfo.getLock();
        programInfoLock.writeLock().lock();
        try {
            ExecutableInfo result;
            ExecutableInfo executableInfo;
            block23: {
                block22: {
                    executableInfo = this.programInfo.getExecutableInfo(executableType);
                    if (executableInfo == null) {
                        boolean bl = false;
                        return bl;
                    }
                    if (this.isAviSynthEngine()) {
                        if (!Platform.isWindows()) {
                            LOGGER.debug("Skipping transcoding engine {} ({}) as it's not compatible with this platform", (Object)this, (Object)executableType);
                            this.setUnavailable(executableType, ExecutableErrorType.SPECIFIC, String.format(Messages.getString("TranscodingEngineNotAvailableOperatingSystem"), this));
                            boolean bl = true;
                            return bl;
                        }
                        String aviSynthPath = CONFIGURATION.getAviSynthPath();
                        if (aviSynthPath == null || !new File(aviSynthPath).exists()) {
                            LOGGER.debug("Transcoding engine {} ({}) is unavailable since AviSynth couldn't be found", (Object)this, (Object)executableType);
                            this.setUnavailable(executableType, ExecutableErrorType.SPECIFIC, String.format(Messages.getString("TranscodingEngineXNotAvailableAvisynth"), this));
                            boolean bl = true;
                            return bl;
                        }
                    }
                    if (!(executableInfo.getAvailable() == null || executableInfo.getAvailable().booleanValue() && this.isSpecificTest())) {
                        boolean aviSynthPath = true;
                        return aviSynthPath;
                    }
                    this.specificErrorsLock.writeLock().lock();
                    try {
                        if (this.specificErrors.get((Object)executableType) == null) break block22;
                        boolean aviSynthPath = true;
                        this.specificErrorsLock.writeLock().unlock();
                        return aviSynthPath;
                    }
                    catch (Throwable throwable) {
                        this.specificErrorsLock.writeLock().unlock();
                        throw throwable;
                    }
                }
                result = this.testExecutable(executableInfo);
                if (result != null) break block23;
                boolean bl = false;
                this.specificErrorsLock.writeLock().unlock();
                return bl;
            }
            if (result.getAvailable() == null) {
                throw new AssertionError((Object)("Engine test for " + this.getName() + " failed to return availability"));
            }
            if (!result.equals(executableInfo)) {
                this.setAvailable(result.getAvailable(), executableType, result.getVersion(), result.getErrorType(), result.getErrorText());
            }
            boolean bl = true;
            this.specificErrorsLock.writeLock().unlock();
            return bl;
        }
        finally {
            programInfoLock.writeLock().unlock();
        }
    }

    public boolean equals(Object object) {
        if (object instanceof Engine) {
            Engine other = (Engine)object;
            return this == object || this.getEngineId() == null && other.getEngineId() == null || this.getEngineId() != null && this.getEngineId().equals(other.getEngineId());
        }
        return false;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.getEngineId() == null ? 0 : this.getEngineId().hashCode());
        return result;
    }

    public static void setAudioAndSubs(StoreItem resource, OutputParams params) {
        if (resource == null || params == null || resource.getMediaInfo() == null) {
            return;
        }
        if (params.getAid() == null) {
            params.setAid(resource.resolveAudioStream());
        }
        if (params.getSid() != null && params.getSid().getId() == Integer.MIN_VALUE) {
            LOGGER.trace("Don't want subtitles!");
            params.setSid(null);
        } else if (params.getSid() == null) {
            params.setSid(resource.resolveSubtitlesStream(params.getAid() == null ? null : params.getAid().getLang(), true));
        }
    }

    public static boolean isMuxable(MediaVideo videoTrack, Renderer renderer) {
        boolean muxable;
        if (videoTrack == null) {
            return false;
        }
        boolean bl = muxable = videoTrack.isH264() || videoTrack.isH265();
        if (renderer.isMaximumResolutionSpecified() && (videoTrack.getWidth() > renderer.getMaxVideoWidth() || videoTrack.getHeight() > renderer.getMaxVideoHeight()) || !renderer.isMuxNonMod4Resolution() && !videoTrack.isMod4()) {
            muxable = false;
        }
        if (renderer.isBRAVIA() && videoTrack.isH264() && videoTrack.getHeight() < 288) {
            muxable = false;
        }
        return muxable;
    }

    protected static boolean isMuxable(String codecA) {
        return codecA != null && (codecA.startsWith("dts") || codecA.equals("dca"));
    }

    protected static String getValidFps(Double frameRate, boolean ratios) {
        if (frameRate != null) {
            try {
                if (frameRate >= 14.99 && frameRate < 15.1) {
                    return "15";
                }
                if (frameRate > 23.9 && frameRate < 23.99) {
                    return ratios ? "24000/1001" : "23.976";
                }
                if (frameRate > 23.99 && frameRate < 24.1) {
                    return "24";
                }
                if (frameRate >= 24.99 && frameRate < 25.1) {
                    return "25";
                }
                if (frameRate > 29.9 && frameRate < 29.99) {
                    return ratios ? "30000/1001" : "29.97";
                }
                if (frameRate >= 29.99 && frameRate < 30.1) {
                    return "30";
                }
                if (frameRate > 47.9 && frameRate < 47.99) {
                    return ratios ? "48000/1001" : "47.952";
                }
                if (frameRate > 49.9 && frameRate < 50.1) {
                    return "50";
                }
                if (frameRate > 59.8 && frameRate < 59.99) {
                    return ratios ? "60000/1001" : "59.94";
                }
                if (frameRate >= 59.99 && frameRate < 60.1) {
                    return "60";
                }
            }
            catch (NumberFormatException nfe) {
                LOGGER.error(null, nfe);
            }
        }
        return null;
    }

    public boolean isWebDl(String filename, MediaInfo media, OutputParams params) {
        if (filename.toLowerCase().replaceAll("\\-", "").contains("webdl")) {
            return true;
        }
        return media.getTitle() != null && media.getTitle().toLowerCase().replaceAll("\\-", "").contains("webdl") || media.getDefaultVideoTrack() != null && media.getDefaultVideoTrack().getTitle() != null && media.getDefaultVideoTrack().getTitle().toLowerCase().replaceAll("\\-", "").contains("webdl") || params.getAid() != null && params.getAid().getTitle() != null && params.getAid().getTitle().toLowerCase().replaceAll("\\-", "").contains("webdl") || params.getSid() != null && params.getSid().getTitle() != null && params.getSid().getTitle().toLowerCase().replaceAll("\\-", "").contains("webdl");
    }

    public boolean isVideoWithinH264LevelLimits(MediaVideo video, Renderer renderer) {
        if (video != null && video.isH264()) {
            byte referenceFrameCount = video.getReferenceFrameCount();
            int width = video.getWidth();
            int height = video.getHeight();
            if (referenceFrameCount == -1 || width < 1 || height < 1) {
                LOGGER.debug("The video may not be compatible with this renderer because we can't get its number of reference frames");
                return false;
            }
            double videoLevel = video.getFormatLevelAsDouble(0.0);
            if (videoLevel == 0.0) {
                return false;
            }
            double limitLevel = renderer.getH264LevelLimit();
            if (videoLevel > limitLevel) {
                LOGGER.debug("The H.264 level ({}) is not supported by the renderer (limit: {}).", (Object)videoLevel, (Object)limitLevel);
                return false;
            }
            int maximumStoredFrames = H264.getMaximumStoredFrames(limitLevel, width, height);
            if (referenceFrameCount > maximumStoredFrames) {
                LOGGER.debug("The video is not compatible with this renderer because it can only take {} reference frames at this resolution while this video has {} reference frames", (Object)maximumStoredFrames, (Object)referenceFrameCount);
            }
            return true;
        }
        return false;
    }
}

