/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.drew.lang.ByteArrayReader;
import com.sun.jna.Platform;
import java.awt.Dimension;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.coobird.thumbnailator.Thumbnails;
import net.coobird.thumbnailator.util.exif.ExifFilterUtils;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.encoders.EncodingFormat;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.EngineId;
import net.pms.encoders.ImageEngine;
import net.pms.encoders.StandardEngineId;
import net.pms.formats.Format;
import net.pms.image.ExifInfo;
import net.pms.image.ExifOrientation;
import net.pms.image.ImageInfo;
import net.pms.image.ImagesUtil;
import net.pms.io.InternalJavaProcessImpl;
import net.pms.io.ListProcessWrapperResult;
import net.pms.io.OutputParams;
import net.pms.io.ProcessWrapper;
import net.pms.io.ProcessWrapperImpl;
import net.pms.io.SimpleProcessWrapper;
import net.pms.media.MediaInfo;
import net.pms.parsers.MetadataExtractorParser;
import net.pms.platform.windows.NTStatus;
import net.pms.store.StoreItem;
import net.pms.util.ExecutableErrorType;
import net.pms.util.ExecutableInfo;
import net.pms.util.Version;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DCRaw
extends ImageEngine {
    private static final Logger LOGGER = LoggerFactory.getLogger(DCRaw.class);
    public static final EngineId ID = StandardEngineId.DCRAW;
    public static final String KEY_DCRAW_PATH = "dcraw_path";
    public static final String KEY_DCRAW_EXECUTABLE_TYPE = "dcraw_executable_type";
    public static final String NAME = "DCRaw";

    DCRaw() {
        super(CONFIGURATION.getDCRawPaths());
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public String getConfigurablePathKey() {
        return KEY_DCRAW_PATH;
    }

    @Override
    public String getExecutableTypeKey() {
        return KEY_DCRAW_EXECUTABLE_TYPE;
    }

    @Override
    public ProcessWrapper launchTranscode(StoreItem resource, MediaInfo media, OutputParams params) throws IOException {
        if (media == null || resource == null) {
            return null;
        }
        String filename = resource.getFileName();
        byte[] image = this.getImage(params, filename, media.getImageInfo());
        if (image == null) {
            return null;
        }
        return new InternalJavaProcessImpl(new ByteArrayInputStream(image));
    }

    @Override
    public String getMimeType() {
        return "image/jpeg";
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int purpose() {
        return 4;
    }

    @Override
    public byte[] getImage(OutputParams params, String fileName, ImageInfo imageInfo) {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.trace("Decoding image \"{}\" with DCRaw", (Object)fileName);
        }
        if (params == null) {
            params = new OutputParams(PMS.getConfiguration());
        }
        params.setLog(false);
        params.setOutputByteArrayStreamBufferSize(imageInfo != null && imageInfo.getSize() != Long.MIN_VALUE ? (int)imageInfo.getSize() : 5000000);
        String[] cmdArray = new String[]{EngineFactory.getEngineExecutable(ID), "-c", "-M", "-w", fileName};
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, true, params, false, true);
        pw.runInSameThread();
        byte[] bytes = pw.getOutputByteArray().toByteArray();
        List<String> results = pw.getResults();
        if (bytes == null || bytes.length == 0) {
            if (!results.isEmpty() && results.get(0).startsWith("Cannot decode file")) {
                LOGGER.warn("DCRaw could not decode image \"{}\"", (Object)fileName);
            } else if (!results.isEmpty()) {
                LOGGER.debug("DCRaw failed to decode image \"{}\": {}", (Object)fileName, (Object)StringUtils.join(results, "\n"));
            }
            return null;
        }
        return bytes;
    }

    @Override
    public byte[] getThumbnail(OutputParams params, String fileName, ImageInfo imageInfo) {
        boolean trace = LOGGER.isTraceEnabled();
        if (trace) {
            LOGGER.trace("Extracting thumbnail from \"{}\" with DCRaw", (Object)fileName);
        }
        if (params == null) {
            params = new OutputParams(PMS.getConfiguration());
        }
        params.setLog(false);
        params.setOutputByteArrayStreamBufferSize(150000);
        String[] cmdArray = new String[]{EngineFactory.getEngineExecutable(ID), "-e", "-c", "-M", "-w", fileName};
        ProcessWrapperImpl pw = new ProcessWrapperImpl(cmdArray, true, params, false, true);
        pw.runInSameThread();
        byte[] bytes = pw.getOutputByteArray().toByteArray();
        List<String> results = pw.getResults();
        if (bytes.length > 0) {
            ExifOrientation imageOrientation;
            boolean isJPEG = (bytes[0] & 0xFF) == 255 && (bytes[1] & 0xFF) == 216;
            ExifOrientation thumbnailOrientation = null;
            Dimension jpegResolution = null;
            int exifOrientationOffset = -1;
            if (isJPEG) {
                try {
                    ByteArrayReader reader = new ByteArrayReader(bytes);
                    exifOrientationOffset = MetadataExtractorParser.getJPEGExifIFDTagOffset(274, reader);
                    jpegResolution = MetadataExtractorParser.getJPEGResolution(reader);
                }
                catch (IOException e) {
                    exifOrientationOffset = -1;
                    LOGGER.debug("Unexpected error while trying to find Exif orientation offset in embedded thumbnail for \"{}\": {}", (Object)fileName, (Object)e.getMessage());
                    LOGGER.trace("", e);
                }
                if (exifOrientationOffset > 0) {
                    thumbnailOrientation = ExifOrientation.typeOf(bytes[exifOrientationOffset]);
                } else {
                    LOGGER.debug("Couldn't find Exif orientation in the thumbnail extracted from \"{}\"", (Object)fileName);
                }
            }
            ExifOrientation exifOrientation = imageOrientation = imageInfo instanceof ExifInfo ? ((ExifInfo)imageInfo).getOriginalExifOrientation() : null;
            if (imageOrientation != null && imageOrientation != thumbnailOrientation) {
                if (thumbnailOrientation != null && imageInfo != null) {
                    double thumbnailAspect;
                    double imageAspect;
                    if (imageInfo.getWidth() > 0 && imageInfo.getHeight() > 0 && jpegResolution != null && jpegResolution.getWidth() > 0.0 && jpegResolution.getHeight() > 0.0 && Math.abs((imageAspect = ImagesUtil.isExifAxesSwapNeeded(imageOrientation) ? (double)imageInfo.getHeight() / (double)imageInfo.getWidth() : (double)imageInfo.getWidth() / (double)imageInfo.getHeight()) - (thumbnailAspect = ImagesUtil.isExifAxesSwapNeeded(thumbnailOrientation) ? jpegResolution.getHeight() / jpegResolution.getWidth() : jpegResolution.getWidth() / jpegResolution.getHeight())) > 0.001) {
                        bytes[exifOrientationOffset] = (byte)imageOrientation.getValue();
                    }
                } else if (imageOrientation != ExifOrientation.TOP_LEFT) {
                    try {
                        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
                        Thumbnails.of(new ByteArrayInputStream(bytes)).scale(1.0).addFilter(ExifFilterUtils.getFilterForOrientation(imageOrientation.getThumbnailatorOrientation())).outputFormat("PNG").outputQuality(1.0f).toOutputStream(outputStream);
                        bytes = outputStream.toByteArray();
                    }
                    catch (IOException e) {
                        LOGGER.error("Unexpected error when trying to rotate thumbnail for \"{}\" - cancelling rotation: {}", (Object)fileName, (Object)e.getMessage());
                        LOGGER.trace("", e);
                    }
                }
            }
        }
        if (bytes.length == 0 || !results.isEmpty() && results.get(0).contains("has no thumbnail")) {
            if (trace) {
                LOGGER.trace("No embedded thumbnail found in \"{}\", trying to generate thumbnail from the image itself", (Object)fileName);
            }
            params.setOutputByteArrayStreamBufferSize(imageInfo != null && imageInfo.getSize() != Long.MIN_VALUE ? (int)imageInfo.getSize() / 4 : 500000);
            cmdArray[1] = "-h";
            pw = new ProcessWrapperImpl(cmdArray, true, params);
            pw.runInSameThread();
            bytes = pw.getOutputByteArray().toByteArray();
        }
        if (trace && (bytes == null || bytes.length == 0)) {
            LOGGER.trace("Failed to generate thumbnail with DCRaw for image \"{}\"", (Object)fileName);
        }
        return bytes != null && bytes.length > 0 ? bytes : null;
    }

    @Override
    public boolean isCompatible(StoreItem resource) {
        return resource != null && resource.getFormat() != null && resource.getFormat().getIdentifier() == Format.Identifier.RAW;
    }

    @Override
    public boolean isCompatible(EncodingFormat encodingFormat) {
        return true;
    }

    @Override
    public boolean excludeFormat(Format extension) {
        return false;
    }

    @Override
    @Nullable
    public ExecutableInfo testExecutable(@Nonnull ExecutableInfo executableInfo) {
        if (Boolean.FALSE.equals((executableInfo = this.testExecutableFile(executableInfo)).getAvailable())) {
            return executableInfo;
        }
        ExecutableInfo.ExecutableInfoBuilder result = executableInfo.modify();
        try {
            ListProcessWrapperResult output = SimpleProcessWrapper.runProcessListOutput(30000L, 1000L, executableInfo.getPath().toString());
            if (output.getError() != null) {
                result.errorType(ExecutableErrorType.GENERAL);
                result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + " \n" + output.getError().getMessage());
                result.available(Boolean.FALSE);
                LOGGER.debug("\"{}\" failed with error: {}", (Object)executableInfo.getPath(), (Object)output.getError().getMessage());
                return result.build();
            }
            if (!output.getOutput().isEmpty() && StringUtils.isBlank((CharSequence)output.getOutput().get(0))) {
                Pattern pattern;
                Matcher matcher;
                if (output.getOutput().size() > 1 && (matcher = (pattern = Pattern.compile("decoder\\s\"dcraw\"\\s(\\S+)", 2)).matcher((CharSequence)output.getOutput().get(1))).find() && StringUtils.isNotBlank(matcher.group(1))) {
                    result.version(new Version(matcher.group(1)));
                }
                result.available(Boolean.TRUE);
            } else if (!output.getOutput().isEmpty()) {
                result.errorType(ExecutableErrorType.GENERAL);
                result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + " \n" + (String)output.getOutput().get(0));
                result.available(Boolean.FALSE);
            } else {
                NTStatus ntStatus;
                NTStatus nTStatus = ntStatus = Platform.isWindows() ? NTStatus.typeOf(output.getExitCode()) : null;
                if (ntStatus != null && ntStatus != NTStatus.STATUS_SUCCESS) {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + "\n\n" + ntStatus);
                } else {
                    result.errorType(ExecutableErrorType.GENERAL);
                    result.errorText(String.format(Messages.getString("TranscodingEngineXNotAvailable"), this) + Messages.getString("UnknownError"));
                }
                result.available(Boolean.FALSE);
            }
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            return null;
        }
        return result.build();
    }

    @Override
    protected boolean isSpecificTest() {
        return false;
    }
}

