/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.StringTokenizer;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EngineId;
import net.pms.encoders.MEncoderVideo;
import net.pms.encoders.StandardEngineId;
import net.pms.formats.Format;
import net.pms.formats.v2.SubtitleType;
import net.pms.media.audio.MediaAudio;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.store.StoreItem;
import net.pms.util.PlayerUtil;
import net.pms.util.ProcessUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AviSynthMEncoder
extends MEncoderVideo {
    private static final Logger LOGGER = LoggerFactory.getLogger(AviSynthMEncoder.class);
    public static final EngineId ID = StandardEngineId.AVI_SYNTH_MENCODER;
    public static final String NAME = "AviSynth/MEncoder";

    AviSynthMEncoder() {
    }

    @Override
    public int purpose() {
        return 0;
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public boolean isAviSynthEngine() {
        return true;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isGPUAccelerationReady() {
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public static File getAVSScript(String fileName, MediaSubtitle subTrack, int fromFrame, int toFrame, String frameRateRatio, String frameRateNumber, UmsConfiguration configuration) throws IOException {
        String onlyFileName = fileName.substring(1 + fileName.lastIndexOf(92));
        File file = new File(CONFIGURATION.getTempFolder(), "ums-avs-" + onlyFileName + ".avs");
        try (PrintWriter pw = new PrintWriter(new FileOutputStream(file));){
            File f;
            String denominator;
            String numerator;
            if (frameRateRatio != null && frameRateNumber != null) {
                if (frameRateRatio.equals(frameRateNumber)) {
                    numerator = frameRateRatio;
                    denominator = "1";
                } else {
                    String[] frameRateNumDen = frameRateRatio.split("/");
                    numerator = frameRateNumDen[0];
                    denominator = "1001";
                }
            } else {
                numerator = "24000";
                denominator = "1001";
                frameRateNumber = "23.976";
            }
            String assumeFPS = ".AssumeFPS(" + numerator + "," + denominator + ")";
            Object directShowFPS = "";
            if (!"0".equals(frameRateNumber)) {
                directShowFPS = ", fps=" + frameRateNumber;
            }
            String convertfps = "";
            if (configuration.getAvisynthConvertFps()) {
                convertfps = ", convertfps=true";
            }
            if ((f = new File(fileName)).exists()) {
                fileName = ProcessUtil.getShortFileNameIfWideChars(fileName);
            }
            String movieLine = "DirectShowSource(\"" + fileName + "\"" + (String)directShowFPS + convertfps + ")" + assumeFPS;
            Object mtLine1 = "";
            String mtLine2 = "";
            String mtLine3 = "";
            String interframeLines = null;
            String interframePath = configuration.getInterFramePath();
            int cores = 1;
            if (configuration.getAvisynthMultiThreading()) {
                cores = configuration.getNumberOfCpuCores();
                mtLine1 = "SetMemoryMax(512)\nSetMTMode(3," + cores + ")\n";
                mtLine2 = "SetMTMode(2)";
                mtLine3 = "SetMTMode(1)\nGetMTMode(false) > 0 ? distributor() : last";
            }
            if (configuration.getAvisynthInterFrame()) {
                String gpu = "";
                movieLine = movieLine + ".ConvertToYV12()";
                if (configuration.getAvisynthInterFrameGPU() && configuration.isGPUAcceleration()) {
                    gpu = ", GPU=true";
                }
                interframeLines = "\nPluginPath = \"" + interframePath + "\"\nLoadPlugin(PluginPath+\"svpflow1.dll\")\nLoadPlugin(PluginPath+\"svpflow2.dll\")\nImport(PluginPath+\"InterFrame2.avsi\")\nInterFrame(Cores=" + cores + gpu + ", Preset=\"Faster\")\n";
            }
            String subLine = null;
            if (subTrack != null && subTrack.isExternal() && configuration.isAutoloadExternalSubtitles() && !configuration.isDisableSubtitles()) {
                if (subTrack.getExternalFile() != null) {
                    LOGGER.info("AviSynth script: Using subtitle track: {}", (Object)subTrack);
                    String function = "TextSub";
                    if (subTrack.getType() == SubtitleType.VOBSUB) {
                        function = "VobSub";
                    }
                    subLine = function + "(\"" + ProcessUtil.getShortFileNameIfWideChars(subTrack.getExternalFile()) + "\")";
                } else {
                    LOGGER.error("External subtitles file \"{}\" is unavailable", (Object)subTrack.getName());
                }
            }
            ArrayList<Object> lines = new ArrayList<Object>();
            lines.add(mtLine1);
            boolean fullyManaged = false;
            String script = configuration.getAvisynthScript();
            StringTokenizer st = new StringTokenizer(script, "\u0001");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (line.contains("<movie") || line.contains("<sub")) {
                    fullyManaged = true;
                }
                lines.add(line);
            }
            lines.add(mtLine2);
            if (configuration.getAvisynthInterFrame()) {
                lines.add(interframeLines);
            }
            lines.add(mtLine3);
            if (fullyManaged) {
                for (String string : lines) {
                    void var29_34;
                    if (string.contains("<moviefilename>")) {
                        String string2 = string.replace("<moviefilename>", fileName);
                    }
                    String string4 = var29_34.replace("<movie>", movieLine);
                    string4 = string4.replace("<sub>", (CharSequence)(subLine != null ? subLine : "#"));
                    pw.println(string4);
                }
            } else {
                pw.println(movieLine);
                if (subLine != null) {
                    pw.println(subLine);
                }
                pw.println("clip");
            }
        }
        file.deleteOnExit();
        return file;
    }

    @Override
    public boolean isCompatible(StoreItem item) {
        Format format = item.getFormat();
        if (format != null && format.getIdentifier() == Format.Identifier.WEB) {
            return false;
        }
        MediaSubtitle subtitle = item.getMediaSubtitle();
        if (subtitle != null && subtitle.getLang() != null) {
            return subtitle.isExternal();
        }
        MediaAudio audio = item.getMediaAudio();
        if (audio != null) {
            try {
                String audioTrackName = item.getMediaAudio().toString();
                String defaultAudioTrackName = item.getMediaInfo().getDefaultAudioTrack().toString();
                if (!audioTrackName.equals(defaultAudioTrackName)) {
                    return false;
                }
            }
            catch (NullPointerException e) {
                LOGGER.trace("AviSynth/MEncoder cannot determine compatibility based on audio track for " + item.getFileName());
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.trace("AviSynth/MEncoder cannot determine compatibility based on default audio track for " + item.getFileName());
            }
        }
        return PlayerUtil.isVideo(item, Format.Identifier.MKV) || PlayerUtil.isVideo(item, Format.Identifier.MPG) || PlayerUtil.isVideo(item, Format.Identifier.OGG);
    }
}

