/*
 * Decompiled with CFR 0.152.
 */
package net.pms.encoders;

import com.sun.jna.Platform;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.StringTokenizer;
import javax.annotation.Nonnull;
import net.pms.Messages;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EngineId;
import net.pms.encoders.FFMpegVideo;
import net.pms.encoders.StandardEngineId;
import net.pms.formats.Format;
import net.pms.formats.v2.SubtitleType;
import net.pms.io.OutputParams;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.platform.PlatformUtils;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.util.ExecutableErrorType;
import net.pms.util.ExecutableInfo;
import net.pms.util.ExternalProgramInfo;
import net.pms.util.PlayerUtil;
import net.pms.util.ProcessUtil;
import net.pms.util.ProgramExecutableType;
import net.pms.util.Version;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AviSynthFFmpeg
extends FFMpegVideo {
    private static final Logger LOGGER = LoggerFactory.getLogger(AviSynthFFmpeg.class);
    private static final String WIDESCREEN_STANDARD_ASPECT_RATO = "16:9";
    public static final EngineId ID = StandardEngineId.AVI_SYNTH_FFMPEG;
    public static final String NAME = "AviSynth/FFmpeg";
    @Nonnull
    private final ExternalProgramInfo aviSynthInfo = CONFIGURATION.getAviSynthPaths();
    private final ExternalProgramInfo ffms2Info = CONFIGURATION.getFFMS2Paths();
    private final ExternalProgramInfo directShowSourceInfo = CONFIGURATION.getDirectShowSourcePaths();
    private final ExternalProgramInfo mvtools2Info = CONFIGURATION.getMvtools2Paths();
    private final ExternalProgramInfo depanInfo = CONFIGURATION.getDepanPaths();
    private final ExternalProgramInfo masktools2Info = CONFIGURATION.getMasktools2Paths();
    private final ExternalProgramInfo convert2dTo3dInfo = CONFIGURATION.getConvert2dTo3dPaths();
    private final ExternalProgramInfo cropResizeInfo = CONFIGURATION.getCropResizePaths();
    private boolean isAviSynthPlus = false;
    private Path ffms2Path;
    private Path directShowSourcePath;
    private Path mvtools2Path;
    private Path depanPath;
    private Path masktools2Path;
    private Path convert2dTo3dPath;
    private Path cropResizePath;

    AviSynthFFmpeg() {
        if (this.aviSynthInfo == null) {
            throw new IllegalStateException("Can't instantiate " + this.getClass().getSimpleName() + "because executables() returns null");
        }
    }

    @Override
    public EngineId getEngineId() {
        return ID;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public boolean isAviSynthEngine() {
        return true;
    }

    @Override
    public String initialString() {
        Object threads = "";
        if (CONFIGURATION.isFfmpegAviSynthMultithreading()) {
            threads = " -threads " + CONFIGURATION.getNumberOfCpuCores();
        }
        return CONFIGURATION.getMPEG2MainSettingsFFmpeg() + " -ab " + CONFIGURATION.getAudioBitrate() + "k" + (String)threads;
    }

    @Override
    public boolean isGPUAccelerationReady() {
        return true;
    }

    @Override
    public boolean isCompatible(StoreItem item) {
        Format format = item.getFormat();
        if (format != null && format.getIdentifier() == Format.Identifier.WEB) {
            return false;
        }
        MediaSubtitle subtitle = item.getMediaSubtitle();
        if (subtitle != null && subtitle.getLang() != null) {
            return false;
        }
        MediaAudio audio = item.getMediaAudio();
        if (audio != null) {
            try {
                String audioTrackName = item.getMediaAudio().toString();
                String defaultAudioTrackName = item.getMediaInfo().getDefaultAudioTrack().toString();
                if (!audioTrackName.equals(defaultAudioTrackName)) {
                    return false;
                }
            }
            catch (NullPointerException e) {
                LOGGER.trace("AviSynth/FFmpeg cannot determine compatibility based on audio track for " + item.getFileName());
            }
            catch (IndexOutOfBoundsException e) {
                LOGGER.trace("AviSynth/FFmpeg cannot determine compatibility based on default audio track for " + item.getFileName());
            }
        }
        return PlayerUtil.isVideo(item, Format.Identifier.MKV) || PlayerUtil.isVideo(item, Format.Identifier.MPG) || PlayerUtil.isVideo(item, Format.Identifier.OGG);
    }

    @Override
    public ExecutableInfo testExecutable(@Nonnull ExecutableInfo executableInfo) {
        if (Boolean.FALSE.equals((executableInfo = super.testExecutable(executableInfo)).getAvailable())) {
            return executableInfo;
        }
        if (!Platform.isWindows()) {
            return executableInfo.modify().available(false).errorType(ExecutableErrorType.GENERAL).errorText(String.format("Skipping transcoding engine %s as it's not compatible with this platform", this)).build();
        }
        if (this.aviSynthInfo != null) {
            for (ProgramExecutableType executableType : this.aviSynthInfo.getExecutableTypes()) {
                Path aviSynthPath = this.aviSynthInfo.getPath(executableType);
                if (aviSynthPath == null || !Files.exists(aviSynthPath, new LinkOption[0])) continue;
                executableInfo = executableInfo.modify().available(true).build();
                Version version = PlatformUtils.INSTANCE.getFileVersionInfo(aviSynthPath.toString());
                if (version == null) break;
                if (version.getMajor() > 2) {
                    this.isAviSynthPlus = true;
                    LOGGER.debug("Found AviSynth+ version {}", (Object)version);
                    break;
                }
                LOGGER.info("Found AviSynth version {}", (Object)version);
                break;
            }
        }
        if (!Boolean.TRUE.equals(executableInfo.getAvailable())) {
            executableInfo = executableInfo.modify().available(Boolean.FALSE).errorType(ExecutableErrorType.GENERAL).errorText(String.format(Messages.getString("ExecutableXTranscodingEngineNotFound"), executableInfo.getPath(), this)).build();
            return executableInfo;
        }
        if (this.ffms2Info != null) {
            for (ProgramExecutableType executableType : this.ffms2Info.getExecutableTypes()) {
                Path ffms2TestPath = this.ffms2Info.getPath(executableType);
                if (!Files.exists(ffms2TestPath, new LinkOption[0])) continue;
                this.ffms2Path = ffms2TestPath;
                LOGGER.info("Found AviSynth FFmpegSource2 library");
                break;
            }
        }
        if (this.directShowSourceInfo != null) {
            for (ProgramExecutableType executableType : this.directShowSourceInfo.getExecutableTypes()) {
                Path directShowSourceTestPath = this.directShowSourceInfo.getPath(executableType);
                if (!Files.exists(directShowSourceTestPath, new LinkOption[0])) continue;
                this.directShowSourcePath = directShowSourceTestPath;
                LOGGER.info("Found AviSynth DirectShowSource library");
                break;
            }
        }
        if (this.ffms2Path == null && this.directShowSourcePath == null) {
            executableInfo = executableInfo.modify().available(Boolean.FALSE).errorType(ExecutableErrorType.GENERAL).errorText(String.format(Messages.getString("ExecutableXTranscodingEngineNotFound"), executableInfo.getPath(), this)).build();
            return executableInfo;
        }
        if (this.mvtools2Info != null) {
            for (ProgramExecutableType executableType : this.mvtools2Info.getExecutableTypes()) {
                Path mvtools2TestPath = this.mvtools2Info.getPath(executableType);
                if (!Files.exists(mvtools2TestPath, new LinkOption[0])) continue;
                this.mvtools2Path = mvtools2TestPath;
                LOGGER.info("Found AviSynth mvtools2 library");
                break;
            }
        }
        if (this.depanInfo != null) {
            for (ProgramExecutableType executableType : this.depanInfo.getExecutableTypes()) {
                Path depanTestPath = this.depanInfo.getPath(executableType);
                if (!Files.exists(depanTestPath, new LinkOption[0])) continue;
                this.depanPath = depanTestPath;
                LOGGER.info("Found AviSynth Depan library");
                break;
            }
        }
        if (this.masktools2Info != null) {
            for (ProgramExecutableType executableType : this.masktools2Info.getExecutableTypes()) {
                Path masktools2TestPath = this.masktools2Info.getPath(executableType);
                if (!Files.exists(masktools2TestPath, new LinkOption[0])) continue;
                this.masktools2Path = masktools2TestPath;
                LOGGER.info("Found AviSynth masktools2 library");
                break;
            }
        }
        if (this.cropResizeInfo != null) {
            for (ProgramExecutableType executableType : this.cropResizeInfo.getExecutableTypes()) {
                Path cropResizeTestPath = this.cropResizeInfo.getPath(executableType);
                if (!Files.exists(cropResizeTestPath, new LinkOption[0])) continue;
                this.cropResizePath = cropResizeTestPath;
                LOGGER.info("Found AviSynth CropResize script");
                break;
            }
        }
        if (this.convert2dTo3dInfo != null) {
            for (ProgramExecutableType executableType : this.convert2dTo3dInfo.getExecutableTypes()) {
                Path convert2dTo3dTestPath = this.convert2dTo3dInfo.getPath(executableType);
                if (!Files.exists(convert2dTo3dTestPath, new LinkOption[0])) continue;
                this.convert2dTo3dPath = convert2dTo3dTestPath;
                LOGGER.info("Found AviSynth convert2dTo3d script");
                break;
            }
        }
        return executableInfo;
    }

    /*
     * WARNING - void declaration
     */
    public AviSynthScriptGenerationResult getAVSScript(String filename, OutputParams params, String frameRateRatio, String frameRateNumber, MediaInfo media) throws IOException {
        Renderer renderer = params.getMediaRenderer();
        UmsConfiguration configuration = renderer.getUmsConfiguration();
        double timeSeek = params.getTimeSeek();
        String onlyFileName = filename.substring(1 + filename.lastIndexOf(92));
        File file = new File(CONFIGURATION.getTempFolder(), "ums-avs-" + onlyFileName + ".avs");
        AviSynthScriptGenerationResult aviSynthScriptGenerationResult = new AviSynthScriptGenerationResult(file, false);
        try (PrintWriter pw = new PrintWriter(new FileOutputStream(file));){
            String denominator;
            String numerator;
            if (frameRateRatio != null && frameRateNumber != null) {
                if (frameRateRatio.equals(frameRateNumber)) {
                    numerator = frameRateRatio;
                    denominator = "1";
                } else {
                    String[] frameRateNumDen = frameRateRatio.split("/");
                    numerator = frameRateNumDen[0];
                    denominator = "1001";
                }
            } else {
                numerator = "24000";
                denominator = "1001";
                frameRateNumber = "23.976";
            }
            File f = new File(filename);
            if (f.exists()) {
                filename = ProcessUtil.getShortFileNameIfWideChars(filename);
            }
            Object movieLine = "";
            Object mtLine1 = "";
            String mtLine2 = "";
            Object mtPrefetchLine = "";
            String interframeLines = null;
            String interframePath = configuration.getInterFramePath();
            if ((this.directShowSourcePath == null || configuration.getFfmpegAvisynthUseFFMS2()) && this.ffms2Path != null) {
                String fpsNum = "fpsnum=" + numerator;
                String fpsDen = "fpsden=" + denominator;
                convertfps = "";
                if (configuration.getFfmpegAvisynthConvertFps()) {
                    convertfps = ", " + fpsNum + ", " + fpsDen;
                }
                File cachefile = new File(CONFIGURATION.getTempFolder(), "ums-avs-" + onlyFileName + ".ffindex");
                cachefile.deleteOnExit();
                int audioTrack = -1;
                int seekMode = 2;
                movieLine = (String)movieLine + "\n";
                movieLine = (String)movieLine + "LoadPlugin(\"" + this.ffms2Path + "\")\n";
                movieLine = (String)movieLine + "FFMS2(\"" + filename + "\"" + (String)convertfps + ", cachefile=\"" + cachefile.getAbsolutePath() + "\", atrack=" + audioTrack + ", seekmode=" + seekMode + ")";
            } else {
                String assumeFPS = ".AssumeFPS(" + numerator + "," + denominator + ")";
                Object directShowFPS = "";
                if (!"0".equals(frameRateNumber)) {
                    directShowFPS = ", fps=" + frameRateNumber;
                }
                convertfps = "";
                if (configuration.getFfmpegAvisynthConvertFps()) {
                    convertfps = ", convertfps=true";
                }
                movieLine = (String)movieLine + "\n";
                movieLine = (String)movieLine + "LoadPlugin(\"" + this.directShowSourcePath + "\")\n";
                movieLine = (String)movieLine + "DirectShowSource(\"" + filename + "\"" + (String)directShowFPS + (String)convertfps + ")" + assumeFPS;
            }
            int cores = 1;
            if (configuration.isFfmpegAviSynthMultithreading()) {
                cores = configuration.getNumberOfCpuCores();
                if (this.isAviSynthPlus) {
                    mtLine1 = "SetFilterMTMode(\"DEFAULT_MT_MODE\", 2)\n";
                    mtPrefetchLine = "Prefetch(" + cores + ")\n";
                } else {
                    mtLine1 = "SetMemoryMax(512)\nSetMTMode(3," + cores + ")\n";
                    mtLine2 = "SetMTMode(2)";
                }
            }
            if (configuration.getFfmpegAvisynthInterFrame() && interframePath != null) {
                String gpu = "";
                movieLine = (String)movieLine + ".ConvertToYV12()";
                if (configuration.getFfmpegAvisynthInterFrameGPU() && configuration.isGPUAcceleration()) {
                    gpu = ", GPU=true";
                }
                interframeLines = "\nPluginPath = \"" + interframePath + "\"\nLoadPlugin(PluginPath+\"svpflow1.dll\")\nLoadPlugin(PluginPath+\"svpflow2.dll\")\nImport(PluginPath+\"InterFrame2.avsi\")\nInterFrame(Cores=" + cores + gpu + ", Preset=\"Faster\")\n";
            }
            String subLine = null;
            MediaSubtitle subTrack = params.getSid();
            if (subTrack != null && subTrack.isExternal() && configuration.isAutoloadExternalSubtitles() && !configuration.isDisableSubtitles()) {
                if (subTrack.getExternalFile() != null) {
                    LOGGER.info("AviSynth script: Using subtitle track: {}", (Object)subTrack);
                    String function = "TextSub";
                    if (subTrack.getType() == SubtitleType.VOBSUB) {
                        function = "VobSub";
                    }
                    subLine = function + "(\"" + ProcessUtil.getShortFileNameIfWideChars(subTrack.getExternalFile()) + "\")";
                } else {
                    LOGGER.error("External subtitles file \"{}\" is unavailable", (Object)subTrack.getName());
                }
            }
            ArrayList<Object> lines = new ArrayList<Object>();
            lines.add(mtLine1);
            boolean fullyManaged = false;
            String script = "<movie>\n<sub>\n";
            StringTokenizer st = new StringTokenizer(script, "\u0001");
            while (st.hasMoreTokens()) {
                String line = st.nextToken();
                if (line.contains("<movie") || line.contains("<sub")) {
                    fullyManaged = true;
                }
                lines.add(line);
            }
            if (configuration.isFfmpegAvisynth2Dto3D() && renderer.getAviSynth2Dto3D() && this.mvtools2Path != null && this.depanPath != null && this.masktools2Path != null && this.convert2dTo3dPath != null && this.cropResizePath != null) {
                boolean rendererRequestsToKeepStandardAspectRatio;
                LOGGER.debug("AviSynth will seek to time index: " + timeSeek + ", before 2D to 3D conversion");
                lines.add("video2d=Last");
                lines.add("seekFrame=int(video2d.FrameRate*" + timeSeek + "+0.5)");
                lines.add("video2dFromSeekPoint=Trim(video2d,seekFrame,0)");
                lines.add("\nLoadPlugin(\"" + this.mvtools2Path + "\")\nLoadPlugin(\"" + this.depanPath + "\")\nLoadPlugin(\"" + this.masktools2Path + "\")\nImport(\"" + this.cropResizePath + "\")\nImport(\"" + this.convert2dTo3dPath + "\")\n\n");
                int frameStretchFactor = configuration.getFfmpegAvisynthFrameStretchFactor();
                int n = configuration.getFfmpegAvisynthLightOffsetFactor();
                boolean forceStandardAspectRatio = false;
                boolean bl = rendererRequestsToKeepStandardAspectRatio = renderer.isKeepAspectRatio() || renderer.isKeepAspectRatioTranscoding();
                if (rendererRequestsToKeepStandardAspectRatio) {
                    LOGGER.debug("AviSynth, renderer requests keeping standard aspect ratio");
                    boolean mediaMeetsStandardAspectRatioRequirement = WIDESCREEN_STANDARD_ASPECT_RATO.equals(media.getDefaultVideoTrack().getDisplayAspectRatio());
                    if (mediaMeetsStandardAspectRatioRequirement) {
                        LOGGER.debug("AviSynth, media already meets standard aspect ratio requirement so no transformation required");
                    }
                    boolean bl2 = forceStandardAspectRatio = !mediaMeetsStandardAspectRatioRequirement;
                    if (forceStandardAspectRatio) {
                        LOGGER.debug("AviSynth, forcing standard aspect ratio transform as media has a different aspect ratio");
                    }
                }
                lines.add("convert2dTo3d(video2dFromSeekPoint, algorithm=" + configuration.getFfmpegAvisynthConversionAlgorithm2Dto3D() + ", outputFormat=" + configuration.getFfmpegAvisynthOutputFormat3D() + ", resize=" + configuration.isFfmpegAvisynthHorizontalResize() + ", hzTargetSize=" + configuration.getFfmpegAvisynthHorizontalResizeResolution() + ", frameStretchFactor=" + frameStretchFactor + ", lightOffsetFactor=" + n + ", forceTargetDAR=" + forceStandardAspectRatio + ")");
                aviSynthScriptGenerationResult.setConvertedTo3d(true);
            }
            if (configuration.getFfmpegAvisynthInterFrame() && interframePath != null) {
                lines.add(mtLine2);
                lines.add(interframeLines);
            }
            if (configuration.isFfmpegAviSynthMultithreading() && this.isAviSynthPlus) {
                lines.add(mtPrefetchLine);
            }
            if (fullyManaged) {
                for (String string : lines) {
                    void var31_39;
                    if (string.contains("<moviefilename>")) {
                        String string2 = string.replace("<moviefilename>", filename);
                    }
                    String string4 = var31_39.replace("<movie>", (CharSequence)movieLine);
                    string4 = string4.replace("<sub>", (CharSequence)(subLine != null ? subLine : "#"));
                    pw.println(string4);
                }
            } else {
                pw.println((String)movieLine);
                if (subLine != null) {
                    pw.println(subLine);
                }
                pw.println("clip");
            }
        }
        file.deleteOnExit();
        return aviSynthScriptGenerationResult;
    }

    public class AviSynthScriptGenerationResult {
        private File avsFile = null;
        private boolean convertedTo3d = false;

        public AviSynthScriptGenerationResult(File avsFile, boolean convertedTo3d) {
            this.avsFile = avsFile;
            this.convertedTo3d = convertedTo3d;
        }

        public File getAvsFile() {
            return this.avsFile;
        }

        public void setAvsFile(File avsFile) {
            this.avsFile = avsFile;
        }

        public boolean isConvertedTo3d() {
            return this.convertedTo3d;
        }

        public void setConvertedTo3d(boolean convertedTo3d) {
            this.convertedTo3d = convertedTo3d;
        }
    }
}

