/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.protocolinfo;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Locale;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.pms.dlna.protocolinfo.ProtocolInfoAttribute;
import net.pms.dlna.protocolinfo.ProtocolInfoAttributeName;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface ProfileName
extends ProtocolInfoAttribute {

    public static class DefaultGenericProfileName
    extends AbstractDefaultProfileName {
        private static final long serialVersionUID = 1L;
        public static final DefaultGenericProfileNameFactory FACTORY = new DefaultGenericProfileNameFactory();
        protected final ProtocolInfoAttributeName name;

        protected DefaultGenericProfileName(ProtocolInfoAttributeName name, String value) {
            super(value);
            this.name = name;
        }

        @Override
        public ProtocolInfoAttributeName getName() {
            return this.name;
        }
    }

    public static class DefaultGenericProfileNameFactory {
        private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProfileNameFactory.class);
        protected final ReentrantReadWriteLock instanceCacheLock = new ReentrantReadWriteLock();
        protected final HashMap<ProtocolInfoAttributeName, HashSet<DefaultGenericProfileName>> instanceCache = new HashMap();

        protected DefaultGenericProfileNameFactory() {
        }

        public DefaultGenericProfileName getProfileName(String name, String value) {
            return this.getProfileName(ProtocolInfoAttributeName.FACTORY.createAttributeName(name), value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DefaultGenericProfileName getProfileName(ProtocolInfoAttributeName name, String value) {
            block5: {
                value = StringUtils.isBlank(value) ? "" : value.trim().toUpperCase(Locale.ROOT);
                this.instanceCacheLock.readLock().lock();
                try {
                    HashSet<DefaultGenericProfileName> set = this.instanceCache.get(name);
                    if (set == null) break block5;
                    for (DefaultGenericProfileName cachedProfileName : set) {
                        if (!value.equals(cachedProfileName.getValue())) continue;
                        DefaultGenericProfileName defaultGenericProfileName = cachedProfileName;
                        return defaultGenericProfileName;
                    }
                }
                finally {
                    this.instanceCacheLock.readLock().unlock();
                }
            }
            return null;
        }

        public DefaultGenericProfileName createProfileName(String name, String value) {
            return this.createProfileName(ProtocolInfoAttributeName.FACTORY.createAttributeName(name), value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DefaultGenericProfileName createProfileName(ProtocolInfoAttributeName name, String value) {
            DefaultGenericProfileName instance = this.getProfileName(name, value);
            if (instance != null) {
                return instance;
            }
            value = StringUtils.isBlank(value) ? "" : value.trim().toUpperCase(Locale.ROOT);
            this.instanceCacheLock.writeLock().lock();
            try {
                HashSet<DefaultGenericProfileName> set = this.instanceCache.get(name);
                if (set != null) {
                    for (DefaultGenericProfileName cachedProfileName : set) {
                        if (!value.equals(cachedProfileName.getValue())) continue;
                        DefaultGenericProfileName defaultGenericProfileName = cachedProfileName;
                        return defaultGenericProfileName;
                    }
                } else {
                    set = new HashSet();
                    this.instanceCache.put(name, set);
                }
                instance = new DefaultGenericProfileName(name, value);
                set.add(instance);
                LOGGER.trace("Adding unknown generic \"{}\" profile name \"{}\"", (Object)name, (Object)value);
                DefaultGenericProfileName defaultGenericProfileName = instance;
                return defaultGenericProfileName;
            }
            finally {
                this.instanceCacheLock.writeLock().unlock();
            }
        }
    }

    public static abstract class AbstractDefaultProfileName
    implements ProfileName {
        private static final long serialVersionUID = 1L;
        protected final String value;

        protected AbstractDefaultProfileName(String value) {
            this.value = value;
        }

        @Override
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return this.getName() + " = " + this.value;
        }

        @Override
        public abstract ProtocolInfoAttributeName getName();

        @Override
        public String getNameString() {
            return this.getName() == null ? "" : this.getName().getName();
        }

        @Override
        public String getAttributeString() {
            return StringUtils.isBlank(this.getNameString()) || StringUtils.isBlank(this.value) ? "" : this.getNameString() + "=" + this.value;
        }
    }

    public static abstract class AbstractProfileNameFactory<E extends ProfileName> {
        private static final Logger LOGGER = LoggerFactory.getLogger(AbstractProfileNameFactory.class);
        protected final ReentrantReadWriteLock instanceCacheLock = new ReentrantReadWriteLock();
        protected final HashSet<E> instanceCache = new HashSet();

        protected abstract E getNoneInstance();

        protected abstract E searchKnownInstances(String var1);

        protected abstract E getNewInstance(String var1);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E getProfileName(String value) {
            if (StringUtils.isBlank(value)) {
                return this.getNoneInstance();
            }
            E instance = this.searchKnownInstances(value = value.trim().toUpperCase(Locale.ROOT));
            if (instance != null) {
                return instance;
            }
            this.instanceCacheLock.readLock().lock();
            try {
                for (ProfileName cachedAttribute : this.instanceCache) {
                    if (!value.equals(cachedAttribute.getValue())) continue;
                    ProfileName profileName = cachedAttribute;
                    return (E)profileName;
                }
            }
            finally {
                this.instanceCacheLock.readLock().unlock();
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public E createProfileName(String value) {
            E instance = this.getProfileName(value);
            if (instance != null) {
                return instance;
            }
            value = value.trim().toUpperCase(Locale.ROOT);
            this.instanceCacheLock.writeLock().lock();
            try {
                for (ProfileName cachedAttribute : this.instanceCache) {
                    if (!value.equals(cachedAttribute.getValue())) continue;
                    ProfileName profileName = cachedAttribute;
                    return (E)profileName;
                }
                instance = this.getNewInstance(value);
                this.instanceCache.add(instance);
                LOGGER.trace("{} added unknown profile \"{}\"", (Object)this.getClass().getSimpleName(), (Object)value);
                Iterator<E> iterator = instance;
                return (E)iterator;
            }
            finally {
                this.instanceCacheLock.writeLock().unlock();
            }
        }
    }
}

