/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.protocolinfo;

import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import net.pms.dlna.protocolinfo.ProtocolInfoAttribute;
import net.pms.dlna.protocolinfo.ProtocolInfoAttributeName;
import net.pms.util.Rational;
import org.apache.commons.lang3.StringUtils;

public class DLNAOrgPlaySpeeds
implements ProtocolInfoAttribute {
    private static final long serialVersionUID = 1L;
    public static final DLNAOrgPlaySpeeds NONE = new DLNAOrgPlaySpeeds(new Rational[0]);
    public static final DLNAOrgPlaySpeedsFactory FACTORY = new DLNAOrgPlaySpeedsFactory();
    public static final ProtocolInfoAttributeName NAME = ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_PS;
    protected final SortedSet<Rational> speeds;
    protected final String stringValue;
    protected final int hashCode;

    private DLNAOrgPlaySpeeds(Rational ... speeds) {
        TreeSet<Rational> speedSet = new TreeSet<Rational>();
        for (Rational speed : speeds) {
            if (speed == null || Rational.ONE.equals(speed)) continue;
            speedSet.add(speed);
        }
        this.speeds = Collections.unmodifiableSortedSet(speedSet);
        this.stringValue = DLNAOrgPlaySpeeds.generateStringValue(this.speeds);
        this.hashCode = this.calculateHashCode();
    }

    private DLNAOrgPlaySpeeds(SortedSet<Rational> speedSet) {
        TreeSet<Rational> newSpeedsSet = new TreeSet<Rational>();
        for (Rational speed : speedSet) {
            if (speed == null || Rational.ONE.equals(speed)) continue;
            newSpeedsSet.add(speed);
        }
        this.speeds = Collections.unmodifiableSortedSet(newSpeedsSet);
        this.stringValue = DLNAOrgPlaySpeeds.generateStringValue(this.speeds);
        this.hashCode = this.calculateHashCode();
    }

    public SortedSet<Rational> getSpeeds() {
        return this.speeds;
    }

    @Override
    public ProtocolInfoAttributeName getName() {
        return NAME;
    }

    @Override
    public String getNameString() {
        return NAME.getName();
    }

    @Override
    public String getValue() {
        return this.stringValue;
    }

    @Override
    public String getAttributeString() {
        return StringUtils.isBlank(this.stringValue) ? "" : NAME + "=" + this.stringValue;
    }

    public String toString() {
        return this.stringValue;
    }

    public int hashCode() {
        return this.hashCode;
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null) {
            return false;
        }
        if (!(object instanceof DLNAOrgPlaySpeeds)) {
            return false;
        }
        DLNAOrgPlaySpeeds other = (DLNAOrgPlaySpeeds)object;
        if (this.speeds == null) {
            return other.speeds == null;
        }
        if (this.speeds.size() != other.speeds.size()) {
            return false;
        }
        return this.hashCode == other.hashCode;
    }

    protected static String generateStringValue(SortedSet<Rational> speeds) {
        StringBuilder sb = new StringBuilder();
        for (Rational speed : speeds) {
            if (speed == null || Rational.ONE.equals(speed)) continue;
            if (sb.length() > 0) {
                sb.append(",");
            }
            sb.append(speed);
        }
        return sb.toString();
    }

    private int calculateHashCode() {
        int prime = 31;
        int result = 1;
        if (this.speeds == null) {
            result = 31 * result;
        } else {
            for (Rational speed : this.speeds) {
                if (speed == null) continue;
                result = 31 * result + speed.hashCode();
            }
        }
        return result;
    }

    public static class DLNAOrgPlaySpeedsFactory {
        protected final ReentrantReadWriteLock instanceCacheLock = new ReentrantReadWriteLock();
        protected final HashSet<DLNAOrgPlaySpeeds> instanceCache = new HashSet();

        private DLNAOrgPlaySpeedsFactory() {
        }

        public DLNAOrgPlaySpeeds getPlaySpeeds(String values) {
            if (StringUtils.isBlank(values)) {
                return NONE;
            }
            values = values.trim();
            String[] valueArray = values.split("\\s*,\\s*");
            TreeSet<Rational> valueSet = new TreeSet<Rational>();
            for (String value : valueArray) {
                if (!StringUtils.isNotBlank(value)) continue;
                valueSet.add(Rational.valueOf(value));
            }
            return this.getPlaySpeeds(valueSet);
        }

        public DLNAOrgPlaySpeeds getPlaySpeeds(Rational ... values) {
            if (values == null || values.length == 0) {
                return NONE;
            }
            return this.getPlaySpeeds(new TreeSet<Rational>(Arrays.asList(values)));
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DLNAOrgPlaySpeeds getPlaySpeeds(SortedSet<Rational> speedSet) {
            if (speedSet == null || speedSet.isEmpty()) {
                return NONE;
            }
            String stringValue = DLNAOrgPlaySpeeds.generateStringValue(speedSet);
            this.instanceCacheLock.readLock().lock();
            try {
                for (DLNAOrgPlaySpeeds cachedAttribute : this.instanceCache) {
                    if (!stringValue.equals(cachedAttribute.getValue())) continue;
                    DLNAOrgPlaySpeeds dLNAOrgPlaySpeeds = cachedAttribute;
                    return dLNAOrgPlaySpeeds;
                }
            }
            finally {
                this.instanceCacheLock.readLock().unlock();
            }
            return null;
        }

        public DLNAOrgPlaySpeeds createPlaySpeeds(String values) {
            if (StringUtils.isBlank(values)) {
                return NONE;
            }
            values = values.trim();
            String[] valueArray = values.split("\\s*,\\s*");
            TreeSet<Rational> valueSet = new TreeSet<Rational>();
            for (String value : valueArray) {
                if (!StringUtils.isNotBlank(value)) continue;
                valueSet.add(Rational.valueOf(value));
            }
            return this.createPlaySpeeds(valueSet);
        }

        public DLNAOrgPlaySpeeds createPlaySpeeds(Rational ... values) {
            if (values == null || values.length == 0) {
                return NONE;
            }
            TreeSet<Rational> cleanedSpeedSet = new TreeSet<Rational>(Arrays.asList(values));
            if (cleanedSpeedSet.contains(Rational.ONE)) {
                cleanedSpeedSet.remove(Rational.ONE);
            }
            return this.createPlaySpeeds(cleanedSpeedSet);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public DLNAOrgPlaySpeeds createPlaySpeeds(SortedSet<Rational> speedSet) {
            SortedSet<Rational> cleanedSpeedSet;
            if (speedSet == null || speedSet.isEmpty()) {
                return NONE;
            }
            if (speedSet.contains(Rational.ONE)) {
                cleanedSpeedSet = new TreeSet<Rational>(speedSet);
                cleanedSpeedSet.remove(Rational.ONE);
            } else {
                cleanedSpeedSet = speedSet;
            }
            DLNAOrgPlaySpeeds instance = this.getPlaySpeeds(cleanedSpeedSet);
            if (instance != null) {
                return instance;
            }
            this.instanceCacheLock.writeLock().lock();
            try {
                instance = this.getPlaySpeeds(cleanedSpeedSet);
                if (instance != null) {
                    DLNAOrgPlaySpeeds dLNAOrgPlaySpeeds = instance;
                    return dLNAOrgPlaySpeeds;
                }
                instance = new DLNAOrgPlaySpeeds(cleanedSpeedSet);
                this.instanceCache.add(instance);
                DLNAOrgPlaySpeeds dLNAOrgPlaySpeeds = instance;
                return dLNAOrgPlaySpeeds;
            }
            finally {
                this.instanceCacheLock.writeLock().unlock();
            }
        }
    }
}

