/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.protocolinfo;

import java.util.ArrayList;
import net.pms.dlna.protocolinfo.ProtocolInfoAttribute;
import net.pms.dlna.protocolinfo.ProtocolInfoAttributeName;
import net.pms.media.MediaType;
import org.apache.commons.lang3.StringUtils;

public class DLNAOrgFlags
implements ProtocolInfoAttribute {
    private static final long serialVersionUID = 1L;
    protected final long high;
    protected final long low;
    public static final ProtocolInfoAttributeName NAME = ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_FLAGS;
    public static final DLNAOrgFlags IMPLIED = new DLNAOrgFlags(0L, 0L);

    public static DLNAOrgFlags getEffectiveFlags(DLNAOrgFlags flags, MediaType mediaType) {
        long high;
        long l = high = flags == null ? 0L : flags.high;
        if (flags == null || !flags.isDLNA15()) {
            high &= Long.MAX_VALUE;
            high &= 0xBFFFFFFFFFFFFFFFL;
            high &= 0xDFFFFFFFFFFFFFFFL;
            high &= 0xEFFFFFFFFFFFFFFFL;
            high &= 0xF7FFFFFFFFFFFFFFL;
            high &= 0xFBFFFFFFFFFFFFFFL;
            high &= 0xFDFFFFFFFFFFFFFFL;
            high = mediaType == MediaType.AUDIO || mediaType == MediaType.VIDEO ? (high |= 0x100000000000000L) : (high &= 0xFEFFFFFFFFFFFFFFL);
            high = mediaType == MediaType.IMAGE ? (high |= 0x80000000000000L) : (high &= 0xFF7FFFFFFFFFFFFFL);
            high &= 0xFFBFFFFFFFFFFFFFL;
            if (flags != null && flags.isCleartextByteFullDataSeek()) {
                high |= 0x1000000000000L;
            }
            high &= 0xFFFFBFFFFFFFFFFFL;
        } else if (flags.isCleartextByteFullDataSeek() || flags.isCleartextLimitedDataSeek()) {
            high |= 0x1000000000000L;
        }
        if (high == 0L && (flags == null || flags.low == 0L)) {
            return IMPLIED;
        }
        return new DLNAOrgFlags(high, flags == null ? 0L : flags.low);
    }

    public static DLNAOrgFlagsBuilder builder(boolean isDLNA15) {
        return new DLNAOrgFlagsBuilder(isDLNA15);
    }

    public DLNAOrgFlags(String hexValue) {
        if (StringUtils.isBlank(hexValue)) {
            throw new IllegalArgumentException("hexValue cannot be empty");
        }
        try {
            switch (hexValue.length()) {
                case 8: {
                    this.high = Long.parseLong(hexValue, 16) << 32;
                    this.low = 0L;
                    break;
                }
                case 32: {
                    this.high = Long.parseLong(hexValue.substring(0, 8), 16) << (int)(32L + Long.parseLong(hexValue.substring(8, 16), 16));
                    this.low = Long.parseLong(hexValue.substring(16, 24), 16) << (int)(32L + Long.parseLong(hexValue.substring(24), 16));
                    break;
                }
                default: {
                    throw new IllegalArgumentException("hexValue must be 8 or 32 digits long");
                }
            }
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("hexValue must be a valid hexadecimal number with 8 or 32 digits", e);
        }
    }

    public DLNAOrgFlags(long highValue, long lowValue) {
        this.high = highValue;
        this.low = lowValue;
    }

    public boolean isSenderPaced() {
        return (this.high >> 63 & 1L) == 1L;
    }

    public boolean isLimitedOperationsTimeBasedSeek() {
        return (this.high >> 62 & 1L) == 1L;
    }

    public boolean isLimitedOperationsByteBasedSeek() {
        return (this.high >> 61 & 1L) == 1L;
    }

    public boolean isPlayContainer() {
        return (this.high >> 60 & 1L) == 1L;
    }

    public boolean isS0Increasing() {
        return (this.high >> 59 & 1L) == 1L;
    }

    public boolean isSNIncreasing() {
        return (this.high >> 58 & 1L) == 1L;
    }

    public boolean isRtspPause() {
        return (this.high >> 57 & 1L) == 1L;
    }

    public boolean isStreamingMode() {
        return (this.high >> 56 & 1L) == 1L;
    }

    public boolean isInteractive() {
        return (this.high >> 55 & 1L) == 1L;
    }

    public boolean isBackgroundMode() {
        return (this.high >> 54 & 1L) == 1L;
    }

    public boolean isHttpConnectionStalling() {
        return (this.high >> 53 & 1L) == 1L;
    }

    public boolean isDLNA15() {
        return (this.high >> 52 & 1L) == 1L;
    }

    public boolean isLinkProtectedContent() {
        return (this.high >> 48 & 1L) == 1L;
    }

    public boolean isCleartextByteFullDataSeek() {
        return (this.high >> 47 & 1L) == 1L;
    }

    public boolean isCleartextLimitedDataSeek() {
        return (this.high >> 46 & 1L) == 1L;
    }

    public DLNAOrgFlags getEffectiveFlags(MediaType mediaType) {
        return DLNAOrgFlags.getEffectiveFlags(this, mediaType);
    }

    @Override
    public ProtocolInfoAttributeName getName() {
        return NAME;
    }

    @Override
    public String getNameString() {
        return NAME.getName();
    }

    @Override
    public String getValue() {
        DLNAOrgFlags flags = DLNAOrgFlags.getEffectiveFlags(this, MediaType.UNKNOWN);
        return String.format("%016x", flags.high) + String.format("%016x", flags.low);
    }

    @Override
    public String getAttributeString() {
        DLNAOrgFlags flags = DLNAOrgFlags.getEffectiveFlags(this, MediaType.UNKNOWN);
        if (flags.high == 0L || (flags.high & 0xFE7FFFFFFFFFFFFFL) == 0L) {
            return "";
        }
        return NAME + "=" + String.format("%016x", flags.high) + String.format("%016x", flags.low);
    }

    public int getPrimaryValue() {
        return (int)(this.high >> 32);
    }

    public long getHighValue() {
        return this.high;
    }

    public long getLowValue() {
        return this.low;
    }

    public String toString() {
        ArrayList<String> enabledFlags = new ArrayList<String>();
        if (this.isSenderPaced()) {
            enabledFlags.add("Sender Paced");
        }
        if (this.isLimitedOperationsTimeBasedSeek()) {
            enabledFlags.add("Limited Operations: Time Based Seek");
        }
        if (this.isLimitedOperationsByteBasedSeek()) {
            enabledFlags.add("Limited Operations: Byte Based Seek");
        }
        if (this.isS0Increasing()) {
            enabledFlags.add("UCDAM s0 Increasing");
        }
        if (this.isSNIncreasing()) {
            enabledFlags.add("UCDAM sN Increasing");
        }
        if (this.isRtspPause()) {
            enabledFlags.add("RTSP Pause");
        }
        if (this.isStreamingMode()) {
            enabledFlags.add("Streaming Mode");
        }
        if (this.isInteractive()) {
            enabledFlags.add("Interactive");
        }
        if (this.isBackgroundMode()) {
            enabledFlags.add("Background Mode");
        }
        if (this.isHttpConnectionStalling()) {
            enabledFlags.add("HTTP Connection Stalling");
        }
        if (this.isDLNA15()) {
            enabledFlags.add("DLNA 1.5");
        }
        if (this.isLinkProtectedContent()) {
            enabledFlags.add("Link Protected Content");
        }
        if (this.isCleartextByteFullDataSeek()) {
            enabledFlags.add("Cleartext Byte Full Data Seek");
        }
        if (this.isCleartextLimitedDataSeek()) {
            enabledFlags.add("Cleartext Limited Data Seek");
        }
        return NAME + " = " + ((Object)enabledFlags).toString();
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (int)(this.high ^ this.high >>> 32);
        result = 31 * result + (int)(this.low ^ this.low >>> 32);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DLNAOrgFlags)) {
            return false;
        }
        DLNAOrgFlags other = (DLNAOrgFlags)obj;
        if (this.high != other.high) {
            return false;
        }
        return this.low == other.low;
    }

    public static class DLNAOrgFlagsBuilder {
        protected long high;
        protected long low;

        public DLNAOrgFlagsBuilder(boolean isDLNA15) {
            this.high = (isDLNA15 ? 1L : 0L) << 52;
            this.low = 0L;
        }

        public DLNAOrgFlags build() {
            return this.high == 0L && this.low == 0L ? IMPLIED : new DLNAOrgFlags(this.high, this.low);
        }

        public DLNAOrgFlagsBuilder senderPaced() {
            this.high |= (this.high >> 52 & 1L) == 1L ? Long.MIN_VALUE : 0L;
            return this;
        }

        public DLNAOrgFlagsBuilder limitedOperationsTimeBasedSeek() {
            this.high |= (this.high >> 52 & 1L) == 1L ? 0x4000000000000000L : 0L;
            return this;
        }

        public DLNAOrgFlagsBuilder limitedOperationsByteBasedSeek() {
            this.high |= (this.high >> 52 & 1L) == 1L ? 0x2000000000000000L : 0L;
            return this;
        }

        public DLNAOrgFlagsBuilder playContainer() {
            this.high |= (this.high >> 52 & 1L) == 1L ? 0x1000000000000000L : 0L;
            return this;
        }

        public DLNAOrgFlagsBuilder s0Increasing() {
            this.high |= (this.high >> 52 & 1L) == 1L ? 0x800000000000000L : 0L;
            return this;
        }

        public DLNAOrgFlagsBuilder sNIncreasing() {
            this.high |= (this.high >> 52 & 1L) == 1L ? 0x400000000000000L : 0L;
            return this;
        }

        public DLNAOrgFlagsBuilder rtspPause() {
            this.high |= (this.high >> 52 & 1L) == 1L ? 0x200000000000000L : 0L;
            return this;
        }

        public DLNAOrgFlagsBuilder streamingMode() {
            this.high |= (this.high >> 52 & 1L) == 1L ? 0x100000000000000L : 0L;
            return this;
        }

        public DLNAOrgFlagsBuilder interactive() {
            this.high |= (this.high >> 52 & 1L) == 1L ? 0x80000000000000L : 0L;
            return this;
        }

        public DLNAOrgFlagsBuilder backgroundMode() {
            this.high |= (this.high >> 52 & 1L) == 1L ? 0x40000000000000L : 0L;
            return this;
        }

        public DLNAOrgFlagsBuilder httpConnectionStalling() {
            this.high |= 0x20000000000000L;
            return this;
        }

        public DLNAOrgFlagsBuilder linkProtectedContent() {
            this.high |= 0x1000000000000L;
            return this;
        }

        public DLNAOrgFlagsBuilder cleartextByteFullDataSeek() {
            this.high |= 0x800000000000L;
            this.high |= 0x1000000000000L;
            return this;
        }

        public DLNAOrgFlagsBuilder cleartextLimitedDataSeek() {
            this.high |= (this.high >> 52 & 1L) == 1L ? 0x400000000000L : 0L;
            if ((this.high >> 46 & 1L) == 1L) {
                this.high |= 0x1000000000000L;
            }
            return this;
        }
    }
}

