/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna.protocolinfo;

import net.pms.dlna.protocolinfo.ProtocolInfoAttribute;
import net.pms.dlna.protocolinfo.ProtocolInfoAttributeName;
import net.pms.util.ParseException;
import org.apache.commons.lang3.StringUtils;

public final class DLNAOrgConversionIndicator
implements ProtocolInfoAttribute {
    private static final long serialVersionUID = 1L;
    public static final ProtocolInfoAttributeName NAME = ProtocolInfoAttributeName.KnownProtocolInfoAttributeName.DLNA_ORG_CI;
    public static final DLNAOrgConversionIndicatorFactory FACTORY = new DLNAOrgConversionIndicatorFactory();
    public static final DLNAOrgConversionIndicator TRUE;
    public static final DLNAOrgConversionIndicator YES;
    public static final DLNAOrgConversionIndicator FALSE;
    public static final DLNAOrgConversionIndicator NO;
    protected final boolean state;

    protected DLNAOrgConversionIndicator(boolean state) {
        this.state = state;
    }

    @Override
    public ProtocolInfoAttributeName getName() {
        return NAME;
    }

    @Override
    public String getNameString() {
        return NAME.getName();
    }

    @Override
    public String getValue() {
        return this.state ? "1" : "0";
    }

    @Override
    public String getAttributeString() {
        return this.state ? NAME + "=1" : "";
    }

    static {
        YES = TRUE = new DLNAOrgConversionIndicator(true);
        NO = FALSE = new DLNAOrgConversionIndicator(false);
    }

    public static class DLNAOrgConversionIndicatorFactory {
        protected DLNAOrgConversionIndicatorFactory() {
        }

        public DLNAOrgConversionIndicator getConversionIndicator(String value) throws ParseException {
            if (StringUtils.isBlank(value)) {
                return FALSE;
            }
            switch (value = value.trim()) {
                case "0": {
                    return FALSE;
                }
                case "1": {
                    return TRUE;
                }
            }
            throw new ParseException("Cannot parse DLNA conversion indicator value \"" + value + "\"");
        }

        public DLNAOrgConversionIndicator getConversionIndicator(boolean ci) {
            return ci ? TRUE : FALSE;
        }
    }
}

