/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.awt.color.ColorSpace;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.pms.dlna.DLNAImageProfile;
import net.pms.dlna.DLNAProfileException;
import net.pms.dlna.DLNAThumbnail;
import net.pms.image.BufferedImageFilterChain;
import net.pms.image.ColorSpaceType;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.image.ImagesUtil;

public class DLNAThumbnailInputStream
extends ByteArrayInputStream {
    protected final ImageInfo imageInfo;
    protected final DLNAImageProfile profile;

    public static DLNAThumbnailInputStream toThumbnailInputStream(byte[] inputByteArray) throws IOException {
        DLNAThumbnail thumbnail = DLNAThumbnail.toThumbnail(inputByteArray);
        return thumbnail != null ? new DLNAThumbnailInputStream(thumbnail) : null;
    }

    public static DLNAThumbnailInputStream toThumbnailInputStream(InputStream inputStream) throws IOException {
        DLNAThumbnail thumbnail = DLNAThumbnail.toThumbnail(inputStream);
        return thumbnail != null ? new DLNAThumbnailInputStream(thumbnail) : null;
    }

    public static DLNAThumbnailInputStream toThumbnailInputStream(byte[] inputByteArray, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        DLNAThumbnail thumbnail = DLNAThumbnail.toThumbnail(inputByteArray, width, height, scaleType, outputFormat, padToSize);
        return thumbnail != null ? new DLNAThumbnailInputStream(thumbnail) : null;
    }

    public static DLNAThumbnailInputStream toThumbnailInputStream(InputStream inputStream, int width, int height, ImagesUtil.ScaleType scaleType, ImageFormat outputFormat, boolean padToSize) throws IOException {
        DLNAThumbnail thumbnail = DLNAThumbnail.toThumbnail(inputStream, width, height, scaleType, outputFormat, padToSize);
        return thumbnail != null ? new DLNAThumbnailInputStream(thumbnail) : null;
    }

    public static DLNAThumbnailInputStream toThumbnailInputStream(DLNAThumbnail thumbnail) {
        return thumbnail != null ? new DLNAThumbnailInputStream(thumbnail) : null;
    }

    public DLNAThumbnailInputStream(DLNAThumbnail thumbnail) {
        super(thumbnail.getBytes(false));
        this.imageInfo = thumbnail.getImageInfo();
        this.profile = thumbnail.getDLNAImageProfile();
    }

    public DLNAThumbnailInputStream transcode(DLNAImageProfile outputProfile, boolean padToSize, BufferedImageFilterChain filterChain) throws IOException {
        DLNAThumbnail thumbnail = (DLNAThumbnail)ImagesUtil.transcodeImage(this.getBytes(false), outputProfile, true, padToSize, filterChain);
        return thumbnail != null ? new DLNAThumbnailInputStream(thumbnail) : null;
    }

    @SuppressFBWarnings(value={"EI_EXPOSE_REP"})
    public byte[] getBytes(boolean copy) {
        if (copy) {
            byte[] result = new byte[this.buf.length];
            System.arraycopy(this.buf, 0, result, 0, this.buf.length);
            return result;
        }
        return this.buf;
    }

    public DLNAThumbnail getThumbnail() throws DLNAProfileException {
        return new DLNAThumbnail(this.buf, this.imageInfo, this.profile, false);
    }

    public ImageInfo getImageInfo() {
        return this.imageInfo;
    }

    public int getWidth() {
        return this.imageInfo != null ? this.imageInfo.getWidth() : -1;
    }

    public int getHeight() {
        return this.imageInfo != null ? this.imageInfo.getHeight() : -1;
    }

    public ImageFormat getFormat() {
        return this.imageInfo != null ? this.imageInfo.getFormat() : null;
    }

    public long getSize() {
        return this.buf != null ? (long)this.buf.length : 0L;
    }

    public ColorSpace getColorSpace() {
        return this.imageInfo != null ? this.imageInfo.getColorSpace() : null;
    }

    public ColorSpaceType getColorSpaceType() {
        return this.imageInfo != null ? this.imageInfo.getColorSpaceType() : null;
    }

    public int getBitPerPixel() {
        return this.imageInfo != null ? this.imageInfo.getBitsPerPixel() : -1;
    }

    public int getNumComponents() {
        return this.imageInfo != null ? this.imageInfo.getNumComponents() : -1;
    }

    public int getBitDepth() {
        return this.imageInfo != null ? this.imageInfo.getBitDepth() : -1;
    }

    public boolean isImageIOSupported() {
        return this.imageInfo != null && this.imageInfo.isImageIOSupported();
    }

    public DLNAImageProfile getDLNAImageProfile() {
        return this.profile;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(90);
        sb.append("DLNAThumbnailInputStream: Format = ").append((Object)this.imageInfo.getFormat()).append(", Width = ").append(this.imageInfo.getWidth()).append(", Height = ").append(this.imageInfo.getHeight()).append(", Size = ").append(this.buf != null ? this.buf.length : 0);
        return sb.toString();
    }

    public synchronized void fullReset() {
        this.pos = 0;
        this.mark = 0;
    }
}

