/*
 * Decompiled with CFR 0.152.
 */
package net.pms.dlna;

import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import net.pms.dlna.DLNAImageProfile;
import net.pms.image.ImageFormat;
import net.pms.image.ImageInfo;
import net.pms.renderers.Renderer;

public class DLNAImageResElement {
    private final DLNAImageProfile profile;
    private final Integer ciFlag;
    private final boolean thumbnail;
    private final DLNAImageProfile.HypotheticalResult hypotheticalResult;

    public DLNAImageResElement(DLNAImageProfile profile, ImageInfo imageInfo, boolean thumbnail) {
        this(profile, imageInfo, thumbnail, null);
    }

    public DLNAImageResElement(DLNAImageProfile profile, ImageInfo imageInfo, boolean thumbnail, Integer overrideCIFlag) {
        this.profile = profile;
        if (profile != null && imageInfo != null) {
            this.hypotheticalResult = profile.calculateHypotheticalProperties(imageInfo);
            this.ciFlag = overrideCIFlag == null ? (this.hypotheticalResult.conversionNeeded ? 1 : 0) : overrideCIFlag;
        } else {
            this.hypotheticalResult = null;
            this.ciFlag = overrideCIFlag;
        }
        this.thumbnail = thumbnail;
    }

    public DLNAImageProfile getProfile() {
        return this.profile;
    }

    public Integer getCiFlag() {
        return this.ciFlag;
    }

    public boolean isThumbnail() {
        return this.thumbnail;
    }

    public boolean isResolutionKnown() {
        return this.hypotheticalResult != null && this.hypotheticalResult.width > 0 && this.hypotheticalResult.height > 0;
    }

    public int getWidth() {
        return this.hypotheticalResult != null ? this.hypotheticalResult.width : Integer.MIN_VALUE;
    }

    public int getHeight() {
        return this.hypotheticalResult != null ? this.hypotheticalResult.height : Integer.MIN_VALUE;
    }

    public Long getSize() {
        return this.hypotheticalResult != null ? this.hypotheticalResult.size : null;
    }

    private DLNAImageProfile.HypotheticalResult getHypotheticalResult() {
        return this.hypotheticalResult;
    }

    public String toString() {
        return "DLNAImageResElement [profile=" + this.profile + ", ciFlag=" + this.ciFlag + ", thumbnail=" + this.thumbnail + ", hypotheticalResult=" + this.hypotheticalResult + "]";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.ciFlag == null ? 0 : this.ciFlag.hashCode());
        result = 31 * result + (this.hypotheticalResult == null ? 0 : this.hypotheticalResult.hashCode());
        result = 31 * result + (this.profile == null ? 0 : this.profile.hashCode());
        result = 31 * result + (this.thumbnail ? 1231 : 1237);
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DLNAImageResElement)) {
            return false;
        }
        DLNAImageResElement other = (DLNAImageResElement)obj;
        if (this.ciFlag == null ? other.ciFlag != null : !this.ciFlag.equals(other.ciFlag)) {
            return false;
        }
        if (this.hypotheticalResult == null ? other.hypotheticalResult != null : !this.hypotheticalResult.equals(other.hypotheticalResult)) {
            return false;
        }
        if (this.profile == null ? other.profile != null : !this.profile.equals(other.profile)) {
            return false;
        }
        return this.thumbnail == other.thumbnail;
    }

    public static Comparator<DLNAImageResElement> getComparator(ImageFormat sourceFormat) {
        ImageFormat preferredFormat;
        if (sourceFormat != null) {
            switch (sourceFormat) {
                case GIF: {
                    preferredFormat = ImageFormat.GIF;
                    break;
                }
                case CUR: 
                case ICNS: 
                case ICO: 
                case PNG: 
                case PSD: 
                case TIFF: 
                case WEBP: {
                    preferredFormat = ImageFormat.PNG;
                    break;
                }
                default: {
                    preferredFormat = ImageFormat.JPEG;
                    break;
                }
            }
        } else {
            preferredFormat = ImageFormat.JPEG;
        }
        return (o1, o2) -> {
            long l;
            ImageFormat o2Format;
            if (o1 == null && o2 == null) {
                return 0;
            }
            if (o1 == null) {
                return 1;
            }
            if (o2 == null) {
                return -1;
            }
            if (o1.isThumbnail() != o2.isThumbnail()) {
                return (o1.isThumbnail() ? 1 : 0) - (o2.isThumbnail() ? 1 : 0);
            }
            int i = Optional.ofNullable(o1.getCiFlag()).orElse(2) - Optional.ofNullable(o2.getCiFlag()).orElse(2);
            if (i != 0) {
                return i;
            }
            ImageFormat o1Format = o1.getProfile() != null ? o1.getProfile().getFormat() : null;
            ImageFormat imageFormat = o2Format = o2.getProfile() != null ? o2.getProfile().getFormat() : null;
            if (o1Format != o2Format) {
                if (o1Format == null) {
                    return 1;
                }
                if (o2Format == null) {
                    return -1;
                }
                if (o1Format == preferredFormat) {
                    return -1;
                }
                if (o2Format == preferredFormat) {
                    return 1;
                }
                return o1Format.compareTo(o2Format);
            }
            if (!(!DLNAImageProfile.JPEG_RES_H_V.equals(o1.getProfile()) && !DLNAImageProfile.JPEG_RES_H_V.equals(o2.getProfile()) || DLNAImageProfile.JPEG_RES_H_V.equals(o1.getProfile()) && DLNAImageProfile.JPEG_RES_H_V.equals(o2.getProfile()))) {
                if (DLNAImageProfile.JPEG_RES_H_V.equals(o1.getProfile())) {
                    return -1;
                }
                return 1;
            }
            if (o1.getWidth() != o2.getWidth()) {
                return o2.getWidth() - o1.getWidth();
            }
            if (o1.getHeight() != o2.getHeight()) {
                return o2.getHeight() - o1.getHeight();
            }
            if (o1.getProfile() != null || o2.getProfile() != null) {
                if (o1.getProfile() == null) {
                    return 1;
                }
                if (o2.getProfile() == null) {
                    return -1;
                }
                if (!o1.getProfile().equals(o2.getProfile())) {
                    return o1.getProfile().toInt() - o2.getProfile().toInt();
                }
            }
            if ((l = Optional.ofNullable(o2.getSize()).orElse(0L) - Optional.ofNullable(o1.getSize()).orElse(0L)) != 0L) {
                return (int)l;
            }
            if (o1.getHypotheticalResult() != null || o2.getHypotheticalResult() != null) {
                if (o1.getHypotheticalResult() == null) {
                    return 1;
                }
                if (o2.getHypotheticalResult() == null) {
                    return -1;
                }
                if (o1.getHypotheticalResult().conversionNeeded != o2.getHypotheticalResult().conversionNeeded) {
                    return (o1.getHypotheticalResult().conversionNeeded ? 1 : 0) - (o2.getHypotheticalResult().conversionNeeded ? 1 : 0);
                }
            }
            return 0;
        };
    }

    public static void filterResElements(List<DLNAImageResElement> resElements, Renderer renderer) {
        if (renderer == null || renderer.deviceProtocolInfo == null || renderer.deviceProtocolInfo.isImageProfilesEmpty()) {
            return;
        }
        Iterator<DLNAImageResElement> iterator = resElements.iterator();
        while (iterator.hasNext()) {
            DLNAImageResElement resElement = iterator.next();
            if (renderer.deviceProtocolInfo.imageProfilesContains(resElement.getProfile())) continue;
            iterator.remove();
        }
    }

    public static boolean isImageProfileSupported(DLNAImageProfile profile, Renderer renderer) {
        return renderer == null || renderer.deviceProtocolInfo == null || renderer.deviceProtocolInfo.isImageProfilesEmpty() || renderer.deviceProtocolInfo.imageProfilesContains(profile);
    }
}

