/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTableFilesStatus;
import net.pms.database.UserTable;
import net.pms.database.UserTableTablesVersions;
import net.pms.iam.User;
import net.pms.image.Image;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserTableUsers
extends UserTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTableUsers.class);
    public static final String TABLE_NAME = "USERS";
    private static final int TABLE_VERSION = 6;
    private static final String COL_ID = "ID";
    private static final String COL_USERNAME = "USERNAME";
    private static final String COL_PASSWORD = "PASSWORD";
    private static final String COL_DISPLAY_NAME = "DISPLAY_NAME";
    private static final String COL_GROUP_ID = "GROUP_ID";
    private static final String COL_AVATAR = "AVATAR";
    private static final String COL_PINCODE = "PINCODE";
    private static final String COL_LAST_LOGIN_TIME = "LAST_LOGIN_TIME";
    private static final String COL_LOGIN_FAIL_TIME = "LOGIN_FAIL_TIME";
    private static final String COL_LOGIN_FAIL_COUNT = "LOGIN_FAIL_COUNT";
    private static final String COL_LIBRARY_HIDDEN = "LIBRARY_HIDDEN";
    private static final String TABLE_COL_ID = "USERS.ID";
    private static final String TABLE_COL_USERNAME = "USERS.USERNAME";
    private static final String TABLE_COL_GROUP_ID = "USERS.GROUP_ID";
    private static final String SQL_GET_ALL = "SELECT * FROM USERS";
    private static final String SQL_GET_BY_ID = "SELECT * FROM USERS WHERE USERS.ID = ? LIMIT 1";
    private static final String SQL_GET_BY_USERNAME = "SELECT * FROM USERS WHERE USERS.USERNAME = ? LIMIT 1";
    private static final String SQL_GET_ADMIN = "SELECT ID FROM USERS WHERE USERS.GROUP_ID = 1 LIMIT 1";
    private static final String SQL_INSERT_USER = "INSERT INTO USERS (USERNAME, PASSWORD, DISPLAY_NAME, GROUP_ID) VALUES(?, ?, ?, ?)";
    private static final String SQL_UPDATE_LOGIN = "UPDATE USERS SET USERNAME = ?, PASSWORD = ? WHERE USERS.ID = ?";
    private static final String SQL_UPDATE_LOGIN_TIME = "UPDATE USERS SET LAST_LOGIN_TIME = ?, LOGIN_FAIL_TIME = '0', LOGIN_FAIL_COUNT = '0' WHERE USERS.ID = ?";
    private static final String SQL_UPDATE_LOGIN_FAIL = "UPDATE USERS SET LOGIN_FAIL_TIME = ?, LOGIN_FAIL_COUNT = LOGIN_FAIL_COUNT+1 WHERE USERS.ID = ?";
    private static final String SQL_RESET_FAIL_COUNT = "UPDATE USERS SET LOGIN_FAIL_COUNT = '0' WHERE USERS.ID = ?";
    private static final String SQL_DELETE_ID = "DELETE FROM USERS WHERE USERS.ID = ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (UserTableUsers.tableExists(connection, TABLE_NAME)) {
            Integer version = UserTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 6) {
                    UserTableUsers.upgradeTable(connection, version);
                } else if (version > 6) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", TABLE_NAME, TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)TABLE_NAME, (Object)TABLE_NAME);
                UserTableUsers.dropTable(connection, TABLE_NAME);
                UserTableUsers.createTable(connection);
                UserTableTablesVersions.setTableVersion(connection, TABLE_NAME, 6);
            }
        } else {
            UserTableUsers.createTable(connection);
            UserTableTablesVersions.setTableVersion(connection, TABLE_NAME, 6);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", TABLE_NAME, TABLE_NAME, currentVersion, 6);
        for (int version = currentVersion; version < 6; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", TABLE_NAME, TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    UserTableUsers.executeUpdate(connection, "ALTER TABLE USERS ADD IF NOT EXISTS DISPLAY_NAME VARCHAR(255)");
                    UserTableUsers.executeUpdate(connection, "ALTER TABLE USERS ADD IF NOT EXISTS GROUP_ID INTEGER DEFAULT 0");
                    UserTableUsers.executeUpdate(connection, "ALTER TABLE USERS ADD IF NOT EXISTS LAST_LOGIN_TIME BIGINT DEFAULT 0");
                    UserTableUsers.executeUpdate(connection, "ALTER TABLE USERS ADD IF NOT EXISTS LOGIN_FAIL_TIME BIGINT DEFAULT 0");
                    UserTableUsers.executeUpdate(connection, "ALTER TABLE USERS ADD IF NOT EXISTS LOGIN_FAIL_COUNT INTEGER DEFAULT 0");
                    UserTableUsers.executeUpdate(connection, "UPDATE USERS SET DISPLAY_NAME = 'admin' WHERE ID = 0");
                    UserTableUsers.executeUpdate(connection, "UPDATE USERS SET GROUP_ID = 1 WHERE ID = 1");
                    break;
                }
                case 2: {
                    UserTableUsers.executeUpdate(connection, "ALTER TABLE USERS ALTER COLUMN IF EXISTS GROUP_ID SET  DEFAULT 0");
                    UserTableUsers.executeUpdate(connection, "UPDATE USERS SET GROUP_ID = 1 WHERE ID = 1");
                    break;
                }
                case 3: {
                    UserTableUsers.executeUpdate(connection, "ALTER TABLE USERS ALTER COLUMN IF EXISTS NAME RENAME TO DISPLAY_NAME");
                    UserTableUsers.executeUpdate(connection, "UPDATE USERS SET DISPLAY_NAME = 'admin' WHERE ID = 1");
                    break;
                }
                case 4: {
                    UserTableUsers.executeUpdate(connection, "ALTER TABLE USERS ADD IF NOT EXISTS AVATAR BLOB");
                    UserTableUsers.executeUpdate(connection, "ALTER TABLE USERS ADD IF NOT EXISTS PINCODE VARCHAR");
                    break;
                }
                case 5: {
                    UserTableUsers.executeUpdate(connection, "ALTER TABLE USERS ADD IF NOT EXISTS LIBRARY_HIDDEN BOOLEAN");
                    List<User> users = UserTableUsers.getAllUsers(connection);
                    if (users.isEmpty()) break;
                    Connection mConnection = MediaDatabase.getConnectionIfAvailable();
                    if (mConnection != null) {
                        for (User user : users) {
                            MediaTableFilesStatus.copyUserEntries(mConnection, 0, user.getId());
                        }
                    }
                    MediaDatabase.close(mConnection);
                    break;
                }
                default: {
                    throw new IllegalStateException(UserTableUsers.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", TABLE_NAME, TABLE_NAME, version, 6));
                }
            }
            LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", TABLE_NAME, TABLE_NAME, currentVersion, version);
        }
        UserTableTablesVersions.setTableVersion(connection, TABLE_NAME, 6);
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)TABLE_NAME, (Object)TABLE_NAME);
        UserTableUsers.execute(connection, "CREATE TABLE USERS(ID INTEGER PRIMARY KEY AUTO_INCREMENT, USERNAME VARCHAR(255)UNIQUE , PASSWORD VARCHAR(255) NOT NULL, DISPLAY_NAME VARCHAR(255), GROUP_ID INTEGER DEFAULT 0, AVATAR BLOB, PINCODE VARCHAR, LAST_LOGIN_TIME BIGINT DEFAULT 0, LOGIN_FAIL_TIME BIGINT DEFAULT 0, LOGIN_FAIL_COUNT INTEGER DEFAULT 0, LIBRARY_HIDDEN BOOLEAN)");
    }

    public static void addUser(Connection connection, String username, String password, String displayName, int groupId) {
        if (connection == null || username == null || "".equals(username) || password == null || "".equals(password)) {
            return;
        }
        LOGGER.info("Creating user: {}", (Object)username);
        try (PreparedStatement insertStatement = connection.prepareStatement(SQL_INSERT_USER, 1);){
            insertStatement.clearParameters();
            insertStatement.setString(1, StringUtils.left(username, 255));
            insertStatement.setString(2, StringUtils.left(password, 255));
            insertStatement.setString(3, StringUtils.left(displayName, 255));
            insertStatement.setInt(4, groupId);
            insertStatement.executeUpdate();
            try (ResultSet rs = insertStatement.getGeneratedKeys();){
                if (rs.next()) {
                    LOGGER.info("Created user successfully in USERS");
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("ERROR createUser" + e);
        }
    }

    public static void deleteUser(Connection connection, int id) {
        if (connection == null || id < 1) {
            return;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_DELETE_ID);){
            statement.setInt(1, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error("Error deleteUser:{}", (Object)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean updateUser(Connection connection, int id, String displayName, int groupId, Image avatar, String pinCode, boolean libraryHidden) {
        if (connection == null) return false;
        if (displayName == null) {
            return false;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_BY_ID, 1003, 1008);){
            statement.setInt(1, id);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.first()) return false;
                resultSet.updateString(COL_DISPLAY_NAME, StringUtils.left(displayName, 255));
                resultSet.updateInt(COL_GROUP_ID, groupId);
                UserTableUsers.updateBytes(resultSet, COL_AVATAR, avatar != null ? avatar.getBytes(true) : null);
                UserTableUsers.updateString(resultSet, COL_PINCODE, pinCode, 4);
                resultSet.updateBoolean(COL_LIBRARY_HIDDEN, libraryHidden);
                resultSet.updateRow();
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error updating user: " + e);
        }
        return false;
    }

    public static boolean updateLogin(Connection connection, int id, String username, String password) {
        boolean bl;
        block9: {
            if (connection == null || username == null || "".equals(username) || password == null || "".equals(password)) {
                return false;
            }
            PreparedStatement statement = connection.prepareStatement(SQL_UPDATE_LOGIN);
            try {
                statement.setString(1, StringUtils.left(username, 255));
                statement.setString(2, StringUtils.left(password, 255));
                statement.setInt(3, id);
                statement.executeUpdate();
                bl = true;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error("Error updateLogin:{}", (Object)e.getMessage());
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    public static void resetLoginFailCount(Connection connection, int id) {
        if (connection == null) {
            return;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_RESET_FAIL_COUNT);){
            statement.setInt(1, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error("Error resetLoginFailCount:{}", (Object)e.getMessage());
        }
    }

    public static void setLoginTime(Connection connection, int id, long time) {
        if (connection == null) {
            return;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_UPDATE_LOGIN_TIME);){
            statement.setLong(1, time);
            statement.setInt(2, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error("Error setLoginTime:{}", (Object)e.getMessage());
        }
    }

    public static void setLoginFailed(Connection connection, int id, long time) {
        if (connection == null) {
            return;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_UPDATE_LOGIN_FAIL);){
            statement.setLong(1, time);
            statement.setInt(2, id);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error("Error setLoginFailed:{}", (Object)e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static User getUserByUsername(Connection connection, String username) {
        LOGGER.info("Finding user: {} ", (Object)username);
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_BY_USERNAME);){
            statement.setString(1, StringUtils.left(username, 255));
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                User user = UserTableUsers.resultSetToUser(resultSet);
                return user;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error finding user: " + e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static User getUserByUserId(Connection connection, int id) {
        LOGGER.info("Finding user id: {} ", (Object)id);
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_BY_ID);){
            statement.setInt(1, id);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                User user = UserTableUsers.resultSetToUser(resultSet);
                return user;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error finding user: " + e);
        }
        return null;
    }

    public static List<User> getAllUsers(Connection connection) {
        ArrayList<User> result = new ArrayList<User>();
        LOGGER.info("Listing all users");
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(SQL_GET_ALL);){
            while (resultSet.next()) {
                result.add(UserTableUsers.resultSetToUser(resultSet));
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error finding user: " + e);
        }
        return result;
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean hasNoAdmin(Connection connection) {
        try (Statement statement = connection.createStatement();){
            boolean bl;
            block14: {
                ResultSet resultSet = statement.executeQuery(SQL_GET_ADMIN);
                try {
                    boolean bl2 = bl = !resultSet.next();
                    if (resultSet == null) break block14;
                }
                catch (Throwable throwable) {
                    if (resultSet != null) {
                        try {
                            resultSet.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                resultSet.close();
            }
            return bl;
        }
        catch (SQLException e) {
            LOGGER.error("Error finding admin: " + e);
            return true;
        }
    }

    private static User resultSetToUser(ResultSet resultSet) throws SQLException {
        User result = new User();
        result.setId(resultSet.getInt(COL_ID));
        result.setUsername(resultSet.getString(COL_USERNAME));
        result.setPassword(resultSet.getString(COL_PASSWORD));
        result.setDisplayName(resultSet.getString(COL_DISPLAY_NAME));
        result.setGroupId(resultSet.getInt(COL_GROUP_ID));
        byte[] imageBytes = resultSet.getBytes(COL_AVATAR);
        if (imageBytes != null) {
            result.setAvatar(new Image(imageBytes, null, false));
        }
        result.setPinCode(resultSet.getString(COL_PINCODE));
        result.setLastLoginTime(resultSet.getLong(COL_LAST_LOGIN_TIME));
        result.setLoginFailedTime(resultSet.getLong(COL_LOGIN_FAIL_TIME));
        result.setLoginFailedCount(resultSet.getInt(COL_LOGIN_FAIL_COUNT));
        result.setLibraryHidden(resultSet.getBoolean(COL_LIBRARY_HIDDEN));
        return result;
    }
}

