/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import net.pms.database.UserTable;
import net.pms.database.UserTableTablesVersions;
import net.pms.iam.Group;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class UserTableGroups
extends UserTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserTableGroups.class);
    public static final String TABLE_NAME = "GROUPS";
    private static final int TABLE_VERSION = 3;
    private static final String COL_ID = "ID";
    private static final String COL_DISPLAY_NAME = "DISPLAY_NAME";
    private static final String COL_PERMISSIONS = "PERMISSIONS";
    private static final String TABLE_COL_ID = "GROUPS.ID";
    private static final String SQL_GET_ALL = "SELECT * FROM GROUPS";
    private static final String SQL_GET_BY_ID = "SELECT * FROM GROUPS WHERE GROUPS.ID = ? LIMIT 1";
    private static final String SQL_DELETE_ID = "DELETE FROM GROUPS WHERE GROUPS.ID = ?";
    private static final String SQL_INSERT_GROUP = "INSERT INTO GROUPS (DISPLAY_NAME, PERMISSIONS) VALUES (?, ?)";
    private static final String SQL_UPDATE_DISPLAY_NAME_BY_ID = "UPDATE GROUPS SET DISPLAY_NAME = ? WHERE GROUPS.ID = ?";
    private static final String SQL_UPDATE_PERMISSIONS_BY_ID = "UPDATE GROUPS SET PERMISSIONS = ? WHERE GROUPS.ID = ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (UserTableGroups.tableExists(connection, TABLE_NAME)) {
            Integer version = UserTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 3) {
                    UserTableGroups.upgradeTable(connection, version);
                } else if (version > 3) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "USERS", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"USERS", (Object)TABLE_NAME);
                UserTableGroups.dropTable(connection, TABLE_NAME);
                UserTableGroups.createTable(connection);
                UserTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
            }
        } else {
            UserTableGroups.createTable(connection);
            UserTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "USERS", TABLE_NAME, currentVersion, 3);
        block4: for (int version = currentVersion; version < 3; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "USERS", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    UserTableGroups.executeUpdate(connection, "ALTER TABLE GROUPS ALTER COLUMN IF EXISTS NAME RENAME TO DISPLAY_NAME");
                    LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", "USERS", TABLE_NAME, currentVersion, version);
                    continue block4;
                }
                case 2: {
                    UserTableGroups.dropTableAndConstraint(connection, COL_PERMISSIONS);
                    UserTableTablesVersions.removeTableVersion(connection, COL_PERMISSIONS);
                    UserTableGroups.executeUpdate(connection, "ALTER TABLE GROUPS ADD IF NOT EXISTS PERMISSIONS INTEGER DEFAULT 0");
                    UserTableGroups.executeUpdate(connection, "UPDATE GROUPS SET PERMISSIONS = -1 WHERE ID = 1");
                    LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", "USERS", TABLE_NAME, currentVersion, version);
                    continue block4;
                }
                default: {
                    throw new IllegalStateException(UserTableGroups.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "USERS", TABLE_NAME, version, 3));
                }
            }
        }
        UserTableTablesVersions.setTableVersion(connection, TABLE_NAME, 3);
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"USERS", (Object)TABLE_NAME);
        UserTableGroups.execute(connection, "CREATE TABLE GROUPS(ID INTEGER PRIMARY KEY AUTO_INCREMENT, DISPLAY_NAME VARCHAR(255)UNIQUE , PERMISSIONS INTEGER DEFAULT 0)");
        UserTableGroups.addGroup(connection, "admin", -1);
    }

    public static void addGroup(Connection connection, String displayName, int permissions) {
        if (connection == null || displayName == null || "".equals(displayName)) {
            return;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_INSERT_GROUP);){
            statement.setString(1, StringUtils.left(displayName, 255));
            statement.setInt(2, permissions);
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "USERS", "inserting value", displayName, TABLE_NAME, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static boolean updateGroupName(Connection connection, int id, String name) {
        boolean bl;
        block9: {
            if (connection == null || id < 1 || name == null || "".equals(name)) {
                return false;
            }
            PreparedStatement statement = connection.prepareStatement(SQL_UPDATE_DISPLAY_NAME_BY_ID);
            try {
                statement.setString(1, StringUtils.left(name, 255));
                statement.setInt(2, id);
                statement.executeUpdate();
                bl = true;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "USERS", "updating name", name, TABLE_NAME, e.getMessage());
                    LOGGER.trace("", e);
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    public static boolean updateGroupPermissions(Connection connection, int id, int permissions) {
        boolean bl;
        block9: {
            if (connection == null || id < 1) {
                return false;
            }
            PreparedStatement statement = connection.prepareStatement(SQL_UPDATE_PERMISSIONS_BY_ID);
            try {
                statement.setInt(1, permissions);
                statement.setInt(2, id);
                statement.executeUpdate();
                bl = true;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "USERS", "updating permissions", permissions, TABLE_NAME, e.getMessage());
                    LOGGER.trace("", e);
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    public static boolean removeGroup(Connection connection, int id) {
        boolean bl;
        block9: {
            if (connection == null || id < 2) {
                return false;
            }
            PreparedStatement statement = connection.prepareStatement(SQL_DELETE_ID);
            try {
                statement.setInt(1, id);
                statement.executeUpdate();
                bl = true;
                if (statement == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (statement != null) {
                        try {
                            statement.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (SQLException e) {
                    LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "USERS", "deleting value", id, TABLE_NAME, e.getMessage());
                    LOGGER.trace("", e);
                    return false;
                }
            }
            statement.close();
        }
        return bl;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Group getGroupById(Connection connection, int id) {
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_BY_ID);){
            statement.setInt(1, id);
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    Group group = UserTableGroups.resultSetToGroup(resultSet);
                    return group;
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error finding group: " + e);
        }
        Group result = new Group();
        result.setId(0);
        result.setDisplayName("");
        result.setPermissions(0);
        return result;
    }

    public static List<Group> getAllGroups(Connection connection) {
        ArrayList<Group> result = new ArrayList<Group>();
        try (Statement statement = connection.createStatement();
             ResultSet resultSet = statement.executeQuery(SQL_GET_ALL);){
            while (resultSet.next()) {
                result.add(UserTableGroups.resultSetToGroup(resultSet));
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error listing groups: " + e);
        }
        return result;
    }

    private static Group resultSetToGroup(ResultSet resultSet) throws SQLException {
        Group group = new Group();
        group.setId(resultSet.getInt(COL_ID));
        group.setDisplayName(resultSet.getString(COL_DISPLAY_NAME));
        group.setPermissions(resultSet.getInt(COL_PERMISSIONS));
        return group;
    }
}

