/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableFiles;
import net.pms.database.MediaTableTablesVersions;
import net.pms.database.MediaTableVideoMetadataActors;
import net.pms.database.MediaTableVideoMetadataAwards;
import net.pms.database.MediaTableVideoMetadataCountries;
import net.pms.database.MediaTableVideoMetadataDirectors;
import net.pms.database.MediaTableVideoMetadataGenres;
import net.pms.database.MediaTableVideoMetadataLocalized;
import net.pms.database.MediaTableVideoMetadataRatings;
import net.pms.external.umsapi.APIUtils;
import net.pms.media.MediaInfo;
import net.pms.media.video.metadata.MediaVideoMetadata;
import net.pms.media.video.metadata.VideoMetadataLocalized;
import net.pms.store.MediaInfoStore;
import net.pms.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTableVideoMetadata
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableVideoMetadata.class);
    private static final Gson GSON = new Gson();
    public static final String TABLE_NAME = "VIDEO_METADATA";
    private static final int TABLE_VERSION = 8;
    private static final String COL_API_VERSION = "API_VERSION";
    private static final String COL_EXTRAINFORMATION = "EXTRAINFORMATION";
    protected static final String COL_FILEID = "FILEID";
    private static final String COL_IMDBID = "IMDBID";
    private static final String COL_TMDBID = "TMDBID";
    private static final String COL_TMDBTVID = "TMDBTVID";
    private static final String COL_ISTVEPISODE = "ISTVEPISODE";
    private static final String COL_MEDIA_YEAR = "MEDIA_YEAR";
    private static final String COL_MODIFIED = "MODIFIED";
    private static final String COL_TITLE = "TITLE";
    private static final String COL_TVSERIESID = "TVSERIESID";
    private static final String COL_TVSEASON = "TVSEASON";
    private static final String COL_TVEPISODENUMBER = "TVEPISODENUMBER";
    private static final String BASIC_COLUMNS = "IMDBID, MEDIA_YEAR, TITLE, TVSERIESID, EXTRAINFORMATION, ISTVEPISODE, TVSEASON, TVEPISODENUMBER";
    private static final String COL_BUDGET = "BUDGET";
    private static final String COL_CREDITS = "CREDITS";
    private static final String COL_EXTERNALIDS = "EXTERNALIDS";
    private static final String COL_HOMEPAGE = "HOMEPAGE";
    private static final String COL_IMAGES = "IMAGES";
    private static final String COL_ORIGINALLANGUAGE = "ORIGINALLANGUAGE";
    private static final String COL_ORIGINALTITLE = "ORIGINALTITLE";
    private static final String COL_OVERVIEW = "OVERVIEW";
    private static final String COL_POSTER = "POSTER";
    private static final String COL_PRODUCTIONCOMPANIES = "PRODUCTIONCOMPANIES";
    private static final String COL_PRODUCTIONCOUNTRIES = "PRODUCTIONCOUNTRIES";
    public static final String COL_RATED = "RATED";
    private static final String COL_RATING = "RATING";
    private static final String COL_RELEASEDATE = "RELEASEDATE";
    private static final String COL_REVENUE = "REVENUE";
    private static final String COL_TAGLINE = "TAGLINE";
    private static final String COL_VOTES = "VOTES";
    private static final String TABLE_COL_API_VERSION = "VIDEO_METADATA.API_VERSION";
    public static final String TABLE_COL_EXTRAINFORMATION = "VIDEO_METADATA.EXTRAINFORMATION";
    public static final String TABLE_COL_FILEID = "VIDEO_METADATA.FILEID";
    public static final String TABLE_COL_IMDBID = "VIDEO_METADATA.IMDBID";
    public static final String TABLE_COL_TMDBID = "VIDEO_METADATA.TMDBID";
    public static final String TABLE_COL_ISTVEPISODE = "VIDEO_METADATA.ISTVEPISODE";
    public static final String TABLE_COL_MEDIA_YEAR = "VIDEO_METADATA.MEDIA_YEAR";
    private static final String TABLE_COL_POSTER = "VIDEO_METADATA.POSTER";
    public static final String TABLE_COL_RATED = "VIDEO_METADATA.RATED";
    public static final String TABLE_COL_RATING = "VIDEO_METADATA.RATING";
    public static final String TABLE_COL_RELEASEDATE = "VIDEO_METADATA.RELEASEDATE";
    public static final String TABLE_COL_TITLE = "VIDEO_METADATA.TITLE";
    public static final String TABLE_COL_TVSERIESID = "VIDEO_METADATA.TVSERIESID";
    public static final String TABLE_COL_TVEPISODENUMBER = "VIDEO_METADATA.TVEPISODENUMBER";
    public static final String TABLE_COL_TVSEASON = "VIDEO_METADATA.TVSEASON";
    public static final String TABLE_COL_FIRST_TVEPISODE = "CAST(REGEXP_SUBSTR(CONCAT('0', VIDEO_METADATA.TVEPISODENUMBER), '\\d*') AS INTEGER)";
    public static final String SQL_LEFT_JOIN_TABLE_TV_SERIES = " LEFT JOIN TV_SERIES ON VIDEO_METADATA.TVSERIESID = TV_SERIES.ID";
    public static final String SQL_LEFT_JOIN_TABLE_VIDEO_METADATA_GENRES = " LEFT JOIN VIDEO_METADATA_GENRES ON VIDEO_METADATA.FILEID = VIDEO_METADATA_GENRES.FILEID";
    public static final String REFERENCE_TABLE_COL_FILE_ID = "VIDEO_METADATA(FILEID)";
    private static final String SQL_GET_VIDEO_METADATA_BY_FILEID = "SELECT FILEID, IMDBID, MEDIA_YEAR, TITLE, TVSERIESID, EXTRAINFORMATION, ISTVEPISODE, TVSEASON, TVEPISODENUMBER FROM VIDEO_METADATA WHERE FILEID = ?";
    private static final String SQL_GET_VIDEO_ALL_METADATA_BY_FILEID = "SELECT * FROM VIDEO_METADATA WHERE FILEID = ?";
    private static final String SQL_GET_VIDEO_METADATA_BY_FILEID_WITH_IMDBID_OR_TMDBID_EXIST = "SELECT * FROM VIDEO_METADATA WHERE VIDEO_METADATA.FILEID = ? AND (VIDEO_METADATA.IMDBID IS NOT NULL OR VIDEO_METADATA.TMDBID IS NOT NULL) LIMIT 1";
    private static final String SQL_GET_API_METADATA_EXIST = "SELECT VIDEO_METADATA.FILEID FROM VIDEO_METADATA WHERE VIDEO_METADATA.FILEID = ? LIMIT 1";
    private static final String SQL_GET_API_METADATA_IMDBID_OR_TMDBID_EXIST = "SELECT VIDEO_METADATA.FILEID FROM VIDEO_METADATA WHERE VIDEO_METADATA.FILEID = ? AND (VIDEO_METADATA.IMDBID IS NOT NULL OR VIDEO_METADATA.TMDBID IS NOT NULL) LIMIT 1";
    private static final String SQL_GET_API_METADATA_API_VERSION_IMDBID_OR_TMDBID_EXIST = "SELECT VIDEO_METADATA.FILEID FROM VIDEO_METADATA WHERE VIDEO_METADATA.FILEID = ? AND (VIDEO_METADATA.IMDBID IS NOT NULL OR VIDEO_METADATA.TMDBID IS NOT NULL) AND VIDEO_METADATA.API_VERSION = ? LIMIT 1";
    private static final String SQL_GET_FILENAME_TVSERIESID = "SELECT FILES.FILENAME FROM FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE VIDEO_METADATA.TVSERIESID = ?";
    private static final String SQL_UPDATE_TITLE = "UPDATE VIDEO_METADATA SET TITLE = ? WHERE TITLE = ?";
    private static final int SIZE_IMDBID = 16;
    private static final int SIZE_TVEPISODENUMBER = 8;
    public static final String RELEASEDATE_FORMATED = "FORMATDATETIME(VIDEO_METADATA.RELEASEDATE, 'yyyy')";
    public static final String FLOOR_RATING = "CAST(FLOOR(VIDEO_METADATA.RATING) AS INT)";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableVideoMetadata.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version == null) {
                version = 1;
            }
            if (version < 8) {
                MediaTableVideoMetadata.upgradeTable(connection, version);
            } else if (version > 8) {
                LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
            }
        } else {
            MediaTableVideoMetadata.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 8);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void upgradeTable(Connection connection, Integer currentVersion) throws SQLException {
        MediaTableVideoMetadata.LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", new Object[]{"medias", "VIDEO_METADATA", currentVersion, 8});
        block55: for (version = currentVersion.intValue(); version < 8; ++version) {
            MediaTableVideoMetadata.LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", new Object[]{"medias", "VIDEO_METADATA", version, version + 1});
            switch (version) {
                case 1: {
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA ADD COLUMN IF NOT EXISTS OVERVIEW CLOB");
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA ADD COLUMN IF NOT EXISTS TAGLINE VARCHAR");
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA ADD COLUMN IF NOT EXISTS VOTES VARCHAR");
                    continue block55;
                }
                case 2: {
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA ADD COLUMN IF NOT EXISTS TMDBID BIGINT");
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA ADD COLUMN IF NOT EXISTS TMDBTVID BIGINT");
                    MediaTableVideoMetadata.executeUpdate(connection, "DROP INDEX IF EXISTS VIDEO_METADATA_IMDBID_API_VERSION_IDX");
                    MediaTableVideoMetadata.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS VIDEO_METADATA_TMDBID_IMDBID_API_VERSION_IDX ON VIDEO_METADATA(TMDBID, IMDBID, API_VERSION)");
                    if (MediaTableVideoMetadata.isColumnExist(connection, "VIDEO_METADATA", "OVERVIEW")) continue block55;
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE IF EXISTS VIDEO_METADATA ALTER COLUMN IF EXISTS PLOT RENAME TO OVERVIEW");
                    continue block55;
                }
                case 3: {
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA ADD COLUMN IF NOT EXISTS MODIFIED BIGINT");
                    continue block55;
                }
                case 4: {
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA ALTER COLUMN IF EXISTS FILEID BIGINT");
                    continue block55;
                }
                case 5: {
                    MediaTableVideoMetadata.executeUpdate(connection, "DROP INDEX IF EXISTS VIDEO_METADATA_BASIC_COLUMNS_IDX");
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE IF EXISTS VIDEO_METADATA ADD COLUMN IF NOT EXISTS TVSERIESID BIGINT");
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE IF EXISTS VIDEO_METADATA ALTER COLUMN IF EXISTS TVEPISODENAME RENAME TO TITLE");
                    if (MediaTableVideoMetadata.isColumnExist(connection, "VIDEO_METADATA", "MOVIEORSHOWNAME")) {
                        MediaTableVideoMetadata.executeUpdate(connection, "UPDATE VIDEO_METADATA SET TITLE = MOVIEORSHOWNAME WHERE VIDEO_METADATA.ISTVEPISODE = FALSE");
                        if (MediaTableVideoMetadata.tableExists(connection, "TV_SERIES")) {
                            MediaTableVideoMetadata.executeUpdate(connection, "UPDATE VIDEO_METADATA SET TVSERIESID = (SELECT TV_SERIES.ID FROM TV_SERIES WHERE TV_SERIES.TITLE = VIDEO_METADATA.MOVIEORSHOWNAME)");
                        }
                        MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE IF EXISTS VIDEO_METADATA DROP COLUMN IF EXISTS MOVIEORSHOWNAME");
                    }
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE IF EXISTS VIDEO_METADATA DROP COLUMN IF EXISTS MOVIEORSHOWNAMESIMPLE");
                    MediaTableVideoMetadata.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS VIDEO_METADATA_BASIC_COLUMNS_IDX ON VIDEO_METADATA(IMDBID, MEDIA_YEAR, TITLE, TVSERIESID, EXTRAINFORMATION, ISTVEPISODE, TVSEASON, TVEPISODENUMBER)");
                    if (MediaTableVideoMetadata.tableExists(connection, "FAILED_LOOKUPS")) {
                        MediaTableVideoMetadata.executeUpdate(connection, "DELETE FROM FAILED_LOOKUPS");
                    }
                    MediaTableVideoMetadata.executeUpdate(connection, "UPDATE VIDEO_METADATA SET TMDBID = NULL WHERE TMDBID = 0");
                    MediaTableVideoMetadata.executeUpdate(connection, "UPDATE VIDEO_METADATA SET TMDBTVID = NULL WHERE TMDBTVID = 0");
                    continue block55;
                }
                case 6: {
                    MediaTableVideoMetadata.executeUpdate(connection, "UPDATE VIDEO_METADATA SET ORIGINALTITLE = REPLACE(ORIGINALTITLE, '\"') WHERE ORIGINALTITLE IS NOT NULL");
                    MediaTableVideoMetadata.executeUpdate(connection, "UPDATE VIDEO_METADATA SET ORIGINALLANGUAGE = REPLACE(ORIGINALLANGUAGE, '\"') WHERE ORIGINALLANGUAGE IS NOT NULL");
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE IF EXISTS VIDEO_METADATA ADD COLUMN IF NOT EXISTS POSTER VARCHAR");
                    if (MediaTableVideoMetadata.tableExists(connection, "VIDEO_METADATA_POSTERS")) {
                        MediaTableVideoMetadata.executeUpdate(connection, "UPDATE VIDEO_METADATA SET VIDEO_METADATA.POSTER = (SELECT VIDEO_METADATA_POSTERS.POSTER FROM VIDEO_METADATA_POSTERS WHERE VIDEO_METADATA_POSTERS.FILEID = VIDEO_METADATA.FILEID LIMIT 1)");
                    }
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE IF EXISTS VIDEO_METADATA ADD COLUMN IF NOT EXISTS RATED VARCHAR");
                    if (MediaTableVideoMetadata.tableExists(connection, "VIDEO_METADATA_RATED")) {
                        MediaTableVideoMetadata.executeUpdate(connection, "UPDATE VIDEO_METADATA SET VIDEO_METADATA.RATED = (SELECT VIDEO_METADATA_RATED.RATED FROM VIDEO_METADATA_RATED WHERE VIDEO_METADATA_RATED.FILEID = VIDEO_METADATA.FILEID LIMIT 1)");
                    }
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE IF EXISTS VIDEO_METADATA ADD COLUMN IF NOT EXISTS RATING DOUBLE PRECISION");
                    if (MediaTableVideoMetadata.tableExists(connection, "VIDEO_METADATA_IMDB_RATING")) {
                        prepSql = "UPDATE VIDEO_METADATA SET RATING = ? WHERE FILEID = ?";
                        ps = connection.prepareStatement("SELECT * FROM VIDEO_METADATA_IMDB_RATING WHERE FILEID IS NOT NULL");
                        try {
                            rs = ps.executeQuery();
                            block56: while (true) {
                                while (rs.next()) {
                                    fileId = rs.getLong("FILEID");
                                    str = rs.getString("IMDBRATING");
                                    try {
                                        rating = Double.valueOf(str);
                                        if (!(rating > 0.0)) continue block56;
                                        udpdateStatement = connection.prepareStatement(prepSql);
                                        try {
                                            udpdateStatement.setDouble(1, rating);
                                            udpdateStatement.setLong(2, fileId);
                                            udpdateStatement.execute();
                                            continue block56;
                                        }
                                        finally {
                                            if (udpdateStatement != null) {
                                                udpdateStatement.close();
                                            }
                                            continue block56;
                                        }
                                    }
                                    catch (NullPointerException | NumberFormatException rating) {
                                    }
                                }
                                ** GOTO lbl89
                                {
                                    continue block56;
                                    break;
                                }
                                break;
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        finally {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                    }
lbl89:
                    // 3 sources

                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE IF EXISTS VIDEO_METADATA ADD COLUMN IF NOT EXISTS RELEASEDATE DATE");
                    if (MediaTableVideoMetadata.tableExists(connection, "VIDEO_METADATA_RELEASED")) {
                        prepSql = "UPDATE VIDEO_METADATA SET RELEASEDATE = ? WHERE FILEID = ?";
                        ps = connection.prepareStatement("SELECT * FROM VIDEO_METADATA_RELEASED WHERE VIDEO_METADATA_RELEASED.FILEID IS NOT NULL");
                        try {
                            rs = ps.executeQuery();
                            block58: while (true) {
                                while (rs.next()) {
                                    fileId = rs.getLong("FILEID");
                                    releaseDate = rs.getString("RELEASEDATE");
                                    if (releaseDate == null) continue;
                                    if (releaseDate.length() > 10) {
                                        releaseDate = releaseDate.substring(0, 10);
                                    }
                                    try {
                                        udpdateStatement = connection.prepareStatement(prepSql);
                                        try {
                                            udpdateStatement.setDate(1, Date.valueOf(releaseDate));
                                            udpdateStatement.setLong(2, fileId);
                                            udpdateStatement.execute();
                                            continue block58;
                                        }
                                        finally {
                                            if (udpdateStatement != null) {
                                                udpdateStatement.close();
                                            }
                                            continue block58;
                                        }
                                    }
                                    catch (IllegalArgumentException var8_23) {
                                    }
                                }
                                ** GOTO lbl130
                                {
                                    continue block58;
                                    break;
                                }
                                break;
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        finally {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                    }
lbl130:
                    // 3 sources

                    ps = connection.prepareStatement("SELECT * FROM VIDEO_METADATA WHERE MEDIA_YEAR IS NOT NULL", 1005, 1008);
                    try {
                        rs = ps.executeQuery();
                        try {
                            while (rs.next()) {
                                yearStr = rs.getString("MEDIA_YEAR");
                                year = FileUtil.getYearFromYearString(yearStr);
                                if (year != null) {
                                    rs.updateString("MEDIA_YEAR", year.toString());
                                } else {
                                    rs.updateNull("MEDIA_YEAR");
                                }
                                rs.updateRow();
                            }
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA ALTER COLUMN IF EXISTS MEDIA_YEAR INTEGER");
                    MediaTableVideoMetadata.executeUpdate(connection, "ALTER TABLE VIDEO_METADATA ALTER COLUMN IF EXISTS TVSEASON INTEGER");
                    continue block55;
                }
                case 7: {
                    MediaTableVideoMetadata.LOGGER.debug("creating index IF NOT EXISTS VIDEO_METADATA_TMDBID_IDX");
                    MediaTableVideoMetadata.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS VIDEO_METADATA_TMDBID_IDX ON VIDEO_METADATA(TMDBID)");
                    MediaTableVideoMetadata.LOGGER.debug("creating index IF NOT EXISTS VIDEO_METADATA_IMDBID_IDX");
                    MediaTableVideoMetadata.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS VIDEO_METADATA_IMDBID_IDX ON VIDEO_METADATA(IMDBID)");
                    continue block55;
                }
                default: {
                    throw new IllegalStateException(MediaTableVideoMetadata.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", new Object[]{"medias", "VIDEO_METADATA", version, 8}));
                }
            }
        }
        try {
            MediaTableTablesVersions.setTableVersion(connection, "VIDEO_METADATA", 8);
        }
        catch (SQLException e) {
            MediaTableVideoMetadata.LOGGER.error("Failed setting the table version of the {} for {}", (Object)"VIDEO_METADATA", (Object)e.getMessage());
            MediaTableVideoMetadata.LOGGER.error("Please use the 'Reset the cache' button on the 'Navigation Settings' tab, close UMS and start it again.");
            throw new SQLException(e);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableVideoMetadata.execute(connection, "CREATE TABLE VIDEO_METADATA (FILEID BIGINT PRIMARY KEY, MODIFIED BIGINT, IMDBID VARCHAR(16), TMDBID BIGINT, TMDBTVID BIGINT, MEDIA_YEAR INTEGER, TITLE VARCHAR, TVSERIESID BIGINT, TVSEASON INTEGER, TVEPISODENUMBER VARCHAR(8), ISTVEPISODE BOOLEAN, EXTRAINFORMATION VARCHAR(255), API_VERSION VARCHAR(16), BUDGET BIGINT, CREDITS CLOB, EXTERNALIDS CLOB, HOMEPAGE VARCHAR, IMAGES CLOB, ORIGINALLANGUAGE VARCHAR, ORIGINALTITLE VARCHAR, OVERVIEW CLOB, POSTER VARCHAR, PRODUCTIONCOMPANIES CLOB, PRODUCTIONCOUNTRIES CLOB, RATED VARCHAR, RELEASEDATE DATE, REVENUE BIGINT, RATING DOUBLE PRECISION, TAGLINE VARCHAR, VOTES VARCHAR, CONSTRAINT VIDEO_METADATA_FILEID_FK FOREIGN KEY(FILEID) REFERENCES FILES(ID) ON DELETE CASCADE)", "CREATE INDEX IF NOT EXISTS VIDEO_METADATA_BASIC_COLUMNS_IDX ON VIDEO_METADATA(IMDBID, MEDIA_YEAR, TITLE, TVSERIESID, EXTRAINFORMATION, ISTVEPISODE, TVSEASON, TVEPISODENUMBER)", "CREATE INDEX IF NOT EXISTS VIDEO_METADATA_TMDBID_IMDBID_API_VERSION_IDX ON VIDEO_METADATA(TMDBID, IMDBID, API_VERSION)", "CREATE INDEX IF NOT EXISTS VIDEO_METADATA_TMDBID_IDX ON VIDEO_METADATA(TMDBID)", "CREATE INDEX IF NOT EXISTS VIDEO_METADATA_IMDBID_IDX ON VIDEO_METADATA(IMDBID)");
    }

    public static void insertOrUpdateVideoMetadata(Connection connection, Long fileId, MediaInfo media, boolean fromApi) throws SQLException {
        if (connection == null || fileId == null || media == null || !media.hasVideoMetadata()) {
            return;
        }
        MediaVideoMetadata videoMetadata = media.getVideoMetadata();
        try (PreparedStatement updateStatement = connection.prepareStatement(fromApi ? SQL_GET_VIDEO_ALL_METADATA_BY_FILEID : SQL_GET_VIDEO_METADATA_BY_FILEID, 1003, 1008);){
            updateStatement.setLong(1, fileId);
            try (ResultSet rs = updateStatement.executeQuery();){
                boolean isCreatingNewRecord;
                boolean bl = isCreatingNewRecord = !rs.next();
                if (isCreatingNewRecord) {
                    rs.moveToInsertRow();
                    rs.updateLong(COL_FILEID, (long)fileId);
                }
                videoMetadata.setFileId(fileId);
                rs.updateString(COL_IMDBID, StringUtils.left(videoMetadata.getIMDbID(), 16));
                MediaTableVideoMetadata.updateInteger(rs, COL_MEDIA_YEAR, videoMetadata.getYear());
                rs.updateString(COL_TITLE, StringUtils.left(videoMetadata.getTitle(), 255));
                rs.updateString(COL_EXTRAINFORMATION, StringUtils.left(videoMetadata.getExtraInformation(), 255));
                rs.updateBoolean(COL_ISTVEPISODE, videoMetadata.isTvEpisode());
                MediaTableVideoMetadata.updateLong(rs, COL_TVSERIESID, videoMetadata.getTvSeriesId());
                MediaTableVideoMetadata.updateInteger(rs, COL_TVSEASON, videoMetadata.getTvSeason());
                rs.updateString(COL_TVEPISODENUMBER, StringUtils.left(videoMetadata.getTvEpisodeNumber(), 8));
                if (fromApi) {
                    rs.updateString(COL_API_VERSION, StringUtils.left(APIUtils.getApiDataVideoVersion(), 16));
                    rs.updateLong(COL_MODIFIED, System.currentTimeMillis());
                    MediaTableVideoMetadata.updateLong(rs, COL_BUDGET, videoMetadata.getBudget());
                    if (videoMetadata.getCredits() != null) {
                        rs.updateString(COL_CREDITS, GSON.toJson(videoMetadata.getCredits()));
                    } else {
                        rs.updateNull(COL_CREDITS);
                    }
                    if (videoMetadata.getExternalIDs() != null) {
                        rs.updateString(COL_EXTERNALIDS, GSON.toJson(videoMetadata.getExternalIDs()));
                    } else {
                        rs.updateNull(COL_EXTERNALIDS);
                    }
                    rs.updateString(COL_HOMEPAGE, videoMetadata.getHomepage());
                    if (videoMetadata.getImages() != null) {
                        rs.updateString(COL_IMAGES, GSON.toJson(videoMetadata.getImages()));
                    } else {
                        rs.updateNull(COL_IMAGES);
                    }
                    if (videoMetadata.getOriginalLanguage() != null) {
                        rs.updateString(COL_ORIGINALLANGUAGE, videoMetadata.getOriginalLanguage());
                    } else {
                        rs.updateNull(COL_ORIGINALLANGUAGE);
                    }
                    if (videoMetadata.getOriginalTitle() != null) {
                        rs.updateString(COL_ORIGINALTITLE, videoMetadata.getOriginalTitle());
                    } else {
                        rs.updateNull(COL_ORIGINALTITLE);
                    }
                    rs.updateString(COL_OVERVIEW, videoMetadata.getOverview());
                    rs.updateString(COL_POSTER, videoMetadata.getPoster());
                    if (videoMetadata.getProductionCompanies() != null) {
                        rs.updateString(COL_PRODUCTIONCOMPANIES, GSON.toJson(videoMetadata.getProductionCompanies()));
                    } else {
                        rs.updateNull(COL_PRODUCTIONCOMPANIES);
                    }
                    if (videoMetadata.getProductionCountries() != null) {
                        rs.updateString(COL_PRODUCTIONCOUNTRIES, GSON.toJson(videoMetadata.getProductionCountries()));
                    } else {
                        rs.updateNull(COL_PRODUCTIONCOUNTRIES);
                    }
                    MediaTableVideoMetadata.updateLong(rs, COL_REVENUE, videoMetadata.getRevenue());
                    rs.updateString(COL_RATED, videoMetadata.getRated());
                    MediaTableVideoMetadata.updateDouble(rs, COL_RATING, videoMetadata.getRating());
                    MediaTableVideoMetadata.updateDate(rs, COL_RELEASEDATE, videoMetadata.getReleased());
                    rs.updateString(COL_TAGLINE, videoMetadata.getTagline());
                    MediaTableVideoMetadata.updateLong(rs, COL_TMDBID, videoMetadata.getTmdbId());
                    MediaTableVideoMetadata.updateLong(rs, COL_TMDBTVID, videoMetadata.getTmdbTvId());
                    rs.updateString(COL_VOTES, videoMetadata.getVotes());
                }
                if (isCreatingNewRecord) {
                    rs.insertRow();
                    connection.commit();
                } else {
                    rs.updateRow();
                }
            }
        }
        if (fromApi) {
            MediaTableVideoMetadataActors.set(connection, fileId, videoMetadata.getActors(), null);
            MediaTableVideoMetadataAwards.set(connection, fileId, videoMetadata.getAwards(), null);
            MediaTableVideoMetadataCountries.set(connection, fileId, videoMetadata.getCountries(), null);
            MediaTableVideoMetadataDirectors.set(connection, fileId, videoMetadata.getDirectors(), null);
            MediaTableVideoMetadataGenres.set(connection, fileId, videoMetadata.getGenres(), null);
            MediaTableVideoMetadataRatings.set(connection, fileId, videoMetadata.getRatings(), null);
        }
        connection.commit();
    }

    public static synchronized void insertVideoMetadata(Connection connection, String path, long modified, MediaInfo media) throws SQLException {
        if (StringUtils.isBlank(path)) {
            LOGGER.warn("Couldn't write metadata for \"{}\" to the database because the media cannot be identified", (Object)path);
            return;
        }
        if (media == null || !media.hasVideoMetadata()) {
            LOGGER.warn("Couldn't write metadata for \"{}\" to the database because there is no media information", (Object)path);
            return;
        }
        Long fileId = MediaTableFiles.getFileId(connection, path, modified);
        if (fileId == null) {
            LOGGER.trace("Couldn't find \"{}\" in the database when trying to store metadata", (Object)path);
        } else {
            try (PreparedStatement selectStatement = connection.prepareStatement(SQL_GET_API_METADATA_EXIST);){
                selectStatement.setLong(1, fileId);
                try (ResultSet rs = selectStatement.executeQuery();){
                    if (rs.next()) {
                        LOGGER.trace("\"{}\" already exists in the database", (Object)path);
                        return;
                    }
                }
            }
            media.getVideoMetadata().setFileId(fileId);
            MediaTableVideoMetadata.insertOrUpdateVideoMetadata(connection, fileId, media, false);
        }
    }

    public static MediaVideoMetadata getVideoMetadataByFilename(Connection connection, String filename) {
        if (connection == null || StringUtils.isBlank(filename)) {
            return null;
        }
        Long id = MediaTableFiles.getFileId(connection, filename);
        if (id != null) {
            return MediaTableVideoMetadata.getVideoMetadataByFileId(connection, id);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MediaVideoMetadata getVideoMetadataByFileId(Connection connection, long fileId) {
        if (connection == null) return null;
        if (fileId < 0L) {
            return null;
        }
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement selectStatement = connection.prepareStatement(SQL_GET_VIDEO_METADATA_BY_FILEID_WITH_IMDBID_OR_TMDBID_EXIST);){
            selectStatement.setLong(1, fileId);
            if (trace) {
                LOGGER.trace("Searching VIDEO_METADATA with \"{}\"", (Object)selectStatement);
            }
            try (ResultSet rs = selectStatement.executeQuery();){
                if (!rs.next()) return null;
                MediaVideoMetadata metadata = new MediaVideoMetadata();
                metadata.setFileId(rs.getLong(COL_FILEID));
                metadata.setApiVersion(rs.getString(COL_API_VERSION));
                metadata.setIMDbID(rs.getString(COL_IMDBID));
                metadata.setYear(MediaTableVideoMetadata.toInteger(rs, COL_MEDIA_YEAR));
                metadata.setTitle(rs.getString(COL_TITLE));
                metadata.setExtraInformation(rs.getString(COL_EXTRAINFORMATION));
                metadata.setIsTvEpisode(rs.getBoolean(COL_ISTVEPISODE));
                metadata.setTvSeriesId(MediaTableVideoMetadata.toLong(rs, COL_TVSERIESID));
                metadata.setActors(MediaTableVideoMetadataActors.getActorsForFile(connection, fileId));
                metadata.setAwards(MediaTableVideoMetadataAwards.getValueForFile(connection, fileId));
                metadata.setBudget(MediaTableVideoMetadata.toLong(rs, COL_BUDGET));
                metadata.setCredits(rs.getString(COL_CREDITS));
                metadata.setCountries(MediaTableVideoMetadataCountries.getCountriesForFile(connection, fileId));
                metadata.setDirectors(MediaTableVideoMetadataDirectors.getDirectorsForFile(connection, fileId));
                metadata.setExternalIDs(rs.getString(COL_EXTERNALIDS));
                metadata.setGenres(MediaTableVideoMetadataGenres.getGenresForFile(connection, fileId));
                metadata.setHomepage(rs.getString(COL_HOMEPAGE));
                metadata.setImages(rs.getString(COL_IMAGES));
                metadata.setOriginalLanguage(rs.getString(COL_ORIGINALLANGUAGE));
                metadata.setOriginalTitle(rs.getString(COL_ORIGINALTITLE));
                metadata.setOverview(rs.getString(COL_OVERVIEW));
                metadata.setPoster(rs.getString(COL_POSTER));
                metadata.setProductionCompanies(rs.getString(COL_PRODUCTIONCOMPANIES));
                metadata.setProductionCountries(rs.getString(COL_PRODUCTIONCOUNTRIES));
                metadata.setRated(rs.getString(COL_RATED));
                metadata.setRating(MediaTableVideoMetadata.toDouble(rs, COL_RATING));
                metadata.setRatings(MediaTableVideoMetadataRatings.getRatingsForFile(connection, fileId));
                metadata.setReleased(MediaTableVideoMetadata.getLocalDate(rs, COL_RELEASEDATE));
                metadata.setRevenue(MediaTableVideoMetadata.toLong(rs, COL_REVENUE));
                if (metadata.isTvEpisode() && metadata.getTvSeriesId() != null) {
                    metadata.setSeriesMetadata(MediaInfoStore.getTvSeriesMetadata(metadata.getTvSeriesId()));
                }
                metadata.setTvSeason(MediaTableVideoMetadata.toInteger(rs, COL_TVSEASON));
                metadata.setTvEpisodeNumber(rs.getString(COL_TVEPISODENUMBER));
                metadata.setTagline(rs.getString(COL_TAGLINE));
                metadata.setTmdbId(MediaTableVideoMetadata.toLong(rs, COL_TMDBID));
                metadata.setTmdbTvId(MediaTableVideoMetadata.toLong(rs, COL_TMDBTVID));
                metadata.setVotes(rs.getString(COL_VOTES));
                metadata.setTranslations(MediaTableVideoMetadataLocalized.getAllVideoMetadataLocalized(connection, fileId, false));
                metadata.ensureHavingTranslation(null);
                MediaVideoMetadata mediaVideoMetadata = metadata;
                return mediaVideoMetadata;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VideoMetadataLocalized getVideoMetadataUnLocalized(Connection connection, long fileId) {
        if (connection == null) return null;
        if (fileId < 0L) {
            return null;
        }
        try (PreparedStatement selectStatement = connection.prepareStatement(SQL_GET_VIDEO_METADATA_BY_FILEID_WITH_IMDBID_OR_TMDBID_EXIST);){
            selectStatement.setLong(1, fileId);
            try (ResultSet rs = selectStatement.executeQuery();){
                if (!rs.next()) return null;
                VideoMetadataLocalized metadata = new VideoMetadataLocalized();
                metadata.setHomepage(rs.getString(COL_HOMEPAGE));
                metadata.setOverview(rs.getString(COL_OVERVIEW));
                metadata.setTagline(rs.getString(COL_TAGLINE));
                metadata.setTitle(rs.getString(COL_TITLE));
                VideoMetadataLocalized videoMetadataLocalized = metadata;
                return videoMetadataLocalized;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in VIDEO_METADATA for \"{}\": {}", (Object)fileId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    public static boolean doesLatestApiMetadataExist(Connection connection, String name, long modified) {
        Long id = MediaTableFiles.getFileId(connection, name, modified);
        if (id == null) {
            return true;
        }
        return MediaTableVideoMetadata.doesLatestApiMetadataExist(connection, id);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean doesLatestApiMetadataExist(Connection connection, Long fileId) {
        String latestVersion = null;
        if (CONFIGURATION.getExternalNetwork()) {
            latestVersion = APIUtils.getApiDataVideoVersion();
        }
        String sql = latestVersion != null ? SQL_GET_API_METADATA_API_VERSION_IMDBID_OR_TMDBID_EXIST : SQL_GET_API_METADATA_IMDBID_OR_TMDBID_EXIST;
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setLong(1, fileId.intValue());
            if (latestVersion != null) {
                statement.setString(2, latestVersion);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return false;
                boolean bl = true;
                return bl;
            }
        }
        catch (SQLException se) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "checking if API metadata exists for", TABLE_NAME, fileId, se.getMessage());
            LOGGER.trace("", se);
        }
        return false;
    }

    public static List<String> getTvEpisodesFilesByTvSeriesId(Connection connection, Long tvSeriesId) {
        ArrayList<String> result = new ArrayList<String>();
        if (connection == null || tvSeriesId == null || tvSeriesId < 0L) {
            return result;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_FILENAME_TVSERIESID);){
            statement.setLong(1, tvSeriesId);
            try (ResultSet resultSet = statement.executeQuery();){
                while (resultSet.next()) {
                    result.add(resultSet.getString(1));
                }
            }
        }
        catch (SQLException se) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "getTvEpisodesFilesByTvSeriesId", TABLE_NAME, tvSeriesId, se.getMessage());
            LOGGER.trace("", se);
        }
        return result;
    }

    public static void updateMovieOrShowName(Connection connection, String oldName, String newName) {
        if (StringUtils.isEmpty(newName)) {
            return;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_UPDATE_TITLE);){
            statement.setString(1, StringUtils.left(newName, 255));
            statement.setString(2, StringUtils.left(oldName, 255));
            statement.execute();
        }
        catch (SQLException e) {
            LOGGER.error("Failed to update MOVIEORSHOWNAME from \"{}\" to \"{}\": {}", oldName, newName, e.getMessage());
            LOGGER.trace("", e);
        }
    }
}

