/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import com.google.gson.Gson;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import net.pms.database.MediaTableVideoMetadataActors;
import net.pms.database.MediaTableVideoMetadataAwards;
import net.pms.database.MediaTableVideoMetadataCountries;
import net.pms.database.MediaTableVideoMetadataDirectors;
import net.pms.database.MediaTableVideoMetadataGenres;
import net.pms.database.MediaTableVideoMetadataLocalized;
import net.pms.database.MediaTableVideoMetadataRatings;
import net.pms.dlna.DLNAThumbnail;
import net.pms.external.JavaHttpClient;
import net.pms.external.umsapi.APIUtils;
import net.pms.media.video.metadata.TvSeriesMetadata;
import net.pms.media.video.metadata.VideoMetadataLocalized;
import net.pms.store.ThumbnailSource;
import net.pms.store.ThumbnailStore;
import net.pms.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableTVSeries
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableTVSeries.class);
    private static final Gson GSON = new Gson();
    public static final String TABLE_NAME = "TV_SERIES";
    private static final int TABLE_VERSION = 12;
    public static final String COL_API_VERSION = "API_VERSION";
    public static final String COL_ID = "ID";
    private static final String COL_IMAGES = "IMAGES";
    private static final String COL_IMDBID = "IMDBID";
    private static final String COL_MODIFIED = "MODIFIED";
    private static final String COL_OVERVIEW = "OVERVIEW";
    private static final String COL_THUMBID = "THUMBID";
    private static final String COL_THUMB_SRC = "THUMB_SRC";
    private static final String COL_TMDBID = "TMDBID";
    private static final String COL_STARTYEAR = "STARTYEAR";
    private static final String COL_ENDYEAR = "ENDYEAR";
    private static final String COL_TITLE = "TITLE";
    private static final String COL_CREATEDBY = "CREATEDBY";
    private static final String COL_TOTALSEASONS = "TOTALSEASONS";
    private static final String COL_VOTES = "VOTES";
    private static final String COL_CREDITS = "CREDITS";
    private static final String COL_EXTERNALIDS = "EXTERNALIDS";
    private static final String COL_FIRSTAIRDATE = "FIRSTAIRDATE";
    private static final String COL_HOMEPAGE = "HOMEPAGE";
    private static final String COL_INPRODUCTION = "INPRODUCTION";
    private static final String COL_LANGUAGES = "LANGUAGES";
    private static final String COL_LASTAIRDATE = "LASTAIRDATE";
    private static final String COL_NETWORKS = "NETWORKS";
    private static final String COL_NUMBEROFEPISODES = "NUMBEROFEPISODES";
    private static final String COL_NUMBEROFSEASONS = "NUMBEROFSEASONS";
    private static final String COL_ORIGINCOUNTRY = "ORIGINCOUNTRY";
    private static final String COL_ORIGINALLANGUAGE = "ORIGINALLANGUAGE";
    private static final String COL_ORIGINALTITLE = "ORIGINALTITLE";
    private static final String COL_POSTER = "POSTER";
    private static final String COL_PRODUCTIONCOMPANIES = "PRODUCTIONCOMPANIES";
    private static final String COL_PRODUCTIONCOUNTRIES = "PRODUCTIONCOUNTRIES";
    public static final String COL_RATED = "RATED";
    private static final String COL_RATING = "RATING";
    private static final String COL_SEASONS = "SEASONS";
    private static final String COL_SERIESTYPE = "SERIESTYPE";
    private static final String COL_SPOKENLANGUAGES = "SPOKENLANGUAGES";
    private static final String COL_STATUS = "STATUS";
    private static final String COL_TAGLINE = "TAGLINE";
    public static final String TABLE_COL_FIRSTAIRDATE = "TV_SERIES.FIRSTAIRDATE";
    public static final String TABLE_COL_ID = "TV_SERIES.ID";
    public static final String TABLE_COL_IMAGES = "TV_SERIES.IMAGES";
    public static final String TABLE_COL_IMDBID = "TV_SERIES.IMDBID";
    private static final String TABLE_COL_POSTER = "TV_SERIES.POSTER";
    public static final String TABLE_COL_RATED = "TV_SERIES.RATED";
    public static final String TABLE_COL_RATING = "TV_SERIES.RATING";
    public static final String TABLE_COL_STARTYEAR = "TV_SERIES.STARTYEAR";
    public static final String TABLE_COL_TITLE = "TV_SERIES.TITLE";
    public static final String TABLE_COL_THUMBID = "TV_SERIES.THUMBID";
    private static final String TABLE_COL_TMDBID = "TV_SERIES.TMDBID";
    public static final String SQL_LEFT_JOIN_TABLE_VIDEO_METADATA_GENRES = " LEFT JOIN VIDEO_METADATA_GENRES ON TV_SERIES.ID = VIDEO_METADATA_GENRES.TVSERIESID";
    public static final String REFERENCE_TABLE_COL_ID = "TV_SERIES(ID)";
    private static final String SQL_GET_BY_ID = "SELECT * FROM TV_SERIES WHERE TV_SERIES.ID = ? LIMIT 1";
    private static final String SQL_GET_BY_TITLE = "SELECT * FROM TV_SERIES WHERE TV_SERIES.TITLE = ? LIMIT 1";
    private static final String SQL_GET_BY_TITLE_YEAR = "SELECT * FROM TV_SERIES WHERE TV_SERIES.TITLE = ? AND TV_SERIES.STARTYEAR = ? LIMIT 1";
    private static final String SQL_GET_BY_IMDBID = "SELECT * FROM TV_SERIES WHERE TV_SERIES.IMDBID = ? LIMIT 1";
    private static final String SQL_GET_BY_TMDBID = "SELECT * FROM TV_SERIES WHERE TV_SERIES.TMDBID = ? LIMIT 1";
    private static final String SQL_GET_ID_BY_IMDBID = "SELECT TV_SERIES.ID FROM TV_SERIES WHERE TV_SERIES.IMDBID = ? LIMIT 1";
    private static final String SQL_GET_ID_BY_IMDBID_API_VERSION = "SELECT TV_SERIES.ID FROM TV_SERIES WHERE TV_SERIES.IMDBID = ? AND API_VERSION = ? LIMIT 1";
    private static final String SQL_GET_ID_BY_SIMPLIFIEDTITLE = "SELECT TV_SERIES.ID FROM TV_SERIES WHERE REGEXP_REPLACE(LOWER(TITLE), '[^a-z0-9]', '') = ? LIMIT 1";
    private static final String SQL_GET_ID_BY_SIMPLIFIEDTITLE_YEAR = "SELECT TV_SERIES.ID FROM TV_SERIES WHERE REGEXP_REPLACE(LOWER(TITLE), '[^a-z0-9]', '') = ? AND TV_SERIES.STARTYEAR = ? LIMIT 1";
    private static final String SQL_GET_ID_BY_ORIGINALTITLE = "SELECT TV_SERIES.ID FROM TV_SERIES WHERE REGEXP_REPLACE(LOWER(ORIGINALTITLE), '[^a-z0-9]', '') = ? LIMIT 1";
    private static final String SQL_GET_ID_BY_ORIGINALTITLE_YEAR = "SELECT TV_SERIES.ID FROM TV_SERIES WHERE REGEXP_REPLACE(LOWER(ORIGINALTITLE), '[^a-z0-9]', '') = ? AND TV_SERIES.STARTYEAR = ? LIMIT 1";
    private static final String SQL_GET_TITLE_BY_ID = "SELECT TV_SERIES.TITLE FROM TV_SERIES WHERE TV_SERIES.ID = ? LIMIT 1";
    private static final String SQL_GET_TMDBID_BY_ID = "SELECT TV_SERIES.TMDBID FROM TV_SERIES WHERE TV_SERIES.ID = ? LIMIT 1";
    private static final String SQL_GET_IMAGES_BY_ID = "SELECT TV_SERIES.IMAGES FROM TV_SERIES WHERE TV_SERIES.ID = ? LIMIT 1";
    private static final String SQL_UPDATE_THUMBID = "UPDATE TV_SERIES SET THUMBID = ?, THUMB_SRC = ? WHERE TV_SERIES.ID = ?";
    private static final String SQL_UPDATE_THUMB_SRC_LOC = "UPDATE TV_SERIES SET THUMB_SRC = ? WHERE THUMB_SRC = ?";
    private static final String SQL_UPDATE_TMDBID = "UPDATE TV_SERIES SET TMDBID = ? WHERE ID = ?";
    private static final String SQL_UPDATE_IMDBID_TMDBID_NULL = "UPDATE TV_SERIES SET IMDBID = NULL, TMDBID = NULL WHERE TV_SERIES.ID = ?";
    private static final String SQL_GET_PARTIALLY_PLAYED = "SELECT VIDEO_METADATA.TITLE FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND VIDEO_METADATA.ISTVEPISODE AND VIDEO_METADATA.TITLE = ? AND FILES_STATUS.USERID = ? LIMIT 1";
    private static final String SQL_GET_NOT_FULLYPLAYED = "SELECT VIDEO_METADATA.TITLE FROM FILES LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE FILES.FORMAT_TYPE = 4 AND VIDEO_METADATA.ISTVEPISODE AND VIDEO_METADATA.TITLE = ? AND FILES_STATUS.ISFULLYPLAYED IS NOT TRUE AND FILES_STATUS.USERID = ? LIMIT 1";
    public static final String CHILD_ID = "TVSERIESID";
    public static final String FIRSTAIRDATE_FORMATED = "FORMATDATETIME(TV_SERIES.FIRSTAIRDATE, 'yyyy')";
    public static final String FLOOR_RATING = "CAST(FLOOR(TV_SERIES.RATING) AS INT)";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableTVSeries.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 12) {
                    MediaTableTVSeries.upgradeTable(connection, version);
                } else if (version > 12) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableTVSeries.dropTable(connection, TABLE_NAME);
                MediaTableTVSeries.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 12);
            }
        } else {
            MediaTableTVSeries.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 12);
        }
    }

    /*
     * Unable to fully structure code
     */
    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        MediaTableTVSeries.LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", new Object[]{"medias", "TV_SERIES", currentVersion, 12});
        block78: for (version = currentVersion; version < 12; ++version) {
            MediaTableTVSeries.LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", new Object[]{"medias", "TV_SERIES", version, version + 1});
            switch (version) {
                case 1: {
                    try {
                        statement = connection.createStatement();
                        try {
                            if (MediaTableTVSeries.isColumnExist(connection, "TV_SERIES", "VERSION")) continue block78;
                            statement.execute("ALTER TABLE TV_SERIES ADD VERSION VARCHAR");
                            statement.execute("CREATE INDEX IF NOT EXISTS IMDBID_VERSION  ON TV_SERIES(IMDBID, VERSION)");
                            continue block78;
                        }
                        finally {
                            if (statement != null) {
                                statement.close();
                            }
                        }
                    }
                    catch (SQLException e) {
                        MediaTableTVSeries.LOGGER.error("Failed upgrading database table {} for {}", (Object)"TV_SERIES", (Object)e.getMessage());
                        MediaTableTVSeries.LOGGER.error("Please use the 'Reset the cache' button on the 'Navigation Settings' tab, close UMS and start it again.");
                        throw new SQLException(e);
                    }
                }
                case 2: {
                    if (!MediaTableTVSeries.isColumnExist(connection, "TV_SERIES", "YEAR")) continue block78;
                    MediaTableTVSeries.LOGGER.trace("Renaming column name YEAR to MEDIA_YEAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ALTER COLUMN `YEAR` RENAME TO MEDIA_YEAR");
                    continue block78;
                }
                case 3: {
                    MediaTableTVSeries.LOGGER.trace("Adding TMDB columns");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS CREATEDBY VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS CREDITS VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS EXTERNALIDS VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS FIRSTAIRDATE VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS HOMEPAGE VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS IMAGES VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS INPRODUCTION VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS LANGUAGES VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS LASTAIRDATE VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS NETWORKS VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS NUMBEROFEPISODES DOUBLE PRECISION");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS NUMBEROFSEASONS DOUBLE PRECISION");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS ORIGINCOUNTRY VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS ORIGINALLANGUAGE VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS ORIGINALTITLE VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS PRODUCTIONCOMPANIES VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS PRODUCTIONCOUNTRIES VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS SEASONS VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS SERIESTYPE VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS SPOKENLANGUAGES VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS STATUS VARCHAR");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS TAGLINE VARCHAR");
                    continue block78;
                }
                case 4: {
                    continue block78;
                }
                case 5: {
                    if (!MediaTableTVSeries.isColumnExist(connection, "TV_SERIES", "INPRODUCTION")) continue block78;
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES DROP COLUMN INPRODUCTION");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN INPRODUCTION BOOLEAN");
                    continue block78;
                }
                case 6: {
                    MediaTableTVSeries.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS TV_SERIES_THUMBID_IDX  ON TV_SERIES(THUMBID)");
                    if (!MediaTableTVSeries.isColumnExist(connection, "TV_SERIES", "VERSION")) continue block78;
                    var4_7 = badJsonColumns = new String[]{"LANGUAGES", "ORIGINCOUNTRY"};
                    var5_11 = var4_7.length;
                    for (var6_17 = 0; var6_17 < var5_11; ++var6_17) {
                        badJsonColumn = var4_7[var6_17];
                        if (!MediaTableTVSeries.isColumnExist(connection, "TV_SERIES", badJsonColumn)) continue;
                        MediaTableTVSeries.executeUpdate(connection, "UPDATE TV_SERIES SET IMDBID = NULL WHERE RIGHT(" + badJsonColumn + ", 1) = ','");
                    }
                    continue block78;
                }
                case 7: {
                    MediaTableTVSeries.executeUpdate(connection, "DROP INDEX IF EXISTS IMDBID_VERSION");
                    if (!MediaTableTVSeries.isColumnExist(connection, "TV_SERIES", "API_VERSION")) {
                        MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE IF EXISTS TV_SERIES ALTER COLUMN IF EXISTS VERSION RENAME TO API_VERSION");
                    }
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS TMDBID BIGINT");
                    MediaTableTVSeries.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS TV_SERIES_TMDBID_IDX  ON TV_SERIES(TMDBID)");
                    MediaTableTVSeries.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS TV_SERIES_TMDBID_IMDBID_API_VERSION_IDX  ON TV_SERIES(TMDBID, IMDBID, API_VERSION)");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER INDEX IF EXISTS IMDBID_IDX RENAME TO TV_SERIES_IMDBID_IDX");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER INDEX IF EXISTS TITLE_IDX RENAME TO TV_SERIES_TITLE_IDX");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER INDEX IF EXISTS SIMPLIFIEDTITLE_IDX RENAME TO TV_SERIES_SIMPLIFIEDTITLE_IDX");
                    if (MediaTableTVSeries.isColumnExist(connection, "TV_SERIES", "OVERVIEW")) continue block78;
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE IF EXISTS TV_SERIES ALTER COLUMN IF EXISTS PLOT RENAME TO OVERVIEW");
                    continue block78;
                }
                case 8: {
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS MODIFIED BIGINT");
                    if (MediaTableTVSeries.isColumnExist(connection, "TV_SERIES", "TMDBID")) continue block78;
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE IF EXISTS TV_SERIES ALTER COLUMN IF EXISTS TMDB_ID RENAME TO TMDBID");
                    continue block78;
                }
                case 9: {
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ADD COLUMN IF NOT EXISTS THUMB_SRC VARCHAR(32)");
                    continue block78;
                }
                case 10: {
                    MediaTableTVSeries.executeUpdate(connection, "DROP INDEX IF EXISTS TV_SERIESTV_SERIES_SIMPLIFIEDTITLE_IDX");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES DROP COLUMN IF EXISTS SIMPLIFIEDTITLE");
                    MediaTableTVSeries.executeUpdate(connection, "UPDATE TV_SERIES SET TMDBID = NULL WHERE TMDBID = 0");
                    continue block78;
                }
                case 11: {
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE IF EXISTS TV_SERIES ADD COLUMN IF NOT EXISTS POSTER VARCHAR");
                    if (MediaTableTVSeries.tableExists(connection, "VIDEO_METADATA_POSTERS")) {
                        MediaTableTVSeries.executeUpdate(connection, "UPDATE TV_SERIES SET TV_SERIES.POSTER = (SELECT VIDEO_METADATA_POSTERS.POSTER FROM VIDEO_METADATA_POSTERS WHERE VIDEO_METADATA_POSTERS.TVSERIESID = TV_SERIES.ID LIMIT 1)");
                        MediaTableTVSeries.executeUpdate(connection, "DROP TABLE VIDEO_METADATA_POSTERS");
                        MediaTableTablesVersions.removeTableVersion(connection, "VIDEO_METADATA_POSTERS");
                    }
                    if (MediaTableTVSeries.tableExists(connection, "VIDEO_METADATA_PRODUCTION")) {
                        MediaTableTVSeries.executeUpdate(connection, "DROP TABLE VIDEO_METADATA_PRODUCTION");
                        MediaTableTablesVersions.removeTableVersion(connection, "VIDEO_METADATA_PRODUCTION");
                    }
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE IF EXISTS TV_SERIES ADD COLUMN IF NOT EXISTS RATED VARCHAR");
                    if (MediaTableTVSeries.tableExists(connection, "VIDEO_METADATA_RATED")) {
                        MediaTableTVSeries.executeUpdate(connection, "UPDATE TV_SERIES SET TV_SERIES.RATED = (SELECT VIDEO_METADATA_RATED.RATED FROM VIDEO_METADATA_RATED WHERE VIDEO_METADATA_RATED.TVSERIESID = TV_SERIES.ID LIMIT 1)");
                        MediaTableTVSeries.executeUpdate(connection, "DROP TABLE VIDEO_METADATA_RATED");
                        MediaTableTablesVersions.removeTableVersion(connection, "VIDEO_METADATA_RATED");
                    }
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE IF EXISTS TV_SERIES ADD COLUMN IF NOT EXISTS RATING DOUBLE PRECISION");
                    if (!MediaTableTVSeries.tableExists(connection, "VIDEO_METADATA_IMDB_RATING")) ** GOTO lbl153
                    prepSql = "UPDATE TV_SERIES SET RATING = ? WHERE ID = ?";
                    ps = connection.prepareStatement("SELECT * FROM VIDEO_METADATA_IMDB_RATING WHERE TVSERIESID IS NOT NULL");
                    try {
                        rs = ps.executeQuery();
                        block80: while (true) {
                            while (rs.next()) {
                                fileId = rs.getLong("TVSERIESID");
                                ratingStr = rs.getString("IMDBRATING");
                                try {
                                    rating = Double.valueOf(ratingStr);
                                    if (!(rating > 0.0)) continue block80;
                                    udpdateStatement = connection.prepareStatement(prepSql);
                                    try {
                                        udpdateStatement.setDouble(1, rating);
                                        udpdateStatement.setLong(2, fileId);
                                        udpdateStatement.execute();
                                        continue block80;
                                    }
                                    finally {
                                        if (udpdateStatement != null) {
                                            udpdateStatement.close();
                                        }
                                        continue block80;
                                    }
                                }
                                catch (NullPointerException | NumberFormatException rating) {
                                }
                            }
                            ** GOTO lbl151
                            {
                                continue block80;
                                break;
                            }
                            break;
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
lbl151:
                    // 1 sources

                    MediaTableTVSeries.executeUpdate(connection, "DROP TABLE VIDEO_METADATA_IMDB_RATING");
                    MediaTableTablesVersions.removeTableVersion(connection, "VIDEO_METADATA_IMDB_RATING");
lbl153:
                    // 2 sources

                    if (!MediaTableTVSeries.tableExists(connection, "VIDEO_METADATA_RELEASED")) ** GOTO lbl194
                    prepSql = "UPDATE TV_SERIES SET FIRSTAIRDATE = ? WHERE TV_SERIES.ID = ?";
                    ps = connection.prepareStatement("SELECT TV_SERIES.ID, TV_SERIES.FIRSTAIRDATE, VIDEO_METADATA_RELEASED.RELEASEDATE FROM TV_SERIES JOIN VIDEO_METADATA_RELEASED ON TV_SERIES.ID = VIDEO_METADATA_RELEASED.TVSERIESID");
                    try {
                        rs = ps.executeQuery();
                        block82: while (true) {
                            while (rs.next()) {
                                tvSeriesId = rs.getLong("ID");
                                firstAirDate = rs.getString("FIRSTAIRDATE");
                                releaseDate = rs.getString("RELEASEDATE");
                                if (firstAirDate != null || releaseDate == null) continue;
                                try {
                                    udpdateStatement = connection.prepareStatement(prepSql);
                                    try {
                                        udpdateStatement.setString(1, StringUtils.left(StringUtils.trimToEmpty(releaseDate), 10));
                                        udpdateStatement.setLong(2, tvSeriesId);
                                        udpdateStatement.execute();
                                        continue block82;
                                    }
                                    finally {
                                        if (udpdateStatement != null) {
                                            udpdateStatement.close();
                                        }
                                        continue block82;
                                    }
                                }
                                catch (IllegalArgumentException udpdateStatement) {
                                }
                            }
                            ** GOTO lbl192
                            {
                                continue block82;
                                break;
                            }
                            break;
                        }
                        finally {
                            if (rs != null) {
                                rs.close();
                            }
                        }
                    }
                    finally {
                        if (ps != null) {
                            ps.close();
                        }
                    }
lbl192:
                    // 1 sources

                    MediaTableTVSeries.executeUpdate(connection, "DROP TABLE VIDEO_METADATA_RELEASED");
                    MediaTableTablesVersions.removeTableVersion(connection, "VIDEO_METADATA_RELEASED");
lbl194:
                    // 2 sources

                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ALTER COLUMN IF EXISTS CREDITS CLOB");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ALTER COLUMN IF EXISTS EXTERNALIDS CLOB");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ALTER COLUMN IF EXISTS IMAGES CLOB");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ALTER COLUMN IF EXISTS NETWORKS CLOB");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ALTER COLUMN IF EXISTS OVERVIEW CLOB");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ALTER COLUMN IF EXISTS PRODUCTIONCOMPANIES CLOB");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ALTER COLUMN IF EXISTS PRODUCTIONCOUNTRIES CLOB");
                    MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ALTER COLUMN IF EXISTS SEASONS CLOB");
                    for (String column : new String[]{"STARTYEAR", "ENDYEAR"}) {
                        ps = connection.prepareStatement("SELECT * FROM TV_SERIES WHERE " + column + " IS NOT NULL", 1005, 1008);
                        try {
                            rs = ps.executeQuery();
                            try {
                                while (rs.next()) {
                                    yearStr = rs.getString(column);
                                    year = FileUtil.getYearFromYearString(yearStr);
                                    if (year != null) {
                                        rs.updateString(column, year.toString());
                                    } else {
                                        rs.updateNull(column);
                                    }
                                    rs.updateRow();
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        finally {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                        MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ALTER COLUMN IF EXISTS " + column + " INTEGER");
                    }
                    for (String column : new String[]{"FIRSTAIRDATE", "LASTAIRDATE"}) {
                        ps = connection.prepareStatement("SELECT * FROM TV_SERIES WHERE " + column + " IS NOT NULL", 1005, 1008);
                        try {
                            rs = ps.executeQuery();
                            try {
                                while (rs.next()) {
                                    dateStr = rs.getString(column);
                                    if (dateStr != null && dateStr.length() > 10) {
                                        dateStr = dateStr.substring(0, 10);
                                    }
                                    localDate = null;
                                    try {
                                        localDate = LocalDate.parse(dateStr);
                                    }
                                    catch (DateTimeParseException var11_44) {
                                        // empty catch block
                                    }
                                    if (localDate != null) {
                                        rs.updateString(column, localDate.toString());
                                    } else {
                                        rs.updateNull(column);
                                    }
                                    rs.updateRow();
                                }
                            }
                            finally {
                                if (rs != null) {
                                    rs.close();
                                }
                            }
                        }
                        finally {
                            if (ps != null) {
                                ps.close();
                            }
                        }
                        MediaTableTVSeries.executeUpdate(connection, "ALTER TABLE TV_SERIES ALTER COLUMN IF EXISTS " + column + " DATE");
                    }
                    continue block78;
                }
                default: {
                    throw new IllegalStateException(MediaTableTVSeries.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", new Object[]{"medias", "TV_SERIES", version, 12}));
                }
            }
        }
        try {
            MediaTableTablesVersions.setTableVersion(connection, "TV_SERIES", 12);
        }
        catch (SQLException e) {
            MediaTableTVSeries.LOGGER.error("Failed setting the table version of the {} for {}", (Object)"TV_SERIES", (Object)e.getMessage());
            throw new SQLException(e);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableTVSeries.execute(connection, "CREATE TABLE TV_SERIES(ID IDENTITY PRIMARY KEY, MODIFIED BIGINT, IMDBID VARCHAR(1024), TMDBID BIGINT, THUMBID BIGINT, THUMB_SRC VARCHAR(32), TITLE VARCHAR(1024) NOT NULL, STARTYEAR INTEGER, ENDYEAR INTEGER, TOTALSEASONS DOUBLE PRECISION, API_VERSION VARCHAR(1024), VOTES VARCHAR(1024), CREATEDBY VARCHAR, CREDITS CLOB, EXTERNALIDS CLOB, FIRSTAIRDATE DATE, HOMEPAGE VARCHAR, IMAGES CLOB, INPRODUCTION BOOLEAN, LANGUAGES VARCHAR, LASTAIRDATE DATE, NETWORKS CLOB, NUMBEROFEPISODES DOUBLE PRECISION, NUMBEROFSEASONS DOUBLE PRECISION, ORIGINCOUNTRY VARCHAR, ORIGINALLANGUAGE VARCHAR, ORIGINALTITLE VARCHAR, OVERVIEW CLOB, POSTER VARCHAR, PRODUCTIONCOMPANIES CLOB, PRODUCTIONCOUNTRIES CLOB, RATING DOUBLE PRECISION, RATED VARCHAR, SEASONS CLOB, SERIESTYPE VARCHAR, SPOKENLANGUAGES VARCHAR, STATUS VARCHAR, TAGLINE VARCHAR)", "CREATE INDEX IF NOT EXISTS TV_SERIES_IMDBID_IDX ON TV_SERIES(IMDBID)", "CREATE INDEX IF NOT EXISTS TV_SERIES_TMDBID_IDX ON TV_SERIES(TMDBID)", "CREATE INDEX IF NOT EXISTS TV_SERIES_TMDBID_IMDBID_API_VERSION_IDX ON TV_SERIES(TMDBID, IMDBID, API_VERSION)", "CREATE INDEX IF NOT EXISTS TV_SERIES_TITLE_IDX ON TV_SERIES(TITLE)", "CREATE INDEX IF NOT EXISTS TV_SERIES_THUMBID_IDX ON TV_SERIES(THUMBID)");
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static Long set(Connection connection, String title, Integer startYear) {
        if (StringUtils.isBlank(title)) {
            LOGGER.debug("Attempted to set TV series info with no series title");
            return null;
        }
        String sql = SQL_GET_BY_TITLE;
        if (startYear != null) {
            sql = SQL_GET_BY_TITLE_YEAR;
        }
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement selectStatement = connection.prepareStatement(sql, 1005, 1008);){
            Long l;
            block24: {
                ResultSet result;
                block22: {
                    Long l2;
                    block23: {
                        selectStatement.setString(1, title);
                        if (startYear != null) {
                            selectStatement.setInt(2, startYear);
                        }
                        result = selectStatement.executeQuery();
                        try {
                            if (!result.next()) break block22;
                            if (trace) {
                                LOGGER.trace("Found entry in TV_SERIES");
                            }
                            l2 = result.getLong(COL_ID);
                            if (result == null) break block23;
                        }
                        catch (Throwable throwable) {
                            if (result != null) {
                                try {
                                    result.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        result.close();
                    }
                    return l2;
                }
                if (trace) {
                    LOGGER.trace("Entry \"{}\" not found in TV_SERIES, inserting", (Object)title);
                }
                result.moveToInsertRow();
                result.updateString(COL_TITLE, title);
                if (startYear != null) {
                    result.updateInt(COL_STARTYEAR, (int)startYear);
                }
                result.insertRow();
                l = MediaTableTVSeries.set(connection, title, startYear);
                if (result == null) break block24;
                result.close();
            }
            return l;
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "writing", TABLE_NAME, "tv Series", e.getMessage());
            LOGGER.trace("", e);
            return null;
        }
    }

    public static void updateAPIMetadata(Connection connection, TvSeriesMetadata seriesMetadata, Long tvSeriesId) {
        if (connection == null || tvSeriesId == null || tvSeriesId < 0L) {
            return;
        }
        if (seriesMetadata == null) {
            LOGGER.warn("Couldn't write API data for \"{}\" to the database because there is no media information");
            return;
        }
        String title = seriesMetadata.getTitle();
        try {
            block32: {
                try (PreparedStatement ps = connection.prepareStatement(SQL_GET_BY_ID, 1003, 1008);){
                    ps.setLong(1, tvSeriesId);
                    LOGGER.trace("Inserting API metadata for TVSeries " + title);
                    try (ResultSet rs = ps.executeQuery();){
                        if (rs.next()) {
                            rs.updateString(COL_IMDBID, seriesMetadata.getIMDbID());
                            rs.updateString(COL_TITLE, title);
                            rs.updateString(COL_API_VERSION, seriesMetadata.getApiVersion());
                            rs.updateLong(COL_MODIFIED, System.currentTimeMillis());
                            if (seriesMetadata.getCreatedBy() != null) {
                                rs.updateString(COL_CREATEDBY, GSON.toJson(seriesMetadata.getCreatedBy()));
                            }
                            if (seriesMetadata.getCredits() != null) {
                                rs.updateString(COL_CREDITS, GSON.toJson(seriesMetadata.getCredits()));
                            }
                            MediaTableTVSeries.updateInteger(rs, COL_ENDYEAR, seriesMetadata.getEndYear());
                            if (seriesMetadata.getExternalIDs() != null) {
                                rs.updateString(COL_EXTERNALIDS, GSON.toJson(seriesMetadata.getExternalIDs()));
                            }
                            MediaTableTVSeries.updateDate(rs, COL_FIRSTAIRDATE, seriesMetadata.getFirstAirDate());
                            rs.updateString(COL_HOMEPAGE, seriesMetadata.getHomepage());
                            if (seriesMetadata.getImages() != null) {
                                rs.updateString(COL_IMAGES, GSON.toJson(seriesMetadata.getImages()));
                            }
                            if (seriesMetadata.isInProduction() != null) {
                                rs.updateBoolean(COL_INPRODUCTION, (boolean)seriesMetadata.isInProduction());
                            }
                            if (seriesMetadata.getLanguages() != null) {
                                rs.updateString(COL_LANGUAGES, GSON.toJson(seriesMetadata.getLanguages()));
                            }
                            MediaTableTVSeries.updateDate(rs, COL_LASTAIRDATE, seriesMetadata.getLastAirDate());
                            if (seriesMetadata.getNetworks() != null) {
                                rs.updateString(COL_NETWORKS, GSON.toJson(seriesMetadata.getNetworks()));
                            }
                            MediaTableTVSeries.updateDouble(rs, COL_NUMBEROFEPISODES, seriesMetadata.getNumberOfEpisodes());
                            MediaTableTVSeries.updateDouble(rs, COL_NUMBEROFSEASONS, seriesMetadata.getNumberOfSeasons());
                            if (seriesMetadata.getOriginCountry() != null) {
                                rs.updateString(COL_ORIGINCOUNTRY, GSON.toJson(seriesMetadata.getOriginCountry()));
                            }
                            rs.updateString(COL_ORIGINALLANGUAGE, seriesMetadata.getOriginalLanguage());
                            rs.updateString(COL_ORIGINALTITLE, seriesMetadata.getOriginalTitle());
                            rs.updateString(COL_OVERVIEW, seriesMetadata.getOverview());
                            rs.updateString(COL_POSTER, seriesMetadata.getPoster());
                            if (seriesMetadata.getProductionCompanies() != null) {
                                rs.updateString(COL_PRODUCTIONCOMPANIES, GSON.toJson(seriesMetadata.getProductionCompanies()));
                            }
                            if (seriesMetadata.getProductionCountries() != null) {
                                rs.updateString(COL_PRODUCTIONCOUNTRIES, GSON.toJson(seriesMetadata.getProductionCountries()));
                            }
                            rs.updateString(COL_RATED, seriesMetadata.getRated());
                            MediaTableTVSeries.updateDouble(rs, COL_RATING, seriesMetadata.getRating());
                            if (seriesMetadata.getSeasons() != null) {
                                rs.updateString(COL_SEASONS, GSON.toJson(seriesMetadata.getSeasons()));
                            }
                            rs.updateString(COL_SERIESTYPE, seriesMetadata.getSeriesType());
                            if (seriesMetadata.getSpokenLanguages() != null) {
                                rs.updateString(COL_SPOKENLANGUAGES, GSON.toJson(seriesMetadata.getSpokenLanguages()));
                            }
                            MediaTableTVSeries.updateInteger(rs, COL_STARTYEAR, seriesMetadata.getStartYear());
                            rs.updateString(COL_STATUS, seriesMetadata.getStatus());
                            rs.updateString(COL_TAGLINE, seriesMetadata.getTagline());
                            MediaTableTVSeries.updateLong(rs, COL_TMDBID, seriesMetadata.getTmdbId());
                            if (seriesMetadata.getTotalSeasons() != null) {
                                rs.updateDouble(COL_TOTALSEASONS, (double)seriesMetadata.getTotalSeasons());
                            }
                            MediaTableTVSeries.updateLong(rs, COL_THUMBID, seriesMetadata.getThumbnailId());
                            if (seriesMetadata.getThumbnailSource() != null) {
                                MediaTableTVSeries.updateString(rs, COL_THUMB_SRC, seriesMetadata.getThumbnailSource().toString(), 32);
                            }
                            rs.updateString(COL_VOTES, seriesMetadata.getVotes());
                            rs.updateRow();
                            connection.commit();
                            break block32;
                        }
                        LOGGER.debug("Couldn't find \"{}\" in the database when trying to store data from our API", (Object)title);
                        return;
                    }
                }
            }
            MediaTableVideoMetadataActors.set(connection, null, seriesMetadata.getActors(), tvSeriesId);
            MediaTableVideoMetadataAwards.set(connection, null, seriesMetadata.getAwards(), tvSeriesId);
            MediaTableVideoMetadataCountries.set(connection, null, seriesMetadata.getCountries(), tvSeriesId);
            MediaTableVideoMetadataDirectors.set(connection, null, seriesMetadata.getDirectors(), tvSeriesId);
            MediaTableVideoMetadataGenres.set(connection, null, seriesMetadata.getGenres(), tvSeriesId);
            MediaTableVideoMetadataRatings.set(connection, null, seriesMetadata.getRatings(), tvSeriesId);
            connection.commit();
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "medias", "inserting API data to TV series entry", title, TABLE_NAME, e.getMessage());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TvSeriesMetadata getTvSeriesMetadata(Connection connection, Long tvSeriesId) {
        if (connection == null) return null;
        if (tvSeriesId == null) return null;
        if (tvSeriesId < 0L) {
            return null;
        }
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement selectStatement = connection.prepareStatement(SQL_GET_BY_ID);){
            selectStatement.setLong(1, tvSeriesId);
            if (trace) {
                LOGGER.trace("Searching TV_SERIES with \"{}\"", (Object)selectStatement);
            }
            try (ResultSet rs = selectStatement.executeQuery();){
                if (!rs.next()) return null;
                TvSeriesMetadata tvSeriesMetadata = MediaTableTVSeries.getTvSeriesMetadata(connection, rs);
                return tvSeriesMetadata;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in TV_SERIES for \"{}\": {}", (Object)tvSeriesId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TvSeriesMetadata getTvSeriesMetadataFromImdbId(Connection connection, String imdbId) {
        if (connection == null) return null;
        if (imdbId == null) {
            return null;
        }
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement selectStatement = connection.prepareStatement(SQL_GET_BY_IMDBID);){
            selectStatement.setString(1, imdbId);
            if (trace) {
                LOGGER.trace("Searching TV_SERIES with \"{}\"", (Object)selectStatement);
            }
            try (ResultSet rs = selectStatement.executeQuery();){
                if (!rs.next()) return null;
                TvSeriesMetadata tvSeriesMetadata = MediaTableTVSeries.getTvSeriesMetadata(connection, rs);
                return tvSeriesMetadata;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in TV_SERIES for \"{}\": {}", (Object)imdbId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static TvSeriesMetadata getTvSeriesMetadataFromTmdbId(Connection connection, Long tmdbId) {
        if (connection == null) return null;
        if (tmdbId == null) {
            return null;
        }
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement selectStatement = connection.prepareStatement(SQL_GET_BY_TMDBID);){
            selectStatement.setLong(1, tmdbId);
            if (trace) {
                LOGGER.trace("Searching TV_SERIES with \"{}\"", (Object)selectStatement);
            }
            try (ResultSet rs = selectStatement.executeQuery();){
                if (!rs.next()) return null;
                TvSeriesMetadata tvSeriesMetadata = MediaTableTVSeries.getTvSeriesMetadata(connection, rs);
                return tvSeriesMetadata;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in TV_SERIES for \"{}\": {}", (Object)tmdbId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    private static TvSeriesMetadata getTvSeriesMetadata(Connection connection, ResultSet resultSet) throws SQLException {
        DLNAThumbnail thumbnail;
        Long tvSeriesId = resultSet.getLong(COL_ID);
        TvSeriesMetadata metadata = new TvSeriesMetadata();
        metadata.setTvSeriesId(tvSeriesId);
        metadata.setActors(MediaTableVideoMetadataActors.getActorsForTvSeries(connection, tvSeriesId));
        metadata.setApiVersion(resultSet.getString(COL_API_VERSION));
        metadata.setAwards(MediaTableVideoMetadataAwards.getValueForTvSeries(connection, tvSeriesId));
        metadata.setCountries(MediaTableVideoMetadataCountries.getCountriesForTvSeries(connection, tvSeriesId));
        metadata.setCreatedBy(resultSet.getString(COL_CREATEDBY));
        metadata.setCredits(resultSet.getString(COL_CREDITS));
        metadata.setDirectors(MediaTableVideoMetadataDirectors.getDirectorsForTvSeries(connection, tvSeriesId));
        metadata.setEndYear(MediaTableTVSeries.toInteger(resultSet, COL_ENDYEAR));
        metadata.setExternalIDs(resultSet.getString(COL_EXTERNALIDS));
        metadata.setFirstAirDate(MediaTableTVSeries.getLocalDate(resultSet, COL_FIRSTAIRDATE));
        metadata.setGenres(MediaTableVideoMetadataGenres.getGenresForTvSeries(connection, tvSeriesId));
        metadata.setHomepage(resultSet.getString(COL_HOMEPAGE));
        metadata.setImages(resultSet.getString(COL_IMAGES));
        metadata.setIMDbID(resultSet.getString(COL_IMDBID));
        metadata.setInProduction(resultSet.getBoolean(COL_INPRODUCTION));
        metadata.setLanguages(resultSet.getString(COL_LANGUAGES));
        metadata.setLastAirDate(MediaTableTVSeries.getLocalDate(resultSet, COL_LASTAIRDATE));
        metadata.setNetworks(resultSet.getString(COL_NETWORKS));
        metadata.setNumberOfEpisodes(MediaTableTVSeries.toDouble(resultSet, COL_NUMBEROFEPISODES));
        metadata.setNumberOfSeasons(MediaTableTVSeries.toDouble(resultSet, COL_NUMBEROFSEASONS));
        metadata.setOriginalLanguage(resultSet.getString(COL_ORIGINALLANGUAGE));
        metadata.setOriginalTitle(resultSet.getString(COL_ORIGINALTITLE));
        metadata.setOriginCountry(resultSet.getString(COL_ORIGINCOUNTRY));
        metadata.setOverview(resultSet.getString(COL_OVERVIEW));
        metadata.setPoster(resultSet.getString(COL_POSTER));
        metadata.setProductionCompanies(resultSet.getString(COL_PRODUCTIONCOMPANIES));
        metadata.setProductionCountries(resultSet.getString(COL_PRODUCTIONCOUNTRIES));
        metadata.setRated(resultSet.getString(COL_RATED));
        metadata.setRating(MediaTableTVSeries.toDouble(resultSet, COL_RATING));
        metadata.setRatings(MediaTableVideoMetadataRatings.getRatingsForTvSeries(connection, tvSeriesId));
        metadata.setSeasons(resultSet.getString(COL_SEASONS));
        metadata.setSeriesType(resultSet.getString(COL_SERIESTYPE));
        metadata.setSpokenLanguages(resultSet.getString(COL_SPOKENLANGUAGES));
        metadata.setStartYear(MediaTableTVSeries.toInteger(resultSet, COL_STARTYEAR));
        metadata.setStatus(resultSet.getString(COL_STATUS));
        metadata.setTagline(resultSet.getString(COL_TAGLINE));
        metadata.setTitle(resultSet.getString(COL_TITLE));
        metadata.setTmdbId(MediaTableTVSeries.toLong(resultSet, COL_TMDBID));
        metadata.setTotalSeasons(MediaTableTVSeries.toDouble(resultSet, COL_TOTALSEASONS));
        metadata.setThumbnailId(MediaTableTVSeries.toLong(resultSet, COL_THUMBID));
        metadata.setThumbnailSource(resultSet.getString(COL_THUMB_SRC));
        metadata.setVotes(resultSet.getString(COL_VOTES));
        metadata.setTranslations(MediaTableVideoMetadataLocalized.getAllVideoMetadataLocalized(connection, tvSeriesId, true));
        metadata.ensureHavingTranslation(null);
        if (metadata.getPoster(null) != null && !metadata.getThumbnailSource().equals((Object)ThumbnailSource.TMDB_LOC) && (thumbnail = JavaHttpClient.getThumbnail(metadata.getPoster(null))) != null) {
            Long thumbnailId = ThumbnailStore.getIdForTvSeries(thumbnail, tvSeriesId, ThumbnailSource.TMDB_LOC);
            metadata.setThumbnailSource(ThumbnailSource.TMDB_LOC);
            metadata.setThumbnailId(thumbnailId);
        }
        return metadata;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long getTmdbIdByTitle(Connection connection, String title, Integer startYear) {
        if (connection == null) return null;
        if (StringUtils.isBlank(title)) {
            return null;
        }
        Long id = MediaTableTVSeries.getIdBySimilarTitle(connection, title, startYear);
        if (id == null) return null;
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_TMDBID_BY_ID);){
            statement.setLong(1, id);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                Long l = MediaTableTVSeries.toLong(resultSet, COL_TMDBID);
                return l;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "medias", "reading Tmdb Id from title", title, TABLE_NAME, e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long getIdByIMDbID(Connection connection, String imdbID) {
        String latestVersion = null;
        if (CONFIGURATION.getExternalNetwork()) {
            latestVersion = APIUtils.getApiDataSeriesVersion();
        }
        String sql = latestVersion != null ? SQL_GET_ID_BY_IMDBID_API_VERSION : SQL_GET_ID_BY_IMDBID;
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, imdbID);
            if (latestVersion != null) {
                statement.setString(2, latestVersion);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                if (resultSet.next()) {
                    Long l = MediaTableTVSeries.toLong(resultSet, COL_ID);
                    return l;
                }
                LOGGER.trace("Did not find tvSeriesId by IMDb ID using query: {}", (Object)statement.toString());
                return null;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "medias", "reading tv series from imdbID", imdbID, TABLE_NAME, e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getImages(Connection connection, Long tvSeriesId) {
        if (connection == null) return null;
        if (tvSeriesId == null) return null;
        if (tvSeriesId < 0L) {
            return null;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_IMAGES_BY_ID);){
            statement.setLong(1, tvSeriesId);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                String string = resultSet.getString(COL_IMAGES);
                return string;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "medias", "reading images from id", tvSeriesId, TABLE_NAME, e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    public static Long getIdBySimilarTitle(Connection connection, String title, Integer startYear) {
        String simplifiedTitle = FileUtil.getSimplifiedShowName(title);
        Long tvSeriesId = MediaTableTVSeries.getIdBySimplifiedTitle(connection, simplifiedTitle, startYear);
        if (tvSeriesId == null) {
            tvSeriesId = MediaTableTVSeries.getIdByOriginalTitle(connection, title, startYear);
        }
        if (tvSeriesId == null) {
            tvSeriesId = MediaTableVideoMetadataLocalized.getTvSeriesIdFromTitle(connection, simplifiedTitle);
        }
        return tvSeriesId;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Long getIdBySimplifiedTitle(Connection connection, String simplifiedTitle, Integer startYear) {
        String sql = SQL_GET_ID_BY_SIMPLIFIEDTITLE;
        if (startYear != null) {
            sql = SQL_GET_ID_BY_SIMPLIFIEDTITLE_YEAR;
        }
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, simplifiedTitle);
            if (startYear != null) {
                statement.setInt(2, startYear);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                Long l = resultSet.getLong(COL_ID);
                return l;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "medias", "reading id from title", simplifiedTitle, TABLE_NAME, e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Long getIdByOriginalTitle(Connection connection, String simplifiedTitle, Integer startYear) {
        String sql = SQL_GET_ID_BY_ORIGINALTITLE;
        if (startYear != null) {
            sql = SQL_GET_ID_BY_ORIGINALTITLE_YEAR;
        }
        try (PreparedStatement statement = connection.prepareStatement(sql);){
            statement.setString(1, simplifiedTitle);
            if (startYear != null) {
                statement.setInt(2, startYear);
            }
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                Long l = resultSet.getLong(COL_ID);
                return l;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "medias", "reading id from original title", simplifiedTitle, TABLE_NAME, e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static VideoMetadataLocalized getTvSeriesMetadataUnLocalized(Connection connection, Long tvSeriesId) {
        if (connection == null) return null;
        if (tvSeriesId == null) return null;
        if (tvSeriesId < 0L) {
            return null;
        }
        try (PreparedStatement selectStatement = connection.prepareStatement(SQL_GET_BY_ID);){
            selectStatement.setLong(1, tvSeriesId);
            try (ResultSet rs = selectStatement.executeQuery();){
                if (!rs.next()) return null;
                VideoMetadataLocalized result = new VideoMetadataLocalized();
                result.setHomepage(rs.getString(COL_HOMEPAGE));
                result.setOverview(rs.getString(COL_OVERVIEW));
                result.setTagline(rs.getString(COL_TAGLINE));
                result.setTitle(rs.getString(COL_TITLE));
                VideoMetadataLocalized videoMetadataLocalized = result;
                return videoMetadataLocalized;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in TV_SERIES for \"{}\": {}", (Object)tvSeriesId, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    public static void updateThumbnailId(Connection connection, Long id, Long thumbId, String thumbnailSource) {
        try (PreparedStatement ps = connection.prepareStatement(SQL_UPDATE_THUMBID);){
            ps.setLong(1, thumbId);
            ps.setString(2, thumbnailSource);
            ps.setLong(3, id);
            ps.executeUpdate();
            LOGGER.trace("TV series THUMBID updated to {} for {}", (Object)thumbId, (Object)id);
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "updating cached thumbnail", TABLE_NAME, id, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static void resetLocalizedThumbnail(Connection connection) {
        try (PreparedStatement ps = connection.prepareStatement(SQL_UPDATE_THUMB_SRC_LOC);){
            ps.setString(1, ThumbnailSource.TMDB.toString());
            ps.setString(2, ThumbnailSource.TMDB_LOC.toString());
            ps.executeUpdate();
            LOGGER.trace("Thumbnail source updated from {} to {}", (Object)ThumbnailSource.TMDB_LOC.toString(), (Object)ThumbnailSource.TMDB.toString());
        }
        catch (SQLException se) {
            LOGGER.error("Error updating thumbnail source: {}", (Object)se.getMessage());
            LOGGER.trace("", se);
        }
    }

    private static void updateTmdbId(Connection connection, long tvSeriesId, long tmdbId) {
        try (PreparedStatement ps = connection.prepareStatement(SQL_UPDATE_TMDBID);){
            ps.setLong(1, tmdbId);
            ps.setLong(2, tvSeriesId);
            ps.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error("Failed to update TMDB ID for \"{}\" to \"{}\": {}", tvSeriesId, tmdbId, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getTitleFromId(Connection connection, Long tvSeriesId) {
        if (connection == null) return null;
        if (tvSeriesId == null) return null;
        if (tvSeriesId < 0L) {
            return null;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_TITLE_BY_ID);){
            statement.setLong(1, tvSeriesId);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                String str = resultSet.getString(COL_TITLE);
                String string = StringUtils.isBlank(str) ? "###" : str;
                return string;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "reading", TABLE_NAME, "SimilarTVSeriesName", e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    public static void unsetApiIdsForId(Connection connection, Long id) {
        try (PreparedStatement statement = connection.prepareStatement(SQL_UPDATE_IMDBID_TMDBID_NULL);){
            statement.setLong(1, id);
            int row = statement.executeUpdate();
            LOGGER.trace("Removed IMDb ID and TMDB ID from {} in TV_SERIES for ID \"{}\"", (Object)row, (Object)id);
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "removing entry", TABLE_NAME, id, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Boolean isFullyPlayed(Connection connection, String title, int userId) {
        try {
            ResultSet resultSet;
            try (PreparedStatement statement = connection.prepareStatement(SQL_GET_PARTIALLY_PLAYED);){
                statement.setString(1, title);
                statement.setInt(2, userId);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Searching TV_SERIES with \"{}\"", (Object)statement);
                }
                resultSet = statement.executeQuery();
                try {
                    if (!resultSet.next()) {
                        Boolean bl = false;
                        return bl;
                    }
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            statement = connection.prepareStatement(SQL_GET_NOT_FULLYPLAYED);
            try {
                statement.setString(1, title);
                statement.setInt(2, userId);
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("Searching TV_SERIES with \"{}\"", (Object)statement);
                }
                resultSet = statement.executeQuery();
                try {
                    if (!resultSet.next()) return true;
                    Boolean bl = false;
                    return bl;
                }
                finally {
                    if (resultSet != null) {
                        resultSet.close();
                    }
                }
            }
            finally {
                if (statement != null) {
                    statement.close();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "looking up TV series status", TABLE_NAME, title, e.getMessage());
            LOGGER.trace("", e);
        }
        return true;
    }

    public static synchronized void cleanup(Connection connection) {
        try (PreparedStatement ps = connection.prepareStatement("DELETE FROM TV_SERIES WHERE NOT EXISTS (SELECT VIDEO_METADATA.TVSERIESID FROM VIDEO_METADATA WHERE VIDEO_METADATA.TVSERIESID = TV_SERIES.ID LIMIT 1);");){
            ps.execute();
        }
        catch (SQLException se) {
            LOGGER.error(null, se);
        }
    }
}

