/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import com.google.common.primitives.UnsignedInteger;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableMetadata;
import net.pms.database.MediaTableTablesVersions;
import net.pms.store.MediaStoreId;
import net.pms.store.StoreResource;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTableStoreIds
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableStoreIds.class);
    public static final String TABLE_NAME = "STORE_IDS";
    private static final int TABLE_VERSION = 2;
    private static final String COL_ID = "ID";
    private static final String COL_PARENT_ID = "PARENT_ID";
    private static final String COL_NAME = "NAME";
    private static final String COL_OBJECT_TYPE = "OBJECT_TYPE";
    private static final String COL_UPDATE_ID = "UPDATE_ID";
    private static final String TABLE_COL_ID = "STORE_IDS.ID";
    private static final String TABLE_COL_PARENT_ID = "STORE_IDS.PARENT_ID";
    private static final String TABLE_COL_NAME = "STORE_IDS.NAME";
    private static final String TABLE_COL_OBJECT_TYPE = "STORE_IDS.OBJECT_TYPE";
    private static final String SQL_GET_ALL_ID = "SELECT * FROM STORE_IDS WHERE STORE_IDS.ID = ?";
    private static final String SQL_GET_ALL_PARENTID_NAME = "SELECT * FROM STORE_IDS WHERE STORE_IDS.PARENT_ID = ? AND STORE_IDS.NAME = ?";
    private static final String SQL_GET_ID_NAME = "SELECT ID FROM STORE_IDS WHERE STORE_IDS.NAME = ?";
    private static final String SQL_GET_NAME_ID = "SELECT NAME FROM STORE_IDS WHERE STORE_IDS.ID = ?";
    private static final String SQL_GET_ID_TYPE = "SELECT ID FROM STORE_IDS WHERE STORE_IDS.OBJECT_TYPE = ?";
    private static final String SQL_GET_ID_NAME_TYPE = "SELECT ID FROM STORE_IDS WHERE STORE_IDS.NAME = ? AND STORE_IDS.OBJECT_TYPE = ?";
    private static final String SQL_GET_ID_NAME_TYPE_PARENTTYPE = "SELECT ID FROM STORE_IDS WHERE STORE_IDS.NAME = ? AND STORE_IDS.OBJECT_TYPE = ? AND STORE_IDS.PARENT_ID IN (SELECT ID FROM STORE_IDS WHERE STORE_IDS.OBJECT_TYPE = ?)";
    private static final String SQL_UPDATE_UPDATEID_ID = "UPDATE STORE_IDS SET UPDATE_ID = ? WHERE STORE_IDS.ID = ?";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableStoreIds.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version == null) {
                version = 1;
            }
            if (version < 2) {
                MediaTableStoreIds.upgradeTable(connection, version);
            } else if (version > 2) {
                LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
            }
        } else {
            MediaTableStoreIds.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 2);
        }
        MediaTableStoreIds.ensureSystemId(connection);
    }

    private static void upgradeTable(Connection connection, Integer currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 2);
        block5: for (int version = currentVersion.intValue(); version < 2; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    LOGGER.trace("Creating index STORE_IDS_NAMEOBJECT_TYPEPARENT_ID_IDX");
                    MediaTableStoreIds.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS STORE_IDS_NAMEOBJECT_TYPEPARENT_ID_IDX ON STORE_IDS(NAME, OBJECT_TYPE, PARENT_ID)");
                    LOGGER.trace("Creating index STORE_IDS_NAMEOBJECT_TYPE_IDX");
                    MediaTableStoreIds.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS STORE_IDS_NAMEOBJECT_TYPE_IDX ON STORE_IDS(NAME, OBJECT_TYPE)");
                    continue block5;
                }
                default: {
                    throw new IllegalStateException(MediaTableStoreIds.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 2));
                }
            }
        }
        try {
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 2);
        }
        catch (SQLException e) {
            LOGGER.error("Failed setting the table version of the {} for {}", (Object)TABLE_NAME, (Object)e.getMessage());
            LOGGER.error("Please use the 'Reset the cache' button on the 'Navigation Settings' tab, close UMS and start it again.");
            throw new SQLException(e);
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableStoreIds.execute(connection, "CREATE TABLE STORE_IDS (ID BIGINT GENERATED BY DEFAULT AS IDENTITY(START WITH 100) PRIMARY KEY, PARENT_ID BIGINT NOT NULL, NAME VARCHAR NOT NULL, OBJECT_TYPE VARCHAR NOT NULL, UPDATE_ID BIGINT)", "CREATE INDEX IF NOT EXISTS STORE_IDS_PARENT_ID_IDX ON STORE_IDS(PARENT_ID)", "CREATE INDEX IF NOT EXISTS STORE_IDS_NAME_IDX ON STORE_IDS(NAME)", "CREATE INDEX IF NOT EXISTS STORE_IDS_NAMEOBJECT_TYPEPARENT_ID_IDX ON STORE_IDS(NAME, OBJECT_TYPE, PARENT_ID)", "CREATE INDEX IF NOT EXISTS STORE_IDS_NAMEOBJECT_TYPE_IDX ON STORE_IDS(NAME, OBJECT_TYPE)");
        MediaTableStoreIds.ensureSystemId(connection);
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static MediaStoreId getResourceMediaStoreId(Connection connection, StoreResource resource) {
        if (connection == null || resource == null || resource.getParent() == null || resource.getParent().getLongId() == null) {
            return null;
        }
        long parentId = resource.getParent().getLongId();
        String name = resource.getSystemName();
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ALL_PARENTID_NAME, 1003, 1008);){
            MediaStoreId mediaStoreId;
            block19: {
                ResultSet elements;
                block17: {
                    MediaStoreId mediaStoreId2;
                    block18: {
                        stmt.setLong(1, parentId);
                        stmt.setString(2, name);
                        elements = stmt.executeQuery();
                        try {
                            if (!elements.next()) break block17;
                            mediaStoreId2 = MediaTableStoreIds.getMediaStoreId(connection, elements.getLong(COL_ID));
                            if (elements == null) break block18;
                        }
                        catch (Throwable throwable) {
                            if (elements != null) {
                                try {
                                    elements.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        elements.close();
                    }
                    return mediaStoreId2;
                }
                elements.moveToInsertRow();
                elements.updateLong(COL_PARENT_ID, parentId);
                elements.updateString(COL_NAME, name);
                elements.updateString(COL_OBJECT_TYPE, resource.getClass().getSimpleName());
                elements.updateLong(COL_UPDATE_ID, 0L);
                elements.insertRow();
                mediaStoreId = MediaTableStoreIds.getResourceMediaStoreId(connection, resource);
                if (elements == null) break block19;
                elements.close();
            }
            return mediaStoreId;
        }
        catch (SQLException e) {
            LOGGER.error("Database error in STORE_IDS for \"{}\": {}", (Object)resource.getDisplayName(), (Object)e.getMessage());
            LOGGER.trace("", e);
            return null;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static MediaStoreId getMediaStoreId(Connection connection, long id) {
        if (connection == null) {
            return null;
        }
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ALL_ID);){
            stmt.setLong(1, id);
            try (ResultSet elements = stmt.executeQuery();){
                if (!elements.next()) return null;
                MediaStoreId result = new MediaStoreId();
                result.setId(elements.getLong(COL_ID));
                result.setParentId(elements.getLong(COL_PARENT_ID));
                result.setName(elements.getString(COL_NAME));
                result.setObjectType(elements.getString(COL_OBJECT_TYPE));
                result.setUpdateId(elements.getLong(COL_UPDATE_ID));
                MediaStoreId mediaStoreId = result;
                return mediaStoreId;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in STORE_IDS for \"{}\": {}", (Object)id, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    public static void setMediaStoreUpdateId(Connection connection, long id, long updateId) {
        if (connection == null) {
            return;
        }
        try (PreparedStatement stmt = connection.prepareStatement(SQL_UPDATE_UPDATEID_ID);){
            stmt.setLong(1, updateId);
            stmt.setLong(2, id);
            stmt.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error("Database error in STORE_IDS for \"{}\": {}", (Object)id, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getMediaStoreNameForId(Connection connection, String id) {
        if (connection == null) {
            return null;
        }
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_NAME_ID);){
            stmt.setLong(1, Long.parseLong(id));
            try (ResultSet elements = stmt.executeQuery();){
                if (!elements.next()) return null;
                String string = elements.getString(COL_NAME);
                return string;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in STORE_IDS for id \"{}\": {}", (Object)id, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    public static List<Long> getMediaStoreIdsForName(Connection connection, String name) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (connection == null) {
            return result;
        }
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ID_NAME);){
            stmt.setString(1, name);
            try (ResultSet elements = stmt.executeQuery();){
                while (elements.next()) {
                    result.add(elements.getLong(COL_ID));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in STORE_IDS for name \"{}\": {}", (Object)name, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static List<Long> getMediaStoreIdsForName(Connection connection, String name, String objectType) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (connection == null) {
            return result;
        }
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ID_NAME_TYPE);){
            stmt.setString(1, name);
            stmt.setString(2, objectType);
            try (ResultSet elements = stmt.executeQuery();){
                while (elements.next()) {
                    result.add(elements.getLong(COL_ID));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in STORE_IDS for name \"{}\" with type \"{}\": {}", name, objectType, e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    public static List<Long> getMediaStoreIdsForName(Connection connection, String name, String objectType, String parentType) {
        ArrayList<Long> result = new ArrayList<Long>();
        if (connection == null) {
            return result;
        }
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ID_NAME_TYPE_PARENTTYPE);){
            stmt.setString(1, name);
            stmt.setString(2, objectType);
            stmt.setString(3, parentType);
            try (ResultSet elements = stmt.executeQuery();){
                while (elements.next()) {
                    result.add(elements.getLong(COL_ID));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in STORE_IDS for name \"{}\" with type \"{}\" and parent type \"{}\": {}", name, objectType, parentType, e.getMessage());
            LOGGER.trace("", e);
        }
        return result;
    }

    private static void ensureSystemId(Connection connection) {
        if (connection == null) {
            return;
        }
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ALL_ID, 1003, 1008);){
            UnsignedInteger systemUpdateId;
            stmt.setLong(1, -1L);
            try (ResultSet elements = stmt.executeQuery();){
                if (!elements.next()) {
                    systemUpdateId = MediaTableStoreIds.getPreviousSystemUpdateId(connection);
                    elements.moveToInsertRow();
                    elements.updateLong(COL_ID, -1L);
                    elements.updateLong(COL_PARENT_ID, -1L);
                    elements.updateString(COL_NAME, "System");
                    elements.updateString(COL_OBJECT_TYPE, "");
                    elements.updateLong(COL_UPDATE_ID, systemUpdateId.longValue());
                    elements.insertRow();
                }
            }
            stmt.clearParameters();
            stmt.setLong(1, 0L);
            elements = stmt.executeQuery();
            try {
                if (!elements.next()) {
                    systemUpdateId = MediaTableStoreIds.getPreviousSystemUpdateId(connection);
                    elements.moveToInsertRow();
                    elements.updateLong(COL_ID, 0L);
                    elements.updateLong(COL_PARENT_ID, -1L);
                    elements.updateString(COL_NAME, "Root");
                    elements.updateString(COL_OBJECT_TYPE, "MediaStore");
                    elements.updateLong(COL_UPDATE_ID, systemUpdateId.longValue());
                    elements.insertRow();
                }
            }
            finally {
                if (elements != null) {
                    elements.close();
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in STORE_IDS for \"{}\": {}", (Object)"System id", (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    private static UnsignedInteger getPreviousSystemUpdateId(Connection connection) {
        UnsignedInteger systemUpdateId;
        String systemUpdateIdFromDb = MediaTableMetadata.getMetadataValue(connection, "SystemUpdateID");
        if (systemUpdateIdFromDb != null) {
            try {
                systemUpdateId = UnsignedInteger.valueOf(systemUpdateIdFromDb);
            }
            catch (NumberFormatException ex) {
                LOGGER.debug("" + ex);
                systemUpdateId = UnsignedInteger.ZERO;
            }
        } else {
            systemUpdateId = UnsignedInteger.ZERO;
        }
        return systemUpdateId;
    }
}

