/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.io.File;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import net.pms.Messages;
import net.pms.configuration.sharedcontent.SharedContentConfiguration;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableAudioMetadata;
import net.pms.database.MediaTableAudiotracks;
import net.pms.database.MediaTableChapters;
import net.pms.database.MediaTableContainerFiles;
import net.pms.database.MediaTableFilesStatus;
import net.pms.database.MediaTableSubtracks;
import net.pms.database.MediaTableTVSeries;
import net.pms.database.MediaTableTablesVersions;
import net.pms.database.MediaTableThumbnails;
import net.pms.database.MediaTableVideoMetadata;
import net.pms.database.MediaTableVideotracks;
import net.pms.dlna.DLNAThumbnail;
import net.pms.external.JavaHttpClient;
import net.pms.gui.GuiManager;
import net.pms.image.ImageInfo;
import net.pms.media.MediaInfo;
import net.pms.store.MediaStoreIds;
import net.pms.store.ThumbnailSource;
import net.pms.store.ThumbnailStore;
import net.pms.util.FileUtil;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaTableFiles
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableFiles.class);
    public static final String TABLE_NAME = "FILES";
    private static final int TABLE_VERSION = 43;
    public static final String COL_ID = "ID";
    public static final String COL_THUMBID = "THUMBID";
    private static final String COL_THUMB_SRC = "THUMB_SRC";
    private static final String COL_FORMAT_TYPE = "FORMAT_TYPE";
    public static final String COL_FILENAME = "FILENAME";
    private static final String COL_MODIFIED = "MODIFIED";
    private static final String COL_PARSER = "PARSER";
    private static final String COL_MEDIA_SIZE = "MEDIA_SIZE";
    private static final String COL_CONTAINER = "CONTAINER";
    private static final String COL_MIMETYPE = "MIMETYPE";
    private static final String COL_TITLECONTAINER = "TITLECONTAINER";
    private static final String COL_DURATION = "DURATION";
    private static final String COL_BITRATE = "BITRATE";
    private static final String COL_FRAMERATE = "FRAMERATE";
    private static final String COL_ASPECTRATIODVD = "ASPECTRATIODVD";
    private static final String COL_IMAGEINFO = "IMAGEINFO";
    private static final String COL_IMAGECOUNT = "IMAGECOUNT";
    public static final String TABLE_COL_ID = "FILES.ID";
    public static final String TABLE_COL_FORMAT_TYPE = "FILES.FORMAT_TYPE";
    public static final String TABLE_COL_FILENAME = "FILES.FILENAME";
    public static final String TABLE_COL_MODIFIED = "FILES.MODIFIED";
    public static final String TABLE_COL_THUMBID = "FILES.THUMBID";
    public static final String TABLE_COL_DURATION = "FILES.DURATION";
    public static final String SQL_LEFT_JOIN_TABLE_FILES_STATUS = " LEFT JOIN FILES_STATUS ON FILES.FILENAME = FILES_STATUS.FILENAME";
    public static final String SQL_LEFT_JOIN_TABLE_THUMBNAILS = " LEFT JOIN THUMBNAILS ON FILES.THUMBID = THUMBNAILS.ID";
    public static final String SQL_LEFT_JOIN_TABLE_AUDIO_METADATA = " LEFT JOIN AUDIO_METADATA ON FILES.ID = AUDIO_METADATA.FILEID";
    public static final String SQL_LEFT_JOIN_TABLE_VIDEO_METADATA = " LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID";
    public static final String REFERENCE_TABLE_COL_ID = "FILES(ID)";
    private static final String SQL_GET_ROW_COUNT = "SELECT COUNT(*) FROM FILES";
    private static final String SQL_GET_FILENAME_MODIFIED_ID = "SELECT FILES.FILENAME, FILES.MODIFIED, FILES.ID FROM FILES";
    private static final String SQL_GET_ALL_BY_FILENAME = "SELECT * FROM FILES WHERE FILES.FILENAME = ? LIMIT 1";
    private static final String SQL_GET_ALL_FILENAME_MODIFIED = "SELECT * FROM FILES LEFT JOIN THUMBNAILS ON FILES.THUMBID = THUMBNAILS.ID WHERE FILES.FILENAME = ? AND FILES.MODIFIED = ? LIMIT 1";
    private static final String SQL_GET_FILENAME_BY_ID = "SELECT FILES.FILENAME FROM FILES WHERE FILES.ID = ?";
    private static final String SQL_GET_FILENAME_LIKE = "SELECT FILES.FILENAME FROM FILES WHERE FILES.FILENAME LIKE STRINGENCODE(?) || '%'";
    private static final String SQL_GET_ID_FILENAME = "SELECT FILES.ID FROM FILES WHERE FILES.FILENAME = ? LIMIT 1";
    private static final String SQL_GET_FORMAT_TYPE_BY_FILENAME = "SELECT FILES.FORMAT_TYPE FROM FILES WHERE FILES.FILENAME = ? LIMIT 1";
    private static final String SQL_GET_ID_FILENAME_MODIFIED = "SELECT FILES.ID FROM FILES WHERE FILES.FILENAME = ? AND FILES.MODIFIED = ? LIMIT 1";
    private static final String SQL_UPDATE_THUMBID_BY_ID = "UPDATE FILES SET THUMBID = ?, THUMB_SRC = ? WHERE FILES.ID = ?";
    private static final String SQL_UPDATE_THUMB_SRC_LOC = "UPDATE FILES SET THUMB_SRC = ? WHERE THUMB_SRC = ?";
    private static final String SQL_DELETE_BY_ID = "DELETE FROM FILES WHERE FILES.ID = ?";
    private static final String SQL_DELETE_BY_FILENAME = "DELETE FROM FILES WHERE FILES.FILENAME = ?";
    private static final String SQL_DELETE_BY_FILENAME_LIKE = "DELETE FROM FILES WHERE FILES.FILENAME LIKE STRINGENCODE(?) || '%'";
    private static final String SQL_GET_THUMBNAIL_BY_TITLE = "SELECT FILES.THUMBID FROM FILES LEFT JOIN VIDEO_METADATA ON FILES.ID = VIDEO_METADATA.FILEID WHERE VIDEO_METADATA.TITLE = ? LIMIT 1";
    public static final String CHILD_ID = "FILEID";
    public static final String NONAME = "###";
    private static final int SIZE_CONTAINER = 32;

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableFiles.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version == null) {
                version = 24;
            }
            if (version < 43) {
                MediaTableFiles.upgradeTable(connection, version);
            } else if (version > 43) {
                LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS.", (Object)"medias", (Object)TABLE_NAME);
            }
        } else {
            MediaTableFiles.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 43);
        }
    }

    @SuppressFBWarnings(value={"IIL_PREPARE_STATEMENT_IN_LOOP"})
    private static void upgradeTable(Connection connection, Integer currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 43);
        boolean force = false;
        try {
            for (int version = currentVersion.intValue(); version < 43; ++version) {
                LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
                switch (version) {
                    case 23: {
                        String[] sb;
                        try (Statement statement = connection.createStatement();){
                            sb = new StringBuilder();
                            sb.append("UPDATE ").append(TABLE_NAME).append(" SET ").append("IMDBID = NULL, ").append("MEDIA_YEAR = NULL, ").append("MOVIEORSHOWNAME = NULL, ").append("MOVIEORSHOWNAMESIMPLE = NULL, ").append("TVSEASON = NULL, ").append("TVEPISODENUMBER = NULL, ").append("TVEPISODENAME = NULL, ").append("ISTVEPISODE = NULL, ").append("EXTRAINFORMATION = NULL").append(" WHERE ").append("NOT ").append("ISTVEPISODE");
                            statement.execute(sb.toString());
                        }
                        LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, version);
                        break;
                    }
                    case 24: {
                        LOGGER.trace("Deleting index TYPE_ISTV");
                        MediaTableFiles.executeUpdate(connection, "DROP INDEX IF EXISTS TYPE_ISTV");
                        LOGGER.trace("Deleting index TYPE_ISTV_SIMPLENAME");
                        MediaTableFiles.executeUpdate(connection, "DROP INDEX IF EXISTS TYPE_ISTV_SIMPLENAME");
                        LOGGER.trace("Deleting index TYPE_ISTV_NAME");
                        MediaTableFiles.executeUpdate(connection, "DROP INDEX IF EXISTS TYPE_ISTV_NAME");
                        LOGGER.trace("Deleting index TYPE_ISTV_NAME_SEASON");
                        MediaTableFiles.executeUpdate(connection, "DROP INDEX IF EXISTS TYPE_ISTV_NAME_SEASON");
                        LOGGER.trace("Deleting index TYPE_ISTV_YEAR_STEREOSCOPY");
                        MediaTableFiles.executeUpdate(connection, "DROP INDEX IF EXISTS TYPE_ISTV_YEAR_STEREOSCOPY");
                        LOGGER.trace("Deleting index TYPE_WIDTH_HEIGHT");
                        MediaTableFiles.executeUpdate(connection, "DROP INDEX IF EXISTS TYPE_WIDTH_HEIGHT");
                        LOGGER.trace("Deleting index TYPE_MODIFIED");
                        MediaTableFiles.executeUpdate(connection, "DROP INDEX IF EXISTS TYPE_MODIFIED");
                        if (MediaTableFiles.isColumnExist(connection, TABLE_NAME, "TYPE")) {
                            LOGGER.trace("Renaming column name TYPE to FORMAT_TYPE");
                            MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ALTER COLUMN `TYPE`  RENAME TO FORMAT_TYPE");
                        }
                        if (MediaTableFiles.isColumnExist(connection, TABLE_NAME, "YEAR")) {
                            LOGGER.trace("Renaming column name YEAR to MEDIA_YEAR");
                            MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ALTER COLUMN `YEAR`  RENAME TO MEDIA_YEAR");
                        }
                        if (MediaTableFiles.isColumnExist(connection, TABLE_NAME, "SIZE")) {
                            LOGGER.trace("Renaming column name SIZE to MEDIA_SIZE");
                            MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ALTER COLUMN `SIZE`  RENAME TO MEDIA_SIZE");
                        }
                        LOGGER.trace("Creating index FORMAT_TYPE");
                        MediaTableFiles.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS FORMAT_TYPE on FILES (FORMAT_TYPE)");
                        LOGGER.trace("Creating index FORMAT_TYPE_WIDTH_HEIGHT");
                        MediaTableFiles.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS FORMAT_TYPE_WIDTH_HEIGHT on FILES (FORMAT_TYPE, WIDTH, HEIGHT)");
                        LOGGER.trace("Creating index FORMAT_TYPE_MODIFIED");
                        MediaTableFiles.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS FORMAT_TYPE_MODIFIED on FILES (FORMAT_TYPE, MODIFIED)");
                        break;
                    }
                    case 25: {
                        String[] sb;
                        try (Statement statement = connection.createStatement();){
                            sb = new StringBuilder();
                            sb.append("UPDATE ").append(TABLE_NAME).append(" SET ").append("IMDBID = NULL, ").append("MEDIA_YEAR = NULL, ").append("MOVIEORSHOWNAME = NULL, ").append("MOVIEORSHOWNAMESIMPLE = NULL, ").append("TVSEASON = NULL, ").append("TVEPISODENUMBER = NULL, ").append("TVEPISODENAME = NULL, ").append("ISTVEPISODE = NULL, ").append("EXTRAINFORMATION = NULL").append(" WHERE ").append("NOT ISTVEPISODE");
                            statement.execute(sb.toString());
                        }
                        LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, version);
                        break;
                    }
                    case 26: {
                        LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, version);
                        break;
                    }
                    case 27: {
                        LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, version);
                        break;
                    }
                    case 28: {
                        LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, version);
                        break;
                    }
                    case 29: {
                        String[] sb;
                        try (Statement statement = connection.createStatement();){
                            sb = new StringBuilder();
                            sb.append("UPDATE ").append(TABLE_NAME).append(" SET ").append("IMDBID = NULL, ").append("MEDIA_YEAR = NULL, ").append("MOVIEORSHOWNAME = NULL, ").append("MOVIEORSHOWNAMESIMPLE = NULL, ").append("TVSEASON = NULL, ").append("TVEPISODENUMBER = NULL, ").append("TVEPISODENAME = NULL, ").append("ISTVEPISODE = NULL, ").append("EXTRAINFORMATION = NULL").append(" WHERE ").append("FILENAME REGEXP '[0-9]of[0-9]'");
                            statement.execute(sb.toString());
                        }
                        LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, version);
                        break;
                    }
                    case 30: {
                        LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, version);
                        break;
                    }
                    case 31: {
                        MediaTableFiles.executeUpdate(connection, "DROP INDEX IF EXISTS FORMAT_TYPE_ISTV_YEAR_STEREOSCOPY");
                        LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, version);
                        break;
                    }
                    case 32: {
                        String[] indexes;
                        MediaTableVideoMetadata.checkTable(connection);
                        for (String index : indexes = new String[]{"IDX_FILENAME_MODIFIED_IMDBID", "FILENAME_MODIFIED_VERSION_IMDBID", "FORMAT_TYPE_ISTV", "FORMAT_TYPE_ISTV_NAME", "FORMAT_TYPE_ISTV_SIMPLENAME", "FORMAT_TYPE_ISTV_NAME_SEASON", "FORMAT_TYPE_ISTV_YEAR_STEREOSCOPY", "FORMAT_TYPE_ISTV_YEAR_DURATION_STEREOSCOPY"}) {
                            MediaTableFiles.executeUpdate(connection, "DROP INDEX IF EXISTS " + index);
                        }
                        if (MediaTableFiles.isColumnExist(connection, TABLE_NAME, "VERSION")) {
                            String[] badJsonColumns;
                            for (String badJsonColumn : badJsonColumns = new String[]{"CREDITS", "EXTERNALIDS", "PRODUCTIONCOMPANIES", "PRODUCTIONCOUNTRIES"}) {
                                if (!MediaTableFiles.isColumnExist(connection, TABLE_NAME, badJsonColumn)) continue;
                                MediaTableFiles.executeUpdate(connection, "UPDATE FILES SET IMDBID = NULL WHERE RIGHT(" + badJsonColumn + ", 1) = ','");
                            }
                        }
                        String[] columns = new String[]{"IMDBID", "MEDIA_YEAR", "MOVIEORSHOWNAME", "MOVIEORSHOWNAMESIMPLE", "TVSEASON", "TVEPISODENUMBER", "TVEPISODENAME", "ISTVEPISODE", "EXTRAINFORMATION", "VERSION", "BUDGET", "CREDITS", "EXTERNALIDS", "HOMEPAGE", "IMAGES", "ORIGINALLANGUAGE", "ORIGINALTITLE", "PRODUCTIONCOMPANIES", "PRODUCTIONCOUNTRIES", "REVENUE"};
                        if (MediaTableFiles.isColumnExist(connection, TABLE_NAME, "MOVIEORSHOWNAMESIMPLE")) {
                            StringBuilder sb = new StringBuilder();
                            StringBuilder sbselect = new StringBuilder();
                            sb.append("INSERT INTO ").append("VIDEO_METADATA");
                            sb.append(" (FILEID");
                            sbselect.append(COL_ID);
                            for (String column : columns) {
                                if (!MediaTableFiles.isColumnExist(connection, TABLE_NAME, column)) continue;
                                sb.append(", ");
                                if ("VERSION".equals(column)) {
                                    sb.append("API_VERSION");
                                } else {
                                    sb.append(column);
                                }
                                sbselect.append(", ").append(column);
                            }
                            sb.append(") ");
                            sb.append("SELECT ").append(sbselect.toString()).append(" FROM ").append(TABLE_NAME);
                            sb.append(" WHERE MOVIEORSHOWNAMESIMPLE IS NOT NULL");
                            sb.append(" AND ID NOT IN (SELECT FILEID FROM ").append("VIDEO_METADATA").append(")");
                            MediaTableFiles.executeUpdate(connection, sb.toString());
                        }
                        String[] stringArray = columns;
                        int n = stringArray.length;
                        for (int index = 0; index < n; ++index) {
                            String column = stringArray[index];
                            MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES DROP COLUMN IF EXISTS " + column);
                        }
                        MediaTableFiles.executeUpdate(connection, "CREATE INDEX IF NOT EXISTS FILES_THUMBID_IDX ON FILES(THUMBID)");
                        LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, version);
                        break;
                    }
                    case 33: {
                        LOGGER.trace("Adding HDRFORMAT column");
                        MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ADD COLUMN IF NOT EXISTS HDRFORMAT VARCHAR");
                        break;
                    }
                    case 34: {
                        LOGGER.trace("Adding HDRFORMATCOMPATIBILITY column");
                        MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ADD COLUMN IF NOT EXISTS HDRFORMATCOMPATIBILITY VARCHAR");
                        break;
                    }
                    case 35: {
                        MediaTableFiles.executeUpdate(connection, "ALTER INDEX IF EXISTS IDX_FILE RENAME TO FILES_FILENAME_MODIFIED_IDX");
                        MediaTableFiles.executeUpdate(connection, "ALTER INDEX IF EXISTS FORMAT_TYPE RENAME TO FILES_FORMAT_TYPE_IDX");
                        MediaTableFiles.executeUpdate(connection, "ALTER INDEX IF EXISTS FORMAT_TYPE_MODIFIED RENAME TO FILES_FORMAT_TYPE_MODIFIED_IDX");
                        break;
                    }
                    case 36: {
                        String[] columns;
                        MediaTableFiles.executeUpdate(connection, "DROP INDEX IF EXISTS FORMAT_TYPE_WIDTH_HEIGHT");
                        MediaTableFiles.executeUpdate(connection, "DROP INDEX IF EXISTS FILES_FORMAT_TYPE_WIDTH_HEIGHT_IDX");
                        for (String column : columns = new String[]{COL_FRAMERATE, "ASPECTRATIOCONTAINER", "ASPECTRATIOVIDEOTRACK", "REFRAMES", "AVCLEVEL", "WIDTH", "HEIGHT", "CODECV", "FRAMERATEMODE", "MATRIXCOEFFICIENTS", "TITLEVIDEOTRACK", "VIDEOTRACKCOUNT", "STEREOSCOPY", "BITDEPTH", "HDRFORMAT", "HDRFORMATCOMPATIBILITY", "PIXELASPECTRATIO", "SCANTYPE", "SCANORDER", "MUXINGMODE"}) {
                            MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES DROP COLUMN IF EXISTS " + column);
                        }
                        LOGGER.trace("Adding back FRAMERATE column");
                        MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ADD COLUMN IF NOT EXISTS FRAMERATE DOUBLE PRECISION");
                        LOGGER.trace("Adding PARSER column");
                        MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ADD COLUMN IF NOT EXISTS PARSER VARCHAR(32)");
                        MediaTableFiles.ensureCascadeConstraint(connection, "AUDIO_METADATA", CHILD_ID, TABLE_NAME, COL_ID);
                        MediaTableFiles.ensureCascadeConstraint(connection, "AUDIOTRACKS", CHILD_ID, TABLE_NAME, COL_ID);
                        MediaTableFiles.ensureCascadeConstraint(connection, "CHAPTERS", CHILD_ID, TABLE_NAME, COL_ID);
                        MediaTableFiles.ensureCascadeConstraint(connection, "SUBTRACKS", CHILD_ID, TABLE_NAME, COL_ID);
                        MediaTableFiles.ensureCascadeConstraint(connection, "VIDEOTRACKS", CHILD_ID, TABLE_NAME, COL_ID);
                        MediaTableFiles.ensureCascadeConstraint(connection, "VIDEO_METADATA", CHILD_ID, TABLE_NAME, COL_ID);
                        break;
                    }
                    case 37: {
                        MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ADD COLUMN IF NOT EXISTS MIMETYPE VARCHAR(32)");
                        break;
                    }
                    case 38: {
                        MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ALTER COLUMN IF EXISTS COL_MIMETYPE RENAME TO MIMETYPE");
                        break;
                    }
                    case 39: {
                        MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ADD COLUMN IF NOT EXISTS THUMB_SRC VARCHAR(32)");
                        break;
                    }
                    case 40: {
                        MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ALTER COLUMN IF EXISTS ID BIGINT");
                        break;
                    }
                    case 41: {
                        MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ALTER COLUMN IF EXISTS ID IDENTITY");
                        MediaTableFiles.executeUpdate(connection, "ALTER TABLE FILES ALTER COLUMN ID RESTART WITH (SELECT MAX(ID) + 1 FROM FILES)");
                        break;
                    }
                    case 42: {
                        String[] sb;
                        try (Statement statement = connection.createStatement();){
                            sb = new StringBuilder();
                            sb.append("UPDATE ").append(TABLE_NAME).append(" SET ").append("PARSER = NULL").append(" WHERE ").append("PARSER='FFmpeg'");
                            statement.execute(sb.toString());
                        }
                        LOGGER.trace("Updated database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, version);
                        break;
                    }
                    default: {
                        force = true;
                    }
                }
                if (force) break;
            }
            try {
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 43);
            }
            catch (SQLException e) {
                LOGGER.error("Failed setting the table version of the {} for {}", (Object)TABLE_NAME, (Object)e.getMessage());
                throw new SQLException(e);
            }
        }
        catch (SQLException se) {
            LOGGER.error("Failed upgrading database \"{}\" table {} for {}", "medias", TABLE_NAME, se.getMessage());
            LOGGER.trace("", se);
            force = true;
        }
        if (force) {
            LOGGER.debug("Database will be (re)initialized");
            try {
                LOGGER.error("Deleting data from table: {}", (Object)TABLE_NAME);
                MediaTableFiles.executeUpdate(connection, "DELETE FROM FILES");
                MediaDatabase.dropCascadeConstraint(connection, TABLE_NAME);
                MediaDatabase.dropTable(connection, TABLE_NAME);
                MediaTableFiles.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 43);
                MediaTableFiles.ensureCascadeConstraint(connection, "AUDIO_METADATA", CHILD_ID, TABLE_NAME, COL_ID);
                MediaTableFiles.ensureCascadeConstraint(connection, "AUDIOTRACKS", CHILD_ID, TABLE_NAME, COL_ID);
                MediaTableFiles.ensureCascadeConstraint(connection, "CHAPTERS", CHILD_ID, TABLE_NAME, COL_ID);
                MediaTableFiles.ensureCascadeConstraint(connection, "SUBTRACKS", CHILD_ID, TABLE_NAME, COL_ID);
                MediaTableFiles.ensureCascadeConstraint(connection, "VIDEOTRACKS", CHILD_ID, TABLE_NAME, COL_ID);
                MediaTableFiles.ensureCascadeConstraint(connection, "VIDEO_METADATA", CHILD_ID, TABLE_NAME, COL_ID);
            }
            catch (SQLException se) {
                LOGGER.error("SQL error while (re)initializing tables: {}", (Object)se.getMessage());
                LOGGER.trace("", se);
            }
        }
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableFiles.execute(connection, "CREATE TABLE FILES (ID IDENTITY, THUMBID BIGINT, THUMB_SRC VARCHAR(32), FILENAME VARCHAR(1024) NOT NULL UNIQUE , MODIFIED TIMESTAMP NOT NULL, PARSER VARCHAR(32), FORMAT_TYPE INTEGER, MEDIA_SIZE NUMERIC, CONTAINER VARCHAR(32), MIMETYPE VARCHAR(32), TITLECONTAINER VARCHAR(255), DURATION DOUBLE PRECISION, BITRATE INTEGER, FRAMERATE DOUBLE PRECISION, ASPECTRATIODVD VARCHAR(255), IMAGECOUNT INTEGER, IMAGEINFO OTHER)");
        LOGGER.trace("Creating index on FILENAME, MODIFIED");
        MediaTableFiles.execute(connection, "CREATE UNIQUE INDEX FILES_FILENAME_MODIFIED_IDX ON FILES (FILENAME, MODIFIED)");
        LOGGER.trace("Creating index on FORMAT_TYPE");
        MediaTableFiles.execute(connection, "CREATE INDEX IF NOT EXISTS FILES_FORMAT_TYPE_IDX ON FILES (FORMAT_TYPE)");
        LOGGER.trace("Creating index on FORMAT_TYPE, MODIFIED");
        MediaTableFiles.execute(connection, "CREATE INDEX IF NOT EXISTS FILES_FORMAT_TYPE_MODIFIED_IDX ON FILES (FORMAT_TYPE, MODIFIED)");
        LOGGER.trace("Creating index on THUMBID");
        MediaTableFiles.execute(connection, "CREATE INDEX IF NOT EXISTS FILES_THUMBID_IDX ON FILES(THUMBID)");
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Long getFileId(Connection connection, String filename, long modified) {
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_ID_FILENAME_MODIFIED);){
            statement.setString(1, filename);
            statement.setTimestamp(2, new Timestamp(modified));
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                Long l = resultSet.getLong(1);
                return l;
            }
        }
        catch (SQLException se) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "getting fileId for {}", TABLE_NAME, filename, se.getMessage());
            LOGGER.trace("", se);
        }
        return null;
    }

    public static Long getFileId(String filename) {
        Long l;
        block9: {
            if (StringUtils.isBlank(filename)) {
                return null;
            }
            Connection connection = MediaDatabase.getConnectionIfAvailable();
            try {
                l = MediaTableFiles.getFileId(connection, filename);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("cannot get fileId for {} ", (Object)filename, (Object)e);
                    return null;
                }
            }
            connection.close();
        }
        return l;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected static Long getFileId(Connection connection, String filename) {
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_ID_FILENAME);){
            statement.setString(1, filename);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                Long l = resultSet.getLong(1);
                return l;
            }
        }
        catch (SQLException se) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "getting fileId for {}", TABLE_NAME, filename, se.getMessage());
            LOGGER.trace("", se);
        }
        return null;
    }

    public static Integer getFormatType(String filename) {
        Integer n;
        block9: {
            if (StringUtils.isBlank(filename)) {
                return null;
            }
            Connection connection = MediaDatabase.getConnectionIfAvailable();
            try {
                n = MediaTableFiles.getFormatType(connection, filename);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("cannot get format type for {} ", (Object)filename, (Object)e);
                    return null;
                }
            }
            connection.close();
        }
        return n;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private static Integer getFormatType(Connection connection, String filename) {
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_FORMAT_TYPE_BY_FILENAME);){
            statement.setString(1, filename);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                Integer n = resultSet.getInt(1);
                return n;
            }
        }
        catch (SQLException se) {
            LOGGER.error("Database \"{}\" error while {} in \"{}\" for \"{}\": {}", "medias", "getting format type for {}", TABLE_NAME, filename, se.getMessage());
            LOGGER.trace("", se);
        }
        return null;
    }

    public static MediaInfo getMediaInfo(Connection connection, String filename, long modified) throws IOException, SQLException {
        MediaInfo media = null;
        try (PreparedStatement stmt = connection.prepareStatement(SQL_GET_ALL_FILENAME_MODIFIED);){
            stmt.setString(1, filename);
            stmt.setTimestamp(2, new Timestamp(modified));
            try (ResultSet rs = stmt.executeQuery();){
                if (rs.next()) {
                    DLNAThumbnail thumbnail;
                    media = new MediaInfo();
                    long fileId = rs.getLong(COL_ID);
                    media.setFileId(fileId);
                    media.setMediaParser(rs.getString(COL_PARSER));
                    media.setSize(rs.getLong(COL_MEDIA_SIZE));
                    media.setContainer(rs.getString(COL_CONTAINER));
                    media.setMimeType(rs.getString(COL_MIMETYPE));
                    media.setTitle(rs.getString(COL_TITLECONTAINER));
                    media.setDuration(MediaTableFiles.toDouble(rs, COL_DURATION));
                    media.setBitRate(rs.getInt(COL_BITRATE));
                    media.setFrameRate(MediaTableFiles.toDouble(rs, COL_FRAMERATE));
                    media.setThumbnailId(MediaTableFiles.toLong(rs, COL_THUMBID));
                    media.setThumbnailSource(rs.getString(COL_THUMB_SRC));
                    media.setAspectRatioDvdIso(rs.getString(COL_ASPECTRATIODVD));
                    media.setImageInfo((ImageInfo)rs.getObject(COL_IMAGEINFO));
                    media.setImageCount(rs.getInt(COL_IMAGECOUNT));
                    media.setAudioTracks(MediaTableAudiotracks.getAudioTracks(connection, fileId));
                    media.setVideoTracks(MediaTableVideotracks.getVideoTracks(connection, fileId));
                    media.setSubtitlesTracks(MediaTableSubtracks.getSubtitleTracks(connection, fileId));
                    media.setChapters(MediaTableChapters.getChapters(connection, fileId));
                    media.setAudioMetadata(MediaTableAudioMetadata.getAudioMetadataByFileId(connection, fileId));
                    media.setVideoMetadata(MediaTableVideoMetadata.getVideoMetadataByFileId(connection, fileId));
                    if (media.getVideoMetadata() != null && media.getVideoMetadata().getPoster() != null && !media.getThumbnailSource().equals((Object)ThumbnailSource.TMDB_LOC) && (thumbnail = JavaHttpClient.getThumbnail(media.getVideoMetadata().getPoster())) != null) {
                        Long thumbnailId = ThumbnailStore.getId(thumbnail);
                        if (!Objects.equals(thumbnailId, media.getThumbnailId())) {
                            media.setThumbnailId(thumbnailId);
                            MediaStoreIds.incrementUpdateIdForFilename(connection, filename);
                        }
                        media.setThumbnailSource(ThumbnailSource.TMDB_LOC);
                        MediaTableFiles.updateThumbnailId(connection, fileId, thumbnailId, ThumbnailSource.TMDB_LOC.toString());
                    }
                }
            }
        }
        return media;
    }

    public static Long getOrInsertFileId(String filename, Long modified, int type) {
        Long l;
        block9: {
            if (StringUtils.isBlank(filename)) {
                return null;
            }
            Connection connection = MediaDatabase.getConnectionIfAvailable();
            try {
                l = MediaTableFiles.getOrInsertFileId(connection, filename, modified, type);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("cannot get fileId for {} ", (Object)filename, (Object)e);
                    return null;
                }
            }
            connection.close();
        }
        return l;
    }

    private static Long getOrInsertFileId(Connection connection, String filename, long modified, int type) {
        if (connection == null || StringUtils.isBlank(filename)) {
            return null;
        }
        Long fileId = MediaTableFiles.getFileId(connection, filename, modified);
        if (fileId != null) {
            return fileId;
        }
        try {
            return MediaTableFiles.insertOrUpdateData(connection, filename, modified, type, null);
        }
        catch (SQLException ex) {
            return null;
        }
    }

    public static Long insertOrUpdateData(String name, long modified, int type, MediaInfo media) {
        Long l;
        block9: {
            if (StringUtils.isBlank(name)) {
                return null;
            }
            Connection connection = MediaDatabase.getConnectionIfAvailable();
            try {
                l = MediaTableFiles.insertOrUpdateData(connection, name, modified, type, media);
                if (connection == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (connection != null) {
                        try {
                            connection.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("cannot store data for {} ", (Object)name, (Object)e);
                    return null;
                }
            }
            connection.close();
        }
        return l;
    }

    public static Long insertOrUpdateData(Connection connection, String name, long modified, int type, MediaInfo media) throws SQLException {
        Long fileId = null;
        try {
            try (PreparedStatement ps = connection.prepareStatement(SQL_GET_ALL_BY_FILENAME, 1003, 1008);){
                ps.setString(1, name);
                try (ResultSet result = ps.executeQuery();){
                    boolean isCreatingNewRecord;
                    boolean bl = isCreatingNewRecord = !result.next();
                    if (isCreatingNewRecord) {
                        result.moveToInsertRow();
                        result.updateString(COL_FILENAME, name);
                    } else {
                        fileId = result.getLong(COL_ID);
                    }
                    result.updateTimestamp(COL_MODIFIED, new Timestamp(modified));
                    result.updateInt(COL_FORMAT_TYPE, type);
                    if (media != null) {
                        MediaTableFiles.updateString(result, COL_PARSER, media.getMediaParser(), 255);
                        MediaTableFiles.updateLong(result, COL_THUMBID, media.getThumbnailId());
                        if (media.getThumbnailSource() != null) {
                            MediaTableFiles.updateString(result, COL_THUMB_SRC, media.getThumbnailSource().toString(), 32);
                        }
                        result.updateLong(COL_MEDIA_SIZE, media.getSize());
                        MediaTableFiles.updateString(result, COL_CONTAINER, media.getContainer(), 32);
                        MediaTableFiles.updateString(result, COL_MIMETYPE, media.getMimeType(), 32);
                        MediaTableFiles.updateString(result, COL_TITLECONTAINER, media.getTitle(), 255);
                        MediaTableFiles.updateDouble(result, COL_DURATION, media.getDurationInSeconds());
                        MediaTableFiles.updateInteger(result, COL_BITRATE, media.getBitRate());
                        MediaTableFiles.updateDouble(result, COL_FRAMERATE, media.getFrameRate());
                        result.updateInt(COL_IMAGECOUNT, media.getImageCount());
                        MediaTableFiles.updateString(result, COL_ASPECTRATIODVD, media.getAspectRatioDvdIso(), 255);
                        MediaTableFiles.updateObject(result, COL_IMAGEINFO, media.getImageInfo());
                    }
                    if (isCreatingNewRecord) {
                        result.insertRow();
                        fileId = MediaTableFiles.getFileId(connection, name);
                    } else {
                        result.updateRow();
                    }
                }
            }
            if (media != null && fileId != null) {
                media.setFileId(fileId);
                MediaTableVideoMetadata.insertOrUpdateVideoMetadata(connection, fileId, media, false);
                MediaTableVideotracks.insertOrUpdateVideoTracks(connection, fileId, media);
                MediaTableAudiotracks.insertOrUpdateAudioTracks(connection, fileId, media);
                MediaTableAudioMetadata.insertOrUpdateAudioMetadata(connection, fileId, media);
                MediaTableSubtracks.insertOrUpdateSubtitleTracks(connection, fileId, media);
                MediaTableChapters.insertOrUpdateChapters(connection, fileId, media);
            }
        }
        catch (SQLException se) {
            if (se.getErrorCode() == 23505) {
                throw new SQLException(String.format("Duplicate key while adding \"%s\" to the cache: %s", name, se.getMessage()), se);
            }
            throw se;
        }
        finally {
            if (fileId != null) {
                MediaStoreIds.incrementUpdateIdForFilename(connection, name);
            }
        }
        return fileId;
    }

    public static void removeMediaEntry(Connection connection, String pathToFile, boolean removeStatus) {
        try {
            MediaTableFiles.removeMedia(connection, pathToFile, false, removeStatus);
        }
        catch (SQLException e) {
            LOGGER.error("An error occurred while trying to remove \"{}\" from the database: {}", (Object)pathToFile, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static void removeMediaEntriesInFolder(Connection connection, String pathToFolder) {
        try {
            MediaTableFiles.removeMedia(connection, pathToFolder, true, true);
        }
        catch (SQLException e) {
            LOGGER.error("An error occurred while trying to remove files matching \"{}\" from the database: {}", (Object)pathToFolder, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static void removeMedia(Connection connection, String filename, boolean useLike, boolean removeStatus) throws SQLException {
        if (StringUtils.isEmpty(filename)) {
            return;
        }
        MediaTableFiles.deleteRowsInFilesTable(connection, filename, useLike);
        if (removeStatus) {
            MediaTableFilesStatus.remove(connection, filename, useLike);
        }
    }

    public static void deleteRowsInFilesTable(Connection connection, String filename, boolean useLike) throws SQLException {
        if (StringUtils.isEmpty(filename)) {
            return;
        }
        LOGGER.trace("Deleting rows from FILES table where the filename is \"{}\"", (Object)filename);
        try (PreparedStatement ps = connection.prepareStatement(useLike ? SQL_DELETE_BY_FILENAME_LIKE : SQL_DELETE_BY_FILENAME, 1003, 1008);){
            ps.setString(1, filename);
            int rows = ps.executeUpdate();
            LOGGER.trace("Deleted {} rows from FILES", (Object)rows);
        }
    }

    public static void removeEntry(String filename) {
        if (StringUtils.isBlank(filename)) {
            return;
        }
        try (Connection connection = MediaDatabase.getConnectionIfAvailable();){
            MediaTableFiles.removeEntry(connection, filename);
        }
        catch (Exception e) {
            LOGGER.error("cannot remove entry {} ", (Object)filename, (Object)e);
        }
    }

    private static void removeEntry(Connection connection, String filename) {
        if (connection == null || StringUtils.isBlank(filename)) {
            return;
        }
        Long fileId = MediaTableFiles.getFileId(connection, filename);
        if (fileId != null) {
            MediaTableFiles.removeEntry(connection, fileId);
        }
    }

    protected static void removeEntry(Connection connection, long fileId) {
        if (connection == null) {
            return;
        }
        List<Long> entries = MediaTableContainerFiles.getContainerFileIds(connection, fileId);
        MediaTableContainerFiles.deleteContainer(connection, fileId);
        for (Long entryId : entries) {
            if (MediaTableContainerFiles.isInContainer(connection, entryId).booleanValue()) continue;
            MediaTableFiles.removeEntry(connection, entryId);
        }
        MediaTableContainerFiles.deleteEntry(connection, fileId);
        try (PreparedStatement ps = connection.prepareStatement(SQL_DELETE_BY_ID);){
            ps.setLong(1, fileId);
            ps.executeUpdate();
        }
        catch (SQLException se) {
            LOGGER.error("An error occurred while trying to remove \"{}\" from the database: {}", (Object)fileId, (Object)se.getMessage());
            LOGGER.trace("", se);
        }
    }

    public static void updateThumbnailId(Connection connection, long fileId, Long thumbId, String thumbnailSource) {
        try (PreparedStatement ps = connection.prepareStatement(SQL_UPDATE_THUMBID_BY_ID);){
            ps.setLong(1, thumbId);
            ps.setString(2, thumbnailSource);
            ps.setLong(3, fileId);
            ps.executeUpdate();
            LOGGER.trace("THUMBID updated to {} for {}", (Object)thumbId, (Object)fileId);
        }
        catch (SQLException se) {
            LOGGER.error("Error updating cached thumbnail for \"{}\": {}", (Object)se.getMessage());
            LOGGER.trace("", se);
        }
    }

    public static void resetLocalizedThumbnail(Connection connection) {
        try (PreparedStatement ps = connection.prepareStatement(SQL_UPDATE_THUMB_SRC_LOC);){
            ps.setString(1, ThumbnailSource.TMDB.toString());
            ps.setString(2, ThumbnailSource.TMDB_LOC.toString());
            ps.executeUpdate();
            LOGGER.trace("Thumbnail source updated from {} to {}", (Object)ThumbnailSource.TMDB_LOC.toString(), (Object)ThumbnailSource.TMDB.toString());
        }
        catch (SQLException se) {
            LOGGER.error("Error updating thumbnail source: {}", (Object)se.getMessage());
            LOGGER.trace("", se);
        }
    }

    public static List<String> getStrings(Connection connection, String sql) {
        ArrayList<String> list = new ArrayList<String>();
        LinkedHashSet<String> set = new LinkedHashSet<String>();
        try (PreparedStatement ps = connection.prepareStatement((String)(sql.toLowerCase().startsWith("select") || sql.toLowerCase().startsWith("with") ? sql : "SELECT FILENAME FROM FILES WHERE " + sql));
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String str = rs.getString(1);
                if (StringUtils.isBlank(str)) {
                    set.add(NONAME);
                    continue;
                }
                set.add(str);
            }
        }
        catch (SQLException se) {
            LOGGER.error(null, se);
            return null;
        }
        list.addAll(set);
        return list;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void cleanup(Connection connection) {
        try {
            ResultSet rs;
            int dbCount = 0;
            try (PreparedStatement ps = connection.prepareStatement(SQL_GET_ROW_COUNT);){
                rs = ps.executeQuery();
                try {
                    if (rs.next()) {
                        dbCount = rs.getInt(1);
                    }
                }
                finally {
                    if (rs != null) {
                        rs.close();
                    }
                }
            }
            if (dbCount > 0) {
                GuiManager.setStatusLine(Messages.getString("CleaningUpDatabase") + " 0%");
                ps = connection.prepareStatement(SQL_GET_FILENAME_MODIFIED_ID, 1003, 1008);
                try {
                    rs = ps.executeQuery();
                    try {
                        List<File> sharedFolders = SharedContentConfiguration.getSharedFolders();
                        ArrayList<Long> removedIds = new ArrayList<Long>();
                        int oldpercent = 0;
                        int i = 0;
                        while (rs.next()) {
                            int newpercent;
                            String filename = rs.getString(COL_FILENAME);
                            Long id = MediaTableFiles.toLong(rs, COL_ID);
                            if (Boolean.FALSE.equals(MediaTableContainerFiles.isInContainer(connection, id)) && !FileUtil.isUrl(filename)) {
                                long modified = rs.getTimestamp(COL_MODIFIED).getTime();
                                File file = new File(filename);
                                if (!file.exists() || file.lastModified() != modified) {
                                    LOGGER.trace("Removing the file {} from our database because it is no longer on the hard drive", (Object)filename);
                                    rs.deleteRow();
                                    removedIds.add(id);
                                } else {
                                    boolean isFileStillShared = false;
                                    for (File folder : sharedFolders) {
                                        if (!filename.contains(folder.getAbsolutePath())) continue;
                                        isFileStillShared = true;
                                        break;
                                    }
                                    if (!isFileStillShared) {
                                        LOGGER.trace("Removing the file {} from our database because it is no longer shared", (Object)filename);
                                        rs.deleteRow();
                                        removedIds.add(id);
                                    }
                                }
                            }
                            if ((newpercent = ++i * 100 / dbCount) <= oldpercent) continue;
                            GuiManager.setStatusLine(Messages.getString("CleaningUpDatabase") + newpercent + "%");
                            oldpercent = newpercent;
                        }
                        for (Long id : removedIds) {
                            MediaTableFiles.removeEntry(connection, id);
                        }
                    }
                    finally {
                        if (rs != null) {
                            rs.close();
                        }
                    }
                }
                finally {
                    if (ps != null) {
                        ps.close();
                    }
                }
                GuiManager.setStatusLine(null);
            }
            ps = connection.prepareStatement("DELETE FROM FILES_STATUS WHERE NOT EXISTS (SELECT FILES.ID FROM FILES WHERE FILES.FILENAME = FILES_STATUS.FILENAME);");
            try {
                ps.execute();
            }
            finally {
                if (ps != null) {
                    ps.close();
                }
            }
            MediaTableTVSeries.cleanup(connection);
            MediaTableThumbnails.cleanup(connection);
        }
        catch (SQLException se) {
            LOGGER.error(null, se);
        }
        finally {
            GuiManager.setStatusLine(null);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String getFilenameById(Connection connection, Long id) {
        if (id == null) {
            return null;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_FILENAME_BY_ID);){
            statement.setLong(1, id);
            try (ResultSet resultSet = statement.executeQuery();){
                if (!resultSet.next()) return null;
                String string = resultSet.getString(1);
                return string;
            }
        }
        catch (SQLException se) {
            LOGGER.error(null, se);
        }
        return null;
    }

    public static List<String> getFilenamesInFolder(Connection connection, String fullPathToFolder) {
        ArrayList<String> result = new ArrayList<String>();
        if (StringUtils.isBlank(fullPathToFolder)) {
            return result;
        }
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_FILENAME_LIKE);){
            ps.setString(1, fullPathToFolder);
            try (ResultSet rs = ps.executeQuery();){
                while (rs.next()) {
                    result.add(rs.getString(COL_FILENAME));
                }
            }
        }
        catch (SQLException se) {
            LOGGER.error(null, se);
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static DLNAThumbnail getThumbnailByTitle(Connection connection, String title) {
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement ps = connection.prepareStatement(SQL_GET_THUMBNAIL_BY_TITLE);){
            ps.setString(1, title);
            if (trace) {
                LOGGER.trace("Searching FILES with \"{}\"", (Object)ps);
            }
            try (ResultSet rs = ps.executeQuery();){
                if (!rs.next()) return null;
                DLNAThumbnail dLNAThumbnail = ThumbnailStore.getThumbnail(rs.getLong(TABLE_COL_THUMBID));
                return dLNAThumbnail;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database error in FILES for \"{}\": {}", (Object)title, (Object)e.getMessage());
            LOGGER.trace("", e);
        }
        return null;
    }

    public static List<File> getFiles(Connection connection, String sql) {
        ArrayList<File> list = new ArrayList<File>();
        String psSql = sql.toUpperCase().startsWith("SELECT ") || sql.toUpperCase().startsWith("WITH ") ? sql : "SELECT FILES.FILENAME, FILES.MODIFIED FROM FILES WHERE " + sql;
        try (PreparedStatement ps = connection.prepareStatement(psSql);
             ResultSet rs = ps.executeQuery();){
            while (rs.next()) {
                String filename = rs.getString(COL_FILENAME);
                long modified = rs.getTimestamp(COL_MODIFIED).getTime();
                File file = new File(filename);
                if (!file.exists() || file.lastModified() != modified) continue;
                list.add(file);
            }
        }
        catch (SQLException se) {
            LOGGER.trace("Error get files with sql: {}", (Object)psSql);
            LOGGER.error(null, se);
            return list;
        }
        return list;
    }
}

