/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.io.InputStream;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import net.pms.database.MediaDatabase;
import net.pms.database.MediaTable;
import net.pms.database.MediaTableTablesVersions;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class MediaTableCoverArtArchive
extends MediaTable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaTableCoverArtArchive.class);
    protected static final String TABLE_NAME = "COVER_ART_ARCHIVE";
    private static final int TABLE_VERSION = 2;
    private static final String COL_ID = "ID";
    private static final String COL_MODIFIED = "MODIFIED";
    private static final String COL_MBID = "MBID";
    private static final String COL_COVER = "COVER";
    private static final String TABLE_COL_MBID = "COVER_ART_ARCHIVE.MBID";
    private static final String SQL_GET_ALL_BY_MBID = "SELECT * FROM COVER_ART_ARCHIVE WHERE COVER_ART_ARCHIVE.MBID = ? LIMIT 1";
    private static final String SQL_GET_COVER_MODIFIED_BY_MBID = "SELECT COVER, MODIFIED FROM COVER_ART_ARCHIVE WHERE COVER_ART_ARCHIVE.MBID = ? LIMIT 1";

    protected static void checkTable(Connection connection) throws SQLException {
        if (MediaTableCoverArtArchive.tableExists(connection, TABLE_NAME)) {
            Integer version = MediaTableTablesVersions.getTableVersion(connection, TABLE_NAME);
            if (version != null) {
                if (version < 2) {
                    MediaTableCoverArtArchive.upgradeTable(connection, version);
                } else if (version > 2) {
                    LOGGER.warn("Database \"{}\" table \"{}\" is from a newer version of UMS. If you experience problems, you could try to move, rename or delete database file \"{}\" before starting UMS", "medias", TABLE_NAME, DATABASE.getDatabaseFilename());
                }
            } else {
                LOGGER.warn("Database \"{}\" table \"{}\" has an unknown version and cannot be used. Dropping and recreating table", (Object)"medias", (Object)TABLE_NAME);
                MediaTableCoverArtArchive.dropTable(connection, TABLE_NAME);
                MediaTableCoverArtArchive.createTable(connection);
                MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 2);
            }
        } else {
            MediaTableCoverArtArchive.createTable(connection);
            MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 2);
        }
    }

    private static void upgradeTable(Connection connection, int currentVersion) throws SQLException {
        LOGGER.info("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, currentVersion, 2);
        block3: for (int version = currentVersion; version < 2; ++version) {
            LOGGER.trace("Upgrading database \"{}\" table \"{}\" from version {} to {}", "medias", TABLE_NAME, version, version + 1);
            switch (version) {
                case 1: {
                    MediaTableCoverArtArchive.executeUpdate(connection, "ALTER INDEX IF EXISTS MBID_IDX RENAME TO COVER_ART_ARCHIVE_MBID_IDX");
                    continue block3;
                }
                default: {
                    MediaTableCoverArtArchive.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, 2);
                    throw new IllegalStateException(MediaTableCoverArtArchive.getMessage("Database \"{}\" table \"{}\" is missing table upgrade commands from version {} to {}", "medias", TABLE_NAME, version, 2));
                }
            }
        }
        MediaTableTablesVersions.setTableVersion(connection, TABLE_NAME, 2);
    }

    private static void createTable(Connection connection) throws SQLException {
        LOGGER.info("Creating database \"{}\" table: \"{}\"", (Object)"medias", (Object)TABLE_NAME);
        MediaTableCoverArtArchive.execute(connection, "CREATE TABLE COVER_ART_ARCHIVE(ID IDENTITY PRIMARY KEY, MODIFIED TIMESTAMP, MBID VARCHAR(36), COVER BLOB)", "CREATE INDEX IF NOT EXISTS COVER_ART_ARCHIVEMBID_IDX ON COVER_ART_ARCHIVE(MBID)");
    }

    public static void writeMBID(String mBID, InputStream cover) {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            MediaTableCoverArtArchive.writeMBID(connection, mBID, cover);
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    public static void writeMBID(Connection connection, String mBID, InputStream cover) {
        if (connection == null || StringUtils.isBlank(mBID)) {
            return;
        }
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_ALL_BY_MBID, 1005, 1008);){
            statement.setString(1, mBID);
            if (trace) {
                LOGGER.trace("Searching for Cover Art Archive cover with \"{}\" before update", (Object)statement);
            }
            try (ResultSet result = statement.executeQuery();){
                boolean isCreatingNewRecord;
                boolean bl = isCreatingNewRecord = !result.next();
                if (isCreatingNewRecord) {
                    if (trace) {
                        LOGGER.trace("Inserting new cover for MBID \"{}\"", (Object)mBID);
                    }
                    result.moveToInsertRow();
                    result.updateTimestamp(COL_MODIFIED, new Timestamp(System.currentTimeMillis()));
                    result.updateString(COL_MBID, mBID);
                    if (cover != null) {
                        result.updateBinaryStream(COL_COVER, cover);
                    }
                    result.insertRow();
                } else if (cover != null || result.getBlob(COL_COVER) == null) {
                    if (trace) {
                        LOGGER.trace("Updating cover for MBID \"{}\"", (Object)mBID);
                    }
                    result.updateTimestamp(COL_MODIFIED, new Timestamp(System.currentTimeMillis()));
                    if (cover != null) {
                        result.updateBinaryStream(COL_COVER, cover);
                    } else {
                        result.updateNull(COL_COVER);
                    }
                    result.updateRow();
                } else if (trace) {
                    LOGGER.trace("Leaving row {} alone since previous information seems better", (Object)result.getInt(COL_ID));
                }
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "medias", "writing Cover Art Archive cover for MBID", mBID, TABLE_NAME, e.getMessage());
            LOGGER.trace("", e);
        }
    }

    public static CoverArtArchiveResult findMBID(String mBID) {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            CoverArtArchiveResult coverArtArchiveResult = MediaTableCoverArtArchive.findMBID(connection, mBID);
            return coverArtArchiveResult;
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static CoverArtArchiveResult findMBID(Connection connection, String mBID) {
        if (connection == null) return new CoverArtArchiveResult(false, null, null);
        if (StringUtils.isBlank(mBID)) {
            return new CoverArtArchiveResult(false, null, null);
        }
        boolean trace = LOGGER.isTraceEnabled();
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_COVER_MODIFIED_BY_MBID, 1005, 1008);){
            statement.setString(1, mBID);
            if (trace) {
                LOGGER.trace("Searching for Cover Art Archive cover with \"{}\"", (Object)statement);
            }
            try (ResultSet result = statement.executeQuery();){
                if (!result.next()) return new CoverArtArchiveResult(false, null, null);
                CoverArtArchiveResult coverArtArchiveResult = new CoverArtArchiveResult(true, result.getTimestamp(COL_MODIFIED), result.getBytes(COL_COVER));
                return coverArtArchiveResult;
            }
        }
        catch (SQLException e) {
            LOGGER.error("Database \"{}\" error while {} \"{}\" in \"{}\": {}", "medias", "looking up Cover Art Archive cover for MBID", mBID, TABLE_NAME, e.getMessage());
            LOGGER.trace("", e);
        }
        return new CoverArtArchiveResult(false, null, null);
    }

    public static boolean hasCover(String mbReleaseId) {
        Connection connection = null;
        try {
            connection = MediaDatabase.getConnectionIfAvailable();
            boolean bl = MediaTableCoverArtArchive.hasCover(connection, mbReleaseId);
            return bl;
        }
        finally {
            MediaDatabase.close(connection);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    public static boolean hasCover(Connection connection, String mbReleaseId) {
        if (connection == null || StringUtils.isBlank(mbReleaseId)) {
            return false;
        }
        try (PreparedStatement statement = connection.prepareStatement(SQL_GET_COVER_MODIFIED_BY_MBID, 1005, 1008);){
            boolean bl;
            block15: {
                statement.setString(1, mbReleaseId);
                ResultSet result = statement.executeQuery();
                try {
                    bl = result.next();
                    if (result == null) break block15;
                }
                catch (Throwable throwable) {
                    if (result != null) {
                        try {
                            result.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                result.close();
            }
            return bl;
        }
        catch (SQLException e) {
            LOGGER.trace("", e);
            return false;
        }
    }

    public static class CoverArtArchiveResult {
        private final boolean found;
        private final Timestamp modified;
        private final byte[] cover;

        public CoverArtArchiveResult(boolean found, Timestamp modified, byte[] cover) {
            this.found = found;
            this.modified = modified;
            this.cover = cover;
        }

        public boolean isFound() {
            return this.found;
        }

        public long getModifiedTime() {
            return this.modified.getTime();
        }

        public boolean hasCoverBytes() {
            return this.cover != null;
        }

        public byte[] getCoverBytes() {
            return this.cover;
        }
    }
}

