/*
 * Decompiled with CFR 0.152.
 */
package net.pms.database;

import java.sql.Connection;
import java.sql.SQLException;
import net.pms.database.Database;
import net.pms.database.DatabaseEmbedded;
import net.pms.database.MediaTableAudioMetadata;
import net.pms.database.MediaTableAudiotracks;
import net.pms.database.MediaTableChapters;
import net.pms.database.MediaTableContainerFiles;
import net.pms.database.MediaTableCoverArtArchive;
import net.pms.database.MediaTableFailedLookups;
import net.pms.database.MediaTableFiles;
import net.pms.database.MediaTableFilesStatus;
import net.pms.database.MediaTableMetadata;
import net.pms.database.MediaTableMusicBrainzReleaseLike;
import net.pms.database.MediaTableMusicBrainzReleases;
import net.pms.database.MediaTableRegexpRules;
import net.pms.database.MediaTableStoreIds;
import net.pms.database.MediaTableSubtracks;
import net.pms.database.MediaTableTVSeries;
import net.pms.database.MediaTableTablesVersions;
import net.pms.database.MediaTableThumbnails;
import net.pms.database.MediaTableVideoMetadata;
import net.pms.database.MediaTableVideoMetadataActors;
import net.pms.database.MediaTableVideoMetadataAwards;
import net.pms.database.MediaTableVideoMetadataCountries;
import net.pms.database.MediaTableVideoMetadataDirectors;
import net.pms.database.MediaTableVideoMetadataGenres;
import net.pms.database.MediaTableVideoMetadataLocalized;
import net.pms.database.MediaTableVideoMetadataRatings;
import net.pms.database.MediaTableVideotracks;
import net.pms.store.MediaScanner;
import net.pms.swing.Splash;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MediaDatabase
extends Database {
    private static final Logger LOGGER = LoggerFactory.getLogger(MediaDatabase.class);
    public static final String DATABASE_NAME = "medias";
    private static MediaDatabase instance = null;
    private static boolean tablesChecked = false;

    public MediaDatabase() {
        super(DATABASE_NAME);
    }

    @Override
    public final void onOpening(boolean force) {
        try {
            this.checkTables(force);
        }
        catch (SQLException se) {
            LOGGER.error("Error checking tables: " + se.getMessage());
            LOGGER.trace("", se);
            this.status = Database.DatabaseStatus.CLOSED;
        }
    }

    @Override
    public final void onOpeningFail(boolean force) {
        MediaScanner.stopMediaScan();
    }

    public final synchronized void checkTables(boolean force) throws SQLException {
        if (tablesChecked && !force) {
            LOGGER.debug("Database tables have already been checked, aborting check");
        } else {
            LOGGER.debug("Starting check of database tables");
            try (Connection connection = this.getConnection();){
                Splash.setStatusMessage("UpgradingMediaDb");
                MediaTableTablesVersions.checkTable(connection);
                MediaTableMetadata.checkTable(connection);
                MediaTableFiles.checkTable(connection);
                MediaTableVideoMetadata.checkTable(connection);
                MediaTableVideotracks.checkTable(connection);
                MediaTableSubtracks.checkTable(connection);
                MediaTableChapters.checkTable(connection);
                MediaTableRegexpRules.checkTable(connection);
                MediaTableMusicBrainzReleases.checkTable(connection);
                MediaTableCoverArtArchive.checkTable(connection);
                MediaTableFilesStatus.checkTable(connection);
                MediaTableThumbnails.checkTable(connection);
                MediaTableTVSeries.checkTable(connection);
                MediaTableFailedLookups.checkTable(connection);
                MediaTableVideoMetadataActors.checkTable(connection);
                MediaTableVideoMetadataAwards.checkTable(connection);
                MediaTableVideoMetadataCountries.checkTable(connection);
                MediaTableVideoMetadataDirectors.checkTable(connection);
                MediaTableVideoMetadataGenres.checkTable(connection);
                MediaTableVideoMetadataRatings.checkTable(connection);
                MediaTableVideoMetadataLocalized.checkTable(connection);
                MediaTableAudioMetadata.checkTable(connection);
                MediaTableAudiotracks.checkTable(connection);
                MediaTableMusicBrainzReleaseLike.checkTable(connection);
                MediaTableContainerFiles.checkTable(connection);
                MediaTableStoreIds.checkTable(connection);
            }
            tablesChecked = true;
        }
    }

    public final void reInitTablesExceptFilesStatus() throws SQLException {
        LOGGER.debug("Re-initializing tables");
        try (Connection connection = this.getConnection();){
            MediaDatabase.dropAllTablesExceptFilesStatus(connection);
        }
        this.checkTables(true);
    }

    public static synchronized void dropAllTables(Connection connection) {
        MediaDatabase.dropAllTablesExceptFilesStatus(connection);
        MediaDatabase.dropTableAndConstraint(connection, "REGEXP_RULES");
        MediaDatabase.dropTableAndConstraint(connection, "FILES_STATUS");
        MediaDatabase.dropTableAndConstraint(connection, "METADATA");
        MediaDatabase.dropTableAndConstraint(connection, "FILES");
        MediaDatabase.dropTableAndConstraint(connection, "TABLES_VERSIONS");
    }

    public static synchronized void dropAllTablesExceptFilesStatus(Connection connection) {
        MediaDatabase.dropTableAndConstraint(connection, "MUSIC_BRAINZ_RELEASES");
        MediaDatabase.dropTableAndConstraint(connection, "COVER_ART_ARCHIVE");
        MediaDatabase.dropTableAndConstraint(connection, "THUMBNAILS");
        MediaDatabase.dropTableAndConstraint(connection, "CHAPTERS");
        MediaDatabase.dropTableAndConstraint(connection, "TV_SERIES");
        MediaDatabase.dropTableAndConstraint(connection, "FAILED_LOOKUPS");
        MediaDatabase.dropTableAndConstraint(connection, "VIDEO_METADATA_ACTORS");
        MediaDatabase.dropTableAndConstraint(connection, "VIDEO_METADATA_AWARDS");
        MediaDatabase.dropTableAndConstraint(connection, "VIDEO_METADATA_COUNTRIES");
        MediaDatabase.dropTableAndConstraint(connection, "VIDEO_METADATA_DIRECTORS");
        MediaDatabase.dropTableAndConstraint(connection, "VIDEO_METADATA_GENRES");
        MediaDatabase.dropTableAndConstraint(connection, "VIDEO_METADATA_RATINGS");
        MediaDatabase.dropTableAndConstraint(connection, "VIDEO_METADATA_LOCALIZED");
        MediaDatabase.dropTableAndConstraint(connection, "AUDIOTRACKS");
        MediaDatabase.dropTableAndConstraint(connection, "CONTAINER_FILES");
    }

    public static synchronized MediaDatabase get() {
        if (instance == null) {
            instance = new MediaDatabase();
        }
        return instance;
    }

    public static synchronized void init() {
        MediaDatabase.get().init(false);
    }

    public static synchronized void initForce() {
        MediaDatabase.get().init(true);
    }

    public static boolean isInstantiated() {
        return instance != null;
    }

    public static boolean isAvailable() {
        return MediaDatabase.isInstantiated() && instance.isOpened();
    }

    public static Connection getConnectionIfAvailable() {
        if (MediaDatabase.isAvailable()) {
            try {
                return instance.getConnection();
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return null;
    }

    public static synchronized void resetCache() throws SQLException {
        if (instance != null) {
            instance.reInitTablesExceptFilesStatus();
        }
    }

    public static synchronized void shutdown() {
        if (instance != null) {
            instance.close();
        }
    }

    public static synchronized void createDatabaseReportIfNeeded() {
        if (instance != null && instance.isEmbedded()) {
            instance.createDatabaseReport();
        }
    }

    public static int getCacheSize() {
        if (instance != null && instance.isEmbedded()) {
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null) {
                    int n = DatabaseEmbedded.getCacheSize(connection);
                    return n;
                }
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
        return 0;
    }

    public static void analyzeDb() {
        if (instance != null && instance.isEmbedded()) {
            Connection connection = null;
            try {
                connection = MediaDatabase.getConnectionIfAvailable();
                if (connection != null) {
                    DatabaseEmbedded.analyzeDb(connection);
                }
            }
            finally {
                MediaDatabase.close(connection);
            }
        }
    }
}

