/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration.old;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Type;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import net.pms.PMS;
import net.pms.configuration.UmsConfiguration;
import net.pms.configuration.old.FileSerializer;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MapFileConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(MapFileConfiguration.class);
    private static final UmsConfiguration CONFIGURATION = PMS.getConfiguration();
    private static final String KEY_VIRTUAL_FOLDERS = "virtual_folders";
    private static final String KEY_VIRTUAL_FOLDERS_FILE = "virtual_folders_file";
    private final String name;
    private final List<MapFileConfiguration> children = new ArrayList<MapFileConfiguration>();
    private final List<File> files = new ArrayList<File>();
    private final boolean addToMediaLibrary;

    public MapFileConfiguration() {
        this.name = null;
        this.addToMediaLibrary = true;
    }

    public String getName() {
        return this.name;
    }

    public List<MapFileConfiguration> getChildren() {
        return this.children;
    }

    public List<File> getFiles() {
        return this.files;
    }

    public boolean isAddToMediaLibrary() {
        return this.addToMediaLibrary;
    }

    public static List<MapFileConfiguration> parseVirtualFolders() {
        String conf;
        if (StringUtils.isNotBlank(MapFileConfiguration.getVirtualFoldersFile())) {
            conf = MapFileConfiguration.getVirtualFoldersFile().trim().replaceAll("&comma;", ",");
            File file = new File(CONFIGURATION.getProfileDirectory(), conf);
            try {
                conf = FileUtils.readFileToString(file, StandardCharsets.US_ASCII);
            }
            catch (IOException e) {
                LOGGER.warn("Unexpected exception while reading \"{}\": {}", (Object)file.getAbsolutePath(), (Object)e.getMessage());
                LOGGER.debug("", e);
                return null;
            }
        } else if (StringUtils.isNotBlank(MapFileConfiguration.getVirtualFolders())) {
            conf = MapFileConfiguration.getVirtualFolders().trim().replaceAll("&comma;", ",");
            String[] arrayLevel0 = conf.split(";");
            StringBuilder jsonStringFromConf = new StringBuilder();
            jsonStringFromConf.append("[");
            boolean firstLoop = true;
            int i = 0;
            for (String folders : arrayLevel0) {
                String[] arrayLevel1 = folders.split("\\|");
                if (!firstLoop) {
                    jsonStringFromConf.append(',');
                }
                for (String value : arrayLevel1) {
                    if (i == 0) {
                        jsonStringFromConf.append("{\"name\":\"").append(value).append("\",\"files\":[");
                        ++i;
                        continue;
                    }
                    String[] arrayLevel2 = value.split(",");
                    boolean firstFile = true;
                    for (String value2 : arrayLevel2) {
                        if (!firstFile) {
                            jsonStringFromConf.append(",");
                        }
                        jsonStringFromConf.append("\"").append(value2).append("\"");
                        firstFile = false;
                    }
                    jsonStringFromConf.append("]}");
                }
                firstLoop = false;
                i = 0;
            }
            jsonStringFromConf.append("]");
            conf = jsonStringFromConf.toString().replace("\\\\", "\\\\\\\\");
        } else {
            return null;
        }
        GsonBuilder gsonBuilder = new GsonBuilder();
        gsonBuilder.registerTypeAdapter((Type)((Object)File.class), new FileSerializer());
        Gson gson = gsonBuilder.create();
        Type listType = new TypeToken<ArrayList<MapFileConfiguration>>(){}.getType();
        return (List)gson.fromJson(conf, listType);
    }

    private static String getVirtualFolders() {
        return CONFIGURATION.getString(KEY_VIRTUAL_FOLDERS, "");
    }

    private static String getVirtualFoldersFile() {
        return CONFIGURATION.getString(KEY_VIRTUAL_FOLDERS_FILE, "");
    }
}

