/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import ch.qos.logback.classic.Level;
import com.google.gson.JsonArray;
import com.google.gson.JsonObject;
import com.google.gson.JsonPrimitive;
import com.sun.jna.Platform;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.pms.Messages;
import net.pms.PMS;
import net.pms.configuration.BaseConfiguration;
import net.pms.configuration.Build;
import net.pms.configuration.ConfigurableProgramPaths;
import net.pms.configuration.ConfigurationReader;
import net.pms.encoders.Engine;
import net.pms.encoders.EngineFactory;
import net.pms.encoders.EngineId;
import net.pms.encoders.FFmpegLogLevels;
import net.pms.encoders.StandardEngineId;
import net.pms.formats.Format;
import net.pms.gui.GuiManager;
import net.pms.platform.PlatformProgramPaths;
import net.pms.platform.PlatformUtils;
import net.pms.platform.TempFolder;
import net.pms.platform.windows.WindowsRegistry;
import net.pms.renderers.ConnectedRenderers;
import net.pms.service.Services;
import net.pms.service.sleep.PreventSleepMode;
import net.pms.service.sleep.SleepManager;
import net.pms.util.CoverSupplier;
import net.pms.util.ExternalProgramInfo;
import net.pms.util.FilePermissions;
import net.pms.util.FileUtil;
import net.pms.util.FullyPlayedAction;
import net.pms.util.InvalidArgumentException;
import net.pms.util.Languages;
import net.pms.util.LogSystemInformationMode;
import net.pms.util.ProgramExecutableType;
import net.pms.util.PropertiesUtil;
import net.pms.util.PropertiesWrapper;
import net.pms.util.StringUtil;
import net.pms.util.SubtitleColor;
import net.pms.util.UMSUtils;
import net.pms.util.UniqueList;
import org.apache.commons.configuration.Configuration;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.configuration.event.ConfigurationListener;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UmsConfiguration
extends BaseConfiguration {
    private static final Logger LOGGER;
    private static final int DEFAULT_MEDIA_SERVER_PORT = 5001;
    private static final int DEFAULT_WEB_GUI_PORT = 9001;
    private static final int DEFAULT_WEB_PLAYER_PORT = 9002;
    private static final int LOGGING_LOGS_TAB_LINEBUFFER_MAX = 90000;
    private static final int LOGGING_LOGS_TAB_LINEBUFFER_MIN = 100;
    private static final int LOGGING_LOGS_TAB_LINEBUFFER_STEP = 500;
    private static final String DEFAULT_PROFILE_FILENAME = "UMS.conf";
    private static final String ENV_PROFILE_PATH = "UMS_PROFILE";
    private static final String DEFAULT_SHARED_CONF_FILENAME = "SHARED.conf";
    private static final String DEFAULT_CREDENTIALS_FILENAME = "UMS.cred";
    private static final String PORTABLE_PATH = "portable";
    public static final String PROPERTY_PROFILE_PATH = "ums.profile.path";
    private static final int MENCODER_MAX_THREADS = 8;
    private static final int WEB_MAX_THREADS = 100;
    private static final int MAX_MAX_MEMORY_DEFAULT_SIZE = 400;
    private static final int BUFFER_MEMORY_FACTOR = 368;
    private static final char LIST_SEPARATOR = ',';
    private static volatile boolean enabledEnginesBuilt;
    private static final ReentrantReadWriteLock ENABLED_ENGINES_LOCK;
    private static UniqueList<EngineId> enabledEngines;
    private static volatile boolean enginesPriorityBuilt;
    private static final ReentrantReadWriteLock ENGINES_PRIORITY_LOCK;
    private static UniqueList<EngineId> enginesPriority;
    private static final String PROFILE_DIRECTORY_NAME;
    private static String hostName;
    private static String defaultAviSynthScript;
    private static int maxMaxMemoryBufferSize;
    private static final String PROFILE_DIRECTORY;
    private static final String PROFILE_PATH;
    private static String sharedConfPath;
    private static final String SKEL_PROFILE_PATH;
    private static final int PROFILE_TYPE;
    private static final String KEY_3D_SUBTITLES_DEPTH = "3d_subtitles_depth";
    private static final String KEY_ALTERNATE_SUBTITLES_FOLDER = "alternate_subtitles_folder";
    private static final String KEY_ALTERNATE_THUMB_FOLDER = "alternate_thumb_folder";
    private static final String KEY_ANONYMOUS_DEVICES_WRITE = "anonymous_devices_write";
    private static final String KEY_APPEND_PROFILE_NAME = "append_profile_name";
    private static final String KEY_ATZ_LIMIT = "atz_limit";
    private static final String KEY_AUTOMATIC_DISCOVER = "automatic_discover";
    private static final String KEY_AUTOMATIC_MAXIMUM_BITRATE = "automatic_maximum_bitrate";
    private static final String KEY_AUDIO_BITRATE = "audio_bitrate";
    private static final String KEY_AUDIO_CHANNEL_COUNT = "audio_channels";
    private static final String KEY_AUDIO_EMBED_DTS_IN_PCM = "audio_embed_dts_in_pcm";
    private static final String KEY_AUDIO_LANGUAGES = "audio_languages";
    private static final String KEY_AUDIO_REMUX_AC3 = "audio_remux_ac3";
    private static final String KEY_AUDIO_RESAMPLE = "audio_resample";
    private static final String KEY_AUDIO_SUB_LANGS = "audio_subtitles_languages";
    private static final String KEY_AUDIO_THUMBNAILS_METHOD = "audio_thumbnails_method";
    private static final String KEY_AUDIO_USE_PCM = "audio_use_pcm";
    private static final String KEY_AUDIO_UPDATE_RATING_TAG = "audio_update_rating_tag";
    private static final String KEY_AUTHENTICATE_LOCALHOST_AS_ADMIN = "authenticate_localhost_as_admin";
    private static final String KEY_AUTHENTICATION_ENABLED = "authentication_enabled";
    private static final String KEY_AUTO_UPDATE = "auto_update";
    private static final String KEY_AUTOLOAD_SUBTITLES = "autoload_external_subtitles";
    private static final String KEY_AVISYNTH_CONVERT_FPS = "avisynth_convert_fps";
    private static final String KEY_AVISYNTH_INTERFRAME = "avisynth_interframe";
    private static final String KEY_AVISYNTH_INTERFRAME_GPU = "avisynth_interframegpu";
    private static final String KEY_AVISYNTH_MULTITHREADING = "avisynth_multithreading";
    private static final String KEY_AVISYNTH_SCRIPT = "avisynth_script";
    private static final String KEY_ASS_MARGIN = "subtitles_ass_margin";
    private static final String KEY_ASS_OUTLINE = "subtitles_ass_outline";
    private static final String KEY_ASS_SCALE = "subtitles_ass_scale";
    private static final String KEY_ASS_SHADOW = "subtitles_ass_shadow";
    private static final String KEY_BLOCK_NETWORK_DEVICES_BY_DEFAULT = "block_network_devices_by_default";
    private static final String KEY_BLOCK_RENDERERS_BY_DEFAULT = "block_renderers_by_default";
    private static final String KEY_CHAPTER_INTERVAL = "chapter_interval";
    private static final String KEY_CHAPTER_SUPPORT = "chapter_support";
    private static final String KEY_CHROMECAST_DBG = "chromecast_debug";
    private static final String KEY_CHROMECAST_EXT = "chromecast_extension";
    private static final String KEY_CODE_CHARS = "code_charset";
    private static final String KEY_CODE_THUMBS = "code_show_thumbs_no_code";
    private static final String KEY_CODE_TMO = "code_valid_timeout";
    private static final String KEY_CODE_USE = "code_enable";
    private static final String KEY_DATABASE_MEDIA_CACHE_SIZE_KB = "database_media_cache_size";
    private static final String KEY_DATABASE_MEDIA_USE_CACHE_SOFT = "database_media_use_cache_soft";
    private static final String KEY_DATABASE_MEDIA_USE_MEMORY_INDEXES = "database_media_use_memory_indexes";
    private static final String KEY_DISABLE_EXTERNAL_ENTITIES = "disable_external_entities";
    private static final String KEY_DISABLE_FAKESIZE = "disable_fakesize";
    private static final String KEY_DISABLE_SUBTITLES = "disable_subtitles";
    private static final String KEY_DISABLE_TRANSCODE_FOR_EXTENSIONS = "disable_transcode_for_extensions";
    private static final String KEY_DISABLE_TRANSCODING = "disable_transcoding";
    private static final String KEY_DVDISO_THUMBNAILS = "dvd_isos_thumbnails";
    private static final String KEY_DYNAMIC_PLS = "dynamic_playlist";
    private static final String KEY_DYNAMIC_PLS_AUTO_SAVE = "dynamic_playlist_auto_save";
    private static final String KEY_DYNAMIC_PLS_HIDE = "dynamic_playlist_hide_folder";
    private static final String KEY_DYNAMIC_PLS_SAVE_PATH = "dynamic_playlist_save_path";
    private static final String KEY_ENCODED_AUDIO_PASSTHROUGH = "encoded_audio_passthrough";
    private static final String KEY_ENGINES = "engines";
    private static final String KEY_ENGINES_PRIORITY = "engines_priority";
    private static final String KEY_EXTERNAL_NETWORK = "external_network";
    private static final String KEY_FFMPEG_AVAILABLE_GPU_ACCELERATION_METHODS = "ffmpeg_available_gpu_acceleration_methods";
    private static final String KEY_FFMPEG_AVISYNTH_2D_TO_3D = "ffmpeg_avisynth_2d_to_3d_conversion";
    private static final String KEY_FFMPEG_AVISYNTH_CONVERSION_ALGORITHM_2D_TO_3D = "ffmpeg_avisynth_conversion_algorithm_index_2d_to_3d";
    private static final String KEY_FFMPEG_AVISYNTH_CONVERT_FPS = "ffmpeg_avisynth_convertfps";
    private static final String KEY_FFMPEG_AVISYNTH_FRAME_STRETCH_FACTOR_2D_TO_3D = "ffmpeg_avisynth_frame_stretch_factor_2d_to_3d";
    private static final String KEY_FFMPEG_AVISYNTH_HORIZONTAL_RESIZE = "ffmpeg_avisynth_horizontal_resize";
    private static final String KEY_FFMPEG_AVISYNTH_HORIZONTAL_RESIZE_RESOLUTION = "ffmpeg_avisynth_horizontal_resize_resolution";
    private static final String KEY_FFMPEG_AVISYNTH_INTERFRAME = "ffmpeg_avisynth_interframe";
    private static final String KEY_FFMPEG_AVISYNTH_INTERFRAME_GPU = "ffmpeg_avisynth_interframegpu";
    private static final String KEY_FFMPEG_AVISYNTH_LIGHT_OFFSET_FACTOR_2D_TO_3D = "ffmpeg_avisynth_light_offset_factor_2d_to_3d";
    private static final String KEY_FFMPEG_AVISYNTH_MULTITHREADING = "ffmpeg_avisynth_multithreading";
    private static final String KEY_FFMPEG_AVISYNTH_OUTPUT_FORMAT_3D = "ffmpeg_avisynth_output_format_index_3d";
    private static final String KEY_FFMPEG_AVISYNTH_USE_FFMS2 = "ffmpeg_avisynth_use_ffms2";
    private static final String KEY_FFMPEG_FONTCONFIG = "ffmpeg_fontconfig";
    private static final String KEY_FFMPEG_GPU_DECODING_ACCELERATION_METHOD = "ffmpeg_gpu_decoding_acceleration_method";
    private static final String KEY_FFMPEG_GPU_DECODING_ACCELERATION_THREAD_NUMBER = "ffmpeg_gpu_decoding_acceleration_thread_number";
    private static final String KEY_FFMPEG_GPU_ENCODING_H264_ACCELERATION_METHOD = "ffmpeg_gpu_encoding_H264_acceleration_method";
    private static final String KEY_FFMPEG_GPU_ENCODING_H265_ACCELERATION_METHOD = "ffmpeg_gpu_encoding_H265_acceleration_method";
    private static final String KEY_FFMPEG_LOGGING_LEVEL = "ffmpeg_logging_level";
    private static final String KEY_FFMPEG_MENCODER_PROBLEMATIC_SUBTITLES = "ffmpeg_mencoder_problematic_subtitles";
    private static final String KEY_FFMPEG_MULTITHREADING = "ffmpeg_multithreading";
    private static final String KEY_FFMPEG_MUX_TSMUXER_COMPATIBLE = "ffmpeg_mux_tsmuxer_compatible";
    private static final String KEY_FFMPEG_SOX = "ffmpeg_sox";
    private static final String KEY_FIX_25FPS_AV_MISMATCH = "fix_25fps_av_mismatch";
    private static final String KEY_FOLDER_LIMIT = "folder_limit";
    private static final String KEY_FOLDER_NAMES_IGNORED = "folder_names_ignored";
    private static final String KEY_FORCE_EXTERNAL_SUBTITLES = "force_external_subtitles";
    private static final String KEY_FORCE_TRANSCODE_FOR_EXTENSIONS = "force_transcode_for_extensions";
    private static final String KEY_FORCED_SUBTITLE_LANGUAGE = "forced_subtitle_language";
    private static final String KEY_FORCED_SUBTITLE_TAGS = "forced_subtitle_tags";
    private static final String KEY_FULLY_PLAYED_ACTION = "fully_played_action";
    private static final String KEY_FULLY_PLAYED_OUTPUT_DIRECTORY = "fully_played_output_directory";
    private static final String KEY_GPU_ACCELERATION = "gpu_acceleration";
    private static final String KEY_GUI_LOG_SEARCH_CASE_SENSITIVE = "gui_log_search_case_sensitive";
    private static final String KEY_GUI_LOG_SEARCH_MULTILINE = "gui_log_search_multiline";
    private static final String KEY_GUI_LOG_SEARCH_USE_REGEX = "gui_log_search_use_regex";
    private static final String KEY_HIDE_ADVANCED_OPTIONS = "hide_advanced_options";
    private static final String KEY_HIDE_EMPTY_FOLDERS = "hide_empty_folders";
    private static final String KEY_HIDE_ENGINENAMES = "hide_enginenames";
    private static final String KEY_HIDE_EXTENSIONS = "hide_extensions";
    private static final String KEY_IGNORE_THE_WORD_A_AND_THE = "ignore_the_word_a_and_the";
    private static final String KEY_IMAGE_THUMBNAILS_ENABLED = "image_thumbnails";
    private static final String KEY_INFO_DB_RETRY = "infodb_retry";
    private static final String KEY_JWT_SIGNER_SECRET = "jwt_secret";
    private static final String KEY_LANGUAGE = "language";
    private static final String KEY_LIVE_SUBTITLES_KEEP = "live_subtitles_keep";
    private static final String KEY_LIVE_SUBTITLES_LIMIT = "live_subtitles_limit";
    private static final String KEY_LOG_SYSTEM_INFO = "log_system_info";
    private static final String KEY_LOGGING_LOGFILE_NAME = "logging_logfile_name";
    private static final String KEY_LOGGING_BUFFERED = "logging_buffered";
    private static final String KEY_LOGGING_FILTER_CONSOLE = "logging_filter_console";
    private static final String KEY_LOGGING_FILTER_LOGS_TAB = "logging_filter_logs_tab";
    private static final String KEY_LOGGING_LOGS_TAB_LINEBUFFER = "logging_logs_tab_linebuffer";
    private static final String KEY_LOGGING_SYSLOG_FACILITY = "logging_syslog_facility";
    private static final String KEY_LOGGING_SYSLOG_HOST = "logging_syslog_host";
    private static final String KEY_LOGGING_SYSLOG_PORT = "logging_syslog_port";
    private static final String KEY_LOGGING_USE_SYSLOG = "logging_use_syslog";
    private static final String KEY_LOG_DATABASE = "log_database";
    private static final String KEY_MAX_AUDIO_BUFFER = "maximum_audio_buffer_size";
    private static final String KEY_MAX_BITRATE = "maximum_bitrate";
    private static final String KEY_MAX_MEMORY_BUFFER_SIZE = "maximum_video_buffer_size";
    private static final String KEY_MENCODER_ASS = "mencoder_ass";
    private static final String KEY_MENCODER_AC3_FIXED = "mencoder_ac3_fixed";
    private static final String KEY_MENCODER_CODEC_SPECIFIC_SCRIPT = "mencoder_codec_specific_script";
    private static final String KEY_MENCODER_CUSTOM_OPTIONS = "mencoder_custom_options";
    private static final String KEY_MENCODER_FONT_CONFIG = "mencoder_fontconfig";
    private static final String KEY_MENCODER_FORCE_FPS = "mencoder_forcefps";
    private static final String KEY_MENCODER_INTELLIGENT_SYNC = "mencoder_intelligent_sync";
    private static final String KEY_MENCODER_MAX_THREADS = "mencoder_max_threads";
    private static final String KEY_MENCODER_MUX_COMPATIBLE = "mencoder_mux_compatible";
    private static final String KEY_MENCODER_MT = "mencoder_mt";
    private static final String KEY_MENCODER_NO_OUT_OF_SYNC = "mencoder_nooutofsync";
    private static final String KEY_MENCODER_NOASS_BLUR = "mencoder_noass_blur";
    private static final String KEY_MENCODER_NOASS_OUTLINE = "mencoder_noass_outline";
    private static final String KEY_MENCODER_NOASS_SCALE = "mencoder_noass_scale";
    private static final String KEY_MENCODER_NOASS_SUBPOS = "mencoder_noass_subpos";
    private static final String KEY_MENCODER_NORMALIZE_VOLUME = "mencoder_normalize_volume";
    private static final String KEY_MENCODER_OVERSCAN_COMPENSATION_HEIGHT = "mencoder_overscan_compensation_height";
    private static final String KEY_MENCODER_OVERSCAN_COMPENSATION_WIDTH = "mencoder_overscan_compensation_width";
    private static final String KEY_MENCODER_REMUX_MPEG2 = "mencoder_remux_mpeg2";
    private static final String KEY_MENCODER_SCALER = "mencoder_scaler";
    private static final String KEY_MENCODER_SCALEX = "mencoder_scalex";
    private static final String KEY_MENCODER_SCALEY = "mencoder_scaley";
    private static final String KEY_MENCODER_SUB_FRIBIDI = "mencoder_subfribidi";
    private static final String KEY_MENCODER_USE_PCM_FOR_HQ_AUDIO_ONLY = "mencoder_usepcm_for_hq_audio_only";
    private static final String KEY_MENCODER_VOBSUB_SUBTITLE_QUALITY = "mencoder_vobsub_subtitle_quality";
    private static final String KEY_MENCODER_YADIF = "mencoder_yadif";
    private static final String KEY_MIN_MEMORY_BUFFER_SIZE = "minimum_video_buffer_size";
    private static final String KEY_MIN_PLAY_TIME = "minimum_watched_play_time";
    private static final String KEY_MIN_PLAY_TIME_FILE = "min_playtime_file";
    private static final String KEY_MIN_STREAM_BUFFER = "minimum_web_buffer_size";
    private static final String KEY_MINIMIZED = "minimized";
    private static final String KEY_MPEG2_MAIN_SETTINGS = "mpeg2_main_settings";
    private static final String KEY_MUX_ALLAUDIOTRACKS = "tsmuxer_mux_all_audiotracks";
    private static final String KEY_NETWORK_DEVICES_FILTER = "network_devices_filter";
    private static final String KEY_NETWORK_INTERFACE = "network_interface";
    private static final String KEY_NEXTCP_API_KEY = "nextcp_api_key";
    private static final String KEY_NEXTCP_AUDIO_LIKES_IN_ROOT_FOLDER = "audio_likes_visible_root";
    private static final String KEY_NUMBER_OF_CPU_CORES = "number_of_cpu_cores";
    private static final String KEY_OPEN_ARCHIVES = "enable_archive_browsing";
    private static final String KEY_OVERSCAN = "mencoder_overscan";
    private static final String KEY_PLAYLIST_AUTO_ADD_ALL = "playlist_auto_add_all";
    private static final String KEY_PLAYLIST_AUTO_CONT = "playlist_auto_continue";
    private static final String KEY_PLAYLIST_AUTO_PLAY = "playlist_auto_play";
    private static final String KEY_PRETTIFY_FILENAMES = "prettify_filenames";
    private static final String KEY_PREVENT_SLEEP = "prevent_sleep";
    private static final String KEY_PROFILE_NAME = "name";
    private static final String KEY_RENDERER_DEFAULT = "renderer_default";
    private static final String KEY_RENDERER_FORCE_DEFAULT = "renderer_force_default";
    private static final String KEY_RENDERERS_FILTER = "renderers_filter";
    private static final String KEY_RENDERERS_USER = "renderers_user";
    private static final String KEY_RESUME = "resume";
    private static final String KEY_RESUME_BACK = "resume_back";
    private static final String KEY_RESUME_KEEP_TIME = "resume_keep_time";
    private static final String KEY_RESUME_REWIND = "resume_rewind";
    private static final String KEY_ROOT_LOG_LEVEL = "log_level";
    private static final String KEY_RUN_WIZARD = "run_wizard";
    private static final String KEY_SCAN_SHARED_FOLDERS_ON_STARTUP = "scan_shared_folders_on_startup";
    private static final String KEY_SCRIPT_DIR = "script_dir";
    private static final String KEY_SEARCH_FOLDER = "search_folder";
    private static final String KEY_SEARCH_IN_FOLDER = "search_in_folder";
    private static final String KEY_SEARCH_RECURSE = "search_recurse";
    private static final String KEY_SEARCH_RECURSE_DEPTH = "search_recurse_depth";
    private static final String KEY_SELECTED_RENDERERS = "selected_renderers";
    private static final String KEY_SERVER_HOSTNAME = "hostname";
    private static final String KEY_SERVER_NAME = "server_name";
    private static final String KEY_SERVER_PORT = "port";
    private static final String KEY_SHARED_CONF_PATH = "shared_conf";
    private static final String KEY_SHOW_INFO_ABOUT_AUTOMATIC_VIDEO_SETTING = "show_info";
    private static final String KEY_SHOW_LIVE_SUBTITLES_FOLDER = "show_live_subtitles_folder";
    private static final String KEY_SHOW_MEDIA_LIBRARY_FOLDER = "show_media_library_folder";
    private static final String KEY_SHOW_RECENTLY_PLAYED_FOLDER = "show_recently_played_folder";
    private static final String KEY_SHOW_SERVER_SETTINGS_FOLDER = "show_server_settings_folder";
    private static final String KEY_SHOW_SPLASH_SCREEN = "show_splash_screen";
    private static final String KEY_SHOW_TRANSCODE_FOLDER = "show_transcode_folder";
    private static final String KEY_SHOW_USER_CHOICE = "show_user_choice";
    private static final String KEY_SINGLE = "single_instance";
    private static final String KEY_SKIP_LOOP_FILTER_ENABLED = "mencoder_skip_loop_filter";
    private static final String KEY_SKIP_NETWORK_INTERFACES = "skip_network_interfaces";
    private static final String KEY_SORT_AUDIO_TRACKS_BY_ALBUM_POSITION = "sort_audio_tracks_by_album_position";
    private static final String KEY_SORT_METHOD = "sort_method";
    private static final String KEY_SORT_PATHS = "sort_paths";
    private static final String KEY_SPEED_DBG = "speed_debug";
    private static final String KEY_SUBS_COLOR = "subtitles_color";
    private static final String KEY_SUBS_FONT = "subtitles_font";
    private static final String KEY_SUBS_INFO_LEVEL = "subs_info_level";
    private static final String KEY_SUBTITLES_CODEPAGE = "subtitles_codepage";
    private static final String KEY_SUBTITLES_LANGUAGES = "subtitles_languages";
    private static final String KEY_TEMP_FOLDER_PATH = "temp_directory";
    private static final String KEY_THUMBNAIL_GENERATION_ENABLED = "generate_thumbnails";
    private static final String KEY_THUMBNAIL_SEEK_POS = "thumbnail_seek_position";
    private static final String KEY_TMDB_API_KEY = "tmdb_api_key";
    private static final String KEY_TRANSCODE_BLOCKS_MULTIPLE_CONNECTIONS = "transcode_block_multiple_connections";
    private static final String KEY_TRANSCODE_FOLDER_NAME = "transcode_folder_name";
    private static final String KEY_TRANSCODE_KEEP_FIRST_CONNECTION = "transcode_keep_first_connection";
    private static final String KEY_TSMUXER_FORCEFPS = "tsmuxer_forcefps";
    private static final String KEY_UPNP_ALIVE_DELAY = "upnp_alive_delay";
    private static final String KEY_UPNP_CDS_WRITE = "upnp_cds_write";
    private static final String KEY_UPNP_ENABLED = "upnp_enable";
    private static final String KEY_UPNP_JUPNP_DIDL = "upnp_jupnp_didl";
    public static final String KEY_UPNP_LOG_LEVEL = "upnp_log_level";
    private static final String KEY_UPNP_PORT = "upnp_port";
    private static final String KEY_USE_EMBEDDED_SUBTITLES_STYLE = "use_embedded_subtitles_style";
    private static final String KEY_USE_API_INFO = "use_api_info";
    private static final String KEY_USE_TMDB_INFO = "use_tmdb_info";
    private static final String KEY_USE_MPLAYER_FOR_THUMBS = "use_mplayer_for_video_thumbs";
    private static final String KEY_USE_SYMLINKS_TARGET_FILE = "use_symlinks_target_file";
    private static final String KEY_UUID = "uuid";
    private static final String KEY_VIDEOTRANSCODE_START_DELAY = "videotranscode_start_delay";
    private static final String KEY_VLC_AUDIO_SYNC_ENABLED = "vlc_audio_sync_enabled";
    private static final String KEY_VLC_SAMPLE_RATE = "vlc_sample_rate";
    private static final String KEY_VLC_SAMPLE_RATE_OVERRIDE = "vlc_sample_rate_override";
    private static final String KEY_VLC_SCALE = "vlc_scale";
    private static final String KEY_VLC_SUBTITLE_ENABLED = "vlc_subtitle_enabled";
    private static final String KEY_VLC_USE_EXPERIMENTAL_CODECS = "vlc_use_experimental_codecs";
    private static final String KEY_VLC_USE_HW_ACCELERATION = "vlc_use_hw_acceleration";
    private static final String KEY_WAS_YOUTUBE_DL_ENABLED_ONCE = "was_youtube_dl_enabled_once";
    private static final String KEY_WEB_GUI_ON_START = "web_gui_on_start";
    private static final String KEY_WEB_GUI_PORT = "web_gui_port";
    private static final String KEY_WEB_PATH = "web_path";
    private static final String KEY_WEB_PLAYER_AUTH = "web_player_auth";
    private static final String KEY_WEB_PLAYER_CONT_AUDIO = "web_player_continue_audio";
    private static final String KEY_WEB_PLAYER_CONT_IMAGE = "web_player_continue_image";
    private static final String KEY_WEB_PLAYER_CONT_VIDEO = "web_player_continue_video";
    private static final String KEY_WEB_PLAYER_CONTROLLABLE = "web_player_controllable";
    private static final String KEY_WEB_PLAYER_CONTROLS = "web_player_controls";
    private static final String KEY_WEB_PLAYER_DOWNLOAD = "web_player_download";
    private static final String KEY_WEB_PLAYER_ENABLE = "web_player_enable";
    private static final String KEY_WEB_PLAYER_HTTPS = "web_player_https";
    private static final String KEY_WEB_PLAYER_IMAGE_SLIDE = "web_player_image_show_delay";
    private static final String KEY_WEB_PLAYER_LOOP_AUDIO = "web_player_loop_audio";
    private static final String KEY_WEB_PLAYER_LOOP_IMAGE = "web_player_loop_image";
    private static final String KEY_WEB_PLAYER_LOOP_VIDEO = "web_player_loop_video";
    private static final String KEY_WEB_PLAYER_MP4_TRANS = "web_mp4_trans";
    private static final String KEY_WEB_PLAYER_PORT = "web_player_port";
    private static final String KEY_WEB_PLAYER_SUB_LANG = "web_use_browser_sub_lang";
    private static final String KEY_WEB_PLAYER_SUBS_TRANS = "web_subtitles_transcoded";
    private static final String KEY_WEB_THREADS = "web_threads";
    private static final String KEY_X264_CONSTANT_RATE_FACTOR = "x264_constant_rate_factor";
    private static final Map<String, String> REFACTORED_KEYS;
    private static final Set<String> REMOVED_KEYS;
    public static final Set<String> NEED_MEDIA_SERVER_RELOAD_FLAGS;
    public static final Set<String> NEED_WEB_PLAYER_SERVER_RELOAD_FLAGS;
    public static final Set<String> NEED_WEB_GUI_SERVER_RELOAD_FLAGS;
    public static final Set<String> NEED_RENDERERS_RELOAD_FLAGS;
    public static final Set<String> LANGUAGE_CHANGED;
    public static final Set<String> NEED_RENDERERS_MEDIA_STORE_RELOAD_FLAGS;
    public static final Set<String> ARRAY_KEYS;
    public static final Set<String> SELECT_KEYS;
    public static final List<String> VALID_EMPTY_KEYS;
    private String defaultLogFileDir = null;
    private String defaultZippedLogFileDir = null;
    @Nonnull
    private final PlatformProgramPaths programPaths;
    protected TempFolder tempFolder;
    private ArrayList<String> ignoredFolderNames;
    private boolean ignoredFolderNamesRead;
    private List<String> ignoredSystemFolderNames = List.of("$RECYCLE.BIN", "System Volume Information");
    public static final String KEY_CRED_PATH = "cred.path";
    private static final String KEY_URL_RES_ORDER = "url_resolve_order";

    public UmsConfiguration() throws ConfigurationException, InterruptedException {
        this(true);
    }

    public UmsConfiguration(boolean loadFile) throws ConfigurationException, InterruptedException {
        super(true);
        if (loadFile) {
            File pmsConfFile = new File(PROFILE_PATH);
            try {
                ((PropertiesConfiguration)this.configuration).load(pmsConfFile);
            }
            catch (ConfigurationException configurationException) {
                if (Platform.isLinux() && SKEL_PROFILE_PATH != null) {
                    LOGGER.debug("Failed to load {} ({}) - attempting to load skel profile", (Object)PROFILE_PATH, (Object)configurationException.getMessage());
                    File skelConfigFile = new File(SKEL_PROFILE_PATH);
                    try {
                        ((PropertiesConfiguration)this.configuration).load(skelConfigFile);
                        LOGGER.info("Default configuration loaded from {}", (Object)SKEL_PROFILE_PATH);
                    }
                    catch (ConfigurationException ce) {
                        LOGGER.warn("Can't load neither {}: {} nor {}: {}", PROFILE_PATH, configurationException.getMessage(), SKEL_PROFILE_PATH, ce.getMessage());
                    }
                }
                LOGGER.warn("Can't load {}: {}", (Object)PROFILE_PATH, (Object)configurationException.getMessage());
            }
        }
        ((PropertiesConfiguration)this.configuration).setPath(PROFILE_PATH);
        for (Map.Entry entry : REFACTORED_KEYS.entrySet()) {
            if (!this.configuration.containsKey((String)entry.getKey())) continue;
            Object value = this.configuration.getProperty((String)entry.getKey());
            this.configuration.setProperty((String)entry.getValue(), value);
            this.configuration.clearProperty((String)entry.getKey());
        }
        String oldIpFilter = this.getString("ip_filter", null);
        if (StringUtils.isNotBlank(oldIpFilter)) {
            this.configuration.setProperty(KEY_BLOCK_NETWORK_DEVICES_BY_DEFAULT, true);
            this.configuration.setProperty(KEY_NETWORK_DEVICES_FILTER, oldIpFilter);
            this.configuration.clearProperty("ip_filter");
        }
        for (String removedKey : REMOVED_KEYS) {
            this.configuration.clearProperty(removedKey);
        }
        this.tempFolder = new TempFolder(this.getString(KEY_TEMP_FOLDER_PATH, null));
        this.programPaths = new ConfigurableProgramPaths(this.configuration);
        PMS.setLocale(this.getLanguageLocale(true));
        Locale.setDefault(this.getLanguageLocale());
        if ("".equals(this.getJwtSecret())) {
            String string = UUID.randomUUID().toString();
            this.setJwtSecret(string.substring(0, string.indexOf("-")));
        }
    }

    protected UmsConfiguration(Configuration configuration, ConfigurationReader configurationReader) {
        super(configuration, configurationReader);
        this.tempFolder = new TempFolder(this.getString(KEY_TEMP_FOLDER_PATH, null));
        this.programPaths = new ConfigurableProgramPaths(configuration);
    }

    private static String verifyLogFolder(File folder, String fallbackTo) {
        try {
            FilePermissions permissions = FileUtil.getFilePermissions(folder);
            if (LOGGER.isTraceEnabled()) {
                if (!permissions.isFolder()) {
                    LOGGER.trace("getDefaultLogFileFolder: \"{}\" is not a folder, falling back to {} for logging", (Object)folder.getAbsolutePath(), (Object)fallbackTo);
                } else if (!permissions.isBrowsable()) {
                    LOGGER.trace("getDefaultLogFileFolder: \"{}\" is not browsable, falling back to {} for logging", (Object)folder.getAbsolutePath(), (Object)fallbackTo);
                } else if (!permissions.isWritable()) {
                    LOGGER.trace("getDefaultLogFileFolder: \"{}\" is not writable, falling back to {} for logging", (Object)folder.getAbsolutePath(), (Object)fallbackTo);
                }
            }
            if (permissions.isFolder() && permissions.isBrowsable() && permissions.isWritable()) {
                if (LOGGER.isDebugEnabled()) {
                    LOGGER.debug("Default logfile folder set to: {}", (Object)folder.getAbsolutePath());
                }
                return folder.getAbsolutePath();
            }
        }
        catch (FileNotFoundException e) {
            LOGGER.trace("getDefaultLogFileFolder: \"{}\" not found, falling back to {} for logging: {}", folder.getAbsolutePath(), fallbackTo, e.getMessage());
        }
        return null;
    }

    public synchronized String getDefaultLogFileFolder() {
        if (this.defaultLogFileDir == null) {
            if (Platform.isLinux()) {
                File logDirectory;
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("getDefaultLogFileFolder: System is Linux, trying \"/var/log/UMS/{}/\"", (Object)System.getProperty("user.name"));
                }
                if (!(logDirectory = new File("/var/log/UMS/" + System.getProperty("user.name") + "/")).exists()) {
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("getDefaultLogFileFolder: Trying to create: \"{}\"", (Object)logDirectory.getAbsolutePath());
                    }
                    try {
                        FileUtils.forceMkdir(logDirectory);
                        if (LOGGER.isTraceEnabled()) {
                            LOGGER.trace("getDefaultLogFileFolder: \"{}\" created", (Object)logDirectory.getAbsolutePath());
                        }
                    }
                    catch (IOException e) {
                        LOGGER.debug("Could not create \"{}\": {}", (Object)logDirectory.getAbsolutePath(), (Object)e.getMessage());
                    }
                }
                this.defaultLogFileDir = UmsConfiguration.verifyLogFolder(logDirectory, "profile folder");
            }
            if (this.defaultLogFileDir == null) {
                File profileDirectory = new File(PROFILE_DIRECTORY);
                this.defaultLogFileDir = UmsConfiguration.verifyLogFolder(profileDirectory, "temporary folder");
            }
            if (this.defaultLogFileDir == null) {
                try {
                    this.defaultLogFileDir = UmsConfiguration.verifyLogFolder(this.getTempFolder(), "working folder");
                }
                catch (IOException e) {
                    LOGGER.error("Could not determine default logfile folder, falling back to working directory: {}", (Object)e.getMessage());
                    this.defaultLogFileDir = "";
                }
            }
        }
        return this.defaultLogFileDir;
    }

    public String getDefaultLogFileName() {
        String s = this.getString(KEY_LOGGING_LOGFILE_NAME, "debug.log");
        if (FileUtil.isValidFileName(s)) {
            return s;
        }
        return "debug.log";
    }

    public String getDefaultLogFilePath() {
        return FileUtil.appendPathSeparator(this.getDefaultLogFileFolder()) + this.getDefaultLogFileName();
    }

    public String getDefaultZippedLogFileFolder() {
        if (this.defaultZippedLogFileDir == null) {
            File zippedLogDir = new File(System.getProperty("user.home") + File.separator + "Desktop" + File.separator + "UMS-log");
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("getDefaultLogFileFolder: Trying \"{}\"", (Object)zippedLogDir.getAbsolutePath());
            }
            if (!zippedLogDir.exists()) {
                if (LOGGER.isTraceEnabled()) {
                    LOGGER.trace("getDefaultLogFileFolder: Trying to create: \"{}\"", (Object)zippedLogDir.getAbsolutePath());
                }
                try {
                    FileUtils.forceMkdir(zippedLogDir);
                    if (LOGGER.isTraceEnabled()) {
                        LOGGER.trace("getDefaultLogFileFolder: \"{}\" created", (Object)zippedLogDir.getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    LOGGER.debug("Could not create \"{}\": {}", (Object)zippedLogDir.getAbsolutePath(), (Object)e.getMessage());
                }
            }
            this.defaultZippedLogFileDir = UmsConfiguration.verifyLogFolder(zippedLogDir, "UMS log file path");
        }
        if (this.defaultZippedLogFileDir == null) {
            this.defaultZippedLogFileDir = this.getDefaultLogFilePath();
        }
        return this.defaultZippedLogFileDir;
    }

    public File getTempFolder() throws IOException {
        return this.tempFolder.getTempFolder();
    }

    public LogSystemInformationMode getLogSystemInformation() {
        LogSystemInformationMode defaultValue = LogSystemInformationMode.TRACE_ONLY;
        String value = this.getString(KEY_LOG_SYSTEM_INFO, defaultValue.toString());
        LogSystemInformationMode result = LogSystemInformationMode.typeOf(value);
        return result != null ? result : defaultValue;
    }

    public int getMencoderMaxThreads() {
        return Math.min(this.getInt(KEY_MENCODER_MAX_THREADS, this.getNumberOfCpuCores()), 8);
    }

    public boolean isCustomProgramPathsSupported() {
        return this.programPaths instanceof ConfigurableProgramPaths;
    }

    public boolean isAudioUpdateTag() {
        return this.getBoolean(KEY_AUDIO_UPDATE_RATING_TAG, false);
    }

    @Nullable
    public ProgramExecutableType getEngineExecutableType(@Nonnull Engine engine) {
        if (engine == null) {
            throw new IllegalArgumentException("engine cannot be null");
        }
        ProgramExecutableType executableType = ProgramExecutableType.toProgramExecutableType(this.getString(engine.getExecutableTypeKey(), null), engine.getProgramInfo().getDefault());
        return executableType == null ? engine.getCurrentExecutableType() : executableType;
    }

    public boolean setEngineExecutableType(@Nonnull Engine engine, @Nonnull ProgramExecutableType executableType) {
        if (engine == null) {
            throw new IllegalArgumentException("engine cannot be null");
        }
        if (executableType == null) {
            throw new IllegalArgumentException("executableType cannot be null");
        }
        String key = engine.getExecutableTypeKey();
        if (key != null) {
            String currentValue = this.configuration.getString(key);
            String newValue = executableType.toRootString();
            if (newValue.equals(currentValue)) {
                return false;
            }
            this.configuration.setProperty(key, newValue);
            engine.determineCurrentExecutableType(executableType);
            return true;
        }
        return false;
    }

    @Nullable
    public Path getEngineCustomPath(@Nullable EngineId engineId) {
        if (engineId == null) {
            return null;
        }
        return this.getEngineCustomPath(EngineFactory.getEngine(engineId, false, false));
    }

    @Nullable
    public Path getEngineCustomPath(@Nullable Engine engine) {
        if (engine == null || StringUtils.isBlank(engine.getConfigurablePathKey()) || !(this.programPaths instanceof ConfigurableProgramPaths)) {
            return null;
        }
        try {
            return ((ConfigurableProgramPaths)this.programPaths).getCustomProgramPath(engine.getConfigurablePathKey());
        }
        catch (ConfigurationException e) {
            LOGGER.warn("An invalid executable path is configured for transcoding engine {}. The path is being ignored: {}", (Object)engine, (Object)e.getMessage());
            LOGGER.trace("", e);
            return null;
        }
    }

    public boolean setEngineCustomPath(@Nonnull Engine engine, @Nullable Path path) {
        if (engine == null) {
            throw new IllegalArgumentException("engine cannot be null");
        }
        if (StringUtils.isBlank(engine.getConfigurablePathKey())) {
            throw new IllegalStateException("Can't set custom executable path for engine " + engine + "because it has no configurable path key");
        }
        if (!this.isCustomProgramPathsSupported()) {
            throw new IllegalStateException("The program paths aren't configurable");
        }
        return ((ConfigurableProgramPaths)this.programPaths).setCustomProgramPathConfiguration(path, engine.getConfigurablePathKey());
    }

    @Nullable
    public ExternalProgramInfo getVLCPaths() {
        return this.programPaths.getVLC();
    }

    @Nullable
    public ExternalProgramInfo getMEncoderPaths() {
        return this.programPaths.getMEncoder();
    }

    @Nullable
    public ExternalProgramInfo getDCRawPaths() {
        return this.programPaths.getDCRaw();
    }

    @Nullable
    public ExternalProgramInfo getFFmpegPaths() {
        return this.programPaths.getFFmpeg();
    }

    @Nullable
    public String getFFmpegPath() {
        Path executable = null;
        ExternalProgramInfo ffmpegPaths = this.getFFmpegPaths();
        if (ffmpegPaths != null) {
            executable = ffmpegPaths.getDefaultPath();
        }
        return executable == null ? null : executable.toString();
    }

    @Nullable
    public ExternalProgramInfo getMPlayerPaths() {
        return this.programPaths.getMPlayer();
    }

    @Nullable
    public String getMPlayerPath() {
        Path executable = null;
        ExternalProgramInfo mPlayerPaths = this.getMPlayerPaths();
        if (mPlayerPaths != null) {
            ProgramExecutableType executableType = ProgramExecutableType.toProgramExecutableType("mplayer_executable_type", mPlayerPaths.getDefault());
            if (executableType != null) {
                executable = mPlayerPaths.getPath(executableType);
            }
            if (executable == null) {
                executable = mPlayerPaths.getDefaultPath();
            }
        }
        return executable == null ? null : executable.toString();
    }

    public void setCustomMPlayerPath(@Nullable Path customPath) {
        if (!this.isCustomProgramPathsSupported()) {
            throw new IllegalStateException("The program paths aren't configurable");
        }
        ((ConfigurableProgramPaths)this.programPaths).setCustomMPlayerPath(customPath);
    }

    @Nullable
    public ExternalProgramInfo getTsMuxeRPaths() {
        return this.programPaths.getTsMuxeR();
    }

    @Nullable
    public ExternalProgramInfo getFLACPaths() {
        return this.programPaths.getFLAC();
    }

    @Nullable
    public String getFLACPath() {
        Path executable = null;
        ExternalProgramInfo flacPaths = this.getFLACPaths();
        if (flacPaths != null) {
            ProgramExecutableType executableType = ProgramExecutableType.toProgramExecutableType("flac_executable_type", flacPaths.getDefault());
            if (executableType != null) {
                executable = flacPaths.getPath(executableType);
            }
            if (executable == null) {
                executable = flacPaths.getDefaultPath();
            }
        }
        return executable == null ? null : executable.toString();
    }

    public void setCustomFlacPath(@Nullable Path customPath) {
        if (!this.isCustomProgramPathsSupported()) {
            throw new IllegalStateException("The program paths aren't configurable");
        }
        ((ConfigurableProgramPaths)this.programPaths).setCustomFlacPath(customPath);
    }

    @Nullable
    public ExternalProgramInfo getAviSynthPaths() {
        return this.programPaths.getAviSynth();
    }

    @Nullable
    public String getAviSynthPath() {
        Path executable = null;
        ExternalProgramInfo aviSynthPaths = this.getAviSynthPaths();
        if (aviSynthPaths != null) {
            executable = aviSynthPaths.getDefaultPath();
        }
        return executable == null ? null : executable.toString();
    }

    @Nullable
    public ExternalProgramInfo getInterFramePaths() {
        return this.programPaths.getInterFrame();
    }

    @Nullable
    public String getInterFramePath() {
        Path executable = null;
        ExternalProgramInfo interFramePaths = this.getInterFramePaths();
        if (interFramePaths != null) {
            ProgramExecutableType executableType = ProgramExecutableType.toProgramExecutableType("interframe_executable_type", interFramePaths.getDefault());
            if (executableType != null) {
                executable = interFramePaths.getPath(executableType);
            }
            if (executable == null) {
                executable = interFramePaths.getDefaultPath();
            }
        }
        return executable == null ? null : executable.toString();
    }

    @Nullable
    public ExternalProgramInfo getDirectShowSourcePaths() {
        return this.programPaths.getDirectShowSource();
    }

    @Nullable
    public ExternalProgramInfo getFFMS2Paths() {
        return this.programPaths.getFFMS2();
    }

    @Nullable
    public String getFFMS2Path() {
        Path executable = null;
        ExternalProgramInfo ffms2Paths = this.getFFMS2Paths();
        if (ffms2Paths != null) {
            ProgramExecutableType executableType = ProgramExecutableType.toProgramExecutableType("ffms2_executable_type", ffms2Paths.getDefault());
            if (executableType != null) {
                executable = ffms2Paths.getPath(executableType);
            }
            if (executable == null) {
                executable = ffms2Paths.getDefaultPath();
            }
        }
        return executable == null ? null : executable.toString();
    }

    @Nullable
    public ExternalProgramInfo getMvtools2Paths() {
        return this.programPaths.getMvtools2();
    }

    @Nullable
    public ExternalProgramInfo getDepanPaths() {
        return this.programPaths.getDepan();
    }

    @Nullable
    public ExternalProgramInfo getMasktools2Paths() {
        return this.programPaths.getMasktools2();
    }

    @Nullable
    public String getMvtools2Path() {
        Path executable = null;
        ExternalProgramInfo mvtools2Paths = this.getMvtools2Paths();
        if (mvtools2Paths != null) {
            executable = mvtools2Paths.getDefaultPath();
        }
        return executable == null ? null : executable.toString();
    }

    @Nullable
    public String getDepanPath() {
        Path executable = null;
        ExternalProgramInfo depanPaths = this.getDepanPaths();
        if (depanPaths != null) {
            executable = depanPaths.getDefaultPath();
        }
        return executable == null ? null : executable.toString();
    }

    @Nullable
    public String getMasktools2Path() {
        Path executable = null;
        ExternalProgramInfo masktools2Paths = this.getMasktools2Paths();
        if (masktools2Paths != null) {
            executable = masktools2Paths.getDefaultPath();
        }
        return executable == null ? null : executable.toString();
    }

    @Nullable
    public ExternalProgramInfo getConvert2dTo3dPaths() {
        return this.programPaths.getConvert2dTo3d();
    }

    @Nullable
    public String getConvert2dTo3dPath() {
        Path executable = null;
        ExternalProgramInfo convert2dTo3dPaths = this.getConvert2dTo3dPaths();
        if (convert2dTo3dPaths != null) {
            ProgramExecutableType executableType = ProgramExecutableType.toProgramExecutableType("2DTO3D_executable_type", convert2dTo3dPaths.getDefault());
            if (executableType != null) {
                executable = convert2dTo3dPaths.getPath(executableType);
            }
            if (executable == null) {
                executable = convert2dTo3dPaths.getDefaultPath();
            }
        }
        return executable == null ? null : executable.toString();
    }

    @Nullable
    public ExternalProgramInfo getCropResizePaths() {
        return this.programPaths.getCropResize();
    }

    @Nullable
    public String getCropResizePath() {
        Path executable = null;
        ExternalProgramInfo cropResizePaths = this.getCropResizePaths();
        if (cropResizePaths != null) {
            ProgramExecutableType executableType = ProgramExecutableType.toProgramExecutableType("cropResize_executable_type", cropResizePaths.getDefault());
            if (executableType != null) {
                executable = cropResizePaths.getPath(executableType);
            }
            if (executable == null) {
                executable = cropResizePaths.getDefaultPath();
            }
        }
        return executable == null ? null : executable.toString();
    }

    public void setCustomInterFramePath(@Nullable Path customPath) {
        if (!this.isCustomProgramPathsSupported()) {
            throw new IllegalStateException("The program paths aren't configurable");
        }
        ((ConfigurableProgramPaths)this.programPaths).setCustomInterFramePath(customPath);
    }

    public void setCustomFFMS2Path(@Nullable Path customPath) {
        if (!this.isCustomProgramPathsSupported()) {
            throw new IllegalStateException("The program paths aren't configurable");
        }
        ((ConfigurableProgramPaths)this.programPaths).setCustomFFMS2Path(customPath);
    }

    public void setCustomConvert2dTo3dPath(@Nullable Path customPath) {
        if (!this.isCustomProgramPathsSupported()) {
            throw new IllegalStateException("The program paths aren't configurable");
        }
        ((ConfigurableProgramPaths)this.programPaths).setCustomConvert2dTo3dPath(customPath);
    }

    public void setCustomCropResizePath(@Nullable Path customPath) {
        if (!this.isCustomProgramPathsSupported()) {
            throw new IllegalStateException("The program paths aren't configurable");
        }
        ((ConfigurableProgramPaths)this.programPaths).setCustomCropResizePath(customPath);
    }

    @Nullable
    public ExternalProgramInfo getYoutubeDlPaths() {
        return this.programPaths.getYoutubeDl();
    }

    @Nullable
    public String getYoutubeDlPath() {
        Path executable = null;
        ExternalProgramInfo youtubeDlPaths = this.getYoutubeDlPaths();
        if (youtubeDlPaths != null) {
            executable = youtubeDlPaths.getDefaultPath();
        }
        return executable != null ? executable.toString() : null;
    }

    public boolean isTsmuxerForceFps() {
        return this.getBoolean(KEY_TSMUXER_FORCEFPS, true);
    }

    public int getAudioBitrate() {
        return this.getInt(KEY_AUDIO_BITRATE, 448);
    }

    public boolean useNextcpApi() {
        return !"".equals(this.getNextcpApiKey());
    }

    public String getNextcpApiKey() {
        return this.getString(KEY_NEXTCP_API_KEY, "");
    }

    public final String getJwtSecret() {
        return this.configuration.getString(KEY_JWT_SIGNER_SECRET, "");
    }

    public final void setJwtSecret(String value) {
        this.configuration.setProperty(KEY_JWT_SIGNER_SECRET, value);
    }

    public void setTsmuxerForceFps(boolean value) {
        this.configuration.setProperty(KEY_TSMUXER_FORCEFPS, value);
    }

    public int getMediaServerPort() {
        return this.getInt(KEY_SERVER_PORT, 5001);
    }

    public void setMediaServerPort(int value) {
        this.configuration.setProperty(KEY_SERVER_PORT, value);
    }

    public String getServerHostname() {
        return this.getString(KEY_SERVER_HOSTNAME, null);
    }

    public void setHostname(String value) {
        this.configuration.setProperty(KEY_SERVER_HOSTNAME, value);
    }

    public String getServerDisplayName() {
        if (this.isAppendProfileName()) {
            return String.format("%s [%s]", this.getString(KEY_SERVER_NAME, PMS.NAME), this.getProfileName());
        }
        return this.getString(KEY_SERVER_NAME, PMS.NAME);
    }

    public String getServerName() {
        return this.getString(KEY_SERVER_NAME, PMS.NAME);
    }

    public void setServerName(String value) {
        this.configuration.setProperty(KEY_SERVER_NAME, value);
    }

    public String getLanguageRawString() {
        return this.configuration.getString(KEY_LANGUAGE);
    }

    public String getTranslationLanguage(String lang) {
        if (lang == null) {
            lang = this.getLanguageRawString();
        }
        if (lang == null) {
            lang = PMS.getLocale().toLanguageTag();
        }
        if (lang != null) {
            return lang.toLowerCase();
        }
        return "en-us";
    }

    public final Locale getLanguageLocale(boolean log) {
        String languageCode = this.configuration.getString(KEY_LANGUAGE);
        Locale locale = null;
        if (languageCode != null && !languageCode.isEmpty()) {
            locale = Languages.toLocale(Locale.forLanguageTag(languageCode));
            if (log && locale == null) {
                LOGGER.error("Invalid or unsupported language tag \"{}\", defaulting to OS language.", (Object)languageCode);
            }
        } else if (log) {
            LOGGER.info("Language not specified, defaulting to OS language.");
        }
        if (locale == null) {
            locale = Languages.toLocale(Locale.getDefault());
            if (log && locale == null) {
                LOGGER.error("Unsupported language tag \"{}\", defaulting to US English.", (Object)Locale.getDefault().toLanguageTag());
            }
        }
        if (locale == null) {
            locale = Locale.forLanguageTag("en-US");
        }
        return locale;
    }

    public final Locale getLanguageLocale() {
        return this.getLanguageLocale(false);
    }

    public String getLanguageTag() {
        return this.getLanguageLocale().toLanguageTag();
    }

    public void setLanguage(Locale locale) {
        if (locale != null) {
            if (Languages.isValid(locale)) {
                this.configuration.setProperty(KEY_LANGUAGE, Languages.toLanguageTag(locale));
                PMS.setLocale(Languages.toLocale(locale));
                Locale.setDefault(Languages.toLocale(locale));
            } else {
                LOGGER.error("setLanguage() aborted because of unsupported language tag \"{}\"", (Object)locale.toLanguageTag());
            }
        } else {
            this.configuration.setProperty(KEY_LANGUAGE, "");
        }
    }

    public void setLanguage(String value) {
        if (value != null && !value.isEmpty()) {
            this.setLanguage(Locale.forLanguageTag(value));
        } else {
            LOGGER.error("setLanguage() aborted because language tag is empty");
        }
    }

    public int getMinMemoryBufferSize() {
        return this.getInt(KEY_MIN_MEMORY_BUFFER_SIZE, 12);
    }

    public int getMaxMemoryBufferSize() {
        return Math.max(0, Math.min(maxMaxMemoryBufferSize, this.getInt(KEY_MAX_MEMORY_BUFFER_SIZE, 200)));
    }

    public void setMaxMemoryBufferSize(int value) {
        this.configuration.setProperty(KEY_MAX_MEMORY_BUFFER_SIZE, Math.max(0, Math.min(maxMaxMemoryBufferSize, value)));
    }

    public String getAssScale() {
        return this.getString(KEY_ASS_SCALE, "1.4");
    }

    public boolean isMencoderAc3Fixed() {
        return this.getBoolean(KEY_MENCODER_AC3_FIXED, false);
    }

    public String getAssMargin() {
        return this.getString(KEY_ASS_MARGIN, "10");
    }

    public String getAssOutline() {
        return this.getString(KEY_ASS_OUTLINE, "1");
    }

    public String getAssShadow() {
        return this.getString(KEY_ASS_SHADOW, "1");
    }

    public String getMencoderNoAssScale() {
        return this.getString(KEY_MENCODER_NOASS_SCALE, "3");
    }

    public String getMencoderNoAssSubPos() {
        return this.getString(KEY_MENCODER_NOASS_SUBPOS, "2");
    }

    public String getMencoderNoAssBlur() {
        return this.getString(KEY_MENCODER_NOASS_BLUR, "1");
    }

    public String getMencoderNoAssOutline() {
        return this.getString(KEY_MENCODER_NOASS_OUTLINE, "1");
    }

    public void setMencoderNoAssOutline(String value) {
        this.configuration.setProperty(KEY_MENCODER_NOASS_OUTLINE, value);
    }

    public void setMencoderAc3Fixed(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_AC3_FIXED, value);
    }

    public void setAssMargin(String value) {
        this.configuration.setProperty(KEY_ASS_MARGIN, value);
    }

    public void setAssOutline(String value) {
        this.configuration.setProperty(KEY_ASS_OUTLINE, value);
    }

    public void setAssShadow(String value) {
        this.configuration.setProperty(KEY_ASS_SHADOW, value);
    }

    public void setAssScale(String value) {
        this.configuration.setProperty(KEY_ASS_SCALE, value);
    }

    public void setMencoderNoAssScale(String value) {
        this.configuration.setProperty(KEY_MENCODER_NOASS_SCALE, value);
    }

    public void setMencoderNoAssBlur(String value) {
        this.configuration.setProperty(KEY_MENCODER_NOASS_BLUR, value);
    }

    public void setMencoderNoAssSubPos(String value) {
        this.configuration.setProperty(KEY_MENCODER_NOASS_SUBPOS, value);
    }

    public void setMencoderMaxThreads(int value) {
        this.configuration.setProperty(KEY_MENCODER_MAX_THREADS, value);
    }

    public boolean isMencoderAss() {
        return this.getBoolean(KEY_MENCODER_ASS, true);
    }

    public boolean isDisableSubtitles() {
        return this.getBoolean(KEY_DISABLE_SUBTITLES, false);
    }

    public void setDisableSubtitles(boolean value) {
        this.configuration.setProperty(KEY_DISABLE_SUBTITLES, value);
    }

    public boolean isAudioUsePCM() {
        return this.getBoolean(KEY_AUDIO_USE_PCM, false);
    }

    public boolean isMencoderUsePcmForHQAudioOnly() {
        return this.getBoolean(KEY_MENCODER_USE_PCM_FOR_HQ_AUDIO_ONLY, false);
    }

    public String getFont() {
        return this.getString(KEY_SUBS_FONT, "");
    }

    public String getAudioLanguages() {
        return this.configurationReader.getPossiblyBlankConfigurationString(KEY_AUDIO_LANGUAGES, Messages.getConfigurationString("AudioLanguages"));
    }

    public String getSubtitlesLanguages() {
        return this.configurationReader.getPossiblyBlankConfigurationString(KEY_SUBTITLES_LANGUAGES, Messages.getConfigurationString("SubtitlesLanguages"));
    }

    public String getForcedSubtitleLanguage() {
        return this.configurationReader.getPossiblyBlankConfigurationString(KEY_FORCED_SUBTITLE_LANGUAGE, PMS.getLocale().getLanguage());
    }

    public String getForcedSubtitleTags() {
        return this.getString(KEY_FORCED_SUBTITLE_TAGS, "forced");
    }

    public String getAudioSubLanguages() {
        return this.configurationReader.getPossiblyBlankConfigurationString(KEY_AUDIO_SUB_LANGS, Messages.getConfigurationString("AudioSubtitlesPairs"));
    }

    public void setAudioSubLanguages(String value) {
        this.configuration.setProperty(KEY_AUDIO_SUB_LANGS, value);
    }

    public boolean isMencoderSubFribidi() {
        return this.getBoolean(KEY_MENCODER_SUB_FRIBIDI, false);
    }

    public String getSubtitlesCodepage() {
        return this.getString(KEY_SUBTITLES_CODEPAGE, "");
    }

    public boolean isMencoderFontConfig() {
        return this.getBoolean(KEY_MENCODER_FONT_CONFIG, true);
    }

    public void setMencoderForceFps(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_FORCE_FPS, value);
    }

    public boolean isMencoderForceFps() {
        return this.getBoolean(KEY_MENCODER_FORCE_FPS, false);
    }

    public void setAudioLanguages(String value) {
        this.configuration.setProperty(KEY_AUDIO_LANGUAGES, value);
    }

    public void setSubtitlesLanguages(String value) {
        this.configuration.setProperty(KEY_SUBTITLES_LANGUAGES, value);
    }

    public void setForcedSubtitleLanguage(String value) {
        this.configuration.setProperty(KEY_FORCED_SUBTITLE_LANGUAGE, value);
    }

    public void setForcedSubtitleTags(String value) {
        this.configuration.setProperty(KEY_FORCED_SUBTITLE_TAGS, value);
    }

    public String getMencoderCustomOptions() {
        return this.getString(KEY_MENCODER_CUSTOM_OPTIONS, "");
    }

    public void setMencoderCustomOptions(String value) {
        this.configuration.setProperty(KEY_MENCODER_CUSTOM_OPTIONS, value);
    }

    public void setSubtitlesCodepage(String value) {
        this.configuration.setProperty(KEY_SUBTITLES_CODEPAGE, value);
    }

    public void setMencoderSubFribidi(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_SUB_FRIBIDI, value);
    }

    public void setFont(String value) {
        this.configuration.setProperty(KEY_SUBS_FONT, value);
    }

    public void setMencoderAss(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_ASS, value);
    }

    public void setMencoderFontConfig(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_FONT_CONFIG, value);
    }

    public void setAudioUsePCM(boolean value) {
        this.configuration.setProperty(KEY_AUDIO_USE_PCM, value);
    }

    public void setMencoderUsePcmForHQAudioOnly(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_USE_PCM_FOR_HQ_AUDIO_ONLY, value);
    }

    public boolean isArchiveBrowsing() {
        return this.getBoolean(KEY_OPEN_ARCHIVES, false);
    }

    public void setArchiveBrowsing(boolean value) {
        this.configuration.setProperty(KEY_OPEN_ARCHIVES, value);
    }

    public boolean isMencoderYadif() {
        return this.getBoolean(KEY_MENCODER_YADIF, false);
    }

    public void setMencoderYadif(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_YADIF, value);
    }

    public boolean isMencoderScaler() {
        return this.getBoolean(KEY_MENCODER_SCALER, false);
    }

    public void setMencoderScaler(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_SCALER, value);
    }

    public int getMencoderScaleX() {
        return this.getInt(KEY_MENCODER_SCALEX, 0);
    }

    public void setMencoderScaleX(int value) {
        this.configuration.setProperty(KEY_MENCODER_SCALEX, value);
    }

    public int getMencoderScaleY() {
        return this.getInt(KEY_MENCODER_SCALEY, 0);
    }

    public void setMencoderScaleY(int value) {
        this.configuration.setProperty(KEY_MENCODER_SCALEY, value);
    }

    public int getAudioChannelCount() {
        int valueFromUserConfig = this.getInt(KEY_AUDIO_CHANNEL_COUNT, 6);
        if (valueFromUserConfig != 6 && valueFromUserConfig != 2) {
            return 6;
        }
        return valueFromUserConfig;
    }

    public void setAudioChannelCount(int value) {
        if (value != 6 && value != 2) {
            value = 6;
        }
        this.configuration.setProperty(KEY_AUDIO_CHANNEL_COUNT, value);
    }

    public void setAudioBitrate(int value) {
        this.configuration.setProperty(KEY_AUDIO_BITRATE, value);
    }

    public String getMaximumBitrate() {
        Integer maximumBitrate = this.getMaximumBitrateDisplay();
        if (maximumBitrate == 0) {
            maximumBitrate = 1000;
        }
        return maximumBitrate.toString();
    }

    public int getMaximumBitrateDisplay() {
        return this.getInt(KEY_MAX_BITRATE, 90);
    }

    public void setMaximumBitrate(String value) {
        int maximumBitrate;
        try {
            maximumBitrate = Integer.parseInt(value);
        }
        catch (NumberFormatException e) {
            maximumBitrate = 90;
        }
        this.configuration.setProperty(KEY_MAX_BITRATE, maximumBitrate);
    }

    public List<String> getSelectedRenderers() {
        return this.getStringList(KEY_SELECTED_RENDERERS, "All renderers");
    }

    public boolean setSelectedRenderers(String value) {
        if (value.isEmpty()) {
            value = "None";
        }
        if (!value.equals(this.configuration.getString(KEY_SELECTED_RENDERERS, null))) {
            this.configuration.setProperty(KEY_SELECTED_RENDERERS, value);
            return true;
        }
        return false;
    }

    public boolean setSelectedRenderers(List<String> value) {
        if (value == null) {
            return this.setSelectedRenderers("");
        }
        List<String> currentValue = this.getStringList(KEY_SELECTED_RENDERERS, null);
        if (currentValue == null || value.size() != currentValue.size() || !value.containsAll(currentValue)) {
            this.setStringList(KEY_SELECTED_RENDERERS, value);
            return true;
        }
        return false;
    }

    public boolean isThumbnailGenerationEnabled() {
        return this.getBoolean(KEY_THUMBNAIL_GENERATION_ENABLED, true);
    }

    public void setThumbnailGenerationEnabled(boolean value) {
        this.configuration.setProperty(KEY_THUMBNAIL_GENERATION_ENABLED, value);
    }

    public int getThumbnailSeekPos() {
        return this.getInt(KEY_THUMBNAIL_SEEK_POS, 4);
    }

    public void setThumbnailSeekPos(int value) {
        this.configuration.setProperty(KEY_THUMBNAIL_SEEK_POS, value);
    }

    public boolean getImageThumbnailsEnabled() {
        return this.getBoolean(KEY_IMAGE_THUMBNAILS_ENABLED, true);
    }

    public void setImageThumbnailsEnabled(boolean value) {
        this.configuration.setProperty(KEY_IMAGE_THUMBNAILS_ENABLED, value);
    }

    public int getNumberOfCpuCores() {
        return this.getInt(KEY_NUMBER_OF_CPU_CORES, UmsConfiguration.getNumberOfSystemCpuCores());
    }

    public static int getNumberOfSystemCpuCores() {
        return Math.max(1, Runtime.getRuntime().availableProcessors());
    }

    public void setNumberOfCpuCores(int value) {
        this.configuration.setProperty(KEY_NUMBER_OF_CPU_CORES, value);
    }

    public boolean isMinimized() {
        return this.getBoolean(KEY_MINIMIZED, true);
    }

    public void setMinimized(boolean value) {
        this.configuration.setProperty(KEY_MINIMIZED, value);
    }

    public boolean isWebGuiOnStart() {
        return this.getBoolean(KEY_WEB_GUI_ON_START, true);
    }

    public void setWebGuiOnStart(boolean value) {
        this.configuration.setProperty(KEY_WEB_GUI_ON_START, value);
    }

    public boolean isAutoStart() {
        File f;
        return Platform.isWindows() && (f = new File(WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Common Startup") + "\\Universal Media Server.lnk")).exists();
    }

    public void setAutoStart(boolean value) {
        block10: {
            File sourceFile = new File(WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Common Programs") + "\\Universal Media Server.lnk");
            File destinationFile = new File(WindowsRegistry.readRegistry("HKLM\\SOFTWARE\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders", "Common Startup") + "\\Universal Media Server.lnk");
            if (value) {
                try {
                    FileUtils.copyFile(sourceFile, destinationFile);
                    if (destinationFile.exists()) {
                        LOGGER.info("UMS will start automatically with Windows");
                        break block10;
                    }
                    LOGGER.info("An error occurred while trying to make UMS start automatically with Windows");
                }
                catch (IOException e) {
                    if (!PlatformUtils.INSTANCE.isAdmin()) {
                        try {
                            GuiManager.showErrorMessage(Messages.getGuiString("UmsMustRunAdministrator"), Messages.getGuiString("PermissionsError"));
                        }
                        catch (NullPointerException nullPointerException) {}
                        break block10;
                    }
                    LOGGER.info("An error occurred while trying to make UMS start automatically with Windows");
                }
            } else if (destinationFile.delete()) {
                LOGGER.info("UMS will not start automatically with Windows");
            } else {
                LOGGER.info("An error occurred while trying to make UMS not start automatically with Windows");
            }
        }
    }

    public boolean isAutoloadExternalSubtitles() {
        return this.getBoolean(KEY_AUTOLOAD_SUBTITLES, true) || this.isForceExternalSubtitles();
    }

    public void setAutoloadExternalSubtitles(boolean value) {
        this.configuration.setProperty(KEY_AUTOLOAD_SUBTITLES, value);
    }

    public boolean isForceExternalSubtitles() {
        return this.getBoolean(KEY_FORCE_EXTERNAL_SUBTITLES, true);
    }

    public void setForceExternalSubtitles(boolean value) {
        this.configuration.setProperty(KEY_FORCE_EXTERNAL_SUBTITLES, value);
    }

    public boolean isShowServerSettingsFolder() {
        return this.getBoolean(KEY_SHOW_SERVER_SETTINGS_FOLDER, false);
    }

    public void setShowServerSettingsFolder(boolean value) {
        this.configuration.setProperty(KEY_SHOW_SERVER_SETTINGS_FOLDER, value);
    }

    public FullyPlayedAction getFullyPlayedAction() {
        return FullyPlayedAction.typeOf(this.getInt(KEY_FULLY_PLAYED_ACTION, FullyPlayedAction.MARK.getValue()), FullyPlayedAction.MARK);
    }

    public void setFullyPlayedAction(FullyPlayedAction action) {
        this.configuration.setProperty(KEY_FULLY_PLAYED_ACTION, action.getValue());
    }

    public String getFullyPlayedOutputDirectory() {
        return this.getString(KEY_FULLY_PLAYED_OUTPUT_DIRECTORY, "");
    }

    public void setFullyPlayedOutputDirectory(String value) {
        this.configuration.setProperty(KEY_FULLY_PLAYED_OUTPUT_DIRECTORY, value);
    }

    public void setAvisynthConvertFps(boolean value) {
        this.configuration.setProperty(KEY_AVISYNTH_CONVERT_FPS, value);
    }

    public boolean getAvisynthConvertFps() {
        return this.getBoolean(KEY_AVISYNTH_CONVERT_FPS, true);
    }

    public void setAvisynthInterFrame(boolean value) {
        this.configuration.setProperty(KEY_AVISYNTH_INTERFRAME, value);
    }

    public boolean getAvisynthInterFrame() {
        return this.getBoolean(KEY_AVISYNTH_INTERFRAME, false);
    }

    public void setAvisynthInterFrameGPU(boolean value) {
        this.configuration.setProperty(KEY_AVISYNTH_INTERFRAME_GPU, value);
    }

    public boolean getAvisynthInterFrameGPU() {
        return this.getBoolean(KEY_AVISYNTH_INTERFRAME_GPU, false);
    }

    public void setAvisynthMultiThreading(boolean value) {
        this.configuration.setProperty(KEY_AVISYNTH_MULTITHREADING, value);
    }

    public boolean getAvisynthMultiThreading() {
        return this.getBoolean(KEY_AVISYNTH_MULTITHREADING, false);
    }

    public String getAvisynthScript() {
        return this.getString(KEY_AVISYNTH_SCRIPT, defaultAviSynthScript);
    }

    public void setAvisynthScript(String value) {
        this.configuration.setProperty(KEY_AVISYNTH_SCRIPT, value);
    }

    public String getMencoderCodecSpecificConfig() {
        return this.getString(KEY_MENCODER_CODEC_SPECIFIC_SCRIPT, "");
    }

    public void setMencoderCodecSpecificConfig(String value) {
        this.configuration.setProperty(KEY_MENCODER_CODEC_SPECIFIC_SCRIPT, value);
    }

    public int getMaxAudioBuffer() {
        return this.getInt(KEY_MAX_AUDIO_BUFFER, 100);
    }

    public int getMinStreamBuffer() {
        return this.getInt(KEY_MIN_STREAM_BUFFER, 1);
    }

    public String getMPEG2MainSettingsFFmpeg() {
        String mpegSettings = this.getMPEG2MainSettings();
        if (StringUtils.isBlank(mpegSettings) || mpegSettings.contains("Automatic")) {
            return mpegSettings;
        }
        return this.convertMencoderSettingToFFmpegFormat(mpegSettings);
    }

    public void setFFmpegLoggingLevel(String value) {
        this.configuration.setProperty(KEY_FFMPEG_LOGGING_LEVEL, value);
    }

    public String getFFmpegLoggingLevel() {
        return this.getString(KEY_FFMPEG_LOGGING_LEVEL, "fatal");
    }

    public void setFfmpegMultithreading(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_MULTITHREADING, value);
    }

    public boolean isFfmpegMultithreading() {
        return this.getBoolean(KEY_FFMPEG_MULTITHREADING, this.getNumberOfCpuCores() > 1);
    }

    public String getFFmpegGPUDecodingAccelerationMethod() {
        return this.getString(KEY_FFMPEG_GPU_DECODING_ACCELERATION_METHOD, "none");
    }

    public String getFFmpegGPUH264EncodingAccelerationMethod() {
        return this.getString(KEY_FFMPEG_GPU_ENCODING_H264_ACCELERATION_METHOD, "libx264");
    }

    public String getFFmpegGPUH265EncodingAccelerationMethod() {
        return this.getString(KEY_FFMPEG_GPU_ENCODING_H265_ACCELERATION_METHOD, "libx265");
    }

    public void setFFmpegGPUDecodingAccelerationMethod(String value) {
        this.configuration.setProperty(KEY_FFMPEG_GPU_DECODING_ACCELERATION_METHOD, value);
    }

    public String getFFmpegGPUDecodingAccelerationThreadNumber() {
        return this.getString(KEY_FFMPEG_GPU_DECODING_ACCELERATION_THREAD_NUMBER, "1");
    }

    public void setFFmpegGPUH264EncodingAccelerationMethod(String value) {
        this.configuration.setProperty(KEY_FFMPEG_GPU_ENCODING_H264_ACCELERATION_METHOD, value);
    }

    public void setFFmpegGPUH265EncodingAccelerationMethod(String value) {
        this.configuration.setProperty(KEY_FFMPEG_GPU_ENCODING_H265_ACCELERATION_METHOD, value);
    }

    public void setFFmpegGPUDecodingAccelerationThreadNumber(String value) {
        this.configuration.setProperty(KEY_FFMPEG_GPU_DECODING_ACCELERATION_THREAD_NUMBER, value);
    }

    public String[] getFFmpegAvailableGPUDecodingAccelerationMethods() {
        return this.getString(KEY_FFMPEG_AVAILABLE_GPU_ACCELERATION_METHODS, "none").split(",");
    }

    public static String[] getFFmpegAvailableGPUH264EncodingAccelerationMethods() {
        return new String[]{"libx264", "h264_nvenc", "h264_amf", "h264_qsv", "h264_mf", "libx264rgb"};
    }

    public static String[] getFFmpegAvailableGPUH265EncodingAccelerationMethods() {
        return new String[]{"libx265", "hevc_nvenc", "hevc_amf", "hevc_qsv", "hevc_mf"};
    }

    public void setFFmpegAvailableGPUDecodingAccelerationMethods(List<String> methods) {
        this.configuration.setProperty(KEY_FFMPEG_AVAILABLE_GPU_ACCELERATION_METHODS, UmsConfiguration.collectionToString(methods));
    }

    public void setFfmpegAviSynthMultithreading(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_AVISYNTH_MULTITHREADING, value);
    }

    public boolean isFfmpegAviSynthMultithreading() {
        return this.getBoolean(KEY_FFMPEG_AVISYNTH_MULTITHREADING, this.getNumberOfCpuCores() > 1);
    }

    public void setFfmpegAvisynthConvertFps(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_AVISYNTH_CONVERT_FPS, value);
    }

    public boolean getFfmpegAvisynthConvertFps() {
        return this.getBoolean(KEY_FFMPEG_AVISYNTH_CONVERT_FPS, true);
    }

    public void setFfmpegAvisynthInterFrame(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_AVISYNTH_INTERFRAME, value);
    }

    public boolean getFfmpegAvisynthInterFrame() {
        return this.getBoolean(KEY_FFMPEG_AVISYNTH_INTERFRAME, false);
    }

    public void setFfmpegAvisynthInterFrameGPU(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_AVISYNTH_INTERFRAME_GPU, value);
    }

    public boolean getFfmpegAvisynthInterFrameGPU() {
        return this.getBoolean(KEY_FFMPEG_AVISYNTH_INTERFRAME_GPU, false);
    }

    public void setFfmpegAvisynthUseFFMS2(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_AVISYNTH_USE_FFMS2, value);
    }

    public boolean getFfmpegAvisynthUseFFMS2() {
        return this.getBoolean(KEY_FFMPEG_AVISYNTH_USE_FFMS2, false);
    }

    public void setFfmpegAvisynth2Dto3D(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_AVISYNTH_2D_TO_3D, value);
    }

    public boolean isFfmpegAvisynth2Dto3D() {
        return this.getBoolean(KEY_FFMPEG_AVISYNTH_2D_TO_3D, false);
    }

    public int getFfmpegAvisynthOutputFormat3D() {
        return this.getInt(KEY_FFMPEG_AVISYNTH_OUTPUT_FORMAT_3D, 4);
    }

    public void setFfmpegAvisynthOutputFormat3D(int value) {
        this.configuration.setProperty(KEY_FFMPEG_AVISYNTH_OUTPUT_FORMAT_3D, value);
    }

    public int getFfmpegAvisynthConversionAlgorithm2Dto3D() {
        return this.getInt(KEY_FFMPEG_AVISYNTH_CONVERSION_ALGORITHM_2D_TO_3D, 1);
    }

    public void setFfmpegAvisynthConversionAlgorithm2Dto3D(int value) {
        this.configuration.setProperty(KEY_FFMPEG_AVISYNTH_CONVERSION_ALGORITHM_2D_TO_3D, value);
    }

    public int getFfmpegAvisynthFrameStretchFactor() {
        return this.getInt(KEY_FFMPEG_AVISYNTH_FRAME_STRETCH_FACTOR_2D_TO_3D, 8);
    }

    public void setFfmpegAvisynthFrameStretchFactor(int value) {
        this.configuration.setProperty(KEY_FFMPEG_AVISYNTH_FRAME_STRETCH_FACTOR_2D_TO_3D, value);
    }

    public int getFfmpegAvisynthLightOffsetFactor() {
        return this.getInt(KEY_FFMPEG_AVISYNTH_LIGHT_OFFSET_FACTOR_2D_TO_3D, 3);
    }

    public void setFfmpegAvisynthLightOffsetFactor(int value) {
        this.configuration.setProperty(KEY_FFMPEG_AVISYNTH_LIGHT_OFFSET_FACTOR_2D_TO_3D, value);
    }

    public void setFfmpegAvisynthHorizontalResize(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_AVISYNTH_HORIZONTAL_RESIZE, value);
    }

    public boolean isFfmpegAvisynthHorizontalResize() {
        return this.getBoolean(KEY_FFMPEG_AVISYNTH_HORIZONTAL_RESIZE, true);
    }

    public int getFfmpegAvisynthHorizontalResizeResolution() {
        return this.getInt(KEY_FFMPEG_AVISYNTH_HORIZONTAL_RESIZE_RESOLUTION, 1920);
    }

    public void setFfmpegAvisynthHorizontalResizeResolution(int value) {
        this.configuration.setProperty(KEY_FFMPEG_AVISYNTH_HORIZONTAL_RESIZE_RESOLUTION, value);
    }

    public boolean isMencoderNoOutOfSync() {
        return this.getBoolean(KEY_MENCODER_NO_OUT_OF_SYNC, true);
    }

    public void setMencoderNoOutOfSync(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_NO_OUT_OF_SYNC, value);
    }

    public boolean getTrancodeBlocksMultipleConnections() {
        return this.getBoolean(KEY_TRANSCODE_BLOCKS_MULTIPLE_CONNECTIONS, false);
    }

    public void setTranscodeBlocksMultipleConnections(boolean value) {
        this.configuration.setProperty(KEY_TRANSCODE_BLOCKS_MULTIPLE_CONNECTIONS, value);
    }

    public boolean getTrancodeKeepFirstConnections() {
        return this.getBoolean(KEY_TRANSCODE_KEEP_FIRST_CONNECTION, true);
    }

    public void setTrancodeKeepFirstConnections(boolean value) {
        this.configuration.setProperty(KEY_TRANSCODE_KEEP_FIRST_CONNECTION, value);
    }

    public boolean isMencoderIntelligentSync() {
        return this.getBoolean(KEY_MENCODER_INTELLIGENT_SYNC, true);
    }

    public void setMencoderIntelligentSync(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_INTELLIGENT_SYNC, value);
    }

    public boolean getSkipLoopFilterEnabled() {
        return this.getBoolean(KEY_SKIP_LOOP_FILTER_ENABLED, false);
    }

    public List<String> getSkipNetworkInterfaces() {
        return this.getStringList(KEY_SKIP_NETWORK_INTERFACES, "tap,vmnet,vnic,virtualbox");
    }

    public void setSkipLoopFilterEnabled(boolean value) {
        this.configuration.setProperty(KEY_SKIP_LOOP_FILTER_ENABLED, value);
    }

    public String getMPEG2MainSettings() {
        return this.getString(KEY_MPEG2_MAIN_SETTINGS, "Automatic (Wired)");
    }

    public void setMPEG2MainSettings(String value) {
        this.configuration.setProperty(KEY_MPEG2_MAIN_SETTINGS, value);
    }

    public String getx264ConstantRateFactor() {
        return this.getString(KEY_X264_CONSTANT_RATE_FACTOR, "Automatic (Wired)");
    }

    public void setx264ConstantRateFactor(String value) {
        this.configuration.setProperty(KEY_X264_CONSTANT_RATE_FACTOR, value);
    }

    public String getMencoderVobsubSubtitleQuality() {
        return this.getString(KEY_MENCODER_VOBSUB_SUBTITLE_QUALITY, "3");
    }

    public void setMencoderVobsubSubtitleQuality(String value) {
        this.configuration.setProperty(KEY_MENCODER_VOBSUB_SUBTITLE_QUALITY, value);
    }

    public String getMencoderOverscanCompensationWidth() {
        return this.getString(KEY_MENCODER_OVERSCAN_COMPENSATION_WIDTH, "0");
    }

    public void setMencoderOverscanCompensationWidth(String value) {
        if (value.trim().length() == 0) {
            value = "0";
        }
        this.configuration.setProperty(KEY_MENCODER_OVERSCAN_COMPENSATION_WIDTH, value);
    }

    public String getMencoderOverscanCompensationHeight() {
        return this.getString(KEY_MENCODER_OVERSCAN_COMPENSATION_HEIGHT, "0");
    }

    public void setMencoderOverscanCompensationHeight(String value) {
        if (value.trim().length() == 0) {
            value = "0";
        }
        this.configuration.setProperty(KEY_MENCODER_OVERSCAN_COMPENSATION_HEIGHT, value);
    }

    private void buildEnabledEngines() {
        if (enabledEnginesBuilt) {
            return;
        }
        ENABLED_ENGINES_LOCK.writeLock().lock();
        try {
            if (enabledEnginesBuilt) {
                return;
            }
            String engines = this.configuration.getString(KEY_ENGINES);
            enabledEngines = UmsConfiguration.stringToEngineIdSet(engines);
            if (StringUtils.isBlank(engines)) {
                this.configuration.setProperty(KEY_ENGINES, UmsConfiguration.collectionToString(enabledEngines));
            }
            enabledEnginesBuilt = true;
        }
        finally {
            ENABLED_ENGINES_LOCK.writeLock().unlock();
        }
    }

    public List<EngineId> getEnabledEngines() {
        this.buildEnabledEngines();
        ENABLED_ENGINES_LOCK.readLock().lock();
        try {
            ArrayList<EngineId> arrayList = new ArrayList<EngineId>(enabledEngines);
            return arrayList;
        }
        finally {
            ENABLED_ENGINES_LOCK.readLock().unlock();
        }
    }

    public boolean isEngineEnabled(EngineId id) {
        if (id == null) {
            throw new NullPointerException("id cannot be null");
        }
        this.buildEnabledEngines();
        ENABLED_ENGINES_LOCK.readLock().lock();
        try {
            boolean bl = enabledEngines.contains(id);
            return bl;
        }
        finally {
            ENABLED_ENGINES_LOCK.readLock().unlock();
        }
    }

    public boolean isEngineEnabled(Engine engine) {
        if (engine == null) {
            throw new NullPointerException("engine cannot be null");
        }
        return this.isEngineEnabled(engine.getEngineId());
    }

    public void setEngineEnabled(EngineId id, boolean enabled) {
        if (id == null) {
            throw new IllegalArgumentException("Unrecognized id");
        }
        ENABLED_ENGINES_LOCK.writeLock().lock();
        try {
            this.buildEnabledEngines();
            if (enabledEngines.contains(id)) {
                if (!enabled) {
                    enabledEngines.remove(id);
                }
            } else if (enabled) {
                enabledEngines.add(id);
            }
            this.configuration.setProperty(KEY_ENGINES, UmsConfiguration.collectionToString(enabledEngines));
        }
        finally {
            ENABLED_ENGINES_LOCK.writeLock().unlock();
        }
    }

    public void setEngineEnabled(Engine engine, boolean enabled) {
        this.setEngineEnabled(engine.getEngineId(), enabled);
    }

    public void capitalizeEngineId(Engine engine) {
        String capitalizedEngines;
        if (engine == null) {
            throw new NullPointerException("engine cannot be null");
        }
        String engines = this.configuration.getString(KEY_ENGINES);
        if (StringUtils.isNotBlank(engines) && !engines.equals(capitalizedEngines = StringUtil.caseReplace(engines.trim(), engine.getEngineId().toString()))) {
            this.configuration.setProperty(KEY_ENGINES, capitalizedEngines);
        }
        if (StringUtils.isNotBlank(engines = this.configuration.getString(KEY_ENGINES_PRIORITY)) && !engines.equals(capitalizedEngines = StringUtil.caseReplace(engines.trim(), engine.getEngineId().toString()))) {
            this.configuration.setProperty(KEY_ENGINES_PRIORITY, capitalizedEngines);
        }
    }

    private void buildEnginesPriority() {
        if (enginesPriorityBuilt) {
            return;
        }
        ENGINES_PRIORITY_LOCK.writeLock().lock();
        try {
            if (enginesPriorityBuilt) {
                return;
            }
            String enginesPriorityString = this.configuration.getString(KEY_ENGINES_PRIORITY);
            enginesPriority = UmsConfiguration.stringToEngineIdSet(enginesPriorityString);
            if (StringUtils.isBlank(enginesPriorityString)) {
                this.configuration.setProperty(KEY_ENGINES_PRIORITY, UmsConfiguration.collectionToString(enginesPriority));
            }
            enginesPriorityBuilt = true;
        }
        finally {
            ENGINES_PRIORITY_LOCK.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getEnginePriority(EngineId id) {
        if (id == null) {
            throw new NullPointerException("id cannot be null");
        }
        this.buildEnginesPriority();
        ENGINES_PRIORITY_LOCK.readLock().lock();
        try {
            int index = enginesPriority.indexOf(id);
            if (index >= 0) {
                int n = index;
                return n;
            }
        }
        finally {
            ENGINES_PRIORITY_LOCK.readLock().unlock();
        }
        ENGINES_PRIORITY_LOCK.writeLock().lock();
        try {
            enginesPriority.add(id);
            int n = enginesPriority.indexOf(id);
            return n;
        }
        finally {
            ENGINES_PRIORITY_LOCK.writeLock().unlock();
        }
    }

    public int getEnginePriority(Engine engine) {
        if (engine == null) {
            throw new NullPointerException("engine cannot be null");
        }
        return this.getEnginePriority(engine.getEngineId());
    }

    public void setEnginePriorityAbove(@Nonnull Engine engine, @Nullable Engine aboveEngine) {
        if (engine == null) {
            throw new IllegalArgumentException("engine cannot be null");
        }
        this.setEnginePriorityAbove(engine.getEngineId(), aboveEngine == null ? null : aboveEngine.getEngineId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnginePriorityAbove(EngineId id, EngineId aboveId) {
        if (id == null) {
            throw new IllegalArgumentException("Unrecognized id");
        }
        ENGINES_PRIORITY_LOCK.writeLock().lock();
        try {
            int newPosition;
            this.buildEnginesPriority();
            if (enginesPriority.indexOf(id) > -1) {
                enginesPriority.remove(id);
            }
            if (aboveId == null) {
                newPosition = 0;
            } else {
                newPosition = enginesPriority.indexOf(aboveId);
                if (newPosition < 0) {
                    newPosition = enginesPriority.size();
                }
            }
            enginesPriority.add(newPosition, id);
            this.configuration.setProperty(KEY_ENGINES_PRIORITY, UmsConfiguration.collectionToString(enginesPriority));
        }
        finally {
            ENGINES_PRIORITY_LOCK.writeLock().unlock();
        }
        EngineFactory.sortEngines();
    }

    public void setEnginePriorityBelow(Engine engine, Engine belowEngine) {
        if (engine == null) {
            throw new IllegalArgumentException("engine cannot be null");
        }
        this.setEnginePriorityBelow(engine.getEngineId(), belowEngine == null ? null : belowEngine.getEngineId());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setEnginePriorityBelow(EngineId id, EngineId belowId) {
        if (id == null) {
            throw new IllegalArgumentException("Unrecognized id");
        }
        ENGINES_PRIORITY_LOCK.writeLock().lock();
        try {
            int newPosition;
            this.buildEnginesPriority();
            if (enginesPriority.indexOf(id) > -1) {
                enginesPriority.remove(id);
            }
            if (belowId == null) {
                newPosition = enginesPriority.size();
            } else {
                newPosition = enginesPriority.indexOf(belowId) + 1;
                if (newPosition < 0) {
                    newPosition = enginesPriority.size();
                }
            }
            enginesPriority.add(newPosition, id);
            this.configuration.setProperty(KEY_ENGINES_PRIORITY, UmsConfiguration.collectionToString(enginesPriority));
        }
        finally {
            ENGINES_PRIORITY_LOCK.writeLock().unlock();
        }
        EngineFactory.sortEngines();
    }

    private static String collectionToString(Collection<?> list) {
        return StringUtils.join(list, ',');
    }

    private static List<String> stringToStringList(String input) {
        ArrayList<String> output = new ArrayList<String>();
        Collections.addAll(output, StringUtils.split(input, ','));
        return output;
    }

    private static UniqueList<EngineId> stringToEngineIdSet(String input) {
        UniqueList<EngineId> output = new UniqueList<EngineId>();
        if (StringUtils.isBlank(input)) {
            output.addAll(StandardEngineId.ALL);
            return output;
        }
        if ("none".equals(input = input.trim().toLowerCase(Locale.ROOT))) {
            return output;
        }
        for (String s : StringUtils.split(input, ',')) {
            EngineId engineId = StandardEngineId.toEngineID(s);
            if (engineId != null) {
                output.add(engineId);
                continue;
            }
            LOGGER.warn("Unknown transcoding engine \"{}\"", (Object)s);
        }
        return output;
    }

    public void save() throws ConfigurationException {
        ((PropertiesConfiguration)this.configuration).save();
        LOGGER.info("Configuration saved to \"{}\"", (Object)PROFILE_PATH);
    }

    public void saveConfiguration() {
        try {
            this.save();
        }
        catch (ConfigurationException e) {
            LOGGER.error("Could not save configuration", e);
        }
    }

    @Nonnull
    public List<String> getIgnoredFolderNames() {
        if (!this.ignoredFolderNamesRead) {
            String ignoredFolderNamesString = this.configuration.getString(KEY_FOLDER_NAMES_IGNORED, ".unwanted,$RECYCLE.BIN,System Volume Information");
            if (ignoredFolderNamesString == null || ignoredFolderNamesString.length() == 0) {
                return this.ignoredSystemFolderNames;
            }
            String[] foldersArray = ignoredFolderNamesString.trim().split("\\s*,\\s*");
            this.ignoredFolderNames = new ArrayList();
            for (String folder : foldersArray) {
                folder = folder.replace("&comma;", ",");
                this.ignoredFolderNames.add(folder);
            }
            this.ignoredFolderNames.addAll(this.ignoredSystemFolderNames);
            this.ignoredFolderNamesRead = true;
        }
        return this.ignoredFolderNames;
    }

    public String getNetworkInterface() {
        return this.getString(KEY_NETWORK_INTERFACE, "");
    }

    public void setNetworkInterface(String value) {
        this.configuration.setProperty(KEY_NETWORK_INTERFACE, value);
    }

    public boolean isHideEngineNames() {
        return this.getBoolean(KEY_HIDE_ENGINENAMES, true);
    }

    public void setHideEngineNames(boolean value) {
        this.configuration.setProperty(KEY_HIDE_ENGINENAMES, value);
    }

    public SubtitlesInfoLevel getSubtitlesInfoLevel() {
        SubtitlesInfoLevel subtitlesInfoLevel = SubtitlesInfoLevel.typeOf(this.getString(KEY_SUBS_INFO_LEVEL, null));
        if (subtitlesInfoLevel != null) {
            return subtitlesInfoLevel;
        }
        return SubtitlesInfoLevel.BASIC;
    }

    public void setSubtitlesInfoLevel(SubtitlesInfoLevel value) {
        this.configuration.setProperty(KEY_SUBS_INFO_LEVEL, value == null ? "" : value.toString());
    }

    public boolean isHideExtensions() {
        return this.getBoolean(KEY_HIDE_EXTENSIONS, true);
    }

    public void setHideExtensions(boolean value) {
        this.configuration.setProperty(KEY_HIDE_EXTENSIONS, value);
    }

    public String getDisableTranscodeForExtensions() {
        return this.getString(KEY_DISABLE_TRANSCODE_FOR_EXTENSIONS, "");
    }

    public void setDisableTranscodeForExtensions(String value) {
        this.configuration.setProperty(KEY_DISABLE_TRANSCODE_FOR_EXTENSIONS, value);
    }

    public boolean isDisableTranscoding() {
        return this.getBoolean(KEY_DISABLE_TRANSCODING, false);
    }

    public void setDisableTranscoding(boolean value) {
        this.configuration.setProperty(KEY_DISABLE_TRANSCODING, value);
    }

    public String getForceTranscodeForExtensions() {
        return this.getString(KEY_FORCE_TRANSCODE_FOR_EXTENSIONS, "");
    }

    public void setForceTranscodeForExtensions(String value) {
        this.configuration.setProperty(KEY_FORCE_TRANSCODE_FOR_EXTENSIONS, value);
    }

    public void setMencoderMT(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_MT, value);
    }

    public boolean getMencoderMT() {
        return this.getBoolean(KEY_MENCODER_MT, this.getNumberOfCpuCores() > 1);
    }

    public void setAudioRemuxAC3(boolean value) {
        this.configuration.setProperty(KEY_AUDIO_REMUX_AC3, value);
    }

    public boolean isAudioRemuxAC3() {
        return this.getBoolean(KEY_AUDIO_REMUX_AC3, true);
    }

    public void setFFmpegSoX(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_SOX, value);
    }

    public boolean isFFmpegSoX() {
        return this.getBoolean(KEY_FFMPEG_SOX, false);
    }

    public void setMencoderRemuxMPEG2(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_REMUX_MPEG2, value);
    }

    public boolean isMencoderRemuxMPEG2() {
        return this.getBoolean(KEY_MENCODER_REMUX_MPEG2, true);
    }

    public void setDisableFakeSize(boolean value) {
        this.configuration.setProperty(KEY_DISABLE_FAKESIZE, value);
    }

    public boolean isDisableFakeSize() {
        return this.getBoolean(KEY_DISABLE_FAKESIZE, false);
    }

    public void setUseEmbeddedSubtitlesStyle(boolean value) {
        this.configuration.setProperty(KEY_USE_EMBEDDED_SUBTITLES_STYLE, value);
    }

    public boolean isUseEmbeddedSubtitlesStyle() {
        return this.getBoolean(KEY_USE_EMBEDDED_SUBTITLES_STYLE, true);
    }

    public int getMEncoderOverscan() {
        return this.getInt(KEY_OVERSCAN, 0);
    }

    public void setMEncoderOverscan(int value) {
        this.configuration.setProperty(KEY_OVERSCAN, value);
    }

    private static int findPathSort(String[] paths, String path) throws NumberFormatException {
        for (String path1 : paths) {
            String[] kv = path1.split(",");
            if (kv.length < 2 || !kv[0].equals(path)) continue;
            return Integer.parseInt(kv[1]);
        }
        return -1;
    }

    public int getSortMethod(File path) {
        int cnt = 0;
        String raw = this.getString(KEY_SORT_PATHS, null);
        if (StringUtils.isBlank(raw)) {
            return this.getSortMethod();
        }
        if (Platform.isWindows()) {
            raw = raw.toLowerCase();
        }
        String[] paths = raw.split(" ");
        while (path != null && cnt++ < 100) {
            String key = path.getAbsolutePath();
            if (Platform.isWindows()) {
                key = key.toLowerCase();
            }
            try {
                int ret = UmsConfiguration.findPathSort(paths, key);
                if (ret != -1) {
                    return ret;
                }
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
            path = path.getParentFile();
        }
        return this.getSortMethod();
    }

    public int getSortMethod() {
        return this.getInt(KEY_SORT_METHOD, 0);
    }

    public void setSortMethod(int value) {
        this.configuration.setProperty(KEY_SORT_METHOD, value);
    }

    public CoverSupplier getAudioThumbnailMethod() {
        return CoverSupplier.toCoverSupplier(this.getInt(KEY_AUDIO_THUMBNAILS_METHOD, 1));
    }

    public void setAudioThumbnailMethod(CoverSupplier value) {
        this.configuration.setProperty(KEY_AUDIO_THUMBNAILS_METHOD, value.toInt());
    }

    public String getAlternateThumbFolder() {
        return this.getString(KEY_ALTERNATE_THUMB_FOLDER, "");
    }

    public void setAlternateThumbFolder(String value) {
        this.configuration.setProperty(KEY_ALTERNATE_THUMB_FOLDER, value);
    }

    public String getAlternateSubtitlesFolder() {
        return this.getString(KEY_ALTERNATE_SUBTITLES_FOLDER, "");
    }

    public void setAlternateSubtitlesFolder(String value) {
        this.configuration.setProperty(KEY_ALTERNATE_SUBTITLES_FOLDER, value);
    }

    public void setAudioEmbedDtsInPcm(boolean value) {
        this.configuration.setProperty(KEY_AUDIO_EMBED_DTS_IN_PCM, value);
    }

    public boolean isAudioEmbedDtsInPcm() {
        return this.getBoolean(KEY_AUDIO_EMBED_DTS_IN_PCM, false);
    }

    public void setEncodedAudioPassthrough(boolean value) {
        this.configuration.setProperty(KEY_ENCODED_AUDIO_PASSTHROUGH, value);
    }

    public boolean isEncodedAudioPassthrough() {
        return this.getBoolean(KEY_ENCODED_AUDIO_PASSTHROUGH, false);
    }

    public void setMencoderMuxWhenCompatible(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_MUX_COMPATIBLE, value);
    }

    public boolean isMencoderMuxWhenCompatible() {
        return this.getBoolean(KEY_MENCODER_MUX_COMPATIBLE, false);
    }

    public void setMEncoderNormalizeVolume(boolean value) {
        this.configuration.setProperty(KEY_MENCODER_NORMALIZE_VOLUME, value);
    }

    public boolean isMEncoderNormalizeVolume() {
        return this.getBoolean(KEY_MENCODER_NORMALIZE_VOLUME, false);
    }

    public void setFFmpegMuxWithTsMuxerWhenCompatible(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_MUX_TSMUXER_COMPATIBLE, value);
    }

    public boolean isFFmpegMuxWithTsMuxerWhenCompatible() {
        return this.getBoolean(KEY_FFMPEG_MUX_TSMUXER_COMPATIBLE, false);
    }

    public void setFFmpegDeferToMEncoderForProblematicSubtitles(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_MENCODER_PROBLEMATIC_SUBTITLES, value);
    }

    public boolean isFFmpegDeferToMEncoderForProblematicSubtitles() {
        return this.getBoolean(KEY_FFMPEG_MENCODER_PROBLEMATIC_SUBTITLES, true);
    }

    public void setFFmpegFontConfig(boolean value) {
        this.configuration.setProperty(KEY_FFMPEG_FONTCONFIG, value);
    }

    public boolean isFFmpegFontConfig() {
        return this.getBoolean(KEY_FFMPEG_FONTCONFIG, false);
    }

    public void setMuxAllAudioTracks(boolean value) {
        this.configuration.setProperty(KEY_MUX_ALLAUDIOTRACKS, value);
    }

    public boolean isMuxAllAudioTracks() {
        return this.getBoolean(KEY_MUX_ALLAUDIOTRACKS, false);
    }

    public void setUseMplayerForVideoThumbs(boolean value) {
        this.configuration.setProperty(KEY_USE_MPLAYER_FOR_THUMBS, value);
    }

    public boolean isUseMplayerForVideoThumbs() {
        return this.getBoolean(KEY_USE_MPLAYER_FOR_THUMBS, false);
    }

    public boolean isNetworkDevicesBlockedByDefault() {
        return this.getBoolean(KEY_BLOCK_NETWORK_DEVICES_BY_DEFAULT, false);
    }

    public void setNetworkDevicesBlockedByDefault(boolean value) {
        this.configuration.setProperty(KEY_BLOCK_NETWORK_DEVICES_BY_DEFAULT, value);
    }

    public final String getNetworkDevicesFilter() {
        return this.getString(KEY_NETWORK_DEVICES_FILTER, "");
    }

    public void setNetworkDevicesFilter(String value) {
        this.configuration.setProperty(KEY_NETWORK_DEVICES_FILTER, value);
    }

    public boolean isRenderersBlockedByDefault() {
        return this.getBoolean(KEY_BLOCK_RENDERERS_BY_DEFAULT, false);
    }

    public void setRenderersBlockedByDefault(boolean value) {
        this.configuration.setProperty(KEY_BLOCK_RENDERERS_BY_DEFAULT, value);
    }

    public final String getRenderersFilter() {
        return this.getString(KEY_RENDERERS_FILTER, "");
    }

    public void setRenderersFilter(String value) {
        this.configuration.setProperty(KEY_RENDERERS_FILTER, value);
    }

    public final String getRenderersUser() {
        return this.getString(KEY_RENDERERS_USER, "{}");
    }

    public void setRenderersUser(String value) {
        this.configuration.setProperty(KEY_RENDERERS_USER, value);
    }

    public void setPreventSleep(PreventSleepMode value) {
        if (value == null) {
            throw new NullPointerException("value cannot be null");
        }
        this.configuration.setProperty(KEY_PREVENT_SLEEP, value.getValue());
        SleepManager sleepManager = Services.sleepManager();
        if (sleepManager != null) {
            sleepManager.setMode(value);
        }
    }

    public PreventSleepMode getPreventSleep() {
        return PreventSleepMode.typeOf(this.getString(KEY_PREVENT_SLEEP, PreventSleepMode.PLAYBACK.getValue()));
    }

    public boolean isHideAdvancedOptions() {
        return this.getBoolean(KEY_HIDE_ADVANCED_OPTIONS, true);
    }

    public void setHideAdvancedOptions(boolean value) {
        this.configuration.setProperty(KEY_HIDE_ADVANCED_OPTIONS, value);
    }

    public boolean isHideEmptyFolders() {
        return this.getBoolean(KEY_HIDE_EMPTY_FOLDERS, false);
    }

    public void setHideEmptyFolders(boolean value) {
        this.configuration.setProperty(KEY_HIDE_EMPTY_FOLDERS, value);
    }

    public boolean isUseSymlinksTargetFile() {
        return this.getBoolean(KEY_USE_SYMLINKS_TARGET_FILE, false);
    }

    public void setUseSymlinksTargetFile(boolean value) {
        this.configuration.setProperty(KEY_USE_SYMLINKS_TARGET_FILE, value);
    }

    public boolean isShowMediaLibraryFolder() {
        return this.getBoolean(KEY_SHOW_MEDIA_LIBRARY_FOLDER, true);
    }

    public void setShowMediaLibraryFolder(boolean value) {
        this.configuration.setProperty(KEY_SHOW_MEDIA_LIBRARY_FOLDER, value);
    }

    public boolean isShowTranscodeFolder() {
        return this.getBoolean(KEY_SHOW_TRANSCODE_FOLDER, true);
    }

    public void setShowTranscodeFolder(boolean value) {
        this.configuration.setProperty(KEY_SHOW_TRANSCODE_FOLDER, value);
    }

    public boolean isShowUserChoice() {
        return this.getBoolean(KEY_SHOW_USER_CHOICE, true);
    }

    public void setShowUserChoice(boolean value) {
        this.configuration.setProperty(KEY_SHOW_USER_CHOICE, value);
    }

    public boolean isDvdIsoThumbnails() {
        return this.getBoolean(KEY_DVDISO_THUMBNAILS, true);
    }

    public void setDvdIsoThumbnails(boolean value) {
        this.configuration.setProperty(KEY_DVDISO_THUMBNAILS, value);
    }

    public Object getCustomProperty(String property) {
        return this.configurationReader.getCustomProperty(property);
    }

    public void setCustomProperty(String property, Object value) {
        this.configuration.setProperty(property, value);
    }

    public boolean isChapterSupport() {
        return this.getBoolean(KEY_CHAPTER_SUPPORT, false);
    }

    public void setChapterSupport(boolean value) {
        this.configuration.setProperty(KEY_CHAPTER_SUPPORT, value);
    }

    public int getChapterInterval() {
        return this.getInt(KEY_CHAPTER_INTERVAL, 5);
    }

    public void setChapterInterval(int value) {
        this.configuration.setProperty(KEY_CHAPTER_INTERVAL, value);
    }

    public SubtitleColor getSubsColor() {
        String colorString = this.getString(KEY_SUBS_COLOR, null);
        if (StringUtils.isNotBlank(colorString)) {
            try {
                return new SubtitleColor(colorString);
            }
            catch (InvalidArgumentException e) {
                LOGGER.error("Using default subtitle color: {}", (Object)e.getMessage());
                LOGGER.trace("", e);
            }
        }
        return new SubtitleColor(255, 255, 255);
    }

    public void setSubsColor(SubtitleColor color) {
        if (color.getAlpha() != 255) {
            this.configuration.setProperty(KEY_SUBS_COLOR, color.get0xRRGGBBAA());
        } else {
            this.configuration.setProperty(KEY_SUBS_COLOR, color.get0xRRGGBB());
        }
    }

    public boolean isFix25FPSAvMismatch() {
        return this.getBoolean(KEY_FIX_25FPS_AV_MISMATCH, false);
    }

    public void setFix25FPSAvMismatch(boolean value) {
        this.configuration.setProperty(KEY_FIX_25FPS_AV_MISMATCH, value);
    }

    public int getVideoTranscodeStartDelay() {
        return this.getInt(KEY_VIDEOTRANSCODE_START_DELAY, 6);
    }

    public void setVideoTranscodeStartDelay(int value) {
        this.configuration.setProperty(KEY_VIDEOTRANSCODE_START_DELAY, value);
    }

    public boolean isAudioResample() {
        return this.getBoolean(KEY_AUDIO_RESAMPLE, true);
    }

    public void setAudioResample(boolean value) {
        this.configuration.setProperty(KEY_AUDIO_RESAMPLE, value);
    }

    public boolean isIgnoreTheWordAandThe() {
        return this.getBoolean(KEY_IGNORE_THE_WORD_A_AND_THE, true);
    }

    public void setIgnoreTheWordAandThe(boolean value) {
        this.configuration.setProperty(KEY_IGNORE_THE_WORD_A_AND_THE, value);
    }

    public boolean isPrettifyFilenames() {
        return this.getBoolean(KEY_PRETTIFY_FILENAMES, false);
    }

    public void setPrettifyFilenames(boolean value) {
        this.configuration.setProperty(KEY_PRETTIFY_FILENAMES, value);
    }

    public boolean isRunWizard() {
        return this.getBoolean(KEY_RUN_WIZARD, true);
    }

    public void setRunWizard(boolean value) {
        this.configuration.setProperty(KEY_RUN_WIZARD, value);
    }

    public boolean isScanSharedFoldersOnStartup() {
        return this.getBoolean(KEY_SCAN_SHARED_FOLDERS_ON_STARTUP, true);
    }

    public void setScanSharedFoldersOnStartup(boolean value) {
        this.configuration.setProperty(KEY_SCAN_SHARED_FOLDERS_ON_STARTUP, value);
    }

    public boolean isShowRecentlyPlayedFolder() {
        return this.getBoolean(KEY_SHOW_RECENTLY_PLAYED_FOLDER, true);
    }

    public void setShowRecentlyPlayedFolder(boolean value) {
        this.configuration.setProperty(KEY_SHOW_RECENTLY_PLAYED_FOLDER, value);
    }

    public String getRendererDefault() {
        return this.getString(KEY_RENDERER_DEFAULT, "");
    }

    public void setRendererDefault(String value) {
        this.configuration.setProperty(KEY_RENDERER_DEFAULT, value);
    }

    public boolean isRendererForceDefault() {
        return this.getBoolean(KEY_RENDERER_FORCE_DEFAULT, false);
    }

    public void setRendererForceDefault(boolean value) {
        this.configuration.setProperty(KEY_RENDERER_FORCE_DEFAULT, value);
    }

    public static String getProfilePath() {
        return PROFILE_PATH;
    }

    public static String getProfileDirectory() {
        return PROFILE_DIRECTORY;
    }

    public static String getProfileType() {
        return switch (PROFILE_TYPE) {
            case 1 -> "user";
            case 2 -> PORTABLE_PATH;
            case 3 -> "custom";
            default -> "system";
        };
    }

    public static boolean isSystemProfile() {
        return PROFILE_TYPE == 0;
    }

    public static boolean isUserProfile() {
        return PROFILE_TYPE == 1;
    }

    public static boolean isPortableProfile() {
        return PROFILE_TYPE == 2;
    }

    public static boolean isCustomProfile() {
        return PROFILE_TYPE == 3;
    }

    public String getSharedConfPath() {
        if (sharedConfPath == null) {
            sharedConfPath = FileUtil.getFileLocation(this.getString(KEY_SHARED_CONF_PATH, null), PROFILE_DIRECTORY, DEFAULT_SHARED_CONF_FILENAME).getFilePath();
        }
        return this.getString(KEY_SHARED_CONF_PATH, sharedConfPath);
    }

    public static String getHostName() {
        if (hostName == null) {
            try {
                hostName = InetAddress.getLocalHost().getHostName();
            }
            catch (UnknownHostException e) {
                LOGGER.info("Can't determine hostname");
                hostName = "unknown host";
            }
        }
        return hostName;
    }

    public String getProfileName() {
        return this.getString(KEY_PROFILE_NAME, UmsConfiguration.getHostName());
    }

    public boolean isAuthenticationEnabled() {
        return this.getBoolean(KEY_AUTHENTICATION_ENABLED, true);
    }

    public void setAuthenticationEnabled(boolean value) {
        this.configuration.setProperty(KEY_AUTHENTICATION_ENABLED, value);
    }

    public boolean isAuthenticateLocalhostAsAdmin() {
        return this.getBoolean(KEY_AUTHENTICATE_LOCALHOST_AS_ADMIN, false);
    }

    public void setAuthenticateLocalhostAsAdmin(boolean value) {
        this.configuration.setProperty(KEY_AUTHENTICATE_LOCALHOST_AS_ADMIN, value);
    }

    public boolean isAutoUpdate() {
        return Build.isUpdatable() && this.getBoolean(KEY_AUTO_UPDATE, true);
    }

    public void setAutoUpdate(boolean value) {
        this.configuration.setProperty(KEY_AUTO_UPDATE, value);
    }

    public int getUpnpPort() {
        return this.getInt(KEY_UPNP_PORT, 1900);
    }

    public String getUuid() {
        return this.getString(KEY_UUID, null);
    }

    public void setUuid(String value) {
        this.configuration.setProperty(KEY_UUID, value);
    }

    public void addConfigurationListener(ConfigurationListener l) {
        ((PropertiesConfiguration)this.configuration).addConfigurationListener(l);
    }

    public void removeConfigurationListener(ConfigurationListener l) {
        ((PropertiesConfiguration)this.configuration).removeConfigurationListener(l);
    }

    public boolean getFolderLimit() {
        return this.getBoolean(KEY_FOLDER_LIMIT, false);
    }

    public String getScriptDir() {
        return this.getString(KEY_SCRIPT_DIR, null);
    }

    public boolean getSearchFolder() {
        return this.getBoolean(KEY_SEARCH_FOLDER, false);
    }

    public boolean getSearchInFolder() {
        return this.getBoolean(KEY_SEARCH_IN_FOLDER, false) && this.getSearchFolder();
    }

    public int getSearchDepth() {
        int ret = this.getBoolean(KEY_SEARCH_RECURSE, true) ? 100 : 2;
        return this.getInt(KEY_SEARCH_RECURSE_DEPTH, ret);
    }

    public void reload() {
        try {
            ((PropertiesConfiguration)this.configuration).refresh();
        }
        catch (ConfigurationException e) {
            LOGGER.error(null, e);
        }
    }

    public String getTranscodeFolderName() {
        return this.getString(KEY_TRANSCODE_FOLDER_NAME, Messages.getConfigurationString("Transcode_FolderName"));
    }

    public void setTranscodeFolderName(String name) {
        this.configuration.setProperty(KEY_TRANSCODE_FOLDER_NAME, name);
    }

    public boolean isGPUAcceleration() {
        return this.getBoolean(KEY_GPU_ACCELERATION, false);
    }

    public void setGPUAcceleration(boolean value) {
        this.configuration.setProperty(KEY_GPU_ACCELERATION, value);
    }

    public boolean getGUILogSearchCaseSensitive() {
        return this.getBoolean(KEY_GUI_LOG_SEARCH_CASE_SENSITIVE, false);
    }

    public void setGUILogSearchCaseSensitive(boolean value) {
        this.configuration.setProperty(KEY_GUI_LOG_SEARCH_CASE_SENSITIVE, value);
    }

    public boolean getGUILogSearchMultiLine() {
        return this.getBoolean(KEY_GUI_LOG_SEARCH_MULTILINE, false);
    }

    public void setGUILogSearchMultiLine(boolean value) {
        this.configuration.setProperty(KEY_GUI_LOG_SEARCH_MULTILINE, value);
    }

    public boolean getGUILogSearchRegEx() {
        return this.getBoolean(KEY_GUI_LOG_SEARCH_USE_REGEX, false);
    }

    public void setGUILogSearchRegEx(boolean value) {
        this.configuration.setProperty(KEY_GUI_LOG_SEARCH_USE_REGEX, value);
    }

    public boolean getExternalNetwork() {
        return this.getBoolean(KEY_EXTERNAL_NETWORK, true);
    }

    public void setExternalNetwork(boolean b) {
        this.configuration.setProperty(KEY_EXTERNAL_NETWORK, b);
    }

    public boolean isUseInfoFromExternalAPI() {
        return this.isUseInfoFromUmsAPI() || this.isUseInfoFromTMDB();
    }

    public boolean isUseInfoFromUmsAPI() {
        return this.getBoolean(KEY_USE_API_INFO, true);
    }

    public void setUseInfoFromUmsAPI(boolean value) {
        this.configuration.setProperty(KEY_USE_API_INFO, value);
    }

    public boolean isUseInfoFromTMDB() {
        return this.getBoolean(KEY_USE_TMDB_INFO, true);
    }

    public void setUseInfoFromTMDB(boolean value) {
        this.configuration.setProperty(KEY_USE_TMDB_INFO, value);
    }

    public String getTmdbApiKey() {
        return this.configuration.getString(KEY_TMDB_API_KEY, "");
    }

    public void setTmdbApiKey(String value) {
        this.configuration.setProperty(KEY_TMDB_API_KEY, value);
    }

    public void initCred() {
        File credFile = this.getCredFile();
        if (!credFile.exists()) {
            try {
                try (BufferedWriter writer = new BufferedWriter(new OutputStreamWriter((OutputStream)new FileOutputStream(credFile), StandardCharsets.UTF_8));){
                    writer.write("# Add credentials to the file");
                    writer.newLine();
                    writer.write("# on the format tag=user,password");
                    writer.newLine();
                    writer.write("# For example:");
                    writer.newLine();
                    writer.write("# channels.xxx=name,secret");
                    writer.newLine();
                }
                this.configuration.setProperty(KEY_CRED_PATH, credFile.getAbsolutePath());
                ((PropertiesConfiguration)this.configuration).save();
            }
            catch (IOException e) {
                LOGGER.debug("Error initializing credentials file: {}", e);
            }
            catch (ConfigurationException e) {
                LOGGER.warn("An error occurred while saving configuration: {}", (Object)e.getMessage());
            }
        }
    }

    public File getCredFile() {
        String path = this.getString(KEY_CRED_PATH, "");
        if (path != null && !path.trim().isEmpty()) {
            return new File(path);
        }
        return new File(UmsConfiguration.getProfileDirectory(), DEFAULT_CREDENTIALS_FILENAME);
    }

    public int getATZLimit() {
        int tmp = this.getInt(KEY_ATZ_LIMIT, 10000);
        if (tmp <= 2) {
            tmp = 10000;
        }
        return tmp;
    }

    public void setATZLimit(int val) {
        if (val <= 2) {
            this.configuration.clearProperty(KEY_ATZ_LIMIT);
            return;
        }
        this.configuration.setProperty(KEY_ATZ_LIMIT, val);
    }

    public void setATZLimit(String str) {
        try {
            this.setATZLimit(Integer.parseInt(str));
        }
        catch (NumberFormatException e) {
            this.setATZLimit(0);
        }
    }

    public String getDataDir() {
        return UmsConfiguration.getProfileDirectory() + File.separator + "data";
    }

    public String getDataFile(String str) {
        return this.getDataDir() + File.separator + str;
    }

    public String[] getURLResolveOrder() {
        return this.getString(KEY_URL_RES_ORDER, "").split(",");
    }

    public boolean isShowLiveSubtitlesFolder() {
        return this.getBoolean(KEY_SHOW_LIVE_SUBTITLES_FOLDER, false);
    }

    public void setShowLiveSubtitlesFolder(boolean value) {
        this.configuration.setProperty(KEY_SHOW_LIVE_SUBTITLES_FOLDER, value);
    }

    public boolean displayAudioLikesInRootFolder() {
        return this.getBoolean(KEY_NEXTCP_AUDIO_LIKES_IN_ROOT_FOLDER, false);
    }

    public int getLiveSubtitlesLimit() {
        return this.getInt(KEY_LIVE_SUBTITLES_LIMIT, 20);
    }

    public void setLiveSubtitlesLimit(int value) {
        if (value > 0) {
            this.configuration.setProperty(KEY_LIVE_SUBTITLES_LIMIT, value);
        }
    }

    public boolean isLiveSubtitlesKeep() {
        return this.getBoolean(KEY_LIVE_SUBTITLES_KEEP, true);
    }

    public void setLiveSubtitlesKeep(boolean value) {
        this.configuration.setProperty(KEY_LIVE_SUBTITLES_KEEP, value);
    }

    public boolean getLoggingBuffered() {
        return this.getBoolean(KEY_LOGGING_BUFFERED, false);
    }

    public void setLoggingBuffered(boolean value) {
        this.configuration.setProperty(KEY_LOGGING_BUFFERED, value);
    }

    public Level getLoggingFilterConsole() {
        return Level.toLevel(this.getString(KEY_LOGGING_FILTER_CONSOLE, "INFO"), Level.INFO);
    }

    public void setLoggingFilterConsole(Level value) {
        this.configuration.setProperty(KEY_LOGGING_FILTER_CONSOLE, value.levelStr);
    }

    public Level getLoggingFilterLogsTab() {
        return Level.toLevel(this.getString(KEY_LOGGING_FILTER_LOGS_TAB, "INFO"), Level.INFO);
    }

    public void setLoggingFilterLogsTab(Level value) {
        this.configuration.setProperty(KEY_LOGGING_FILTER_LOGS_TAB, value.levelStr);
    }

    public static int getLoggingLogsTabLinebufferMin() {
        return 100;
    }

    public static int getLoggingLogsTabLinebufferMax() {
        return 90000;
    }

    public static int getLoggingLogsTabLinebufferStep() {
        return 500;
    }

    public int getLoggingLogsTabLinebuffer() {
        return Math.min(Math.max(this.getInt(KEY_LOGGING_LOGS_TAB_LINEBUFFER, 1000), 100), 90000);
    }

    public void setLoggingLogsTabLinebuffer(int value) {
        value = Math.min(Math.max(value, 100), 90000);
        this.configuration.setProperty(KEY_LOGGING_LOGS_TAB_LINEBUFFER, value);
    }

    public String getLoggingSyslogFacility() {
        return this.getString(KEY_LOGGING_SYSLOG_FACILITY, "USER");
    }

    public void setLoggingSyslogFacility(String value) {
        this.configuration.setProperty(KEY_LOGGING_SYSLOG_FACILITY, value);
    }

    public void setLoggingSyslogFacilityDefault() {
        this.setLoggingSyslogFacility("USER");
    }

    public String getLoggingSyslogHost() {
        return this.getString(KEY_LOGGING_SYSLOG_HOST, "");
    }

    public void setLoggingSyslogHost(String value) {
        this.configuration.setProperty(KEY_LOGGING_SYSLOG_HOST, value);
    }

    public int getLoggingSyslogPort() {
        int i = this.getInt(KEY_LOGGING_SYSLOG_PORT, 514);
        if (i < 1 || i > 65535) {
            return 514;
        }
        return i;
    }

    public void setLoggingSyslogPort(int value) {
        if (value < 1 || value > 65535) {
            this.setLoggingSyslogPortDefault();
        } else {
            this.configuration.setProperty(KEY_LOGGING_SYSLOG_PORT, value);
        }
    }

    public void setLoggingSyslogPortDefault() {
        this.setLoggingSyslogPort(514);
    }

    public boolean getLoggingUseSyslog() {
        return this.getBoolean(KEY_LOGGING_USE_SYSLOG, false);
    }

    public void setLoggingUseSyslog(boolean value) {
        this.configuration.setProperty(KEY_LOGGING_USE_SYSLOG, value);
    }

    public boolean getDatabaseLogging() {
        boolean dbLog = this.getBoolean(KEY_LOG_DATABASE, false);
        return dbLog || PMS.getLogDB();
    }

    public int getDatabaseMediaCacheSize() {
        return this.getInt(KEY_DATABASE_MEDIA_CACHE_SIZE_KB, -1);
    }

    public void setDatabaseMediaCacheSize(int value) {
        this.configuration.setProperty(KEY_DATABASE_MEDIA_CACHE_SIZE_KB, value);
    }

    public boolean isDatabaseMediaUseMemoryIndexes() {
        return this.getBoolean(KEY_DATABASE_MEDIA_USE_MEMORY_INDEXES, false);
    }

    public boolean isDatabaseMediaUseCacheSoft() {
        return this.getBoolean(KEY_DATABASE_MEDIA_USE_CACHE_SOFT, false);
    }

    public boolean isVlcUseHardwareAccel() {
        return this.getBoolean(KEY_VLC_USE_HW_ACCELERATION, false);
    }

    public void setVlcUseHardwareAccel(boolean value) {
        this.configuration.setProperty(KEY_VLC_USE_HW_ACCELERATION, value);
    }

    public boolean isVlcExperimentalCodecs() {
        return this.getBoolean(KEY_VLC_USE_EXPERIMENTAL_CODECS, false);
    }

    public void setVlcExperimentalCodecs(boolean value) {
        this.configuration.setProperty(KEY_VLC_USE_EXPERIMENTAL_CODECS, value);
    }

    public boolean isVlcAudioSyncEnabled() {
        return this.getBoolean(KEY_VLC_AUDIO_SYNC_ENABLED, false);
    }

    public void setVlcAudioSyncEnabled(boolean value) {
        this.configuration.setProperty(KEY_VLC_AUDIO_SYNC_ENABLED, value);
    }

    public boolean isVlcSubtitleEnabled() {
        return this.getBoolean(KEY_VLC_SUBTITLE_ENABLED, true);
    }

    public void setVlcSubtitleEnabled(boolean value) {
        this.configuration.setProperty(KEY_VLC_SUBTITLE_ENABLED, value);
    }

    public String getVlcScale() {
        return this.getString(KEY_VLC_SCALE, "1.0");
    }

    public void setVlcScale(String value) {
        this.configuration.setProperty(KEY_VLC_SCALE, value);
    }

    public boolean getVlcSampleRateOverride() {
        return this.getBoolean(KEY_VLC_SAMPLE_RATE_OVERRIDE, false);
    }

    public void setVlcSampleRateOverride(boolean value) {
        this.configuration.setProperty(KEY_VLC_SAMPLE_RATE_OVERRIDE, value);
    }

    public String getVlcSampleRate() {
        return this.getString(KEY_VLC_SAMPLE_RATE, "48000");
    }

    public void setVlcSampleRate(String value) {
        this.configuration.setProperty(KEY_VLC_SAMPLE_RATE, value);
    }

    public boolean isResumeEnabled() {
        return this.getBoolean(KEY_RESUME, true);
    }

    public void setResume(boolean value) {
        this.configuration.setProperty(KEY_RESUME, value);
    }

    public int getMinimumWatchedPlayTime() {
        return this.getInt(KEY_MIN_PLAY_TIME, 30000);
    }

    public int getMinimumWatchedPlayTimeSeconds() {
        return this.getMinimumWatchedPlayTime() / 1000;
    }

    public int getMinPlayTimeFile() {
        return this.getInt(KEY_MIN_PLAY_TIME_FILE, this.getMinimumWatchedPlayTime());
    }

    public int getResumeRewind() {
        return this.getInt(KEY_RESUME_REWIND, 17000);
    }

    public double getResumeBackFactor() {
        int percent = this.getInt(KEY_RESUME_BACK, 92);
        if (percent > 97) {
            percent = 97;
        }
        if (percent < 10) {
            percent = 10;
        }
        return (double)percent / 100.0;
    }

    public int getResumeKeepTime() {
        return this.getInt(KEY_RESUME_KEEP_TIME, 0);
    }

    public boolean isAppendProfileName() {
        return this.getBoolean(KEY_APPEND_PROFILE_NAME, false);
    }

    public void setAppendProfileName(boolean value) {
        this.configuration.setProperty(KEY_APPEND_PROFILE_NAME, value);
    }

    public int getDepth3D() {
        return this.getInt(KEY_3D_SUBTITLES_DEPTH, 0);
    }

    public void setDepth3D(int value) {
        this.configuration.setProperty(KEY_3D_SUBTITLES_DEPTH, value);
    }

    public void setRunSingleInstance(boolean value) {
        this.configuration.setProperty(KEY_SINGLE, value);
    }

    public boolean isRunSingleInstance() {
        return this.getBoolean(KEY_SINGLE, true);
    }

    public File getWebPath() {
        File path = new File(this.getString(KEY_WEB_PATH, "web"));
        if (!path.exists()) {
            File srcPath = new File("src/main/external-resources/web");
            if (!srcPath.exists()) {
                path.mkdirs();
            } else {
                path = srcPath;
            }
        }
        return path;
    }

    public File getWebFile(String file) {
        return new File(this.getWebPath().getAbsolutePath() + File.separator + file);
    }

    public int getWebGuiServerPort() {
        return this.getInt(KEY_WEB_GUI_PORT, 9001);
    }

    public int getWebThreads() {
        int x = this.getInt(KEY_WEB_THREADS, 30);
        return x > 100 ? 100 : x;
    }

    public boolean useWebPlayerServer() {
        return this.getBoolean(KEY_WEB_PLAYER_ENABLE, true);
    }

    public int getWebPlayerServerPort() {
        return this.getInt(KEY_WEB_PLAYER_PORT, 9002);
    }

    public boolean getWebPlayerHttps() {
        return this.getBoolean(KEY_WEB_PLAYER_HTTPS, false);
    }

    public boolean isWebPlayerControllable() {
        return this.getBoolean(KEY_WEB_PLAYER_CONTROLLABLE, true);
    }

    public boolean isWebPlayerAuthenticationEnabled() {
        return this.getBoolean(KEY_WEB_PLAYER_AUTH, false);
    }

    public boolean useWebPlayerControls() {
        return this.getBoolean(KEY_WEB_PLAYER_CONTROLS, true);
    }

    public boolean useWebPlayerDownload() {
        return this.getBoolean(KEY_WEB_PLAYER_DOWNLOAD, true);
    }

    public boolean isWebPlayerMp4Trans() {
        return this.getBoolean(KEY_WEB_PLAYER_MP4_TRANS, false);
    }

    public boolean getWebPlayerAutoCont(Format f) {
        String key = KEY_WEB_PLAYER_CONT_VIDEO;
        boolean def = false;
        if (f.isAudio()) {
            key = KEY_WEB_PLAYER_CONT_AUDIO;
            def = true;
        }
        if (f.isImage()) {
            key = KEY_WEB_PLAYER_CONT_IMAGE;
            def = false;
        }
        return this.getBoolean(key, def);
    }

    public boolean getWebPlayerAutoLoop(Format f) {
        String key = KEY_WEB_PLAYER_LOOP_VIDEO;
        if (f.isAudio()) {
            key = KEY_WEB_PLAYER_LOOP_AUDIO;
        }
        if (f.isImage()) {
            key = KEY_WEB_PLAYER_LOOP_IMAGE;
        }
        return this.getBoolean(key, false);
    }

    public int getWebPlayerImgSlideDelay() {
        return this.getInt(KEY_WEB_PLAYER_IMAGE_SLIDE, 0);
    }

    public boolean getWebPlayerSubs() {
        return this.getBoolean(KEY_WEB_PLAYER_SUBS_TRANS, false);
    }

    public boolean useWebPlayerSubLang() {
        return this.getBoolean(KEY_WEB_PLAYER_SUB_LANG, false);
    }

    public boolean isAutomaticMaximumBitrate() {
        return this.getBoolean(KEY_AUTOMATIC_MAXIMUM_BITRATE, true);
    }

    public void setAutomaticMaximumBitrate(boolean b) {
        if (!this.isAutomaticMaximumBitrate() && b) {
            ConnectedRenderers.calculateAllSpeeds();
        }
        this.configuration.setProperty(KEY_AUTOMATIC_MAXIMUM_BITRATE, b);
    }

    public boolean isSpeedDbg() {
        return this.getBoolean(KEY_SPEED_DBG, false);
    }

    public boolean getAutoDiscover() {
        return this.getBoolean(KEY_AUTOMATIC_DISCOVER, false);
    }

    public boolean useCode() {
        return this.getBoolean(KEY_CODE_USE, true);
    }

    public int getCodeValidTmo() {
        return this.getInt(KEY_CODE_TMO, 240) * 60 * 1000;
    }

    public boolean isShowCodeThumbs() {
        return this.getBoolean(KEY_CODE_THUMBS, true);
    }

    public int getCodeCharSet() {
        int cs = this.getInt(KEY_CODE_CHARS, 0);
        if (cs < 0 || cs > 2) {
            cs = 0;
        }
        return cs;
    }

    public boolean isSortAudioTracksByAlbumPosition() {
        return this.getBoolean(KEY_SORT_AUDIO_TRACKS_BY_ALBUM_POSITION, true);
    }

    public boolean isDynamicPls() {
        return this.getBoolean(KEY_DYNAMIC_PLS, false);
    }

    public boolean isDynamicPlsAutoSave() {
        return this.getBoolean(KEY_DYNAMIC_PLS_AUTO_SAVE, false);
    }

    public String getDynamicPlsSavePath() {
        String path = this.getString(KEY_DYNAMIC_PLS_SAVE_PATH, "");
        if (StringUtils.isEmpty(path)) {
            path = this.getDataFile("dynpls");
            new File(path).mkdirs();
        }
        return path;
    }

    public String getDynamicPlsSaveFile(String str) {
        return this.getDynamicPlsSavePath() + File.separator + str;
    }

    public boolean isHideSavedPlaylistFolder() {
        return this.getBoolean(KEY_DYNAMIC_PLS_HIDE, false);
    }

    public boolean isAutoContinue() {
        return this.getBoolean(KEY_PLAYLIST_AUTO_CONT, false);
    }

    public boolean isAutoAddAll() {
        return this.getBoolean(KEY_PLAYLIST_AUTO_ADD_ALL, false);
    }

    public String getAutoPlay() {
        return this.getString(KEY_PLAYLIST_AUTO_PLAY, null);
    }

    public boolean useChromecastExt() {
        return this.getBoolean(KEY_CHROMECAST_EXT, false);
    }

    public boolean isChromecastDbg() {
        return this.getBoolean(KEY_CHROMECAST_DBG, false);
    }

    public void setAutoSave() {
        ((PropertiesConfiguration)this.configuration).setAutoSave(true);
    }

    public boolean isUpnpEnabled() {
        return this.getBoolean(KEY_UPNP_ENABLED, true);
    }

    private int getUpnpDebugLevel() {
        return this.getInt(KEY_UPNP_LOG_LEVEL, 1);
    }

    public boolean isUpnpDebugOff() {
        return this.getUpnpDebugLevel() < 1;
    }

    public boolean isUpnpDebugMediaServer() {
        return this.getUpnpDebugLevel() > 0;
    }

    public boolean isUpnpDebugBasic() {
        return this.getUpnpDebugLevel() > 1;
    }

    public boolean isUpnpDebugFull() {
        return this.getUpnpDebugLevel() > 2;
    }

    public boolean isUpnpJupnpDidl() {
        return this.getBoolean(KEY_UPNP_JUPNP_DIDL, false);
    }

    public boolean isUpnpCdsWrite() {
        return this.getBoolean(KEY_UPNP_CDS_WRITE, false);
    }

    public boolean isAnonymousDevicesWrite() {
        return this.getBoolean(KEY_ANONYMOUS_DEVICES_WRITE, false);
    }

    public String getRootLogLevel() {
        String level = this.getString(KEY_ROOT_LOG_LEVEL, "DEBUG").toUpperCase();
        return "ALL TRACE DEBUG INFO WARN ERROR OFF".contains(level) ? level : "DEBUG";
    }

    public void setRootLogLevel(Level level) {
        this.configuration.setProperty(KEY_ROOT_LOG_LEVEL, level.toString());
    }

    public boolean isShowSplashScreen() {
        return this.getBoolean(KEY_SHOW_SPLASH_SCREEN, true);
    }

    public void setShowSplashScreen(boolean value) {
        this.configuration.setProperty(KEY_SHOW_SPLASH_SCREEN, value);
    }

    public boolean isInfoDbRetry() {
        return this.getBoolean(KEY_INFO_DB_RETRY, false);
    }

    public int getUpnpSendAliveDelay() {
        return this.getInt(KEY_UPNP_ALIVE_DELAY, 0);
    }

    public boolean showInfoAboutVideoAutomaticSetting() {
        return this.getBoolean(KEY_SHOW_INFO_ABOUT_AUTOMATIC_VIDEO_SETTING, true);
    }

    public void setShowInfoAboutVideoAutomaticSetting(boolean value) {
        this.configuration.setProperty(KEY_SHOW_INFO_ABOUT_AUTOMATIC_VIDEO_SETTING, value);
    }

    public boolean hasRunOnce() {
        return this.getBoolean(KEY_WAS_YOUTUBE_DL_ENABLED_ONCE, false);
    }

    public void setHasRunOnce() {
        this.configuration.setProperty(KEY_WAS_YOUTUBE_DL_ENABLED_ONCE, true);
    }

    public boolean disableExternalEntities() {
        return this.getBoolean(KEY_DISABLE_EXTERNAL_ENTITIES, true);
    }

    public static synchronized JsonArray getAudioCoverSuppliersAsJsonArray() {
        JsonArray jsonArray = new JsonArray();
        JsonObject noneObject = new JsonObject();
        noneObject.addProperty("value", CoverSupplier.NONE_INTEGER.toString());
        noneObject.addProperty("label", "i18n@None");
        jsonArray.add(noneObject);
        JsonObject coverArtArchiveObject = new JsonObject();
        coverArtArchiveObject.addProperty("value", CoverSupplier.COVER_ART_ARCHIVE_INTEGER.toString());
        coverArtArchiveObject.addProperty("label", "i18n@DownloadFromCoverArtArchive");
        jsonArray.add(coverArtArchiveObject);
        return jsonArray;
    }

    public static synchronized JsonArray getSortMethodsAsJsonArray() {
        String[] values = new String[]{"0", "1", "2", "5", "6"};
        String[] labels = new String[]{"i18n@ByDisplayName", "i18n@ByDateNewestFirst", "i18n@ByDateOldestFirst", "i18n@Random", "i18n@NoSorting"};
        return UMSUtils.getArraysAsJsonArrayOfObjects(values, labels, null);
    }

    public static synchronized JsonArray getFfmpegLoglevels() {
        String[] values = FFmpegLogLevels.getLabels();
        String[] labels = FFmpegLogLevels.getLabels();
        return UMSUtils.getArraysAsJsonArrayOfObjects(values, labels, null);
    }

    public static synchronized JsonArray getSubtitlesInfoLevelsAsJsonArray() {
        String[] values = new String[]{SubtitlesInfoLevel.NONE.toString(), SubtitlesInfoLevel.BASIC.toString(), SubtitlesInfoLevel.FULL.toString()};
        String[] labels = new String[]{"i18n@None", "i18n@Basic", "i18n@Full"};
        return UMSUtils.getArraysAsJsonArrayOfObjects(values, labels, null);
    }

    public static synchronized JsonArray getUpnpLoglevels() {
        String[] values = new String[]{"0", "1", "2", "3"};
        String[] labels = new String[]{"i18n@None", "i18n@MediaServerOnly", "i18n@Basic", "i18n@Full"};
        return UMSUtils.getArraysAsJsonArrayOfObjects(values, labels, null);
    }

    public static synchronized JsonArray getFullyPlayedActionsAsJsonArray() {
        String[] values = new String[]{String.valueOf(FullyPlayedAction.NO_ACTION.getValue()), String.valueOf(FullyPlayedAction.MARK.getValue()), String.valueOf(FullyPlayedAction.HIDE_MEDIA.getValue()), String.valueOf(FullyPlayedAction.MOVE_FOLDER.getValue()), String.valueOf(FullyPlayedAction.MOVE_FOLDER_AND_MARK.getValue()), String.valueOf(FullyPlayedAction.MOVE_TRASH.getValue())};
        String[] labels = new String[]{"i18n@DoNothing", "i18n@MarkMedia", "i18n@HideMedia", "i18n@MoveFileToDifferentFolder", "i18n@MoveFileDifferentFolderMark", "i18n@MoveFileRecycleTrashBin"};
        return UMSUtils.getArraysAsJsonArrayOfObjects(values, labels, null);
    }

    public static synchronized JsonArray getSubtitlesCodepageArray() {
        String[] values = new String[]{"", "cp874", "cp932", "cp936", "cp949", "cp950", "cp1250", "cp1251", "cp1252", "cp1253", "cp1254", "cp1255", "cp1256", "cp1257", "cp1258", "ISO-2022-CN", "ISO-2022-JP", "ISO-2022-KR", "ISO-8859-1", "ISO-8859-2", "ISO-8859-3", "ISO-8859-4", "ISO-8859-5", "ISO-8859-6", "ISO-8859-7", "ISO-8859-8", "ISO-8859-9", "ISO-8859-10", "ISO-8859-11", "ISO-8859-13", "ISO-8859-14", "ISO-8859-15", "ISO-8859-16", "Big5", "EUC-JP", "EUC-KR", "GB18030", "IBM420", "IBM424", "KOI8-R", "Shift_JIS", "TIS-620"};
        String[] labels = new String[]{"i18n@AutoDetect", "i18n@CharacterSet.874", "i18n@CharacterSet.932", "i18n@CharacterSet.936", "i18n@CharacterSet.949", "i18n@CharacterSet.950", "i18n@CharacterSet.1250", "i18n@CharacterSet.1251", "i18n@CharacterSet.1252", "i18n@CharacterSet.1253", "i18n@CharacterSet.1254", "i18n@CharacterSet.1255", "i18n@CharacterSet.1256", "i18n@CharacterSet.1257", "i18n@CharacterSet.1258", "i18n@CharacterSet.2022-CN", "i18n@CharacterSet.2022-JP", "i18n@CharacterSet.2022-KR", "i18n@CharacterSet.8859-1", "i18n@CharacterSet.8859-2", "i18n@CharacterSet.8859-3", "i18n@CharacterSet.8859-4", "i18n@CharacterSet.8859-5", "i18n@CharacterSet.8859-6", "i18n@CharacterSet.8859-7", "i18n@CharacterSet.8859-8", "i18n@CharacterSet.8859-9", "i18n@CharacterSet.8859-10", "i18n@CharacterSet.8859-11", "i18n@CharacterSet.8859-13", "i18n@CharacterSet.8859-14", "i18n@CharacterSet.8859-15", "i18n@CharacterSet.8859-16", "i18n@CharacterSet.Big5", "i18n@CharacterSet.EUC-JP", "i18n@CharacterSet.EUC-KR", "i18n@CharacterSet.GB18030", "i18n@CharacterSet.IBM420", "i18n@CharacterSet.IBM424", "i18n@CharacterSet.KOI8-R", "i18n@CharacterSet.ShiftJIS", "i18n@CharacterSet.TIS-620"};
        return UMSUtils.getArraysAsJsonArrayOfObjects(values, labels, null);
    }

    public static synchronized JsonObject getAllEnginesAsJsonObject() {
        JsonObject result = new JsonObject();
        for (EngineId engineId : StandardEngineId.ALL) {
            Engine engine = EngineFactory.getEngine(engineId, false, false);
            if (engine == null) continue;
            JsonObject jsonPlayer = new JsonObject();
            jsonPlayer.add("id", new JsonPrimitive(engineId.getName()));
            jsonPlayer.add(KEY_PROFILE_NAME, new JsonPrimitive(engine.getName()));
            jsonPlayer.add("isAvailable", new JsonPrimitive(engine.isAvailable()));
            jsonPlayer.add("purpose", new JsonPrimitive(engine.purpose()));
            jsonPlayer.add("statusText", engine.getStatusTextFullAsJsonArray());
            result.add(engineId.getName(), jsonPlayer);
        }
        return result;
    }

    public static synchronized JsonArray getAllEnginesAsJsonArray() {
        JsonArray result = new JsonArray();
        for (EngineId engineId : StandardEngineId.ALL) {
            result.add(engineId.getName());
        }
        return result;
    }

    public static synchronized JsonArray getEnginesPurposesAsJsonArray() {
        JsonArray result = new JsonArray();
        result.add("i18n@VideoFilesEngines");
        result.add("i18n@AudioFilesEngines");
        result.add("i18n@WebVideoStreamingEngines");
        result.add("i18n@WebAudioStreamingEngines");
        result.add("i18n@MiscEngines");
        return result;
    }

    public static synchronized JsonArray getSubtitlesDepthArray() {
        String[] values = new String[]{"-5", "-4", "-3", "-2", "-1", "0", "1", "2", "3", "4", "5"};
        String[] labels = new String[]{"-5", "-4", "-3", "-2", "-1", "0", "1", "2", "3", "4", "5"};
        return UMSUtils.getArraysAsJsonArrayOfObjects(values, labels, null);
    }

    public static synchronized JsonArray getFFmpegAvailableGPUH264EncodingAccelerationMethodsArray() {
        String[] values = UmsConfiguration.getFFmpegAvailableGPUH264EncodingAccelerationMethods();
        String[] labels = UmsConfiguration.getFFmpegAvailableGPUH264EncodingAccelerationMethods();
        return UMSUtils.getArraysAsJsonArrayOfObjects(values, labels, null);
    }

    public static synchronized JsonArray getFFmpegAvailableGPUH265EncodingAccelerationMethodsArray() {
        String[] values = UmsConfiguration.getFFmpegAvailableGPUH265EncodingAccelerationMethods();
        String[] labels = UmsConfiguration.getFFmpegAvailableGPUH265EncodingAccelerationMethods();
        return UMSUtils.getArraysAsJsonArrayOfObjects(values, labels, null);
    }

    public static JsonObject getWebSettingsWithDefaults() {
        JsonObject jObj = new JsonObject();
        jObj.addProperty(KEY_ALTERNATE_SUBTITLES_FOLDER, "");
        jObj.addProperty(KEY_ALTERNATE_THUMB_FOLDER, "");
        jObj.addProperty(KEY_APPEND_PROFILE_NAME, false);
        jObj.addProperty(KEY_ATZ_LIMIT, 10000);
        jObj.addProperty(KEY_AUDIO_CHANNEL_COUNT, "6");
        jObj.addProperty(KEY_AUDIO_EMBED_DTS_IN_PCM, false);
        jObj.addProperty(KEY_AUDIO_BITRATE, "448");
        jObj.addProperty(KEY_AUDIO_LANGUAGES, Messages.getConfigurationString("AudioLanguages"));
        jObj.addProperty(KEY_AUDIO_REMUX_AC3, true);
        jObj.addProperty(KEY_AUDIO_RESAMPLE, true);
        jObj.addProperty(KEY_AUDIO_SUB_LANGS, "");
        jObj.addProperty(KEY_AUDIO_THUMBNAILS_METHOD, "1");
        jObj.addProperty(KEY_AUDIO_USE_PCM, false);
        jObj.addProperty(KEY_AUTO_UPDATE, true);
        jObj.addProperty(KEY_AUTOLOAD_SUBTITLES, true);
        jObj.addProperty(KEY_AUTOMATIC_MAXIMUM_BITRATE, true);
        jObj.addProperty(KEY_CHAPTER_INTERVAL, 5);
        jObj.addProperty(KEY_CHAPTER_SUPPORT, false);
        jObj.addProperty(KEY_CHROMECAST_EXT, false);
        jObj.addProperty(KEY_DISABLE_SUBTITLES, false);
        jObj.addProperty(KEY_DISABLE_TRANSCODE_FOR_EXTENSIONS, "");
        jObj.addProperty(KEY_DISABLE_TRANSCODING, false);
        jObj.addProperty(KEY_OPEN_ARCHIVES, false);
        jObj.addProperty(KEY_ENCODED_AUDIO_PASSTHROUGH, false);
        JsonArray transcodingEngines = UmsConfiguration.getAllEnginesAsJsonArray();
        jObj.add(KEY_ENGINES, transcodingEngines);
        jObj.add(KEY_ENGINES_PRIORITY, transcodingEngines);
        jObj.addProperty(KEY_FORCE_TRANSCODE_FOR_EXTENSIONS, "");
        jObj.addProperty(KEY_FULLY_PLAYED_ACTION, String.valueOf(FullyPlayedAction.MARK.getValue()));
        jObj.addProperty(KEY_FULLY_PLAYED_OUTPUT_DIRECTORY, "");
        jObj.addProperty(KEY_GPU_ACCELERATION, false);
        jObj.addProperty(KEY_EXTERNAL_NETWORK, true);
        jObj.addProperty(KEY_FFMPEG_FONTCONFIG, false);
        jObj.addProperty(KEY_FFMPEG_GPU_DECODING_ACCELERATION_METHOD, "none");
        jObj.addProperty(KEY_FFMPEG_GPU_DECODING_ACCELERATION_THREAD_NUMBER, 1);
        jObj.addProperty(KEY_FFMPEG_GPU_ENCODING_H264_ACCELERATION_METHOD, "libx264");
        jObj.addProperty(KEY_FFMPEG_GPU_ENCODING_H265_ACCELERATION_METHOD, "libx265");
        jObj.addProperty(KEY_FFMPEG_LOGGING_LEVEL, "fatal");
        jObj.addProperty(KEY_FFMPEG_MENCODER_PROBLEMATIC_SUBTITLES, true);
        jObj.addProperty(KEY_FFMPEG_MULTITHREADING, UmsConfiguration.getNumberOfSystemCpuCores() > 1);
        jObj.addProperty(KEY_FFMPEG_MUX_TSMUXER_COMPATIBLE, false);
        jObj.addProperty(KEY_FFMPEG_SOX, true);
        jObj.addProperty(KEY_FFMPEG_AVISYNTH_CONVERT_FPS, true);
        jObj.addProperty(KEY_FFMPEG_AVISYNTH_INTERFRAME, false);
        jObj.addProperty(KEY_FFMPEG_AVISYNTH_INTERFRAME_GPU, false);
        jObj.addProperty(KEY_FFMPEG_AVISYNTH_MULTITHREADING, UmsConfiguration.getNumberOfSystemCpuCores() > 1);
        jObj.addProperty(KEY_FFMPEG_AVISYNTH_2D_TO_3D, false);
        jObj.addProperty(KEY_FFMPEG_AVISYNTH_CONVERSION_ALGORITHM_2D_TO_3D, "1");
        jObj.addProperty(KEY_FFMPEG_AVISYNTH_FRAME_STRETCH_FACTOR_2D_TO_3D, 8);
        jObj.addProperty(KEY_FFMPEG_AVISYNTH_LIGHT_OFFSET_FACTOR_2D_TO_3D, 3);
        jObj.addProperty(KEY_FFMPEG_AVISYNTH_OUTPUT_FORMAT_3D, "4");
        jObj.addProperty(KEY_FFMPEG_AVISYNTH_HORIZONTAL_RESIZE, true);
        jObj.addProperty(KEY_FFMPEG_AVISYNTH_HORIZONTAL_RESIZE_RESOLUTION, "1920");
        jObj.addProperty(KEY_FFMPEG_AVISYNTH_USE_FFMS2, false);
        jObj.addProperty(KEY_FORCE_EXTERNAL_SUBTITLES, true);
        jObj.addProperty(KEY_FORCED_SUBTITLE_LANGUAGE, "");
        jObj.addProperty(KEY_FORCED_SUBTITLE_TAGS, "forced");
        jObj.addProperty(KEY_THUMBNAIL_GENERATION_ENABLED, true);
        jObj.addProperty(KEY_HIDE_EMPTY_FOLDERS, false);
        jObj.addProperty(KEY_HIDE_ENGINENAMES, true);
        jObj.addProperty(KEY_HIDE_EXTENSIONS, true);
        jObj.addProperty(KEY_SERVER_HOSTNAME, "");
        jObj.addProperty(KEY_IGNORE_THE_WORD_A_AND_THE, true);
        jObj.addProperty(KEY_LANGUAGE, "en-US");
        jObj.addProperty(KEY_LIVE_SUBTITLES_KEEP, false);
        jObj.addProperty(KEY_LIVE_SUBTITLES_LIMIT, 20);
        jObj.addProperty(KEY_MENCODER_ASS, true);
        jObj.addProperty(KEY_MENCODER_CODEC_SPECIFIC_SCRIPT, "");
        jObj.addProperty(KEY_MENCODER_CUSTOM_OPTIONS, "");
        jObj.addProperty(KEY_MENCODER_FONT_CONFIG, true);
        jObj.addProperty(KEY_MENCODER_FORCE_FPS, false);
        jObj.addProperty(KEY_MENCODER_INTELLIGENT_SYNC, true);
        jObj.addProperty(KEY_MENCODER_MT, UmsConfiguration.getNumberOfSystemCpuCores() > 1);
        jObj.addProperty(KEY_MENCODER_MUX_COMPATIBLE, false);
        jObj.addProperty(KEY_MENCODER_NOASS_OUTLINE, 1);
        jObj.addProperty(KEY_MENCODER_NO_OUT_OF_SYNC, false);
        jObj.addProperty(KEY_MENCODER_OVERSCAN_COMPENSATION_HEIGHT, "0");
        jObj.addProperty(KEY_MENCODER_OVERSCAN_COMPENSATION_WIDTH, "0");
        jObj.addProperty(KEY_MENCODER_REMUX_MPEG2, true);
        jObj.addProperty(KEY_MENCODER_SCALER, false);
        jObj.addProperty(KEY_MENCODER_SCALEX, "0");
        jObj.addProperty(KEY_MENCODER_SCALEY, "0");
        jObj.addProperty(KEY_SKIP_LOOP_FILTER_ENABLED, false);
        jObj.addProperty(KEY_MENCODER_SUB_FRIBIDI, false);
        jObj.addProperty(KEY_MENCODER_YADIF, false);
        jObj.addProperty(KEY_MAX_MEMORY_BUFFER_SIZE, 200);
        jObj.addProperty(KEY_MAX_BITRATE, 90);
        jObj.addProperty(KEY_MINIMIZED, false);
        jObj.addProperty(KEY_TSMUXER_FORCEFPS, true);
        jObj.addProperty(KEY_MUX_ALLAUDIOTRACKS, false);
        jObj.addProperty(KEY_MPEG2_MAIN_SETTINGS, "Automatic (Wired)");
        jObj.addProperty(KEY_NETWORK_INTERFACE, "");
        int numberOfCpuCores = Runtime.getRuntime().availableProcessors();
        if (numberOfCpuCores < 1) {
            numberOfCpuCores = 1;
        }
        jObj.addProperty(KEY_NUMBER_OF_CPU_CORES, numberOfCpuCores);
        jObj.addProperty(KEY_SERVER_PORT, 5001);
        jObj.addProperty(KEY_PRETTIFY_FILENAMES, false);
        jObj.addProperty(KEY_RENDERER_DEFAULT, "");
        jObj.addProperty(KEY_RENDERER_FORCE_DEFAULT, false);
        jObj.addProperty(KEY_RESUME, true);
        JsonArray allRenderers = new JsonArray();
        allRenderers.add("All renderers");
        jObj.add(KEY_SELECTED_RENDERERS, allRenderers);
        jObj.addProperty(KEY_SERVER_NAME, PMS.NAME);
        jObj.addProperty(KEY_SHOW_LIVE_SUBTITLES_FOLDER, false);
        jObj.addProperty(KEY_SHOW_MEDIA_LIBRARY_FOLDER, true);
        jObj.addProperty(KEY_SHOW_RECENTLY_PLAYED_FOLDER, true);
        jObj.addProperty(KEY_SHOW_SERVER_SETTINGS_FOLDER, false);
        jObj.addProperty(KEY_SHOW_SPLASH_SCREEN, true);
        jObj.addProperty(KEY_SHOW_TRANSCODE_FOLDER, true);
        jObj.addProperty(KEY_SHOW_USER_CHOICE, true);
        jObj.addProperty(KEY_SORT_METHOD, "0");
        jObj.addProperty(KEY_SUBS_INFO_LEVEL, "basic");
        jObj.addProperty(KEY_SUBTITLES_CODEPAGE, "");
        jObj.addProperty(KEY_SUBTITLES_LANGUAGES, Messages.getConfigurationString("SubtitlesLanguages"));
        jObj.addProperty(KEY_SUBS_COLOR, "0xFFFFFFFF");
        jObj.addProperty(KEY_SUBS_FONT, "");
        jObj.addProperty(KEY_ASS_MARGIN, 10);
        jObj.addProperty(KEY_ASS_SCALE, 1.4);
        jObj.addProperty(KEY_ASS_SHADOW, 1);
        jObj.addProperty(KEY_THUMBNAIL_SEEK_POS, 4);
        jObj.addProperty(KEY_TMDB_API_KEY, "");
        jObj.addProperty(KEY_UPNP_ENABLED, true);
        jObj.addProperty(KEY_UPNP_JUPNP_DIDL, false);
        jObj.addProperty(KEY_UPNP_LOG_LEVEL, "1");
        jObj.addProperty(KEY_USE_API_INFO, true);
        jObj.addProperty(KEY_USE_EMBEDDED_SUBTITLES_STYLE, true);
        jObj.addProperty(KEY_USE_TMDB_INFO, true);
        jObj.addProperty(KEY_USE_SYMLINKS_TARGET_FILE, true);
        jObj.addProperty(KEY_VLC_AUDIO_SYNC_ENABLED, false);
        jObj.addProperty(KEY_VLC_USE_EXPERIMENTAL_CODECS, false);
        jObj.addProperty(KEY_WEB_PLAYER_ENABLE, true);
        jObj.addProperty(KEY_WEB_GUI_ON_START, true);
        jObj.addProperty(KEY_WEB_GUI_PORT, 9001);
        jObj.addProperty(KEY_WEB_PLAYER_AUTH, false);
        jObj.addProperty(KEY_WEB_PLAYER_CONTROLS, true);
        jObj.addProperty(KEY_WEB_PLAYER_DOWNLOAD, true);
        jObj.addProperty(KEY_WEB_PLAYER_PORT, 9002);
        jObj.addProperty(KEY_X264_CONSTANT_RATE_FACTOR, "Automatic (Wired)");
        jObj.addProperty(KEY_3D_SUBTITLES_DEPTH, "0");
        return jObj;
    }

    static {
        String customProfilePath;
        LOGGER = LoggerFactory.getLogger(UmsConfiguration.class);
        enabledEnginesBuilt = false;
        ENABLED_ENGINES_LOCK = new ReentrantReadWriteLock();
        enginesPriorityBuilt = false;
        ENGINES_PRIORITY_LOCK = new ReentrantReadWriteLock();
        PROFILE_DIRECTORY_NAME = Build.getProfileDirectoryName();
        maxMaxMemoryBufferSize = 400;
        REFACTORED_KEYS = Map.ofEntries(new AbstractMap.SimpleEntry<String, String>("web_enable", KEY_WEB_PLAYER_ENABLE), new AbstractMap.SimpleEntry<String, String>("web_continue_audio", KEY_WEB_PLAYER_CONT_AUDIO), new AbstractMap.SimpleEntry<String, String>("web_continue_image", KEY_WEB_PLAYER_CONT_IMAGE), new AbstractMap.SimpleEntry<String, String>("web_continue_video", KEY_WEB_PLAYER_CONT_VIDEO), new AbstractMap.SimpleEntry<String, String>("web_https", KEY_WEB_PLAYER_HTTPS), new AbstractMap.SimpleEntry<String, String>("web_control", KEY_WEB_PLAYER_CONTROLLABLE), new AbstractMap.SimpleEntry<String, String>("web_image_show_delay", KEY_WEB_PLAYER_IMAGE_SLIDE), new AbstractMap.SimpleEntry<String, String>("web_loop_audio", KEY_WEB_PLAYER_LOOP_AUDIO), new AbstractMap.SimpleEntry<String, String>("web_loop_image", KEY_WEB_PLAYER_LOOP_IMAGE), new AbstractMap.SimpleEntry<String, String>("web_loop_video", KEY_WEB_PLAYER_LOOP_VIDEO), new AbstractMap.SimpleEntry<String, String>("fmpeg_sox", KEY_FFMPEG_SOX), new AbstractMap.SimpleEntry<String, String>("ALIVE_delay", KEY_UPNP_ALIVE_DELAY), new AbstractMap.SimpleEntry<String, String>("api_key", KEY_NEXTCP_API_KEY), new AbstractMap.SimpleEntry<String, String>("use_imdb_info", KEY_USE_API_INFO));
        REMOVED_KEYS = Set.of("alternativeffmpegpath", "buffer_max", "http_engine_v2", "hide_subs_info", "media_lib_sort", "no_shared", "plugin_purge", "proxy", "ip_filter", "web_transcode", "web_low_speed", "web_use_browser_lang", "web_authenticate", "allowed_bump_ips", "web_flash", "web_height", "web_size", "web_width", "bump.js", "bump.skin", "min_playtime_web", "bump", "shares", "server_engine");
        NEED_MEDIA_SERVER_RELOAD_FLAGS = Set.of(KEY_CHROMECAST_EXT, KEY_NETWORK_INTERFACE, KEY_SERVER_HOSTNAME, KEY_SERVER_PORT, KEY_UPNP_ENABLED);
        NEED_WEB_PLAYER_SERVER_RELOAD_FLAGS = Set.of(KEY_WEB_PLAYER_ENABLE, KEY_WEB_PLAYER_HTTPS, KEY_WEB_PLAYER_PORT);
        NEED_WEB_GUI_SERVER_RELOAD_FLAGS = Set.of(KEY_WEB_GUI_PORT);
        NEED_RENDERERS_RELOAD_FLAGS = Set.of(KEY_RENDERER_DEFAULT, KEY_RENDERER_FORCE_DEFAULT, KEY_SELECTED_RENDERERS);
        LANGUAGE_CHANGED = Set.of(KEY_LANGUAGE);
        NEED_RENDERERS_MEDIA_STORE_RELOAD_FLAGS = Set.of(KEY_ATZ_LIMIT, KEY_AUDIO_THUMBNAILS_METHOD, KEY_CHAPTER_SUPPORT, KEY_DISABLE_TRANSCODE_FOR_EXTENSIONS, KEY_DISABLE_TRANSCODING, KEY_FORCE_TRANSCODE_FOR_EXTENSIONS, KEY_FULLY_PLAYED_ACTION, KEY_HIDE_EMPTY_FOLDERS, KEY_OPEN_ARCHIVES, KEY_PRETTIFY_FILENAMES, KEY_SHOW_LIVE_SUBTITLES_FOLDER, KEY_SHOW_MEDIA_LIBRARY_FOLDER, KEY_SHOW_RECENTLY_PLAYED_FOLDER, KEY_SHOW_SERVER_SETTINGS_FOLDER, KEY_SHOW_TRANSCODE_FOLDER, KEY_SORT_METHOD);
        ARRAY_KEYS = Set.of(KEY_ENGINES, KEY_ENGINES_PRIORITY, KEY_SELECTED_RENDERERS);
        SELECT_KEYS = Set.of(KEY_AUDIO_THUMBNAILS_METHOD, KEY_FFMPEG_AVISYNTH_OUTPUT_FORMAT_3D, KEY_FFMPEG_AVISYNTH_CONVERSION_ALGORITHM_2D_TO_3D, KEY_FFMPEG_AVISYNTH_HORIZONTAL_RESIZE_RESOLUTION, KEY_SORT_METHOD, KEY_UPNP_LOG_LEVEL);
        VALID_EMPTY_KEYS = List.of(KEY_ALTERNATE_THUMB_FOLDER, KEY_SERVER_HOSTNAME, KEY_NETWORK_INTERFACE, KEY_SERVER_PORT, KEY_RENDERER_DEFAULT, KEY_WEB_GUI_PORT, KEY_WEB_PLAYER_PORT);
        int systemProfileType = 0;
        String systemProfileDirectoryPath = null;
        File systemConfigDirectory = new File(new File("").getAbsolutePath(), PORTABLE_PATH);
        if (systemConfigDirectory.exists() && systemConfigDirectory.isDirectory()) {
            systemProfileDirectoryPath = systemConfigDirectory.getAbsolutePath();
            systemProfileType = 2;
        } else if (Platform.isWindows()) {
            String programData = System.getenv("LOCALAPPDATA");
            if (programData != null) {
                systemProfileDirectoryPath = String.format("%s\\%s", programData, PROFILE_DIRECTORY_NAME);
                systemConfigDirectory = new File(systemProfileDirectoryPath);
                if (systemConfigDirectory.exists() && systemConfigDirectory.isDirectory()) {
                    systemProfileType = 1;
                } else {
                    systemProfileDirectoryPath = null;
                }
            }
            if (systemProfileDirectoryPath == null) {
                programData = System.getenv("ALLUSERSPROFILE");
                systemProfileDirectoryPath = programData != null ? String.format("%s\\%s", programData, PROFILE_DIRECTORY_NAME) : "";
                systemProfileType = 0;
            }
        } else if (Platform.isMac()) {
            systemProfileDirectoryPath = String.format("%s/%s/%s", System.getProperty("user.home"), "/Library/Application Support", PROFILE_DIRECTORY_NAME);
            systemProfileType = 1;
        } else {
            String xdgConfigHome = System.getenv("XDG_CONFIG_HOME");
            systemProfileDirectoryPath = xdgConfigHome == null ? String.format("%s/.config/%s", System.getProperty("user.home"), PROFILE_DIRECTORY_NAME) : String.format("%s/%s", xdgConfigHome, PROFILE_DIRECTORY_NAME);
            systemProfileType = 1;
        }
        systemConfigDirectory = new File(systemProfileDirectoryPath);
        if (!systemConfigDirectory.exists()) {
            systemConfigDirectory.mkdirs();
        }
        if (StringUtils.isBlank(customProfilePath = System.getProperty(PROPERTY_PROFILE_PATH))) {
            customProfilePath = System.getenv(ENV_PROFILE_PATH);
        }
        FileUtil.FileLocation profileLocation = FileUtil.getFileLocation(customProfilePath, systemProfileDirectoryPath, DEFAULT_PROFILE_FILENAME);
        PROFILE_PATH = profileLocation.getFilePath();
        PROFILE_DIRECTORY = profileLocation.getDirectoryPath();
        PROFILE_TYPE = profileLocation.isCustom() ? 3 : systemProfileType;
        PropertiesWrapper projectProperties = PropertiesUtil.getProjectProperties();
        if (projectProperties != null) {
            String skelDir = projectProperties.get("project.skelprofile.dir");
            SKEL_PROFILE_PATH = Platform.isLinux() && StringUtils.isNotBlank(skelDir) ? FilenameUtils.normalize(new File(new File(skelDir, PROFILE_DIRECTORY_NAME).getAbsolutePath(), DEFAULT_PROFILE_FILENAME).getAbsolutePath()) : null;
        } else {
            SKEL_PROFILE_PATH = null;
        }
        long usableMemory = Runtime.getRuntime().maxMemory() / 0x100000L - 368L;
        if (usableMemory > 400L) {
            maxMaxMemoryBufferSize = (int)usableMemory;
        }
        defaultAviSynthScript = "<movie>\n<sub>\n";
    }

    public static enum SubtitlesInfoLevel {
        NONE,
        BASIC,
        FULL;


        public String toString() {
            switch (this) {
                case BASIC: {
                    return "basic";
                }
                case FULL: {
                    return "full";
                }
                case NONE: {
                    return "none";
                }
            }
            throw new AssertionError((Object)("Missing implementation of SubtitlesInfoLevel \"" + this.name() + "\""));
        }

        public static SubtitlesInfoLevel typeOf(String infoLevelString) {
            if (StringUtils.isBlank(infoLevelString)) {
                return null;
            }
            return switch (infoLevelString = infoLevelString.trim().toLowerCase(Locale.ROOT)) {
                case "off", "none", "0" -> NONE;
                case "basic", "simple", "1" -> BASIC;
                case "full", "advanced", "2" -> FULL;
                default -> null;
            };
        }
    }
}

