/*
 * Decompiled with CFR 0.152.
 */
package net.pms.configuration;

import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.StringTokenizer;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.pms.PMS;
import net.pms.configuration.BaseConfiguration;
import net.pms.configuration.FormatConfiguration;
import net.pms.configuration.UmsConfiguration;
import net.pms.encoders.EncodingFormat;
import net.pms.formats.Format;
import net.pms.media.MediaInfo;
import net.pms.media.audio.MediaAudio;
import net.pms.media.subtitle.MediaSubtitle;
import net.pms.media.video.MediaVideo;
import net.pms.parsers.MediaInfoParser;
import net.pms.renderers.Renderer;
import net.pms.store.StoreItem;
import net.pms.store.StoreResource;
import net.pms.util.FileWatcher;
import net.pms.util.SortedHeaderMap;
import net.pms.util.StringUtil;
import org.apache.commons.configuration.ConfigurationException;
import org.apache.commons.configuration.PropertiesConfiguration;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang.WordUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RendererConfiguration
extends BaseConfiguration {
    private static final Logger LOGGER = LoggerFactory.getLogger(RendererConfiguration.class);
    private static final String KEY_ACCURATE_DLNA_ORGPN = "AccurateDLNAOrgPN";
    private static final String KEY_ALBUM_ART_PROFILE = "AlbumArtProfile";
    private static final String KEY_AUDIO = "Audio";
    protected static final String KEY_AUTO_PLAY_TMO = "AutoPlayTmo";
    private static final String KEY_AVISYNTH_2D_TO_3D = "AviSynth2Dto3D";
    private static final String KEY_BYTE_TO_TIMESEEK_REWIND_SECONDS = "ByteToTimeseekRewindSeconds";
    private static final String KEY_CBR_VIDEO_BITRATE = "CBRVideoBitrate";
    private static final String KEY_CHARMAP = "CharMap";
    private static final String KEY_CHUNKED_TRANSFER = "ChunkedTransfer";
    private static final String KEY_CUSTOM_FFMPEG_AUDIO_OPTIONS = "CustomFFmpegAudioOptions";
    private static final String KEY_CUSTOM_FFMPEG_OPTIONS = "CustomFFmpegOptions";
    private static final String KEY_CUSTOM_MENCODER_OPTIONS = "CustomMencoderOptions";
    private static final String KEY_CUSTOM_MENCODER_MPEG2_OPTIONS = "CustomMEncoderMPEG2Options";
    private static final String KEY_DEFAULT_VBV_BUFSIZE = "DefaultVBVBufSize";
    private static final String KEY_DEVICE_ID = "Device";
    private static final String KEY_DISABLE_MENCODER_NOSKIP = "DisableMencoderNoskip";
    private static final String KEY_DLNA_LOCALIZATION_REQUIRED = "DLNALocalizationRequired";
    private static final String KEY_DLNA_ORGPN_USE = "DLNAOrgPN";
    private static final String KEY_DLNA_PROFILE_CHANGES = "DLNAProfileChanges";
    private static final String KEY_DLNA_TREE_HACK = "CreateDLNATreeFaster";
    private static final String KEY_HALVE_BITRATE = "HalveBitrate";
    private static final String KEY_H264_LEVEL_LIMIT = "H264LevelLimit";
    private static final String KEY_H265_LEVEL_LIMIT = "H265LevelLimit";
    protected static final String KEY_HLS_MULTI_VIDEO_QUALITY = "HlsMultiVideoQuality";
    protected static final String KEY_HLS_VERSION = "HlsVersion";
    private static final String KEY_IGNORE_TRANSCODE_BYTE_RANGE_REQUEST = "IgnoreTranscodeByteRangeRequests";
    private static final String KEY_IMAGE = "Image";
    private static final String KEY_KEEP_ASPECT_RATIO = "KeepAspectRatio";
    private static final String KEY_KEEP_ASPECT_RATIO_TRANSCODING = "KeepAspectRatioTranscoding";
    protected static final String KEY_LIMIT_FOLDERS = "LimitFolders";
    private static final String KEY_LOADING_PRIORITY = "LoadingPriority";
    private static final String KEY_MAX_VIDEO_BITRATE = "MaxVideoBitrateMbps";
    private static final String KEY_MAX_VIDEO_HEIGHT = "MaxVideoHeight";
    private static final String KEY_MAX_VIDEO_WIDTH = "MaxVideoWidth";
    private static final String KEY_MAX_VOLUME = "MaxVolume";
    protected static final String KEY_MEDIAPARSERV2 = "MediaInfo";
    protected static final String KEY_MEDIAPARSERV2_THUMB = "MediaParserV2_ThumbnailGeneration";
    private static final String KEY_MIME_TYPES_CHANGES = "MimeTypesChanges";
    private static final String KEY_MUX_DTS_TO_MPEG = "MuxDTSToMpeg";
    private static final String KEY_MUX_LPCM_TO_MPEG = "MuxLPCMToMpeg";
    private static final String KEY_MUX_NON_MOD4_RESOLUTION = "MuxNonMod4Resolution";
    private static final String KEY_OFFER_SUBTITLES_BY_PROTOCOL_INFO = "OfferSubtitlesByProtocolInfo";
    private static final String KEY_OFFER_SUBTITLES_AS_SOURCE = "OfferSubtitlesAsSource";
    private static final String KEY_OUTPUT_3D_FORMAT = "Output3DFormat";
    private static final String KEY_OVERRIDE_FFMPEG_VF = "OverrideFFmpegVideoFilter";
    private static final String KEY_PREPEND_TRACK_NUMBERS = "PrependTrackNumbers";
    private static final String KEY_PUSH_METADATA = "PushMetadata";
    private static final String KEY_REMOVE_TAGS_FROM_SRT_SUBS = "RemoveTagsFromSRTSubtitles";
    private static final String KEY_RENDERER_ICON = "RendererIcon";
    private static final String KEY_RENDERER_ICON_OVERLAYS = "RendererIconOverlays";
    private static final String KEY_RENDERER_NAME = "RendererName";
    private static final String KEY_RESCALE_BY_RENDERER = "RescaleByRenderer";
    private static final String KEY_SEEK_BY_TIME = "SeekByTime";
    private static final String KEY_NEED_ALBUM_ART_HACK = "NeedAlbumArtHack";
    private static final String KEY_NEED_VERSIONED_OBJECT_ID = "NeedVersionedObjectId";
    private static final String KEY_SEND_DATE_METADATA = "SendDateMetadata";
    private static final String KEY_SEND_DATE_METADATA_YEAR_FOR_AUDIO_TAGS = "SendDateMetadataYearForAudioTags";
    private static final String KEY_SEND_DLNA_ORG_FLAGS = "SendDLNAOrgFlags";
    private static final String KEY_SEND_FOLDER_THUMBNAILS = "SendFolderThumbnails";
    private static final String KEY_SHOW_AUDIO_METADATA = "ShowAudioMetadata";
    private static final String KEY_SHOW_DVD_TITLE_DURATION = "ShowDVDTitleDuration";
    private static final String KEY_SHOW_SUB_METADATA = "ShowSubMetadata";
    private static final String KEY_STREAM_EXT = "StreamExtensions";
    private static final String KEY_STREAM_SUBS_FOR_TRANSCODED_VIDEO = "StreamSubsForTranscodedVideo";
    private static final String KEY_SUBTITLE_HTTP_HEADER = "SubtitleHttpHeader";
    protected static final String KEY_SUPPORTED = "Supported";
    private static final String KEY_SUPPORTED_VIDEO_BIT_DEPTHS = "SupportedVideoBitDepths";
    private static final String KEY_SUPPORTED_EXTERNAL_SUBTITLES_FORMATS = "SupportedExternalSubtitlesFormats";
    private static final String KEY_SUPPORTED_INTERNAL_SUBTITLES_FORMATS = "SupportedInternalSubtitlesFormats";
    private static final String KEY_TEXTWRAP = "TextWrap";
    private static final String KEY_THUMBNAIL_PADDING = "ThumbnailPadding";
    private static final String KEY_THUMBNAILS = "Thumbnails";
    protected static final String KEY_TRANSCODE_AUDIO = "TranscodeAudio";
    private static final String KEY_TRANSCODE_AUDIO_441KHZ = "TranscodeAudioTo441kHz";
    private static final String KEY_TRANSCODE_EXT = "TranscodeExtensions";
    private static final String KEY_TRANSCODE_FAST_START = "TranscodeFastStart";
    protected static final String KEY_TRANSCODE_VIDEO = "TranscodeVideo";
    private static final String KEY_TRANSCODED_SIZE = "TranscodedVideoFileSize";
    private static final String KEY_TRANSCODED_VIDEO_AUDIO_SAMPLE_RATE = "TranscodedVideoAudioSampleRate";
    private static final String KEY_UPNP_DETAILS = "UpnpDetailsSearch";
    protected static final String KEY_UPNP_ALLOW = "UpnpAllow";
    private static final String KEY_USER_AGENT = "UserAgentSearch";
    private static final String KEY_USER_AGENT_ADDITIONAL_HEADER = "UserAgentAdditionalHeader";
    private static final String KEY_USER_AGENT_ADDITIONAL_SEARCH = "UserAgentAdditionalHeaderSearch";
    private static final String KEY_USE_CLOSED_CAPTION = "UseClosedCaption";
    private static final String KEY_USE_SAME_EXTENSION = "UseSameExtension";
    private static final String KEY_VIDEO = "Video";
    private static final String KEY_WRAP_DTS_INTO_PCM = "WrapDTSIntoPCM";
    private static final String KEY_WRAP_ENCODED_AUDIO_INTO_PCM = "WrapEncodedAudioIntoPCM";
    private static final String KEY_DISABLE_UMS_RESUME = "DisableUmsResume";
    private static final String KEY_UPNP_ENABLE_SEARCHCAPS = "UpnpSearchCapsEnabled";
    public static final File NOFILE = new File("NOFILE");
    public static final String UNKNOWN_ICON = "unknown.png";
    protected Matcher sortedHeaderMatcher;
    protected UmsConfiguration umsConfiguration = PMS.getConfiguration();
    protected boolean loaded = false;
    private boolean fileless = false;
    private File file;
    private FormatConfiguration formatConfiguration;
    private List<String> identifiers = null;
    private Map<String, String> mimes;
    private Map<String, String> charMap;
    private Map<String, String> dlnaProfiles;
    private int lineWidth;
    private int lineHeight;
    private int indent;
    private String inset;
    private String dots;
    private static final FileWatcher.Listener RELOADER = (filename, event, watch, isDir) -> {
        RendererConfiguration r = (RendererConfiguration)watch.getItem();
        if (r != null && r.getFile().equals(new File(filename))) {
            r.reset();
        }
    };

    public RendererConfiguration() {
        super(false);
    }

    public RendererConfiguration(File f) throws ConfigurationException {
        super(false);
        this.umsConfiguration = PMS.getConfiguration();
        this.init(f);
    }

    public boolean isUpnpSearchCapsEnabled() {
        return this.getBoolean(KEY_UPNP_ENABLE_SEARCHCAPS, true);
    }

    public boolean isLoaded() {
        return this.loaded;
    }

    public FormatConfiguration getFormatConfiguration() {
        return this.formatConfiguration;
    }

    public UmsConfiguration getUmsConfiguration() {
        return this.umsConfiguration;
    }

    public File getFile() {
        return this.file;
    }

    public boolean isFileless() {
        return this.fileless;
    }

    public final void setFileless(boolean b) {
        this.fileless = b;
    }

    public boolean isXbox360() {
        return this.getConfName().toUpperCase().contains("XBOX 360");
    }

    public boolean isXboxOne() {
        return this.getConfName().toUpperCase().contains("XBOX ONE");
    }

    public boolean isXBMC() {
        return this.getConfName().toUpperCase().contains("KODI") || this.getConfName().toUpperCase().contains("XBMC");
    }

    public boolean isPS3() {
        return this.getConfName().toUpperCase().contains("PLAYSTATION 3") || this.getConfName().toUpperCase().contains("PS3");
    }

    public boolean isPS4() {
        return this.getConfName().toUpperCase().contains("PLAYSTATION 4");
    }

    public boolean isBRAVIA() {
        return this.getConfName().toUpperCase().contains("BRAVIA");
    }

    public boolean isFDSSDP() {
        return this.getConfName().toUpperCase().contains("FDSSDP");
    }

    public boolean isLG() {
        return this.getConfName().toUpperCase().contains("LG ");
    }

    public boolean isSamsung() {
        return this.getConfName().toUpperCase().contains("SAMSUNG");
    }

    public int getByteToTimeseekRewindSeconds() {
        return this.getInt(KEY_BYTE_TO_TIMESEEK_REWIND_SECONDS, 0);
    }

    public int getCBRVideoBitrate() {
        return this.getInt(KEY_CBR_VIDEO_BITRATE, 0);
    }

    public boolean isShowDVDTitleDuration() {
        return this.getBoolean(KEY_SHOW_DVD_TITLE_DURATION, false);
    }

    public boolean load(File f) throws ConfigurationException {
        if (f != null && !f.equals(NOFILE) && this.configuration instanceof PropertiesConfiguration) {
            ((PropertiesConfiguration)this.configuration).load(f);
            SortedHeaderMap searchMap = new SortedHeaderMap();
            searchMap.put("User-Agent", this.getUserAgent());
            searchMap.put(this.getUserAgentAdditionalHttpHeader(), this.getUserAgentAdditionalHttpHeaderSearch());
            String re = searchMap.toRegex();
            this.sortedHeaderMatcher = StringUtils.isNotBlank(re) ? Pattern.compile(re, 2).matcher("") : null;
            boolean addWatch = this.file != f;
            this.file = f;
            if (addWatch) {
                FileWatcher.add(new FileWatcher.Watch(this.getFile().getPath(), RELOADER, this));
            }
            return true;
        }
        return false;
    }

    public final void init(File f) throws ConfigurationException {
        if (!this.loaded) {
            this.configuration.clear();
            this.loaded = this.load(f);
        }
        this.mimes = new HashMap<String, String>();
        String mimeTypes = this.getString(KEY_MIME_TYPES_CHANGES, "");
        if (StringUtils.isNotBlank(mimeTypes)) {
            StringTokenizer st = new StringTokenizer(mimeTypes, "|");
            while (st.hasMoreTokens()) {
                String mimeChange = st.nextToken().trim();
                int equals = mimeChange.indexOf(61);
                if (equals <= -1) continue;
                String old = mimeChange.substring(0, equals).trim().toLowerCase();
                String nw = mimeChange.substring(equals + 1).trim().toLowerCase();
                this.mimes.put(old, nw);
            }
        }
        String s = this.getString(KEY_TEXTWRAP, "").toLowerCase();
        this.lineWidth = RendererConfiguration.getIntAt(s, "width:", 0);
        if (this.lineWidth > 0) {
            this.lineHeight = RendererConfiguration.getIntAt(s, "height:", 0);
            this.indent = RendererConfiguration.getIntAt(s, "indent:", 0);
            int whitespace = RendererConfiguration.getIntAt(s, "whitespace:", 9);
            int dotCount = RendererConfiguration.getIntAt(s, "dots:", 0);
            this.inset = StringUtil.fillString(whitespace, this.indent);
            this.dots = StringUtil.fillString(".", dotCount);
        }
        this.charMap = new HashMap<String, String>();
        String ch = this.getString(KEY_CHARMAP, null);
        if (StringUtils.isNotBlank(ch)) {
            StringTokenizer st = new StringTokenizer(ch, " ");
            String org = "";
            while (st.hasMoreTokens()) {
                String tok = st.nextToken().trim();
                if (StringUtils.isBlank(tok)) continue;
                tok = tok.replace("###0", " ").replace("###n", "\n").replace("###r", "\r");
                if (StringUtils.isBlank(org)) {
                    org = tok;
                    continue;
                }
                this.charMap.put(org, tok);
                org = "";
            }
        }
        this.dlnaProfiles = new HashMap<String, String>();
        String dlnaProfileChanges = this.getString(KEY_DLNA_PROFILE_CHANGES, "");
        if (StringUtils.isNotBlank(dlnaProfileChanges)) {
            LOGGER.trace("Config dlnaProfileChanges: " + dlnaProfileChanges);
            StringTokenizer st = new StringTokenizer(dlnaProfileChanges, "|");
            while (st.hasMoreTokens()) {
                String dLNAPNChange = st.nextToken().trim();
                int equals = dLNAPNChange.indexOf(61);
                if (equals <= -1) continue;
                String old = dLNAPNChange.substring(0, equals).trim().toUpperCase();
                String nw = dLNAPNChange.substring(equals + 1).trim().toUpperCase();
                this.dlnaProfiles.put(old, nw);
            }
        }
        if (f == null) {
            this.configuration.addProperty(KEY_MEDIAPARSERV2, true);
            this.configuration.addProperty(KEY_MEDIAPARSERV2_THUMB, true);
            this.configuration.addProperty(KEY_SUPPORTED, "f:.+");
        }
        if (this.isUseMediaInfo()) {
            this.formatConfiguration = new FormatConfiguration(this.configuration.getList(KEY_SUPPORTED));
        }
    }

    public void reset() {
        File f = this.getFile();
        try {
            LOGGER.info("Reloading renderer configuration: {}", (Object)f);
            this.loaded = false;
            this.init(f);
        }
        catch (ConfigurationException e) {
            LOGGER.debug("Error reloading renderer configuration {}: {}", (Object)f, (Object)e);
        }
    }

    public void resetLoaded() {
        this.loaded = false;
    }

    public String getDlnaProfileId(String profile) {
        if (this.dlnaProfiles.containsKey(profile)) {
            return this.dlnaProfiles.get(profile);
        }
        return profile;
    }

    public boolean supportsFormat(Format f) {
        return switch (f.getType()) {
            case 4 -> this.isVideoSupported();
            case 1 -> this.isAudioSupported();
            case 2 -> this.isImageSupported();
            default -> false;
        };
    }

    public boolean isVideoSupported() {
        return this.getBoolean(KEY_VIDEO, true);
    }

    public boolean isAudioSupported() {
        return this.getBoolean(KEY_AUDIO, true);
    }

    public boolean isImageSupported() {
        return this.getBoolean(KEY_IMAGE, true);
    }

    public List<EncodingFormat> getTranscodingFormats() {
        ArrayList<EncodingFormat> encodingFormats = new ArrayList<EncodingFormat>();
        encodingFormats.addAll(EncodingFormat.getVideoEncodingFormats(this.getVideoTranscode()));
        EncodingFormat audioFormat = EncodingFormat.getAudioEncodingFormat(this.getAudioTranscode());
        if (audioFormat != null) {
            encodingFormats.add(audioFormat);
        }
        return encodingFormats;
    }

    public boolean isTranscodeAudioTo441() {
        return this.getBoolean(KEY_TRANSCODE_AUDIO_441KHZ, false);
    }

    public double getH264LevelLimit() {
        return this.getDouble(KEY_H264_LEVEL_LIMIT, 4.1);
    }

    public double getH265LevelLimit() {
        return this.getDouble(KEY_H265_LEVEL_LIMIT, 4.1);
    }

    public boolean isTranscodeFastStart() {
        return this.getBoolean(KEY_TRANSCODE_FAST_START, false);
    }

    public boolean isDLNALocalizationRequired() {
        return this.getBoolean(KEY_DLNA_LOCALIZATION_REQUIRED, false);
    }

    public boolean isDisableMencoderNoskip() {
        return this.getBoolean(KEY_DISABLE_MENCODER_NOSKIP, false);
    }

    public boolean disableUmsResume() {
        return this.getBoolean(KEY_DISABLE_UMS_RESUME, false);
    }

    public boolean isVideoStreamTypeSupportedInTranscodingContainer(MediaInfo media, EncodingFormat encodingFormat, String transcodingContainerOverride) {
        if (media.getDefaultVideoTrack() == null) {
            return true;
        }
        if (this.getFormatConfiguration() == null) {
            return encodingFormat.isTranscodeToH264() && media.getDefaultVideoTrack().isH264() || encodingFormat.isTranscodeToH265() && media.getDefaultVideoTrack().isH265();
        }
        String transcodingContainer = transcodingContainerOverride != null ? transcodingContainerOverride : encodingFormat.getTranscodingContainer();
        return this.getFormatConfiguration().getMatchedMIMEtype(transcodingContainer, media.getDefaultVideoTrack().getCodec(), null) != null;
    }

    public boolean isAudioStreamTypeSupportedInTranscodingContainer(MediaAudio audio, EncodingFormat encodingFormat) {
        if (this.getFormatConfiguration() == null) {
            return encodingFormat.isTranscodeToAAC() && audio.isAACLC() || encodingFormat.isTranscodeToAC3() && audio.isAC3();
        }
        return this.getFormatConfiguration().getMatchedMIMEtype(encodingFormat.getTranscodingContainer(), null, audio.getCodec()) != null;
    }

    public Map<String, String> getMimeTranslations() {
        return this.mimes;
    }

    public boolean matchUPNPDetails(String details) {
        String upnpDetails = this.getUpnpDetailsString();
        if (StringUtils.isNotBlank(upnpDetails)) {
            String p = StringUtils.join((Object[])upnpDetails.split(" , "), ".*");
            Pattern pattern = Pattern.compile(p, 2);
            return pattern.matcher(details.replace("\n", " ")).find();
        }
        return false;
    }

    public String getUserAgent() {
        return this.getString(KEY_USER_AGENT, "");
    }

    public String getUpnpDetailsString() {
        return this.getString(KEY_UPNP_DETAILS, "");
    }

    public String getUpnpAllow() {
        return this.getString(KEY_UPNP_ALLOW, "true");
    }

    public void setUpnpAllow(String value) {
        this.configuration.setProperty(KEY_UPNP_ALLOW, value);
    }

    public int getMaxVideoBitrate() {
        return this.getInt(KEY_MAX_VIDEO_BITRATE, 0);
    }

    public String getRendererName() {
        return this.getConfName();
    }

    public String getSimpleName() {
        return StringUtils.substringBefore(this.getRendererName(), "(").trim();
    }

    public String getConfName() {
        return this.getString(KEY_RENDERER_NAME, "UnknownRenderer");
    }

    public String getRendererIcon() {
        return this.getString(KEY_RENDERER_ICON, UNKNOWN_ICON);
    }

    public String getRendererIconOverlays() {
        return this.getString(KEY_RENDERER_ICON_OVERLAYS, "");
    }

    public String getUserAgentAdditionalHttpHeader() {
        return this.getString(KEY_USER_AGENT_ADDITIONAL_HEADER, "");
    }

    public String getUserAgentAdditionalHttpHeaderSearch() {
        return this.getString(KEY_USER_AGENT_ADDITIONAL_SEARCH, "");
    }

    public String getUseSameExtension(String file) {
        String extension = this.getString(KEY_USE_SAME_EXTENSION, "");
        if (StringUtils.isNotEmpty(extension)) {
            file = (String)file + "." + extension;
        }
        return file;
    }

    private String getTranscodeSeekBy() {
        return this.getString(KEY_SEEK_BY_TIME, "false");
    }

    public boolean isTranscodeSeekByByteExclusive() {
        return this.getTranscodeSeekBy().equalsIgnoreCase("false");
    }

    public boolean isTranscodeSeekByBoth() {
        return this.getTranscodeSeekBy().equalsIgnoreCase("true");
    }

    public boolean isTranscodeSeekByTimeExclusive() {
        return this.getTranscodeSeekBy().equalsIgnoreCase("exclusive");
    }

    public boolean isTranscodeSeekByByte() {
        return this.isTranscodeSeekByByteExclusive() || this.isTranscodeSeekByBoth();
    }

    public boolean isTranscodeSeekByTime() {
        return this.isTranscodeSeekByTimeExclusive() || this.isTranscodeSeekByBoth();
    }

    public boolean isDTSPlayable() {
        return this.isMuxDTSToMpeg() || this.isWrapDTSIntoPCM() && this.isMuxLPCMToMpeg();
    }

    public boolean isMuxDTSToMpeg() {
        if (this.isUseMediaInfo()) {
            return this.getFormatConfiguration().isDTSSupported();
        }
        return this.getBoolean(KEY_MUX_DTS_TO_MPEG, false);
    }

    public boolean isWrapDTSIntoPCM() {
        return this.getBoolean(KEY_WRAP_DTS_INTO_PCM, false);
    }

    public boolean isWrapEncodedAudioIntoPCM() {
        return this.getBoolean(KEY_WRAP_ENCODED_AUDIO_INTO_PCM, false);
    }

    public boolean isLPCMPlayable() {
        return this.isMuxLPCMToMpeg();
    }

    public boolean isMuxLPCMToMpeg() {
        if (this.isUseMediaInfo()) {
            return this.getFormatConfiguration().isLPCMSupported();
        }
        return this.getBoolean(KEY_MUX_LPCM_TO_MPEG, true);
    }

    public boolean isMuxNonMod4Resolution() {
        return this.getBoolean(KEY_MUX_NON_MOD4_RESOLUTION, false);
    }

    public boolean isMpeg2Supported() {
        if (this.isUseMediaInfo()) {
            return this.getFormatConfiguration().isMpeg2Supported();
        }
        return this.isPS3();
    }

    public boolean isPushMetadata() {
        return this.getBoolean(KEY_PUSH_METADATA, true);
    }

    public List<String> getVideoTranscode() {
        return this.getStringList(KEY_TRANSCODE_VIDEO, "MPEGPS-MPEG2-AC3");
    }

    public String getAudioTranscode() {
        return this.getString(KEY_TRANSCODE_AUDIO, "LPCM");
    }

    public boolean isDefaultVBVSize() {
        return this.getBoolean(KEY_DEFAULT_VBV_BUFSIZE, false);
    }

    public boolean isHalveBitrate() {
        return this.getBoolean(KEY_HALVE_BITRATE, false);
    }

    public String getCustomMEncoderMPEG2Options() {
        String o = this.getString(KEY_CUSTOM_MENCODER_MPEG2_OPTIONS, "");
        if (StringUtils.isBlank(o)) {
            o = this.getString("CustomMencoderQualitySettings", "");
        }
        return o;
    }

    public String getCustomFFmpegMPEG2Options() {
        String mpegSettings = this.getCustomMEncoderMPEG2Options();
        if (StringUtils.isBlank(mpegSettings)) {
            return "";
        }
        return this.convertMencoderSettingToFFmpegFormat(mpegSettings);
    }

    public String getCustomMencoderOptions() {
        return this.getString(KEY_CUSTOM_MENCODER_OPTIONS, "");
    }

    public int getMaxVideoWidth() {
        return this.getInt(KEY_MAX_VIDEO_WIDTH, 1920);
    }

    public int getMaxVideoHeight() {
        return this.getInt(KEY_MAX_VIDEO_HEIGHT, 1080);
    }

    public boolean isMaximumResolutionSpecified() {
        return this.getMaxVideoWidth() > 0 && this.getMaxVideoHeight() > 0;
    }

    public boolean isResolutionCompatibleWithRenderer(int width, int height) {
        if (this.isMaximumResolutionSpecified() && (width > this.getMaxVideoWidth() || height > this.getMaxVideoHeight() && (this.getMaxVideoHeight() != 1080 || height != 1088))) {
            LOGGER.trace("Resolution {}x{} is too high for this renderer, which supports up to {}x{}", width, height, this.getMaxVideoWidth(), this.getMaxVideoHeight());
            return false;
        }
        if (!this.isRescaleByRenderer() && this.getMaxVideoWidth() < 720) {
            LOGGER.trace("Resolution {}x{} is too low for this renderer");
            return false;
        }
        return true;
    }

    public boolean isDLNAOrgPNUsed() {
        return this.getBoolean(KEY_DLNA_ORGPN_USE, true);
    }

    public boolean isSendDLNAOrgFlags() {
        return this.getBoolean(KEY_SEND_DLNA_ORG_FLAGS, true);
    }

    public boolean isAccurateDLNAOrgPN() {
        return this.getBoolean(KEY_ACCURATE_DLNA_ORGPN, false);
    }

    public String getTranscodedExtensions() {
        return this.getString(KEY_TRANSCODE_EXT, "");
    }

    public String getStreamedExtensions() {
        return this.getString(KEY_STREAM_EXT, "");
    }

    public long getTranscodedSize() {
        return this.getLong(KEY_TRANSCODED_SIZE, 0L);
    }

    public String getSubtitleHttpHeader() {
        return this.getString(KEY_SUBTITLE_HTTP_HEADER, "");
    }

    public String toString() {
        return this.getRendererName();
    }

    public boolean isUseMediaInfo() {
        return this.getBoolean(KEY_MEDIAPARSERV2, true) && MediaInfoParser.isValid();
    }

    public boolean isMediaInfoThumbnailGeneration() {
        return this.getBoolean(KEY_MEDIAPARSERV2_THUMB, false) && MediaInfoParser.isValid();
    }

    public boolean isShowAudioMetadata() {
        return this.getBoolean(KEY_SHOW_AUDIO_METADATA, true);
    }

    public boolean isShowSubMetadata() {
        return this.getBoolean(KEY_SHOW_SUB_METADATA, true);
    }

    public boolean needAlbumArtHack() {
        return this.getBoolean(KEY_NEED_ALBUM_ART_HACK, true);
    }

    public String getAlbumArtProfile() {
        return this.getString(KEY_ALBUM_ART_PROFILE, "");
    }

    public boolean needVersionedObjectId() {
        return this.getBoolean(KEY_NEED_VERSIONED_OBJECT_ID, false);
    }

    public boolean isSendDateMetadata() {
        return this.getBoolean(KEY_SEND_DATE_METADATA, true);
    }

    public boolean isSendDateMetadataYearForAudioTags() {
        return this.getBoolean(KEY_SEND_DATE_METADATA_YEAR_FOR_AUDIO_TAGS, false);
    }

    public boolean isSendFolderThumbnails() {
        return this.getBoolean(KEY_SEND_FOLDER_THUMBNAILS, true);
    }

    public boolean isDLNATreeHack() {
        return this.getBoolean(KEY_DLNA_TREE_HACK, false) && MediaInfoParser.isValid();
    }

    public boolean isChunkedTransfer() {
        return this.getBoolean(KEY_CHUNKED_TRANSFER, false);
    }

    public boolean isCompatible(StoreItem resource, Format format) {
        MediaInfo mediaInfo = resource != null ? resource.getMediaInfo() : null;
        if (this.umsConfiguration != null && (this.umsConfiguration.isDisableTranscoding() || format != null && format.skip(this.umsConfiguration.getDisableTranscodeForExtensions()))) {
            return true;
        }
        if (format != null && format.isImage()) {
            if (format.getIdentifier() == Format.Identifier.RAW || mediaInfo != null && mediaInfo.getImageInfo() != null && mediaInfo.getImageInfo().getFormat() != null && mediaInfo.getImageInfo().getFormat().isRaw()) {
                LOGGER.trace("RAW ({}) images are not supported for streaming", mediaInfo != null && mediaInfo.getImageInfo() != null && mediaInfo.getImageInfo().getFormat() != null ? mediaInfo.getImageInfo().getFormat() : format);
                return false;
            }
            if (mediaInfo != null && mediaInfo.getImageInfo() != null && mediaInfo.getImageInfo().isImageIOSupported()) {
                LOGGER.trace("Format \"{}\" will be subject to on-demand automatic transcoding with ImageIO", mediaInfo.getImageInfo().getFormat() != null ? mediaInfo.getImageInfo().getFormat() : format);
                return true;
            }
            LOGGER.trace("Format \"{}\" is not supported by ImageIO and will depend on a compatible transcoding engine", (Object)format);
            return false;
        }
        if (this.isUseMediaInfo() && mediaInfo != null && this.getFormatConfiguration().getMatchedMIMEtype(resource, this) != null) {
            return true;
        }
        return format != null && format.skip(this.getStreamedExtensions());
    }

    public int getAutoPlayTmo() {
        return this.getInt(KEY_AUTO_PLAY_TMO, 5000);
    }

    public String getCustomFFmpegAudioOptions() {
        return this.getString(KEY_CUSTOM_FFMPEG_AUDIO_OPTIONS, "");
    }

    public String getCustomFFmpegOptions() {
        return this.getString(KEY_CUSTOM_FFMPEG_OPTIONS, "");
    }

    public boolean isNoDynPlsFolder() {
        return false;
    }

    public boolean isKeepAspectRatio() {
        return this.getBoolean(KEY_KEEP_ASPECT_RATIO, false);
    }

    public boolean isKeepAspectRatioTranscoding() {
        return this.getBoolean(KEY_KEEP_ASPECT_RATIO_TRANSCODING, false);
    }

    public boolean isRescaleByRenderer() {
        return this.getBoolean(KEY_RESCALE_BY_RENDERER, true);
    }

    public boolean isPrependTrackNumbers() {
        return this.getBoolean(KEY_PREPEND_TRACK_NUMBERS, false);
    }

    public String getFFmpegVideoFilterOverride() {
        return this.getString(KEY_OVERRIDE_FFMPEG_VF, "");
    }

    public int getTranscodedVideoAudioSampleRate() {
        return this.getInt(KEY_TRANSCODED_VIDEO_AUDIO_SAMPLE_RATE, 48000);
    }

    public boolean isLimitFolders() {
        return this.getBoolean(KEY_LIMIT_FOLDERS, true);
    }

    public String getDcTitle(String name, String suffix, StoreResource resource) {
        int len = 0;
        if (suffix == null) {
            suffix = "";
        }
        if (this.lineWidth > 0 && ((String)name).length() + suffix.length() > this.lineWidth) {
            int suffixLength = this.dots.length() + suffix.length();
            if (this.lineHeight == 1) {
                len = this.lineWidth - suffixLength;
            } else {
                int i = resource.isFolder() ? 0 : this.indent;
                String newline = "\n" + (resource.isFolder() ? "" : this.inset);
                name = ((String)name).substring(0, i + (i < ((String)name).length() && Character.isWhitespace(((String)name).charAt(i)) ? 1 : 0)) + WordUtils.wrap(((String)name).substring(i) + suffix, this.lineWidth - i, newline, true);
                len = this.lineWidth * this.lineHeight;
                if (len != 0 && ((String)name).length() > len) {
                    len = ((String)name).substring(0, ((String)name).length() - this.lineWidth).lastIndexOf(newline) + newline.length();
                    name = ((String)name).substring(0, len) + ((String)name).substring(len, len + this.lineWidth).replace(newline, " ");
                    len += this.lineWidth - suffixLength - i;
                } else {
                    len = -1;
                }
            }
            if (len > 0) {
                name = ((String)name).substring(0, len).trim() + this.dots;
            }
        }
        if (len > -1 && StringUtils.isNotBlank(suffix)) {
            name = (String)name + " " + suffix;
        }
        for (Map.Entry<String, String> entry : this.charMap.entrySet()) {
            String repl = entry.getValue().replace("###e", "");
            name = ((String)name).replaceAll(entry.getKey(), repl);
        }
        return name;
    }

    public String getExternalSubtitlesFormatsSupportedForAllFiletypes() {
        return this.getString(KEY_SUPPORTED_EXTERNAL_SUBTITLES_FORMATS, "");
    }

    public String getSupportedEmbeddedSubtitles() {
        return this.getString(KEY_SUPPORTED_INTERNAL_SUBTITLES_FORMATS, "");
    }

    public boolean useClosedCaption() {
        return this.getBoolean(KEY_USE_CLOSED_CAPTION, false);
    }

    public boolean offerSubtitlesAsResource() {
        return this.getBoolean(KEY_OFFER_SUBTITLES_AS_SOURCE, true);
    }

    public boolean offerSubtitlesByProtocolInfo() {
        return this.getBoolean(KEY_OFFER_SUBTITLES_BY_PROTOCOL_INFO, true);
    }

    public boolean isSubtitlesStreamingSupportedForAllFiletypes() {
        return StringUtils.isNotBlank(this.getExternalSubtitlesFormatsSupportedForAllFiletypes());
    }

    public boolean isExternalSubtitlesFormatSupportedForAllFiletypes(String subtitlesFormat) {
        if (this.isSubtitlesStreamingSupportedForAllFiletypes()) {
            String[] supportedSubs;
            for (String supportedSub : supportedSubs = this.getExternalSubtitlesFormatsSupportedForAllFiletypes().split(",")) {
                if (!subtitlesFormat.equals(supportedSub.trim().toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isExternalSubtitlesFormatSupported(MediaSubtitle subtitle, StoreItem resource) {
        if (subtitle == null || subtitle.getType() == null || resource == null) {
            return false;
        }
        LOGGER.trace("Checking whether the external subtitles format " + subtitle.getType().toString() + " is supported by the renderer");
        return this.getFormatConfiguration().getMatchedMIMEtype(resource.getMediaInfo().getContainer(), null, null, 0, 0, 0, 0, 0, 0, 8, null, null, null, subtitle.getType().getShortName().toUpperCase(Locale.ROOT), true, this) != null;
    }

    public boolean isEmbeddedSubtitlesFormatSupportedForAllFiletypes(String subtitlesFormat) {
        if (this.isEmbeddedSubtitlesSupported()) {
            String[] supportedSubs;
            for (String supportedSub : supportedSubs = this.getSupportedEmbeddedSubtitles().split(",")) {
                if (!subtitlesFormat.equals(supportedSub.trim().toUpperCase())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isEmbeddedSubtitlesFormatSupported(MediaSubtitle subtitle, StoreItem resource) {
        if (subtitle == null) {
            return false;
        }
        LOGGER.trace("Checking whether the embedded subtitles format " + (subtitle.getType().toString() != null ? subtitle.getType().toString() : "null") + " is supported by the renderer");
        return this.getFormatConfiguration().getMatchedMIMEtype(resource, this) != null;
    }

    public boolean isEmbeddedSubtitlesSupported() {
        return StringUtils.isNotBlank(this.getSupportedEmbeddedSubtitles());
    }

    public String getOutput3DFormat() {
        String value = this.getString(KEY_OUTPUT_3D_FORMAT, "").toLowerCase(Locale.ROOT);
        if (StringUtils.isNotBlank(value)) {
            for (MediaVideo.Mode3D format : MediaVideo.Mode3D.values()) {
                if (!value.equals(format.toString().toLowerCase(Locale.ROOT))) continue;
                return value;
            }
            LOGGER.debug("The output 3D format `{}` specified in the `Output3DFormat` is not implemented or incorrectly specified.", (Object)value);
        }
        return "";
    }

    public boolean getAviSynth2Dto3D() {
        return this.getBoolean(KEY_AVISYNTH_2D_TO_3D, false);
    }

    public boolean ignoreTranscodeByteRangeRequests() {
        return this.getBoolean(KEY_IGNORE_TRANSCODE_BYTE_RANGE_REQUEST, false);
    }

    public boolean match(SortedHeaderMap headers) {
        if (headers != null && !headers.isEmpty() && this.sortedHeaderMatcher != null) {
            try {
                return this.sortedHeaderMatcher.reset(headers.joined()).find();
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public int getLoadingPriority() {
        return this.getInt(KEY_LOADING_PRIORITY, 0);
    }

    public String getSubLanguage() {
        return this.umsConfiguration.getSubtitlesLanguages();
    }

    public int getMaxVolume() {
        return this.getInt(KEY_MAX_VOLUME, 100);
    }

    public void setIdentifiers(List<String> identifiers) {
        this.identifiers = identifiers;
    }

    public List<String> getIdentifiers() {
        return this.identifiers;
    }

    public boolean hasDeviceId() {
        return this.configuration.containsKey(KEY_DEVICE_ID) || this.configuration.containsKey("device");
    }

    public String getDeviceId() {
        String d = this.getString(KEY_DEVICE_ID, "");
        if (StringUtils.isBlank(d)) {
            d = this.getString("device", "");
        }
        return d;
    }

    public boolean isThumbnails() {
        return this.getBoolean(KEY_THUMBNAILS, true);
    }

    public boolean isThumbnailPadding() {
        return this.getBoolean(KEY_THUMBNAIL_PADDING, false);
    }

    public boolean streamSubsForTranscodedVideo() {
        return this.getBoolean(KEY_STREAM_SUBS_FOR_TRANSCODED_VIDEO, false);
    }

    public String getSupportedVideoBitDepths() {
        return this.getString(KEY_SUPPORTED_VIDEO_BIT_DEPTHS, "8");
    }

    public boolean isVideoBitDepthSupported(StoreItem resource) {
        Object videoBitDepth = null;
        if (resource.getMediaInfo() != null && resource.getMediaInfo().getDefaultVideoTrack() != null) {
            videoBitDepth = resource.getMediaInfo().getDefaultVideoTrack().getBitDepth();
        }
        if (videoBitDepth != null) {
            String[] supportedBitDepths;
            for (String supportedBitDepth : supportedBitDepths = this.getSupportedVideoBitDepths().split(",")) {
                if (!Objects.equals(Integer.valueOf(supportedBitDepth.trim()), videoBitDepth)) continue;
                return true;
            }
        }
        LOGGER.trace("Checking whether the video bit depth " + (Serializable)(videoBitDepth != null ? videoBitDepth : "null") + " matches any 'vbd' entries in the 'Supported' lines");
        return this.getFormatConfiguration().getMatchedMIMEtype(resource, this) != null;
    }

    public boolean isVideoBitDepthSupportedForAllFiletypes(Integer videoBitDepth) {
        if (videoBitDepth != null) {
            String[] supportedBitDepths;
            for (String supportedBitDepth : supportedBitDepths = this.getSupportedVideoBitDepths().split(",")) {
                if (!Objects.equals(Integer.valueOf(supportedBitDepth.trim()), videoBitDepth)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean isRemoveTagsFromSRTsubs() {
        return this.getBoolean(KEY_REMOVE_TAGS_FROM_SRT_SUBS, true);
    }

    public int getHlsVersion() {
        return this.getInt(KEY_HLS_VERSION, 3);
    }

    public boolean getHlsMultiVideoQuality() {
        return this.getBoolean(KEY_HLS_MULTI_VIDEO_QUALITY, false);
    }

    protected static int[] getVideoBitrateConfig(String bitrate) {
        int[] bitrates = new int[2];
        if (bitrate.contains("(") && bitrate.contains(")")) {
            bitrates[1] = Integer.parseInt(bitrate.substring(bitrate.indexOf(40) + 1, bitrate.indexOf(41)));
        }
        if (bitrate.contains("(")) {
            bitrate = bitrate.substring(0, bitrate.indexOf(40)).trim();
        }
        if (StringUtils.isBlank(bitrate)) {
            bitrate = "0";
        }
        bitrates[0] = (int)Double.parseDouble(bitrate);
        return bitrates;
    }

    private static int getIntAt(String s, String key, int fallback) {
        if (StringUtils.isBlank(s) || StringUtils.isBlank(key)) {
            return fallback;
        }
        try {
            return Integer.parseInt((s + " ").split(key)[1].split("\\D")[0]);
        }
        catch (ArrayIndexOutOfBoundsException | NumberFormatException e) {
            return fallback;
        }
    }

    public static List<String> getRendererLines(Renderer renderer, File refFile) {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            String name = renderer.getSimpleName();
            Map<String, String> details = renderer.getUpnpDetails();
            List<String> headers = renderer.getIdentifiers();
            boolean hasRef = refFile != null && refFile != NOFILE;
            lines.add("#----------------------------------------------------------------------------");
            lines.add("# Auto-generated profile for " + name);
            lines.add("#" + (String)(refFile != null && refFile != NOFILE ? " Based on " + refFile.getName() : ""));
            lines.add("# See DefaultRenderer.conf for a description of all possible configuration options.");
            lines.add("#");
            lines.add("");
            lines.add("RendererName = " + name);
            if (headers != null || details != null) {
                lines.add("");
                lines.add("# ============================================================================");
                lines.add("# This renderer has sent the following string/s:");
                if (headers != null && !headers.isEmpty()) {
                    lines.add("#");
                    for (String h : headers) {
                        lines.add("# " + h);
                    }
                }
                if (details != null) {
                    details.remove("address");
                    details.remove("udn");
                    lines.add("#");
                    lines.add("# " + details);
                }
                lines.add("# ============================================================================");
                lines.add("");
            }
            lines.add("UserAgentSearch = ");
            if (headers != null && headers.size() > 1) {
                lines.add("UserAgentAdditionalHeader = ");
                lines.add("UserAgentAdditionalHeaderSearch = ");
            }
            if (details != null) {
                lines.add("UpnpDetailsSearch = " + details.get("manufacturer") + " , " + details.get("modelName"));
            }
            lines.add("");
            if (hasRef) {
                Matcher skip = Pattern.compile(".*(RendererIcon|RendererName|UpnpDetailsSearch|UserAgentSearch|UserAgentAdditionalHeader|UserAgentAdditionalHeaderSearch).*").matcher("");
                boolean header = true;
                for (String line : FileUtils.readLines(refFile, StandardCharsets.UTF_8)) {
                    if (skip.reset(line).matches() || header && (line.startsWith("#") || StringUtils.isBlank(line))) continue;
                    header = false;
                    lines.add(line);
                }
            }
        }
        catch (IOException ie) {
            LOGGER.debug("Error creating renderer configuration file: " + ie);
        }
        return lines;
    }

    public static List<String> getDeviceLines(Renderer renderer) {
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("#----------------------------------------------------------------------------");
        lines.add("# Custom Device profile");
        lines.add("# See DefaultRenderer.conf for descriptions of all possible renderer options");
        lines.add("# and UMS.conf for program options.");
        lines.add("");
        lines.add("# Options in this file override the default settings for the specific " + renderer.getSimpleName() + " device(s) listed below.");
        lines.add("# Specify devices by uuid (or address if no uuid), separated by commas if more than one.");
        lines.add("");
        lines.add("Device = " + renderer.getId());
        return lines;
    }
}

